/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pools;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WindowInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MAX_POOL_SIZE = 10;
    private static Pools.SynchronizedPool<WindowInfo> sPool;
    public int type;
    public int layer;
    public IBinder token;
    public IBinder parentToken;
    public boolean focused;
    public Rect boundsInScreen;
    public List<IBinder> childTokens;
    public CharSequence title;
    public int accessibilityIdOfAnchor;
    public boolean inPictureInPicture;
    public static Parcelable.Creator<WindowInfo> CREATOR;

    private void $$robo$$android_view_WindowInfo$__constructor__() {
        this.boundsInScreen = new Rect();
        this.accessibilityIdOfAnchor = -1;
    }

    private static final WindowInfo $$robo$$android_view_WindowInfo$obtain() {
        WindowInfo window = sPool.acquire();
        if (window == null) {
            window = new WindowInfo();
        }
        return window;
    }

    private static final WindowInfo $$robo$$android_view_WindowInfo$obtain(WindowInfo other) {
        WindowInfo window = WindowInfo.obtain();
        window.type = other.type;
        window.layer = other.layer;
        window.token = other.token;
        window.parentToken = other.parentToken;
        window.focused = other.focused;
        window.boundsInScreen.set(other.boundsInScreen);
        window.title = other.title;
        window.accessibilityIdOfAnchor = other.accessibilityIdOfAnchor;
        window.inPictureInPicture = other.inPictureInPicture;
        if (other.childTokens != null && !other.childTokens.isEmpty()) {
            if (window.childTokens == null) {
                window.childTokens = new ArrayList<IBinder>(other.childTokens);
            } else {
                window.childTokens.addAll(other.childTokens);
            }
        }
        return window;
    }

    private final void $$robo$$android_view_WindowInfo$recycle() {
        this.clear();
        sPool.release(this);
    }

    private final int $$robo$$android_view_WindowInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_WindowInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.type);
        parcel.writeInt(this.layer);
        parcel.writeStrongBinder(this.token);
        parcel.writeStrongBinder(this.parentToken);
        parcel.writeInt(this.focused ? 1 : 0);
        this.boundsInScreen.writeToParcel(parcel, flags);
        parcel.writeCharSequence(this.title);
        parcel.writeInt(this.accessibilityIdOfAnchor);
        parcel.writeInt(this.inPictureInPicture ? 1 : 0);
        if (this.childTokens != null && !this.childTokens.isEmpty()) {
            parcel.writeInt(1);
            parcel.writeBinderList(this.childTokens);
        } else {
            parcel.writeInt(0);
        }
    }

    private final String $$robo$$android_view_WindowInfo$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WindowInfo[");
        builder.append("title=").append(this.title);
        builder.append(", type=").append(this.type);
        builder.append(", layer=").append(this.layer);
        builder.append(", token=").append(this.token);
        builder.append(", bounds=").append(this.boundsInScreen);
        builder.append(", parent=").append(this.parentToken);
        builder.append(", focused=").append(this.focused);
        builder.append(", children=").append(this.childTokens);
        builder.append(", accessibility anchor=").append(this.accessibilityIdOfAnchor);
        builder.append(']');
        return builder.toString();
    }

    private final void $$robo$$android_view_WindowInfo$initFromParcel(Parcel parcel) {
        boolean hasChildren;
        this.type = parcel.readInt();
        this.layer = parcel.readInt();
        this.token = parcel.readStrongBinder();
        this.parentToken = parcel.readStrongBinder();
        this.focused = parcel.readInt() == 1;
        this.boundsInScreen.readFromParcel(parcel);
        this.title = parcel.readCharSequence();
        this.accessibilityIdOfAnchor = parcel.readInt();
        this.inPictureInPicture = parcel.readInt() == 1;
        boolean bl = hasChildren = parcel.readInt() == 1;
        if (hasChildren) {
            if (this.childTokens == null) {
                this.childTokens = new ArrayList<IBinder>();
            }
            parcel.readBinderList(this.childTokens);
        }
    }

    private final void $$robo$$android_view_WindowInfo$clear() {
        this.type = 0;
        this.layer = 0;
        this.token = null;
        this.parentToken = null;
        this.focused = false;
        this.boundsInScreen.setEmpty();
        if (this.childTokens != null) {
            this.childTokens.clear();
        }
        this.inPictureInPicture = false;
    }

    static void __staticInitializer__() {
        sPool = new Pools.SynchronizedPool(10);
        CREATOR = new Parcelable.Creator<WindowInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_WindowInfo_1$__constructor__() {
            }

            private final WindowInfo $$robo$$android_view_WindowInfo_1$createFromParcel(Parcel parcel) {
                WindowInfo window = WindowInfo.obtain();
                window.initFromParcel(parcel);
                return window;
            }

            private final WindowInfo[] $$robo$$android_view_WindowInfo_1$newArray(int size) {
                return new WindowInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_WindowInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowInfo_1$__constructor__(), this);
            }

            @Override
            public WindowInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_WindowInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WindowInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_WindowInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_view_WindowInfo$__constructor__();
    }

    public WindowInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowInfo$__constructor__(), this);
    }

    public static WindowInfo obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_WindowInfo$obtain());
    }

    public static WindowInfo obtain(WindowInfo windowInfo) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_WindowInfo$obtain(android.view.WindowInfo ), (WindowInfo)windowInfo);
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_WindowInfo$recycle(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_WindowInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_WindowInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_WindowInfo$toString(), this);
    }

    private void initFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("initFromParcel", $$robo$$android_view_WindowInfo$initFromParcel(android.os.Parcel ), this, parcel);
    }

    private void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_WindowInfo$clear(), this);
    }

    static {
        RobolectricInternals.classInitializing(WindowInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WindowInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

