/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.InputEventConsistencyVerifier;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GestureDetector
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int mTouchSlopSquare;
    private int mDoubleTapTouchSlopSquare;
    private int mDoubleTapSlopSquare;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private static int LONGPRESS_TIMEOUT;
    private static int TAP_TIMEOUT;
    private static int DOUBLE_TAP_TIMEOUT;
    private static int DOUBLE_TAP_MIN_TIME;
    private static int SHOW_PRESS = 1;
    private static int LONG_PRESS = 2;
    private static int TAP = 3;
    private Handler mHandler;
    private OnGestureListener mListener;
    private OnDoubleTapListener mDoubleTapListener;
    private OnContextClickListener mContextClickListener;
    private boolean mStillDown;
    private boolean mDeferConfirmSingleTap;
    private boolean mInLongPress;
    private boolean mInContextClick;
    private boolean mAlwaysInTapRegion;
    private boolean mAlwaysInBiggerTapRegion;
    private boolean mIgnoreNextUpEvent;
    private MotionEvent mCurrentDownEvent;
    private MotionEvent mPreviousUpEvent;
    private boolean mIsDoubleTapping;
    private float mLastFocusX;
    private float mLastFocusY;
    private float mDownFocusX;
    private float mDownFocusY;
    private boolean mIsLongpressEnabled;
    private VelocityTracker mVelocityTracker;
    private InputEventConsistencyVerifier mInputEventConsistencyVerifier;

    @Deprecated
    private void $$robo$$android_view_GestureDetector$__constructor__(OnGestureListener listener, Handler handler) {
    }

    @Deprecated
    private void $$robo$$android_view_GestureDetector$__constructor__(OnGestureListener listener) {
    }

    private void $$robo$$android_view_GestureDetector$__constructor__(Context context, OnGestureListener listener) {
    }

    private void $$robo$$android_view_GestureDetector$__constructor__(Context context, OnGestureListener listener, Handler handler) {
        this.mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
        this.mHandler = handler != null ? new GestureHandler(this, handler) : new GestureHandler(this);
        this.mListener = listener;
        if (listener instanceof OnDoubleTapListener) {
            this.setOnDoubleTapListener((OnDoubleTapListener)((Object)listener));
        }
        if (listener instanceof OnContextClickListener) {
            this.setContextClickListener((OnContextClickListener)((Object)listener));
        }
        this.init(context);
    }

    private void $$robo$$android_view_GestureDetector$__constructor__(Context context, OnGestureListener listener, Handler handler, boolean unused) {
    }

    private final void $$robo$$android_view_GestureDetector$init(Context context) {
        int doubleTapSlop;
        int doubleTapTouchSlop;
        int touchSlop;
        if (this.mListener == null) {
            throw new NullPointerException("OnGestureListener must not be null");
        }
        this.mIsLongpressEnabled = true;
        if (context == null) {
            doubleTapTouchSlop = touchSlop = ViewConfiguration.getTouchSlop();
            doubleTapSlop = ViewConfiguration.getDoubleTapSlop();
            this.mMinimumFlingVelocity = ViewConfiguration.getMinimumFlingVelocity();
            this.mMaximumFlingVelocity = ViewConfiguration.getMaximumFlingVelocity();
        } else {
            ViewConfiguration configuration = ViewConfiguration.get(context);
            touchSlop = configuration.getScaledTouchSlop();
            doubleTapTouchSlop = configuration.getScaledDoubleTapTouchSlop();
            doubleTapSlop = configuration.getScaledDoubleTapSlop();
            this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
            this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        }
        this.mTouchSlopSquare = touchSlop * touchSlop;
        this.mDoubleTapTouchSlopSquare = doubleTapTouchSlop * doubleTapTouchSlop;
        this.mDoubleTapSlopSquare = doubleTapSlop * doubleTapSlop;
    }

    private final void $$robo$$android_view_GestureDetector$setOnDoubleTapListener(OnDoubleTapListener onDoubleTapListener) {
        this.mDoubleTapListener = onDoubleTapListener;
    }

    private final void $$robo$$android_view_GestureDetector$setContextClickListener(OnContextClickListener onContextClickListener) {
        this.mContextClickListener = onContextClickListener;
    }

    private final void $$robo$$android_view_GestureDetector$setIsLongpressEnabled(boolean isLongpressEnabled) {
        this.mIsLongpressEnabled = isLongpressEnabled;
    }

    private final boolean $$robo$$android_view_GestureDetector$isLongpressEnabled() {
        return this.mIsLongpressEnabled;
    }

    private final boolean $$robo$$android_view_GestureDetector$onTouchEvent(MotionEvent ev) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(ev, 0);
        }
        int action = ev.getAction();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        boolean pointerUp = (action & 0xFF) == 6;
        int skipIndex = pointerUp ? ev.getActionIndex() : -1;
        boolean isGeneratedGesture = (ev.getFlags() & 8) != 0;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = ev.getPointerCount();
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += ev.getX(i);
            sumY += ev.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float focusX = sumX / (float)div;
        float focusY = sumY / (float)div;
        boolean handled = false;
        block0 : switch (action & 0xFF) {
            case 5: {
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                this.cancelTaps();
                break;
            }
            case 6: {
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                int upIndex = ev.getActionIndex();
                int id1 = ev.getPointerId(upIndex);
                float x1 = this.mVelocityTracker.getXVelocity(id1);
                float y1 = this.mVelocityTracker.getYVelocity(id1);
                for (int i = 0; i < count; ++i) {
                    float y;
                    int id2;
                    float x;
                    float dot;
                    if (i == upIndex || !((dot = (x = x1 * this.mVelocityTracker.getXVelocity(id2 = ev.getPointerId(i))) + (y = y1 * this.mVelocityTracker.getYVelocity(id2))) < 0.0f)) continue;
                    this.mVelocityTracker.clear();
                    break block0;
                }
                break;
            }
            case 0: {
                if (this.mDoubleTapListener != null) {
                    boolean hadTapMessage = this.mHandler.hasMessages(3);
                    if (hadTapMessage) {
                        this.mHandler.removeMessages(3);
                    }
                    if (this.mCurrentDownEvent != null && this.mPreviousUpEvent != null && hadTapMessage && this.isConsideredDoubleTap(this.mCurrentDownEvent, this.mPreviousUpEvent, ev)) {
                        this.mIsDoubleTapping = true;
                        handled |= this.mDoubleTapListener.onDoubleTap(this.mCurrentDownEvent);
                        handled |= this.mDoubleTapListener.onDoubleTapEvent(ev);
                    } else {
                        this.mHandler.sendEmptyMessageDelayed(3, DOUBLE_TAP_TIMEOUT);
                    }
                }
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                if (this.mCurrentDownEvent != null) {
                    this.mCurrentDownEvent.recycle();
                }
                this.mCurrentDownEvent = MotionEvent.obtain(ev);
                this.mAlwaysInTapRegion = true;
                this.mAlwaysInBiggerTapRegion = true;
                this.mStillDown = true;
                this.mInLongPress = false;
                this.mDeferConfirmSingleTap = false;
                if (this.mIsLongpressEnabled) {
                    this.mHandler.removeMessages(2);
                    this.mHandler.sendEmptyMessageAtTime(2, this.mCurrentDownEvent.getDownTime() + (long)LONGPRESS_TIMEOUT);
                }
                this.mHandler.sendEmptyMessageAtTime(1, this.mCurrentDownEvent.getDownTime() + (long)TAP_TIMEOUT);
                handled |= this.mListener.onDown(ev);
                break;
            }
            case 2: {
                if (this.mInLongPress || this.mInContextClick) break;
                float scrollX = this.mLastFocusX - focusX;
                float scrollY = this.mLastFocusY - focusY;
                if (this.mIsDoubleTapping) {
                    handled |= this.mDoubleTapListener.onDoubleTapEvent(ev);
                    break;
                }
                if (this.mAlwaysInTapRegion) {
                    int doubleTapSlopSquare;
                    int slopSquare;
                    int deltaX = (int)(focusX - this.mDownFocusX);
                    int deltaY = (int)(focusY - this.mDownFocusY);
                    int distance = deltaX * deltaX + deltaY * deltaY;
                    int n = slopSquare = isGeneratedGesture ? 0 : this.mTouchSlopSquare;
                    if (distance > slopSquare) {
                        handled = this.mListener.onScroll(this.mCurrentDownEvent, ev, scrollX, scrollY);
                        this.mLastFocusX = focusX;
                        this.mLastFocusY = focusY;
                        this.mAlwaysInTapRegion = false;
                        this.mHandler.removeMessages(3);
                        this.mHandler.removeMessages(1);
                        this.mHandler.removeMessages(2);
                    }
                    int n2 = doubleTapSlopSquare = isGeneratedGesture ? 0 : this.mDoubleTapTouchSlopSquare;
                    if (distance <= doubleTapSlopSquare) break;
                    this.mAlwaysInBiggerTapRegion = false;
                    break;
                }
                if (!(Math.abs(scrollX) >= 1.0f) && !(Math.abs(scrollY) >= 1.0f)) break;
                handled = this.mListener.onScroll(this.mCurrentDownEvent, ev, scrollX, scrollY);
                this.mLastFocusX = focusX;
                this.mLastFocusY = focusY;
                break;
            }
            case 1: {
                this.mStillDown = false;
                MotionEvent currentUpEvent = MotionEvent.obtain(ev);
                if (this.mIsDoubleTapping) {
                    handled |= this.mDoubleTapListener.onDoubleTapEvent(ev);
                } else if (this.mInLongPress) {
                    this.mHandler.removeMessages(3);
                    this.mInLongPress = false;
                } else if (this.mAlwaysInTapRegion && !this.mIgnoreNextUpEvent) {
                    handled = this.mListener.onSingleTapUp(ev);
                    if (this.mDeferConfirmSingleTap && this.mDoubleTapListener != null) {
                        this.mDoubleTapListener.onSingleTapConfirmed(ev);
                    }
                } else if (!this.mIgnoreNextUpEvent) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    int pointerId = ev.getPointerId(0);
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                    float velocityY = velocityTracker.getYVelocity(pointerId);
                    float velocityX = velocityTracker.getXVelocity(pointerId);
                    if (Math.abs(velocityY) > (float)this.mMinimumFlingVelocity || Math.abs(velocityX) > (float)this.mMinimumFlingVelocity) {
                        handled = this.mListener.onFling(this.mCurrentDownEvent, ev, velocityX, velocityY);
                    }
                }
                if (this.mPreviousUpEvent != null) {
                    this.mPreviousUpEvent.recycle();
                }
                this.mPreviousUpEvent = currentUpEvent;
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mIsDoubleTapping = false;
                this.mDeferConfirmSingleTap = false;
                this.mIgnoreNextUpEvent = false;
                this.mHandler.removeMessages(1);
                this.mHandler.removeMessages(2);
                break;
            }
            case 3: {
                this.cancel();
            }
        }
        if (!handled && this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(ev, 0);
        }
        return handled;
    }

    private final boolean $$robo$$android_view_GestureDetector$onGenericMotionEvent(MotionEvent ev) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onGenericMotionEvent(ev, 0);
        }
        int actionButton = ev.getActionButton();
        switch (ev.getActionMasked()) {
            case 11: {
                if (this.mContextClickListener == null || this.mInContextClick || this.mInLongPress || actionButton != 32 && actionButton != 2 || !this.mContextClickListener.onContextClick(ev)) break;
                this.mInContextClick = true;
                this.mHandler.removeMessages(2);
                this.mHandler.removeMessages(3);
                return true;
            }
            case 12: {
                if (!this.mInContextClick || actionButton != 32 && actionButton != 2) break;
                this.mInContextClick = false;
                this.mIgnoreNextUpEvent = true;
            }
        }
        return false;
    }

    private final void $$robo$$android_view_GestureDetector$cancel() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.mIsDoubleTapping = false;
        this.mStillDown = false;
        this.mAlwaysInTapRegion = false;
        this.mAlwaysInBiggerTapRegion = false;
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = false;
        this.mInContextClick = false;
        this.mIgnoreNextUpEvent = false;
    }

    private final void $$robo$$android_view_GestureDetector$cancelTaps() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        this.mIsDoubleTapping = false;
        this.mAlwaysInTapRegion = false;
        this.mAlwaysInBiggerTapRegion = false;
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = false;
        this.mInContextClick = false;
        this.mIgnoreNextUpEvent = false;
    }

    private final boolean $$robo$$android_view_GestureDetector$isConsideredDoubleTap(MotionEvent firstDown, MotionEvent firstUp, MotionEvent secondDown) {
        if (!this.mAlwaysInBiggerTapRegion) {
            return false;
        }
        long deltaTime = secondDown.getEventTime() - firstUp.getEventTime();
        if (deltaTime > (long)DOUBLE_TAP_TIMEOUT || deltaTime < (long)DOUBLE_TAP_MIN_TIME) {
            return false;
        }
        int deltaX = (int)firstDown.getX() - (int)secondDown.getX();
        int deltaY = (int)firstDown.getY() - (int)secondDown.getY();
        boolean isGeneratedGesture = (firstDown.getFlags() & 8) != 0;
        int slopSquare = isGeneratedGesture ? 0 : this.mDoubleTapSlopSquare;
        return deltaX * deltaX + deltaY * deltaY < slopSquare;
    }

    private final void $$robo$$android_view_GestureDetector$dispatchLongPress() {
        this.mHandler.removeMessages(3);
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = true;
        this.mListener.onLongPress(this.mCurrentDownEvent);
    }

    static void __staticInitializer__() {
        LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
        TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
        DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
        DOUBLE_TAP_MIN_TIME = ViewConfiguration.getDoubleTapMinTime();
    }

    private void __constructor__(OnGestureListener onGestureListener, Handler handler) {
        this.$$robo$$android_view_GestureDetector$__constructor__(onGestureListener, handler);
    }

    public GestureDetector(OnGestureListener onGestureListener, Handler handler) {
        this(null, onGestureListener, handler);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GestureDetector$__constructor__(android.view.GestureDetector$OnGestureListener android.os.Handler ), this, onGestureListener, handler);
    }

    private void __constructor__(OnGestureListener onGestureListener) {
        this.$$robo$$android_view_GestureDetector$__constructor__(onGestureListener);
    }

    public GestureDetector(OnGestureListener onGestureListener) {
        this(null, onGestureListener, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GestureDetector$__constructor__(android.view.GestureDetector$OnGestureListener ), this, onGestureListener);
    }

    private void __constructor__(Context context, OnGestureListener onGestureListener) {
        this.$$robo$$android_view_GestureDetector$__constructor__(context, onGestureListener);
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener) {
        this(context, onGestureListener, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GestureDetector$__constructor__(android.content.Context android.view.GestureDetector$OnGestureListener ), this, context, onGestureListener);
    }

    private void __constructor__(Context context, OnGestureListener onGestureListener, Handler handler) {
        this.$$robo$$android_view_GestureDetector$__constructor__(context, onGestureListener, handler);
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GestureDetector$__constructor__(android.content.Context android.view.GestureDetector$OnGestureListener android.os.Handler ), this, context, onGestureListener, handler);
    }

    private void __constructor__(Context context, OnGestureListener onGestureListener, Handler handler, boolean bl) {
        this.$$robo$$android_view_GestureDetector$__constructor__(context, onGestureListener, handler, bl);
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener, Handler handler, boolean bl) {
        this(context, onGestureListener, handler);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GestureDetector$__constructor__(android.content.Context android.view.GestureDetector$OnGestureListener android.os.Handler boolean ), this, context, onGestureListener, handler, bl);
    }

    private void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_GestureDetector$init(android.content.Context ), this, context);
    }

    public void setOnDoubleTapListener(OnDoubleTapListener onDoubleTapListener) {
        InvokeDynamicSupport.bootstrap("setOnDoubleTapListener", $$robo$$android_view_GestureDetector$setOnDoubleTapListener(android.view.GestureDetector$OnDoubleTapListener ), this, onDoubleTapListener);
    }

    public void setContextClickListener(OnContextClickListener onContextClickListener) {
        InvokeDynamicSupport.bootstrap("setContextClickListener", $$robo$$android_view_GestureDetector$setContextClickListener(android.view.GestureDetector$OnContextClickListener ), this, onContextClickListener);
    }

    public void setIsLongpressEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsLongpressEnabled", $$robo$$android_view_GestureDetector$setIsLongpressEnabled(boolean ), this, bl);
    }

    public boolean isLongpressEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLongpressEnabled", $$robo$$android_view_GestureDetector$isLongpressEnabled(), this);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_view_GestureDetector$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_view_GestureDetector$onGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_view_GestureDetector$cancel(), this);
    }

    private void cancelTaps() {
        InvokeDynamicSupport.bootstrap("cancelTaps", $$robo$$android_view_GestureDetector$cancelTaps(), this);
    }

    private boolean isConsideredDoubleTap(MotionEvent motionEvent, MotionEvent motionEvent2, MotionEvent motionEvent3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isConsideredDoubleTap", $$robo$$android_view_GestureDetector$isConsideredDoubleTap(android.view.MotionEvent android.view.MotionEvent android.view.MotionEvent ), this, motionEvent, motionEvent2, motionEvent3);
    }

    private void dispatchLongPress() {
        InvokeDynamicSupport.bootstrap("dispatchLongPress", $$robo$$android_view_GestureDetector$dispatchLongPress(), this);
    }

    static {
        RobolectricInternals.classInitializing(GestureDetector.class);
    }

    public /* synthetic */ GestureDetector() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureDetector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class GestureHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ GestureDetector this$0;

        private void $$robo$$android_view_GestureDetector_GestureHandler$__constructor__(GestureDetector gestureDetector) {
        }

        private void $$robo$$android_view_GestureDetector_GestureHandler$__constructor__(GestureDetector gestureDetector, Handler handler) {
        }

        private final void $$robo$$android_view_GestureDetector_GestureHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.this$0.mListener.onShowPress(this.this$0.mCurrentDownEvent);
                    break;
                }
                case 2: {
                    this.this$0.dispatchLongPress();
                    break;
                }
                case 3: {
                    if (this.this$0.mDoubleTapListener == null) break;
                    if (!this.this$0.mStillDown) {
                        this.this$0.mDoubleTapListener.onSingleTapConfirmed(this.this$0.mCurrentDownEvent);
                        break;
                    }
                    this.this$0.mDeferConfirmSingleTap = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown message " + msg);
                }
            }
        }

        private void __constructor__(GestureDetector gestureDetector) {
            this.$$robo$$android_view_GestureDetector_GestureHandler$__constructor__(gestureDetector);
        }

        public GestureHandler(GestureDetector gestureDetector) {
            this.this$0 = gestureDetector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GestureDetector_GestureHandler$__constructor__(android.view.GestureDetector ), this, gestureDetector);
        }

        private void __constructor__(GestureDetector gestureDetector, Handler handler) {
            this.$$robo$$android_view_GestureDetector_GestureHandler$__constructor__(gestureDetector, handler);
        }

        public GestureHandler(GestureDetector gestureDetector, Handler handler) {
            this.this$0 = gestureDetector;
            super(handler.getLooper());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GestureDetector_GestureHandler$__constructor__(android.view.GestureDetector android.os.Handler ), this, gestureDetector, handler);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_GestureDetector_GestureHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ GestureHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SimpleOnGestureListener
    implements OnGestureListener,
    OnDoubleTapListener,
    OnContextClickListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_GestureDetector_SimpleOnGestureListener$__constructor__() {
        }

        private final boolean $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onSingleTapUp(MotionEvent e) {
            return false;
        }

        private final void $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onLongPress(MotionEvent e) {
        }

        private final boolean $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return false;
        }

        private final boolean $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }

        private final void $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onShowPress(MotionEvent e) {
        }

        private final boolean $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onDown(MotionEvent e) {
            return false;
        }

        private final boolean $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onDoubleTap(MotionEvent e) {
            return false;
        }

        private final boolean $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        private final boolean $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onSingleTapConfirmed(MotionEvent e) {
            return false;
        }

        private final boolean $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onContextClick(MotionEvent e) {
            return false;
        }

        private void __constructor__() {
            this.$$robo$$android_view_GestureDetector_SimpleOnGestureListener$__constructor__();
        }

        public SimpleOnGestureListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$__constructor__(), this);
        }

        @Override
        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onSingleTapUp", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onSingleTapUp(android.view.MotionEvent ), this, motionEvent);
        }

        @Override
        public void onLongPress(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("onLongPress", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onLongPress(android.view.MotionEvent ), this, motionEvent);
        }

        @Override
        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onScroll", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onScroll(android.view.MotionEvent android.view.MotionEvent float float ), this, motionEvent, motionEvent2, f, f2);
        }

        @Override
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onFling", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onFling(android.view.MotionEvent android.view.MotionEvent float float ), this, motionEvent, motionEvent2, f, f2);
        }

        @Override
        public void onShowPress(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("onShowPress", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onShowPress(android.view.MotionEvent ), this, motionEvent);
        }

        @Override
        public boolean onDown(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onDown", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onDown(android.view.MotionEvent ), this, motionEvent);
        }

        @Override
        public boolean onDoubleTap(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onDoubleTap", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onDoubleTap(android.view.MotionEvent ), this, motionEvent);
        }

        @Override
        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onDoubleTapEvent", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onDoubleTapEvent(android.view.MotionEvent ), this, motionEvent);
        }

        @Override
        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onSingleTapConfirmed", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onSingleTapConfirmed(android.view.MotionEvent ), this, motionEvent);
        }

        @Override
        public boolean onContextClick(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onContextClick", $$robo$$android_view_GestureDetector_SimpleOnGestureListener$onContextClick(android.view.MotionEvent ), this, motionEvent);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleOnGestureListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnContextClickListener
    extends InstrumentedInterface {
        public boolean onContextClick(MotionEvent var1);
    }

    public static interface OnDoubleTapListener
    extends InstrumentedInterface {
        public boolean onSingleTapConfirmed(MotionEvent var1);

        public boolean onDoubleTap(MotionEvent var1);

        public boolean onDoubleTapEvent(MotionEvent var1);
    }

    public static interface OnGestureListener
    extends InstrumentedInterface {
        public boolean onDown(MotionEvent var1);

        public void onShowPress(MotionEvent var1);

        public boolean onSingleTapUp(MotionEvent var1);

        public boolean onScroll(MotionEvent var1, MotionEvent var2, float var3, float var4);

        public void onLongPress(MotionEvent var1);

        public boolean onFling(MotionEvent var1, MotionEvent var2, float var3, float var4);
    }
}

