/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayAdjustments;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import libcore.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DisplayInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public int layerStack;
    public int flags;
    public int type;
    public String address;
    public String name;
    public String uniqueId;
    public int appWidth;
    public int appHeight;
    public int smallestNominalAppWidth;
    public int smallestNominalAppHeight;
    public int largestNominalAppWidth;
    public int largestNominalAppHeight;
    public int logicalWidth;
    public int logicalHeight;
    public int overscanLeft;
    public int overscanTop;
    public int overscanRight;
    public int overscanBottom;
    public int rotation;
    public int modeId;
    public int defaultModeId;
    public Display.Mode[] supportedModes;
    public int colorMode;
    public int[] supportedColorModes;
    public Display.HdrCapabilities hdrCapabilities;
    public int logicalDensityDpi;
    public float physicalXDpi;
    public float physicalYDpi;
    public long appVsyncOffsetNanos;
    public long presentationDeadlineNanos;
    public int state;
    public int ownerUid;
    public String ownerPackageName;
    public int removeMode;
    public static Parcelable.Creator<DisplayInfo> CREATOR;

    private void $$robo$$android_view_DisplayInfo$__constructor__() {
        this.supportedModes = Display.Mode.EMPTY_ARRAY;
        this.supportedColorModes = new int[]{0};
        this.removeMode = 0;
    }

    private void $$robo$$android_view_DisplayInfo$__constructor__(DisplayInfo other) {
        this.supportedModes = Display.Mode.EMPTY_ARRAY;
        this.supportedColorModes = new int[]{0};
        this.removeMode = 0;
        this.copyFrom(other);
    }

    private void $$robo$$android_view_DisplayInfo$__constructor__(Parcel source) {
        this.supportedModes = Display.Mode.EMPTY_ARRAY;
        this.supportedColorModes = new int[]{0};
        this.removeMode = 0;
        this.readFromParcel(source);
    }

    private final boolean $$robo$$android_view_DisplayInfo$equals(Object o) {
        return o instanceof DisplayInfo && this.equals((DisplayInfo)o);
    }

    private final boolean $$robo$$android_view_DisplayInfo$equals(DisplayInfo other) {
        return other != null && this.layerStack == other.layerStack && this.flags == other.flags && this.type == other.type && Objects.equal(this.address, other.address) && Objects.equal(this.uniqueId, other.uniqueId) && this.appWidth == other.appWidth && this.appHeight == other.appHeight && this.smallestNominalAppWidth == other.smallestNominalAppWidth && this.smallestNominalAppHeight == other.smallestNominalAppHeight && this.largestNominalAppWidth == other.largestNominalAppWidth && this.largestNominalAppHeight == other.largestNominalAppHeight && this.logicalWidth == other.logicalWidth && this.logicalHeight == other.logicalHeight && this.overscanLeft == other.overscanLeft && this.overscanTop == other.overscanTop && this.overscanRight == other.overscanRight && this.overscanBottom == other.overscanBottom && this.rotation == other.rotation && this.modeId == other.modeId && this.defaultModeId == other.defaultModeId && this.colorMode == other.colorMode && Arrays.equals(this.supportedColorModes, other.supportedColorModes) && Objects.equal(this.hdrCapabilities, other.hdrCapabilities) && this.logicalDensityDpi == other.logicalDensityDpi && this.physicalXDpi == other.physicalXDpi && this.physicalYDpi == other.physicalYDpi && this.appVsyncOffsetNanos == other.appVsyncOffsetNanos && this.presentationDeadlineNanos == other.presentationDeadlineNanos && this.state == other.state && this.ownerUid == other.ownerUid && Objects.equal(this.ownerPackageName, other.ownerPackageName) && this.removeMode == other.removeMode;
    }

    private final int $$robo$$android_view_DisplayInfo$hashCode() {
        return 0;
    }

    private final void $$robo$$android_view_DisplayInfo$copyFrom(DisplayInfo other) {
        this.layerStack = other.layerStack;
        this.flags = other.flags;
        this.type = other.type;
        this.address = other.address;
        this.name = other.name;
        this.uniqueId = other.uniqueId;
        this.appWidth = other.appWidth;
        this.appHeight = other.appHeight;
        this.smallestNominalAppWidth = other.smallestNominalAppWidth;
        this.smallestNominalAppHeight = other.smallestNominalAppHeight;
        this.largestNominalAppWidth = other.largestNominalAppWidth;
        this.largestNominalAppHeight = other.largestNominalAppHeight;
        this.logicalWidth = other.logicalWidth;
        this.logicalHeight = other.logicalHeight;
        this.overscanLeft = other.overscanLeft;
        this.overscanTop = other.overscanTop;
        this.overscanRight = other.overscanRight;
        this.overscanBottom = other.overscanBottom;
        this.rotation = other.rotation;
        this.modeId = other.modeId;
        this.defaultModeId = other.defaultModeId;
        this.supportedModes = Arrays.copyOf(other.supportedModes, other.supportedModes.length);
        this.colorMode = other.colorMode;
        this.supportedColorModes = Arrays.copyOf(other.supportedColorModes, other.supportedColorModes.length);
        this.hdrCapabilities = other.hdrCapabilities;
        this.logicalDensityDpi = other.logicalDensityDpi;
        this.physicalXDpi = other.physicalXDpi;
        this.physicalYDpi = other.physicalYDpi;
        this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
        this.presentationDeadlineNanos = other.presentationDeadlineNanos;
        this.state = other.state;
        this.ownerUid = other.ownerUid;
        this.ownerPackageName = other.ownerPackageName;
        this.removeMode = other.removeMode;
    }

    private final void $$robo$$android_view_DisplayInfo$readFromParcel(Parcel source) {
        this.layerStack = source.readInt();
        this.flags = source.readInt();
        this.type = source.readInt();
        this.address = source.readString();
        this.name = source.readString();
        this.appWidth = source.readInt();
        this.appHeight = source.readInt();
        this.smallestNominalAppWidth = source.readInt();
        this.smallestNominalAppHeight = source.readInt();
        this.largestNominalAppWidth = source.readInt();
        this.largestNominalAppHeight = source.readInt();
        this.logicalWidth = source.readInt();
        this.logicalHeight = source.readInt();
        this.overscanLeft = source.readInt();
        this.overscanTop = source.readInt();
        this.overscanRight = source.readInt();
        this.overscanBottom = source.readInt();
        this.rotation = source.readInt();
        this.modeId = source.readInt();
        this.defaultModeId = source.readInt();
        int nModes = source.readInt();
        this.supportedModes = new Display.Mode[nModes];
        for (int i = 0; i < nModes; ++i) {
            this.supportedModes[i] = Display.Mode.CREATOR.createFromParcel(source);
        }
        this.colorMode = source.readInt();
        int nColorModes = source.readInt();
        this.supportedColorModes = new int[nColorModes];
        for (int i = 0; i < nColorModes; ++i) {
            this.supportedColorModes[i] = source.readInt();
        }
        this.hdrCapabilities = (Display.HdrCapabilities)source.readParcelable(null);
        this.logicalDensityDpi = source.readInt();
        this.physicalXDpi = source.readFloat();
        this.physicalYDpi = source.readFloat();
        this.appVsyncOffsetNanos = source.readLong();
        this.presentationDeadlineNanos = source.readLong();
        this.state = source.readInt();
        this.ownerUid = source.readInt();
        this.ownerPackageName = source.readString();
        this.uniqueId = source.readString();
        this.removeMode = source.readInt();
    }

    private final void $$robo$$android_view_DisplayInfo$writeToParcel(Parcel dest, int flags) {
        int i;
        dest.writeInt(this.layerStack);
        dest.writeInt(this.flags);
        dest.writeInt(this.type);
        dest.writeString(this.address);
        dest.writeString(this.name);
        dest.writeInt(this.appWidth);
        dest.writeInt(this.appHeight);
        dest.writeInt(this.smallestNominalAppWidth);
        dest.writeInt(this.smallestNominalAppHeight);
        dest.writeInt(this.largestNominalAppWidth);
        dest.writeInt(this.largestNominalAppHeight);
        dest.writeInt(this.logicalWidth);
        dest.writeInt(this.logicalHeight);
        dest.writeInt(this.overscanLeft);
        dest.writeInt(this.overscanTop);
        dest.writeInt(this.overscanRight);
        dest.writeInt(this.overscanBottom);
        dest.writeInt(this.rotation);
        dest.writeInt(this.modeId);
        dest.writeInt(this.defaultModeId);
        dest.writeInt(this.supportedModes.length);
        for (i = 0; i < this.supportedModes.length; ++i) {
            this.supportedModes[i].writeToParcel(dest, flags);
        }
        dest.writeInt(this.colorMode);
        dest.writeInt(this.supportedColorModes.length);
        for (i = 0; i < this.supportedColorModes.length; ++i) {
            dest.writeInt(this.supportedColorModes[i]);
        }
        dest.writeParcelable(this.hdrCapabilities, flags);
        dest.writeInt(this.logicalDensityDpi);
        dest.writeFloat(this.physicalXDpi);
        dest.writeFloat(this.physicalYDpi);
        dest.writeLong(this.appVsyncOffsetNanos);
        dest.writeLong(this.presentationDeadlineNanos);
        dest.writeInt(this.state);
        dest.writeInt(this.ownerUid);
        dest.writeString(this.ownerPackageName);
        dest.writeString(this.uniqueId);
        dest.writeInt(this.removeMode);
    }

    private final int $$robo$$android_view_DisplayInfo$describeContents() {
        return 0;
    }

    private final Display.Mode $$robo$$android_view_DisplayInfo$getMode() {
        return this.findMode(this.modeId);
    }

    private final Display.Mode $$robo$$android_view_DisplayInfo$getDefaultMode() {
        return this.findMode(this.defaultModeId);
    }

    private final Display.Mode $$robo$$android_view_DisplayInfo$findMode(int id2) {
        for (int i = 0; i < this.supportedModes.length; ++i) {
            if (this.supportedModes[i].getModeId() != id2) continue;
            return this.supportedModes[i];
        }
        throw new IllegalStateException("Unable to locate mode " + id2);
    }

    private final int $$robo$$android_view_DisplayInfo$findDefaultModeByRefreshRate(float refreshRate) {
        Display.Mode[] modes = this.supportedModes;
        Display.Mode defaultMode = this.getDefaultMode();
        for (int i = 0; i < modes.length; ++i) {
            if (!modes[i].matches(defaultMode.getPhysicalWidth(), defaultMode.getPhysicalHeight(), refreshRate)) continue;
            return modes[i].getModeId();
        }
        return 0;
    }

    private final float[] $$robo$$android_view_DisplayInfo$getDefaultRefreshRates() {
        Display.Mode[] modes = this.supportedModes;
        ArraySet<Float> rates = new ArraySet<Float>();
        Display.Mode defaultMode = this.getDefaultMode();
        for (int i = 0; i < modes.length; ++i) {
            Display.Mode mode = modes[i];
            if (mode.getPhysicalWidth() != defaultMode.getPhysicalWidth() || mode.getPhysicalHeight() != defaultMode.getPhysicalHeight()) continue;
            rates.add(Float.valueOf(mode.getRefreshRate()));
        }
        float[] result = new float[rates.size()];
        int i = 0;
        for (Float rate : rates) {
            result[i++] = rate.floatValue();
        }
        return result;
    }

    private final void $$robo$$android_view_DisplayInfo$getAppMetrics(DisplayMetrics outMetrics) {
        this.getAppMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
    }

    private final void $$robo$$android_view_DisplayInfo$getAppMetrics(DisplayMetrics outMetrics, DisplayAdjustments displayAdjustments) {
        this.getMetricsWithSize(outMetrics, displayAdjustments.getCompatibilityInfo(), displayAdjustments.getConfiguration(), this.appWidth, this.appHeight);
    }

    private final void $$robo$$android_view_DisplayInfo$getAppMetrics(DisplayMetrics outMetrics, CompatibilityInfo ci, Configuration configuration) {
        this.getMetricsWithSize(outMetrics, ci, configuration, this.appWidth, this.appHeight);
    }

    private final void $$robo$$android_view_DisplayInfo$getLogicalMetrics(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration) {
        this.getMetricsWithSize(outMetrics, compatInfo, configuration, this.logicalWidth, this.logicalHeight);
    }

    private final int $$robo$$android_view_DisplayInfo$getNaturalWidth() {
        return this.rotation == 0 || this.rotation == 2 ? this.logicalWidth : this.logicalHeight;
    }

    private final int $$robo$$android_view_DisplayInfo$getNaturalHeight() {
        return this.rotation == 0 || this.rotation == 2 ? this.logicalHeight : this.logicalWidth;
    }

    private final boolean $$robo$$android_view_DisplayInfo$isHdr() {
        int[] types = this.hdrCapabilities != null ? this.hdrCapabilities.getSupportedHdrTypes() : null;
        return types != null && types.length > 0;
    }

    private final boolean $$robo$$android_view_DisplayInfo$isWideColorGamut() {
        for (int colorMode : this.supportedColorModes) {
            if (colorMode != 6 && colorMode <= 7) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_view_DisplayInfo$hasAccess(int uid) {
        return Display.hasAccess(uid, this.flags, this.ownerUid);
    }

    private final void $$robo$$android_view_DisplayInfo$getMetricsWithSize(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration, int width, int height) {
        outMetrics.densityDpi = outMetrics.noncompatDensityDpi = this.logicalDensityDpi;
        outMetrics.scaledDensity = outMetrics.noncompatScaledDensity = (outMetrics.density = (outMetrics.noncompatDensity = (float)this.logicalDensityDpi * 0.00625f));
        outMetrics.xdpi = outMetrics.noncompatXdpi = this.physicalXDpi;
        outMetrics.ydpi = outMetrics.noncompatYdpi = this.physicalYDpi;
        width = configuration != null && configuration.appBounds != null ? configuration.appBounds.width() : width;
        height = configuration != null && configuration.appBounds != null ? configuration.appBounds.height() : height;
        outMetrics.noncompatWidthPixels = outMetrics.widthPixels = width;
        outMetrics.noncompatHeightPixels = outMetrics.heightPixels = height;
        if (!compatInfo.equals(CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO)) {
            compatInfo.applyToDisplayMetrics(outMetrics);
        }
    }

    private final String $$robo$$android_view_DisplayInfo$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DisplayInfo{\"");
        sb.append(this.name);
        sb.append("\", uniqueId \"");
        sb.append(this.uniqueId);
        sb.append("\", app ");
        sb.append(this.appWidth);
        sb.append(" x ");
        sb.append(this.appHeight);
        sb.append(", real ");
        sb.append(this.logicalWidth);
        sb.append(" x ");
        sb.append(this.logicalHeight);
        if (this.overscanLeft != 0 || this.overscanTop != 0 || this.overscanRight != 0 || this.overscanBottom != 0) {
            sb.append(", overscan (");
            sb.append(this.overscanLeft);
            sb.append(",");
            sb.append(this.overscanTop);
            sb.append(",");
            sb.append(this.overscanRight);
            sb.append(",");
            sb.append(this.overscanBottom);
            sb.append(")");
        }
        sb.append(", largest app ");
        sb.append(this.largestNominalAppWidth);
        sb.append(" x ");
        sb.append(this.largestNominalAppHeight);
        sb.append(", smallest app ");
        sb.append(this.smallestNominalAppWidth);
        sb.append(" x ");
        sb.append(this.smallestNominalAppHeight);
        sb.append(", mode ");
        sb.append(this.modeId);
        sb.append(", defaultMode ");
        sb.append(this.defaultModeId);
        sb.append(", modes ");
        sb.append(Arrays.toString(this.supportedModes));
        sb.append(", colorMode ");
        sb.append(this.colorMode);
        sb.append(", supportedColorModes ");
        sb.append(Arrays.toString(this.supportedColorModes));
        sb.append(", hdrCapabilities ");
        sb.append(this.hdrCapabilities);
        sb.append(", rotation ");
        sb.append(this.rotation);
        sb.append(", density ");
        sb.append(this.logicalDensityDpi);
        sb.append(" (");
        sb.append(this.physicalXDpi);
        sb.append(" x ");
        sb.append(this.physicalYDpi);
        sb.append(") dpi, layerStack ");
        sb.append(this.layerStack);
        sb.append(", appVsyncOff ");
        sb.append(this.appVsyncOffsetNanos);
        sb.append(", presDeadline ");
        sb.append(this.presentationDeadlineNanos);
        sb.append(", type ");
        sb.append(Display.typeToString(this.type));
        if (this.address != null) {
            sb.append(", address ").append(this.address);
        }
        sb.append(", state ");
        sb.append(Display.stateToString(this.state));
        if (this.ownerUid != 0 || this.ownerPackageName != null) {
            sb.append(", owner ").append(this.ownerPackageName);
            sb.append(" (uid ").append(this.ownerUid).append(")");
        }
        sb.append(DisplayInfo.flagsToString(this.flags));
        sb.append(", removeMode ");
        sb.append(this.removeMode);
        sb.append("}");
        return sb.toString();
    }

    private static final String $$robo$$android_view_DisplayInfo$flagsToString(int flags) {
        StringBuilder result = new StringBuilder();
        if ((flags & 2) != 0) {
            result.append(", FLAG_SECURE");
        }
        if ((flags & 1) != 0) {
            result.append(", FLAG_SUPPORTS_PROTECTED_BUFFERS");
        }
        if ((flags & 4) != 0) {
            result.append(", FLAG_PRIVATE");
        }
        if ((flags & 8) != 0) {
            result.append(", FLAG_PRESENTATION");
        }
        if ((flags & 0x40000000) != 0) {
            result.append(", FLAG_SCALING_DISABLED");
        }
        if ((flags & 0x10) != 0) {
            result.append(", FLAG_ROUND");
        }
        return result.toString();
    }

    private /* synthetic */ void $$robo$$android_view_DisplayInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<DisplayInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_DisplayInfo_1$__constructor__() {
            }

            private final DisplayInfo $$robo$$android_view_DisplayInfo_1$createFromParcel(Parcel source) {
                return new DisplayInfo(source, null);
            }

            private final DisplayInfo[] $$robo$$android_view_DisplayInfo_1$newArray(int size) {
                return new DisplayInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_DisplayInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayInfo_1$__constructor__(), this);
            }

            @Override
            public DisplayInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_DisplayInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public DisplayInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_DisplayInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_view_DisplayInfo$__constructor__();
    }

    public DisplayInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayInfo$__constructor__(), this);
    }

    private void __constructor__(DisplayInfo displayInfo) {
        this.$$robo$$android_view_DisplayInfo$__constructor__(displayInfo);
    }

    public DisplayInfo(DisplayInfo displayInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayInfo$__constructor__(android.view.DisplayInfo ), this, displayInfo);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_DisplayInfo$__constructor__(parcel);
    }

    public DisplayInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_DisplayInfo$equals(java.lang.Object ), this, object);
    }

    public boolean equals(DisplayInfo displayInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_DisplayInfo$equals(android.view.DisplayInfo ), this, displayInfo);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_DisplayInfo$hashCode(), this);
    }

    public void copyFrom(DisplayInfo displayInfo) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_view_DisplayInfo$copyFrom(android.view.DisplayInfo ), this, displayInfo);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_view_DisplayInfo$readFromParcel(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_DisplayInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_DisplayInfo$describeContents(), this);
    }

    public Display.Mode getMode() {
        return InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_view_DisplayInfo$getMode(), this);
    }

    public Display.Mode getDefaultMode() {
        return InvokeDynamicSupport.bootstrap("getDefaultMode", $$robo$$android_view_DisplayInfo$getDefaultMode(), this);
    }

    private Display.Mode findMode(int n) {
        return InvokeDynamicSupport.bootstrap("findMode", $$robo$$android_view_DisplayInfo$findMode(int ), this, n);
    }

    public int findDefaultModeByRefreshRate(float f) {
        return (int)InvokeDynamicSupport.bootstrap("findDefaultModeByRefreshRate", $$robo$$android_view_DisplayInfo$findDefaultModeByRefreshRate(float ), this, f);
    }

    public float[] getDefaultRefreshRates() {
        return InvokeDynamicSupport.bootstrap("getDefaultRefreshRates", $$robo$$android_view_DisplayInfo$getDefaultRefreshRates(), this);
    }

    public void getAppMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("getAppMetrics", $$robo$$android_view_DisplayInfo$getAppMetrics(android.util.DisplayMetrics ), this, displayMetrics);
    }

    public void getAppMetrics(DisplayMetrics displayMetrics, DisplayAdjustments displayAdjustments) {
        InvokeDynamicSupport.bootstrap("getAppMetrics", $$robo$$android_view_DisplayInfo$getAppMetrics(android.util.DisplayMetrics android.view.DisplayAdjustments ), this, displayMetrics, displayAdjustments);
    }

    public void getAppMetrics(DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo, Configuration configuration) {
        InvokeDynamicSupport.bootstrap("getAppMetrics", $$robo$$android_view_DisplayInfo$getAppMetrics(android.util.DisplayMetrics android.content.res.CompatibilityInfo android.content.res.Configuration ), this, displayMetrics, compatibilityInfo, configuration);
    }

    public void getLogicalMetrics(DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo, Configuration configuration) {
        InvokeDynamicSupport.bootstrap("getLogicalMetrics", $$robo$$android_view_DisplayInfo$getLogicalMetrics(android.util.DisplayMetrics android.content.res.CompatibilityInfo android.content.res.Configuration ), this, displayMetrics, compatibilityInfo, configuration);
    }

    public int getNaturalWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getNaturalWidth", $$robo$$android_view_DisplayInfo$getNaturalWidth(), this);
    }

    public int getNaturalHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getNaturalHeight", $$robo$$android_view_DisplayInfo$getNaturalHeight(), this);
    }

    public boolean isHdr() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHdr", $$robo$$android_view_DisplayInfo$isHdr(), this);
    }

    public boolean isWideColorGamut() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWideColorGamut", $$robo$$android_view_DisplayInfo$isWideColorGamut(), this);
    }

    public boolean hasAccess(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAccess", $$robo$$android_view_DisplayInfo$hasAccess(int ), this, n);
    }

    private void getMetricsWithSize(DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo, Configuration configuration, int n, int n2) {
        InvokeDynamicSupport.bootstrap("getMetricsWithSize", $$robo$$android_view_DisplayInfo$getMetricsWithSize(android.util.DisplayMetrics android.content.res.CompatibilityInfo android.content.res.Configuration int int ), this, displayMetrics, compatibilityInfo, configuration, n, n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_DisplayInfo$toString(), this);
    }

    private static String flagsToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("flagsToString", $$robo$$android_view_DisplayInfo$flagsToString(int ), (int)n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_DisplayInfo$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ DisplayInfo(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_DisplayInfo$__constructor__(android.os.Parcel android.view.DisplayInfo$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(DisplayInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

