/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.text.style.AccessibilityClickableSpan;
import android.text.style.ClickableSpan;
import android.util.LongSparseArray;
import android.view.MagnificationSpec;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AccessibilityInteractionController
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean ENFORCE_NODE_TREE_CONSISTENT = false;
    private ArrayList<AccessibilityNodeInfo> mTempAccessibilityNodeInfoList;
    private Handler mHandler;
    private ViewRootImpl mViewRootImpl;
    private AccessibilityNodePrefetcher mPrefetcher;
    private long mMyLooperThreadId;
    private int mMyProcessId;
    private ArrayList<View> mTempArrayList;
    private Point mTempPoint;
    private Rect mTempRect;
    private Rect mTempRect1;
    private Rect mTempRect2;
    private AddNodeInfosForViewId mAddNodeInfosForViewId;

    private void $$robo$$android_view_AccessibilityInteractionController$__constructor__(ViewRootImpl viewRootImpl) {
        this.mTempAccessibilityNodeInfoList = new ArrayList();
        this.mTempArrayList = new ArrayList();
        this.mTempPoint = new Point();
        this.mTempRect = new Rect();
        this.mTempRect1 = new Rect();
        this.mTempRect2 = new Rect();
        Looper looper = viewRootImpl.mHandler.getLooper();
        this.mMyLooperThreadId = looper.getThread().getId();
        this.mMyProcessId = Process.myPid();
        this.mHandler = new PrivateHandler(this, looper);
        this.mViewRootImpl = viewRootImpl;
        this.mPrefetcher = new AccessibilityNodePrefetcher(this, null);
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$scheduleMessage(Message message, int interrogatingPid, long interrogatingTid) {
        if (interrogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
        } else {
            this.mHandler.sendMessage(message);
        }
    }

    private final boolean $$robo$$android_view_AccessibilityInteractionController$isShown(View view) {
        return view.mAttachInfo != null && view.mAttachInfo.mWindowVisibility == 0 && view.isShown();
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfoByAccessibilityIdClientThread(long accessibilityNodeId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec, Bundle arguments) {
        Message message = this.mHandler.obtainMessage();
        message.what = 2;
        message.arg1 = flags;
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        args.arg4 = arguments;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfoByAccessibilityIdUiThread(Message message) {
        int flags = message.arg1;
        SomeArgs args = (SomeArgs)message.obj;
        int accessibilityViewId = args.argi1;
        int virtualDescendantId = args.argi2;
        int interactionId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        Region interactiveRegion = (Region)args.arg3;
        Bundle arguments = (Bundle)args.arg4;
        args.recycle();
        ArrayList<AccessibilityNodeInfo> infos = this.mTempAccessibilityNodeInfoList;
        infos.clear();
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId == 0x7FFFFFFE ? this.mViewRootImpl.mView : this.findViewByAccessibilityId(accessibilityViewId);
            if (root != null && this.isShown(root)) {
                this.mPrefetcher.prefetchAccessibilityNodeInfos(root, virtualDescendantId, flags, infos, arguments);
            }
        }
        finally {
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, interactiveRegion);
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfosByViewIdClientThread(long accessibilityNodeId, String viewId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 3;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = viewId;
        args.arg4 = interactiveRegion;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfosByViewIdUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int interactionId = args.argi1;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        String viewId = (String)args.arg3;
        Region interactiveRegion = (Region)args.arg4;
        args.recycle();
        ArrayList<AccessibilityNodeInfo> infos = this.mTempAccessibilityNodeInfoList;
        infos.clear();
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (root != null) {
                int resolvedViewId = root.getContext().getResources().getIdentifier(viewId, null, null);
                if (resolvedViewId <= 0) {
                    return;
                }
                if (this.mAddNodeInfosForViewId == null) {
                    this.mAddNodeInfosForViewId = new AddNodeInfosForViewId(this, null);
                }
                this.mAddNodeInfosForViewId.init(resolvedViewId, infos);
                root.findViewByPredicate(this.mAddNodeInfosForViewId);
                this.mAddNodeInfosForViewId.reset();
            }
        }
        finally {
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, interactiveRegion);
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfosByTextClientThread(long accessibilityNodeId, String text, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 4;
        message.arg1 = flags;
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = text;
        args.arg2 = callback;
        args.arg3 = spec;
        args.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi3 = interactionId;
        args.arg4 = interactiveRegion;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfosByTextUiThread(Message message) {
        int flags = message.arg1;
        SomeArgs args = (SomeArgs)message.obj;
        String text = (String)args.arg1;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg2;
        MagnificationSpec spec = (MagnificationSpec)args.arg3;
        int accessibilityViewId = args.argi1;
        int virtualDescendantId = args.argi2;
        int interactionId = args.argi3;
        Region interactiveRegion = (Region)args.arg4;
        args.recycle();
        List<AccessibilityNodeInfo> infos = null;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (root != null && this.isShown(root)) {
                AccessibilityNodeProvider provider = root.getAccessibilityNodeProvider();
                if (provider != null) {
                    infos = provider.findAccessibilityNodeInfosByText(text, virtualDescendantId);
                } else if (virtualDescendantId == -1) {
                    ArrayList<View> foundViews = this.mTempArrayList;
                    foundViews.clear();
                    root.findViewsWithText(foundViews, text, 7);
                    if (!foundViews.isEmpty()) {
                        infos = this.mTempAccessibilityNodeInfoList;
                        infos.clear();
                        int viewCount = foundViews.size();
                        for (int i = 0; i < viewCount; ++i) {
                            View foundView = foundViews.get(i);
                            if (!this.isShown(foundView)) continue;
                            provider = foundView.getAccessibilityNodeProvider();
                            if (provider != null) {
                                List<AccessibilityNodeInfo> infosFromProvider = provider.findAccessibilityNodeInfosByText(text, -1);
                                if (infosFromProvider == null) continue;
                                infos.addAll(infosFromProvider);
                                continue;
                            }
                            infos.add(foundView.createAccessibilityNodeInfo());
                        }
                    }
                }
            }
        }
        finally {
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, interactiveRegion);
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$findFocusClientThread(long accessibilityNodeId, int focusType, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 5;
        message.arg1 = flags;
        message.arg2 = focusType;
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = interactionId;
        args.argi2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi3 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_view_AccessibilityInteractionController$findFocusUiThread(Message message) {
        int flags = message.arg1;
        int focusType = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int interactionId = args.argi1;
        int accessibilityViewId = args.argi2;
        int virtualDescendantId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        Region interactiveRegion = (Region)args.arg3;
        args.recycle();
        AccessibilityNodeInfo focused = null;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (root == null || !this.isShown(root)) return;
            switch (focusType) {
                case 2: {
                    View host = this.mViewRootImpl.mAccessibilityFocusedHost;
                    if (host == null) return;
                    if (!ViewRootImpl.isViewDescendantOf(host, root)) {
                        return;
                    } else if (!this.isShown(host)) {
                        return;
                    } else {
                        AccessibilityNodeProvider provider = host.getAccessibilityNodeProvider();
                        if (provider != null) {
                            if (this.mViewRootImpl.mAccessibilityFocusedVirtualView == null) return;
                            focused = AccessibilityNodeInfo.obtain(this.mViewRootImpl.mAccessibilityFocusedVirtualView);
                            return;
                        } else {
                            if (virtualDescendantId != -1) return;
                            focused = host.createAccessibilityNodeInfo();
                            return;
                        }
                    }
                }
                case 1: {
                    View target = root.findFocus();
                    if (target == null) return;
                    if (!this.isShown(target)) {
                        return;
                    } else {
                        AccessibilityNodeProvider provider = target.getAccessibilityNodeProvider();
                        if (provider != null) {
                            focused = provider.findFocus(focusType);
                        }
                        if (focused != null) return;
                        focused = target.createAccessibilityNodeInfo();
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown focus type: " + focusType);
                }
            }
        }
        finally {
            this.updateInfoForViewportAndReturnFindNodeResult(focused, callback, interactionId, spec, interactiveRegion);
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$focusSearchClientThread(long accessibilityNodeId, int direction, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 6;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi2 = direction;
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_AccessibilityInteractionController$focusSearchUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int direction = args.argi2;
        int interactionId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        Region interactiveRegion = (Region)args.arg3;
        args.recycle();
        AccessibilityNodeInfo next = null;
        try {
            View nextView;
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (root != null && this.isShown(root) && (nextView = root.focusSearch(direction)) != null) {
                next = nextView.createAccessibilityNodeInfo();
            }
        }
        finally {
            this.updateInfoForViewportAndReturnFindNodeResult(next, callback, interactionId, spec, interactiveRegion);
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$performAccessibilityActionClientThread(long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 1;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi2 = action;
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = arguments;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_AccessibilityInteractionController$performAccessibilityActionUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int virtualDescendantId = args.argi1;
        int action = args.argi2;
        int interactionId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        Bundle arguments = (Bundle)args.arg2;
        args.recycle();
        boolean succeeded = false;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null || this.mViewRootImpl.mStopped || this.mViewRootImpl.mPausedForTransition) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View target = null;
            target = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (target != null && this.isShown(target)) {
                if (action == 16908647) {
                    succeeded = this.handleClickableSpanActionUiThread(target, virtualDescendantId, arguments);
                } else {
                    AccessibilityNodeProvider provider = target.getAccessibilityNodeProvider();
                    if (provider != null) {
                        succeeded = provider.performAction(virtualDescendantId, action, arguments);
                    } else if (virtualDescendantId == -1) {
                        succeeded = target.performAccessibilityAction(action, arguments);
                    }
                }
            }
        }
        finally {
            try {
                this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                callback.setPerformAccessibilityActionResult(succeeded, interactionId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final View $$robo$$android_view_AccessibilityInteractionController$findViewByAccessibilityId(int accessibilityId) {
        View root = this.mViewRootImpl.mView;
        if (root == null) {
            return null;
        }
        Object foundView = root.findViewByAccessibilityId(accessibilityId);
        if (foundView != null && !this.isShown((View)foundView)) {
            return null;
        }
        return foundView;
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$applyAppScaleAndMagnificationSpecIfNeeded(List<AccessibilityNodeInfo> infos, MagnificationSpec spec) {
        if (infos == null) {
            return;
        }
        float applicationScale = this.mViewRootImpl.mAttachInfo.mApplicationScale;
        if (this.shouldApplyAppScaleAndMagnificationSpec(applicationScale, spec)) {
            int infoCount = infos.size();
            for (int i = 0; i < infoCount; ++i) {
                AccessibilityNodeInfo info = infos.get(i);
                this.applyAppScaleAndMagnificationSpecIfNeeded(info, spec);
            }
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$adjustIsVisibleToUserIfNeeded(List<AccessibilityNodeInfo> infos, Region interactiveRegion) {
        if (interactiveRegion == null || infos == null) {
            return;
        }
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityNodeInfo info = infos.get(i);
            this.adjustIsVisibleToUserIfNeeded(info, interactiveRegion);
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$adjustIsVisibleToUserIfNeeded(AccessibilityNodeInfo info, Region interactiveRegion) {
        if (interactiveRegion == null || info == null) {
            return;
        }
        Rect boundsInScreen = this.mTempRect;
        info.getBoundsInScreen(boundsInScreen);
        if (interactiveRegion.quickReject(boundsInScreen)) {
            info.setVisibleToUser(false);
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$applyAppScaleAndMagnificationSpecIfNeeded(AccessibilityNodeInfo info, MagnificationSpec spec) {
        Bundle extras;
        Parcelable[] textLocations;
        if (info == null) {
            return;
        }
        float applicationScale = this.mViewRootImpl.mAttachInfo.mApplicationScale;
        if (!this.shouldApplyAppScaleAndMagnificationSpec(applicationScale, spec)) {
            return;
        }
        Rect boundsInParent = this.mTempRect;
        Rect boundsInScreen = this.mTempRect1;
        info.getBoundsInParent(boundsInParent);
        info.getBoundsInScreen(boundsInScreen);
        if (applicationScale != 1.0f) {
            boundsInParent.scale(applicationScale);
            boundsInScreen.scale(applicationScale);
        }
        if (spec != null) {
            boundsInParent.scale(spec.scale);
            boundsInScreen.scale(spec.scale);
            boundsInScreen.offset((int)spec.offsetX, (int)spec.offsetY);
        }
        info.setBoundsInParent(boundsInParent);
        info.setBoundsInScreen(boundsInScreen);
        if (info.hasExtras() && (textLocations = (extras = info.getExtras()).getParcelableArray("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY")) != null) {
            for (int i = 0; i < textLocations.length; ++i) {
                RectF textLocation = (RectF)textLocations[i];
                textLocation.scale(applicationScale);
                if (spec == null) continue;
                textLocation.scale(spec.scale);
                textLocation.offset(spec.offsetX, spec.offsetY);
            }
        }
        if (spec != null) {
            View.AttachInfo attachInfo = this.mViewRootImpl.mAttachInfo;
            if (attachInfo.mDisplay == null) {
                return;
            }
            float scale = attachInfo.mApplicationScale * spec.scale;
            Rect visibleWinFrame = this.mTempRect1;
            visibleWinFrame.left = (int)((float)attachInfo.mWindowLeft * scale + spec.offsetX);
            visibleWinFrame.top = (int)((float)attachInfo.mWindowTop * scale + spec.offsetY);
            visibleWinFrame.right = (int)((float)visibleWinFrame.left + (float)this.mViewRootImpl.mWidth * scale);
            visibleWinFrame.bottom = (int)((float)visibleWinFrame.top + (float)this.mViewRootImpl.mHeight * scale);
            attachInfo.mDisplay.getRealSize(this.mTempPoint);
            int displayWidth = this.mTempPoint.x;
            int displayHeight = this.mTempPoint.y;
            Rect visibleDisplayFrame = this.mTempRect2;
            visibleDisplayFrame.set(0, 0, displayWidth, displayHeight);
            if (!visibleWinFrame.intersect(visibleDisplayFrame)) {
                visibleDisplayFrame.setEmpty();
            }
            if (!visibleWinFrame.intersects(boundsInScreen.left, boundsInScreen.top, boundsInScreen.right, boundsInScreen.bottom)) {
                info.setVisibleToUser(false);
            }
        }
    }

    private final boolean $$robo$$android_view_AccessibilityInteractionController$shouldApplyAppScaleAndMagnificationSpec(float appScale, MagnificationSpec spec) {
        return appScale != 1.0f || spec != null && !spec.isNop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_AccessibilityInteractionController$updateInfosForViewportAndReturnFindNodeResult(List<AccessibilityNodeInfo> infos, IAccessibilityInteractionConnectionCallback callback, int interactionId, MagnificationSpec spec, Region interactiveRegion) {
        try {
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
            this.applyAppScaleAndMagnificationSpecIfNeeded(infos, spec);
            this.adjustIsVisibleToUserIfNeeded(infos, interactiveRegion);
            callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
            if (infos != null) {
                infos.clear();
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.recycleMagnificationSpecAndRegionIfNeeded(spec, interactiveRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_AccessibilityInteractionController$updateInfoForViewportAndReturnFindNodeResult(AccessibilityNodeInfo info, IAccessibilityInteractionConnectionCallback callback, int interactionId, MagnificationSpec spec, Region interactiveRegion) {
        try {
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
            this.applyAppScaleAndMagnificationSpecIfNeeded(info, spec);
            this.adjustIsVisibleToUserIfNeeded(info, interactiveRegion);
            callback.setFindAccessibilityNodeInfoResult(info, interactionId);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.recycleMagnificationSpecAndRegionIfNeeded(spec, interactiveRegion);
        }
    }

    private final void $$robo$$android_view_AccessibilityInteractionController$recycleMagnificationSpecAndRegionIfNeeded(MagnificationSpec spec, Region region) {
        if (Process.myPid() != Binder.getCallingPid()) {
            if (spec != null) {
                spec.recycle();
            }
        } else if (region != null) {
            region.recycle();
        }
    }

    private final boolean $$robo$$android_view_AccessibilityInteractionController$handleClickableSpanActionUiThread(View view, int virtualDescendantId, Bundle arguments) {
        Object span = arguments.getParcelable("android.view.accessibility.action.ACTION_ARGUMENT_ACCESSIBLE_CLICKABLE_SPAN");
        if (!(span instanceof AccessibilityClickableSpan)) {
            return false;
        }
        AccessibilityNodeInfo infoWithSpan = null;
        AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
        if (provider != null) {
            infoWithSpan = provider.createAccessibilityNodeInfo(virtualDescendantId);
        } else if (virtualDescendantId == -1) {
            infoWithSpan = view.createAccessibilityNodeInfo();
        }
        if (infoWithSpan == null) {
            return false;
        }
        ClickableSpan clickableSpan = ((AccessibilityClickableSpan)span).findClickableSpan(infoWithSpan.getOriginalText());
        if (clickableSpan != null) {
            clickableSpan.onClick(view);
            return true;
        }
        return false;
    }

    private void __constructor__(ViewRootImpl viewRootImpl) {
        this.$$robo$$android_view_AccessibilityInteractionController$__constructor__(viewRootImpl);
    }

    public AccessibilityInteractionController(ViewRootImpl viewRootImpl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityInteractionController$__constructor__(android.view.ViewRootImpl ), this, viewRootImpl);
    }

    private void scheduleMessage(Message message, int n, long l) {
        InvokeDynamicSupport.bootstrap("scheduleMessage", $$robo$$android_view_AccessibilityInteractionController$scheduleMessage(android.os.Message int long ), this, message, n, l);
    }

    private boolean isShown(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isShown", $$robo$$android_view_AccessibilityInteractionController$isShown(android.view.View ), this, view);
    }

    public void findAccessibilityNodeInfoByAccessibilityIdClientThread(long l, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfoByAccessibilityIdClientThread", $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfoByAccessibilityIdClientThread(long android.graphics.Region int android.view.accessibility.IAccessibilityInteractionConnectionCallback int int long android.view.MagnificationSpec android.os.Bundle ), this, l, region, n, iAccessibilityInteractionConnectionCallback, n2, n3, l2, magnificationSpec, bundle);
    }

    private void findAccessibilityNodeInfoByAccessibilityIdUiThread(Message message) {
        InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfoByAccessibilityIdUiThread", $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfoByAccessibilityIdUiThread(android.os.Message ), this, message);
    }

    public void findAccessibilityNodeInfosByViewIdClientThread(long l, String string2, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec) {
        InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByViewIdClientThread", $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfosByViewIdClientThread(long java.lang.String android.graphics.Region int android.view.accessibility.IAccessibilityInteractionConnectionCallback int int long android.view.MagnificationSpec ), this, l, string2, region, n, iAccessibilityInteractionConnectionCallback, n2, n3, l2, magnificationSpec);
    }

    private void findAccessibilityNodeInfosByViewIdUiThread(Message message) {
        InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByViewIdUiThread", $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfosByViewIdUiThread(android.os.Message ), this, message);
    }

    public void findAccessibilityNodeInfosByTextClientThread(long l, String string2, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec) {
        InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByTextClientThread", $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfosByTextClientThread(long java.lang.String android.graphics.Region int android.view.accessibility.IAccessibilityInteractionConnectionCallback int int long android.view.MagnificationSpec ), this, l, string2, region, n, iAccessibilityInteractionConnectionCallback, n2, n3, l2, magnificationSpec);
    }

    private void findAccessibilityNodeInfosByTextUiThread(Message message) {
        InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByTextUiThread", $$robo$$android_view_AccessibilityInteractionController$findAccessibilityNodeInfosByTextUiThread(android.os.Message ), this, message);
    }

    public void findFocusClientThread(long l, int n, Region region, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2, MagnificationSpec magnificationSpec) {
        InvokeDynamicSupport.bootstrap("findFocusClientThread", $$robo$$android_view_AccessibilityInteractionController$findFocusClientThread(long int android.graphics.Region int android.view.accessibility.IAccessibilityInteractionConnectionCallback int int long android.view.MagnificationSpec ), this, l, n, region, n2, iAccessibilityInteractionConnectionCallback, n3, n4, l2, magnificationSpec);
    }

    private void findFocusUiThread(Message message) {
        InvokeDynamicSupport.bootstrap("findFocusUiThread", $$robo$$android_view_AccessibilityInteractionController$findFocusUiThread(android.os.Message ), this, message);
    }

    public void focusSearchClientThread(long l, int n, Region region, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2, MagnificationSpec magnificationSpec) {
        InvokeDynamicSupport.bootstrap("focusSearchClientThread", $$robo$$android_view_AccessibilityInteractionController$focusSearchClientThread(long int android.graphics.Region int android.view.accessibility.IAccessibilityInteractionConnectionCallback int int long android.view.MagnificationSpec ), this, l, n, region, n2, iAccessibilityInteractionConnectionCallback, n3, n4, l2, magnificationSpec);
    }

    private void focusSearchUiThread(Message message) {
        InvokeDynamicSupport.bootstrap("focusSearchUiThread", $$robo$$android_view_AccessibilityInteractionController$focusSearchUiThread(android.os.Message ), this, message);
    }

    public void performAccessibilityActionClientThread(long l, int n, Bundle bundle, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2) {
        InvokeDynamicSupport.bootstrap("performAccessibilityActionClientThread", $$robo$$android_view_AccessibilityInteractionController$performAccessibilityActionClientThread(long int android.os.Bundle int android.view.accessibility.IAccessibilityInteractionConnectionCallback int int long ), this, l, n, bundle, n2, iAccessibilityInteractionConnectionCallback, n3, n4, l2);
    }

    private void performAccessibilityActionUiThread(Message message) {
        InvokeDynamicSupport.bootstrap("performAccessibilityActionUiThread", $$robo$$android_view_AccessibilityInteractionController$performAccessibilityActionUiThread(android.os.Message ), this, message);
    }

    private View findViewByAccessibilityId(int n) {
        return InvokeDynamicSupport.bootstrap("findViewByAccessibilityId", $$robo$$android_view_AccessibilityInteractionController$findViewByAccessibilityId(int ), this, n);
    }

    private void applyAppScaleAndMagnificationSpecIfNeeded(List<AccessibilityNodeInfo> list, MagnificationSpec magnificationSpec) {
        InvokeDynamicSupport.bootstrap("applyAppScaleAndMagnificationSpecIfNeeded", $$robo$$android_view_AccessibilityInteractionController$applyAppScaleAndMagnificationSpecIfNeeded(java.util.List<android.view.accessibility.AccessibilityNodeInfo> android.view.MagnificationSpec ), this, list, magnificationSpec);
    }

    private void adjustIsVisibleToUserIfNeeded(List<AccessibilityNodeInfo> list, Region region) {
        InvokeDynamicSupport.bootstrap("adjustIsVisibleToUserIfNeeded", $$robo$$android_view_AccessibilityInteractionController$adjustIsVisibleToUserIfNeeded(java.util.List<android.view.accessibility.AccessibilityNodeInfo> android.graphics.Region ), this, list, region);
    }

    private void adjustIsVisibleToUserIfNeeded(AccessibilityNodeInfo accessibilityNodeInfo, Region region) {
        InvokeDynamicSupport.bootstrap("adjustIsVisibleToUserIfNeeded", $$robo$$android_view_AccessibilityInteractionController$adjustIsVisibleToUserIfNeeded(android.view.accessibility.AccessibilityNodeInfo android.graphics.Region ), this, accessibilityNodeInfo, region);
    }

    private void applyAppScaleAndMagnificationSpecIfNeeded(AccessibilityNodeInfo accessibilityNodeInfo, MagnificationSpec magnificationSpec) {
        InvokeDynamicSupport.bootstrap("applyAppScaleAndMagnificationSpecIfNeeded", $$robo$$android_view_AccessibilityInteractionController$applyAppScaleAndMagnificationSpecIfNeeded(android.view.accessibility.AccessibilityNodeInfo android.view.MagnificationSpec ), this, accessibilityNodeInfo, magnificationSpec);
    }

    private boolean shouldApplyAppScaleAndMagnificationSpec(float f, MagnificationSpec magnificationSpec) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldApplyAppScaleAndMagnificationSpec", $$robo$$android_view_AccessibilityInteractionController$shouldApplyAppScaleAndMagnificationSpec(float android.view.MagnificationSpec ), this, f, magnificationSpec);
    }

    private void updateInfosForViewportAndReturnFindNodeResult(List<AccessibilityNodeInfo> list, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n, MagnificationSpec magnificationSpec, Region region) {
        InvokeDynamicSupport.bootstrap("updateInfosForViewportAndReturnFindNodeResult", $$robo$$android_view_AccessibilityInteractionController$updateInfosForViewportAndReturnFindNodeResult(java.util.List<android.view.accessibility.AccessibilityNodeInfo> android.view.accessibility.IAccessibilityInteractionConnectionCallback int android.view.MagnificationSpec android.graphics.Region ), this, list, iAccessibilityInteractionConnectionCallback, n, magnificationSpec, region);
    }

    private void updateInfoForViewportAndReturnFindNodeResult(AccessibilityNodeInfo accessibilityNodeInfo, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n, MagnificationSpec magnificationSpec, Region region) {
        InvokeDynamicSupport.bootstrap("updateInfoForViewportAndReturnFindNodeResult", $$robo$$android_view_AccessibilityInteractionController$updateInfoForViewportAndReturnFindNodeResult(android.view.accessibility.AccessibilityNodeInfo android.view.accessibility.IAccessibilityInteractionConnectionCallback int android.view.MagnificationSpec android.graphics.Region ), this, accessibilityNodeInfo, iAccessibilityInteractionConnectionCallback, n, magnificationSpec, region);
    }

    private void recycleMagnificationSpecAndRegionIfNeeded(MagnificationSpec magnificationSpec, Region region) {
        InvokeDynamicSupport.bootstrap("recycleMagnificationSpecAndRegionIfNeeded", $$robo$$android_view_AccessibilityInteractionController$recycleMagnificationSpecAndRegionIfNeeded(android.view.MagnificationSpec android.graphics.Region ), this, magnificationSpec, region);
    }

    private boolean handleClickableSpanActionUiThread(View view, int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleClickableSpanActionUiThread", $$robo$$android_view_AccessibilityInteractionController$handleClickableSpanActionUiThread(android.view.View int android.os.Bundle ), this, view, n, bundle);
    }

    public /* synthetic */ AccessibilityInteractionController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityInteractionController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class AddNodeInfosForViewId
    implements Predicate<View> {
        public /* synthetic */ Object __robo_data__;
        private int mViewId;
        private List<AccessibilityNodeInfo> mInfos;
        /* synthetic */ AccessibilityInteractionController this$0;

        private void $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$__constructor__(AccessibilityInteractionController accessibilityInteractionController) {
            this.mViewId = -1;
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$init(int viewId, List<AccessibilityNodeInfo> infos) {
            this.mViewId = viewId;
            this.mInfos = infos;
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$reset() {
            this.mViewId = -1;
            this.mInfos = null;
        }

        private final boolean $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$test(View view) {
            if (view.getId() == this.mViewId && this.this$0.isShown(view)) {
                this.mInfos.add(view.createAccessibilityNodeInfo());
            }
            return false;
        }

        private /* synthetic */ void $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$__constructor__(AccessibilityInteractionController x0, 1 x1) {
        }

        private void __constructor__(AccessibilityInteractionController accessibilityInteractionController) {
            this.$$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$__constructor__(accessibilityInteractionController);
        }

        public AddNodeInfosForViewId(AccessibilityInteractionController accessibilityInteractionController) {
            this.this$0 = accessibilityInteractionController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$__constructor__(android.view.AccessibilityInteractionController ), this, accessibilityInteractionController);
        }

        public void init(int n, List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$init(int java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, n, list);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$reset(), this);
        }

        @Override
        public boolean test(View view) {
            return (boolean)InvokeDynamicSupport.bootstrap("test", $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$test(android.view.View ), this, view);
        }

        private /* synthetic */ void __constructor__(AccessibilityInteractionController accessibilityInteractionController, 1 var2_2) {
            this.$$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$__constructor__(accessibilityInteractionController, var2_2);
        }

        public /* synthetic */ AddNodeInfosForViewId(AccessibilityInteractionController accessibilityInteractionController, 1 var2_2) {
            this(accessibilityInteractionController);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityInteractionController_AddNodeInfosForViewId$__constructor__(android.view.AccessibilityInteractionController android.view.AccessibilityInteractionController$1 ), this, accessibilityInteractionController, var2_2);
        }

        public /* synthetic */ AddNodeInfosForViewId() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AddNodeInfosForViewId)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PrivateHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_PERFORM_ACCESSIBILITY_ACTION = 1;
        private static int MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_ACCESSIBILITY_ID = 2;
        private static int MSG_FIND_ACCESSIBILITY_NODE_INFOS_BY_VIEW_ID = 3;
        private static int MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_TEXT = 4;
        private static int MSG_FIND_FOCUS = 5;
        private static int MSG_FOCUS_SEARCH = 6;
        /* synthetic */ AccessibilityInteractionController this$0;

        private void $$robo$$android_view_AccessibilityInteractionController_PrivateHandler$__constructor__(AccessibilityInteractionController accessibilityInteractionController, Looper looper) {
        }

        private final String $$robo$$android_view_AccessibilityInteractionController_PrivateHandler$getMessageName(Message message) {
            int type = message.what;
            switch (type) {
                case 1: {
                    return "MSG_PERFORM_ACCESSIBILITY_ACTION";
                }
                case 2: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_ACCESSIBILITY_ID";
                }
                case 3: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFOS_BY_VIEW_ID";
                }
                case 4: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_TEXT";
                }
                case 5: {
                    return "MSG_FIND_FOCUS";
                }
                case 6: {
                    return "MSG_FOCUS_SEARCH";
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + type);
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_PrivateHandler$handleMessage(Message message) {
            int type = message.what;
            switch (type) {
                case 2: {
                    this.this$0.findAccessibilityNodeInfoByAccessibilityIdUiThread(message);
                    break;
                }
                case 1: {
                    this.this$0.performAccessibilityActionUiThread(message);
                    break;
                }
                case 3: {
                    this.this$0.findAccessibilityNodeInfosByViewIdUiThread(message);
                    break;
                }
                case 4: {
                    this.this$0.findAccessibilityNodeInfosByTextUiThread(message);
                    break;
                }
                case 5: {
                    this.this$0.findFocusUiThread(message);
                    break;
                }
                case 6: {
                    this.this$0.focusSearchUiThread(message);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message type: " + type);
                }
            }
        }

        private void __constructor__(AccessibilityInteractionController accessibilityInteractionController, Looper looper) {
            this.$$robo$$android_view_AccessibilityInteractionController_PrivateHandler$__constructor__(accessibilityInteractionController, looper);
        }

        public PrivateHandler(AccessibilityInteractionController accessibilityInteractionController, Looper looper) {
            this.this$0 = accessibilityInteractionController;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityInteractionController_PrivateHandler$__constructor__(android.view.AccessibilityInteractionController android.os.Looper ), this, accessibilityInteractionController, looper);
        }

        @Override
        public String getMessageName(Message message) {
            return InvokeDynamicSupport.bootstrap("getMessageName", $$robo$$android_view_AccessibilityInteractionController_PrivateHandler$getMessageName(android.os.Message ), this, message);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_AccessibilityInteractionController_PrivateHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ PrivateHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrivateHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AccessibilityNodePrefetcher
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MAX_ACCESSIBILITY_NODE_INFO_BATCH_SIZE = 50;
        private ArrayList<View> mTempViewList;
        /* synthetic */ AccessibilityInteractionController this$0;

        private void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$__constructor__(AccessibilityInteractionController accessibilityInteractionController) {
            this.mTempViewList = new ArrayList();
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchAccessibilityNodeInfos(View view, int virtualViewId, int fetchFlags, List<AccessibilityNodeInfo> outInfos, Bundle arguments) {
            String extraDataRequested;
            AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
            String string2 = extraDataRequested = arguments == null ? null : arguments.getString("android.view.accessibility.AccessibilityNodeInfo.extra_data_requested");
            if (provider == null) {
                AccessibilityNodeInfo root = view.createAccessibilityNodeInfo();
                if (root != null) {
                    if (extraDataRequested != null) {
                        view.addExtraDataToAccessibilityNodeInfo(root, extraDataRequested, arguments);
                    }
                    outInfos.add(root);
                    if ((fetchFlags & 1) != 0) {
                        this.prefetchPredecessorsOfRealNode(view, outInfos);
                    }
                    if ((fetchFlags & 2) != 0) {
                        this.prefetchSiblingsOfRealNode(view, outInfos);
                    }
                    if ((fetchFlags & 4) != 0) {
                        this.prefetchDescendantsOfRealNode(view, outInfos);
                    }
                }
            } else {
                AccessibilityNodeInfo root = provider.createAccessibilityNodeInfo(virtualViewId);
                if (root != null) {
                    if (extraDataRequested != null) {
                        provider.addExtraDataToAccessibilityNodeInfo(virtualViewId, root, extraDataRequested, arguments);
                    }
                    outInfos.add(root);
                    if ((fetchFlags & 1) != 0) {
                        this.prefetchPredecessorsOfVirtualNode(root, view, provider, outInfos);
                    }
                    if ((fetchFlags & 2) != 0) {
                        this.prefetchSiblingsOfVirtualNode(root, view, provider, outInfos);
                    }
                    if ((fetchFlags & 4) != 0) {
                        this.prefetchDescendantsOfVirtualNode(root, provider, outInfos);
                    }
                }
            }
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$enforceNodeTreeConsistent(List<AccessibilityNodeInfo> nodes) {
            AccessibilityNodeInfo root;
            LongSparseArray<AccessibilityNodeInfo> nodeMap = new LongSparseArray<AccessibilityNodeInfo>();
            int nodeCount = nodes.size();
            for (int i = 0; i < nodeCount; ++i) {
                AccessibilityNodeInfo node = nodes.get(i);
                nodeMap.put(node.getSourceNodeId(), node);
            }
            AccessibilityNodeInfo parent = root = (AccessibilityNodeInfo)nodeMap.valueAt(0);
            while (parent != null) {
                root = parent;
                parent = (AccessibilityNodeInfo)nodeMap.get(parent.getParentNodeId());
            }
            AccessibilityNodeInfo accessFocus = null;
            AccessibilityNodeInfo inputFocus = null;
            HashSet<AccessibilityNodeInfo> seen = new HashSet<AccessibilityNodeInfo>();
            LinkedList<AccessibilityNodeInfo> fringe = new LinkedList<AccessibilityNodeInfo>();
            fringe.add(root);
            while (!fringe.isEmpty()) {
                AccessibilityNodeInfo current = (AccessibilityNodeInfo)fringe.poll();
                if (!seen.add(current)) {
                    throw new IllegalStateException("Duplicate node: " + current + " in window:" + ((AccessibilityInteractionController)this.this$0).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                }
                if (current.isAccessibilityFocused()) {
                    if (accessFocus != null) {
                        throw new IllegalStateException("Duplicate accessibility focus:" + current + " in window:" + ((AccessibilityInteractionController)this.this$0).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                    }
                    accessFocus = current;
                }
                if (current.isFocused()) {
                    if (inputFocus != null) {
                        throw new IllegalStateException("Duplicate input focus: " + current + " in window:" + ((AccessibilityInteractionController)this.this$0).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                    }
                    inputFocus = current;
                }
                int childCount = current.getChildCount();
                for (int j = 0; j < childCount; ++j) {
                    long childId = current.getChildId(j);
                    AccessibilityNodeInfo child = (AccessibilityNodeInfo)nodeMap.get(childId);
                    if (child == null) continue;
                    fringe.add(child);
                }
            }
            for (int j = nodeMap.size() - 1; j >= 0; --j) {
                AccessibilityNodeInfo info = (AccessibilityNodeInfo)nodeMap.valueAt(j);
                if (seen.contains(info)) continue;
                throw new IllegalStateException("Disconnected node: " + info);
            }
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchPredecessorsOfRealNode(View view, List<AccessibilityNodeInfo> outInfos) {
            ViewParent parent = view.getParentForAccessibility();
            while (parent instanceof View && outInfos.size() < 50) {
                View parentView = (View)((Object)parent);
                AccessibilityNodeInfo info = parentView.createAccessibilityNodeInfo();
                if (info != null) {
                    outInfos.add(info);
                }
                parent = parent.getParentForAccessibility();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchSiblingsOfRealNode(View current, List<AccessibilityNodeInfo> outInfos) {
            ViewParent parent = current.getParentForAccessibility();
            if (parent instanceof ViewGroup) {
                ViewGroup parentGroup = (ViewGroup)parent;
                ArrayList<View> children = this.mTempViewList;
                children.clear();
                try {
                    parentGroup.addChildrenForAccessibility(children);
                    int childCount = children.size();
                    for (int i = 0; i < childCount; ++i) {
                        if (outInfos.size() >= 50) {
                            return;
                        }
                        View child = children.get(i);
                        if (child.getAccessibilityViewId() == current.getAccessibilityViewId() || !this.this$0.isShown(child)) continue;
                        AccessibilityNodeInfo info = null;
                        AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                        info = provider == null ? child.createAccessibilityNodeInfo() : provider.createAccessibilityNodeInfo(-1);
                        if (info == null) continue;
                        outInfos.add(info);
                    }
                }
                finally {
                    children.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchDescendantsOfRealNode(View root, List<AccessibilityNodeInfo> outInfos) {
            if (!(root instanceof ViewGroup)) {
                return;
            }
            HashMap<View, AccessibilityNodeInfo> addedChildren = new HashMap<View, AccessibilityNodeInfo>();
            ArrayList<View> children = this.mTempViewList;
            children.clear();
            try {
                root.addChildrenForAccessibility(children);
                int childCount = children.size();
                for (int i = 0; i < childCount; ++i) {
                    AccessibilityNodeInfo info;
                    if (outInfos.size() >= 50) {
                        return;
                    }
                    View child = children.get(i);
                    if (!this.this$0.isShown(child)) continue;
                    AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                    if (provider == null) {
                        info = child.createAccessibilityNodeInfo();
                        if (info == null) continue;
                        outInfos.add(info);
                        addedChildren.put(child, null);
                        continue;
                    }
                    info = provider.createAccessibilityNodeInfo(-1);
                    if (info == null) continue;
                    outInfos.add(info);
                    addedChildren.put(child, info);
                }
            }
            finally {
                children.clear();
            }
            if (outInfos.size() < 50) {
                for (Map.Entry entry : addedChildren.entrySet()) {
                    View addedChild = (View)entry.getKey();
                    AccessibilityNodeInfo virtualRoot = (AccessibilityNodeInfo)entry.getValue();
                    if (virtualRoot == null) {
                        this.prefetchDescendantsOfRealNode(addedChild, outInfos);
                        continue;
                    }
                    AccessibilityNodeProvider provider = addedChild.getAccessibilityNodeProvider();
                    this.prefetchDescendantsOfVirtualNode(virtualRoot, provider, outInfos);
                }
            }
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchPredecessorsOfVirtualNode(AccessibilityNodeInfo root, View providerHost, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            int initialResultSize = outInfos.size();
            long parentNodeId = root.getParentNodeId();
            int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
            while (accessibilityViewId != Integer.MAX_VALUE) {
                if (outInfos.size() >= 50) {
                    return;
                }
                int virtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(parentNodeId);
                if (virtualDescendantId != -1 || accessibilityViewId == providerHost.getAccessibilityViewId()) {
                    AccessibilityNodeInfo parent = provider.createAccessibilityNodeInfo(virtualDescendantId);
                    if (parent == null) {
                        int currentResultSize = outInfos.size();
                        for (int i = currentResultSize - 1; i >= initialResultSize; --i) {
                            outInfos.remove(i);
                        }
                        return;
                    }
                    outInfos.add(parent);
                    parentNodeId = parent.getParentNodeId();
                    accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
                    continue;
                }
                this.prefetchPredecessorsOfRealNode(providerHost, outInfos);
                return;
            }
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchSiblingsOfVirtualNode(AccessibilityNodeInfo current, View providerHost, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            long parentNodeId = current.getParentNodeId();
            int parentAccessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
            int parentVirtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(parentNodeId);
            if (parentVirtualDescendantId != -1 || parentAccessibilityViewId == providerHost.getAccessibilityViewId()) {
                AccessibilityNodeInfo parent = provider.createAccessibilityNodeInfo(parentVirtualDescendantId);
                if (parent != null) {
                    int childCount = parent.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        int childVirtualDescendantId;
                        AccessibilityNodeInfo child;
                        if (outInfos.size() >= 50) {
                            return;
                        }
                        long childNodeId = parent.getChildId(i);
                        if (childNodeId == current.getSourceNodeId() || (child = provider.createAccessibilityNodeInfo(childVirtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(childNodeId))) == null) continue;
                        outInfos.add(child);
                    }
                }
            } else {
                this.prefetchSiblingsOfRealNode(providerHost, outInfos);
            }
        }

        private final void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchDescendantsOfVirtualNode(AccessibilityNodeInfo root, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            int initialOutInfosSize = outInfos.size();
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (outInfos.size() >= 50) {
                    return;
                }
                long childNodeId = root.getChildId(i);
                AccessibilityNodeInfo child = provider.createAccessibilityNodeInfo(AccessibilityNodeInfo.getVirtualDescendantId(childNodeId));
                if (child == null) continue;
                outInfos.add(child);
            }
            if (outInfos.size() < 50) {
                int addedChildCount = outInfos.size() - initialOutInfosSize;
                for (int i = 0; i < addedChildCount; ++i) {
                    AccessibilityNodeInfo child = outInfos.get(initialOutInfosSize + i);
                    this.prefetchDescendantsOfVirtualNode(child, provider, outInfos);
                }
            }
        }

        private /* synthetic */ void $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$__constructor__(AccessibilityInteractionController x0, 1 x1) {
        }

        private void __constructor__(AccessibilityInteractionController accessibilityInteractionController) {
            this.$$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$__constructor__(accessibilityInteractionController);
        }

        public AccessibilityNodePrefetcher(AccessibilityInteractionController accessibilityInteractionController) {
            this.this$0 = accessibilityInteractionController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$__constructor__(android.view.AccessibilityInteractionController ), this, accessibilityInteractionController);
        }

        public void prefetchAccessibilityNodeInfos(View view, int n, int n2, List<AccessibilityNodeInfo> list, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("prefetchAccessibilityNodeInfos", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchAccessibilityNodeInfos(android.view.View int int java.util.List<android.view.accessibility.AccessibilityNodeInfo> android.os.Bundle ), this, view, n, n2, list, bundle);
        }

        private void enforceNodeTreeConsistent(List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("enforceNodeTreeConsistent", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$enforceNodeTreeConsistent(java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, list);
        }

        private void prefetchPredecessorsOfRealNode(View view, List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("prefetchPredecessorsOfRealNode", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchPredecessorsOfRealNode(android.view.View java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, view, list);
        }

        private void prefetchSiblingsOfRealNode(View view, List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("prefetchSiblingsOfRealNode", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchSiblingsOfRealNode(android.view.View java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, view, list);
        }

        private void prefetchDescendantsOfRealNode(View view, List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("prefetchDescendantsOfRealNode", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchDescendantsOfRealNode(android.view.View java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, view, list);
        }

        private void prefetchPredecessorsOfVirtualNode(AccessibilityNodeInfo accessibilityNodeInfo, View view, AccessibilityNodeProvider accessibilityNodeProvider, List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("prefetchPredecessorsOfVirtualNode", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchPredecessorsOfVirtualNode(android.view.accessibility.AccessibilityNodeInfo android.view.View android.view.accessibility.AccessibilityNodeProvider java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, accessibilityNodeInfo, view, accessibilityNodeProvider, list);
        }

        private void prefetchSiblingsOfVirtualNode(AccessibilityNodeInfo accessibilityNodeInfo, View view, AccessibilityNodeProvider accessibilityNodeProvider, List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("prefetchSiblingsOfVirtualNode", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchSiblingsOfVirtualNode(android.view.accessibility.AccessibilityNodeInfo android.view.View android.view.accessibility.AccessibilityNodeProvider java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, accessibilityNodeInfo, view, accessibilityNodeProvider, list);
        }

        private void prefetchDescendantsOfVirtualNode(AccessibilityNodeInfo accessibilityNodeInfo, AccessibilityNodeProvider accessibilityNodeProvider, List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("prefetchDescendantsOfVirtualNode", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$prefetchDescendantsOfVirtualNode(android.view.accessibility.AccessibilityNodeInfo android.view.accessibility.AccessibilityNodeProvider java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, accessibilityNodeInfo, accessibilityNodeProvider, list);
        }

        private /* synthetic */ void __constructor__(AccessibilityInteractionController accessibilityInteractionController, 1 var2_2) {
            this.$$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$__constructor__(accessibilityInteractionController, var2_2);
        }

        public /* synthetic */ AccessibilityNodePrefetcher(AccessibilityInteractionController accessibilityInteractionController, 1 var2_2) {
            this(accessibilityInteractionController);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityInteractionController_AccessibilityNodePrefetcher$__constructor__(android.view.AccessibilityInteractionController android.view.AccessibilityInteractionController$1 ), this, accessibilityInteractionController, var2_2);
        }

        public /* synthetic */ AccessibilityNodePrefetcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityNodePrefetcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

