/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Emoji;
import android.text.SpannableStringBuilder;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BidiFormatter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static TextDirectionHeuristic DEFAULT_TEXT_DIRECTION_HEURISTIC;
    private static char LRE = '\u202a';
    private static char RLE = '\u202b';
    private static char PDF = '\u202c';
    private static char LRM = '\u200e';
    private static char RLM = '\u200f';
    private static String LRM_STRING;
    private static String RLM_STRING;
    private static String EMPTY_STRING = "";
    private static int FLAG_STEREO_RESET = 2;
    private static int DEFAULT_FLAGS = 2;
    private static BidiFormatter DEFAULT_LTR_INSTANCE;
    private static BidiFormatter DEFAULT_RTL_INSTANCE;
    private boolean mIsRtlContext;
    private int mFlags;
    private TextDirectionHeuristic mDefaultTextDirectionHeuristic;
    private static int DIR_LTR = -1;
    private static int DIR_UNKNOWN = 0;
    private static int DIR_RTL = 1;

    private static final BidiFormatter $$robo$$android_text_BidiFormatter$getInstance() {
        return BidiFormatter.getDefaultInstanceFromContext(BidiFormatter.isRtlLocale(Locale.getDefault()));
    }

    private static final BidiFormatter $$robo$$android_text_BidiFormatter$getInstance(boolean rtlContext) {
        return BidiFormatter.getDefaultInstanceFromContext(rtlContext);
    }

    private static final BidiFormatter $$robo$$android_text_BidiFormatter$getInstance(Locale locale) {
        return BidiFormatter.getDefaultInstanceFromContext(BidiFormatter.isRtlLocale(locale));
    }

    private void $$robo$$android_text_BidiFormatter$__constructor__(boolean isRtlContext, int flags, TextDirectionHeuristic heuristic) {
        this.mIsRtlContext = isRtlContext;
        this.mFlags = flags;
        this.mDefaultTextDirectionHeuristic = heuristic;
    }

    private final boolean $$robo$$android_text_BidiFormatter$isRtlContext() {
        return this.mIsRtlContext;
    }

    private final boolean $$robo$$android_text_BidiFormatter$getStereoReset() {
        return (this.mFlags & 2) != 0;
    }

    private final String $$robo$$android_text_BidiFormatter$markAfter(CharSequence str, TextDirectionHeuristic heuristic) {
        boolean isRtl = heuristic.isRtl(str, 0, str.length());
        if (!this.mIsRtlContext && (isRtl || BidiFormatter.getExitDir(str) == 1)) {
            return LRM_STRING;
        }
        if (this.mIsRtlContext && (!isRtl || BidiFormatter.getExitDir(str) == -1)) {
            return RLM_STRING;
        }
        return "";
    }

    private final String $$robo$$android_text_BidiFormatter$markBefore(CharSequence str, TextDirectionHeuristic heuristic) {
        boolean isRtl = heuristic.isRtl(str, 0, str.length());
        if (!this.mIsRtlContext && (isRtl || BidiFormatter.getEntryDir(str) == 1)) {
            return LRM_STRING;
        }
        if (this.mIsRtlContext && (!isRtl || BidiFormatter.getEntryDir(str) == -1)) {
            return RLM_STRING;
        }
        return "";
    }

    private final boolean $$robo$$android_text_BidiFormatter$isRtl(String str) {
        return this.isRtl((CharSequence)str);
    }

    private final boolean $$robo$$android_text_BidiFormatter$isRtl(CharSequence str) {
        return this.mDefaultTextDirectionHeuristic.isRtl(str, 0, str.length());
    }

    private final String $$robo$$android_text_BidiFormatter$unicodeWrap(String str, TextDirectionHeuristic heuristic, boolean isolate) {
        if (str == null) {
            return null;
        }
        return this.unicodeWrap((CharSequence)str, heuristic, isolate).toString();
    }

    private final CharSequence $$robo$$android_text_BidiFormatter$unicodeWrap(CharSequence str, TextDirectionHeuristic heuristic, boolean isolate) {
        if (str == null) {
            return null;
        }
        boolean isRtl = heuristic.isRtl(str, 0, str.length());
        SpannableStringBuilder result = new SpannableStringBuilder();
        if (this.getStereoReset() && isolate) {
            result.append(this.markBefore(str, isRtl ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR));
        }
        if (isRtl != this.mIsRtlContext) {
            result.append(isRtl ? (char)'\u202b' : '\u202a');
            result.append(str);
            result.append('\u202c');
        } else {
            result.append(str);
        }
        if (isolate) {
            result.append(this.markAfter(str, isRtl ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR));
        }
        return result;
    }

    private final String $$robo$$android_text_BidiFormatter$unicodeWrap(String str, TextDirectionHeuristic heuristic) {
        return this.unicodeWrap(str, heuristic, true);
    }

    private final CharSequence $$robo$$android_text_BidiFormatter$unicodeWrap(CharSequence str, TextDirectionHeuristic heuristic) {
        return this.unicodeWrap(str, heuristic, true);
    }

    private final String $$robo$$android_text_BidiFormatter$unicodeWrap(String str, boolean isolate) {
        return this.unicodeWrap(str, this.mDefaultTextDirectionHeuristic, isolate);
    }

    private final CharSequence $$robo$$android_text_BidiFormatter$unicodeWrap(CharSequence str, boolean isolate) {
        return this.unicodeWrap(str, this.mDefaultTextDirectionHeuristic, isolate);
    }

    private final String $$robo$$android_text_BidiFormatter$unicodeWrap(String str) {
        return this.unicodeWrap(str, this.mDefaultTextDirectionHeuristic, true);
    }

    private final CharSequence $$robo$$android_text_BidiFormatter$unicodeWrap(CharSequence str) {
        return this.unicodeWrap(str, this.mDefaultTextDirectionHeuristic, true);
    }

    private static final BidiFormatter $$robo$$android_text_BidiFormatter$getDefaultInstanceFromContext(boolean isRtlContext) {
        return isRtlContext ? DEFAULT_RTL_INSTANCE : DEFAULT_LTR_INSTANCE;
    }

    private static final boolean $$robo$$android_text_BidiFormatter$isRtlLocale(Locale locale) {
        return TextUtils.getLayoutDirectionFromLocale(locale) == 1;
    }

    private static final int $$robo$$android_text_BidiFormatter$getExitDir(CharSequence str) {
        return new DirectionalityEstimator(str, false).getExitDir();
    }

    private static final int $$robo$$android_text_BidiFormatter$getEntryDir(CharSequence str) {
        return new DirectionalityEstimator(str, false).getEntryDir();
    }

    private /* synthetic */ void $$robo$$android_text_BidiFormatter$__constructor__(boolean x0, int x1, TextDirectionHeuristic x2, 1 x3) {
    }

    static void __staticInitializer__() {
        DEFAULT_TEXT_DIRECTION_HEURISTIC = TextDirectionHeuristics.FIRSTSTRONG_LTR;
        LRM_STRING = Character.toString('\u200e');
        RLM_STRING = Character.toString('\u200f');
        DEFAULT_LTR_INSTANCE = new BidiFormatter(false, 2, DEFAULT_TEXT_DIRECTION_HEURISTIC);
        DEFAULT_RTL_INSTANCE = new BidiFormatter(true, 2, DEFAULT_TEXT_DIRECTION_HEURISTIC);
    }

    public static BidiFormatter getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_BidiFormatter$getInstance());
    }

    public static BidiFormatter getInstance(boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_BidiFormatter$getInstance(boolean ), (boolean)bl);
    }

    public static BidiFormatter getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_BidiFormatter$getInstance(java.util.Locale ), (Locale)locale);
    }

    private void __constructor__(boolean bl, int n, TextDirectionHeuristic textDirectionHeuristic) {
        this.$$robo$$android_text_BidiFormatter$__constructor__(bl, n, textDirectionHeuristic);
    }

    public BidiFormatter(boolean bl, int n, TextDirectionHeuristic textDirectionHeuristic) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BidiFormatter$__constructor__(boolean int android.text.TextDirectionHeuristic ), this, bl, n, textDirectionHeuristic);
    }

    public boolean isRtlContext() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRtlContext", $$robo$$android_text_BidiFormatter$isRtlContext(), this);
    }

    public boolean getStereoReset() {
        return (boolean)InvokeDynamicSupport.bootstrap("getStereoReset", $$robo$$android_text_BidiFormatter$getStereoReset(), this);
    }

    public String markAfter(CharSequence charSequence, TextDirectionHeuristic textDirectionHeuristic) {
        return InvokeDynamicSupport.bootstrap("markAfter", $$robo$$android_text_BidiFormatter$markAfter(java.lang.CharSequence android.text.TextDirectionHeuristic ), this, charSequence, textDirectionHeuristic);
    }

    public String markBefore(CharSequence charSequence, TextDirectionHeuristic textDirectionHeuristic) {
        return InvokeDynamicSupport.bootstrap("markBefore", $$robo$$android_text_BidiFormatter$markBefore(java.lang.CharSequence android.text.TextDirectionHeuristic ), this, charSequence, textDirectionHeuristic);
    }

    public boolean isRtl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRtl", $$robo$$android_text_BidiFormatter$isRtl(java.lang.String ), this, string2);
    }

    public boolean isRtl(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRtl", $$robo$$android_text_BidiFormatter$isRtl(java.lang.CharSequence ), this, charSequence);
    }

    public String unicodeWrap(String string2, TextDirectionHeuristic textDirectionHeuristic, boolean bl) {
        return InvokeDynamicSupport.bootstrap("unicodeWrap", $$robo$$android_text_BidiFormatter$unicodeWrap(java.lang.String android.text.TextDirectionHeuristic boolean ), this, string2, textDirectionHeuristic, bl);
    }

    public CharSequence unicodeWrap(CharSequence charSequence, TextDirectionHeuristic textDirectionHeuristic, boolean bl) {
        return InvokeDynamicSupport.bootstrap("unicodeWrap", $$robo$$android_text_BidiFormatter$unicodeWrap(java.lang.CharSequence android.text.TextDirectionHeuristic boolean ), this, charSequence, textDirectionHeuristic, bl);
    }

    public String unicodeWrap(String string2, TextDirectionHeuristic textDirectionHeuristic) {
        return InvokeDynamicSupport.bootstrap("unicodeWrap", $$robo$$android_text_BidiFormatter$unicodeWrap(java.lang.String android.text.TextDirectionHeuristic ), this, string2, textDirectionHeuristic);
    }

    public CharSequence unicodeWrap(CharSequence charSequence, TextDirectionHeuristic textDirectionHeuristic) {
        return InvokeDynamicSupport.bootstrap("unicodeWrap", $$robo$$android_text_BidiFormatter$unicodeWrap(java.lang.CharSequence android.text.TextDirectionHeuristic ), this, charSequence, textDirectionHeuristic);
    }

    public String unicodeWrap(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("unicodeWrap", $$robo$$android_text_BidiFormatter$unicodeWrap(java.lang.String boolean ), this, string2, bl);
    }

    public CharSequence unicodeWrap(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("unicodeWrap", $$robo$$android_text_BidiFormatter$unicodeWrap(java.lang.CharSequence boolean ), this, charSequence, bl);
    }

    public String unicodeWrap(String string2) {
        return InvokeDynamicSupport.bootstrap("unicodeWrap", $$robo$$android_text_BidiFormatter$unicodeWrap(java.lang.String ), this, string2);
    }

    public CharSequence unicodeWrap(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("unicodeWrap", $$robo$$android_text_BidiFormatter$unicodeWrap(java.lang.CharSequence ), this, charSequence);
    }

    private static BidiFormatter getDefaultInstanceFromContext(boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultInstanceFromContext", $$robo$$android_text_BidiFormatter$getDefaultInstanceFromContext(boolean ), (boolean)bl);
    }

    private static boolean isRtlLocale(Locale locale) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRtlLocale", $$robo$$android_text_BidiFormatter$isRtlLocale(java.util.Locale ), (Locale)locale);
    }

    private static int getExitDir(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getExitDir", $$robo$$android_text_BidiFormatter$getExitDir(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    private static int getEntryDir(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getEntryDir", $$robo$$android_text_BidiFormatter$getEntryDir(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    private /* synthetic */ void __constructor__(boolean bl, int n, TextDirectionHeuristic textDirectionHeuristic, 1 var4_4) {
        this.$$robo$$android_text_BidiFormatter$__constructor__(bl, n, textDirectionHeuristic, var4_4);
    }

    public /* synthetic */ BidiFormatter(boolean bl, int n, TextDirectionHeuristic textDirectionHeuristic, 1 var4_4) {
        this(bl, n, textDirectionHeuristic);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BidiFormatter$__constructor__(boolean int android.text.TextDirectionHeuristic android.text.BidiFormatter$1 ), this, bl, n, textDirectionHeuristic, var4_4);
    }

    static {
        RobolectricInternals.classInitializing(BidiFormatter.class);
    }

    public /* synthetic */ BidiFormatter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BidiFormatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DirectionalityEstimator
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int DIR_TYPE_CACHE_SIZE = 1792;
        private static byte[] DIR_TYPE_CACHE;
        private CharSequence text;
        private boolean isHtml;
        private int length;
        private int charIndex;
        private char lastChar;

        private static final byte $$robo$$android_text_BidiFormatter_DirectionalityEstimator$getDirectionality(int codePoint) {
            if (Emoji.isNewEmoji(codePoint)) {
                return 13;
            }
            return Character.getDirectionality(codePoint);
        }

        private void $$robo$$android_text_BidiFormatter_DirectionalityEstimator$__constructor__(CharSequence text, boolean isHtml) {
            this.text = text;
            this.isHtml = isHtml;
            this.length = text.length();
        }

        private final int $$robo$$android_text_BidiFormatter_DirectionalityEstimator$getEntryDir() {
            this.charIndex = 0;
            int embeddingLevel = 0;
            int embeddingLevelDir = 0;
            int firstNonEmptyEmbeddingLevel = 0;
            block13: while (this.charIndex < this.length && firstNonEmptyEmbeddingLevel == 0) {
                switch (this.dirTypeForward()) {
                    case 14: 
                    case 15: {
                        ++embeddingLevel;
                        embeddingLevelDir = -1;
                        continue block13;
                    }
                    case 16: 
                    case 17: {
                        ++embeddingLevel;
                        embeddingLevelDir = 1;
                        continue block13;
                    }
                    case 18: {
                        --embeddingLevel;
                        embeddingLevelDir = 0;
                        continue block13;
                    }
                    case 9: {
                        continue block13;
                    }
                    case 0: {
                        if (embeddingLevel == 0) {
                            return -1;
                        }
                        firstNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block13;
                    }
                    case 1: 
                    case 2: {
                        if (embeddingLevel == 0) {
                            return 1;
                        }
                        firstNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block13;
                    }
                }
                firstNonEmptyEmbeddingLevel = embeddingLevel;
            }
            if (firstNonEmptyEmbeddingLevel == 0) {
                return 0;
            }
            if (embeddingLevelDir != 0) {
                return embeddingLevelDir;
            }
            while (this.charIndex > 0) {
                switch (this.dirTypeBackward()) {
                    case 14: 
                    case 15: {
                        if (firstNonEmptyEmbeddingLevel == embeddingLevel) {
                            return -1;
                        }
                        --embeddingLevel;
                        break;
                    }
                    case 16: 
                    case 17: {
                        if (firstNonEmptyEmbeddingLevel == embeddingLevel) {
                            return 1;
                        }
                        --embeddingLevel;
                        break;
                    }
                    case 18: {
                        ++embeddingLevel;
                    }
                }
            }
            return 0;
        }

        private final int $$robo$$android_text_BidiFormatter_DirectionalityEstimator$getExitDir() {
            this.charIndex = this.length;
            int embeddingLevel = 0;
            int lastNonEmptyEmbeddingLevel = 0;
            block8: while (this.charIndex > 0) {
                switch (this.dirTypeBackward()) {
                    case 0: {
                        if (embeddingLevel == 0) {
                            return -1;
                        }
                        if (lastNonEmptyEmbeddingLevel != 0) continue block8;
                        lastNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block8;
                    }
                    case 14: 
                    case 15: {
                        if (lastNonEmptyEmbeddingLevel == embeddingLevel) {
                            return -1;
                        }
                        --embeddingLevel;
                        continue block8;
                    }
                    case 1: 
                    case 2: {
                        if (embeddingLevel == 0) {
                            return 1;
                        }
                        if (lastNonEmptyEmbeddingLevel != 0) continue block8;
                        lastNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block8;
                    }
                    case 16: 
                    case 17: {
                        if (lastNonEmptyEmbeddingLevel == embeddingLevel) {
                            return 1;
                        }
                        --embeddingLevel;
                        continue block8;
                    }
                    case 18: {
                        ++embeddingLevel;
                        continue block8;
                    }
                    case 9: {
                        continue block8;
                    }
                }
                if (lastNonEmptyEmbeddingLevel != 0) continue;
                lastNonEmptyEmbeddingLevel = embeddingLevel;
            }
            return 0;
        }

        private static final byte $$robo$$android_text_BidiFormatter_DirectionalityEstimator$getCachedDirectionality(char c) {
            return c < '\u0700' ? DIR_TYPE_CACHE[c] : DirectionalityEstimator.getDirectionality(c);
        }

        private final byte $$robo$$android_text_BidiFormatter_DirectionalityEstimator$dirTypeForward() {
            this.lastChar = this.text.charAt(this.charIndex);
            if (Character.isHighSurrogate(this.lastChar)) {
                int codePoint = Character.codePointAt(this.text, this.charIndex);
                this.charIndex += Character.charCount(codePoint);
                return DirectionalityEstimator.getDirectionality(codePoint);
            }
            ++this.charIndex;
            byte dirType = DirectionalityEstimator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '<') {
                    dirType = this.skipTagForward();
                } else if (this.lastChar == '&') {
                    dirType = this.skipEntityForward();
                }
            }
            return dirType;
        }

        private final byte $$robo$$android_text_BidiFormatter_DirectionalityEstimator$dirTypeBackward() {
            this.lastChar = this.text.charAt(this.charIndex - 1);
            if (Character.isLowSurrogate(this.lastChar)) {
                int codePoint = Character.codePointBefore(this.text, this.charIndex);
                this.charIndex -= Character.charCount(codePoint);
                return DirectionalityEstimator.getDirectionality(codePoint);
            }
            --this.charIndex;
            byte dirType = DirectionalityEstimator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '>') {
                    dirType = this.skipTagBackward();
                } else if (this.lastChar == ';') {
                    dirType = this.skipEntityBackward();
                }
            }
            return dirType;
        }

        private final byte $$robo$$android_text_BidiFormatter_DirectionalityEstimator$skipTagForward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex < this.length) {
                this.lastChar = this.text.charAt(this.charIndex++);
                if (this.lastChar == '>') {
                    return 12;
                }
                if (this.lastChar != '\"' && this.lastChar != '\'') continue;
                char quote = this.lastChar;
                while (this.charIndex < this.length && (this.lastChar = this.text.charAt(this.charIndex++)) != quote) {
                }
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)60;
            return 13;
        }

        private final byte $$robo$$android_text_BidiFormatter_DirectionalityEstimator$skipTagBackward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex > 0) {
                this.lastChar = this.text.charAt(--this.charIndex);
                if (this.lastChar == '<') {
                    return 12;
                }
                if (this.lastChar == '>') break;
                if (this.lastChar != '\"' && this.lastChar != '\'') continue;
                char quote = this.lastChar;
                while (this.charIndex > 0 && (this.lastChar = this.text.charAt(--this.charIndex)) != quote) {
                }
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)62;
            return 13;
        }

        private final byte $$robo$$android_text_BidiFormatter_DirectionalityEstimator$skipEntityForward() {
            while (this.charIndex < this.length && (this.lastChar = this.text.charAt(this.charIndex++)) != ';') {
            }
            return 12;
        }

        private final byte $$robo$$android_text_BidiFormatter_DirectionalityEstimator$skipEntityBackward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex > 0) {
                this.lastChar = this.text.charAt(--this.charIndex);
                if (this.lastChar == '&') {
                    return 12;
                }
                if (this.lastChar != ';') continue;
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)59;
            return 13;
        }

        static void __staticInitializer__() {
            DIR_TYPE_CACHE = new byte[1792];
            for (int i = 0; i < 1792; ++i) {
                DirectionalityEstimator.DIR_TYPE_CACHE[i] = Character.getDirectionality(i);
            }
        }

        private static byte getDirectionality(int n) {
            return (byte)InvokeDynamicSupport.bootstrapStatic("getDirectionality", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$getDirectionality(int ), (int)n);
        }

        private void __constructor__(CharSequence charSequence, boolean bl) {
            this.$$robo$$android_text_BidiFormatter_DirectionalityEstimator$__constructor__(charSequence, bl);
        }

        public DirectionalityEstimator(CharSequence charSequence, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$__constructor__(java.lang.CharSequence boolean ), this, charSequence, bl);
        }

        int getEntryDir() {
            return (int)InvokeDynamicSupport.bootstrap("getEntryDir", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$getEntryDir(), this);
        }

        int getExitDir() {
            return (int)InvokeDynamicSupport.bootstrap("getExitDir", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$getExitDir(), this);
        }

        private static byte getCachedDirectionality(char c) {
            return (byte)InvokeDynamicSupport.bootstrapStatic("getCachedDirectionality", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$getCachedDirectionality(char ), (char)c);
        }

        byte dirTypeForward() {
            return (byte)InvokeDynamicSupport.bootstrap("dirTypeForward", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$dirTypeForward(), this);
        }

        byte dirTypeBackward() {
            return (byte)InvokeDynamicSupport.bootstrap("dirTypeBackward", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$dirTypeBackward(), this);
        }

        private byte skipTagForward() {
            return (byte)InvokeDynamicSupport.bootstrap("skipTagForward", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$skipTagForward(), this);
        }

        private byte skipTagBackward() {
            return (byte)InvokeDynamicSupport.bootstrap("skipTagBackward", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$skipTagBackward(), this);
        }

        private byte skipEntityForward() {
            return (byte)InvokeDynamicSupport.bootstrap("skipEntityForward", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$skipEntityForward(), this);
        }

        private byte skipEntityBackward() {
            return (byte)InvokeDynamicSupport.bootstrap("skipEntityBackward", $$robo$$android_text_BidiFormatter_DirectionalityEstimator$skipEntityBackward(), this);
        }

        static {
            RobolectricInternals.classInitializing(DirectionalityEstimator.class);
        }

        public /* synthetic */ DirectionalityEstimator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DirectionalityEstimator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mIsRtlContext;
        private int mFlags;
        private TextDirectionHeuristic mTextDirectionHeuristic;

        private void $$robo$$android_text_BidiFormatter_Builder$__constructor__() {
            this.initialize(BidiFormatter.isRtlLocale(Locale.getDefault()));
        }

        private void $$robo$$android_text_BidiFormatter_Builder$__constructor__(boolean rtlContext) {
            this.initialize(rtlContext);
        }

        private void $$robo$$android_text_BidiFormatter_Builder$__constructor__(Locale locale) {
            this.initialize(BidiFormatter.isRtlLocale(locale));
        }

        private final void $$robo$$android_text_BidiFormatter_Builder$initialize(boolean isRtlContext) {
            this.mIsRtlContext = isRtlContext;
            this.mTextDirectionHeuristic = DEFAULT_TEXT_DIRECTION_HEURISTIC;
            this.mFlags = 2;
        }

        private final Builder $$robo$$android_text_BidiFormatter_Builder$stereoReset(boolean stereoReset) {
            this.mFlags = stereoReset ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
            return this;
        }

        private final Builder $$robo$$android_text_BidiFormatter_Builder$setTextDirectionHeuristic(TextDirectionHeuristic heuristic) {
            this.mTextDirectionHeuristic = heuristic;
            return this;
        }

        private final BidiFormatter $$robo$$android_text_BidiFormatter_Builder$build() {
            if (this.mFlags == 2 && this.mTextDirectionHeuristic == DEFAULT_TEXT_DIRECTION_HEURISTIC) {
                return BidiFormatter.getDefaultInstanceFromContext(this.mIsRtlContext);
            }
            return new BidiFormatter(this.mIsRtlContext, this.mFlags, this.mTextDirectionHeuristic, null);
        }

        private void __constructor__() {
            this.$$robo$$android_text_BidiFormatter_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BidiFormatter_Builder$__constructor__(), this);
        }

        private void __constructor__(boolean bl) {
            this.$$robo$$android_text_BidiFormatter_Builder$__constructor__(bl);
        }

        public Builder(boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BidiFormatter_Builder$__constructor__(boolean ), this, bl);
        }

        private void __constructor__(Locale locale) {
            this.$$robo$$android_text_BidiFormatter_Builder$__constructor__(locale);
        }

        public Builder(Locale locale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_BidiFormatter_Builder$__constructor__(java.util.Locale ), this, locale);
        }

        private void initialize(boolean bl) {
            InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_text_BidiFormatter_Builder$initialize(boolean ), this, bl);
        }

        public Builder stereoReset(boolean bl) {
            return InvokeDynamicSupport.bootstrap("stereoReset", $$robo$$android_text_BidiFormatter_Builder$stereoReset(boolean ), this, bl);
        }

        public Builder setTextDirectionHeuristic(TextDirectionHeuristic textDirectionHeuristic) {
            return InvokeDynamicSupport.bootstrap("setTextDirectionHeuristic", $$robo$$android_text_BidiFormatter_Builder$setTextDirectionHeuristic(android.text.TextDirectionHeuristic ), this, textDirectionHeuristic);
        }

        public BidiFormatter build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_text_BidiFormatter_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

