/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PhoneAccount
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String EXTRA_CALL_SUBJECT_MAX_LENGTH = "android.telecom.extra.CALL_SUBJECT_MAX_LENGTH";
    public static String EXTRA_CALL_SUBJECT_CHARACTER_ENCODING = "android.telecom.extra.CALL_SUBJECT_CHARACTER_ENCODING";
    public static int CAPABILITY_CONNECTION_MANAGER = 1;
    public static int CAPABILITY_CALL_PROVIDER = 2;
    public static int CAPABILITY_SIM_SUBSCRIPTION = 4;
    public static int CAPABILITY_VIDEO_CALLING = 8;
    public static int CAPABILITY_PLACE_EMERGENCY_CALLS = 16;
    public static int CAPABILITY_MULTI_USER = 32;
    public static int CAPABILITY_CALL_SUBJECT = 64;
    public static int CAPABILITY_EMERGENCY_CALLS_ONLY = 128;
    public static int CAPABILITY_VIDEO_CALLING_RELIES_ON_PRESENCE = 256;
    public static int CAPABILITY_EMERGENCY_VIDEO_CALLING = 512;
    public static int CAPABILITY_SUPPORTS_VIDEO_CALLING = 1024;
    public static int CAPABILITY_SELF_MANAGED = 2048;
    public static int CAPABILITY_RTT = 4096;
    public static String SCHEME_TEL = "tel";
    public static String SCHEME_VOICEMAIL = "voicemail";
    public static String SCHEME_SIP = "sip";
    public static int NO_ICON_TINT = 0;
    public static int NO_HIGHLIGHT_COLOR = 0;
    public static int NO_RESOURCE_ID = -1;
    private PhoneAccountHandle mAccountHandle;
    private Uri mAddress;
    private Uri mSubscriptionAddress;
    private int mCapabilities;
    private int mHighlightColor;
    private CharSequence mLabel;
    private CharSequence mShortDescription;
    private List<String> mSupportedUriSchemes;
    private int mSupportedAudioRoutes;
    private Icon mIcon;
    private Bundle mExtras;
    private boolean mIsEnabled;
    private String mGroupId;
    public static Parcelable.Creator<PhoneAccount> CREATOR;

    private void $$robo$$android_telecom_PhoneAccount$__constructor__(PhoneAccountHandle account, Uri address, Uri subscriptionAddress, int capabilities, Icon icon, int highlightColor, CharSequence label, CharSequence shortDescription, List<String> supportedUriSchemes, Bundle extras, int supportedAudioRoutes, boolean isEnabled, String groupId) {
        this.mAccountHandle = account;
        this.mAddress = address;
        this.mSubscriptionAddress = subscriptionAddress;
        this.mCapabilities = capabilities;
        this.mIcon = icon;
        this.mHighlightColor = highlightColor;
        this.mLabel = label;
        this.mShortDescription = shortDescription;
        this.mSupportedUriSchemes = Collections.unmodifiableList(supportedUriSchemes);
        this.mExtras = extras;
        this.mSupportedAudioRoutes = supportedAudioRoutes;
        this.mIsEnabled = isEnabled;
        this.mGroupId = groupId;
    }

    private static final Builder $$robo$$android_telecom_PhoneAccount$builder(PhoneAccountHandle accountHandle, CharSequence label) {
        return new Builder(accountHandle, label);
    }

    private final Builder $$robo$$android_telecom_PhoneAccount$toBuilder() {
        return new Builder(this);
    }

    private final PhoneAccountHandle $$robo$$android_telecom_PhoneAccount$getAccountHandle() {
        return this.mAccountHandle;
    }

    private final Uri $$robo$$android_telecom_PhoneAccount$getAddress() {
        return this.mAddress;
    }

    private final Uri $$robo$$android_telecom_PhoneAccount$getSubscriptionAddress() {
        return this.mSubscriptionAddress;
    }

    private final int $$robo$$android_telecom_PhoneAccount$getCapabilities() {
        return this.mCapabilities;
    }

    private final boolean $$robo$$android_telecom_PhoneAccount$hasCapabilities(int capability) {
        return (this.mCapabilities & capability) == capability;
    }

    private final boolean $$robo$$android_telecom_PhoneAccount$hasAudioRoutes(int routes) {
        return (this.mSupportedAudioRoutes & routes) == routes;
    }

    private final CharSequence $$robo$$android_telecom_PhoneAccount$getLabel() {
        return this.mLabel;
    }

    private final CharSequence $$robo$$android_telecom_PhoneAccount$getShortDescription() {
        return this.mShortDescription;
    }

    private final List<String> $$robo$$android_telecom_PhoneAccount$getSupportedUriSchemes() {
        return this.mSupportedUriSchemes;
    }

    private final Bundle $$robo$$android_telecom_PhoneAccount$getExtras() {
        return this.mExtras;
    }

    private final int $$robo$$android_telecom_PhoneAccount$getSupportedAudioRoutes() {
        return this.mSupportedAudioRoutes;
    }

    private final Icon $$robo$$android_telecom_PhoneAccount$getIcon() {
        return this.mIcon;
    }

    private final boolean $$robo$$android_telecom_PhoneAccount$isEnabled() {
        return this.mIsEnabled;
    }

    private final String $$robo$$android_telecom_PhoneAccount$getGroupId() {
        return this.mGroupId;
    }

    private final boolean $$robo$$android_telecom_PhoneAccount$supportsUriScheme(String uriScheme) {
        if (this.mSupportedUriSchemes == null || uriScheme == null) {
            return false;
        }
        for (String scheme : this.mSupportedUriSchemes) {
            if (scheme == null || !scheme.equals(uriScheme)) continue;
            return true;
        }
        return false;
    }

    private final int $$robo$$android_telecom_PhoneAccount$getHighlightColor() {
        return this.mHighlightColor;
    }

    private final void $$robo$$android_telecom_PhoneAccount$setIsEnabled(boolean isEnabled) {
        this.mIsEnabled = isEnabled;
    }

    private final boolean $$robo$$android_telecom_PhoneAccount$isSelfManaged() {
        return (this.mCapabilities & 0x800) == 2048;
    }

    private final int $$robo$$android_telecom_PhoneAccount$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telecom_PhoneAccount$writeToParcel(Parcel out, int flags) {
        if (this.mAccountHandle == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            this.mAccountHandle.writeToParcel(out, flags);
        }
        if (this.mAddress == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            this.mAddress.writeToParcel(out, flags);
        }
        if (this.mSubscriptionAddress == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            this.mSubscriptionAddress.writeToParcel(out, flags);
        }
        out.writeInt(this.mCapabilities);
        out.writeInt(this.mHighlightColor);
        out.writeCharSequence(this.mLabel);
        out.writeCharSequence(this.mShortDescription);
        out.writeStringList(this.mSupportedUriSchemes);
        if (this.mIcon == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            this.mIcon.writeToParcel(out, flags);
        }
        out.writeByte((byte)(this.mIsEnabled ? 1 : 0));
        out.writeBundle(this.mExtras);
        out.writeString(this.mGroupId);
        out.writeInt(this.mSupportedAudioRoutes);
    }

    private void $$robo$$android_telecom_PhoneAccount$__constructor__(Parcel in) {
        this.mAccountHandle = in.readInt() > 0 ? PhoneAccountHandle.CREATOR.createFromParcel(in) : null;
        this.mAddress = in.readInt() > 0 ? Uri.CREATOR.createFromParcel(in) : null;
        this.mSubscriptionAddress = in.readInt() > 0 ? Uri.CREATOR.createFromParcel(in) : null;
        this.mCapabilities = in.readInt();
        this.mHighlightColor = in.readInt();
        this.mLabel = in.readCharSequence();
        this.mShortDescription = in.readCharSequence();
        this.mSupportedUriSchemes = Collections.unmodifiableList(in.createStringArrayList());
        this.mIcon = in.readInt() > 0 ? Icon.CREATOR.createFromParcel(in) : null;
        this.mIsEnabled = in.readByte() == 1;
        this.mExtras = in.readBundle();
        this.mGroupId = in.readString();
        this.mSupportedAudioRoutes = in.readInt();
    }

    private final String $$robo$$android_telecom_PhoneAccount$toString() {
        StringBuilder sb = new StringBuilder().append("[[").append(this.mIsEnabled ? (char)'X' : ' ').append("] PhoneAccount: ").append(this.mAccountHandle).append(" Capabilities: ").append(this.capabilitiesToString()).append(" Audio Routes: ").append(this.audioRoutesToString()).append(" Schemes: ");
        for (String scheme : this.mSupportedUriSchemes) {
            sb.append(scheme).append(" ");
        }
        sb.append(" Extras: ");
        sb.append(this.mExtras);
        sb.append(" GroupId: ");
        sb.append(Log.pii(this.mGroupId));
        sb.append("]");
        return sb.toString();
    }

    private final String $$robo$$android_telecom_PhoneAccount$capabilitiesToString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasCapabilities(2048)) {
            sb.append("SelfManaged ");
        }
        if (this.hasCapabilities(1024)) {
            sb.append("SuppVideo ");
        }
        if (this.hasCapabilities(8)) {
            sb.append("Video ");
        }
        if (this.hasCapabilities(256)) {
            sb.append("Presence ");
        }
        if (this.hasCapabilities(2)) {
            sb.append("CallProvider ");
        }
        if (this.hasCapabilities(64)) {
            sb.append("CallSubject ");
        }
        if (this.hasCapabilities(1)) {
            sb.append("ConnectionMgr ");
        }
        if (this.hasCapabilities(128)) {
            sb.append("EmergOnly ");
        }
        if (this.hasCapabilities(32)) {
            sb.append("MultiUser ");
        }
        if (this.hasCapabilities(16)) {
            sb.append("PlaceEmerg ");
        }
        if (this.hasCapabilities(512)) {
            sb.append("EmergVideo ");
        }
        if (this.hasCapabilities(4)) {
            sb.append("SimSub ");
        }
        return sb.toString();
    }

    private final String $$robo$$android_telecom_PhoneAccount$audioRoutesToString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasAudioRoutes(2)) {
            sb.append("B");
        }
        if (this.hasAudioRoutes(1)) {
            sb.append("E");
        }
        if (this.hasAudioRoutes(8)) {
            sb.append("S");
        }
        if (this.hasAudioRoutes(4)) {
            sb.append("W");
        }
        return sb.toString();
    }

    private /* synthetic */ void $$robo$$android_telecom_PhoneAccount$__constructor__(PhoneAccountHandle x0, Uri x1, Uri x2, int x3, Icon x4, int x5, CharSequence x6, CharSequence x7, List x8, Bundle x9, int x10, boolean x11, String x12, 1 x13) {
    }

    private /* synthetic */ void $$robo$$android_telecom_PhoneAccount$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PhoneAccount>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telecom_PhoneAccount_1$__constructor__() {
            }

            private final PhoneAccount $$robo$$android_telecom_PhoneAccount_1$createFromParcel(Parcel in) {
                return new PhoneAccount(in, null);
            }

            private final PhoneAccount[] $$robo$$android_telecom_PhoneAccount_1$newArray(int size) {
                return new PhoneAccount[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telecom_PhoneAccount_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount_1$__constructor__(), this);
            }

            @Override
            public PhoneAccount createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telecom_PhoneAccount_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public PhoneAccount[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telecom_PhoneAccount_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(PhoneAccountHandle phoneAccountHandle, Uri uri, Uri uri2, int n, Icon icon, int n2, CharSequence charSequence, CharSequence charSequence2, List<String> list, Bundle bundle, int n3, boolean bl, String string2) {
        this.$$robo$$android_telecom_PhoneAccount$__constructor__(phoneAccountHandle, uri, uri2, n, icon, n2, charSequence, charSequence2, list, bundle, n3, bl, string2);
    }

    public PhoneAccount(PhoneAccountHandle phoneAccountHandle, Uri uri, Uri uri2, int n, Icon icon, int n2, CharSequence charSequence, CharSequence charSequence2, List<String> list, Bundle bundle, int n3, boolean bl, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount$__constructor__(android.telecom.PhoneAccountHandle android.net.Uri android.net.Uri int android.graphics.drawable.Icon int java.lang.CharSequence java.lang.CharSequence java.util.List<java.lang.String> android.os.Bundle int boolean java.lang.String ), this, phoneAccountHandle, uri, uri2, n, icon, n2, charSequence, charSequence2, list, bundle, n3, bl, string2);
    }

    public static Builder builder(PhoneAccountHandle phoneAccountHandle, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("builder", $$robo$$android_telecom_PhoneAccount$builder(android.telecom.PhoneAccountHandle java.lang.CharSequence ), (PhoneAccountHandle)phoneAccountHandle, (CharSequence)charSequence);
    }

    public Builder toBuilder() {
        return InvokeDynamicSupport.bootstrap("toBuilder", $$robo$$android_telecom_PhoneAccount$toBuilder(), this);
    }

    public PhoneAccountHandle getAccountHandle() {
        return InvokeDynamicSupport.bootstrap("getAccountHandle", $$robo$$android_telecom_PhoneAccount$getAccountHandle(), this);
    }

    public Uri getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_telecom_PhoneAccount$getAddress(), this);
    }

    public Uri getSubscriptionAddress() {
        return InvokeDynamicSupport.bootstrap("getSubscriptionAddress", $$robo$$android_telecom_PhoneAccount$getSubscriptionAddress(), this);
    }

    public int getCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_telecom_PhoneAccount$getCapabilities(), this);
    }

    public boolean hasCapabilities(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCapabilities", $$robo$$android_telecom_PhoneAccount$hasCapabilities(int ), this, n);
    }

    public boolean hasAudioRoutes(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAudioRoutes", $$robo$$android_telecom_PhoneAccount$hasAudioRoutes(int ), this, n);
    }

    public CharSequence getLabel() {
        return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_telecom_PhoneAccount$getLabel(), this);
    }

    public CharSequence getShortDescription() {
        return InvokeDynamicSupport.bootstrap("getShortDescription", $$robo$$android_telecom_PhoneAccount$getShortDescription(), this);
    }

    public List<String> getSupportedUriSchemes() {
        return InvokeDynamicSupport.bootstrap("getSupportedUriSchemes", $$robo$$android_telecom_PhoneAccount$getSupportedUriSchemes(), this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_telecom_PhoneAccount$getExtras(), this);
    }

    public int getSupportedAudioRoutes() {
        return (int)InvokeDynamicSupport.bootstrap("getSupportedAudioRoutes", $$robo$$android_telecom_PhoneAccount$getSupportedAudioRoutes(), this);
    }

    public Icon getIcon() {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_telecom_PhoneAccount$getIcon(), this);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_telecom_PhoneAccount$isEnabled(), this);
    }

    public String getGroupId() {
        return InvokeDynamicSupport.bootstrap("getGroupId", $$robo$$android_telecom_PhoneAccount$getGroupId(), this);
    }

    public boolean supportsUriScheme(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsUriScheme", $$robo$$android_telecom_PhoneAccount$supportsUriScheme(java.lang.String ), this, string2);
    }

    public int getHighlightColor() {
        return (int)InvokeDynamicSupport.bootstrap("getHighlightColor", $$robo$$android_telecom_PhoneAccount$getHighlightColor(), this);
    }

    public void setIsEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsEnabled", $$robo$$android_telecom_PhoneAccount$setIsEnabled(boolean ), this, bl);
    }

    public boolean isSelfManaged() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSelfManaged", $$robo$$android_telecom_PhoneAccount$isSelfManaged(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telecom_PhoneAccount$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telecom_PhoneAccount$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telecom_PhoneAccount$__constructor__(parcel);
    }

    public PhoneAccount(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount$__constructor__(android.os.Parcel ), this, parcel);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telecom_PhoneAccount$toString(), this);
    }

    private String capabilitiesToString() {
        return InvokeDynamicSupport.bootstrap("capabilitiesToString", $$robo$$android_telecom_PhoneAccount$capabilitiesToString(), this);
    }

    private String audioRoutesToString() {
        return InvokeDynamicSupport.bootstrap("audioRoutesToString", $$robo$$android_telecom_PhoneAccount$audioRoutesToString(), this);
    }

    private /* synthetic */ void __constructor__(PhoneAccountHandle phoneAccountHandle, Uri uri, Uri uri2, int n, Icon icon, int n2, CharSequence charSequence, CharSequence charSequence2, List list, Bundle bundle, int n3, boolean bl, String string2, 1 var14_14) {
        this.$$robo$$android_telecom_PhoneAccount$__constructor__(phoneAccountHandle, uri, uri2, n, icon, n2, charSequence, charSequence2, list, bundle, n3, bl, string2, var14_14);
    }

    public /* synthetic */ PhoneAccount(PhoneAccountHandle phoneAccountHandle, Uri uri, Uri uri2, int n, Icon icon, int n2, CharSequence charSequence, CharSequence charSequence2, List list, Bundle bundle, int n3, boolean bl, String string2, 1 var14_14) {
        this(phoneAccountHandle, uri, uri2, n, icon, n2, charSequence, charSequence2, list, bundle, n3, bl, string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount$__constructor__(android.telecom.PhoneAccountHandle android.net.Uri android.net.Uri int android.graphics.drawable.Icon int java.lang.CharSequence java.lang.CharSequence java.util.List android.os.Bundle int boolean java.lang.String android.telecom.PhoneAccount$1 ), this, phoneAccountHandle, uri, uri2, n, icon, n2, charSequence, charSequence2, list, bundle, n3, bl, string2, var14_14);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_telecom_PhoneAccount$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ PhoneAccount(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount$__constructor__(android.os.Parcel android.telecom.PhoneAccount$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PhoneAccount.class);
    }

    public /* synthetic */ PhoneAccount() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneAccount)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private PhoneAccountHandle mAccountHandle;
        private Uri mAddress;
        private Uri mSubscriptionAddress;
        private int mCapabilities;
        private int mSupportedAudioRoutes;
        private int mHighlightColor;
        private CharSequence mLabel;
        private CharSequence mShortDescription;
        private List<String> mSupportedUriSchemes;
        private Icon mIcon;
        private Bundle mExtras;
        private boolean mIsEnabled;
        private String mGroupId;

        private void $$robo$$android_telecom_PhoneAccount_Builder$__constructor__(PhoneAccountHandle accountHandle, CharSequence label) {
            this.mSupportedAudioRoutes = 15;
            this.mHighlightColor = 0;
            this.mSupportedUriSchemes = new ArrayList<String>();
            this.mIsEnabled = false;
            this.mGroupId = "";
            this.mAccountHandle = accountHandle;
            this.mLabel = label;
        }

        private void $$robo$$android_telecom_PhoneAccount_Builder$__constructor__(PhoneAccount phoneAccount) {
            this.mSupportedAudioRoutes = 15;
            this.mHighlightColor = 0;
            this.mSupportedUriSchemes = new ArrayList<String>();
            this.mIsEnabled = false;
            this.mGroupId = "";
            this.mAccountHandle = phoneAccount.getAccountHandle();
            this.mAddress = phoneAccount.getAddress();
            this.mSubscriptionAddress = phoneAccount.getSubscriptionAddress();
            this.mCapabilities = phoneAccount.getCapabilities();
            this.mHighlightColor = phoneAccount.getHighlightColor();
            this.mLabel = phoneAccount.getLabel();
            this.mShortDescription = phoneAccount.getShortDescription();
            this.mSupportedUriSchemes.addAll(phoneAccount.getSupportedUriSchemes());
            this.mIcon = phoneAccount.getIcon();
            this.mIsEnabled = phoneAccount.isEnabled();
            this.mExtras = phoneAccount.getExtras();
            this.mGroupId = phoneAccount.getGroupId();
            this.mSupportedAudioRoutes = phoneAccount.getSupportedAudioRoutes();
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setLabel(CharSequence label) {
            this.mLabel = label;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setAddress(Uri value) {
            this.mAddress = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setSubscriptionAddress(Uri value) {
            this.mSubscriptionAddress = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setCapabilities(int value) {
            this.mCapabilities = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setIcon(Icon icon) {
            this.mIcon = icon;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setHighlightColor(int value) {
            this.mHighlightColor = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setShortDescription(CharSequence value) {
            this.mShortDescription = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$addSupportedUriScheme(String uriScheme) {
            if (!TextUtils.isEmpty(uriScheme) && !this.mSupportedUriSchemes.contains(uriScheme)) {
                this.mSupportedUriSchemes.add(uriScheme);
            }
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setSupportedUriSchemes(List<String> uriSchemes) {
            this.mSupportedUriSchemes.clear();
            if (uriSchemes != null && !uriSchemes.isEmpty()) {
                for (String uriScheme : uriSchemes) {
                    this.addSupportedUriScheme(uriScheme);
                }
            }
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setExtras(Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setIsEnabled(boolean isEnabled) {
            this.mIsEnabled = isEnabled;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setGroupId(String groupId) {
            this.mGroupId = groupId != null ? groupId : "";
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setSupportedAudioRoutes(int routes) {
            this.mSupportedAudioRoutes = routes;
            return this;
        }

        private final PhoneAccount $$robo$$android_telecom_PhoneAccount_Builder$build() {
            if (this.mSupportedUriSchemes.isEmpty()) {
                this.addSupportedUriScheme("tel");
            }
            return new PhoneAccount(this.mAccountHandle, this.mAddress, this.mSubscriptionAddress, this.mCapabilities, this.mIcon, this.mHighlightColor, this.mLabel, this.mShortDescription, this.mSupportedUriSchemes, this.mExtras, this.mSupportedAudioRoutes, this.mIsEnabled, this.mGroupId, null);
        }

        private void __constructor__(PhoneAccountHandle phoneAccountHandle, CharSequence charSequence) {
            this.$$robo$$android_telecom_PhoneAccount_Builder$__constructor__(phoneAccountHandle, charSequence);
        }

        public Builder(PhoneAccountHandle phoneAccountHandle, CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount_Builder$__constructor__(android.telecom.PhoneAccountHandle java.lang.CharSequence ), this, phoneAccountHandle, charSequence);
        }

        private void __constructor__(PhoneAccount phoneAccount) {
            this.$$robo$$android_telecom_PhoneAccount_Builder$__constructor__(phoneAccount);
        }

        public Builder(PhoneAccount phoneAccount) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount_Builder$__constructor__(android.telecom.PhoneAccount ), this, phoneAccount);
        }

        public Builder setLabel(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_telecom_PhoneAccount_Builder$setLabel(java.lang.CharSequence ), this, charSequence);
        }

        public Builder setAddress(Uri uri) {
            return InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_PhoneAccount_Builder$setAddress(android.net.Uri ), this, uri);
        }

        public Builder setSubscriptionAddress(Uri uri) {
            return InvokeDynamicSupport.bootstrap("setSubscriptionAddress", $$robo$$android_telecom_PhoneAccount_Builder$setSubscriptionAddress(android.net.Uri ), this, uri);
        }

        public Builder setCapabilities(int n) {
            return InvokeDynamicSupport.bootstrap("setCapabilities", $$robo$$android_telecom_PhoneAccount_Builder$setCapabilities(int ), this, n);
        }

        public Builder setIcon(Icon icon) {
            return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_telecom_PhoneAccount_Builder$setIcon(android.graphics.drawable.Icon ), this, icon);
        }

        public Builder setHighlightColor(int n) {
            return InvokeDynamicSupport.bootstrap("setHighlightColor", $$robo$$android_telecom_PhoneAccount_Builder$setHighlightColor(int ), this, n);
        }

        public Builder setShortDescription(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setShortDescription", $$robo$$android_telecom_PhoneAccount_Builder$setShortDescription(java.lang.CharSequence ), this, charSequence);
        }

        public Builder addSupportedUriScheme(String string2) {
            return InvokeDynamicSupport.bootstrap("addSupportedUriScheme", $$robo$$android_telecom_PhoneAccount_Builder$addSupportedUriScheme(java.lang.String ), this, string2);
        }

        public Builder setSupportedUriSchemes(List<String> list) {
            return InvokeDynamicSupport.bootstrap("setSupportedUriSchemes", $$robo$$android_telecom_PhoneAccount_Builder$setSupportedUriSchemes(java.util.List<java.lang.String> ), this, list);
        }

        public Builder setExtras(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_telecom_PhoneAccount_Builder$setExtras(android.os.Bundle ), this, bundle);
        }

        public Builder setIsEnabled(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setIsEnabled", $$robo$$android_telecom_PhoneAccount_Builder$setIsEnabled(boolean ), this, bl);
        }

        public Builder setGroupId(String string2) {
            return InvokeDynamicSupport.bootstrap("setGroupId", $$robo$$android_telecom_PhoneAccount_Builder$setGroupId(java.lang.String ), this, string2);
        }

        public Builder setSupportedAudioRoutes(int n) {
            return InvokeDynamicSupport.bootstrap("setSupportedAudioRoutes", $$robo$$android_telecom_PhoneAccount_Builder$setSupportedAudioRoutes(int ), this, n);
        }

        public PhoneAccount build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_telecom_PhoneAccount_Builder$build(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

