/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Bundle;
import android.telecom.AudioState;
import android.telecom.Call;
import android.telecom.CallAudioState;
import android.telecom.Conferenceable;
import android.telecom.Connection;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Conference
extends Conferenceable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static long CONNECT_TIME_NOT_SPECIFIED = 0L;
    private Set<Listener> mListeners;
    private List<Connection> mChildConnections;
    private List<Connection> mUnmodifiableChildConnections;
    private List<Connection> mConferenceableConnections;
    private List<Connection> mUnmodifiableConferenceableConnections;
    private String mTelecomCallId;
    private PhoneAccountHandle mPhoneAccount;
    private CallAudioState mCallAudioState;
    private int mState;
    private DisconnectCause mDisconnectCause;
    private int mConnectionCapabilities;
    private int mConnectionProperties;
    private String mDisconnectMessage;
    private long mConnectTimeMillis;
    private StatusHints mStatusHints;
    private Bundle mExtras;
    private Set<String> mPreviousExtraKeys;
    private Object mExtrasLock;
    private Connection.Listener mConnectionDeathListener;

    private void $$robo$$android_telecom_Conference$__constructor__(PhoneAccountHandle phoneAccount) {
        this.mListeners = new CopyOnWriteArraySet<Listener>();
        this.mChildConnections = new CopyOnWriteArrayList<Connection>();
        this.mUnmodifiableChildConnections = Collections.unmodifiableList(this.mChildConnections);
        this.mConferenceableConnections = new ArrayList<Connection>();
        this.mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mConnectTimeMillis = 0L;
        this.mExtrasLock = new Object();
        this.mConnectionDeathListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Conference this$0;

            private void $$robo$$android_telecom_Conference_1$__constructor__(Conference this$0) {
            }

            private final void $$robo$$android_telecom_Conference_1$onDestroyed(Connection c) {
                if (this.this$0.mConferenceableConnections.remove(c)) {
                    this.this$0.fireOnConferenceableConnectionsChanged();
                }
            }

            private void __constructor__(Conference conference) {
                this.$$robo$$android_telecom_Conference_1$__constructor__(conference);
            }
            {
                this.this$0 = conference;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Conference_1$__constructor__(android.telecom.Conference ), this, conference);
            }

            @Override
            public void onDestroyed(Connection connection) {
                InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Conference_1$onDestroyed(android.telecom.Connection ), this, connection);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhoneAccount = phoneAccount;
    }

    private final String $$robo$$android_telecom_Conference$getTelecomCallId() {
        return this.mTelecomCallId;
    }

    private final void $$robo$$android_telecom_Conference$setTelecomCallId(String telecomCallId) {
        this.mTelecomCallId = telecomCallId;
    }

    private final PhoneAccountHandle $$robo$$android_telecom_Conference$getPhoneAccountHandle() {
        return this.mPhoneAccount;
    }

    private final List<Connection> $$robo$$android_telecom_Conference$getConnections() {
        return this.mUnmodifiableChildConnections;
    }

    private final int $$robo$$android_telecom_Conference$getState() {
        return this.mState;
    }

    private final int $$robo$$android_telecom_Conference$getConnectionCapabilities() {
        return this.mConnectionCapabilities;
    }

    private final int $$robo$$android_telecom_Conference$getConnectionProperties() {
        return this.mConnectionProperties;
    }

    private static final boolean $$robo$$android_telecom_Conference$can(int capabilities, int capability) {
        return (capabilities & capability) != 0;
    }

    private final boolean $$robo$$android_telecom_Conference$can(int capability) {
        return Conference.can(this.mConnectionCapabilities, capability);
    }

    private final void $$robo$$android_telecom_Conference$removeCapability(int capability) {
        int newCapabilities = this.mConnectionCapabilities;
        this.setConnectionCapabilities(newCapabilities &= ~capability);
    }

    private final void $$robo$$android_telecom_Conference$addCapability(int capability) {
        int newCapabilities = this.mConnectionCapabilities;
        this.setConnectionCapabilities(newCapabilities |= capability);
    }

    @Deprecated
    private final AudioState $$robo$$android_telecom_Conference$getAudioState() {
        return new AudioState(this.mCallAudioState);
    }

    private final CallAudioState $$robo$$android_telecom_Conference$getCallAudioState() {
        return this.mCallAudioState;
    }

    private final Connection.VideoProvider $$robo$$android_telecom_Conference$getVideoProvider() {
        return null;
    }

    private final int $$robo$$android_telecom_Conference$getVideoState() {
        return 0;
    }

    private final void $$robo$$android_telecom_Conference$onDisconnect() {
    }

    private final void $$robo$$android_telecom_Conference$onSeparate(Connection connection) {
    }

    private final void $$robo$$android_telecom_Conference$onMerge(Connection connection) {
    }

    private final void $$robo$$android_telecom_Conference$onHold() {
    }

    private final void $$robo$$android_telecom_Conference$onUnhold() {
    }

    private final void $$robo$$android_telecom_Conference$onMerge() {
    }

    private final void $$robo$$android_telecom_Conference$onSwap() {
    }

    private final void $$robo$$android_telecom_Conference$onPlayDtmfTone(char c) {
    }

    private final void $$robo$$android_telecom_Conference$onStopDtmfTone() {
    }

    @Deprecated
    private final void $$robo$$android_telecom_Conference$onAudioStateChanged(AudioState state) {
    }

    private final void $$robo$$android_telecom_Conference$onCallAudioStateChanged(CallAudioState state) {
    }

    private final void $$robo$$android_telecom_Conference$onConnectionAdded(Connection connection) {
    }

    private final void $$robo$$android_telecom_Conference$setOnHold() {
        this.setState(5);
    }

    private final void $$robo$$android_telecom_Conference$setDialing() {
        this.setState(3);
    }

    private final void $$robo$$android_telecom_Conference$setActive() {
        this.setState(4);
    }

    private final void $$robo$$android_telecom_Conference$setDisconnected(DisconnectCause disconnectCause) {
        this.mDisconnectCause = disconnectCause;
        this.setState(6);
        for (Listener l : this.mListeners) {
            l.onDisconnected(this, this.mDisconnectCause);
        }
    }

    private final DisconnectCause $$robo$$android_telecom_Conference$getDisconnectCause() {
        return this.mDisconnectCause;
    }

    private final void $$robo$$android_telecom_Conference$setConnectionCapabilities(int connectionCapabilities) {
        if (connectionCapabilities != this.mConnectionCapabilities) {
            this.mConnectionCapabilities = connectionCapabilities;
            for (Listener l : this.mListeners) {
                l.onConnectionCapabilitiesChanged(this, this.mConnectionCapabilities);
            }
        }
    }

    private final void $$robo$$android_telecom_Conference$setConnectionProperties(int connectionProperties) {
        if (connectionProperties != this.mConnectionProperties) {
            this.mConnectionProperties = connectionProperties;
            for (Listener l : this.mListeners) {
                l.onConnectionPropertiesChanged(this, this.mConnectionProperties);
            }
        }
    }

    private final boolean $$robo$$android_telecom_Conference$addConnection(Connection connection) {
        Log.d(this, "Connection=%s, connection=", connection);
        if (connection != null && !this.mChildConnections.contains(connection) && connection.setConference(this)) {
            this.mChildConnections.add(connection);
            this.onConnectionAdded(connection);
            for (Listener l : this.mListeners) {
                l.onConnectionAdded(this, connection);
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_telecom_Conference$removeConnection(Connection connection) {
        Log.d(this, "removing %s from %s", connection, this.mChildConnections);
        if (connection != null && this.mChildConnections.remove(connection)) {
            connection.resetConference();
            for (Listener l : this.mListeners) {
                l.onConnectionRemoved(this, connection);
            }
        }
    }

    private final void $$robo$$android_telecom_Conference$setConferenceableConnections(List<Connection> conferenceableConnections) {
        if (Objects.equals(this.mConferenceableConnections, conferenceableConnections)) {
            return;
        }
        this.clearConferenceableList();
        for (Connection c : conferenceableConnections) {
            if (this.mConferenceableConnections.contains(c)) continue;
            c.addConnectionListener(this.mConnectionDeathListener);
            this.mConferenceableConnections.add(c);
        }
        this.fireOnConferenceableConnectionsChanged();
    }

    private final void $$robo$$android_telecom_Conference$setVideoState(Connection c, int videoState) {
        Log.d(this, "setVideoState Conference: %s Connection: %s VideoState: %s", this, c, videoState);
        for (Listener l : this.mListeners) {
            l.onVideoStateChanged(this, videoState);
        }
    }

    private final void $$robo$$android_telecom_Conference$setVideoProvider(Connection c, Connection.VideoProvider videoProvider) {
        Log.d(this, "setVideoProvider Conference: %s Connection: %s VideoState: %s", this, c, videoProvider);
        for (Listener l : this.mListeners) {
            l.onVideoProviderChanged(this, videoProvider);
        }
    }

    private final void $$robo$$android_telecom_Conference$fireOnConferenceableConnectionsChanged() {
        for (Listener l : this.mListeners) {
            l.onConferenceableConnectionsChanged(this, this.getConferenceableConnections());
        }
    }

    private final List<Connection> $$robo$$android_telecom_Conference$getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    private final void $$robo$$android_telecom_Conference$destroy() {
        Log.d(this, "destroying conference : %s", this);
        for (Connection connection : this.mChildConnections) {
            Log.d(this, "removing connection %s", connection);
            this.removeConnection(connection);
        }
        if (this.mState != 6) {
            Log.d(this, "setting to disconnected", new Object[0]);
            this.setDisconnected(new DisconnectCause(2));
        }
        for (Listener l : this.mListeners) {
            l.onDestroyed(this);
        }
    }

    private final Conference $$robo$$android_telecom_Conference$addListener(Listener listener) {
        this.mListeners.add(listener);
        return this;
    }

    private final Conference $$robo$$android_telecom_Conference$removeListener(Listener listener) {
        this.mListeners.remove(listener);
        return this;
    }

    private final Connection $$robo$$android_telecom_Conference$getPrimaryConnection() {
        if (this.mUnmodifiableChildConnections == null || this.mUnmodifiableChildConnections.isEmpty()) {
            return null;
        }
        return this.mUnmodifiableChildConnections.get(0);
    }

    @Deprecated
    private final void $$robo$$android_telecom_Conference$setConnectTimeMillis(long connectTimeMillis) {
        this.setConnectionTime(connectTimeMillis);
    }

    private final void $$robo$$android_telecom_Conference$setConnectionTime(long connectionTimeMillis) {
        this.mConnectTimeMillis = connectionTimeMillis;
    }

    @Deprecated
    private final long $$robo$$android_telecom_Conference$getConnectTimeMillis() {
        return this.getConnectionTime();
    }

    private final long $$robo$$android_telecom_Conference$getConnectionTime() {
        return this.mConnectTimeMillis;
    }

    private final void $$robo$$android_telecom_Conference$setCallAudioState(CallAudioState state) {
        Log.d(this, "setCallAudioState %s", state);
        this.mCallAudioState = state;
        this.onAudioStateChanged(this.getAudioState());
        this.onCallAudioStateChanged(state);
    }

    private final void $$robo$$android_telecom_Conference$setState(int newState) {
        if (newState != 4 && newState != 5 && newState != 6) {
            Log.w(this, "Unsupported state transition for Conference call.", Connection.stateToString(newState));
            return;
        }
        if (this.mState != newState) {
            int oldState = this.mState;
            this.mState = newState;
            for (Listener l : this.mListeners) {
                l.onStateChanged(this, oldState, newState);
            }
        }
    }

    private final void $$robo$$android_telecom_Conference$clearConferenceableList() {
        for (Connection c : this.mConferenceableConnections) {
            c.removeConnectionListener(this.mConnectionDeathListener);
        }
        this.mConferenceableConnections.clear();
    }

    private final String $$robo$$android_telecom_Conference$toString() {
        return String.format(Locale.US, "[State: %s,Capabilites: %s, VideoState: %s, VideoProvider: %s, ThisObject %s]", Connection.stateToString(this.mState), Call.Details.capabilitiesToString(this.mConnectionCapabilities), this.getVideoState(), this.getVideoProvider(), super.toString());
    }

    private final void $$robo$$android_telecom_Conference$setStatusHints(StatusHints statusHints) {
        this.mStatusHints = statusHints;
        for (Listener l : this.mListeners) {
            l.onStatusHintsChanged(this, statusHints);
        }
    }

    private final StatusHints $$robo$$android_telecom_Conference$getStatusHints() {
        return this.mStatusHints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Conference$setExtras(Bundle extras) {
        Object object = this.mExtrasLock;
        synchronized (object) {
            this.putExtras(extras);
            if (this.mPreviousExtraKeys != null) {
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String oldKey : this.mPreviousExtraKeys) {
                    if (extras != null && extras.containsKey(oldKey)) continue;
                    toRemove.add(oldKey);
                }
                if (!toRemove.isEmpty()) {
                    this.removeExtras(toRemove);
                }
            }
            if (this.mPreviousExtraKeys == null) {
                this.mPreviousExtraKeys = new ArraySet<String>();
            }
            this.mPreviousExtraKeys.clear();
            if (extras != null) {
                this.mPreviousExtraKeys.addAll(extras.keySet());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Conference$putExtras(Bundle extras) {
        Bundle listenersBundle;
        if (extras == null) {
            return;
        }
        Iterator<Listener> iterator = this.mExtrasLock;
        synchronized (iterator) {
            if (this.mExtras == null) {
                this.mExtras = new Bundle();
            }
            this.mExtras.putAll(extras);
            listenersBundle = new Bundle(this.mExtras);
        }
        for (Listener l : this.mListeners) {
            l.onExtrasChanged(this, new Bundle(listenersBundle));
        }
    }

    private final void $$robo$$android_telecom_Conference$putExtra(String key, boolean value) {
        Bundle newExtras = new Bundle();
        newExtras.putBoolean(key, value);
        this.putExtras(newExtras);
    }

    private final void $$robo$$android_telecom_Conference$putExtra(String key, int value) {
        Bundle newExtras = new Bundle();
        newExtras.putInt(key, value);
        this.putExtras(newExtras);
    }

    private final void $$robo$$android_telecom_Conference$putExtra(String key, String value) {
        Bundle newExtras = new Bundle();
        newExtras.putString(key, value);
        this.putExtras(newExtras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Conference$removeExtras(List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Object object = this.mExtrasLock;
        synchronized (object) {
            if (this.mExtras != null) {
                for (String key : keys) {
                    this.mExtras.remove(key);
                }
            }
        }
        List<String> unmodifiableKeys = Collections.unmodifiableList(keys);
        for (Listener l : this.mListeners) {
            l.onExtrasRemoved(this, unmodifiableKeys);
        }
    }

    private final void $$robo$$android_telecom_Conference$removeExtras(String ... keys) {
        this.removeExtras(Arrays.asList(keys));
    }

    private final Bundle $$robo$$android_telecom_Conference$getExtras() {
        return this.mExtras;
    }

    private final void $$robo$$android_telecom_Conference$onExtrasChanged(Bundle extras) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Conference$handleExtrasChanged(Bundle extras) {
        Bundle b = null;
        Object object = this.mExtrasLock;
        synchronized (object) {
            this.mExtras = extras;
            if (this.mExtras != null) {
                b = new Bundle(this.mExtras);
            }
        }
        this.onExtrasChanged(b);
    }

    private void __constructor__(PhoneAccountHandle phoneAccountHandle) {
        this.$$robo$$android_telecom_Conference$__constructor__(phoneAccountHandle);
    }

    public Conference(PhoneAccountHandle phoneAccountHandle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Conference$__constructor__(android.telecom.PhoneAccountHandle ), this, phoneAccountHandle);
    }

    public String getTelecomCallId() {
        return InvokeDynamicSupport.bootstrap("getTelecomCallId", $$robo$$android_telecom_Conference$getTelecomCallId(), this);
    }

    public void setTelecomCallId(String string2) {
        InvokeDynamicSupport.bootstrap("setTelecomCallId", $$robo$$android_telecom_Conference$setTelecomCallId(java.lang.String ), this, string2);
    }

    public PhoneAccountHandle getPhoneAccountHandle() {
        return InvokeDynamicSupport.bootstrap("getPhoneAccountHandle", $$robo$$android_telecom_Conference$getPhoneAccountHandle(), this);
    }

    public List<Connection> getConnections() {
        return InvokeDynamicSupport.bootstrap("getConnections", $$robo$$android_telecom_Conference$getConnections(), this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_Conference$getState(), this);
    }

    public int getConnectionCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionCapabilities", $$robo$$android_telecom_Conference$getConnectionCapabilities(), this);
    }

    public int getConnectionProperties() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionProperties", $$robo$$android_telecom_Conference$getConnectionProperties(), this);
    }

    public static boolean can(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("can", $$robo$$android_telecom_Conference$can(int int ), (int)n, (int)n2);
    }

    public boolean can(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("can", $$robo$$android_telecom_Conference$can(int ), this, n);
    }

    public void removeCapability(int n) {
        InvokeDynamicSupport.bootstrap("removeCapability", $$robo$$android_telecom_Conference$removeCapability(int ), this, n);
    }

    public void addCapability(int n) {
        InvokeDynamicSupport.bootstrap("addCapability", $$robo$$android_telecom_Conference$addCapability(int ), this, n);
    }

    @Deprecated
    public AudioState getAudioState() {
        return InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_telecom_Conference$getAudioState(), this);
    }

    public CallAudioState getCallAudioState() {
        return InvokeDynamicSupport.bootstrap("getCallAudioState", $$robo$$android_telecom_Conference$getCallAudioState(), this);
    }

    public Connection.VideoProvider getVideoProvider() {
        return InvokeDynamicSupport.bootstrap("getVideoProvider", $$robo$$android_telecom_Conference$getVideoProvider(), this);
    }

    public int getVideoState() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$android_telecom_Conference$getVideoState(), this);
    }

    public void onDisconnect() {
        InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$android_telecom_Conference$onDisconnect(), this);
    }

    public void onSeparate(Connection connection) {
        InvokeDynamicSupport.bootstrap("onSeparate", $$robo$$android_telecom_Conference$onSeparate(android.telecom.Connection ), this, connection);
    }

    public void onMerge(Connection connection) {
        InvokeDynamicSupport.bootstrap("onMerge", $$robo$$android_telecom_Conference$onMerge(android.telecom.Connection ), this, connection);
    }

    public void onHold() {
        InvokeDynamicSupport.bootstrap("onHold", $$robo$$android_telecom_Conference$onHold(), this);
    }

    public void onUnhold() {
        InvokeDynamicSupport.bootstrap("onUnhold", $$robo$$android_telecom_Conference$onUnhold(), this);
    }

    public void onMerge() {
        InvokeDynamicSupport.bootstrap("onMerge", $$robo$$android_telecom_Conference$onMerge(), this);
    }

    public void onSwap() {
        InvokeDynamicSupport.bootstrap("onSwap", $$robo$$android_telecom_Conference$onSwap(), this);
    }

    public void onPlayDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("onPlayDtmfTone", $$robo$$android_telecom_Conference$onPlayDtmfTone(char ), this, c);
    }

    public void onStopDtmfTone() {
        InvokeDynamicSupport.bootstrap("onStopDtmfTone", $$robo$$android_telecom_Conference$onStopDtmfTone(), this);
    }

    @Deprecated
    public void onAudioStateChanged(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_Conference$onAudioStateChanged(android.telecom.AudioState ), this, audioState);
    }

    public void onCallAudioStateChanged(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("onCallAudioStateChanged", $$robo$$android_telecom_Conference$onCallAudioStateChanged(android.telecom.CallAudioState ), this, callAudioState);
    }

    public void onConnectionAdded(Connection connection) {
        InvokeDynamicSupport.bootstrap("onConnectionAdded", $$robo$$android_telecom_Conference$onConnectionAdded(android.telecom.Connection ), this, connection);
    }

    public void setOnHold() {
        InvokeDynamicSupport.bootstrap("setOnHold", $$robo$$android_telecom_Conference$setOnHold(), this);
    }

    public void setDialing() {
        InvokeDynamicSupport.bootstrap("setDialing", $$robo$$android_telecom_Conference$setDialing(), this);
    }

    public void setActive() {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_telecom_Conference$setActive(), this);
    }

    public void setDisconnected(DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_Conference$setDisconnected(android.telecom.DisconnectCause ), this, disconnectCause);
    }

    public DisconnectCause getDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_Conference$getDisconnectCause(), this);
    }

    public void setConnectionCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionCapabilities", $$robo$$android_telecom_Conference$setConnectionCapabilities(int ), this, n);
    }

    public void setConnectionProperties(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionProperties", $$robo$$android_telecom_Conference$setConnectionProperties(int ), this, n);
    }

    public boolean addConnection(Connection connection) {
        return (boolean)InvokeDynamicSupport.bootstrap("addConnection", $$robo$$android_telecom_Conference$addConnection(android.telecom.Connection ), this, connection);
    }

    public void removeConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$android_telecom_Conference$removeConnection(android.telecom.Connection ), this, connection);
    }

    public void setConferenceableConnections(List<Connection> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_Conference$setConferenceableConnections(java.util.List<android.telecom.Connection> ), this, list);
    }

    public void setVideoState(Connection connection, int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_Conference$setVideoState(android.telecom.Connection int ), this, connection, n);
    }

    public void setVideoProvider(Connection connection, Connection.VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$android_telecom_Conference$setVideoProvider(android.telecom.Connection android.telecom.Connection$VideoProvider ), this, connection, videoProvider);
    }

    private void fireOnConferenceableConnectionsChanged() {
        InvokeDynamicSupport.bootstrap("fireOnConferenceableConnectionsChanged", $$robo$$android_telecom_Conference$fireOnConferenceableConnectionsChanged(), this);
    }

    public List<Connection> getConferenceableConnections() {
        return InvokeDynamicSupport.bootstrap("getConferenceableConnections", $$robo$$android_telecom_Conference$getConferenceableConnections(), this);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_telecom_Conference$destroy(), this);
    }

    public Conference addListener(Listener listener) {
        return InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_telecom_Conference$addListener(android.telecom.Conference$Listener ), this, listener);
    }

    public Conference removeListener(Listener listener) {
        return InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_telecom_Conference$removeListener(android.telecom.Conference$Listener ), this, listener);
    }

    public Connection getPrimaryConnection() {
        return InvokeDynamicSupport.bootstrap("getPrimaryConnection", $$robo$$android_telecom_Conference$getPrimaryConnection(), this);
    }

    @Deprecated
    public void setConnectTimeMillis(long l) {
        InvokeDynamicSupport.bootstrap("setConnectTimeMillis", $$robo$$android_telecom_Conference$setConnectTimeMillis(long ), this, l);
    }

    public void setConnectionTime(long l) {
        InvokeDynamicSupport.bootstrap("setConnectionTime", $$robo$$android_telecom_Conference$setConnectionTime(long ), this, l);
    }

    @Deprecated
    public long getConnectTimeMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getConnectTimeMillis", $$robo$$android_telecom_Conference$getConnectTimeMillis(), this);
    }

    public long getConnectionTime() {
        return (long)InvokeDynamicSupport.bootstrap("getConnectionTime", $$robo$$android_telecom_Conference$getConnectionTime(), this);
    }

    void setCallAudioState(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("setCallAudioState", $$robo$$android_telecom_Conference$setCallAudioState(android.telecom.CallAudioState ), this, callAudioState);
    }

    private void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telecom_Conference$setState(int ), this, n);
    }

    private void clearConferenceableList() {
        InvokeDynamicSupport.bootstrap("clearConferenceableList", $$robo$$android_telecom_Conference$clearConferenceableList(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telecom_Conference$toString(), this);
    }

    public void setStatusHints(StatusHints statusHints) {
        InvokeDynamicSupport.bootstrap("setStatusHints", $$robo$$android_telecom_Conference$setStatusHints(android.telecom.StatusHints ), this, statusHints);
    }

    public StatusHints getStatusHints() {
        return InvokeDynamicSupport.bootstrap("getStatusHints", $$robo$$android_telecom_Conference$getStatusHints(), this);
    }

    public void setExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_telecom_Conference$setExtras(android.os.Bundle ), this, bundle);
    }

    public void putExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("putExtras", $$robo$$android_telecom_Conference$putExtras(android.os.Bundle ), this, bundle);
    }

    public void putExtra(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Conference$putExtra(java.lang.String boolean ), this, string2, bl);
    }

    public void putExtra(String string2, int n) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Conference$putExtra(java.lang.String int ), this, string2, n);
    }

    public void putExtra(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Conference$putExtra(java.lang.String java.lang.String ), this, string2, string3);
    }

    public void removeExtras(List<String> list) {
        InvokeDynamicSupport.bootstrap("removeExtras", $$robo$$android_telecom_Conference$removeExtras(java.util.List<java.lang.String> ), this, list);
    }

    public void removeExtras(String ... stringArray) {
        InvokeDynamicSupport.bootstrap("removeExtras", $$robo$$android_telecom_Conference$removeExtras(java.lang.String[] ), this, stringArray);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_telecom_Conference$getExtras(), this);
    }

    public void onExtrasChanged(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$android_telecom_Conference$onExtrasChanged(android.os.Bundle ), this, bundle);
    }

    void handleExtrasChanged(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("handleExtrasChanged", $$robo$$android_telecom_Conference$handleExtrasChanged(android.os.Bundle ), this, bundle);
    }

    public /* synthetic */ Conference() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Conference)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class Listener
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Conference_Listener$__constructor__() {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onStateChanged(Conference conference, int oldState, int newState) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onDisconnected(Conference conference, DisconnectCause disconnectCause) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onConnectionAdded(Conference conference, Connection connection) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onConnectionRemoved(Conference conference, Connection connection) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onConferenceableConnectionsChanged(Conference conference, List<Connection> conferenceableConnections) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onDestroyed(Conference conference) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onConnectionCapabilitiesChanged(Conference conference, int connectionCapabilities) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onConnectionPropertiesChanged(Conference conference, int connectionProperties) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onVideoStateChanged(Conference c, int videoState) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onVideoProviderChanged(Conference c, Connection.VideoProvider videoProvider) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onStatusHintsChanged(Conference conference, StatusHints statusHints) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onExtrasChanged(Conference c, Bundle extras) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onExtrasRemoved(Conference c, List<String> keys) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Conference_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Conference_Listener$__constructor__(), this);
        }

        public void onStateChanged(Conference conference, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_Conference_Listener$onStateChanged(android.telecom.Conference int int ), this, conference, n, n2);
        }

        public void onDisconnected(Conference conference, DisconnectCause disconnectCause) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_Conference_Listener$onDisconnected(android.telecom.Conference android.telecom.DisconnectCause ), this, conference, disconnectCause);
        }

        public void onConnectionAdded(Conference conference, Connection connection) {
            InvokeDynamicSupport.bootstrap("onConnectionAdded", $$robo$$android_telecom_Conference_Listener$onConnectionAdded(android.telecom.Conference android.telecom.Connection ), this, conference, connection);
        }

        public void onConnectionRemoved(Conference conference, Connection connection) {
            InvokeDynamicSupport.bootstrap("onConnectionRemoved", $$robo$$android_telecom_Conference_Listener$onConnectionRemoved(android.telecom.Conference android.telecom.Connection ), this, conference, connection);
        }

        public void onConferenceableConnectionsChanged(Conference conference, List<Connection> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_Conference_Listener$onConferenceableConnectionsChanged(android.telecom.Conference java.util.List<android.telecom.Connection> ), this, conference, list);
        }

        public void onDestroyed(Conference conference) {
            InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Conference_Listener$onDestroyed(android.telecom.Conference ), this, conference);
        }

        public void onConnectionCapabilitiesChanged(Conference conference, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionCapabilitiesChanged", $$robo$$android_telecom_Conference_Listener$onConnectionCapabilitiesChanged(android.telecom.Conference int ), this, conference, n);
        }

        public void onConnectionPropertiesChanged(Conference conference, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionPropertiesChanged", $$robo$$android_telecom_Conference_Listener$onConnectionPropertiesChanged(android.telecom.Conference int ), this, conference, n);
        }

        public void onVideoStateChanged(Conference conference, int n) {
            InvokeDynamicSupport.bootstrap("onVideoStateChanged", $$robo$$android_telecom_Conference_Listener$onVideoStateChanged(android.telecom.Conference int ), this, conference, n);
        }

        public void onVideoProviderChanged(Conference conference, Connection.VideoProvider videoProvider) {
            InvokeDynamicSupport.bootstrap("onVideoProviderChanged", $$robo$$android_telecom_Conference_Listener$onVideoProviderChanged(android.telecom.Conference android.telecom.Connection$VideoProvider ), this, conference, videoProvider);
        }

        public void onStatusHintsChanged(Conference conference, StatusHints statusHints) {
            InvokeDynamicSupport.bootstrap("onStatusHintsChanged", $$robo$$android_telecom_Conference_Listener$onStatusHintsChanged(android.telecom.Conference android.telecom.StatusHints ), this, conference, statusHints);
        }

        public void onExtrasChanged(Conference conference, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$android_telecom_Conference_Listener$onExtrasChanged(android.telecom.Conference android.os.Bundle ), this, conference, bundle);
        }

        public void onExtrasRemoved(Conference conference, List<String> list) {
            InvokeDynamicSupport.bootstrap("onExtrasRemoved", $$robo$$android_telecom_Conference_Listener$onExtrasRemoved(android.telecom.Conference java.util.List<java.lang.String> ), this, conference, list);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

