/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioFormat;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.TextToSpeechService;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FileSynthesisCallback
extends AbstractSynthesisCallback
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "FileSynthesisRequest";
    private static boolean DBG = false;
    private static int MAX_AUDIO_BUFFER_SIZE = 8192;
    private static int WAV_HEADER_LENGTH = 44;
    private static short WAV_FORMAT_PCM = 1;
    private Object mStateLock;
    private int mSampleRateInHz;
    private int mAudioFormat;
    private int mChannelCount;
    private FileChannel mFileChannel;
    private TextToSpeechService.UtteranceProgressDispatcher mDispatcher;
    private boolean mStarted;
    private boolean mDone;
    protected int mStatusCode;

    private void $$robo$$android_speech_tts_FileSynthesisCallback$__constructor__(FileChannel fileChannel, TextToSpeechService.UtteranceProgressDispatcher dispatcher, boolean clientIsUsingV2) {
        this.mStateLock = new Object();
        this.mStarted = false;
        this.mDone = false;
        this.mFileChannel = fileChannel;
        this.mDispatcher = dispatcher;
        this.mStatusCode = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_FileSynthesisCallback$stop() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            if (this.mStatusCode == -2) {
                return;
            }
            this.mStatusCode = -2;
            this.cleanUp();
            this.mDispatcher.dispatchOnStop();
        }
    }

    private final void $$robo$$android_speech_tts_FileSynthesisCallback$cleanUp() {
        this.closeFile();
    }

    private final void $$robo$$android_speech_tts_FileSynthesisCallback$closeFile() {
        this.mFileChannel = null;
    }

    private final int $$robo$$android_speech_tts_FileSynthesisCallback$getMaxBufferSize() {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_FileSynthesisCallback$start(int sampleRateInHz, int audioFormat, int channelCount) {
        if (audioFormat != 3 && audioFormat != 2 && audioFormat != 4) {
            Log.e("FileSynthesisRequest", "Audio format encoding " + audioFormat + " not supported. Please use one of AudioFormat.ENCODING_PCM_8BIT, AudioFormat.ENCODING_PCM_16BIT or AudioFormat.ENCODING_PCM_FLOAT");
        }
        this.mDispatcher.dispatchOnBeginSynthesis(sampleRateInHz, audioFormat, channelCount);
        FileChannel fileChannel = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            if (this.mStatusCode != 0) {
                return -1;
            }
            if (this.mStarted) {
                Log.e("FileSynthesisRequest", "Start called twice");
                return -1;
            }
            this.mStarted = true;
            this.mSampleRateInHz = sampleRateInHz;
            this.mAudioFormat = audioFormat;
            this.mChannelCount = channelCount;
            this.mDispatcher.dispatchOnStart();
            fileChannel = this.mFileChannel;
        }
        try {
            fileChannel.write(ByteBuffer.allocate(44));
            return 0;
        }
        catch (IOException ex) {
            Log.e("FileSynthesisRequest", "Failed to write wav header to output file descriptor", ex);
            Object object2 = this.mStateLock;
            synchronized (object2) {
                this.cleanUp();
                this.mStatusCode = -5;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_FileSynthesisCallback$audioAvailable(byte[] buffer, int offset, int length) {
        FileChannel fileChannel = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            if (this.mStatusCode != 0) {
                return -1;
            }
            if (this.mFileChannel == null) {
                Log.e("FileSynthesisRequest", "File not open");
                this.mStatusCode = -5;
                return -1;
            }
            if (!this.mStarted) {
                Log.e("FileSynthesisRequest", "Start method was not called");
                return -1;
            }
            fileChannel = this.mFileChannel;
        }
        byte[] bufferCopy = new byte[length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])buffer, (int)offset, (byte[])bufferCopy, (int)0, (int)length);
        this.mDispatcher.dispatchOnAudioAvailable(bufferCopy);
        try {
            fileChannel.write(ByteBuffer.wrap(buffer, offset, length));
            return 0;
        }
        catch (IOException ex) {
            Log.e("FileSynthesisRequest", "Failed to write to output file descriptor", ex);
            Object object2 = this.mStateLock;
            synchronized (object2) {
                this.cleanUp();
                this.mStatusCode = -5;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_FileSynthesisCallback$done() {
        FileChannel fileChannel = null;
        int sampleRateInHz = 0;
        int audioFormat = 0;
        int channelCount = 0;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                Log.w("FileSynthesisRequest", "Duplicate call to done()");
                return -1;
            }
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            if (this.mStatusCode != 0 && this.mStatusCode != -2) {
                this.mDispatcher.dispatchOnError(this.mStatusCode);
                return -1;
            }
            if (this.mFileChannel == null) {
                Log.e("FileSynthesisRequest", "File not open");
                return -1;
            }
            this.mDone = true;
            fileChannel = this.mFileChannel;
            sampleRateInHz = this.mSampleRateInHz;
            audioFormat = this.mAudioFormat;
            channelCount = this.mChannelCount;
        }
        try {
            fileChannel.position(0L);
            int dataLength = (int)(fileChannel.size() - 44L);
            fileChannel.write(this.makeWavHeader(sampleRateInHz, audioFormat, channelCount, dataLength));
            Object object2 = this.mStateLock;
            synchronized (object2) {
                this.closeFile();
                this.mDispatcher.dispatchOnSuccess();
                return 0;
            }
        }
        catch (IOException ex) {
            Log.e("FileSynthesisRequest", "Failed to write to output file descriptor", ex);
            Object object3 = this.mStateLock;
            synchronized (object3) {
                this.cleanUp();
            }
            return -1;
        }
    }

    private final void $$robo$$android_speech_tts_FileSynthesisCallback$error() {
        this.error(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_FileSynthesisCallback$error(int errorCode) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            this.cleanUp();
            this.mStatusCode = errorCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_speech_tts_FileSynthesisCallback$hasStarted() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mStarted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_speech_tts_FileSynthesisCallback$hasFinished() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mDone;
        }
    }

    private final ByteBuffer $$robo$$android_speech_tts_FileSynthesisCallback$makeWavHeader(int sampleRateInHz, int audioFormat, int channelCount, int dataLength) {
        int sampleSizeInBytes = AudioFormat.getBytesPerSample(audioFormat);
        int byteRate = sampleRateInHz * sampleSizeInBytes * channelCount;
        short blockAlign = (short)(sampleSizeInBytes * channelCount);
        short bitsPerSample = (short)(sampleSizeInBytes * 8);
        byte[] headerBuf = new byte[44];
        ByteBuffer header = ByteBuffer.wrap(headerBuf);
        header.order(ByteOrder.LITTLE_ENDIAN);
        header.put(new byte[]{82, 73, 70, 70});
        header.putInt(dataLength + 44 - 8);
        header.put(new byte[]{87, 65, 86, 69});
        header.put(new byte[]{102, 109, 116, 32});
        header.putInt(16);
        header.putShort((short)1);
        header.putShort((short)channelCount);
        header.putInt(sampleRateInHz);
        header.putInt(byteRate);
        header.putShort(blockAlign);
        header.putShort(bitsPerSample);
        header.put(new byte[]{100, 97, 116, 97});
        header.putInt(dataLength);
        header.flip();
        return header;
    }

    private final void $$robo$$android_speech_tts_FileSynthesisCallback$rangeStart(int markerInFrames, int start, int end) {
        this.mDispatcher.dispatchOnRangeStart(markerInFrames, start, end);
    }

    private void __constructor__(FileChannel fileChannel, TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, boolean bl) {
        this.$$robo$$android_speech_tts_FileSynthesisCallback$__constructor__(fileChannel, utteranceProgressDispatcher, bl);
    }

    public FileSynthesisCallback(FileChannel fileChannel, TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, boolean bl) {
        super(bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_FileSynthesisCallback$__constructor__(java.nio.channels.FileChannel android.speech.tts.TextToSpeechService$UtteranceProgressDispatcher boolean ), this, fileChannel, utteranceProgressDispatcher, bl);
    }

    @Override
    void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_FileSynthesisCallback$stop(), this);
    }

    private void cleanUp() {
        InvokeDynamicSupport.bootstrap("cleanUp", $$robo$$android_speech_tts_FileSynthesisCallback$cleanUp(), this);
    }

    private void closeFile() {
        InvokeDynamicSupport.bootstrap("closeFile", $$robo$$android_speech_tts_FileSynthesisCallback$closeFile(), this);
    }

    @Override
    public int getMaxBufferSize() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxBufferSize", $$robo$$android_speech_tts_FileSynthesisCallback$getMaxBufferSize(), this);
    }

    @Override
    public int start(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("start", $$robo$$android_speech_tts_FileSynthesisCallback$start(int int int ), this, n, n2, n3);
    }

    @Override
    public int audioAvailable(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("audioAvailable", $$robo$$android_speech_tts_FileSynthesisCallback$audioAvailable(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    public int done() {
        return (int)InvokeDynamicSupport.bootstrap("done", $$robo$$android_speech_tts_FileSynthesisCallback$done(), this);
    }

    @Override
    public void error() {
        InvokeDynamicSupport.bootstrap("error", $$robo$$android_speech_tts_FileSynthesisCallback$error(), this);
    }

    @Override
    public void error(int n) {
        InvokeDynamicSupport.bootstrap("error", $$robo$$android_speech_tts_FileSynthesisCallback$error(int ), this, n);
    }

    @Override
    public boolean hasStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStarted", $$robo$$android_speech_tts_FileSynthesisCallback$hasStarted(), this);
    }

    @Override
    public boolean hasFinished() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFinished", $$robo$$android_speech_tts_FileSynthesisCallback$hasFinished(), this);
    }

    private ByteBuffer makeWavHeader(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("makeWavHeader", $$robo$$android_speech_tts_FileSynthesisCallback$makeWavHeader(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public void rangeStart(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("rangeStart", $$robo$$android_speech_tts_FileSynthesisCallback$rangeStart(int int int ), this, n, n2, n3);
    }

    public /* synthetic */ FileSynthesisCallback() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileSynthesisCallback)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

