/*
 * Decompiled with CFR 0.152.
 */
package android.speech;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.IRecognitionListener;
import android.speech.IRecognitionService;
import android.speech.RecognitionListener;
import android.text.TextUtils;
import android.util.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SpeechRecognizer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "SpeechRecognizer";
    public static String RESULTS_RECOGNITION = "results_recognition";
    public static String CONFIDENCE_SCORES = "confidence_scores";
    public static int ERROR_NETWORK_TIMEOUT = 1;
    public static int ERROR_NETWORK = 2;
    public static int ERROR_AUDIO = 3;
    public static int ERROR_SERVER = 4;
    public static int ERROR_CLIENT = 5;
    public static int ERROR_SPEECH_TIMEOUT = 6;
    public static int ERROR_NO_MATCH = 7;
    public static int ERROR_RECOGNIZER_BUSY = 8;
    public static int ERROR_INSUFFICIENT_PERMISSIONS = 9;
    private static int MSG_START = 1;
    private static int MSG_STOP = 2;
    private static int MSG_CANCEL = 3;
    private static int MSG_CHANGE_LISTENER = 4;
    private IRecognitionService mService;
    private Connection mConnection;
    private Context mContext;
    private ComponentName mServiceComponent;
    private Handler mHandler;
    private Queue<Message> mPendingTasks;
    private InternalListener mListener;

    private void $$robo$$android_speech_SpeechRecognizer$__constructor__(Context context, ComponentName serviceComponent) {
        this.mHandler = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ SpeechRecognizer this$0;

            private void $$robo$$android_speech_SpeechRecognizer_1$__constructor__(SpeechRecognizer this$0) {
            }

            private final void $$robo$$android_speech_SpeechRecognizer_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.handleStartListening((Intent)msg.obj);
                        break;
                    }
                    case 2: {
                        this.this$0.handleStopMessage();
                        break;
                    }
                    case 3: {
                        this.this$0.handleCancelMessage();
                        break;
                    }
                    case 4: {
                        this.this$0.handleChangeListener((RecognitionListener)msg.obj);
                    }
                }
            }

            private void __constructor__(SpeechRecognizer speechRecognizer) {
                this.$$robo$$android_speech_SpeechRecognizer_1$__constructor__(speechRecognizer);
            }
            {
                this.this$0 = speechRecognizer;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_SpeechRecognizer_1$__constructor__(android.speech.SpeechRecognizer ), this, speechRecognizer);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_speech_SpeechRecognizer_1$handleMessage(android.os.Message ), this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPendingTasks = new LinkedList<Message>();
        this.mListener = new InternalListener(null);
        this.mContext = context;
        this.mServiceComponent = serviceComponent;
    }

    private static final boolean $$robo$$android_speech_SpeechRecognizer$isRecognitionAvailable(Context context) {
        List<ResolveInfo> list = context.getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 0);
        return list != null && list.size() != 0;
    }

    private static final SpeechRecognizer $$robo$$android_speech_SpeechRecognizer$createSpeechRecognizer(Context context) {
        return SpeechRecognizer.createSpeechRecognizer(context, null);
    }

    private static final SpeechRecognizer $$robo$$android_speech_SpeechRecognizer$createSpeechRecognizer(Context context, ComponentName serviceComponent) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null)");
        }
        SpeechRecognizer.checkIsCalledFromMainThread();
        return new SpeechRecognizer(context, serviceComponent);
    }

    private final void $$robo$$android_speech_SpeechRecognizer$setRecognitionListener(RecognitionListener listener) {
        SpeechRecognizer.checkIsCalledFromMainThread();
        this.putMessage(Message.obtain(this.mHandler, 4, listener));
    }

    private final void $$robo$$android_speech_SpeechRecognizer$startListening(Intent recognizerIntent) {
        if (recognizerIntent == null) {
            throw new IllegalArgumentException("intent must not be null");
        }
        SpeechRecognizer.checkIsCalledFromMainThread();
        if (this.mConnection == null) {
            this.mConnection = new Connection(this, null);
            Intent serviceIntent = new Intent("android.speech.RecognitionService");
            if (this.mServiceComponent == null) {
                String serviceComponent = Settings.Secure.getString(this.mContext.getContentResolver(), "voice_recognition_service");
                if (TextUtils.isEmpty(serviceComponent)) {
                    Log.e("SpeechRecognizer", "no selected voice recognition service");
                    this.mListener.onError(5);
                    return;
                }
                serviceIntent.setComponent(ComponentName.unflattenFromString(serviceComponent));
            } else {
                serviceIntent.setComponent(this.mServiceComponent);
            }
            if (!this.mContext.bindService(serviceIntent, this.mConnection, 1)) {
                Log.e("SpeechRecognizer", "bind to recognition service failed");
                this.mConnection = null;
                this.mService = null;
                this.mListener.onError(5);
                return;
            }
        }
        this.putMessage(Message.obtain(this.mHandler, 1, recognizerIntent));
    }

    private final void $$robo$$android_speech_SpeechRecognizer$stopListening() {
        SpeechRecognizer.checkIsCalledFromMainThread();
        this.putMessage(Message.obtain(this.mHandler, 2));
    }

    private final void $$robo$$android_speech_SpeechRecognizer$cancel() {
        SpeechRecognizer.checkIsCalledFromMainThread();
        this.putMessage(Message.obtain(this.mHandler, 3));
    }

    private static final void $$robo$$android_speech_SpeechRecognizer$checkIsCalledFromMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new RuntimeException("SpeechRecognizer should be used only from the application's main thread");
        }
    }

    private final void $$robo$$android_speech_SpeechRecognizer$putMessage(Message msg) {
        if (this.mService == null) {
            this.mPendingTasks.offer(msg);
        } else {
            this.mHandler.sendMessage(msg);
        }
    }

    private final void $$robo$$android_speech_SpeechRecognizer$handleStartListening(Intent recognizerIntent) {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            this.mService.startListening(recognizerIntent, this.mListener);
        }
        catch (RemoteException e) {
            Log.e("SpeechRecognizer", "startListening() failed", e);
            this.mListener.onError(5);
        }
    }

    private final void $$robo$$android_speech_SpeechRecognizer$handleStopMessage() {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            this.mService.stopListening(this.mListener);
        }
        catch (RemoteException e) {
            Log.e("SpeechRecognizer", "stopListening() failed", e);
            this.mListener.onError(5);
        }
    }

    private final void $$robo$$android_speech_SpeechRecognizer$handleCancelMessage() {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            this.mService.cancel(this.mListener);
        }
        catch (RemoteException e) {
            Log.e("SpeechRecognizer", "cancel() failed", e);
            this.mListener.onError(5);
        }
    }

    private final boolean $$robo$$android_speech_SpeechRecognizer$checkOpenConnection() {
        if (this.mService != null) {
            return true;
        }
        this.mListener.onError(5);
        Log.e("SpeechRecognizer", "not connected to the recognition service");
        return false;
    }

    private final void $$robo$$android_speech_SpeechRecognizer$handleChangeListener(RecognitionListener listener) {
        this.mListener.mInternalListener = listener;
    }

    private final void $$robo$$android_speech_SpeechRecognizer$destroy() {
        if (this.mService != null) {
            try {
                this.mService.cancel(this.mListener);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
        }
        this.mPendingTasks.clear();
        this.mService = null;
        this.mConnection = null;
        this.mListener.mInternalListener = null;
    }

    private void __constructor__(Context context, ComponentName componentName) {
        this.$$robo$$android_speech_SpeechRecognizer$__constructor__(context, componentName);
    }

    public SpeechRecognizer(Context context, ComponentName componentName) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_SpeechRecognizer$__constructor__(android.content.Context android.content.ComponentName ), this, context, componentName);
    }

    public static boolean isRecognitionAvailable(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRecognitionAvailable", $$robo$$android_speech_SpeechRecognizer$isRecognitionAvailable(android.content.Context ), (Context)context);
    }

    public static SpeechRecognizer createSpeechRecognizer(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("createSpeechRecognizer", $$robo$$android_speech_SpeechRecognizer$createSpeechRecognizer(android.content.Context ), (Context)context);
    }

    public static SpeechRecognizer createSpeechRecognizer(Context context, ComponentName componentName) {
        return InvokeDynamicSupport.bootstrapStatic("createSpeechRecognizer", $$robo$$android_speech_SpeechRecognizer$createSpeechRecognizer(android.content.Context android.content.ComponentName ), (Context)context, (ComponentName)componentName);
    }

    public void setRecognitionListener(RecognitionListener recognitionListener) {
        InvokeDynamicSupport.bootstrap("setRecognitionListener", $$robo$$android_speech_SpeechRecognizer$setRecognitionListener(android.speech.RecognitionListener ), this, recognitionListener);
    }

    public void startListening(Intent intent) {
        InvokeDynamicSupport.bootstrap("startListening", $$robo$$android_speech_SpeechRecognizer$startListening(android.content.Intent ), this, intent);
    }

    public void stopListening() {
        InvokeDynamicSupport.bootstrap("stopListening", $$robo$$android_speech_SpeechRecognizer$stopListening(), this);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_speech_SpeechRecognizer$cancel(), this);
    }

    private static void checkIsCalledFromMainThread() {
        InvokeDynamicSupport.bootstrapStatic("checkIsCalledFromMainThread", $$robo$$android_speech_SpeechRecognizer$checkIsCalledFromMainThread());
    }

    private void putMessage(Message message) {
        InvokeDynamicSupport.bootstrap("putMessage", $$robo$$android_speech_SpeechRecognizer$putMessage(android.os.Message ), this, message);
    }

    private void handleStartListening(Intent intent) {
        InvokeDynamicSupport.bootstrap("handleStartListening", $$robo$$android_speech_SpeechRecognizer$handleStartListening(android.content.Intent ), this, intent);
    }

    private void handleStopMessage() {
        InvokeDynamicSupport.bootstrap("handleStopMessage", $$robo$$android_speech_SpeechRecognizer$handleStopMessage(), this);
    }

    private void handleCancelMessage() {
        InvokeDynamicSupport.bootstrap("handleCancelMessage", $$robo$$android_speech_SpeechRecognizer$handleCancelMessage(), this);
    }

    private boolean checkOpenConnection() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkOpenConnection", $$robo$$android_speech_SpeechRecognizer$checkOpenConnection(), this);
    }

    private void handleChangeListener(RecognitionListener recognitionListener) {
        InvokeDynamicSupport.bootstrap("handleChangeListener", $$robo$$android_speech_SpeechRecognizer$handleChangeListener(android.speech.RecognitionListener ), this, recognitionListener);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_speech_SpeechRecognizer$destroy(), this);
    }

    public /* synthetic */ SpeechRecognizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpeechRecognizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class InternalListener
    extends IRecognitionListener.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private RecognitionListener mInternalListener;
        private static int MSG_BEGINNING_OF_SPEECH = 1;
        private static int MSG_BUFFER_RECEIVED = 2;
        private static int MSG_END_OF_SPEECH = 3;
        private static int MSG_ERROR = 4;
        private static int MSG_READY_FOR_SPEECH = 5;
        private static int MSG_RESULTS = 6;
        private static int MSG_PARTIAL_RESULTS = 7;
        private static int MSG_RMS_CHANGED = 8;
        private static int MSG_ON_EVENT = 9;
        private Handler mInternalHandler;

        private void $$robo$$android_speech_SpeechRecognizer_InternalListener$__constructor__() {
            this.mInternalHandler = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ InternalListener this$0;

                private void $$robo$$android_speech_SpeechRecognizer_InternalListener_1$__constructor__(InternalListener this$0) {
                }

                private final void $$robo$$android_speech_SpeechRecognizer_InternalListener_1$handleMessage(Message msg) {
                    if (this.this$0.mInternalListener == null) {
                        return;
                    }
                    switch (msg.what) {
                        case 1: {
                            this.this$0.mInternalListener.onBeginningOfSpeech();
                            break;
                        }
                        case 2: {
                            this.this$0.mInternalListener.onBufferReceived((byte[])msg.obj);
                            break;
                        }
                        case 3: {
                            this.this$0.mInternalListener.onEndOfSpeech();
                            break;
                        }
                        case 4: {
                            this.this$0.mInternalListener.onError((Integer)msg.obj);
                            break;
                        }
                        case 5: {
                            this.this$0.mInternalListener.onReadyForSpeech((Bundle)msg.obj);
                            break;
                        }
                        case 6: {
                            this.this$0.mInternalListener.onResults((Bundle)msg.obj);
                            break;
                        }
                        case 7: {
                            this.this$0.mInternalListener.onPartialResults((Bundle)msg.obj);
                            break;
                        }
                        case 8: {
                            this.this$0.mInternalListener.onRmsChanged(((Float)msg.obj).floatValue());
                            break;
                        }
                        case 9: {
                            this.this$0.mInternalListener.onEvent(msg.arg1, (Bundle)msg.obj);
                        }
                    }
                }

                private void __constructor__(InternalListener internalListener) {
                    this.$$robo$$android_speech_SpeechRecognizer_InternalListener_1$__constructor__(internalListener);
                }
                {
                    this.this$0 = internalListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_SpeechRecognizer_InternalListener_1$__constructor__(android.speech.SpeechRecognizer$InternalListener ), this, internalListener);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_speech_SpeechRecognizer_InternalListener_1$handleMessage(android.os.Message ), this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onBeginningOfSpeech() {
            Message.obtain(this.mInternalHandler, 1).sendToTarget();
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onBufferReceived(byte[] buffer) {
            Message.obtain(this.mInternalHandler, 2, buffer).sendToTarget();
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onEndOfSpeech() {
            Message.obtain(this.mInternalHandler, 3).sendToTarget();
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onError(int error) {
            Message.obtain(this.mInternalHandler, 4, error).sendToTarget();
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onReadyForSpeech(Bundle noiseParams) {
            Message.obtain(this.mInternalHandler, 5, noiseParams).sendToTarget();
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onResults(Bundle results) {
            Message.obtain(this.mInternalHandler, 6, results).sendToTarget();
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onPartialResults(Bundle results) {
            Message.obtain(this.mInternalHandler, 7, results).sendToTarget();
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onRmsChanged(float rmsdB) {
            Message.obtain(this.mInternalHandler, 8, Float.valueOf(rmsdB)).sendToTarget();
        }

        private final void $$robo$$android_speech_SpeechRecognizer_InternalListener$onEvent(int eventType, Bundle params) {
            Message.obtain(this.mInternalHandler, 9, eventType, eventType, params).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_speech_SpeechRecognizer_InternalListener$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_speech_SpeechRecognizer_InternalListener$__constructor__();
        }

        public InternalListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_SpeechRecognizer_InternalListener$__constructor__(), this);
        }

        @Override
        public void onBeginningOfSpeech() {
            InvokeDynamicSupport.bootstrap("onBeginningOfSpeech", $$robo$$android_speech_SpeechRecognizer_InternalListener$onBeginningOfSpeech(), this);
        }

        @Override
        public void onBufferReceived(byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onBufferReceived", $$robo$$android_speech_SpeechRecognizer_InternalListener$onBufferReceived(byte[] ), this, byArray);
        }

        @Override
        public void onEndOfSpeech() {
            InvokeDynamicSupport.bootstrap("onEndOfSpeech", $$robo$$android_speech_SpeechRecognizer_InternalListener$onEndOfSpeech(), this);
        }

        @Override
        public void onError(int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_speech_SpeechRecognizer_InternalListener$onError(int ), this, n);
        }

        @Override
        public void onReadyForSpeech(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onReadyForSpeech", $$robo$$android_speech_SpeechRecognizer_InternalListener$onReadyForSpeech(android.os.Bundle ), this, bundle);
        }

        @Override
        public void onResults(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onResults", $$robo$$android_speech_SpeechRecognizer_InternalListener$onResults(android.os.Bundle ), this, bundle);
        }

        @Override
        public void onPartialResults(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPartialResults", $$robo$$android_speech_SpeechRecognizer_InternalListener$onPartialResults(android.os.Bundle ), this, bundle);
        }

        @Override
        public void onRmsChanged(float f) {
            InvokeDynamicSupport.bootstrap("onRmsChanged", $$robo$$android_speech_SpeechRecognizer_InternalListener$onRmsChanged(float ), this, f);
        }

        @Override
        public void onEvent(int n, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onEvent", $$robo$$android_speech_SpeechRecognizer_InternalListener$onEvent(int android.os.Bundle ), this, n, bundle);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_speech_SpeechRecognizer_InternalListener$__constructor__(var1_1);
        }

        public /* synthetic */ InternalListener(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_SpeechRecognizer_InternalListener$__constructor__(android.speech.SpeechRecognizer$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InternalListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class Connection
    implements ServiceConnection,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ SpeechRecognizer this$0;

        private void $$robo$$android_speech_SpeechRecognizer_Connection$__constructor__(SpeechRecognizer speechRecognizer) {
        }

        private final void $$robo$$android_speech_SpeechRecognizer_Connection$onServiceConnected(ComponentName name, IBinder service) {
            this.this$0.mService = IRecognitionService.Stub.asInterface(service);
            while (!this.this$0.mPendingTasks.isEmpty()) {
                this.this$0.mHandler.sendMessage((Message)this.this$0.mPendingTasks.poll());
            }
        }

        private final void $$robo$$android_speech_SpeechRecognizer_Connection$onServiceDisconnected(ComponentName name) {
            this.this$0.mService = null;
            this.this$0.mConnection = null;
            this.this$0.mPendingTasks.clear();
        }

        private /* synthetic */ void $$robo$$android_speech_SpeechRecognizer_Connection$__constructor__(SpeechRecognizer x0, 1 x1) {
        }

        private void __constructor__(SpeechRecognizer speechRecognizer) {
            this.$$robo$$android_speech_SpeechRecognizer_Connection$__constructor__(speechRecognizer);
        }

        public Connection(SpeechRecognizer speechRecognizer) {
            this.this$0 = speechRecognizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_SpeechRecognizer_Connection$__constructor__(android.speech.SpeechRecognizer ), this, speechRecognizer);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_speech_SpeechRecognizer_Connection$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_speech_SpeechRecognizer_Connection$onServiceDisconnected(android.content.ComponentName ), this, componentName);
        }

        private /* synthetic */ void __constructor__(SpeechRecognizer speechRecognizer, 1 var2_2) {
            this.$$robo$$android_speech_SpeechRecognizer_Connection$__constructor__(speechRecognizer, var2_2);
        }

        public /* synthetic */ Connection(SpeechRecognizer speechRecognizer, 1 var2_2) {
            this(speechRecognizer);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_SpeechRecognizer_Connection$__constructor__(android.speech.SpeechRecognizer android.speech.SpeechRecognizer$1 ), this, speechRecognizer, var2_2);
        }

        public /* synthetic */ Connection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Connection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

