/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.OperationResult;
import android.security.keystore.AndroidKeyStoreCipherSpiBase;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.ArrayUtils;
import android.security.keystore.KeyStoreCryptoOperationChunkedStreamer;
import android.security.keystore.KeyStoreCryptoOperationStreamer;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.GCMParameterSpec;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AndroidKeyStoreAuthenticatedAESCipherSpi
extends AndroidKeyStoreCipherSpiBase
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int BLOCK_SIZE_BYTES = 16;
    private int mKeymasterBlockMode;
    private int mKeymasterPadding;
    private byte[] mIv;
    private boolean mIvHasBeenUsed;

    private void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$__constructor__(int keymasterBlockMode, int keymasterPadding) {
        this.mKeymasterBlockMode = keymasterBlockMode;
        this.mKeymasterPadding = keymasterPadding;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$resetAll() {
        this.mIv = null;
        this.mIvHasBeenUsed = false;
        super.resetAll();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$initKey(int opmode, Key key) throws InvalidKeyException {
        if (!(key instanceof AndroidKeyStoreSecretKey)) {
            throw new InvalidKeyException("Unsupported key: " + (key != null ? key.getClass().getName() : "null"));
        }
        if (!"AES".equalsIgnoreCase(key.getAlgorithm())) {
            throw new InvalidKeyException("Unsupported key algorithm: " + key.getAlgorithm() + ". Only " + "AES" + " supported");
        }
        this.setKey((AndroidKeyStoreSecretKey)key);
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
        if (this.isEncrypting() && this.mIvHasBeenUsed) {
            throw new IllegalStateException("IV has already been used. Reusing IV in encryption mode violates security best practices.");
        }
        keymasterArgs.addEnum(0x10000002, 32);
        keymasterArgs.addEnum(0x20000004, this.mKeymasterBlockMode);
        keymasterArgs.addEnum(0x20000006, this.mKeymasterPadding);
        if (this.mIv != null) {
            keymasterArgs.addBytes(-1879047191, this.mIv);
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArgs) {
        this.mIvHasBeenUsed = true;
        byte[] returnedIv = keymasterArgs.getBytes(-1879047191, null);
        if (returnedIv != null && returnedIv.length == 0) {
            returnedIv = null;
        }
        if (this.mIv == null) {
            this.mIv = returnedIv;
        } else if (returnedIv != null && !Arrays.equals(returnedIv, this.mIv)) {
            throw new ProviderException("IV in use differs from provided IV");
        }
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$engineGetBlockSize() {
        return 16;
    }

    private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$engineGetIV() {
        return ArrayUtils.cloneIfNotEmpty(this.mIv);
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$setIv(byte[] iv) {
        this.mIv = iv;
    }

    private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$getIv() {
        return this.mIv;
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$__constructor__(n, n2);
    }

    public AndroidKeyStoreAuthenticatedAESCipherSpi(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$__constructor__(int int ), this, n, n2);
    }

    @Override
    protected void resetAll() {
        InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$resetAll(), this);
    }

    @Override
    protected void initKey(int n, Key key) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("initKey", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$initKey(int java.security.Key ), this, n, key);
    }

    @Override
    protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("addAlgorithmSpecificParametersToBegin", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$addAlgorithmSpecificParametersToBegin(android.security.keymaster.KeymasterArguments ), this, keymasterArguments);
    }

    @Override
    protected void loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("loadAlgorithmSpecificParametersFromBeginResult", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$loadAlgorithmSpecificParametersFromBeginResult(android.security.keymaster.KeymasterArguments ), this, keymasterArguments);
    }

    @Override
    protected int engineGetBlockSize() {
        return (int)InvokeDynamicSupport.bootstrap("engineGetBlockSize", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$engineGetBlockSize(), this);
    }

    @Override
    protected byte[] engineGetIV() {
        return InvokeDynamicSupport.bootstrap("engineGetIV", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$engineGetIV(), this);
    }

    protected void setIv(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setIv", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$setIv(byte[] ), this, byArray);
    }

    protected byte[] getIv() {
        return InvokeDynamicSupport.bootstrap("getIv", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi$getIv(), this);
    }

    public /* synthetic */ AndroidKeyStoreAuthenticatedAESCipherSpi() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreAuthenticatedAESCipherSpi)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AdditionalAuthenticationDataStream
    implements KeyStoreCryptoOperationChunkedStreamer.Stream,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private KeyStore mKeyStore;
        private IBinder mOperationToken;

        private void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$__constructor__(KeyStore keyStore, IBinder operationToken) {
            this.mKeyStore = keyStore;
            this.mOperationToken = operationToken;
        }

        private final OperationResult $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$update(byte[] input) {
            KeymasterArguments keymasterArgs = new KeymasterArguments();
            keymasterArgs.addBytes(-1879047192, input);
            OperationResult result = this.mKeyStore.update(this.mOperationToken, keymasterArgs, null);
            if (result.resultCode == 1) {
                result = new OperationResult(result.resultCode, result.token, result.operationHandle, input.length, result.output, result.outParams);
            }
            return result;
        }

        private final OperationResult $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$finish(byte[] signature, byte[] additionalEntropy) {
            if (additionalEntropy != null && additionalEntropy.length > 0) {
                throw new ProviderException("AAD stream does not support additional entropy");
            }
            return new OperationResult(1, this.mOperationToken, 0L, 0, EmptyArray.BYTE, new KeymasterArguments());
        }

        private /* synthetic */ void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$__constructor__(KeyStore x0, IBinder x1, 1 x2) {
        }

        private void __constructor__(KeyStore keyStore, IBinder iBinder) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$__constructor__(keyStore, iBinder);
        }

        public AdditionalAuthenticationDataStream(KeyStore keyStore, IBinder iBinder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$__constructor__(android.security.KeyStore android.os.IBinder ), this, keyStore, iBinder);
        }

        @Override
        public OperationResult update(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("update", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$update(byte[] ), this, byArray);
        }

        @Override
        public OperationResult finish(byte[] byArray, byte[] byArray2) {
            return InvokeDynamicSupport.bootstrap("finish", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$finish(byte[] byte[] ), this, byArray, byArray2);
        }

        private /* synthetic */ void __constructor__(KeyStore keyStore, IBinder iBinder, 1 var3_3) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$__constructor__(keyStore, iBinder, var3_3);
        }

        public /* synthetic */ AdditionalAuthenticationDataStream(KeyStore keyStore, IBinder iBinder, 1 var3_3) {
            this(keyStore, iBinder);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_AdditionalAuthenticationDataStream$__constructor__(android.security.KeyStore android.os.IBinder android.security.keystore.AndroidKeyStoreAuthenticatedAESCipherSpi$1 ), this, keyStore, iBinder, var3_3);
        }

        public /* synthetic */ AdditionalAuthenticationDataStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdditionalAuthenticationDataStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class BufferAllOutputUntilDoFinalStreamer
    implements KeyStoreCryptoOperationStreamer,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private KeyStoreCryptoOperationStreamer mDelegate;
        private ByteArrayOutputStream mBufferedOutput;
        private long mProducedOutputSizeBytes;

        private void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$__constructor__(KeyStoreCryptoOperationStreamer delegate) {
            this.mBufferedOutput = new ByteArrayOutputStream();
            this.mDelegate = delegate;
        }

        private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$update(byte[] input, int inputOffset, int inputLength) throws KeyStoreException {
            byte[] output = this.mDelegate.update(input, inputOffset, inputLength);
            if (output != null) {
                try {
                    this.mBufferedOutput.write(output);
                }
                catch (IOException e) {
                    throw new ProviderException("Failed to buffer output", e);
                }
            }
            return EmptyArray.BYTE;
        }

        private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$doFinal(byte[] input, int inputOffset, int inputLength, byte[] signature, byte[] additionalEntropy) throws KeyStoreException {
            byte[] output = this.mDelegate.doFinal(input, inputOffset, inputLength, signature, additionalEntropy);
            if (output != null) {
                try {
                    this.mBufferedOutput.write(output);
                }
                catch (IOException e) {
                    throw new ProviderException("Failed to buffer output", e);
                }
            }
            byte[] result = this.mBufferedOutput.toByteArray();
            this.mBufferedOutput.reset();
            this.mProducedOutputSizeBytes += (long)result.length;
            return result;
        }

        private final long $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$getConsumedInputSizeBytes() {
            return this.mDelegate.getConsumedInputSizeBytes();
        }

        private final long $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$getProducedOutputSizeBytes() {
            return this.mProducedOutputSizeBytes;
        }

        private /* synthetic */ void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$__constructor__(KeyStoreCryptoOperationStreamer x0, 1 x1) {
        }

        private void __constructor__(KeyStoreCryptoOperationStreamer keyStoreCryptoOperationStreamer) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$__constructor__(keyStoreCryptoOperationStreamer);
        }

        public BufferAllOutputUntilDoFinalStreamer(KeyStoreCryptoOperationStreamer keyStoreCryptoOperationStreamer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$__constructor__(android.security.keystore.KeyStoreCryptoOperationStreamer ), this, keyStoreCryptoOperationStreamer);
        }

        @Override
        public byte[] update(byte[] byArray, int n, int n2) throws KeyStoreException {
            return InvokeDynamicSupport.bootstrap("update", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$update(byte[] int int ), this, byArray, n, n2);
        }

        @Override
        public byte[] doFinal(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) throws KeyStoreException {
            return InvokeDynamicSupport.bootstrap("doFinal", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$doFinal(byte[] int int byte[] byte[] ), this, byArray, n, n2, byArray2, byArray3);
        }

        @Override
        public long getConsumedInputSizeBytes() {
            return (long)InvokeDynamicSupport.bootstrap("getConsumedInputSizeBytes", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$getConsumedInputSizeBytes(), this);
        }

        @Override
        public long getProducedOutputSizeBytes() {
            return (long)InvokeDynamicSupport.bootstrap("getProducedOutputSizeBytes", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$getProducedOutputSizeBytes(), this);
        }

        private /* synthetic */ void __constructor__(KeyStoreCryptoOperationStreamer keyStoreCryptoOperationStreamer, 1 var2_2) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$__constructor__(keyStoreCryptoOperationStreamer, var2_2);
        }

        public /* synthetic */ BufferAllOutputUntilDoFinalStreamer(KeyStoreCryptoOperationStreamer keyStoreCryptoOperationStreamer, 1 var2_2) {
            this(keyStoreCryptoOperationStreamer);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_BufferAllOutputUntilDoFinalStreamer$__constructor__(android.security.keystore.KeyStoreCryptoOperationStreamer android.security.keystore.AndroidKeyStoreAuthenticatedAESCipherSpi$1 ), this, keyStoreCryptoOperationStreamer, var2_2);
        }

        public /* synthetic */ BufferAllOutputUntilDoFinalStreamer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BufferAllOutputUntilDoFinalStreamer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class GCM
    extends AndroidKeyStoreAuthenticatedAESCipherSpi
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static int MIN_SUPPORTED_TAG_LENGTH_BITS = 96;
        private static int MAX_SUPPORTED_TAG_LENGTH_BITS = 128;
        private static int DEFAULT_TAG_LENGTH_BITS = 128;
        private static int IV_LENGTH_BYTES = 12;
        private int mTagLengthBits;

        private void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$__constructor__(int keymasterPadding) {
            this.mTagLengthBits = 128;
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$resetAll() {
            this.mTagLengthBits = 128;
            super.resetAll();
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$resetWhilePreservingInitState() {
            super.resetWhilePreservingInitState();
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$initAlgorithmSpecificParameters() throws InvalidKeyException {
            if (!this.isEncrypting()) {
                throw new InvalidKeyException("IV required when decrypting. Use IvParameterSpec or AlgorithmParameters to provide it.");
            }
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params == null) {
                if (!this.isEncrypting()) {
                    throw new InvalidAlgorithmParameterException("GCMParameterSpec must be provided when decrypting");
                }
                return;
            }
            if (!(params instanceof GCMParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only GCMParameterSpec supported");
            }
            GCMParameterSpec spec = (GCMParameterSpec)params;
            byte[] iv = spec.getIV();
            if (iv == null) {
                throw new InvalidAlgorithmParameterException("Null IV in GCMParameterSpec");
            }
            if (iv.length != 12) {
                throw new InvalidAlgorithmParameterException("Unsupported IV length: " + iv.length + " bytes. Only " + 12 + " bytes long IV supported");
            }
            int tagLengthBits = spec.getTLen();
            if (tagLengthBits < 96 || tagLengthBits > 128 || tagLengthBits % 8 != 0) {
                throw new InvalidAlgorithmParameterException("Unsupported tag length: " + tagLengthBits + " bits. Supported lengths: 96, 104, 112, 120, 128");
            }
            this.setIv(iv);
            this.mTagLengthBits = tagLengthBits;
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            GCMParameterSpec spec;
            if (params == null) {
                if (!this.isEncrypting()) {
                    throw new InvalidAlgorithmParameterException("IV required when decrypting. Use GCMParameterSpec or GCM AlgorithmParameters to provide it.");
                }
                return;
            }
            if (!"GCM".equalsIgnoreCase(params.getAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Unsupported AlgorithmParameters algorithm: " + params.getAlgorithm() + ". Supported: GCM");
            }
            try {
                spec = params.getParameterSpec(GCMParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                if (!this.isEncrypting()) {
                    throw new InvalidAlgorithmParameterException("IV and tag length required when decrypting, but not found in parameters: " + params, e);
                }
                this.setIv(null);
                return;
            }
            this.initAlgorithmSpecificParameters(spec);
        }

        private final AlgorithmParameters $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$engineGetParameters() {
            byte[] iv = this.getIv();
            if (iv != null && iv.length > 0) {
                try {
                    AlgorithmParameters params = AlgorithmParameters.getInstance("GCM");
                    params.init(new GCMParameterSpec(this.mTagLengthBits, iv));
                    return params;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ProviderException("Failed to obtain GCM AlgorithmParameters", e);
                }
                catch (InvalidParameterSpecException e) {
                    throw new ProviderException("Failed to initialize GCM AlgorithmParameters", e);
                }
            }
            return null;
        }

        private final KeyStoreCryptoOperationStreamer $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$createMainDataStreamer(KeyStore keyStore, IBinder operationToken) {
            KeyStoreCryptoOperationChunkedStreamer streamer = new KeyStoreCryptoOperationChunkedStreamer(new KeyStoreCryptoOperationChunkedStreamer.MainDataStream(keyStore, operationToken));
            if (this.isEncrypting()) {
                return streamer;
            }
            return new BufferAllOutputUntilDoFinalStreamer(streamer, null);
        }

        private final KeyStoreCryptoOperationStreamer $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$createAdditionalAuthenticationDataStreamer(KeyStore keyStore, IBinder operationToken) {
            return new KeyStoreCryptoOperationChunkedStreamer(new AdditionalAuthenticationDataStream(keyStore, operationToken, null));
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$getAdditionalEntropyAmountForBegin() {
            if (this.getIv() == null && this.isEncrypting()) {
                return 12;
            }
            return 0;
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$getAdditionalEntropyAmountForFinish() {
            return 0;
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
            super.addAlgorithmSpecificParametersToBegin(keymasterArgs);
            keymasterArgs.addUnsignedInt(805307371, this.mTagLengthBits);
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$getTagLengthBits() {
            return this.mTagLengthBits;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$__constructor__(n);
        }

        public GCM(int n) {
            super(32, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$__constructor__(int ), this, n);
        }

        @Override
        protected void resetAll() {
            InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$resetAll(), this);
        }

        @Override
        protected void resetWhilePreservingInitState() {
            InvokeDynamicSupport.bootstrap("resetWhilePreservingInitState", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$resetWhilePreservingInitState(), this);
        }

        @Override
        protected void initAlgorithmSpecificParameters() throws InvalidKeyException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$initAlgorithmSpecificParameters(), this);
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$initAlgorithmSpecificParameters(java.security.spec.AlgorithmParameterSpec ), this, algorithmParameterSpec);
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$initAlgorithmSpecificParameters(java.security.AlgorithmParameters ), this, algorithmParameters);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return InvokeDynamicSupport.bootstrap("engineGetParameters", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$engineGetParameters(), this);
        }

        @Override
        protected KeyStoreCryptoOperationStreamer createMainDataStreamer(KeyStore keyStore, IBinder iBinder) {
            return InvokeDynamicSupport.bootstrap("createMainDataStreamer", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$createMainDataStreamer(android.security.KeyStore android.os.IBinder ), this, keyStore, iBinder);
        }

        @Override
        protected KeyStoreCryptoOperationStreamer createAdditionalAuthenticationDataStreamer(KeyStore keyStore, IBinder iBinder) {
            return InvokeDynamicSupport.bootstrap("createAdditionalAuthenticationDataStreamer", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$createAdditionalAuthenticationDataStreamer(android.security.KeyStore android.os.IBinder ), this, keyStore, iBinder);
        }

        @Override
        protected int getAdditionalEntropyAmountForBegin() {
            return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForBegin", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$getAdditionalEntropyAmountForBegin(), this);
        }

        @Override
        protected int getAdditionalEntropyAmountForFinish() {
            return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForFinish", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$getAdditionalEntropyAmountForFinish(), this);
        }

        @Override
        protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArguments) {
            InvokeDynamicSupport.bootstrap("addAlgorithmSpecificParametersToBegin", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$addAlgorithmSpecificParametersToBegin(android.security.keymaster.KeymasterArguments ), this, keymasterArguments);
        }

        protected int getTagLengthBits() {
            return (int)InvokeDynamicSupport.bootstrap("getTagLengthBits", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM$getTagLengthBits(), this);
        }

        public /* synthetic */ GCM() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GCM)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class NoPadding
        extends GCM
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM_NoPadding$__constructor__() {
            }

            private final int $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM_NoPadding$engineGetOutputSize(int inputLen) {
                int tagLengthBytes = (this.getTagLengthBits() + 7) / 8;
                long result = this.isEncrypting() ? this.getConsumedInputSizeBytes() - this.getProducedOutputSizeBytes() + (long)inputLen + (long)tagLengthBytes : this.getConsumedInputSizeBytes() - this.getProducedOutputSizeBytes() + (long)inputLen - (long)tagLengthBytes;
                if (result < 0L) {
                    return 0;
                }
                if (result > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return (int)result;
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM_NoPadding$__constructor__();
            }

            public NoPadding() {
                super(1);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM_NoPadding$__constructor__(), this);
            }

            @Override
            protected int engineGetOutputSize(int n) {
                return (int)InvokeDynamicSupport.bootstrap("engineGetOutputSize", $$robo$$android_security_keystore_AndroidKeyStoreAuthenticatedAESCipherSpi_GCM_NoPadding$engineGetOutputSize(int ), this, n);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPadding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

