/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.os.Environment;
import android.os.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SystemKeyStore
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String SYSTEM_KEYSTORE_DIRECTORY = "misc/systemkeys";
    private static String KEY_FILE_EXTENSION = ".sks";
    private static SystemKeyStore mInstance;

    private void $$robo$$android_security_SystemKeyStore$__constructor__() {
    }

    private static final SystemKeyStore $$robo$$android_security_SystemKeyStore$getInstance() {
        return mInstance;
    }

    private static final String $$robo$$android_security_SystemKeyStore$toHexString(byte[] keyData) {
        if (keyData == null) {
            return null;
        }
        int keyLen = keyData.length;
        int expectedStringLen = keyData.length * 2;
        StringBuilder sb = new StringBuilder(expectedStringLen);
        for (int i = 0; i < keyData.length; ++i) {
            String hexStr = Integer.toString(keyData[i] & 0xFF, 16);
            if (hexStr.length() == 1) {
                hexStr = "0" + hexStr;
            }
            sb.append(hexStr);
        }
        return sb.toString();
    }

    private final String $$robo$$android_security_SystemKeyStore$generateNewKeyHexString(int numBits, String algName, String keyName) throws NoSuchAlgorithmException {
        return SystemKeyStore.toHexString(this.generateNewKey(numBits, algName, keyName));
    }

    private final byte[] $$robo$$android_security_SystemKeyStore$generateNewKey(int numBits, String algName, String keyName) throws NoSuchAlgorithmException {
        File keyFile = this.getKeyFile(keyName);
        if (keyFile.exists()) {
            throw new IllegalArgumentException();
        }
        KeyGenerator skg = KeyGenerator.getInstance(algName);
        SecureRandom srng = SecureRandom.getInstance("SHA1PRNG");
        skg.init(numBits, srng);
        SecretKey sk = skg.generateKey();
        byte[] retKey = sk.getEncoded();
        try {
            if (!keyFile.createNewFile()) {
                throw new IllegalArgumentException();
            }
            FileOutputStream fos = new FileOutputStream(keyFile);
            fos.write(retKey);
            fos.flush();
            FileUtils.sync(fos);
            fos.close();
            FileUtils.setPermissions(keyFile.getName(), 384, -1, -1);
        }
        catch (IOException ioe) {
            return null;
        }
        return retKey;
    }

    private final File $$robo$$android_security_SystemKeyStore$getKeyFile(String keyName) {
        File sysKeystoreDir = new File(Environment.getDataDirectory(), "misc/systemkeys");
        File keyFile = new File(sysKeystoreDir, keyName + ".sks");
        return keyFile;
    }

    private final String $$robo$$android_security_SystemKeyStore$retrieveKeyHexString(String keyName) throws IOException {
        return SystemKeyStore.toHexString(this.retrieveKey(keyName));
    }

    private final byte[] $$robo$$android_security_SystemKeyStore$retrieveKey(String keyName) throws IOException {
        File keyFile = this.getKeyFile(keyName);
        if (!keyFile.exists()) {
            return null;
        }
        return IoUtils.readFileAsByteArray(keyFile.toString());
    }

    private final void $$robo$$android_security_SystemKeyStore$deleteKey(String keyName) {
        File keyFile = this.getKeyFile(keyName);
        if (!keyFile.exists()) {
            throw new IllegalArgumentException();
        }
        keyFile.delete();
    }

    static void __staticInitializer__() {
        mInstance = new SystemKeyStore();
    }

    private void __constructor__() {
        this.$$robo$$android_security_SystemKeyStore$__constructor__();
    }

    public SystemKeyStore() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_SystemKeyStore$__constructor__(), this);
    }

    public static SystemKeyStore getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_security_SystemKeyStore$getInstance());
    }

    public static String toHexString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("toHexString", $$robo$$android_security_SystemKeyStore$toHexString(byte[] ), (byte[])byArray);
    }

    public String generateNewKeyHexString(int n, String string2, String string3) throws NoSuchAlgorithmException {
        return InvokeDynamicSupport.bootstrap("generateNewKeyHexString", $$robo$$android_security_SystemKeyStore$generateNewKeyHexString(int java.lang.String java.lang.String ), this, n, string2, string3);
    }

    public byte[] generateNewKey(int n, String string2, String string3) throws NoSuchAlgorithmException {
        return InvokeDynamicSupport.bootstrap("generateNewKey", $$robo$$android_security_SystemKeyStore$generateNewKey(int java.lang.String java.lang.String ), this, n, string2, string3);
    }

    private File getKeyFile(String string2) {
        return InvokeDynamicSupport.bootstrap("getKeyFile", $$robo$$android_security_SystemKeyStore$getKeyFile(java.lang.String ), this, string2);
    }

    public String retrieveKeyHexString(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("retrieveKeyHexString", $$robo$$android_security_SystemKeyStore$retrieveKeyHexString(java.lang.String ), this, string2);
    }

    public byte[] retrieveKey(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("retrieveKey", $$robo$$android_security_SystemKeyStore$retrieveKey(java.lang.String ), this, string2);
    }

    public void deleteKey(String string2) {
        InvokeDynamicSupport.bootstrap("deleteKey", $$robo$$android_security_SystemKeyStore$deleteKey(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(SystemKeyStore.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemKeyStore)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

