/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.security.GateKeeper;
import android.security.IKeystoreService;
import android.security.KeyStoreException;
import android.security.KeystoreArguments;
import android.security.keymaster.ExportResult;
import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.KeymasterBlob;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keymaster.KeymasterDefs;
import android.security.keymaster.OperationResult;
import android.security.keystore.KeyExpiredException;
import android.security.keystore.KeyNotYetValidException;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.UserNotAuthenticatedException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyStore
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "KeyStore";
    public static int NO_ERROR = 1;
    public static int LOCKED = 2;
    public static int UNINITIALIZED = 3;
    public static int SYSTEM_ERROR = 4;
    public static int PROTOCOL_ERROR = 5;
    public static int PERMISSION_DENIED = 6;
    public static int KEY_NOT_FOUND = 7;
    public static int VALUE_CORRUPTED = 8;
    public static int UNDEFINED_ACTION = 9;
    public static int WRONG_PASSWORD = 10;
    public static int OP_AUTH_NEEDED = 15;
    public static int UID_SELF = -1;
    public static int FLAG_NONE = 0;
    public static int FLAG_ENCRYPTED = 1;
    public static int FLAG_CRITICAL_TO_DEVICE_ENCRYPTION = 8;
    private int mError;
    private IKeystoreService mBinder;
    private Context mContext;
    private IBinder mToken;

    private void $$robo$$android_security_KeyStore$__constructor__(IKeystoreService binder) {
        this.mError = 1;
        this.mBinder = binder;
        this.mContext = KeyStore.getApplicationContext();
    }

    private static final Context $$robo$$android_security_KeyStore$getApplicationContext() {
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            throw new IllegalStateException("Failed to obtain application Context from ActivityThread");
        }
        return application;
    }

    private static final KeyStore $$robo$$android_security_KeyStore$getInstance() {
        IKeystoreService keystore = IKeystoreService.Stub.asInterface(ServiceManager.getService("android.security.keystore"));
        return new KeyStore(keystore);
    }

    private final synchronized IBinder $$robo$$android_security_KeyStore$getToken() {
        if (this.mToken == null) {
            this.mToken = new Binder();
        }
        return this.mToken;
    }

    private final State $$robo$$android_security_KeyStore$state(int userId) {
        int ret;
        try {
            ret = this.mBinder.getState(userId);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            throw new AssertionError((Object)e);
        }
        switch (ret) {
            case 1: {
                return State.UNLOCKED;
            }
            case 2: {
                return State.LOCKED;
            }
            case 3: {
                return State.UNINITIALIZED;
            }
        }
        throw new AssertionError(this.mError);
    }

    private final State $$robo$$android_security_KeyStore$state() {
        return this.state(UserHandle.myUserId());
    }

    private final boolean $$robo$$android_security_KeyStore$isUnlocked() {
        return this.state() == State.UNLOCKED;
    }

    private final byte[] $$robo$$android_security_KeyStore$get(String key, int uid) {
        try {
            return this.mBinder.get(key, uid);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final byte[] $$robo$$android_security_KeyStore$get(String key) {
        return this.get(key, -1);
    }

    private final boolean $$robo$$android_security_KeyStore$put(String key, byte[] value, int uid, int flags) {
        return this.insert(key, value, uid, flags) == 1;
    }

    private final int $$robo$$android_security_KeyStore$insert(String key, byte[] value, int uid, int flags) {
        try {
            return this.mBinder.insert(key, value, uid, flags);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return 4;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$delete(String key, int uid) {
        try {
            int ret = this.mBinder.del(key, uid);
            return ret == 1 || ret == 7;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$delete(String key) {
        return this.delete(key, -1);
    }

    private final boolean $$robo$$android_security_KeyStore$contains(String key, int uid) {
        try {
            return this.mBinder.exist(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$contains(String key) {
        return this.contains(key, -1);
    }

    private final String[] $$robo$$android_security_KeyStore$list(String prefix, int uid) {
        try {
            return this.mBinder.list(prefix, uid);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final String[] $$robo$$android_security_KeyStore$list(String prefix) {
        return this.list(prefix, -1);
    }

    private final boolean $$robo$$android_security_KeyStore$reset() {
        try {
            return this.mBinder.reset() == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$lock(int userId) {
        try {
            return this.mBinder.lock(userId) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$lock() {
        return this.lock(UserHandle.myUserId());
    }

    private final boolean $$robo$$android_security_KeyStore$unlock(int userId, String password) {
        try {
            this.mError = this.mBinder.unlock(userId, password);
            return this.mError == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$unlock(String password) {
        return this.unlock(UserHandle.getUserId(Process.myUid()), password);
    }

    private final boolean $$robo$$android_security_KeyStore$isEmpty(int userId) {
        try {
            return this.mBinder.isEmpty(userId) != 0;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$isEmpty() {
        return this.isEmpty(UserHandle.myUserId());
    }

    private final boolean $$robo$$android_security_KeyStore$generate(String key, int uid, int keyType, int keySize, int flags, byte[][] args) {
        try {
            return this.mBinder.generate(key, uid, keyType, keySize, flags, new KeystoreArguments(args)) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$importKey(String keyName, byte[] key, int uid, int flags) {
        try {
            return this.mBinder.import_key(keyName, key, uid, flags) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final byte[] $$robo$$android_security_KeyStore$sign(String key, byte[] data) {
        try {
            return this.mBinder.sign(key, data);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$verify(String key, byte[] data, byte[] signature) {
        try {
            return this.mBinder.verify(key, data, signature) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$grant(String key, int uid) {
        try {
            return this.mBinder.grant(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$ungrant(String key, int uid) {
        try {
            return this.mBinder.ungrant(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final long $$robo$$android_security_KeyStore$getmtime(String key, int uid) {
        try {
            long millis = this.mBinder.getmtime(key, uid);
            if (millis == -1L) {
                return -1L;
            }
            return millis * 1000L;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return -1L;
        }
    }

    private final long $$robo$$android_security_KeyStore$getmtime(String key) {
        return this.getmtime(key, -1);
    }

    private final boolean $$robo$$android_security_KeyStore$duplicate(String srcKey, int srcUid, String destKey, int destUid) {
        try {
            return this.mBinder.duplicate(srcKey, srcUid, destKey, destUid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$isHardwareBacked() {
        return this.isHardwareBacked("RSA");
    }

    private final boolean $$robo$$android_security_KeyStore$isHardwareBacked(String keyType) {
        try {
            return this.mBinder.is_hardware_backed(keyType.toUpperCase(Locale.US)) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$clearUid(int uid) {
        try {
            return this.mBinder.clear_uid(uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final int $$robo$$android_security_KeyStore$getLastError() {
        return this.mError;
    }

    private final boolean $$robo$$android_security_KeyStore$addRngEntropy(byte[] data) {
        try {
            return this.mBinder.addRngEntropy(data) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final int $$robo$$android_security_KeyStore$generateKey(String alias, KeymasterArguments args, byte[] entropy, int uid, int flags, KeyCharacteristics outCharacteristics) {
        try {
            return this.mBinder.generateKey(alias, args, entropy, uid, flags, outCharacteristics);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return 4;
        }
    }

    private final int $$robo$$android_security_KeyStore$generateKey(String alias, KeymasterArguments args, byte[] entropy, int flags, KeyCharacteristics outCharacteristics) {
        return this.generateKey(alias, args, entropy, -1, flags, outCharacteristics);
    }

    private final int $$robo$$android_security_KeyStore$getKeyCharacteristics(String alias, KeymasterBlob clientId, KeymasterBlob appId, int uid, KeyCharacteristics outCharacteristics) {
        try {
            return this.mBinder.getKeyCharacteristics(alias, clientId, appId, uid, outCharacteristics);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return 4;
        }
    }

    private final int $$robo$$android_security_KeyStore$getKeyCharacteristics(String alias, KeymasterBlob clientId, KeymasterBlob appId, KeyCharacteristics outCharacteristics) {
        return this.getKeyCharacteristics(alias, clientId, appId, -1, outCharacteristics);
    }

    private final int $$robo$$android_security_KeyStore$importKey(String alias, KeymasterArguments args, int format, byte[] keyData, int uid, int flags, KeyCharacteristics outCharacteristics) {
        try {
            return this.mBinder.importKey(alias, args, format, keyData, uid, flags, outCharacteristics);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return 4;
        }
    }

    private final int $$robo$$android_security_KeyStore$importKey(String alias, KeymasterArguments args, int format, byte[] keyData, int flags, KeyCharacteristics outCharacteristics) {
        return this.importKey(alias, args, format, keyData, -1, flags, outCharacteristics);
    }

    private final ExportResult $$robo$$android_security_KeyStore$exportKey(String alias, int format, KeymasterBlob clientId, KeymasterBlob appId, int uid) {
        try {
            return this.mBinder.exportKey(alias, format, clientId, appId, uid);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final ExportResult $$robo$$android_security_KeyStore$exportKey(String alias, int format, KeymasterBlob clientId, KeymasterBlob appId) {
        return this.exportKey(alias, format, clientId, appId, -1);
    }

    private final OperationResult $$robo$$android_security_KeyStore$begin(String alias, int purpose, boolean pruneable, KeymasterArguments args, byte[] entropy, int uid) {
        try {
            return this.mBinder.begin(this.getToken(), alias, purpose, pruneable, args, entropy, uid);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final OperationResult $$robo$$android_security_KeyStore$begin(String alias, int purpose, boolean pruneable, KeymasterArguments args, byte[] entropy) {
        return this.begin(alias, purpose, pruneable, args, entropy, -1);
    }

    private final OperationResult $$robo$$android_security_KeyStore$update(IBinder token, KeymasterArguments arguments, byte[] input) {
        try {
            return this.mBinder.update(token, arguments, input);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final OperationResult $$robo$$android_security_KeyStore$finish(IBinder token, KeymasterArguments arguments, byte[] signature, byte[] entropy) {
        try {
            return this.mBinder.finish(token, arguments, signature, entropy);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final OperationResult $$robo$$android_security_KeyStore$finish(IBinder token, KeymasterArguments arguments, byte[] signature) {
        return this.finish(token, arguments, signature, null);
    }

    private final int $$robo$$android_security_KeyStore$abort(IBinder token) {
        try {
            return this.mBinder.abort(token);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return 4;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$isOperationAuthorized(IBinder token) {
        try {
            return this.mBinder.isOperationAuthorized(token);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final int $$robo$$android_security_KeyStore$addAuthToken(byte[] authToken) {
        try {
            return this.mBinder.addAuthToken(authToken);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return 4;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$onUserPasswordChanged(int userId, String newPassword) {
        if (newPassword == null) {
            newPassword = "";
        }
        try {
            return this.mBinder.onUserPasswordChanged(userId, newPassword) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final void $$robo$$android_security_KeyStore$onUserAdded(int userId, int parentId) {
        try {
            this.mBinder.onUserAdded(userId, parentId);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
        }
    }

    private final void $$robo$$android_security_KeyStore$onUserAdded(int userId) {
        this.onUserAdded(userId, -1);
    }

    private final void $$robo$$android_security_KeyStore$onUserRemoved(int userId) {
        try {
            this.mBinder.onUserRemoved(userId);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
        }
    }

    private final boolean $$robo$$android_security_KeyStore$onUserPasswordChanged(String newPassword) {
        return this.onUserPasswordChanged(UserHandle.getUserId(Process.myUid()), newPassword);
    }

    private final int $$robo$$android_security_KeyStore$attestKey(String alias, KeymasterArguments params, KeymasterCertificateChain outChain) {
        try {
            return this.mBinder.attestKey(alias, params, outChain);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return 4;
        }
    }

    private final int $$robo$$android_security_KeyStore$attestDeviceIds(KeymasterArguments params, KeymasterCertificateChain outChain) {
        try {
            return this.mBinder.attestDeviceIds(params, outChain);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return 4;
        }
    }

    private final void $$robo$$android_security_KeyStore$onDeviceOffBody() {
        try {
            this.mBinder.onDeviceOffBody();
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
        }
    }

    private static final KeyStoreException $$robo$$android_security_KeyStore$getKeyStoreException(int errorCode) {
        if (errorCode > 0) {
            switch (errorCode) {
                case 1: {
                    return new KeyStoreException(errorCode, "OK");
                }
                case 2: {
                    return new KeyStoreException(errorCode, "User authentication required");
                }
                case 3: {
                    return new KeyStoreException(errorCode, "Keystore not initialized");
                }
                case 4: {
                    return new KeyStoreException(errorCode, "System error");
                }
                case 6: {
                    return new KeyStoreException(errorCode, "Permission denied");
                }
                case 7: {
                    return new KeyStoreException(errorCode, "Key not found");
                }
                case 8: {
                    return new KeyStoreException(errorCode, "Key blob corrupted");
                }
                case 15: {
                    return new KeyStoreException(errorCode, "Operation requires authorization");
                }
            }
            return new KeyStoreException(errorCode, String.valueOf(errorCode));
        }
        switch (errorCode) {
            case -16: {
                return new KeyStoreException(errorCode, "Invalid user authentication validity duration");
            }
        }
        return new KeyStoreException(errorCode, KeymasterDefs.getErrorMessage(errorCode));
    }

    private final InvalidKeyException $$robo$$android_security_KeyStore$getInvalidKeyException(String keystoreKeyAlias, int uid, KeyStoreException e) {
        switch (e.getErrorCode()) {
            case 2: {
                return new UserNotAuthenticatedException();
            }
            case -25: {
                return new KeyExpiredException();
            }
            case -24: {
                return new KeyNotYetValidException();
            }
            case -26: 
            case 15: {
                KeyCharacteristics keyCharacteristics = new KeyCharacteristics();
                int getKeyCharacteristicsErrorCode = this.getKeyCharacteristics(keystoreKeyAlias, null, null, uid, keyCharacteristics);
                if (getKeyCharacteristicsErrorCode != 1) {
                    return new InvalidKeyException("Failed to obtained key characteristics", KeyStore.getKeyStoreException(getKeyCharacteristicsErrorCode));
                }
                List<BigInteger> keySids = keyCharacteristics.getUnsignedLongs(-1610612234);
                if (keySids.isEmpty()) {
                    return new KeyPermanentlyInvalidatedException();
                }
                long rootSid = GateKeeper.getSecureUserId();
                if (rootSid != 0L && keySids.contains(KeymasterArguments.toUint64(rootSid))) {
                    return new UserNotAuthenticatedException();
                }
                long fingerprintOnlySid = this.getFingerprintOnlySid();
                if (fingerprintOnlySid != 0L && keySids.contains(KeymasterArguments.toUint64(fingerprintOnlySid))) {
                    return new UserNotAuthenticatedException();
                }
                return new KeyPermanentlyInvalidatedException();
            }
        }
        return new InvalidKeyException("Keystore operation failed", e);
    }

    private final long $$robo$$android_security_KeyStore$getFingerprintOnlySid() {
        FingerprintManager fingerprintManager = this.mContext.getSystemService(FingerprintManager.class);
        if (fingerprintManager == null) {
            return 0L;
        }
        return fingerprintManager.getAuthenticatorId();
    }

    private final InvalidKeyException $$robo$$android_security_KeyStore$getInvalidKeyException(String keystoreKeyAlias, int uid, int errorCode) {
        return this.getInvalidKeyException(keystoreKeyAlias, uid, KeyStore.getKeyStoreException(errorCode));
    }

    private void __constructor__(IKeystoreService iKeystoreService) {
        this.$$robo$$android_security_KeyStore$__constructor__(iKeystoreService);
    }

    public KeyStore(IKeystoreService iKeystoreService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_KeyStore$__constructor__(android.security.IKeystoreService ), this, iKeystoreService);
    }

    public static Context getApplicationContext() {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationContext", $$robo$$android_security_KeyStore$getApplicationContext());
    }

    public static KeyStore getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_security_KeyStore$getInstance());
    }

    private synchronized IBinder getToken() {
        return InvokeDynamicSupport.bootstrap("getToken", $$robo$$android_security_KeyStore$getToken(), this);
    }

    public State state(int n) {
        return InvokeDynamicSupport.bootstrap("state", $$robo$$android_security_KeyStore$state(int ), this, n);
    }

    public State state() {
        return InvokeDynamicSupport.bootstrap("state", $$robo$$android_security_KeyStore$state(), this);
    }

    public boolean isUnlocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnlocked", $$robo$$android_security_KeyStore$isUnlocked(), this);
    }

    public byte[] get(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_security_KeyStore$get(java.lang.String int ), this, string2, n);
    }

    public byte[] get(String string2) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_security_KeyStore$get(java.lang.String ), this, string2);
    }

    public boolean put(String string2, byte[] byArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("put", $$robo$$android_security_KeyStore$put(java.lang.String byte[] int int ), this, string2, byArray, n, n2);
    }

    public int insert(String string2, byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("insert", $$robo$$android_security_KeyStore$insert(java.lang.String byte[] int int ), this, string2, byArray, n, n2);
    }

    public boolean delete(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_security_KeyStore$delete(java.lang.String int ), this, string2, n);
    }

    public boolean delete(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_security_KeyStore$delete(java.lang.String ), this, string2);
    }

    public boolean contains(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_security_KeyStore$contains(java.lang.String int ), this, string2, n);
    }

    public boolean contains(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_security_KeyStore$contains(java.lang.String ), this, string2);
    }

    public String[] list(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("list", $$robo$$android_security_KeyStore$list(java.lang.String int ), this, string2, n);
    }

    public String[] list(String string2) {
        return InvokeDynamicSupport.bootstrap("list", $$robo$$android_security_KeyStore$list(java.lang.String ), this, string2);
    }

    public boolean reset() {
        return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$android_security_KeyStore$reset(), this);
    }

    public boolean lock(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("lock", $$robo$$android_security_KeyStore$lock(int ), this, n);
    }

    public boolean lock() {
        return (boolean)InvokeDynamicSupport.bootstrap("lock", $$robo$$android_security_KeyStore$lock(), this);
    }

    public boolean unlock(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("unlock", $$robo$$android_security_KeyStore$unlock(int java.lang.String ), this, n, string2);
    }

    public boolean unlock(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("unlock", $$robo$$android_security_KeyStore$unlock(java.lang.String ), this, string2);
    }

    public boolean isEmpty(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_security_KeyStore$isEmpty(int ), this, n);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_security_KeyStore$isEmpty(), this);
    }

    public boolean generate(String string2, int n, int n2, int n3, int n4, byte[][] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("generate", $$robo$$android_security_KeyStore$generate(java.lang.String int int int int byte[][] ), this, string2, n, n2, n3, n4, byArray);
    }

    public boolean importKey(String string2, byte[] byArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("importKey", $$robo$$android_security_KeyStore$importKey(java.lang.String byte[] int int ), this, string2, byArray, n, n2);
    }

    public byte[] sign(String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("sign", $$robo$$android_security_KeyStore$sign(java.lang.String byte[] ), this, string2, byArray);
    }

    public boolean verify(String string2, byte[] byArray, byte[] byArray2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verify", $$robo$$android_security_KeyStore$verify(java.lang.String byte[] byte[] ), this, string2, byArray, byArray2);
    }

    public boolean grant(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("grant", $$robo$$android_security_KeyStore$grant(java.lang.String int ), this, string2, n);
    }

    public boolean ungrant(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("ungrant", $$robo$$android_security_KeyStore$ungrant(java.lang.String int ), this, string2, n);
    }

    public long getmtime(String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getmtime", $$robo$$android_security_KeyStore$getmtime(java.lang.String int ), this, string2, n);
    }

    public long getmtime(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("getmtime", $$robo$$android_security_KeyStore$getmtime(java.lang.String ), this, string2);
    }

    public boolean duplicate(String string2, int n, String string3, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("duplicate", $$robo$$android_security_KeyStore$duplicate(java.lang.String int java.lang.String int ), this, string2, n, string3, n2);
    }

    public boolean isHardwareBacked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareBacked", $$robo$$android_security_KeyStore$isHardwareBacked(), this);
    }

    public boolean isHardwareBacked(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareBacked", $$robo$$android_security_KeyStore$isHardwareBacked(java.lang.String ), this, string2);
    }

    public boolean clearUid(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearUid", $$robo$$android_security_KeyStore$clearUid(int ), this, n);
    }

    public int getLastError() {
        return (int)InvokeDynamicSupport.bootstrap("getLastError", $$robo$$android_security_KeyStore$getLastError(), this);
    }

    public boolean addRngEntropy(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("addRngEntropy", $$robo$$android_security_KeyStore$addRngEntropy(byte[] ), this, byArray);
    }

    public int generateKey(String string2, KeymasterArguments keymasterArguments, byte[] byArray, int n, int n2, KeyCharacteristics keyCharacteristics) {
        return (int)InvokeDynamicSupport.bootstrap("generateKey", $$robo$$android_security_KeyStore$generateKey(java.lang.String android.security.keymaster.KeymasterArguments byte[] int int android.security.keymaster.KeyCharacteristics ), this, string2, keymasterArguments, byArray, n, n2, keyCharacteristics);
    }

    public int generateKey(String string2, KeymasterArguments keymasterArguments, byte[] byArray, int n, KeyCharacteristics keyCharacteristics) {
        return (int)InvokeDynamicSupport.bootstrap("generateKey", $$robo$$android_security_KeyStore$generateKey(java.lang.String android.security.keymaster.KeymasterArguments byte[] int android.security.keymaster.KeyCharacteristics ), this, string2, keymasterArguments, byArray, n, keyCharacteristics);
    }

    public int getKeyCharacteristics(String string2, KeymasterBlob keymasterBlob, KeymasterBlob keymasterBlob2, int n, KeyCharacteristics keyCharacteristics) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyCharacteristics", $$robo$$android_security_KeyStore$getKeyCharacteristics(java.lang.String android.security.keymaster.KeymasterBlob android.security.keymaster.KeymasterBlob int android.security.keymaster.KeyCharacteristics ), this, string2, keymasterBlob, keymasterBlob2, n, keyCharacteristics);
    }

    public int getKeyCharacteristics(String string2, KeymasterBlob keymasterBlob, KeymasterBlob keymasterBlob2, KeyCharacteristics keyCharacteristics) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyCharacteristics", $$robo$$android_security_KeyStore$getKeyCharacteristics(java.lang.String android.security.keymaster.KeymasterBlob android.security.keymaster.KeymasterBlob android.security.keymaster.KeyCharacteristics ), this, string2, keymasterBlob, keymasterBlob2, keyCharacteristics);
    }

    public int importKey(String string2, KeymasterArguments keymasterArguments, int n, byte[] byArray, int n2, int n3, KeyCharacteristics keyCharacteristics) {
        return (int)InvokeDynamicSupport.bootstrap("importKey", $$robo$$android_security_KeyStore$importKey(java.lang.String android.security.keymaster.KeymasterArguments int byte[] int int android.security.keymaster.KeyCharacteristics ), this, string2, keymasterArguments, n, byArray, n2, n3, keyCharacteristics);
    }

    public int importKey(String string2, KeymasterArguments keymasterArguments, int n, byte[] byArray, int n2, KeyCharacteristics keyCharacteristics) {
        return (int)InvokeDynamicSupport.bootstrap("importKey", $$robo$$android_security_KeyStore$importKey(java.lang.String android.security.keymaster.KeymasterArguments int byte[] int android.security.keymaster.KeyCharacteristics ), this, string2, keymasterArguments, n, byArray, n2, keyCharacteristics);
    }

    public ExportResult exportKey(String string2, int n, KeymasterBlob keymasterBlob, KeymasterBlob keymasterBlob2, int n2) {
        return InvokeDynamicSupport.bootstrap("exportKey", $$robo$$android_security_KeyStore$exportKey(java.lang.String int android.security.keymaster.KeymasterBlob android.security.keymaster.KeymasterBlob int ), this, string2, n, keymasterBlob, keymasterBlob2, n2);
    }

    public ExportResult exportKey(String string2, int n, KeymasterBlob keymasterBlob, KeymasterBlob keymasterBlob2) {
        return InvokeDynamicSupport.bootstrap("exportKey", $$robo$$android_security_KeyStore$exportKey(java.lang.String int android.security.keymaster.KeymasterBlob android.security.keymaster.KeymasterBlob ), this, string2, n, keymasterBlob, keymasterBlob2);
    }

    public OperationResult begin(String string2, int n, boolean bl, KeymasterArguments keymasterArguments, byte[] byArray, int n2) {
        return InvokeDynamicSupport.bootstrap("begin", $$robo$$android_security_KeyStore$begin(java.lang.String int boolean android.security.keymaster.KeymasterArguments byte[] int ), this, string2, n, bl, keymasterArguments, byArray, n2);
    }

    public OperationResult begin(String string2, int n, boolean bl, KeymasterArguments keymasterArguments, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("begin", $$robo$$android_security_KeyStore$begin(java.lang.String int boolean android.security.keymaster.KeymasterArguments byte[] ), this, string2, n, bl, keymasterArguments, byArray);
    }

    public OperationResult update(IBinder iBinder, KeymasterArguments keymasterArguments, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("update", $$robo$$android_security_KeyStore$update(android.os.IBinder android.security.keymaster.KeymasterArguments byte[] ), this, iBinder, keymasterArguments, byArray);
    }

    public OperationResult finish(IBinder iBinder, KeymasterArguments keymasterArguments, byte[] byArray, byte[] byArray2) {
        return InvokeDynamicSupport.bootstrap("finish", $$robo$$android_security_KeyStore$finish(android.os.IBinder android.security.keymaster.KeymasterArguments byte[] byte[] ), this, iBinder, keymasterArguments, byArray, byArray2);
    }

    public OperationResult finish(IBinder iBinder, KeymasterArguments keymasterArguments, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("finish", $$robo$$android_security_KeyStore$finish(android.os.IBinder android.security.keymaster.KeymasterArguments byte[] ), this, iBinder, keymasterArguments, byArray);
    }

    public int abort(IBinder iBinder) {
        return (int)InvokeDynamicSupport.bootstrap("abort", $$robo$$android_security_KeyStore$abort(android.os.IBinder ), this, iBinder);
    }

    public boolean isOperationAuthorized(IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOperationAuthorized", $$robo$$android_security_KeyStore$isOperationAuthorized(android.os.IBinder ), this, iBinder);
    }

    public int addAuthToken(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("addAuthToken", $$robo$$android_security_KeyStore$addAuthToken(byte[] ), this, byArray);
    }

    public boolean onUserPasswordChanged(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onUserPasswordChanged", $$robo$$android_security_KeyStore$onUserPasswordChanged(int java.lang.String ), this, n, string2);
    }

    public void onUserAdded(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onUserAdded", $$robo$$android_security_KeyStore$onUserAdded(int int ), this, n, n2);
    }

    public void onUserAdded(int n) {
        InvokeDynamicSupport.bootstrap("onUserAdded", $$robo$$android_security_KeyStore$onUserAdded(int ), this, n);
    }

    public void onUserRemoved(int n) {
        InvokeDynamicSupport.bootstrap("onUserRemoved", $$robo$$android_security_KeyStore$onUserRemoved(int ), this, n);
    }

    public boolean onUserPasswordChanged(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onUserPasswordChanged", $$robo$$android_security_KeyStore$onUserPasswordChanged(java.lang.String ), this, string2);
    }

    public int attestKey(String string2, KeymasterArguments keymasterArguments, KeymasterCertificateChain keymasterCertificateChain) {
        return (int)InvokeDynamicSupport.bootstrap("attestKey", $$robo$$android_security_KeyStore$attestKey(java.lang.String android.security.keymaster.KeymasterArguments android.security.keymaster.KeymasterCertificateChain ), this, string2, keymasterArguments, keymasterCertificateChain);
    }

    public int attestDeviceIds(KeymasterArguments keymasterArguments, KeymasterCertificateChain keymasterCertificateChain) {
        return (int)InvokeDynamicSupport.bootstrap("attestDeviceIds", $$robo$$android_security_KeyStore$attestDeviceIds(android.security.keymaster.KeymasterArguments android.security.keymaster.KeymasterCertificateChain ), this, keymasterArguments, keymasterCertificateChain);
    }

    public void onDeviceOffBody() {
        InvokeDynamicSupport.bootstrap("onDeviceOffBody", $$robo$$android_security_KeyStore$onDeviceOffBody(), this);
    }

    public static KeyStoreException getKeyStoreException(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getKeyStoreException", $$robo$$android_security_KeyStore$getKeyStoreException(int ), (int)n);
    }

    public InvalidKeyException getInvalidKeyException(String string2, int n, KeyStoreException keyStoreException) {
        return InvokeDynamicSupport.bootstrap("getInvalidKeyException", $$robo$$android_security_KeyStore$getInvalidKeyException(java.lang.String int android.security.KeyStoreException ), this, string2, n, keyStoreException);
    }

    private long getFingerprintOnlySid() {
        return (long)InvokeDynamicSupport.bootstrap("getFingerprintOnlySid", $$robo$$android_security_KeyStore$getFingerprintOnlySid(), this);
    }

    public InvalidKeyException getInvalidKeyException(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getInvalidKeyException", $$robo$$android_security_KeyStore$getInvalidKeyException(java.lang.String int int ), this, string2, n, n2);
    }

    public /* synthetic */ KeyStore() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyStore)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class State
    extends Enum<State> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ State UNLOCKED;
        public static /* enum */ State LOCKED;
        public static /* enum */ State UNINITIALIZED;
        private static /* synthetic */ State[] $VALUES;

        private static final State[] $$robo$$android_security_KeyStore_State$values() {
            return (State[])$VALUES.clone();
        }

        private static final State $$robo$$android_security_KeyStore_State$valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_security_KeyStore_State$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            UNLOCKED = new State();
            LOCKED = new State();
            UNINITIALIZED = new State();
            $VALUES = new State[]{UNLOCKED, LOCKED, UNINITIALIZED};
        }

        public static State[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_security_KeyStore_State$values());
        }

        public static State valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_security_KeyStore_State$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_security_KeyStore_State$__constructor__(string2, n);
        }

        public State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_KeyStore_State$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(State.class);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

