/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class DialogPreference
extends Preference
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener,
PreferenceManager.OnActivityDestroyListener,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private AlertDialog.Builder mBuilder;
    private CharSequence mDialogTitle;
    private CharSequence mDialogMessage;
    private Drawable mDialogIcon;
    private CharSequence mPositiveButtonText;
    private CharSequence mNegativeButtonText;
    private int mDialogLayoutResId;
    private Dialog mDialog;
    private int mWhichButtonClicked;

    private void $$robo$$android_preference_DialogPreference$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DialogPreference, defStyleAttr, defStyleRes);
        this.mDialogTitle = a.getString(0);
        if (this.mDialogTitle == null) {
            this.mDialogTitle = this.getTitle();
        }
        this.mDialogMessage = a.getString(1);
        this.mDialogIcon = a.getDrawable(2);
        this.mPositiveButtonText = a.getString(3);
        this.mNegativeButtonText = a.getString(4);
        this.mDialogLayoutResId = a.getResourceId(5, this.mDialogLayoutResId);
        a.recycle();
    }

    private void $$robo$$android_preference_DialogPreference$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_preference_DialogPreference$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_preference_DialogPreference$__constructor__(Context context) {
    }

    private final void $$robo$$android_preference_DialogPreference$setDialogTitle(CharSequence dialogTitle) {
        this.mDialogTitle = dialogTitle;
    }

    private final void $$robo$$android_preference_DialogPreference$setDialogTitle(int dialogTitleResId) {
        this.setDialogTitle(this.getContext().getString(dialogTitleResId));
    }

    private final CharSequence $$robo$$android_preference_DialogPreference$getDialogTitle() {
        return this.mDialogTitle;
    }

    private final void $$robo$$android_preference_DialogPreference$setDialogMessage(CharSequence dialogMessage) {
        this.mDialogMessage = dialogMessage;
    }

    private final void $$robo$$android_preference_DialogPreference$setDialogMessage(int dialogMessageResId) {
        this.setDialogMessage(this.getContext().getString(dialogMessageResId));
    }

    private final CharSequence $$robo$$android_preference_DialogPreference$getDialogMessage() {
        return this.mDialogMessage;
    }

    private final void $$robo$$android_preference_DialogPreference$setDialogIcon(Drawable dialogIcon) {
        this.mDialogIcon = dialogIcon;
    }

    private final void $$robo$$android_preference_DialogPreference$setDialogIcon(int dialogIconRes) {
        this.mDialogIcon = this.getContext().getDrawable(dialogIconRes);
    }

    private final Drawable $$robo$$android_preference_DialogPreference$getDialogIcon() {
        return this.mDialogIcon;
    }

    private final void $$robo$$android_preference_DialogPreference$setPositiveButtonText(CharSequence positiveButtonText) {
        this.mPositiveButtonText = positiveButtonText;
    }

    private final void $$robo$$android_preference_DialogPreference$setPositiveButtonText(int positiveButtonTextResId) {
        this.setPositiveButtonText(this.getContext().getString(positiveButtonTextResId));
    }

    private final CharSequence $$robo$$android_preference_DialogPreference$getPositiveButtonText() {
        return this.mPositiveButtonText;
    }

    private final void $$robo$$android_preference_DialogPreference$setNegativeButtonText(CharSequence negativeButtonText) {
        this.mNegativeButtonText = negativeButtonText;
    }

    private final void $$robo$$android_preference_DialogPreference$setNegativeButtonText(int negativeButtonTextResId) {
        this.setNegativeButtonText(this.getContext().getString(negativeButtonTextResId));
    }

    private final CharSequence $$robo$$android_preference_DialogPreference$getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    private final void $$robo$$android_preference_DialogPreference$setDialogLayoutResource(int dialogLayoutResId) {
        this.mDialogLayoutResId = dialogLayoutResId;
    }

    private final int $$robo$$android_preference_DialogPreference$getDialogLayoutResource() {
        return this.mDialogLayoutResId;
    }

    private final void $$robo$$android_preference_DialogPreference$onPrepareDialogBuilder(AlertDialog.Builder builder) {
    }

    private final void $$robo$$android_preference_DialogPreference$onClick() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            return;
        }
        this.showDialog(null);
    }

    private final void $$robo$$android_preference_DialogPreference$showDialog(Bundle state) {
        Context context = this.getContext();
        this.mWhichButtonClicked = -2;
        this.mBuilder = new AlertDialog.Builder(context).setTitle(this.mDialogTitle).setIcon(this.mDialogIcon).setPositiveButton(this.mPositiveButtonText, (DialogInterface.OnClickListener)this).setNegativeButton(this.mNegativeButtonText, (DialogInterface.OnClickListener)this);
        View contentView = this.onCreateDialogView();
        if (contentView != null) {
            this.onBindDialogView(contentView);
            this.mBuilder.setView(contentView);
        } else {
            this.mBuilder.setMessage(this.mDialogMessage);
        }
        this.onPrepareDialogBuilder(this.mBuilder);
        this.getPreferenceManager().registerOnActivityDestroyListener(this);
        this.mDialog = this.mBuilder.create();
        AlertDialog dialog = this.mDialog;
        if (state != null) {
            dialog.onRestoreInstanceState(state);
        }
        if (this.needInputMethod()) {
            this.requestInputMethod(dialog);
        }
        dialog.setOnDismissListener(this);
        dialog.show();
    }

    private final boolean $$robo$$android_preference_DialogPreference$needInputMethod() {
        return false;
    }

    private final void $$robo$$android_preference_DialogPreference$requestInputMethod(Dialog dialog) {
        Window window = dialog.getWindow();
        window.setSoftInputMode(5);
    }

    private final View $$robo$$android_preference_DialogPreference$onCreateDialogView() {
        if (this.mDialogLayoutResId == 0) {
            return null;
        }
        LayoutInflater inflater = LayoutInflater.from(this.mBuilder.getContext());
        return inflater.inflate(this.mDialogLayoutResId, null);
    }

    private final void $$robo$$android_preference_DialogPreference$onBindDialogView(View view) {
        Object dialogMessageView = view.findViewById(16908299);
        if (dialogMessageView != null) {
            CharSequence message = this.getDialogMessage();
            int newVisibility = 8;
            if (!TextUtils.isEmpty(message)) {
                if (dialogMessageView instanceof TextView) {
                    ((TextView)dialogMessageView).setText(message);
                }
                newVisibility = 0;
            }
            if (((View)dialogMessageView).getVisibility() != newVisibility) {
                ((View)dialogMessageView).setVisibility(newVisibility);
            }
        }
    }

    private final void $$robo$$android_preference_DialogPreference$onClick(DialogInterface dialog, int which) {
        this.mWhichButtonClicked = which;
    }

    private final void $$robo$$android_preference_DialogPreference$onDismiss(DialogInterface dialog) {
        this.getPreferenceManager().unregisterOnActivityDestroyListener(this);
        this.mDialog = null;
        this.onDialogClosed(this.mWhichButtonClicked == -1);
    }

    private final void $$robo$$android_preference_DialogPreference$onDialogClosed(boolean positiveResult) {
    }

    private final Dialog $$robo$$android_preference_DialogPreference$getDialog() {
        return this.mDialog;
    }

    private final void $$robo$$android_preference_DialogPreference$onActivityDestroy() {
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return;
        }
        this.mDialog.dismiss();
    }

    private final Parcelable $$robo$$android_preference_DialogPreference$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = this.mDialog.onSaveInstanceState();
        return myState;
    }

    private final void $$robo$$android_preference_DialogPreference$onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_preference_DialogPreference$__constructor__(context, attributeSet, n, n2);
    }

    public DialogPreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_DialogPreference$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_preference_DialogPreference$__constructor__(context, attributeSet, n);
    }

    public DialogPreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_DialogPreference$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_preference_DialogPreference$__constructor__(context, attributeSet);
    }

    public DialogPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010091);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_DialogPreference$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_preference_DialogPreference$__constructor__(context);
    }

    public DialogPreference(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_DialogPreference$__constructor__(android.content.Context ), this, context);
    }

    public void setDialogTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setDialogTitle", $$robo$$android_preference_DialogPreference$setDialogTitle(java.lang.CharSequence ), this, charSequence);
    }

    public void setDialogTitle(int n) {
        InvokeDynamicSupport.bootstrap("setDialogTitle", $$robo$$android_preference_DialogPreference$setDialogTitle(int ), this, n);
    }

    public CharSequence getDialogTitle() {
        return InvokeDynamicSupport.bootstrap("getDialogTitle", $$robo$$android_preference_DialogPreference$getDialogTitle(), this);
    }

    public void setDialogMessage(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setDialogMessage", $$robo$$android_preference_DialogPreference$setDialogMessage(java.lang.CharSequence ), this, charSequence);
    }

    public void setDialogMessage(int n) {
        InvokeDynamicSupport.bootstrap("setDialogMessage", $$robo$$android_preference_DialogPreference$setDialogMessage(int ), this, n);
    }

    public CharSequence getDialogMessage() {
        return InvokeDynamicSupport.bootstrap("getDialogMessage", $$robo$$android_preference_DialogPreference$getDialogMessage(), this);
    }

    public void setDialogIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDialogIcon", $$robo$$android_preference_DialogPreference$setDialogIcon(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public void setDialogIcon(int n) {
        InvokeDynamicSupport.bootstrap("setDialogIcon", $$robo$$android_preference_DialogPreference$setDialogIcon(int ), this, n);
    }

    public Drawable getDialogIcon() {
        return InvokeDynamicSupport.bootstrap("getDialogIcon", $$robo$$android_preference_DialogPreference$getDialogIcon(), this);
    }

    public void setPositiveButtonText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setPositiveButtonText", $$robo$$android_preference_DialogPreference$setPositiveButtonText(java.lang.CharSequence ), this, charSequence);
    }

    public void setPositiveButtonText(int n) {
        InvokeDynamicSupport.bootstrap("setPositiveButtonText", $$robo$$android_preference_DialogPreference$setPositiveButtonText(int ), this, n);
    }

    public CharSequence getPositiveButtonText() {
        return InvokeDynamicSupport.bootstrap("getPositiveButtonText", $$robo$$android_preference_DialogPreference$getPositiveButtonText(), this);
    }

    public void setNegativeButtonText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setNegativeButtonText", $$robo$$android_preference_DialogPreference$setNegativeButtonText(java.lang.CharSequence ), this, charSequence);
    }

    public void setNegativeButtonText(int n) {
        InvokeDynamicSupport.bootstrap("setNegativeButtonText", $$robo$$android_preference_DialogPreference$setNegativeButtonText(int ), this, n);
    }

    public CharSequence getNegativeButtonText() {
        return InvokeDynamicSupport.bootstrap("getNegativeButtonText", $$robo$$android_preference_DialogPreference$getNegativeButtonText(), this);
    }

    public void setDialogLayoutResource(int n) {
        InvokeDynamicSupport.bootstrap("setDialogLayoutResource", $$robo$$android_preference_DialogPreference$setDialogLayoutResource(int ), this, n);
    }

    public int getDialogLayoutResource() {
        return (int)InvokeDynamicSupport.bootstrap("getDialogLayoutResource", $$robo$$android_preference_DialogPreference$getDialogLayoutResource(), this);
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        InvokeDynamicSupport.bootstrap("onPrepareDialogBuilder", $$robo$$android_preference_DialogPreference$onPrepareDialogBuilder(android.app.AlertDialog$Builder ), this, builder);
    }

    @Override
    protected void onClick() {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_preference_DialogPreference$onClick(), this);
    }

    protected void showDialog(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("showDialog", $$robo$$android_preference_DialogPreference$showDialog(android.os.Bundle ), this, bundle);
    }

    protected boolean needInputMethod() {
        return (boolean)InvokeDynamicSupport.bootstrap("needInputMethod", $$robo$$android_preference_DialogPreference$needInputMethod(), this);
    }

    private void requestInputMethod(Dialog dialog) {
        InvokeDynamicSupport.bootstrap("requestInputMethod", $$robo$$android_preference_DialogPreference$requestInputMethod(android.app.Dialog ), this, dialog);
    }

    protected View onCreateDialogView() {
        return InvokeDynamicSupport.bootstrap("onCreateDialogView", $$robo$$android_preference_DialogPreference$onCreateDialogView(), this);
    }

    protected void onBindDialogView(View view) {
        InvokeDynamicSupport.bootstrap("onBindDialogView", $$robo$$android_preference_DialogPreference$onBindDialogView(android.view.View ), this, view);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_preference_DialogPreference$onClick(android.content.DialogInterface int ), this, dialogInterface, n);
    }

    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$android_preference_DialogPreference$onDismiss(android.content.DialogInterface ), this, dialogInterface);
    }

    protected void onDialogClosed(boolean bl) {
        InvokeDynamicSupport.bootstrap("onDialogClosed", $$robo$$android_preference_DialogPreference$onDialogClosed(boolean ), this, bl);
    }

    public Dialog getDialog() {
        return InvokeDynamicSupport.bootstrap("getDialog", $$robo$$android_preference_DialogPreference$getDialog(), this);
    }

    @Override
    public void onActivityDestroy() {
        InvokeDynamicSupport.bootstrap("onActivityDestroy", $$robo$$android_preference_DialogPreference$onActivityDestroy(), this);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_preference_DialogPreference$onSaveInstanceState(), this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_preference_DialogPreference$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    public /* synthetic */ DialogPreference() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DialogPreference)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SavedState
    extends Preference.BaseSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        boolean isDialogShowing;
        Bundle dialogBundle;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_preference_DialogPreference_SavedState$__constructor__(Parcel source) {
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        private final void $$robo$$android_preference_DialogPreference_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }

        private void $$robo$$android_preference_DialogPreference_SavedState$__constructor__(Parcelable superState) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_preference_DialogPreference_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_preference_DialogPreference_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_preference_DialogPreference_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_preference_DialogPreference_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_DialogPreference_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_preference_DialogPreference_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_preference_DialogPreference_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_preference_DialogPreference_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_DialogPreference_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_preference_DialogPreference_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_preference_DialogPreference_SavedState$__constructor__(parcelable);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_DialogPreference_SavedState$__constructor__(android.os.Parcelable ), this, parcelable);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

