/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemClock;
import android.os.SystemProperties;
import com.google.android.collect.Maps;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SystemService
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static HashMap<String, State> sStates;
    private static Object sPropertyLock;

    private void $$robo$$android_os_SystemService$__constructor__() {
    }

    private static final void $$robo$$android_os_SystemService$start(String name) {
        SystemProperties.set("ctl.start", name);
    }

    private static final void $$robo$$android_os_SystemService$stop(String name) {
        SystemProperties.set("ctl.stop", name);
    }

    private static final void $$robo$$android_os_SystemService$restart(String name) {
        SystemProperties.set("ctl.restart", name);
    }

    private static final State $$robo$$android_os_SystemService$getState(String service) {
        String rawState = SystemProperties.get("init.svc." + service);
        State state = sStates.get(rawState);
        if (state != null) {
            return state;
        }
        return State.STOPPED;
    }

    private static final boolean $$robo$$android_os_SystemService$isStopped(String service) {
        return State.STOPPED.equals((Object)SystemService.getState(service));
    }

    private static final boolean $$robo$$android_os_SystemService$isRunning(String service) {
        return State.RUNNING.equals((Object)SystemService.getState(service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_SystemService$waitForState(String service, State state, long timeoutMillis) throws TimeoutException {
        long endMillis = SystemClock.elapsedRealtime() + timeoutMillis;
        while (true) {
            Object object = sPropertyLock;
            synchronized (object) {
                State currentState = SystemService.getState(service);
                if (state.equals((Object)currentState)) {
                    return;
                }
                if (SystemClock.elapsedRealtime() >= endMillis) {
                    throw new TimeoutException("Service " + service + " currently " + (Object)((Object)currentState) + "; waited " + timeoutMillis + "ms for " + (Object)((Object)state));
                }
                try {
                    sPropertyLock.wait(timeoutMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_SystemService$waitForAnyStopped(String ... services) {
        while (true) {
            Object object = sPropertyLock;
            synchronized (object) {
                for (String service : services) {
                    if (!State.STOPPED.equals((Object)SystemService.getState(service))) continue;
                    return;
                }
                try {
                    sPropertyLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static void __staticInitializer__() {
        sStates = Maps.newHashMap();
        sPropertyLock = new Object();
        SystemProperties.addChangeCallback(new Runnable(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_SystemService_1$__constructor__() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_SystemService_1$run() {
                Object object = sPropertyLock;
                synchronized (object) {
                    sPropertyLock.notifyAll();
                }
            }

            private void __constructor__() {
                this.$$robo$$android_os_SystemService_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SystemService_1$__constructor__(), this);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_SystemService_1$run(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private void __constructor__() {
        this.$$robo$$android_os_SystemService$__constructor__();
    }

    public SystemService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SystemService$__constructor__(), this);
    }

    public static void start(String string2) {
        InvokeDynamicSupport.bootstrapStatic("start", $$robo$$android_os_SystemService$start(java.lang.String ), (String)string2);
    }

    public static void stop(String string2) {
        InvokeDynamicSupport.bootstrapStatic("stop", $$robo$$android_os_SystemService$stop(java.lang.String ), (String)string2);
    }

    public static void restart(String string2) {
        InvokeDynamicSupport.bootstrapStatic("restart", $$robo$$android_os_SystemService$restart(java.lang.String ), (String)string2);
    }

    public static State getState(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getState", $$robo$$android_os_SystemService$getState(java.lang.String ), (String)string2);
    }

    public static boolean isStopped(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStopped", $$robo$$android_os_SystemService$isStopped(java.lang.String ), (String)string2);
    }

    public static boolean isRunning(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRunning", $$robo$$android_os_SystemService$isRunning(java.lang.String ), (String)string2);
    }

    public static void waitForState(String string2, State state, long l) throws TimeoutException {
        InvokeDynamicSupport.bootstrapStatic("waitForState", $$robo$$android_os_SystemService$waitForState(java.lang.String android.os.SystemService$State long ), (String)string2, (State)state, (long)l);
    }

    public static void waitForAnyStopped(String ... stringArray) {
        InvokeDynamicSupport.bootstrapStatic("waitForAnyStopped", $$robo$$android_os_SystemService$waitForAnyStopped(java.lang.String[] ), (String[])stringArray);
    }

    static {
        RobolectricInternals.classInitializing(SystemService.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemService)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class State
    extends Enum<State> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ State RUNNING;
        public static /* enum */ State STOPPING;
        public static /* enum */ State STOPPED;
        public static /* enum */ State RESTARTING;
        private static /* synthetic */ State[] $VALUES;

        private static final State[] $$robo$$android_os_SystemService_State$values() {
            return (State[])$VALUES.clone();
        }

        private static final State $$robo$$android_os_SystemService_State$valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_os_SystemService_State$__constructor__(String string2, int n, String state) {
            sStates.put(state, this);
        }

        static void __staticInitializer__() {
            RUNNING = new State("running");
            STOPPING = new State("stopping");
            STOPPED = new State("stopped");
            RESTARTING = new State("restarting");
            $VALUES = new State[]{RUNNING, STOPPING, STOPPED, RESTARTING};
        }

        public static State[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_os_SystemService_State$values());
        }

        public static State valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_os_SystemService_State$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, String string3) {
            this.$$robo$$android_os_SystemService_State$__constructor__(string2, n, string3);
        }

        public State(String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SystemService_State$__constructor__(java.lang.String int java.lang.String ), this, string2, n, string3);
        }

        static {
            RobolectricInternals.classInitializing(State.class);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

