/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.app.IActivityManager;
import android.content.Intent;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.FileUriExposedException;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.NetworkOnMainThreadException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Printer;
import android.util.Singleton;
import android.view.IWindowManager;
import com.android.internal.os.RuntimeInit;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.HexDump;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import dalvik.system.VMDebug;
import dalvik.system.VMRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class StrictMode
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "StrictMode";
    private static boolean LOG_V;
    private static boolean IS_USER_BUILD;
    private static boolean IS_ENG_BUILD;
    public static String DISABLE_PROPERTY = "persist.sys.strictmode.disable";
    public static String VISUAL_PROPERTY = "persist.sys.strictmode.visual";
    private static String CLEARTEXT_PROPERTY = "persist.sys.strictmode.clear";
    private static long MIN_LOG_INTERVAL_MS = 1000L;
    private static long MIN_DIALOG_INTERVAL_MS = 30000L;
    private static int MAX_SPAN_TAGS = 20;
    private static int MAX_OFFENSES_PER_LOOP = 10;
    public static int DETECT_DISK_WRITE = 1;
    public static int DETECT_DISK_READ = 2;
    public static int DETECT_NETWORK = 4;
    public static int DETECT_CUSTOM = 8;
    public static int DETECT_RESOURCE_MISMATCH = 16;
    public static int DETECT_UNBUFFERED_IO = 32;
    private static int ALL_THREAD_DETECT_BITS = 63;
    public static int DETECT_VM_CURSOR_LEAKS = 256;
    public static int DETECT_VM_CLOSABLE_LEAKS = 512;
    public static int DETECT_VM_ACTIVITY_LEAKS = 1024;
    private static int DETECT_VM_INSTANCE_LEAKS = 2048;
    public static int DETECT_VM_REGISTRATION_LEAKS = 4096;
    private static int DETECT_VM_FILE_URI_EXPOSURE = 8192;
    private static int DETECT_VM_CLEARTEXT_NETWORK = 16384;
    private static int DETECT_VM_CONTENT_URI_WITHOUT_PERMISSION = 32768;
    private static int DETECT_VM_UNTAGGED_SOCKET = Integer.MIN_VALUE;
    private static int ALL_VM_DETECT_BITS = -2147418368;
    public static int PENALTY_LOG = 65536;
    public static int PENALTY_DIALOG = 131072;
    public static int PENALTY_DEATH = 262144;
    public static int PENALTY_FLASH = 0x100000;
    public static int PENALTY_DROPBOX = 0x200000;
    public static int PENALTY_GATHER = 0x400000;
    public static int PENALTY_DEATH_ON_NETWORK = 0x1000000;
    public static int PENALTY_DEATH_ON_CLEARTEXT_NETWORK = 0x2000000;
    public static int PENALTY_DEATH_ON_FILE_URI_EXPOSURE = 0x4000000;
    private static int THREAD_PENALTY_MASK = 0x1770000;
    private static int VM_PENALTY_MASK = 103088128;
    public static int NETWORK_POLICY_ACCEPT = 0;
    public static int NETWORK_POLICY_LOG = 1;
    public static int NETWORK_POLICY_REJECT = 2;
    private static HashMap<Class, Integer> EMPTY_CLASS_LIMIT_MAP;
    private static volatile int sVmPolicyMask;
    private static volatile VmPolicy sVmPolicy;
    private static volatile ViolationListener sListener;
    private static AtomicInteger sDropboxCallsInFlight;
    private static ThreadLocal<ArrayList<ViolationInfo>> gatheredViolations;
    private static ThreadLocal<ArrayList<ViolationInfo>> violationsBeingTimed;
    private static ThreadLocal<Handler> threadHandler;
    private static ThreadLocal<AndroidBlockGuardPolicy> threadAndroidPolicy;
    private static long sLastInstanceCountCheckMillis;
    private static boolean sIsIdlerRegistered;
    private static MessageQueue.IdleHandler sProcessIdleHandler;
    private static HashMap<Integer, Long> sLastVmViolationTime;
    private static Span NO_OP_SPAN;
    private static ThreadLocal<ThreadSpanState> sThisThreadSpanState;
    private static Singleton<IWindowManager> sWindowManager;
    private static HashMap<Class, Integer> sExpectedActivityInstanceCount;

    private static final void $$robo$$android_os_StrictMode$setViolationListener(ViolationListener listener) {
        sListener = listener;
    }

    private void $$robo$$android_os_StrictMode$__constructor__() {
    }

    private static final void $$robo$$android_os_StrictMode$setThreadPolicy(ThreadPolicy policy) {
        StrictMode.setThreadPolicyMask(policy.mask);
    }

    private static final void $$robo$$android_os_StrictMode$setThreadPolicyMask(int policyMask) {
        StrictMode.setBlockGuardPolicy(policyMask);
        Binder.setThreadStrictModePolicy(policyMask);
    }

    private static final void $$robo$$android_os_StrictMode$setBlockGuardPolicy(int policyMask) {
        AndroidBlockGuardPolicy androidPolicy;
        if (policyMask == 0) {
            BlockGuard.setThreadPolicy(BlockGuard.LAX_POLICY);
            return;
        }
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (policy instanceof AndroidBlockGuardPolicy) {
            androidPolicy = (AndroidBlockGuardPolicy)policy;
        } else {
            androidPolicy = threadAndroidPolicy.get();
            BlockGuard.setThreadPolicy(androidPolicy);
        }
        androidPolicy.setPolicyMask(policyMask);
    }

    private static final void $$robo$$android_os_StrictMode$setCloseGuardEnabled(boolean enabled) {
        if (!(CloseGuard.getReporter() instanceof AndroidCloseGuardReporter)) {
            CloseGuard.setReporter(new AndroidCloseGuardReporter(null));
        }
        CloseGuard.setEnabled(enabled);
    }

    private static final int $$robo$$android_os_StrictMode$getThreadPolicyMask() {
        return BlockGuard.getThreadPolicy().getPolicyMask();
    }

    private static final ThreadPolicy $$robo$$android_os_StrictMode$getThreadPolicy() {
        return new ThreadPolicy(StrictMode.getThreadPolicyMask(), null);
    }

    private static final ThreadPolicy $$robo$$android_os_StrictMode$allowThreadDiskWrites() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFC;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return new ThreadPolicy(oldPolicyMask, null);
    }

    private static final ThreadPolicy $$robo$$android_os_StrictMode$allowThreadDiskReads() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFD;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return new ThreadPolicy(oldPolicyMask, null);
    }

    private static final boolean $$robo$$android_os_StrictMode$amTheSystemServerProcess() {
        if (Process.myUid() != 1000) {
            return false;
        }
        Throwable stack = new Throwable();
        stack.fillInStackTrace();
        for (StackTraceElement ste : stack.getStackTrace()) {
            String clsName = ste.getClassName();
            if (clsName == null || !clsName.startsWith("com.android.server.")) continue;
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_os_StrictMode$conditionallyEnableDebugLogging() {
        boolean doFlashes = SystemProperties.getBoolean("persist.sys.strictmode.visual", false) && !StrictMode.amTheSystemServerProcess();
        boolean suppress = SystemProperties.getBoolean("persist.sys.strictmode.disable", false);
        if (!doFlashes && (IS_USER_BUILD || suppress)) {
            StrictMode.setCloseGuardEnabled(false);
            return false;
        }
        if (IS_ENG_BUILD) {
            doFlashes = true;
        }
        int threadPolicyMask = 7;
        if (!IS_USER_BUILD) {
            threadPolicyMask |= 0x200000;
        }
        if (doFlashes) {
            threadPolicyMask |= 0x100000;
        }
        StrictMode.setThreadPolicyMask(threadPolicyMask);
        if (IS_USER_BUILD) {
            StrictMode.setCloseGuardEnabled(false);
        } else {
            VmPolicy.Builder policyBuilder = new VmPolicy.Builder().detectAll();
            if (!IS_ENG_BUILD) {
                policyBuilder = policyBuilder.disable(1024);
            }
            policyBuilder = policyBuilder.penaltyDropBox();
            if (IS_ENG_BUILD) {
                policyBuilder.penaltyLog();
            }
            if (Process.myUid() < 10000) {
                policyBuilder.detectUntaggedSockets();
            }
            StrictMode.setVmPolicy(policyBuilder.build());
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
        }
        return true;
    }

    private static final void $$robo$$android_os_StrictMode$enableDeathOnNetwork() {
        int oldPolicy = StrictMode.getThreadPolicyMask();
        int newPolicy = oldPolicy | 4 | 0x1000000;
        StrictMode.setThreadPolicyMask(newPolicy);
    }

    private static final void $$robo$$android_os_StrictMode$enableDeathOnFileUriExposure() {
        sVmPolicyMask |= 0x4002000;
    }

    private static final void $$robo$$android_os_StrictMode$disableDeathOnFileUriExposure() {
        sVmPolicyMask &= 0xFBFFDFFF;
    }

    private static final int $$robo$$android_os_StrictMode$parsePolicyFromMessage(String message) {
        if (message == null || !message.startsWith("policy=")) {
            return 0;
        }
        int spaceIndex = message.indexOf(32);
        if (spaceIndex == -1) {
            return 0;
        }
        String policyString = message.substring(7, spaceIndex);
        try {
            return Integer.parseInt(policyString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static final int $$robo$$android_os_StrictMode$parseViolationFromMessage(String message) {
        if (message == null) {
            return 0;
        }
        int violationIndex = message.indexOf("violation=");
        if (violationIndex == -1) {
            return 0;
        }
        int numberStartIndex = violationIndex + "violation=".length();
        int numberEndIndex = message.indexOf(32, numberStartIndex);
        if (numberEndIndex == -1) {
            numberEndIndex = message.length();
        }
        String violationString = message.substring(numberStartIndex, numberEndIndex);
        try {
            return Integer.parseInt(violationString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static final boolean $$robo$$android_os_StrictMode$tooManyViolationsThisLoop() {
        return violationsBeingTimed.get().size() >= 10;
    }

    private static final void $$robo$$android_os_StrictMode$executeDeathPenalty(ViolationInfo info) {
        int violationBit = StrictMode.parseViolationFromMessage(info.crashInfo.exceptionMessage);
        throw new StrictModeViolation(info.policy, violationBit, null);
    }

    private static final void $$robo$$android_os_StrictMode$dropboxViolationAsync(int violationMaskSubset, ViolationInfo info) {
        int outstanding = sDropboxCallsInFlight.incrementAndGet();
        if (outstanding > 20) {
            sDropboxCallsInFlight.decrementAndGet();
            return;
        }
        if (LOG_V) {
            Log.d("StrictMode", "Dropboxing async; in-flight=" + outstanding);
        }
        new ShadowedObject("callActivityManagerForStrictModeDropbox", violationMaskSubset, info){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$violationMaskSubset;
            /* synthetic */ ViolationInfo val$info;

            private void $$robo$$android_os_StrictMode_5$__constructor__(String x0, int n, ViolationInfo violationInfo) {
                this.val$violationMaskSubset = n;
                this.val$info = violationInfo;
            }

            private final void $$robo$$android_os_StrictMode_5$run() {
                block5: {
                    Process.setThreadPriority(10);
                    try {
                        IActivityManager am = ActivityManager.getService();
                        if (am == null) {
                            Log.d("StrictMode", "No activity manager; failed to Dropbox violation.");
                        } else {
                            am.handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), this.val$violationMaskSubset, this.val$info);
                        }
                    }
                    catch (RemoteException e) {
                        if (e instanceof DeadObjectException) break block5;
                        Log.e("StrictMode", "RemoteException handling StrictMode violation", e);
                    }
                }
                int outstanding = sDropboxCallsInFlight.decrementAndGet();
                if (LOG_V) {
                    Log.d("StrictMode", "Dropbox complete; in-flight=" + outstanding);
                }
            }

            private void __constructor__(String string2, int n, ViolationInfo violationInfo) {
                this.$$robo$$android_os_StrictMode_5$__constructor__(string2, n, violationInfo);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_5$__constructor__(java.lang.String int android.os.StrictMode$ViolationInfo ), this, string2, n, violationInfo);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_StrictMode_5$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.start();
    }

    private static final boolean $$robo$$android_os_StrictMode$hasGatheredViolations() {
        return gatheredViolations.get() != null;
    }

    private static final void $$robo$$android_os_StrictMode$clearGatheredViolations() {
        gatheredViolations.set(null);
    }

    private static final void $$robo$$android_os_StrictMode$conditionallyCheckInstanceCounts() {
        VmPolicy policy = StrictMode.getVmPolicy();
        int policySize = policy.classInstanceLimit.size();
        if (policySize == 0) {
            return;
        }
        System.gc();
        System.runFinalization();
        System.gc();
        Class[] classes = policy.classInstanceLimit.keySet().toArray(new Class[policySize]);
        long[] instanceCounts = VMDebug.countInstancesOfClasses(classes, false);
        for (int i = 0; i < classes.length; ++i) {
            long instances = instanceCounts[i];
            Class klass = classes[i];
            int limit = policy.classInstanceLimit.get(klass);
            if (instances <= (long)limit) continue;
            InstanceCountViolation tr = new InstanceCountViolation(klass, instances, limit);
            StrictMode.onVmPolicyViolation(tr.getMessage(), tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$setVmPolicy(VmPolicy policy) {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            INetworkManagementService netd;
            sVmPolicy = policy;
            sVmPolicyMask = policy.mask;
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
            Looper looper = Looper.getMainLooper();
            if (looper != null) {
                MessageQueue mq = looper.mQueue;
                if (policy.classInstanceLimit.size() == 0 || (sVmPolicyMask & 0x6250000) == 0) {
                    mq.removeIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = false;
                } else if (!sIsIdlerRegistered) {
                    mq.addIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = true;
                }
            }
            int networkPolicy = 0;
            if ((sVmPolicyMask & 0x4000) != 0) {
                networkPolicy = (sVmPolicyMask & 0x40000) != 0 || (sVmPolicyMask & 0x2000000) != 0 ? 2 : 1;
            }
            if ((netd = INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management"))) != null) {
                try {
                    netd.setUidCleartextNetworkPolicy(Process.myUid(), networkPolicy);
                }
                catch (RemoteException remoteException) {}
            } else if (networkPolicy != 0) {
                Log.w("StrictMode", "Dropping requested network policy due to missing service!");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final VmPolicy $$robo$$android_os_StrictMode$getVmPolicy() {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVmPolicy;
        }
    }

    private static final void $$robo$$android_os_StrictMode$enableDefaults() {
        StrictMode.setThreadPolicy(new ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy(new VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    private static final boolean $$robo$$android_os_StrictMode$vmSqliteObjectLeaksEnabled() {
        return (sVmPolicyMask & 0x100) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmClosableObjectLeaksEnabled() {
        return (sVmPolicyMask & 0x200) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmRegistrationLeaksEnabled() {
        return (sVmPolicyMask & 0x1000) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmFileUriExposureEnabled() {
        return (sVmPolicyMask & 0x2000) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmCleartextNetworkEnabled() {
        return (sVmPolicyMask & 0x4000) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmContentUriWithoutPermissionEnabled() {
        return (sVmPolicyMask & 0x8000) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmUntaggedSocketEnabled() {
        return (sVmPolicyMask & Integer.MIN_VALUE) != 0;
    }

    private static final void $$robo$$android_os_StrictMode$onSqliteObjectLeaked(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(message, originStack);
    }

    private static final void $$robo$$android_os_StrictMode$onWebViewMethodCalledOnWrongThread(Throwable originStack) {
        StrictMode.onVmPolicyViolation(null, originStack);
    }

    private static final void $$robo$$android_os_StrictMode$onIntentReceiverLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(null, originStack);
    }

    private static final void $$robo$$android_os_StrictMode$onServiceConnectionLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(null, originStack);
    }

    private static final void $$robo$$android_os_StrictMode$onFileUriExposed(Uri uri, String location) {
        String message = uri + " exposed beyond app through " + location;
        if ((sVmPolicyMask & 0x4000000) != 0) {
            throw new FileUriExposedException(message);
        }
        StrictMode.onVmPolicyViolation(null, new Throwable(message));
    }

    private static final void $$robo$$android_os_StrictMode$onContentUriWithoutPermission(Uri uri, String location) {
        String message = uri + " exposed beyond app through " + location + " without permission grant flags; did you forget FLAG_GRANT_READ_URI_PERMISSION?";
        StrictMode.onVmPolicyViolation(null, new Throwable(message));
    }

    private static final void $$robo$$android_os_StrictMode$onCleartextNetworkDetected(byte[] firstPacket) {
        byte[] rawAddr = null;
        if (firstPacket != null) {
            if (firstPacket.length >= 20 && (firstPacket[0] & 0xF0) == 64) {
                rawAddr = new byte[4];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])firstPacket, (int)16, (byte[])rawAddr, (int)0, (int)4);
            } else if (firstPacket.length >= 40 && (firstPacket[0] & 0xF0) == 96) {
                rawAddr = new byte[16];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])firstPacket, (int)24, (byte[])rawAddr, (int)0, (int)16);
            }
        }
        int uid = Process.myUid();
        String msg = "Detected cleartext network traffic from UID " + uid;
        if (rawAddr != null) {
            try {
                msg = "Detected cleartext network traffic from UID " + uid + " to " + InetAddress.getByAddress(rawAddr);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        boolean forceDeath = (sVmPolicyMask & 0x2000000) != 0;
        StrictMode.onVmPolicyViolation(HexDump.dumpHexString(firstPacket).trim(), new Throwable(msg), forceDeath);
    }

    private static final void $$robo$$android_os_StrictMode$onUntaggedSocket() {
        StrictMode.onVmPolicyViolation(null, new Throwable("Untagged socket detected; use TrafficStats.setThreadSocketTag() to track all network usage"));
    }

    private static final void $$robo$$android_os_StrictMode$onVmPolicyViolation(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(message, originStack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$onVmPolicyViolation(String message, Throwable originStack, boolean forceDeath) {
        boolean penaltyDropbox = (sVmPolicyMask & 0x200000) != 0;
        boolean penaltyDeath = (sVmPolicyMask & 0x40000) != 0 || forceDeath;
        boolean penaltyLog = (sVmPolicyMask & 0x10000) != 0;
        ViolationInfo info = new ViolationInfo(message, originStack, sVmPolicyMask);
        info.numAnimationsRunning = 0;
        info.tags = null;
        info.broadcastIntentAction = null;
        Integer fingerprint = info.hashCode();
        long now = SystemClock.uptimeMillis();
        long lastViolationTime = 0L;
        long timeSinceLastViolationMillis = Long.MAX_VALUE;
        HashMap<Integer, Long> hashMap = sLastVmViolationTime;
        synchronized (hashMap) {
            if (sLastVmViolationTime.containsKey(fingerprint)) {
                lastViolationTime = sLastVmViolationTime.get(fingerprint);
                timeSinceLastViolationMillis = now - lastViolationTime;
            }
            if (timeSinceLastViolationMillis > 1000L) {
                sLastVmViolationTime.put(fingerprint, now);
            }
        }
        if (penaltyLog && sListener != null) {
            sListener.onViolation(originStack.toString());
        }
        if (penaltyLog && timeSinceLastViolationMillis > 1000L) {
            Log.e("StrictMode", message, originStack);
        }
        int violationMaskSubset = 0x200000 | 0x8000FF00 & sVmPolicyMask;
        if (penaltyDropbox && !penaltyDeath) {
            StrictMode.dropboxViolationAsync(violationMaskSubset, info);
            return;
        }
        if (penaltyDropbox && lastViolationTime == 0L) {
            int savedPolicyMask = StrictMode.getThreadPolicyMask();
            try {
                StrictMode.setThreadPolicyMask(0);
                ActivityManager.getService().handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
            }
            catch (RemoteException e) {
                if (e instanceof DeadObjectException) {
                } else {
                    Log.e("StrictMode", "RemoteException trying to handle StrictMode violation", e);
                }
            }
            finally {
                StrictMode.setThreadPolicyMask(savedPolicyMask);
            }
        }
        if (penaltyDeath) {
            System.err.println("StrictMode VmPolicy violation with POLICY_DEATH; shutting down.");
            Process.killProcess(Process.myPid());
            System.exit(10);
        }
    }

    private static final void $$robo$$android_os_StrictMode$writeGatheredViolationsToParcel(Parcel p) {
        ArrayList<ViolationInfo> violations = gatheredViolations.get();
        if (violations == null) {
            p.writeInt(0);
        } else {
            int size = Math.min(violations.size(), 3);
            p.writeInt(size);
            for (int i = 0; i < size; ++i) {
                violations.get(i).writeToParcel(p, 0);
            }
        }
        gatheredViolations.set(null);
    }

    private static final void $$robo$$android_os_StrictMode$readAndHandleBinderCallViolations(Parcel p) {
        StringWriter sw = new StringWriter();
        sw.append("# via Binder call with stack:\n");
        FastPrintWriter pw = new FastPrintWriter(sw, false, 256);
        new LogStackTrace(null).printStackTrace(pw);
        ((PrintWriter)pw).flush();
        String ourStack = sw.toString();
        int policyMask = StrictMode.getThreadPolicyMask();
        boolean currentlyGathering = (policyMask & 0x400000) != 0;
        int size = p.readInt();
        for (int i = 0; i < size; ++i) {
            ViolationInfo info = new ViolationInfo(p, !currentlyGathering);
            info.crashInfo.appendStackTrace(ourStack);
            BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
            if (!(policy instanceof AndroidBlockGuardPolicy)) continue;
            ((AndroidBlockGuardPolicy)policy).handleViolationWithTimingAttempt(info);
        }
    }

    private static final void $$robo$$android_os_StrictMode$onBinderStrictModePolicyChange(int newPolicy) {
        StrictMode.setBlockGuardPolicy(newPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Span $$robo$$android_os_StrictMode$enterCriticalSpan(String name) {
        if (IS_USER_BUILD) {
            return NO_OP_SPAN;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        ThreadSpanState state = sThisThreadSpanState.get();
        Span span = null;
        ThreadSpanState threadSpanState = state;
        synchronized (threadSpanState) {
            if (state.mFreeListHead != null) {
                span = state.mFreeListHead;
                state.mFreeListHead = span.mNext;
                --state.mFreeListSize;
            } else {
                span = new Span(state);
            }
            span.mName = name;
            span.mCreateMillis = SystemClock.uptimeMillis();
            span.mNext = state.mActiveHead;
            span.mPrev = null;
            state.mActiveHead = span;
            ++state.mActiveSize;
            if (span.mNext != null) {
                span.mNext.mPrev = span;
            }
            if (LOG_V) {
                Log.d("StrictMode", "Span enter=" + name + "; size=" + state.mActiveSize);
            }
        }
        return span;
    }

    private static final void $$robo$$android_os_StrictMode$noteSlowCall(String name) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onCustomSlowCall(name);
    }

    private static final void $$robo$$android_os_StrictMode$noteResourceMismatch(Object tag) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onResourceMismatch(tag);
    }

    private static final void $$robo$$android_os_StrictMode$noteUnbufferedIO() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onUnbufferedIO();
    }

    private static final void $$robo$$android_os_StrictMode$noteDiskRead() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onReadFromDisk();
    }

    private static final void $$robo$$android_os_StrictMode$noteDiskWrite() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onWriteToDisk();
    }

    private static final Object $$robo$$android_os_StrictMode$trackActivity(Object instance) {
        return new InstanceTracker(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$incrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            if ((StrictMode.sVmPolicy.mask & 0x400) == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            Integer newExpected = expected == null ? 1 : expected + 1;
            sExpectedActivityInstanceCount.put(klass, newExpected);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$decrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            int newExpected;
            if ((StrictMode.sVmPolicy.mask & 0x400) == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            int n = newExpected = expected == null || expected == 0 ? 0 : expected - 1;
            if (newExpected == 0) {
                sExpectedActivityInstanceCount.remove(klass);
            } else {
                sExpectedActivityInstanceCount.put(klass, newExpected);
            }
            int limit = newExpected + 1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            int actual = InstanceTracker.getInstanceCount(klass);
            if (actual <= limit) {
                return;
            }
            System.gc();
            System.runFinalization();
            System.gc();
            long instances = VMDebug.countInstancesOfClass(klass, false);
            if (instances > (long)limit) {
                InstanceCountViolation tr = new InstanceCountViolation(klass, instances, limit);
                StrictMode.onVmPolicyViolation(tr.getMessage(), tr);
            }
            return;
        }
    }

    static void __staticInitializer__() {
        LOG_V = Log.isLoggable("StrictMode", 2);
        IS_USER_BUILD = "user".equals(Build.TYPE);
        IS_ENG_BUILD = "eng".equals(Build.TYPE);
        EMPTY_CLASS_LIMIT_MAP = new HashMap();
        sVmPolicyMask = 0;
        sVmPolicy = VmPolicy.LAX;
        sDropboxCallsInFlight = new AtomicInteger(0);
        gatheredViolations = new ThreadLocal<ArrayList<ViolationInfo>>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_1$__constructor__() {
            }

            private final ArrayList<ViolationInfo> $$robo$$android_os_StrictMode_1$initialValue() {
                return null;
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_1$__constructor__(), this);
            }

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_1$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        violationsBeingTimed = new ThreadLocal<ArrayList<ViolationInfo>>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_2$__constructor__() {
            }

            private final ArrayList<ViolationInfo> $$robo$$android_os_StrictMode_2$initialValue() {
                return new ArrayList<ViolationInfo>();
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_2$__constructor__(), this);
            }

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_2$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        threadHandler = new ThreadLocal<Handler>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_3$__constructor__() {
            }

            private final Handler $$robo$$android_os_StrictMode_3$initialValue() {
                return new Handler();
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_3$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_3$__constructor__(), this);
            }

            @Override
            protected Handler initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_3$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        threadAndroidPolicy = new ThreadLocal<AndroidBlockGuardPolicy>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_4$__constructor__() {
            }

            private final AndroidBlockGuardPolicy $$robo$$android_os_StrictMode_4$initialValue() {
                return new AndroidBlockGuardPolicy(0);
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_4$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_4$__constructor__(), this);
            }

            @Override
            protected AndroidBlockGuardPolicy initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_4$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sLastInstanceCountCheckMillis = 0L;
        sIsIdlerRegistered = false;
        sProcessIdleHandler = new MessageQueue.IdleHandler(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_6$__constructor__() {
            }

            private final boolean $$robo$$android_os_StrictMode_6$queueIdle() {
                long now = SystemClock.uptimeMillis();
                if (now - sLastInstanceCountCheckMillis > 30000L) {
                    sLastInstanceCountCheckMillis = now;
                    StrictMode.conditionallyCheckInstanceCounts();
                }
                return true;
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_6$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_6$__constructor__(), this);
            }

            @Override
            public boolean queueIdle() {
                return (boolean)InvokeDynamicSupport.bootstrap("queueIdle", $$robo$$android_os_StrictMode_6$queueIdle(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sLastVmViolationTime = new HashMap();
        NO_OP_SPAN = new ShadowedObject(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_7$__constructor__() {
            }

            private final void $$robo$$android_os_StrictMode_7$finish() {
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_7$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_7$__constructor__(), this);
            }

            @Override
            public void finish() {
                InvokeDynamicSupport.bootstrap("finish", $$robo$$android_os_StrictMode_7$finish(), this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sThisThreadSpanState = new ThreadLocal<ThreadSpanState>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_8$__constructor__() {
            }

            private final ThreadSpanState $$robo$$android_os_StrictMode_8$initialValue() {
                return new ThreadSpanState(null);
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_8$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_8$__constructor__(), this);
            }

            @Override
            protected ThreadSpanState initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_8$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sWindowManager = new Singleton<IWindowManager>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_9$__constructor__() {
            }

            private final IWindowManager $$robo$$android_os_StrictMode_9$create() {
                return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_9$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_9$__constructor__(), this);
            }

            @Override
            protected IWindowManager create() {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$android_os_StrictMode_9$create(), this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sExpectedActivityInstanceCount = new HashMap();
    }

    public static void setViolationListener(ViolationListener violationListener) {
        InvokeDynamicSupport.bootstrapStatic("setViolationListener", $$robo$$android_os_StrictMode$setViolationListener(android.os.StrictMode$ViolationListener ), (ViolationListener)violationListener);
    }

    private void __constructor__() {
        this.$$robo$$android_os_StrictMode$__constructor__();
    }

    public StrictMode() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode$__constructor__(), this);
    }

    public static void setThreadPolicy(ThreadPolicy threadPolicy) {
        InvokeDynamicSupport.bootstrapStatic("setThreadPolicy", $$robo$$android_os_StrictMode$setThreadPolicy(android.os.StrictMode$ThreadPolicy ), (ThreadPolicy)threadPolicy);
    }

    private static void setThreadPolicyMask(int n) {
        InvokeDynamicSupport.bootstrapStatic("setThreadPolicyMask", $$robo$$android_os_StrictMode$setThreadPolicyMask(int ), (int)n);
    }

    private static void setBlockGuardPolicy(int n) {
        InvokeDynamicSupport.bootstrapStatic("setBlockGuardPolicy", $$robo$$android_os_StrictMode$setBlockGuardPolicy(int ), (int)n);
    }

    private static void setCloseGuardEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setCloseGuardEnabled", $$robo$$android_os_StrictMode$setCloseGuardEnabled(boolean ), (boolean)bl);
    }

    public static int getThreadPolicyMask() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadPolicyMask", $$robo$$android_os_StrictMode$getThreadPolicyMask());
    }

    public static ThreadPolicy getThreadPolicy() {
        return InvokeDynamicSupport.bootstrapStatic("getThreadPolicy", $$robo$$android_os_StrictMode$getThreadPolicy());
    }

    public static ThreadPolicy allowThreadDiskWrites() {
        return InvokeDynamicSupport.bootstrapStatic("allowThreadDiskWrites", $$robo$$android_os_StrictMode$allowThreadDiskWrites());
    }

    public static ThreadPolicy allowThreadDiskReads() {
        return InvokeDynamicSupport.bootstrapStatic("allowThreadDiskReads", $$robo$$android_os_StrictMode$allowThreadDiskReads());
    }

    private static boolean amTheSystemServerProcess() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("amTheSystemServerProcess", $$robo$$android_os_StrictMode$amTheSystemServerProcess());
    }

    public static boolean conditionallyEnableDebugLogging() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("conditionallyEnableDebugLogging", $$robo$$android_os_StrictMode$conditionallyEnableDebugLogging());
    }

    public static void enableDeathOnNetwork() {
        InvokeDynamicSupport.bootstrapStatic("enableDeathOnNetwork", $$robo$$android_os_StrictMode$enableDeathOnNetwork());
    }

    public static void enableDeathOnFileUriExposure() {
        InvokeDynamicSupport.bootstrapStatic("enableDeathOnFileUriExposure", $$robo$$android_os_StrictMode$enableDeathOnFileUriExposure());
    }

    public static void disableDeathOnFileUriExposure() {
        InvokeDynamicSupport.bootstrapStatic("disableDeathOnFileUriExposure", $$robo$$android_os_StrictMode$disableDeathOnFileUriExposure());
    }

    private static int parsePolicyFromMessage(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parsePolicyFromMessage", $$robo$$android_os_StrictMode$parsePolicyFromMessage(java.lang.String ), (String)string2);
    }

    private static int parseViolationFromMessage(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseViolationFromMessage", $$robo$$android_os_StrictMode$parseViolationFromMessage(java.lang.String ), (String)string2);
    }

    private static boolean tooManyViolationsThisLoop() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("tooManyViolationsThisLoop", $$robo$$android_os_StrictMode$tooManyViolationsThisLoop());
    }

    private static void executeDeathPenalty(ViolationInfo violationInfo) {
        InvokeDynamicSupport.bootstrapStatic("executeDeathPenalty", $$robo$$android_os_StrictMode$executeDeathPenalty(android.os.StrictMode$ViolationInfo ), (ViolationInfo)violationInfo);
    }

    private static void dropboxViolationAsync(int n, ViolationInfo violationInfo) {
        InvokeDynamicSupport.bootstrapStatic("dropboxViolationAsync", $$robo$$android_os_StrictMode$dropboxViolationAsync(int android.os.StrictMode$ViolationInfo ), (int)n, (ViolationInfo)violationInfo);
    }

    static boolean hasGatheredViolations() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasGatheredViolations", $$robo$$android_os_StrictMode$hasGatheredViolations());
    }

    static void clearGatheredViolations() {
        InvokeDynamicSupport.bootstrapStatic("clearGatheredViolations", $$robo$$android_os_StrictMode$clearGatheredViolations());
    }

    public static void conditionallyCheckInstanceCounts() {
        InvokeDynamicSupport.bootstrapStatic("conditionallyCheckInstanceCounts", $$robo$$android_os_StrictMode$conditionallyCheckInstanceCounts());
    }

    public static void setVmPolicy(VmPolicy vmPolicy) {
        InvokeDynamicSupport.bootstrapStatic("setVmPolicy", $$robo$$android_os_StrictMode$setVmPolicy(android.os.StrictMode$VmPolicy ), (VmPolicy)vmPolicy);
    }

    public static VmPolicy getVmPolicy() {
        return InvokeDynamicSupport.bootstrapStatic("getVmPolicy", $$robo$$android_os_StrictMode$getVmPolicy());
    }

    public static void enableDefaults() {
        InvokeDynamicSupport.bootstrapStatic("enableDefaults", $$robo$$android_os_StrictMode$enableDefaults());
    }

    public static boolean vmSqliteObjectLeaksEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmSqliteObjectLeaksEnabled", $$robo$$android_os_StrictMode$vmSqliteObjectLeaksEnabled());
    }

    public static boolean vmClosableObjectLeaksEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmClosableObjectLeaksEnabled", $$robo$$android_os_StrictMode$vmClosableObjectLeaksEnabled());
    }

    public static boolean vmRegistrationLeaksEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmRegistrationLeaksEnabled", $$robo$$android_os_StrictMode$vmRegistrationLeaksEnabled());
    }

    public static boolean vmFileUriExposureEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmFileUriExposureEnabled", $$robo$$android_os_StrictMode$vmFileUriExposureEnabled());
    }

    public static boolean vmCleartextNetworkEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmCleartextNetworkEnabled", $$robo$$android_os_StrictMode$vmCleartextNetworkEnabled());
    }

    public static boolean vmContentUriWithoutPermissionEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmContentUriWithoutPermissionEnabled", $$robo$$android_os_StrictMode$vmContentUriWithoutPermissionEnabled());
    }

    public static boolean vmUntaggedSocketEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmUntaggedSocketEnabled", $$robo$$android_os_StrictMode$vmUntaggedSocketEnabled());
    }

    public static void onSqliteObjectLeaked(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onSqliteObjectLeaked", $$robo$$android_os_StrictMode$onSqliteObjectLeaked(java.lang.String java.lang.Throwable ), (String)string2, (Throwable)throwable);
    }

    public static void onWebViewMethodCalledOnWrongThread(Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onWebViewMethodCalledOnWrongThread", $$robo$$android_os_StrictMode$onWebViewMethodCalledOnWrongThread(java.lang.Throwable ), (Throwable)throwable);
    }

    public static void onIntentReceiverLeaked(Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onIntentReceiverLeaked", $$robo$$android_os_StrictMode$onIntentReceiverLeaked(java.lang.Throwable ), (Throwable)throwable);
    }

    public static void onServiceConnectionLeaked(Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onServiceConnectionLeaked", $$robo$$android_os_StrictMode$onServiceConnectionLeaked(java.lang.Throwable ), (Throwable)throwable);
    }

    public static void onFileUriExposed(Uri uri, String string2) {
        InvokeDynamicSupport.bootstrapStatic("onFileUriExposed", $$robo$$android_os_StrictMode$onFileUriExposed(android.net.Uri java.lang.String ), (Uri)uri, (String)string2);
    }

    public static void onContentUriWithoutPermission(Uri uri, String string2) {
        InvokeDynamicSupport.bootstrapStatic("onContentUriWithoutPermission", $$robo$$android_os_StrictMode$onContentUriWithoutPermission(android.net.Uri java.lang.String ), (Uri)uri, (String)string2);
    }

    public static void onCleartextNetworkDetected(byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("onCleartextNetworkDetected", $$robo$$android_os_StrictMode$onCleartextNetworkDetected(byte[] ), (byte[])byArray);
    }

    public static void onUntaggedSocket() {
        InvokeDynamicSupport.bootstrapStatic("onUntaggedSocket", $$robo$$android_os_StrictMode$onUntaggedSocket());
    }

    public static void onVmPolicyViolation(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onVmPolicyViolation", $$robo$$android_os_StrictMode$onVmPolicyViolation(java.lang.String java.lang.Throwable ), (String)string2, (Throwable)throwable);
    }

    public static void onVmPolicyViolation(String string2, Throwable throwable, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("onVmPolicyViolation", $$robo$$android_os_StrictMode$onVmPolicyViolation(java.lang.String java.lang.Throwable boolean ), (String)string2, (Throwable)throwable, (boolean)bl);
    }

    static void writeGatheredViolationsToParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("writeGatheredViolationsToParcel", $$robo$$android_os_StrictMode$writeGatheredViolationsToParcel(android.os.Parcel ), (Parcel)parcel);
    }

    static void readAndHandleBinderCallViolations(Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("readAndHandleBinderCallViolations", $$robo$$android_os_StrictMode$readAndHandleBinderCallViolations(android.os.Parcel ), (Parcel)parcel);
    }

    private static void onBinderStrictModePolicyChange(int n) {
        InvokeDynamicSupport.bootstrapStatic("onBinderStrictModePolicyChange", $$robo$$android_os_StrictMode$onBinderStrictModePolicyChange(int ), (int)n);
    }

    public static Span enterCriticalSpan(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("enterCriticalSpan", $$robo$$android_os_StrictMode$enterCriticalSpan(java.lang.String ), (String)string2);
    }

    public static void noteSlowCall(String string2) {
        InvokeDynamicSupport.bootstrapStatic("noteSlowCall", $$robo$$android_os_StrictMode$noteSlowCall(java.lang.String ), (String)string2);
    }

    public static void noteResourceMismatch(Object object) {
        InvokeDynamicSupport.bootstrapStatic("noteResourceMismatch", $$robo$$android_os_StrictMode$noteResourceMismatch(java.lang.Object ), (Object)object);
    }

    public static void noteUnbufferedIO() {
        InvokeDynamicSupport.bootstrapStatic("noteUnbufferedIO", $$robo$$android_os_StrictMode$noteUnbufferedIO());
    }

    public static void noteDiskRead() {
        InvokeDynamicSupport.bootstrapStatic("noteDiskRead", $$robo$$android_os_StrictMode$noteDiskRead());
    }

    public static void noteDiskWrite() {
        InvokeDynamicSupport.bootstrapStatic("noteDiskWrite", $$robo$$android_os_StrictMode$noteDiskWrite());
    }

    public static Object trackActivity(Object object) {
        return InvokeDynamicSupport.bootstrapStatic("trackActivity", $$robo$$android_os_StrictMode$trackActivity(java.lang.Object ), (Object)object);
    }

    public static void incrementExpectedActivityCount(Class clazz) {
        InvokeDynamicSupport.bootstrapStatic("incrementExpectedActivityCount", $$robo$$android_os_StrictMode$incrementExpectedActivityCount(java.lang.Class ), (Class)clazz);
    }

    public static void decrementExpectedActivityCount(Class clazz) {
        InvokeDynamicSupport.bootstrapStatic("decrementExpectedActivityCount", $$robo$$android_os_StrictMode$decrementExpectedActivityCount(java.lang.Class ), (Class)clazz);
    }

    static {
        RobolectricInternals.classInitializing(StrictMode.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictMode)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class InstanceTracker
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static HashMap<Class<?>, Integer> sInstanceCounts;
        private Class<?> mKlass;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void $$robo$$android_os_StrictMode_InstanceTracker$__constructor__(Object instance) {
            this.mKlass = instance.getClass();
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(this.mKlass);
                int newValue = value != null ? value + 1 : 1;
                sInstanceCounts.put(this.mKlass, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_StrictMode_InstanceTracker$finalize() throws Throwable {
            try {
                HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
                synchronized (hashMap) {
                    Integer value = sInstanceCounts.get(this.mKlass);
                    if (value != null) {
                        int newValue = value - 1;
                        if (newValue > 0) {
                            sInstanceCounts.put(this.mKlass, newValue);
                        } else {
                            sInstanceCounts.remove(this.mKlass);
                        }
                    }
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final int $$robo$$android_os_StrictMode_InstanceTracker$getInstanceCount(Class<?> klass) {
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(klass);
                return value != null ? value : 0;
            }
        }

        static void __staticInitializer__() {
            sInstanceCounts = new HashMap();
        }

        private void __constructor__(Object object) {
            this.$$robo$$android_os_StrictMode_InstanceTracker$__constructor__(object);
        }

        public InstanceTracker(Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_InstanceTracker$__constructor__(java.lang.Object ), this, object);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_StrictMode_InstanceTracker$finalize(), this);
        }

        public static int getInstanceCount(Class<?> clazz) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getInstanceCount", $$robo$$android_os_StrictMode_InstanceTracker$getInstanceCount(java.lang.Class<?> ), clazz);
        }

        static {
            RobolectricInternals.classInitializing(InstanceTracker.class);
        }

        public /* synthetic */ InstanceTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstanceTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class InstanceCountViolation
    extends Throwable
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Class mClass;
        long mInstances;
        int mLimit;
        private static StackTraceElement[] FAKE_STACK;

        private void $$robo$$android_os_StrictMode_InstanceCountViolation$__constructor__(Class klass, long instances, int limit) {
            this.setStackTrace(FAKE_STACK);
            this.mClass = klass;
            this.mInstances = instances;
            this.mLimit = limit;
        }

        static void __staticInitializer__() {
            FAKE_STACK = new StackTraceElement[]{new StackTraceElement("android.os.StrictMode", "setClassInstanceLimit", "StrictMode.java", 1)};
        }

        private void __constructor__(Class clazz, long l, int n) {
            this.$$robo$$android_os_StrictMode_InstanceCountViolation$__constructor__(clazz, l, n);
        }

        public InstanceCountViolation(Class clazz, long l, int n) {
            super(clazz.toString() + "; instances=" + l + "; limit=" + n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_InstanceCountViolation$__constructor__(java.lang.Class long int ), this, clazz, l, n);
        }

        static {
            RobolectricInternals.classInitializing(InstanceCountViolation.class);
        }

        public /* synthetic */ InstanceCountViolation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstanceCountViolation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ViolationInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String message;
        public ApplicationErrorReport.CrashInfo crashInfo;
        public int policy;
        public int durationMillis;
        public int numAnimationsRunning;
        public String[] tags;
        public int violationNumThisLoop;
        public long violationUptimeMillis;
        public String broadcastIntentAction;
        public long numInstances;
        public static Parcelable.Creator<ViolationInfo> CREATOR;

        private void $$robo$$android_os_StrictMode_ViolationInfo$__constructor__() {
            this.durationMillis = -1;
            this.numAnimationsRunning = 0;
            this.numInstances = -1L;
            this.message = null;
            this.crashInfo = null;
            this.policy = 0;
        }

        private void $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(Throwable tr, int policy) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(String message, Throwable tr, int policy) {
            this.durationMillis = -1;
            this.numAnimationsRunning = 0;
            this.numInstances = -1L;
            this.message = message;
            this.crashInfo = new ApplicationErrorReport.CrashInfo(tr);
            this.violationUptimeMillis = SystemClock.uptimeMillis();
            this.policy = policy;
            this.numAnimationsRunning = ValueAnimator.getCurrentAnimationsCount();
            Intent broadcastIntent = ActivityThread.getIntentBeingBroadcast();
            if (broadcastIntent != null) {
                this.broadcastIntentAction = broadcastIntent.getAction();
            }
            ThreadSpanState state = (ThreadSpanState)sThisThreadSpanState.get();
            if (tr instanceof InstanceCountViolation) {
                this.numInstances = ((InstanceCountViolation)tr).mInstances;
            }
            ThreadSpanState threadSpanState = state;
            synchronized (threadSpanState) {
                int spanActiveCount = state.mActiveSize;
                if (spanActiveCount > 20) {
                    spanActiveCount = 20;
                }
                if (spanActiveCount != 0) {
                    this.tags = new String[spanActiveCount];
                    Span iter = state.mActiveHead;
                    for (int index = 0; iter != null && index < spanActiveCount; ++index) {
                        this.tags[index] = iter.mName;
                        iter = iter.mNext;
                    }
                }
            }
        }

        private final int $$robo$$android_os_StrictMode_ViolationInfo$hashCode() {
            int result = 17;
            if (this.crashInfo != null) {
                result = 37 * result + this.crashInfo.stackTrace.hashCode();
            }
            if (this.numAnimationsRunning != 0) {
                result *= 37;
            }
            if (this.broadcastIntentAction != null) {
                result = 37 * result + this.broadcastIntentAction.hashCode();
            }
            if (this.tags != null) {
                for (String tag : this.tags) {
                    result = 37 * result + tag.hashCode();
                }
            }
            return result;
        }

        private void $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(Parcel in) {
        }

        private void $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(Parcel in, boolean unsetGatheringBit) {
            this.durationMillis = -1;
            this.numAnimationsRunning = 0;
            this.numInstances = -1L;
            this.message = in.readString();
            this.crashInfo = in.readInt() != 0 ? new ApplicationErrorReport.CrashInfo(in) : null;
            int rawPolicy = in.readInt();
            this.policy = unsetGatheringBit ? rawPolicy & 0xFFBFFFFF : rawPolicy;
            this.durationMillis = in.readInt();
            this.violationNumThisLoop = in.readInt();
            this.numAnimationsRunning = in.readInt();
            this.violationUptimeMillis = in.readLong();
            this.numInstances = in.readLong();
            this.broadcastIntentAction = in.readString();
            this.tags = in.readStringArray();
        }

        private final void $$robo$$android_os_StrictMode_ViolationInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.message);
            if (this.crashInfo != null) {
                dest.writeInt(1);
                this.crashInfo.writeToParcel(dest, flags);
            } else {
                dest.writeInt(0);
            }
            int start = dest.dataPosition();
            dest.writeInt(this.policy);
            dest.writeInt(this.durationMillis);
            dest.writeInt(this.violationNumThisLoop);
            dest.writeInt(this.numAnimationsRunning);
            dest.writeLong(this.violationUptimeMillis);
            dest.writeLong(this.numInstances);
            dest.writeString(this.broadcastIntentAction);
            dest.writeStringArray(this.tags);
            int total = dest.dataPosition() - start;
        }

        private final void $$robo$$android_os_StrictMode_ViolationInfo$dump(Printer pw, String prefix) {
            if (this.crashInfo != null) {
                this.crashInfo.dump(pw, prefix);
            }
            pw.println(prefix + "policy: " + this.policy);
            if (this.durationMillis != -1) {
                pw.println(prefix + "durationMillis: " + this.durationMillis);
            }
            if (this.numInstances != -1L) {
                pw.println(prefix + "numInstances: " + this.numInstances);
            }
            if (this.violationNumThisLoop != 0) {
                pw.println(prefix + "violationNumThisLoop: " + this.violationNumThisLoop);
            }
            if (this.numAnimationsRunning != 0) {
                pw.println(prefix + "numAnimationsRunning: " + this.numAnimationsRunning);
            }
            pw.println(prefix + "violationUptimeMillis: " + this.violationUptimeMillis);
            if (this.broadcastIntentAction != null) {
                pw.println(prefix + "broadcastIntentAction: " + this.broadcastIntentAction);
            }
            if (this.tags != null) {
                int index = 0;
                for (String tag : this.tags) {
                    pw.println(prefix + "tag[" + index++ + "]: " + tag);
                }
            }
        }

        private final int $$robo$$android_os_StrictMode_ViolationInfo$describeContents() {
            return 0;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ViolationInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_StrictMode_ViolationInfo_1$__constructor__() {
                }

                private final ViolationInfo $$robo$$android_os_StrictMode_ViolationInfo_1$createFromParcel(Parcel in) {
                    return new ViolationInfo(in);
                }

                private final ViolationInfo[] $$robo$$android_os_StrictMode_ViolationInfo_1$newArray(int size) {
                    return new ViolationInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_StrictMode_ViolationInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo_1$__constructor__(), this);
                }

                @Override
                public ViolationInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_StrictMode_ViolationInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ViolationInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_StrictMode_ViolationInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_os_StrictMode_ViolationInfo$__constructor__();
        }

        public ViolationInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(), this);
        }

        private void __constructor__(Throwable throwable, int n) {
            this.$$robo$$android_os_StrictMode_ViolationInfo$__constructor__(throwable, n);
        }

        public ViolationInfo(Throwable throwable, int n) {
            this(null, throwable, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(java.lang.Throwable int ), this, throwable, n);
        }

        private void __constructor__(String string2, Throwable throwable, int n) {
            this.$$robo$$android_os_StrictMode_ViolationInfo$__constructor__(string2, throwable, n);
        }

        public ViolationInfo(String string2, Throwable throwable, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(java.lang.String java.lang.Throwable int ), this, string2, throwable, n);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_StrictMode_ViolationInfo$hashCode(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_StrictMode_ViolationInfo$__constructor__(parcel);
        }

        public ViolationInfo(Parcel parcel) {
            this(parcel, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcel parcel, boolean bl) {
            this.$$robo$$android_os_StrictMode_ViolationInfo$__constructor__(parcel, bl);
        }

        public ViolationInfo(Parcel parcel, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(android.os.Parcel boolean ), this, parcel, bl);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_StrictMode_ViolationInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void dump(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_StrictMode_ViolationInfo$dump(android.util.Printer java.lang.String ), this, printer, string2);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_StrictMode_ViolationInfo$describeContents(), this);
        }

        static {
            RobolectricInternals.classInitializing(ViolationInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViolationInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ThreadSpanState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Span mActiveHead;
        public int mActiveSize;
        public Span mFreeListHead;
        public int mFreeListSize;

        private void $$robo$$android_os_StrictMode_ThreadSpanState$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_ThreadSpanState$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_os_StrictMode_ThreadSpanState$__constructor__();
        }

        public ThreadSpanState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadSpanState$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_os_StrictMode_ThreadSpanState$__constructor__(var1_1);
        }

        public /* synthetic */ ThreadSpanState(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadSpanState$__constructor__(android.os.StrictMode$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadSpanState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Span
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mName;
        private long mCreateMillis;
        private Span mNext;
        private Span mPrev;
        private ThreadSpanState mContainerState;

        private void $$robo$$android_os_StrictMode_Span$__constructor__(ThreadSpanState threadState) {
            this.mContainerState = threadState;
        }

        private void $$robo$$android_os_StrictMode_Span$__constructor__() {
            this.mContainerState = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_StrictMode_Span$finish() {
            ThreadSpanState state;
            ThreadSpanState threadSpanState = state = this.mContainerState;
            synchronized (threadSpanState) {
                if (this.mName == null) {
                    return;
                }
                if (this.mPrev != null) {
                    this.mPrev.mNext = this.mNext;
                }
                if (this.mNext != null) {
                    this.mNext.mPrev = this.mPrev;
                }
                if (state.mActiveHead == this) {
                    state.mActiveHead = this.mNext;
                }
                --state.mActiveSize;
                if (LOG_V) {
                    Log.d("StrictMode", "Span finished=" + this.mName + "; size=" + state.mActiveSize);
                }
                this.mCreateMillis = -1L;
                this.mName = null;
                this.mPrev = null;
                this.mNext = null;
                if (state.mFreeListSize < 5) {
                    this.mNext = state.mFreeListHead;
                    state.mFreeListHead = this;
                    ++state.mFreeListSize;
                }
            }
        }

        private void __constructor__(ThreadSpanState threadSpanState) {
            this.$$robo$$android_os_StrictMode_Span$__constructor__(threadSpanState);
        }

        public Span(ThreadSpanState threadSpanState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_Span$__constructor__(android.os.StrictMode$ThreadSpanState ), this, threadSpanState);
        }

        private void __constructor__() {
            this.$$robo$$android_os_StrictMode_Span$__constructor__();
        }

        public Span() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_Span$__constructor__(), this);
        }

        public void finish() {
            InvokeDynamicSupport.bootstrap("finish", $$robo$$android_os_StrictMode_Span$finish(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Span)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LogStackTrace
    extends Exception
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_LogStackTrace$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_LogStackTrace$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_os_StrictMode_LogStackTrace$__constructor__();
        }

        public LogStackTrace() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_LogStackTrace$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_os_StrictMode_LogStackTrace$__constructor__(var1_1);
        }

        public /* synthetic */ LogStackTrace(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_LogStackTrace$__constructor__(android.os.StrictMode$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogStackTrace)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AndroidCloseGuardReporter
    implements CloseGuard.Reporter,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__() {
        }

        private final void $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$report(String message, Throwable allocationSite) {
            StrictMode.onVmPolicyViolation(message, allocationSite);
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__();
        }

        public AndroidCloseGuardReporter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__(), this);
        }

        @Override
        public void report(String string2, Throwable throwable) {
            InvokeDynamicSupport.bootstrap("report", $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$report(java.lang.String java.lang.Throwable ), this, string2, throwable);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__(var1_1);
        }

        public /* synthetic */ AndroidCloseGuardReporter(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__(android.os.StrictMode$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidCloseGuardReporter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AndroidBlockGuardPolicy
    implements BlockGuard.Policy,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mPolicyMask;
        private ArrayMap<Integer, Long> mLastViolationTime;

        private void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$__constructor__(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        private final String $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$toString() {
            return "AndroidBlockGuardPolicy; mPolicyMask=" + this.mPolicyMask;
        }

        private final int $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$getPolicyMask() {
            return this.mPolicyMask;
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onWriteToDisk() {
            if ((this.mPolicyMask & 1) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeDiskWriteViolation e = new StrictModeDiskWriteViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onCustomSlowCall(String name) {
            if ((this.mPolicyMask & 8) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeCustomViolation e = new StrictModeCustomViolation(this.mPolicyMask, name);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onResourceMismatch(Object tag) {
            if ((this.mPolicyMask & 0x10) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeResourceMismatchViolation e = new StrictModeResourceMismatchViolation(this.mPolicyMask, tag);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onUnbufferedIO() {
            if ((this.mPolicyMask & 0x20) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeUnbufferedIOViolation e = new StrictModeUnbufferedIOViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onReadFromDisk() {
            if ((this.mPolicyMask & 2) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeDiskReadViolation e = new StrictModeDiskReadViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onNetwork() {
            if ((this.mPolicyMask & 4) == 0) {
                return;
            }
            if ((this.mPolicyMask & 0x1000000) != 0) {
                throw new NetworkOnMainThreadException();
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeNetworkViolation e = new StrictModeNetworkViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$setPolicyMask(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$startHandlingViolationException(BlockGuard.BlockGuardPolicyException e) {
            ViolationInfo info = new ViolationInfo(e, e.getPolicy());
            info.violationUptimeMillis = SystemClock.uptimeMillis();
            this.handleViolationWithTimingAttempt(info);
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$handleViolationWithTimingAttempt(ViolationInfo info) {
            IWindowManager windowManager;
            Looper looper = Looper.myLooper();
            if (looper == null || (info.policy & 0x1770000) == 262144) {
                info.durationMillis = -1;
                this.handleViolation(info);
                return;
            }
            ArrayList records = (ArrayList)violationsBeingTimed.get();
            if (records.size() >= 10) {
                return;
            }
            records.add(info);
            if (records.size() > 1) {
                return;
            }
            IWindowManager iWindowManager = windowManager = (info.policy & 0x100000) != 0 ? (IWindowManager)sWindowManager.get() : null;
            if (windowManager != null) {
                try {
                    windowManager.showStrictModeViolation(true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            ((Handler)threadHandler.get()).postAtFrontOfQueue(new Runnable(this, windowManager, records){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ IWindowManager val$windowManager;
                /* synthetic */ ArrayList val$records;
                /* synthetic */ AndroidBlockGuardPolicy this$0;

                private void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy_1$__constructor__(AndroidBlockGuardPolicy this$0, IWindowManager iWindowManager, ArrayList arrayList) {
                    this.val$windowManager = iWindowManager;
                    this.val$records = arrayList;
                }

                private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy_1$run() {
                    long loopFinishTime = SystemClock.uptimeMillis();
                    if (this.val$windowManager != null) {
                        try {
                            this.val$windowManager.showStrictModeViolation(false);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    for (int n = 0; n < this.val$records.size(); ++n) {
                        ViolationInfo v = (ViolationInfo)this.val$records.get(n);
                        v.violationNumThisLoop = n + 1;
                        v.durationMillis = (int)(loopFinishTime - v.violationUptimeMillis);
                        this.this$0.handleViolation(v);
                    }
                    this.val$records.clear();
                }

                private void __constructor__(AndroidBlockGuardPolicy androidBlockGuardPolicy, IWindowManager iWindowManager, ArrayList arrayList) {
                    this.$$robo$$android_os_StrictMode_AndroidBlockGuardPolicy_1$__constructor__(androidBlockGuardPolicy, iWindowManager, arrayList);
                }
                {
                    this.this$0 = androidBlockGuardPolicy;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy_1$__constructor__(android.os.StrictMode$AndroidBlockGuardPolicy android.view.IWindowManager java.util.ArrayList ), this, androidBlockGuardPolicy, iWindowManager, arrayList);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$handleViolation(ViolationInfo info) {
            long timeSinceLastViolationMillis;
            if (info == null || info.crashInfo == null || info.crashInfo.stackTrace == null) {
                Log.wtf("StrictMode", "unexpected null stacktrace");
                return;
            }
            if (LOG_V) {
                Log.d("StrictMode", "handleViolation; policy=" + info.policy);
            }
            if ((info.policy & 0x400000) != 0) {
                ArrayList<ViolationInfo> violations = (ArrayList<ViolationInfo>)gatheredViolations.get();
                if (violations == null) {
                    violations = new ArrayList<ViolationInfo>(1);
                    gatheredViolations.set(violations);
                }
                for (ViolationInfo previous : violations) {
                    if (!info.crashInfo.stackTrace.equals(previous.crashInfo.stackTrace)) continue;
                    return;
                }
                violations.add(info);
                return;
            }
            Integer crashFingerprint = info.hashCode();
            long lastViolationTime = 0L;
            if (this.mLastViolationTime != null) {
                Long vtime = this.mLastViolationTime.get(crashFingerprint);
                if (vtime != null) {
                    lastViolationTime = vtime;
                }
            } else {
                this.mLastViolationTime = new ArrayMap(1);
            }
            long now = SystemClock.uptimeMillis();
            this.mLastViolationTime.put(crashFingerprint, now);
            long l = timeSinceLastViolationMillis = lastViolationTime == 0L ? Long.MAX_VALUE : now - lastViolationTime;
            if ((info.policy & 0x10000) != 0 && sListener != null) {
                sListener.onViolation(info.crashInfo.stackTrace);
            }
            if ((info.policy & 0x10000) != 0 && timeSinceLastViolationMillis > 1000L) {
                if (info.durationMillis != -1) {
                    Log.d("StrictMode", "StrictMode policy violation; ~duration=" + info.durationMillis + " ms: " + info.crashInfo.stackTrace);
                } else {
                    Log.d("StrictMode", "StrictMode policy violation: " + info.crashInfo.stackTrace);
                }
            }
            int violationMaskSubset = 0;
            if ((info.policy & 0x20000) != 0 && timeSinceLastViolationMillis > 30000L) {
                violationMaskSubset |= 0x20000;
            }
            if ((info.policy & 0x200000) != 0 && lastViolationTime == 0L) {
                violationMaskSubset |= 0x200000;
            }
            if (violationMaskSubset != 0) {
                boolean justDropBox;
                int violationBit = StrictMode.parseViolationFromMessage(info.crashInfo.exceptionMessage);
                violationMaskSubset |= violationBit;
                int savedPolicyMask = StrictMode.getThreadPolicyMask();
                boolean bl = justDropBox = (info.policy & 0x1770000) == 0x200000;
                if (justDropBox) {
                    StrictMode.dropboxViolationAsync(violationMaskSubset, info);
                    return;
                }
                try {
                    StrictMode.setThreadPolicyMask(0);
                    ActivityManager.getService().handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
                }
                catch (RemoteException e) {
                    if (e instanceof DeadObjectException) {
                    } else {
                        Log.e("StrictMode", "RemoteException trying to handle StrictMode violation", e);
                    }
                }
                finally {
                    StrictMode.setThreadPolicyMask(savedPolicyMask);
                }
            }
            if ((info.policy & 0x40000) != 0) {
                StrictMode.executeDeathPenalty(info);
            }
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$__constructor__(n);
        }

        public AndroidBlockGuardPolicy(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$__constructor__(int ), this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$toString(), this);
        }

        @Override
        public int getPolicyMask() {
            return (int)InvokeDynamicSupport.bootstrap("getPolicyMask", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$getPolicyMask(), this);
        }

        @Override
        public void onWriteToDisk() {
            InvokeDynamicSupport.bootstrap("onWriteToDisk", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onWriteToDisk(), this);
        }

        void onCustomSlowCall(String string2) {
            InvokeDynamicSupport.bootstrap("onCustomSlowCall", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onCustomSlowCall(java.lang.String ), this, string2);
        }

        void onResourceMismatch(Object object) {
            InvokeDynamicSupport.bootstrap("onResourceMismatch", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onResourceMismatch(java.lang.Object ), this, object);
        }

        @Override
        public void onUnbufferedIO() {
            InvokeDynamicSupport.bootstrap("onUnbufferedIO", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onUnbufferedIO(), this);
        }

        @Override
        public void onReadFromDisk() {
            InvokeDynamicSupport.bootstrap("onReadFromDisk", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onReadFromDisk(), this);
        }

        @Override
        public void onNetwork() {
            InvokeDynamicSupport.bootstrap("onNetwork", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onNetwork(), this);
        }

        public void setPolicyMask(int n) {
            InvokeDynamicSupport.bootstrap("setPolicyMask", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$setPolicyMask(int ), this, n);
        }

        void startHandlingViolationException(BlockGuard.BlockGuardPolicyException blockGuardPolicyException) {
            InvokeDynamicSupport.bootstrap("startHandlingViolationException", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$startHandlingViolationException(dalvik.system.BlockGuard$BlockGuardPolicyException ), this, blockGuardPolicyException);
        }

        void handleViolationWithTimingAttempt(ViolationInfo violationInfo) {
            InvokeDynamicSupport.bootstrap("handleViolationWithTimingAttempt", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$handleViolationWithTimingAttempt(android.os.StrictMode$ViolationInfo ), this, violationInfo);
        }

        void handleViolation(ViolationInfo violationInfo) {
            InvokeDynamicSupport.bootstrap("handleViolation", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$handleViolation(android.os.StrictMode$ViolationInfo ), this, violationInfo);
        }

        public /* synthetic */ AndroidBlockGuardPolicy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidBlockGuardPolicy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StrictModeUnbufferedIOViolation
    extends StrictModeViolation
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_StrictModeUnbufferedIOViolation$__constructor__(int policyMask) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_StrictMode_StrictModeUnbufferedIOViolation$__constructor__(n);
        }

        public StrictModeUnbufferedIOViolation(int n) {
            super(n, 32, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_StrictModeUnbufferedIOViolation$__constructor__(int ), this, n);
        }

        public /* synthetic */ StrictModeUnbufferedIOViolation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictModeUnbufferedIOViolation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StrictModeResourceMismatchViolation
    extends StrictModeViolation
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_StrictModeResourceMismatchViolation$__constructor__(int policyMask, Object tag) {
        }

        private void __constructor__(int n, Object object) {
            this.$$robo$$android_os_StrictMode_StrictModeResourceMismatchViolation$__constructor__(n, object);
        }

        public StrictModeResourceMismatchViolation(int n, Object object) {
            super(n, 16, object != null ? object.toString() : null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_StrictModeResourceMismatchViolation$__constructor__(int java.lang.Object ), this, n, object);
        }

        public /* synthetic */ StrictModeResourceMismatchViolation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictModeResourceMismatchViolation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StrictModeCustomViolation
    extends StrictModeViolation
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_StrictModeCustomViolation$__constructor__(int policyMask, String name) {
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_os_StrictMode_StrictModeCustomViolation$__constructor__(n, string2);
        }

        public StrictModeCustomViolation(int n, String string2) {
            super(n, 8, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_StrictModeCustomViolation$__constructor__(int java.lang.String ), this, n, string2);
        }

        public /* synthetic */ StrictModeCustomViolation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictModeCustomViolation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StrictModeDiskWriteViolation
    extends StrictModeViolation
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_StrictModeDiskWriteViolation$__constructor__(int policyMask) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_StrictMode_StrictModeDiskWriteViolation$__constructor__(n);
        }

        public StrictModeDiskWriteViolation(int n) {
            super(n, 1, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_StrictModeDiskWriteViolation$__constructor__(int ), this, n);
        }

        public /* synthetic */ StrictModeDiskWriteViolation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictModeDiskWriteViolation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StrictModeDiskReadViolation
    extends StrictModeViolation
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_StrictModeDiskReadViolation$__constructor__(int policyMask) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_StrictMode_StrictModeDiskReadViolation$__constructor__(n);
        }

        public StrictModeDiskReadViolation(int n) {
            super(n, 2, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_StrictModeDiskReadViolation$__constructor__(int ), this, n);
        }

        public /* synthetic */ StrictModeDiskReadViolation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictModeDiskReadViolation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StrictModeNetworkViolation
    extends StrictModeViolation
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_StrictModeNetworkViolation$__constructor__(int policyMask) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_StrictMode_StrictModeNetworkViolation$__constructor__(n);
        }

        public StrictModeNetworkViolation(int n) {
            super(n, 4, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_StrictModeNetworkViolation$__constructor__(int ), this, n);
        }

        public /* synthetic */ StrictModeNetworkViolation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictModeNetworkViolation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StrictModeViolation
    extends BlockGuard.BlockGuardPolicyException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_StrictModeViolation$__constructor__(int policyState, int policyViolated, String message) {
        }

        private void __constructor__(int n, int n2, String string2) {
            this.$$robo$$android_os_StrictMode_StrictModeViolation$__constructor__(n, n2, string2);
        }

        public StrictModeViolation(int n, int n2, String string2) {
            super(n, n2, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_StrictModeViolation$__constructor__(int int java.lang.String ), this, n, n2, string2);
        }

        public /* synthetic */ StrictModeViolation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictModeViolation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class VmPolicy
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static VmPolicy LAX;
        int mask;
        HashMap<Class, Integer> classInstanceLimit;

        private void $$robo$$android_os_StrictMode_VmPolicy$__constructor__(int mask, HashMap<Class, Integer> classInstanceLimit) {
            if (classInstanceLimit == null) {
                throw new NullPointerException("classInstanceLimit == null");
            }
            this.mask = mask;
            this.classInstanceLimit = classInstanceLimit;
        }

        private final String $$robo$$android_os_StrictMode_VmPolicy$toString() {
            return "[StrictMode.VmPolicy; mask=" + this.mask + "]";
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_VmPolicy$__constructor__(int x0, HashMap x1, 1 x2) {
        }

        static void __staticInitializer__() {
            LAX = new VmPolicy(0, EMPTY_CLASS_LIMIT_MAP);
        }

        private void __constructor__(int n, HashMap<Class, Integer> hashMap) {
            this.$$robo$$android_os_StrictMode_VmPolicy$__constructor__(n, hashMap);
        }

        public VmPolicy(int n, HashMap<Class, Integer> hashMap) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_VmPolicy$__constructor__(int java.util.HashMap<java.lang.Class, java.lang.Integer> ), this, n, hashMap);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_StrictMode_VmPolicy$toString(), this);
        }

        private /* synthetic */ void __constructor__(int n, HashMap hashMap, 1 var3_3) {
            this.$$robo$$android_os_StrictMode_VmPolicy$__constructor__(n, hashMap, var3_3);
        }

        public /* synthetic */ VmPolicy(int n, HashMap hashMap, 1 var3_3) {
            this(n, hashMap);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_VmPolicy$__constructor__(int java.util.HashMap android.os.StrictMode$1 ), this, n, hashMap, var3_3);
        }

        static {
            RobolectricInternals.classInitializing(VmPolicy.class);
        }

        public /* synthetic */ VmPolicy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VmPolicy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mMask;
            private HashMap<Class, Integer> mClassInstanceLimit;
            private boolean mClassInstanceLimitNeedCow;

            private void $$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__() {
                this.mClassInstanceLimitNeedCow = false;
                this.mMask = 0;
            }

            private void $$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__(VmPolicy base) {
                this.mClassInstanceLimitNeedCow = false;
                this.mMask = base.mask;
                this.mClassInstanceLimitNeedCow = true;
                this.mClassInstanceLimit = base.classInstanceLimit;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$setClassInstanceLimit(Class klass, int instanceLimit) {
                if (klass == null) {
                    throw new NullPointerException("klass == null");
                }
                if (this.mClassInstanceLimitNeedCow) {
                    if (this.mClassInstanceLimit.containsKey(klass) && this.mClassInstanceLimit.get(klass) == instanceLimit) {
                        return this;
                    }
                    this.mClassInstanceLimitNeedCow = false;
                    this.mClassInstanceLimit = (HashMap)this.mClassInstanceLimit.clone();
                } else if (this.mClassInstanceLimit == null) {
                    this.mClassInstanceLimit = new HashMap();
                }
                this.mMask |= 0x800;
                this.mClassInstanceLimit.put(klass, instanceLimit);
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectActivityLeaks() {
                return this.enable(1024);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectAll() {
                this.detectLeakedSqlLiteObjects();
                int targetSdk = VMRuntime.getRuntime().getTargetSdkVersion();
                if (targetSdk >= 11) {
                    this.detectActivityLeaks();
                    this.detectLeakedClosableObjects();
                }
                if (targetSdk >= 16) {
                    this.detectLeakedRegistrationObjects();
                }
                if (targetSdk >= 18) {
                    this.detectFileUriExposure();
                }
                if (targetSdk >= 23 && SystemProperties.getBoolean("persist.sys.strictmode.clear", false)) {
                    this.detectCleartextNetwork();
                }
                if (targetSdk >= 26) {
                    this.detectContentUriWithoutPermission();
                    this.detectUntaggedSockets();
                }
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedSqlLiteObjects() {
                return this.enable(256);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedClosableObjects() {
                return this.enable(512);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedRegistrationObjects() {
                return this.enable(4096);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectFileUriExposure() {
                return this.enable(8192);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectCleartextNetwork() {
                return this.enable(16384);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectContentUriWithoutPermission() {
                return this.enable(32768);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectUntaggedSockets() {
                return this.enable(Integer.MIN_VALUE);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeath() {
                return this.enable(262144);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeathOnCleartextNetwork() {
                return this.enable(0x2000000);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeathOnFileUriExposure() {
                return this.enable(0x4000000);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyLog() {
                return this.enable(65536);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDropBox() {
                return this.enable(0x200000);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            private final VmPolicy $$robo$$android_os_StrictMode_VmPolicy_Builder$build() {
                if (this.mMask != 0 && (this.mMask & 0x270000) == 0) {
                    this.penaltyLog();
                }
                return new VmPolicy(this.mMask, this.mClassInstanceLimit != null ? this.mClassInstanceLimit : EMPTY_CLASS_LIMIT_MAP, null);
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__(), this);
            }

            private void __constructor__(VmPolicy vmPolicy) {
                this.$$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__(vmPolicy);
            }

            public Builder(VmPolicy vmPolicy) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__(android.os.StrictMode$VmPolicy ), this, vmPolicy);
            }

            public Builder setClassInstanceLimit(Class clazz, int n) {
                return InvokeDynamicSupport.bootstrap("setClassInstanceLimit", $$robo$$android_os_StrictMode_VmPolicy_Builder$setClassInstanceLimit(java.lang.Class int ), this, clazz, n);
            }

            public Builder detectActivityLeaks() {
                return InvokeDynamicSupport.bootstrap("detectActivityLeaks", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectActivityLeaks(), this);
            }

            public Builder detectAll() {
                return InvokeDynamicSupport.bootstrap("detectAll", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectAll(), this);
            }

            public Builder detectLeakedSqlLiteObjects() {
                return InvokeDynamicSupport.bootstrap("detectLeakedSqlLiteObjects", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedSqlLiteObjects(), this);
            }

            public Builder detectLeakedClosableObjects() {
                return InvokeDynamicSupport.bootstrap("detectLeakedClosableObjects", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedClosableObjects(), this);
            }

            public Builder detectLeakedRegistrationObjects() {
                return InvokeDynamicSupport.bootstrap("detectLeakedRegistrationObjects", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedRegistrationObjects(), this);
            }

            public Builder detectFileUriExposure() {
                return InvokeDynamicSupport.bootstrap("detectFileUriExposure", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectFileUriExposure(), this);
            }

            public Builder detectCleartextNetwork() {
                return InvokeDynamicSupport.bootstrap("detectCleartextNetwork", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectCleartextNetwork(), this);
            }

            public Builder detectContentUriWithoutPermission() {
                return InvokeDynamicSupport.bootstrap("detectContentUriWithoutPermission", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectContentUriWithoutPermission(), this);
            }

            public Builder detectUntaggedSockets() {
                return InvokeDynamicSupport.bootstrap("detectUntaggedSockets", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectUntaggedSockets(), this);
            }

            public Builder penaltyDeath() {
                return InvokeDynamicSupport.bootstrap("penaltyDeath", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeath(), this);
            }

            public Builder penaltyDeathOnCleartextNetwork() {
                return InvokeDynamicSupport.bootstrap("penaltyDeathOnCleartextNetwork", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeathOnCleartextNetwork(), this);
            }

            public Builder penaltyDeathOnFileUriExposure() {
                return InvokeDynamicSupport.bootstrap("penaltyDeathOnFileUriExposure", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeathOnFileUriExposure(), this);
            }

            public Builder penaltyLog() {
                return InvokeDynamicSupport.bootstrap("penaltyLog", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyLog(), this);
            }

            public Builder penaltyDropBox() {
                return InvokeDynamicSupport.bootstrap("penaltyDropBox", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDropBox(), this);
            }

            private Builder enable(int n) {
                return InvokeDynamicSupport.bootstrap("enable", $$robo$$android_os_StrictMode_VmPolicy_Builder$enable(int ), this, n);
            }

            Builder disable(int n) {
                return InvokeDynamicSupport.bootstrap("disable", $$robo$$android_os_StrictMode_VmPolicy_Builder$disable(int ), this, n);
            }

            public VmPolicy build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_os_StrictMode_VmPolicy_Builder$build(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ThreadPolicy
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static ThreadPolicy LAX;
        int mask;

        private void $$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(int mask) {
            this.mask = mask;
        }

        private final String $$robo$$android_os_StrictMode_ThreadPolicy$toString() {
            return "[StrictMode.ThreadPolicy; mask=" + this.mask + "]";
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(int x0, 1 x1) {
        }

        static void __staticInitializer__() {
            LAX = new ThreadPolicy(0);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(n);
        }

        public ThreadPolicy(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(int ), this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_StrictMode_ThreadPolicy$toString(), this);
        }

        private /* synthetic */ void __constructor__(int n, 1 var2_2) {
            this.$$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(n, var2_2);
        }

        public /* synthetic */ ThreadPolicy(int n, 1 var2_2) {
            this(n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(int android.os.StrictMode$1 ), this, n, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(ThreadPolicy.class);
        }

        public /* synthetic */ ThreadPolicy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadPolicy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mMask;

            private void $$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__() {
                this.mMask = 0;
                this.mMask = 0;
            }

            private void $$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__(ThreadPolicy policy) {
                this.mMask = 0;
                this.mMask = policy.mask;
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectAll() {
                this.detectDiskReads();
                this.detectDiskWrites();
                this.detectNetwork();
                int targetSdk = VMRuntime.getRuntime().getTargetSdkVersion();
                if (targetSdk >= 11) {
                    this.detectCustomSlowCalls();
                }
                if (targetSdk >= 23) {
                    this.detectResourceMismatches();
                }
                if (targetSdk >= 26) {
                    this.detectUnbufferedIo();
                }
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitAll() {
                return this.disable(63);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectNetwork() {
                return this.enable(4);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitNetwork() {
                return this.disable(4);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectDiskReads() {
                return this.enable(2);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitDiskReads() {
                return this.disable(2);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectCustomSlowCalls() {
                return this.enable(8);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitCustomSlowCalls() {
                return this.disable(8);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitResourceMismatches() {
                return this.disable(16);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectUnbufferedIo() {
                return this.enable(32);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitUnbufferedIo() {
                return this.disable(32);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectResourceMismatches() {
                return this.enable(16);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectDiskWrites() {
                return this.enable(1);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitDiskWrites() {
                return this.disable(1);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDialog() {
                return this.enable(131072);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDeath() {
                return this.enable(262144);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDeathOnNetwork() {
                return this.enable(0x1000000);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyFlashScreen() {
                return this.enable(0x100000);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyLog() {
                return this.enable(65536);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDropBox() {
                return this.enable(0x200000);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            private final ThreadPolicy $$robo$$android_os_StrictMode_ThreadPolicy_Builder$build() {
                if (this.mMask != 0 && (this.mMask & 0x270000) == 0) {
                    this.penaltyLog();
                }
                return new ThreadPolicy(this.mMask, null);
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__(), this);
            }

            private void __constructor__(ThreadPolicy threadPolicy) {
                this.$$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__(threadPolicy);
            }

            public Builder(ThreadPolicy threadPolicy) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__(android.os.StrictMode$ThreadPolicy ), this, threadPolicy);
            }

            public Builder detectAll() {
                return InvokeDynamicSupport.bootstrap("detectAll", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectAll(), this);
            }

            public Builder permitAll() {
                return InvokeDynamicSupport.bootstrap("permitAll", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitAll(), this);
            }

            public Builder detectNetwork() {
                return InvokeDynamicSupport.bootstrap("detectNetwork", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectNetwork(), this);
            }

            public Builder permitNetwork() {
                return InvokeDynamicSupport.bootstrap("permitNetwork", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitNetwork(), this);
            }

            public Builder detectDiskReads() {
                return InvokeDynamicSupport.bootstrap("detectDiskReads", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectDiskReads(), this);
            }

            public Builder permitDiskReads() {
                return InvokeDynamicSupport.bootstrap("permitDiskReads", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitDiskReads(), this);
            }

            public Builder detectCustomSlowCalls() {
                return InvokeDynamicSupport.bootstrap("detectCustomSlowCalls", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectCustomSlowCalls(), this);
            }

            public Builder permitCustomSlowCalls() {
                return InvokeDynamicSupport.bootstrap("permitCustomSlowCalls", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitCustomSlowCalls(), this);
            }

            public Builder permitResourceMismatches() {
                return InvokeDynamicSupport.bootstrap("permitResourceMismatches", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitResourceMismatches(), this);
            }

            public Builder detectUnbufferedIo() {
                return InvokeDynamicSupport.bootstrap("detectUnbufferedIo", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectUnbufferedIo(), this);
            }

            public Builder permitUnbufferedIo() {
                return InvokeDynamicSupport.bootstrap("permitUnbufferedIo", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitUnbufferedIo(), this);
            }

            public Builder detectResourceMismatches() {
                return InvokeDynamicSupport.bootstrap("detectResourceMismatches", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectResourceMismatches(), this);
            }

            public Builder detectDiskWrites() {
                return InvokeDynamicSupport.bootstrap("detectDiskWrites", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectDiskWrites(), this);
            }

            public Builder permitDiskWrites() {
                return InvokeDynamicSupport.bootstrap("permitDiskWrites", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitDiskWrites(), this);
            }

            public Builder penaltyDialog() {
                return InvokeDynamicSupport.bootstrap("penaltyDialog", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDialog(), this);
            }

            public Builder penaltyDeath() {
                return InvokeDynamicSupport.bootstrap("penaltyDeath", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDeath(), this);
            }

            public Builder penaltyDeathOnNetwork() {
                return InvokeDynamicSupport.bootstrap("penaltyDeathOnNetwork", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDeathOnNetwork(), this);
            }

            public Builder penaltyFlashScreen() {
                return InvokeDynamicSupport.bootstrap("penaltyFlashScreen", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyFlashScreen(), this);
            }

            public Builder penaltyLog() {
                return InvokeDynamicSupport.bootstrap("penaltyLog", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyLog(), this);
            }

            public Builder penaltyDropBox() {
                return InvokeDynamicSupport.bootstrap("penaltyDropBox", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDropBox(), this);
            }

            private Builder enable(int n) {
                return InvokeDynamicSupport.bootstrap("enable", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$enable(int ), this, n);
            }

            private Builder disable(int n) {
                return InvokeDynamicSupport.bootstrap("disable", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$disable(int ), this, n);
            }

            public ThreadPolicy build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$build(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static interface ViolationListener
    extends InstrumentedInterface {
        public void onViolation(String var1);
    }
}

