/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.MemoryFile;
import android.os.MessageQueue;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.invoke.CallSite;
import java.net.DatagramSocket;
import java.net.Socket;
import java.nio.ByteOrder;
import libcore.io.IoUtils;
import libcore.io.Memory;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ParcelFileDescriptor
implements Parcelable,
Closeable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ParcelFileDescriptor";
    private FileDescriptor mFd;
    private FileDescriptor mCommFd;
    private ParcelFileDescriptor mWrapped;
    private static int MAX_STATUS = 1024;
    private byte[] mStatusBuf;
    private Status mStatus;
    private volatile boolean mClosed;
    private CloseGuard mGuard;
    @Deprecated
    public static int MODE_WORLD_READABLE = 1;
    @Deprecated
    public static int MODE_WORLD_WRITEABLE = 2;
    public static int MODE_READ_ONLY = 0x10000000;
    public static int MODE_WRITE_ONLY = 0x20000000;
    public static int MODE_READ_WRITE = 0x30000000;
    public static int MODE_CREATE = 0x8000000;
    public static int MODE_TRUNCATE = 0x4000000;
    public static int MODE_APPEND = 0x2000000;
    public static Parcelable.Creator<ParcelFileDescriptor> CREATOR;

    private void $$robo$$android_os_ParcelFileDescriptor$__constructor__(ParcelFileDescriptor wrapped) {
        this.mGuard = CloseGuard.get();
        this.mWrapped = wrapped;
        this.mFd = null;
        this.mCommFd = null;
        this.mClosed = true;
    }

    private void $$robo$$android_os_ParcelFileDescriptor$__constructor__(FileDescriptor fd) {
    }

    private void $$robo$$android_os_ParcelFileDescriptor$__constructor__(FileDescriptor fd, FileDescriptor commChannel) {
        this.mGuard = CloseGuard.get();
        if (fd == null) {
            throw new NullPointerException("FileDescriptor must not be null");
        }
        this.mWrapped = null;
        this.mFd = fd;
        this.mCommFd = commChannel;
        this.mGuard.open("close");
    }

    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$open(File file, int mode) throws FileNotFoundException {
        FileDescriptor fd = ParcelFileDescriptor.openInternal(file, mode);
        if (fd == null) {
            return null;
        }
        return new ParcelFileDescriptor(fd);
    }

    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$open(File file, int mode, Handler handler, OnCloseListener listener) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Handler must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        FileDescriptor fd = ParcelFileDescriptor.openInternal(file, mode);
        if (fd == null) {
            return null;
        }
        return ParcelFileDescriptor.fromFd(fd, handler, listener);
    }

    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$fromFd(FileDescriptor fd, Handler handler, OnCloseListener listener) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Handler must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        FileDescriptor[] comm = ParcelFileDescriptor.createCommSocketPair();
        ParcelFileDescriptor pfd = new ParcelFileDescriptor(fd, comm[0]);
        MessageQueue queue = handler.getLooper().getQueue();
        queue.addOnFileDescriptorEventListener(comm[1], 1, new MessageQueue.OnFileDescriptorEventListener(queue, listener){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MessageQueue val$queue;
            /* synthetic */ OnCloseListener val$listener;

            private void $$robo$$android_os_ParcelFileDescriptor_1$__constructor__(MessageQueue messageQueue, OnCloseListener onCloseListener) {
                this.val$queue = messageQueue;
                this.val$listener = onCloseListener;
            }

            private final int $$robo$$android_os_ParcelFileDescriptor_1$onFileDescriptorEvents(FileDescriptor fd, int events) {
                Status status = null;
                if ((events & 1) != 0) {
                    byte[] buf = new byte[1024];
                    status = ParcelFileDescriptor.readCommStatus(fd, buf);
                } else if ((events & 4) != 0) {
                    status = new Status(-2);
                }
                if (status != null) {
                    this.val$queue.removeOnFileDescriptorEventListener(fd);
                    IoUtils.closeQuietly(fd);
                    this.val$listener.onClose(status.asIOException());
                    return 0;
                }
                return 1;
            }

            private void __constructor__(MessageQueue messageQueue, OnCloseListener onCloseListener) {
                this.$$robo$$android_os_ParcelFileDescriptor_1$__constructor__(messageQueue, onCloseListener);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor_1$__constructor__(android.os.MessageQueue android.os.ParcelFileDescriptor$OnCloseListener ), this, messageQueue, onCloseListener);
            }

            @Override
            public int onFileDescriptorEvents(FileDescriptor fileDescriptor, int n) {
                return (int)InvokeDynamicSupport.bootstrap("onFileDescriptorEvents", $$robo$$android_os_ParcelFileDescriptor_1$onFileDescriptorEvents(java.io.FileDescriptor int ), this, fileDescriptor, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        return pfd;
    }

    private static final FileDescriptor $$robo$$android_os_ParcelFileDescriptor$openInternal(File file, int mode) throws FileNotFoundException {
        if ((mode & 0x30000000) == 0) {
            throw new IllegalArgumentException("Must specify MODE_READ_ONLY, MODE_WRITE_ONLY, or MODE_READ_WRITE");
        }
        int flags = 0;
        switch (mode & 0x30000000) {
            case 0: 
            case 0x10000000: {
                flags = OsConstants.O_RDONLY;
                break;
            }
            case 0x20000000: {
                flags = OsConstants.O_WRONLY;
                break;
            }
            case 0x30000000: {
                flags = OsConstants.O_RDWR;
            }
        }
        if ((mode & 0x8000000) != 0) {
            flags |= OsConstants.O_CREAT;
        }
        if ((mode & 0x4000000) != 0) {
            flags |= OsConstants.O_TRUNC;
        }
        if ((mode & 0x2000000) != 0) {
            flags |= OsConstants.O_APPEND;
        }
        int realMode = OsConstants.S_IRWXU | OsConstants.S_IRWXG;
        if ((mode & 1) != 0) {
            realMode |= OsConstants.S_IROTH;
        }
        if ((mode & 2) != 0) {
            realMode |= OsConstants.S_IWOTH;
        }
        String path = file.getPath();
        try {
            return Os.open(path, flags, realMode);
        }
        catch (ErrnoException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$dup(FileDescriptor orig) throws IOException {
        try {
            FileDescriptor fd = Os.dup(orig);
            return new ParcelFileDescriptor(fd);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$dup() throws IOException {
        if (this.mWrapped != null) {
            return this.mWrapped.dup();
        }
        return ParcelFileDescriptor.dup(this.getFileDescriptor());
    }

    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$fromFd(int fd) throws IOException {
        FileDescriptor original = new FileDescriptor();
        InvokeDynamicSupport.bootstrapIntrinsic("setInt$", "java.io.FileDescriptor", (FileDescriptor)original, (int)fd);
        try {
            FileDescriptor dup = Os.dup(original);
            return new ParcelFileDescriptor(dup);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$adoptFd(int fd) {
        FileDescriptor fdesc = new FileDescriptor();
        InvokeDynamicSupport.bootstrapIntrinsic("setInt$", "java.io.FileDescriptor", (FileDescriptor)fdesc, (int)fd);
        return new ParcelFileDescriptor(fdesc);
    }

    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$fromSocket(Socket socket) {
        CallSite fd = InvokeDynamicSupport.bootstrapIntrinsic("getFileDescriptor$", "java.net.Socket", (Socket)socket);
        return fd != null ? new ParcelFileDescriptor((FileDescriptor)((Object)fd)) : null;
    }

    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$fromDatagramSocket(DatagramSocket datagramSocket) {
        FileDescriptor fd = datagramSocket.getFileDescriptor$();
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    private static final ParcelFileDescriptor[] $$robo$$android_os_ParcelFileDescriptor$createPipe() throws IOException {
        try {
            FileDescriptor[] fds = Os.pipe();
            return new ParcelFileDescriptor[]{new ParcelFileDescriptor(fds[0]), new ParcelFileDescriptor(fds[1])};
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private static final ParcelFileDescriptor[] $$robo$$android_os_ParcelFileDescriptor$createReliablePipe() throws IOException {
        try {
            FileDescriptor[] comm = ParcelFileDescriptor.createCommSocketPair();
            FileDescriptor[] fds = Os.pipe();
            return new ParcelFileDescriptor[]{new ParcelFileDescriptor(fds[0], comm[0]), new ParcelFileDescriptor(fds[1], comm[1])};
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private static final ParcelFileDescriptor[] $$robo$$android_os_ParcelFileDescriptor$createSocketPair() throws IOException {
        return ParcelFileDescriptor.createSocketPair(OsConstants.SOCK_STREAM);
    }

    private static final ParcelFileDescriptor[] $$robo$$android_os_ParcelFileDescriptor$createSocketPair(int type) throws IOException {
        try {
            FileDescriptor fd0 = new FileDescriptor();
            FileDescriptor fd1 = new FileDescriptor();
            Os.socketpair(OsConstants.AF_UNIX, type, 0, fd0, fd1);
            return new ParcelFileDescriptor[]{new ParcelFileDescriptor(fd0), new ParcelFileDescriptor(fd1)};
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private static final ParcelFileDescriptor[] $$robo$$android_os_ParcelFileDescriptor$createReliableSocketPair() throws IOException {
        return ParcelFileDescriptor.createReliableSocketPair(OsConstants.SOCK_STREAM);
    }

    private static final ParcelFileDescriptor[] $$robo$$android_os_ParcelFileDescriptor$createReliableSocketPair(int type) throws IOException {
        try {
            FileDescriptor[] comm = ParcelFileDescriptor.createCommSocketPair();
            FileDescriptor fd0 = new FileDescriptor();
            FileDescriptor fd1 = new FileDescriptor();
            Os.socketpair(OsConstants.AF_UNIX, type, 0, fd0, fd1);
            return new ParcelFileDescriptor[]{new ParcelFileDescriptor(fd0, comm[0]), new ParcelFileDescriptor(fd1, comm[1])};
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private static final FileDescriptor[] $$robo$$android_os_ParcelFileDescriptor$createCommSocketPair() throws IOException {
        try {
            FileDescriptor comm1 = new FileDescriptor();
            FileDescriptor comm2 = new FileDescriptor();
            Os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_SEQPACKET, 0, comm1, comm2);
            IoUtils.setBlocking(comm1, false);
            IoUtils.setBlocking(comm2, false);
            return new FileDescriptor[]{comm1, comm2};
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    @Deprecated
    private static final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor$fromData(byte[] data, String name) throws IOException {
        if (data == null) {
            return null;
        }
        MemoryFile file = new MemoryFile(name, data.length);
        if (data.length > 0) {
            file.writeBytes(data, 0, 0, data.length);
        }
        file.deactivate();
        FileDescriptor fd = file.getFileDescriptor();
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    private static final int $$robo$$android_os_ParcelFileDescriptor$parseMode(String mode) {
        int modeBits;
        if ("r".equals(mode)) {
            modeBits = 0x10000000;
        } else if ("w".equals(mode) || "wt".equals(mode)) {
            modeBits = 0x2C000000;
        } else if ("wa".equals(mode)) {
            modeBits = 0x2A000000;
        } else if ("rw".equals(mode)) {
            modeBits = 0x38000000;
        } else if ("rwt".equals(mode)) {
            modeBits = 0x3C000000;
        } else {
            throw new IllegalArgumentException("Bad mode '" + mode + "'");
        }
        return modeBits;
    }

    private static final File $$robo$$android_os_ParcelFileDescriptor$getFile(FileDescriptor fd) throws IOException {
        try {
            String path = Os.readlink("/proc/self/fd/" + (int)InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)fd));
            if (OsConstants.S_ISREG(Os.stat((String)path).st_mode)) {
                return new File(path);
            }
            throw new IOException("Not a regular file: " + path);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private final FileDescriptor $$robo$$android_os_ParcelFileDescriptor$getFileDescriptor() {
        if (this.mWrapped != null) {
            return this.mWrapped.getFileDescriptor();
        }
        return this.mFd;
    }

    private final long $$robo$$android_os_ParcelFileDescriptor$getStatSize() {
        if (this.mWrapped != null) {
            return this.mWrapped.getStatSize();
        }
        try {
            StructStat st = Os.fstat(this.mFd);
            if (OsConstants.S_ISREG(st.st_mode) || OsConstants.S_ISLNK(st.st_mode)) {
                return st.st_size;
            }
            return -1L;
        }
        catch (ErrnoException e) {
            Log.w("ParcelFileDescriptor", "fstat() failed: " + e);
            return -1L;
        }
    }

    private final long $$robo$$android_os_ParcelFileDescriptor$seekTo(long pos) throws IOException {
        if (this.mWrapped != null) {
            return this.mWrapped.seekTo(pos);
        }
        try {
            return Os.lseek(this.mFd, pos, OsConstants.SEEK_SET);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private final int $$robo$$android_os_ParcelFileDescriptor$getFd() {
        if (this.mWrapped != null) {
            return this.mWrapped.getFd();
        }
        if (this.mClosed) {
            throw new IllegalStateException("Already closed");
        }
        return (int)InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)this.mFd);
    }

    private final int $$robo$$android_os_ParcelFileDescriptor$detachFd() {
        if (this.mWrapped != null) {
            return this.mWrapped.detachFd();
        }
        if (this.mClosed) {
            throw new IllegalStateException("Already closed");
        }
        int fd = this.getFd();
        Parcel.clearFileDescriptor(this.mFd);
        this.writeCommStatusAndClose(2, null);
        this.mClosed = true;
        this.mGuard.close();
        this.releaseResources();
        return fd;
    }

    private final void $$robo$$android_os_ParcelFileDescriptor$close() throws IOException {
        if (this.mWrapped != null) {
            try {
                this.mWrapped.close();
            }
            finally {
                this.releaseResources();
            }
        } else {
            this.closeWithStatus(0, null);
        }
    }

    private final void $$robo$$android_os_ParcelFileDescriptor$closeWithError(String msg) throws IOException {
        if (this.mWrapped != null) {
            try {
                this.mWrapped.closeWithError(msg);
            }
            finally {
                this.releaseResources();
            }
        } else {
            if (msg == null) {
                throw new IllegalArgumentException("Message must not be null");
            }
            this.closeWithStatus(1, msg);
        }
    }

    private final void $$robo$$android_os_ParcelFileDescriptor$closeWithStatus(int status, String msg) {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mGuard.close();
        this.writeCommStatusAndClose(status, msg);
        IoUtils.closeQuietly(this.mFd);
        this.releaseResources();
    }

    private final void $$robo$$android_os_ParcelFileDescriptor$releaseResources() {
    }

    private final byte[] $$robo$$android_os_ParcelFileDescriptor$getOrCreateStatusBuffer() {
        if (this.mStatusBuf == null) {
            this.mStatusBuf = new byte[1024];
        }
        return this.mStatusBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_ParcelFileDescriptor$writeCommStatusAndClose(int status, String msg) {
        if (this.mCommFd == null) {
            if (msg != null) {
                Log.w("ParcelFileDescriptor", "Unable to inform peer: " + msg);
            }
            return;
        }
        if (status == 2) {
            Log.w("ParcelFileDescriptor", "Peer expected signal when closed; unable to deliver after detach");
        }
        try {
            if (status == -1) {
                return;
            }
            this.mStatus = ParcelFileDescriptor.readCommStatus(this.mCommFd, this.getOrCreateStatusBuffer());
            if (this.mStatus != null) {
                return;
            }
            try {
                byte[] buf = this.getOrCreateStatusBuffer();
                int writePtr = 0;
                Memory.pokeInt(buf, writePtr, status, ByteOrder.BIG_ENDIAN);
                writePtr += 4;
                if (msg != null) {
                    byte[] rawMsg = msg.getBytes();
                    int len = Math.min(rawMsg.length, buf.length - writePtr);
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])rawMsg, (int)0, (byte[])buf, (int)writePtr, (int)len);
                    writePtr += len;
                }
                Os.write(this.mCommFd, buf, 0, writePtr);
            }
            catch (ErrnoException e) {
                Log.w("ParcelFileDescriptor", "Failed to report status: " + e);
            }
            catch (InterruptedIOException e) {
                Log.w("ParcelFileDescriptor", "Failed to report status: " + e);
            }
        }
        finally {
            IoUtils.closeQuietly(this.mCommFd);
            this.mCommFd = null;
        }
    }

    private static final Status $$robo$$android_os_ParcelFileDescriptor$readCommStatus(FileDescriptor comm, byte[] buf) {
        try {
            int n = Os.read(comm, buf, 0, buf.length);
            if (n == 0) {
                return new Status(-2);
            }
            int status = Memory.peekInt(buf, 0, ByteOrder.BIG_ENDIAN);
            if (status == 1) {
                String msg = new String(buf, 4, n - 4);
                return new Status(status, msg);
            }
            return new Status(status);
        }
        catch (ErrnoException e) {
            if (e.errno == OsConstants.EAGAIN) {
                return null;
            }
            Log.d("ParcelFileDescriptor", "Failed to read status; assuming dead: " + e);
            return new Status(-2);
        }
        catch (InterruptedIOException e) {
            Log.d("ParcelFileDescriptor", "Failed to read status; assuming dead: " + e);
            return new Status(-2);
        }
    }

    private final boolean $$robo$$android_os_ParcelFileDescriptor$canDetectErrors() {
        if (this.mWrapped != null) {
            return this.mWrapped.canDetectErrors();
        }
        return this.mCommFd != null;
    }

    private final void $$robo$$android_os_ParcelFileDescriptor$checkError() throws IOException {
        if (this.mWrapped == null) {
            if (this.mStatus == null) {
                if (this.mCommFd == null) {
                    Log.w("ParcelFileDescriptor", "Peer didn't provide a comm channel; unable to check for errors");
                    return;
                }
                this.mStatus = ParcelFileDescriptor.readCommStatus(this.mCommFd, this.getOrCreateStatusBuffer());
            }
            if (this.mStatus == null || this.mStatus.status == 0) {
                return;
            }
            throw this.mStatus.asIOException();
        }
        this.mWrapped.checkError();
    }

    private final String $$robo$$android_os_ParcelFileDescriptor$toString() {
        if (this.mWrapped != null) {
            return this.mWrapped.toString();
        }
        return "{ParcelFileDescriptor: " + this.mFd + "}";
    }

    private final void $$robo$$android_os_ParcelFileDescriptor$finalize() throws Throwable {
        if (this.mWrapped != null) {
            this.releaseResources();
        }
        if (this.mGuard != null) {
            this.mGuard.warnIfOpen();
        }
        try {
            if (!this.mClosed) {
                this.closeWithStatus(3, null);
            }
        }
        finally {
            super.finalize();
        }
    }

    private final int $$robo$$android_os_ParcelFileDescriptor$describeContents() {
        if (this.mWrapped != null) {
            return this.mWrapped.describeContents();
        }
        return 1;
    }

    private final void $$robo$$android_os_ParcelFileDescriptor$writeToParcel(Parcel out, int flags) {
        if (this.mWrapped != null) {
            try {
                this.mWrapped.writeToParcel(out, flags);
            }
            finally {
                this.releaseResources();
            }
        } else {
            if (this.mCommFd != null) {
                out.writeInt(1);
                out.writeFileDescriptor(this.mFd);
                out.writeFileDescriptor(this.mCommFd);
            } else {
                out.writeInt(0);
                out.writeFileDescriptor(this.mFd);
            }
            if ((flags & 1) != 0 && !this.mClosed) {
                this.closeWithStatus(-1, null);
            }
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ParcelFileDescriptor>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_ParcelFileDescriptor_2$__constructor__() {
            }

            private final ParcelFileDescriptor $$robo$$android_os_ParcelFileDescriptor_2$createFromParcel(Parcel in) {
                int hasCommChannel = in.readInt();
                FileDescriptor fd = in.readRawFileDescriptor();
                FileDescriptor commChannel = null;
                if (hasCommChannel != 0) {
                    commChannel = in.readRawFileDescriptor();
                }
                return new ParcelFileDescriptor(fd, commChannel);
            }

            private final ParcelFileDescriptor[] $$robo$$android_os_ParcelFileDescriptor_2$newArray(int size) {
                return new ParcelFileDescriptor[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_ParcelFileDescriptor_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor_2$__constructor__(), this);
            }

            @Override
            public ParcelFileDescriptor createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_ParcelFileDescriptor_2$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public ParcelFileDescriptor[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_ParcelFileDescriptor_2$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ParcelFileDescriptor parcelFileDescriptor) {
        this.$$robo$$android_os_ParcelFileDescriptor$__constructor__(parcelFileDescriptor);
    }

    public ParcelFileDescriptor(ParcelFileDescriptor parcelFileDescriptor) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor$__constructor__(android.os.ParcelFileDescriptor ), this, parcelFileDescriptor);
    }

    private void __constructor__(FileDescriptor fileDescriptor) {
        this.$$robo$$android_os_ParcelFileDescriptor$__constructor__(fileDescriptor);
    }

    public ParcelFileDescriptor(FileDescriptor fileDescriptor) {
        this(fileDescriptor, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor$__constructor__(java.io.FileDescriptor ), this, fileDescriptor);
    }

    private void __constructor__(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) {
        this.$$robo$$android_os_ParcelFileDescriptor$__constructor__(fileDescriptor, fileDescriptor2);
    }

    public ParcelFileDescriptor(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor$__constructor__(java.io.FileDescriptor java.io.FileDescriptor ), this, fileDescriptor, fileDescriptor2);
    }

    public static ParcelFileDescriptor open(File file, int n) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("open", $$robo$$android_os_ParcelFileDescriptor$open(java.io.File int ), (File)file, (int)n);
    }

    public static ParcelFileDescriptor open(File file, int n, Handler handler, OnCloseListener onCloseListener) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("open", $$robo$$android_os_ParcelFileDescriptor$open(java.io.File int android.os.Handler android.os.ParcelFileDescriptor$OnCloseListener ), (File)file, (int)n, (Handler)handler, (OnCloseListener)onCloseListener);
    }

    public static ParcelFileDescriptor fromFd(FileDescriptor fileDescriptor, Handler handler, OnCloseListener onCloseListener) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("fromFd", $$robo$$android_os_ParcelFileDescriptor$fromFd(java.io.FileDescriptor android.os.Handler android.os.ParcelFileDescriptor$OnCloseListener ), (FileDescriptor)fileDescriptor, (Handler)handler, (OnCloseListener)onCloseListener);
    }

    private static FileDescriptor openInternal(File file, int n) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("openInternal", $$robo$$android_os_ParcelFileDescriptor$openInternal(java.io.File int ), (File)file, (int)n);
    }

    public static ParcelFileDescriptor dup(FileDescriptor fileDescriptor) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("dup", $$robo$$android_os_ParcelFileDescriptor$dup(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public ParcelFileDescriptor dup() throws IOException {
        return InvokeDynamicSupport.bootstrap("dup", $$robo$$android_os_ParcelFileDescriptor$dup(), this);
    }

    public static ParcelFileDescriptor fromFd(int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("fromFd", $$robo$$android_os_ParcelFileDescriptor$fromFd(int ), (int)n);
    }

    public static ParcelFileDescriptor adoptFd(int n) {
        return InvokeDynamicSupport.bootstrapStatic("adoptFd", $$robo$$android_os_ParcelFileDescriptor$adoptFd(int ), (int)n);
    }

    public static ParcelFileDescriptor fromSocket(Socket socket) {
        return InvokeDynamicSupport.bootstrapStatic("fromSocket", $$robo$$android_os_ParcelFileDescriptor$fromSocket(java.net.Socket ), (Socket)socket);
    }

    public static ParcelFileDescriptor fromDatagramSocket(DatagramSocket datagramSocket) {
        return InvokeDynamicSupport.bootstrapStatic("fromDatagramSocket", $$robo$$android_os_ParcelFileDescriptor$fromDatagramSocket(java.net.DatagramSocket ), (DatagramSocket)datagramSocket);
    }

    public static ParcelFileDescriptor[] createPipe() throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createPipe", $$robo$$android_os_ParcelFileDescriptor$createPipe());
    }

    public static ParcelFileDescriptor[] createReliablePipe() throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createReliablePipe", $$robo$$android_os_ParcelFileDescriptor$createReliablePipe());
    }

    public static ParcelFileDescriptor[] createSocketPair() throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createSocketPair", $$robo$$android_os_ParcelFileDescriptor$createSocketPair());
    }

    public static ParcelFileDescriptor[] createSocketPair(int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createSocketPair", $$robo$$android_os_ParcelFileDescriptor$createSocketPair(int ), (int)n);
    }

    public static ParcelFileDescriptor[] createReliableSocketPair() throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createReliableSocketPair", $$robo$$android_os_ParcelFileDescriptor$createReliableSocketPair());
    }

    public static ParcelFileDescriptor[] createReliableSocketPair(int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createReliableSocketPair", $$robo$$android_os_ParcelFileDescriptor$createReliableSocketPair(int ), (int)n);
    }

    private static FileDescriptor[] createCommSocketPair() throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createCommSocketPair", $$robo$$android_os_ParcelFileDescriptor$createCommSocketPair());
    }

    @Deprecated
    public static ParcelFileDescriptor fromData(byte[] byArray, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("fromData", $$robo$$android_os_ParcelFileDescriptor$fromData(byte[] java.lang.String ), (byte[])byArray, (String)string2);
    }

    public static int parseMode(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseMode", $$robo$$android_os_ParcelFileDescriptor$parseMode(java.lang.String ), (String)string2);
    }

    public static File getFile(FileDescriptor fileDescriptor) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getFile", $$robo$$android_os_ParcelFileDescriptor$getFile(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public FileDescriptor getFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$android_os_ParcelFileDescriptor$getFileDescriptor(), this);
    }

    public long getStatSize() {
        return (long)InvokeDynamicSupport.bootstrap("getStatSize", $$robo$$android_os_ParcelFileDescriptor$getStatSize(), this);
    }

    public long seekTo(long l) throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_os_ParcelFileDescriptor$seekTo(long ), this, l);
    }

    public int getFd() {
        return (int)InvokeDynamicSupport.bootstrap("getFd", $$robo$$android_os_ParcelFileDescriptor$getFd(), this);
    }

    public int detachFd() {
        return (int)InvokeDynamicSupport.bootstrap("detachFd", $$robo$$android_os_ParcelFileDescriptor$detachFd(), this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_ParcelFileDescriptor$close(), this);
    }

    public void closeWithError(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("closeWithError", $$robo$$android_os_ParcelFileDescriptor$closeWithError(java.lang.String ), this, string2);
    }

    private void closeWithStatus(int n, String string2) {
        InvokeDynamicSupport.bootstrap("closeWithStatus", $$robo$$android_os_ParcelFileDescriptor$closeWithStatus(int java.lang.String ), this, n, string2);
    }

    public void releaseResources() {
        InvokeDynamicSupport.bootstrap("releaseResources", $$robo$$android_os_ParcelFileDescriptor$releaseResources(), this);
    }

    private byte[] getOrCreateStatusBuffer() {
        return InvokeDynamicSupport.bootstrap("getOrCreateStatusBuffer", $$robo$$android_os_ParcelFileDescriptor$getOrCreateStatusBuffer(), this);
    }

    private void writeCommStatusAndClose(int n, String string2) {
        InvokeDynamicSupport.bootstrap("writeCommStatusAndClose", $$robo$$android_os_ParcelFileDescriptor$writeCommStatusAndClose(int java.lang.String ), this, n, string2);
    }

    private static Status readCommStatus(FileDescriptor fileDescriptor, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("readCommStatus", $$robo$$android_os_ParcelFileDescriptor$readCommStatus(java.io.FileDescriptor byte[] ), (FileDescriptor)fileDescriptor, (byte[])byArray);
    }

    public boolean canDetectErrors() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDetectErrors", $$robo$$android_os_ParcelFileDescriptor$canDetectErrors(), this);
    }

    public void checkError() throws IOException {
        InvokeDynamicSupport.bootstrap("checkError", $$robo$$android_os_ParcelFileDescriptor$checkError(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_ParcelFileDescriptor$toString(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_ParcelFileDescriptor$finalize(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_ParcelFileDescriptor$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_ParcelFileDescriptor$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(ParcelFileDescriptor.class);
    }

    public /* synthetic */ ParcelFileDescriptor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelFileDescriptor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Status
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int DEAD = -2;
        public static int SILENCE = -1;
        public static int OK = 0;
        public static int ERROR = 1;
        public static int DETACHED = 2;
        public static int LEAKED = 3;
        public int status;
        public String msg;

        private void $$robo$$android_os_ParcelFileDescriptor_Status$__constructor__(int status) {
        }

        private void $$robo$$android_os_ParcelFileDescriptor_Status$__constructor__(int status, String msg) {
            this.status = status;
            this.msg = msg;
        }

        private final IOException $$robo$$android_os_ParcelFileDescriptor_Status$asIOException() {
            switch (this.status) {
                case -2: {
                    return new IOException("Remote side is dead");
                }
                case 0: {
                    return null;
                }
                case 1: {
                    return new IOException("Remote error: " + this.msg);
                }
                case 2: {
                    return new FileDescriptorDetachedException();
                }
                case 3: {
                    return new IOException("Remote side was leaked");
                }
            }
            return new IOException("Unknown status: " + this.status);
        }

        private final String $$robo$$android_os_ParcelFileDescriptor_Status$toString() {
            return "{" + this.status + ": " + this.msg + "}";
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_ParcelFileDescriptor_Status$__constructor__(n);
        }

        public Status(int n) {
            this(n, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor_Status$__constructor__(int ), this, n);
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_os_ParcelFileDescriptor_Status$__constructor__(n, string2);
        }

        public Status(int n, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor_Status$__constructor__(int java.lang.String ), this, n, string2);
        }

        public IOException asIOException() {
            return InvokeDynamicSupport.bootstrap("asIOException", $$robo$$android_os_ParcelFileDescriptor_Status$asIOException(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_ParcelFileDescriptor_Status$toString(), this);
        }

        public /* synthetic */ Status() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Status)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class FileDescriptorDetachedException
    extends IOException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 955542466045L;

        private void $$robo$$android_os_ParcelFileDescriptor_FileDescriptorDetachedException$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_os_ParcelFileDescriptor_FileDescriptorDetachedException$__constructor__();
        }

        public FileDescriptorDetachedException() {
            super("Remote side is detached");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor_FileDescriptorDetachedException$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileDescriptorDetachedException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnCloseListener
    extends InstrumentedInterface {
        public void onClose(IOException var1);
    }

    public static class AutoCloseOutputStream
    extends FileOutputStream
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ParcelFileDescriptor mPfd;

        private void $$robo$$android_os_ParcelFileDescriptor_AutoCloseOutputStream$__constructor__(ParcelFileDescriptor pfd) {
            this.mPfd = pfd;
        }

        private final void $$robo$$android_os_ParcelFileDescriptor_AutoCloseOutputStream$close() throws IOException {
            try {
                this.mPfd.close();
            }
            finally {
                super.close();
            }
        }

        private void __constructor__(ParcelFileDescriptor parcelFileDescriptor) {
            this.$$robo$$android_os_ParcelFileDescriptor_AutoCloseOutputStream$__constructor__(parcelFileDescriptor);
        }

        public AutoCloseOutputStream(ParcelFileDescriptor parcelFileDescriptor) {
            super(parcelFileDescriptor.getFileDescriptor());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor_AutoCloseOutputStream$__constructor__(android.os.ParcelFileDescriptor ), this, parcelFileDescriptor);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_ParcelFileDescriptor_AutoCloseOutputStream$close(), this);
        }

        public /* synthetic */ AutoCloseOutputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutoCloseOutputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AutoCloseInputStream
    extends FileInputStream
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ParcelFileDescriptor mPfd;

        private void $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$__constructor__(ParcelFileDescriptor pfd) {
            this.mPfd = pfd;
        }

        private final void $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$close() throws IOException {
            try {
                this.mPfd.close();
            }
            finally {
                super.close();
            }
        }

        private final int $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$read() throws IOException {
            int result = super.read();
            if (result == -1 && this.mPfd.canDetectErrors()) {
                this.mPfd.checkError();
            }
            return result;
        }

        private final int $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$read(byte[] b) throws IOException {
            int result = super.read(b);
            if (result == -1 && this.mPfd.canDetectErrors()) {
                this.mPfd.checkError();
            }
            return result;
        }

        private final int $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            if (result == -1 && this.mPfd.canDetectErrors()) {
                this.mPfd.checkError();
            }
            return result;
        }

        private void __constructor__(ParcelFileDescriptor parcelFileDescriptor) {
            this.$$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$__constructor__(parcelFileDescriptor);
        }

        public AutoCloseInputStream(ParcelFileDescriptor parcelFileDescriptor) {
            super(parcelFileDescriptor.getFileDescriptor());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$__constructor__(android.os.ParcelFileDescriptor ), this, parcelFileDescriptor);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$close(), this);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$read(), this);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$read(byte[] ), this, byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_ParcelFileDescriptor_AutoCloseInputStream$read(byte[] int int ), this, byArray, n, n2);
        }

        public /* synthetic */ AutoCloseInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutoCloseInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

