/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.NetworkOnMainThreadException;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.ServiceSpecificException;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMRuntime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libcore.util.SneakyThrow;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Parcel
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG_RECYCLE = false;
    private static boolean DEBUG_ARRAY_MAP = false;
    private static String TAG = "Parcel";
    private long mNativePtr;
    private boolean mOwnsNativeParcelObject;
    private long mNativeSize;
    private ArrayMap<Class, Object> mClassCookies;
    private RuntimeException mStack;
    private static int POOL_SIZE = 6;
    private static Parcel[] sOwnedPool;
    private static Parcel[] sHolderPool;
    private static int VAL_NULL = -1;
    private static int VAL_STRING = 0;
    private static int VAL_INTEGER = 1;
    private static int VAL_MAP = 2;
    private static int VAL_BUNDLE = 3;
    private static int VAL_PARCELABLE = 4;
    private static int VAL_SHORT = 5;
    private static int VAL_LONG = 6;
    private static int VAL_FLOAT = 7;
    private static int VAL_DOUBLE = 8;
    private static int VAL_BOOLEAN = 9;
    private static int VAL_CHARSEQUENCE = 10;
    private static int VAL_LIST = 11;
    private static int VAL_SPARSEARRAY = 12;
    private static int VAL_BYTEARRAY = 13;
    private static int VAL_STRINGARRAY = 14;
    private static int VAL_IBINDER = 15;
    private static int VAL_PARCELABLEARRAY = 16;
    private static int VAL_OBJECTARRAY = 17;
    private static int VAL_INTARRAY = 18;
    private static int VAL_LONGARRAY = 19;
    private static int VAL_BYTE = 20;
    private static int VAL_SERIALIZABLE = 21;
    private static int VAL_SPARSEBOOLEANARRAY = 22;
    private static int VAL_BOOLEANARRAY = 23;
    private static int VAL_CHARSEQUENCEARRAY = 24;
    private static int VAL_PERSISTABLEBUNDLE = 25;
    private static int VAL_SIZE = 26;
    private static int VAL_SIZEF = 27;
    private static int VAL_DOUBLEARRAY = 28;
    private static int EX_SECURITY = -1;
    private static int EX_BAD_PARCELABLE = -2;
    private static int EX_ILLEGAL_ARGUMENT = -3;
    private static int EX_NULL_POINTER = -4;
    private static int EX_ILLEGAL_STATE = -5;
    private static int EX_NETWORK_MAIN_THREAD = -6;
    private static int EX_UNSUPPORTED_OPERATION = -7;
    private static int EX_SERVICE_SPECIFIC = -8;
    private static int EX_PARCELABLE = -9;
    private static int EX_HAS_REPLY_HEADER = -128;
    private static int EX_TRANSACTION_FAILED = -129;
    public static Parcelable.Creator<String> STRING_CREATOR;
    private static HashMap<ClassLoader, HashMap<String, Parcelable.Creator<?>>> mCreators;

    @FastNative
    private static final int $$robo$$android_os_Parcel$nativeDataSize(long l) {
        return 0;
    }

    @FastNative
    private static final int $$robo$$android_os_Parcel$nativeDataAvail(long l) {
        return 0;
    }

    @FastNative
    private static final int $$robo$$android_os_Parcel$nativeDataPosition(long l) {
        return 0;
    }

    @FastNative
    private static final int $$robo$$android_os_Parcel$nativeDataCapacity(long l) {
        return 0;
    }

    @FastNative
    private static final long $$robo$$android_os_Parcel$nativeSetDataSize(long l, int n) {
        return 0L;
    }

    @FastNative
    private static final void $$robo$$android_os_Parcel$nativeSetDataPosition(long l, int n) {
    }

    @FastNative
    private static final void $$robo$$android_os_Parcel$nativeSetDataCapacity(long l, int n) {
    }

    @FastNative
    private static final boolean $$robo$$android_os_Parcel$nativePushAllowFds(long l, boolean bl) {
        return false;
    }

    @FastNative
    private static final void $$robo$$android_os_Parcel$nativeRestoreAllowFds(long l, boolean bl) {
    }

    private static final void $$robo$$android_os_Parcel$nativeWriteByteArray(long l, byte[] byArray, int n, int n2) {
    }

    private static final void $$robo$$android_os_Parcel$nativeWriteBlob(long l, byte[] byArray, int n, int n2) {
    }

    @FastNative
    private static final void $$robo$$android_os_Parcel$nativeWriteInt(long l, int n) {
    }

    @FastNative
    private static final void $$robo$$android_os_Parcel$nativeWriteLong(long l, long l2) {
    }

    @FastNative
    private static final void $$robo$$android_os_Parcel$nativeWriteFloat(long l, float f) {
    }

    @FastNative
    private static final void $$robo$$android_os_Parcel$nativeWriteDouble(long l, double d) {
    }

    private static final void $$robo$$android_os_Parcel$nativeWriteString(long l, String string2) {
    }

    private static final void $$robo$$android_os_Parcel$nativeWriteStrongBinder(long l, IBinder iBinder) {
    }

    private static final long $$robo$$android_os_Parcel$nativeWriteFileDescriptor(long l, FileDescriptor fileDescriptor) {
        return 0L;
    }

    private static final byte[] $$robo$$android_os_Parcel$nativeCreateByteArray(long l) {
        return null;
    }

    private static final byte[] $$robo$$android_os_Parcel$nativeReadBlob(long l) {
        return null;
    }

    @FastNative
    private static final int $$robo$$android_os_Parcel$nativeReadInt(long l) {
        return 0;
    }

    @FastNative
    private static final long $$robo$$android_os_Parcel$nativeReadLong(long l) {
        return 0L;
    }

    @FastNative
    private static final float $$robo$$android_os_Parcel$nativeReadFloat(long l) {
        return 0.0f;
    }

    @FastNative
    private static final double $$robo$$android_os_Parcel$nativeReadDouble(long l) {
        return 0.0;
    }

    private static final String $$robo$$android_os_Parcel$nativeReadString(long l) {
        return null;
    }

    private static final IBinder $$robo$$android_os_Parcel$nativeReadStrongBinder(long l) {
        return null;
    }

    private static final FileDescriptor $$robo$$android_os_Parcel$nativeReadFileDescriptor(long l) {
        return null;
    }

    private static final long $$robo$$android_os_Parcel$nativeCreate() {
        return 0L;
    }

    private static final long $$robo$$android_os_Parcel$nativeFreeBuffer(long l) {
        return 0L;
    }

    private static final void $$robo$$android_os_Parcel$nativeDestroy(long l) {
    }

    private static final byte[] $$robo$$android_os_Parcel$nativeMarshall(long l) {
        return null;
    }

    private static final long $$robo$$android_os_Parcel$nativeUnmarshall(long l, byte[] byArray, int n, int n2) {
        return 0L;
    }

    private static final int $$robo$$android_os_Parcel$nativeCompareData(long l, long l2) {
        return 0;
    }

    private static final long $$robo$$android_os_Parcel$nativeAppendFrom(long l, long l2, int n, int n2) {
        return 0L;
    }

    @FastNative
    private static final boolean $$robo$$android_os_Parcel$nativeHasFileDescriptors(long l) {
        return false;
    }

    private static final void $$robo$$android_os_Parcel$nativeWriteInterfaceToken(long l, String string2) {
    }

    private static final void $$robo$$android_os_Parcel$nativeEnforceInterface(long l, String string2) {
    }

    private static final long $$robo$$android_os_Parcel$nativeGetBlobAshmemSize(long l) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Parcel $$robo$$android_os_Parcel$obtain() {
        Parcel[] pool;
        Parcel[] parcelArray = pool = sOwnedPool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                Parcel p = pool[i];
                if (p == null) continue;
                pool[i] = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return p;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Parcel(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_Parcel$recycle() {
        Parcel[] pool;
        this.freeBuffer();
        if (this.mOwnsNativeParcelObject) {
            pool = sOwnedPool;
        } else {
            this.mNativePtr = 0L;
            pool = sHolderPool;
        }
        Parcel[] parcelArray = pool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                if (pool[i] != null) continue;
                pool[i] = this;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static final long $$robo$$android_os_Parcel$getGlobalAllocSize() {
        return 0L;
    }

    private static final long $$robo$$android_os_Parcel$getGlobalAllocCount() {
        return 0L;
    }

    private final int $$robo$$android_os_Parcel$dataSize() {
        return Parcel.nativeDataSize(this.mNativePtr);
    }

    private final int $$robo$$android_os_Parcel$dataAvail() {
        return Parcel.nativeDataAvail(this.mNativePtr);
    }

    private final int $$robo$$android_os_Parcel$dataPosition() {
        return Parcel.nativeDataPosition(this.mNativePtr);
    }

    private final int $$robo$$android_os_Parcel$dataCapacity() {
        return Parcel.nativeDataCapacity(this.mNativePtr);
    }

    private final void $$robo$$android_os_Parcel$setDataSize(int size) {
        this.updateNativeSize(Parcel.nativeSetDataSize(this.mNativePtr, size));
    }

    private final void $$robo$$android_os_Parcel$setDataPosition(int pos) {
        Parcel.nativeSetDataPosition(this.mNativePtr, pos);
    }

    private final void $$robo$$android_os_Parcel$setDataCapacity(int size) {
        Parcel.nativeSetDataCapacity(this.mNativePtr, size);
    }

    private final boolean $$robo$$android_os_Parcel$pushAllowFds(boolean allowFds) {
        return Parcel.nativePushAllowFds(this.mNativePtr, allowFds);
    }

    private final void $$robo$$android_os_Parcel$restoreAllowFds(boolean lastValue) {
        Parcel.nativeRestoreAllowFds(this.mNativePtr, lastValue);
    }

    private final byte[] $$robo$$android_os_Parcel$marshall() {
        return Parcel.nativeMarshall(this.mNativePtr);
    }

    private final void $$robo$$android_os_Parcel$unmarshall(byte[] data, int offset, int length) {
        this.updateNativeSize(Parcel.nativeUnmarshall(this.mNativePtr, data, offset, length));
    }

    private final void $$robo$$android_os_Parcel$appendFrom(Parcel parcel, int offset, int length) {
        this.updateNativeSize(Parcel.nativeAppendFrom(this.mNativePtr, parcel.mNativePtr, offset, length));
    }

    private final int $$robo$$android_os_Parcel$compareData(Parcel other) {
        return Parcel.nativeCompareData(this.mNativePtr, other.mNativePtr);
    }

    private final void $$robo$$android_os_Parcel$setClassCookie(Class clz, Object cookie) {
        if (this.mClassCookies == null) {
            this.mClassCookies = new ArrayMap();
        }
        this.mClassCookies.put(clz, cookie);
    }

    private final Object $$robo$$android_os_Parcel$getClassCookie(Class clz) {
        return this.mClassCookies != null ? this.mClassCookies.get(clz) : null;
    }

    private final void $$robo$$android_os_Parcel$adoptClassCookies(Parcel from) {
        this.mClassCookies = from.mClassCookies;
    }

    private final boolean $$robo$$android_os_Parcel$hasFileDescriptors() {
        return Parcel.nativeHasFileDescriptors(this.mNativePtr);
    }

    private final void $$robo$$android_os_Parcel$writeInterfaceToken(String interfaceName) {
        Parcel.nativeWriteInterfaceToken(this.mNativePtr, interfaceName);
    }

    private final void $$robo$$android_os_Parcel$enforceInterface(String interfaceName) {
        Parcel.nativeEnforceInterface(this.mNativePtr, interfaceName);
    }

    private final void $$robo$$android_os_Parcel$writeByteArray(byte[] b) {
        this.writeByteArray(b, 0, b != null ? b.length : 0);
    }

    private final void $$robo$$android_os_Parcel$writeByteArray(byte[] b, int offset, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        Arrays.checkOffsetAndCount((int)b.length, (int)offset, (int)len);
        Parcel.nativeWriteByteArray(this.mNativePtr, b, offset, len);
    }

    private final void $$robo$$android_os_Parcel$writeBlob(byte[] b) {
        this.writeBlob(b, 0, b != null ? b.length : 0);
    }

    private final void $$robo$$android_os_Parcel$writeBlob(byte[] b, int offset, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        Arrays.checkOffsetAndCount((int)b.length, (int)offset, (int)len);
        Parcel.nativeWriteBlob(this.mNativePtr, b, offset, len);
    }

    private final void $$robo$$android_os_Parcel$writeInt(int val) {
        Parcel.nativeWriteInt(this.mNativePtr, val);
    }

    private final void $$robo$$android_os_Parcel$writeLong(long val) {
        Parcel.nativeWriteLong(this.mNativePtr, val);
    }

    private final void $$robo$$android_os_Parcel$writeFloat(float val) {
        Parcel.nativeWriteFloat(this.mNativePtr, val);
    }

    private final void $$robo$$android_os_Parcel$writeDouble(double val) {
        Parcel.nativeWriteDouble(this.mNativePtr, val);
    }

    private final void $$robo$$android_os_Parcel$writeString(String val) {
        Parcel.nativeWriteString(this.mNativePtr, val);
    }

    private final void $$robo$$android_os_Parcel$writeBoolean(boolean val) {
        this.writeInt(val ? 1 : 0);
    }

    private final void $$robo$$android_os_Parcel$writeCharSequence(CharSequence val) {
        TextUtils.writeToParcel(val, this, 0);
    }

    private final void $$robo$$android_os_Parcel$writeStrongBinder(IBinder val) {
        Parcel.nativeWriteStrongBinder(this.mNativePtr, val);
    }

    private final void $$robo$$android_os_Parcel$writeStrongInterface(IInterface val) {
        this.writeStrongBinder(val == null ? null : val.asBinder());
    }

    private final void $$robo$$android_os_Parcel$writeFileDescriptor(FileDescriptor val) {
        this.updateNativeSize(Parcel.nativeWriteFileDescriptor(this.mNativePtr, val));
    }

    private final void $$robo$$android_os_Parcel$updateNativeSize(long newNativeSize) {
        if (this.mOwnsNativeParcelObject) {
            if (newNativeSize > Integer.MAX_VALUE) {
                newNativeSize = Integer.MAX_VALUE;
            }
            if (newNativeSize != this.mNativeSize) {
                int delta = (int)(newNativeSize - this.mNativeSize);
                if (delta > 0) {
                    VMRuntime.getRuntime().registerNativeAllocation(delta);
                } else {
                    VMRuntime.getRuntime().registerNativeFree(-delta);
                }
                this.mNativeSize = newNativeSize;
            }
        }
    }

    private final void $$robo$$android_os_Parcel$writeRawFileDescriptor(FileDescriptor val) {
        Parcel.nativeWriteFileDescriptor(this.mNativePtr, val);
    }

    private final void $$robo$$android_os_Parcel$writeRawFileDescriptorArray(FileDescriptor[] value) {
        if (value != null) {
            int N = value.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeRawFileDescriptor(value[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final void $$robo$$android_os_Parcel$writeByte(byte val) {
        this.writeInt(val);
    }

    private final void $$robo$$android_os_Parcel$writeMap(Map val) {
        this.writeMapInternal(val);
    }

    private final void $$robo$$android_os_Parcel$writeMapInternal(Map<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        Set<Map.Entry<String, Object>> entries = val.entrySet();
        this.writeInt(entries.size());
        for (Map.Entry<String, Object> e : entries) {
            this.writeValue(e.getKey());
            this.writeValue(e.getValue());
        }
    }

    private final void $$robo$$android_os_Parcel$writeArrayMapInternal(ArrayMap<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    private final void $$robo$$android_os_Parcel$writeArrayMap(ArrayMap<String, Object> val) {
        this.writeArrayMapInternal(val);
    }

    private final void $$robo$$android_os_Parcel$writeArraySet(ArraySet<? extends Object> val) {
        int size = val != null ? val.size() : -1;
        this.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.writeValue(val.valueAt(i));
        }
    }

    private final void $$robo$$android_os_Parcel$writeBundle(Bundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    private final void $$robo$$android_os_Parcel$writePersistableBundle(PersistableBundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    private final void $$robo$$android_os_Parcel$writeSize(Size val) {
        this.writeInt(val.getWidth());
        this.writeInt(val.getHeight());
    }

    private final void $$robo$$android_os_Parcel$writeSizeF(SizeF val) {
        this.writeFloat(val.getWidth());
        this.writeFloat(val.getHeight());
    }

    private final void $$robo$$android_os_Parcel$writeList(List val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val.get(i));
        }
    }

    private final void $$robo$$android_os_Parcel$writeArray(Object[] val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.length;
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val[i]);
        }
    }

    private final void $$robo$$android_os_Parcel$writeSparseArray(SparseArray<Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    private final void $$robo$$android_os_Parcel$writeSparseBooleanArray(SparseBooleanArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeByte((byte)(val.valueAt(i) ? 1 : 0));
        }
    }

    private final void $$robo$$android_os_Parcel$writeSparseIntArray(SparseIntArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeInt(val.valueAt(i));
        }
    }

    private final void $$robo$$android_os_Parcel$writeBooleanArray(boolean[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i] ? 1 : 0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final boolean[] $$robo$$android_os_Parcel$createBooleanArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            boolean[] val = new boolean[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
            return val;
        }
        return null;
    }

    private final void $$robo$$android_os_Parcel$readBooleanArray(boolean[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    private final void $$robo$$android_os_Parcel$writeCharArray(char[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final char[] $$robo$$android_os_Parcel$createCharArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            char[] val = new char[N];
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
            return val;
        }
        return null;
    }

    private final void $$robo$$android_os_Parcel$readCharArray(char[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    private final void $$robo$$android_os_Parcel$writeIntArray(int[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final int[] $$robo$$android_os_Parcel$createIntArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            int[] val = new int[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
            return val;
        }
        return null;
    }

    private final void $$robo$$android_os_Parcel$readIntArray(int[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    private final void $$robo$$android_os_Parcel$writeLongArray(long[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeLong(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final long[] $$robo$$android_os_Parcel$createLongArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            long[] val = new long[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
            return val;
        }
        return null;
    }

    private final void $$robo$$android_os_Parcel$readLongArray(long[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    private final void $$robo$$android_os_Parcel$writeFloatArray(float[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeFloat(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final float[] $$robo$$android_os_Parcel$createFloatArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            float[] val = new float[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
            return val;
        }
        return null;
    }

    private final void $$robo$$android_os_Parcel$readFloatArray(float[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    private final void $$robo$$android_os_Parcel$writeDoubleArray(double[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeDouble(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final double[] $$robo$$android_os_Parcel$createDoubleArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            double[] val = new double[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
            return val;
        }
        return null;
    }

    private final void $$robo$$android_os_Parcel$readDoubleArray(double[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    private final void $$robo$$android_os_Parcel$writeStringArray(String[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeString(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final String[] $$robo$$android_os_Parcel$createStringArray() {
        int N = this.readInt();
        if (N >= 0) {
            String[] val = new String[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString();
            }
            return val;
        }
        return null;
    }

    private final void $$robo$$android_os_Parcel$readStringArray(String[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    private final void $$robo$$android_os_Parcel$writeBinderArray(IBinder[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeStrongBinder(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final void $$robo$$android_os_Parcel$writeCharSequenceArray(CharSequence[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final void $$robo$$android_os_Parcel$writeCharSequenceList(ArrayList<CharSequence> val) {
        if (val != null) {
            int N = val.size();
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val.get(i));
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final IBinder[] $$robo$$android_os_Parcel$createBinderArray() {
        int N = this.readInt();
        if (N >= 0) {
            IBinder[] val = new IBinder[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
            return val;
        }
        return null;
    }

    private final void $$robo$$android_os_Parcel$readBinderArray(IBinder[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    private final <T extends Parcelable> void $$robo$$android_os_Parcel$writeTypedList(List<T> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            Parcelable item = (Parcelable)val.get(i);
            if (item != null) {
                this.writeInt(1);
                item.writeToParcel(this, 0);
                continue;
            }
            this.writeInt(0);
        }
    }

    private final void $$robo$$android_os_Parcel$writeStringList(List<String> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.get(i));
        }
    }

    private final void $$robo$$android_os_Parcel$writeBinderList(List<IBinder> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeStrongBinder(val.get(i));
        }
    }

    private final <T extends Parcelable> void $$robo$$android_os_Parcel$writeParcelableList(List<T> val, int flags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeParcelable((Parcelable)val.get(i), flags);
        }
    }

    private final <T extends Parcelable> void $$robo$$android_os_Parcel$writeTypedArray(T[] val, int parcelableFlags) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                T item = val[i];
                if (item != null) {
                    this.writeInt(1);
                    item.writeToParcel(this, parcelableFlags);
                    continue;
                }
                this.writeInt(0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final <T extends Parcelable> void $$robo$$android_os_Parcel$writeTypedArrayList(ArrayList<T> list, int parcelableFlags) {
        if (list != null) {
            int N = list.size();
            this.writeInt(N);
            boolean wroteCreator = false;
            for (int i = 0; i < N; ++i) {
                Parcelable item = (Parcelable)list.get(i);
                if (item != null) {
                    this.writeInt(1);
                    if (!wroteCreator) {
                        this.writeParcelableCreator(item);
                        wroteCreator = true;
                    }
                    item.writeToParcel(this, parcelableFlags);
                    continue;
                }
                this.writeInt(0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final <T> ArrayList<T> $$robo$$android_os_Parcel$readTypedArrayList(ClassLoader loader) {
        int N = this.readInt();
        if (N <= 0) {
            return null;
        }
        Parcelable.Creator<?> creator = null;
        ArrayList result = new ArrayList(N);
        for (int i = 0; i < N; ++i) {
            if (this.readInt() != 0) {
                Object parcelable;
                if (creator == null && (creator = this.readParcelableCreator(loader)) == null) {
                    return null;
                }
                if (creator instanceof Parcelable.ClassLoaderCreator) {
                    Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
                    parcelable = classLoaderCreator.createFromParcel(this, loader);
                } else {
                    parcelable = creator.createFromParcel(this);
                }
                result.add(parcelable);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    private final <T extends Parcelable> void $$robo$$android_os_Parcel$writeTypedArraySet(ArraySet<T> set, int parcelableFlags) {
        if (set != null) {
            int N = set.size();
            this.writeInt(N);
            boolean wroteCreator = false;
            for (int i = 0; i < N; ++i) {
                Parcelable item = (Parcelable)set.valueAt(i);
                if (item != null) {
                    this.writeInt(1);
                    if (!wroteCreator) {
                        this.writeParcelableCreator(item);
                        wroteCreator = true;
                    }
                    item.writeToParcel(this, parcelableFlags);
                    continue;
                }
                this.writeInt(0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final <T> ArraySet<T> $$robo$$android_os_Parcel$readTypedArraySet(ClassLoader loader) {
        int N = this.readInt();
        if (N <= 0) {
            return null;
        }
        Parcelable.Creator<?> creator = null;
        ArraySet<Object> result = new ArraySet<Object>(N);
        for (int i = 0; i < N; ++i) {
            Object parcelable = null;
            if (this.readInt() != 0) {
                if (creator == null && (creator = this.readParcelableCreator(loader)) == null) {
                    return null;
                }
                if (creator instanceof Parcelable.ClassLoaderCreator) {
                    Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
                    parcelable = classLoaderCreator.createFromParcel(this, loader);
                } else {
                    parcelable = creator.createFromParcel(this);
                }
            }
            result.append(parcelable);
        }
        return result;
    }

    private final <T extends Parcelable> void $$robo$$android_os_Parcel$writeTypedObject(T val, int parcelableFlags) {
        if (val != null) {
            this.writeInt(1);
            val.writeToParcel(this, parcelableFlags);
        } else {
            this.writeInt(0);
        }
    }

    private final void $$robo$$android_os_Parcel$writeValue(Object v) {
        if (v == null) {
            this.writeInt(-1);
        } else if (v instanceof String) {
            this.writeInt(0);
            this.writeString((String)v);
        } else if (v instanceof Integer) {
            this.writeInt(1);
            this.writeInt((Integer)v);
        } else if (v instanceof Map) {
            this.writeInt(2);
            this.writeMap((Map)v);
        } else if (v instanceof Bundle) {
            this.writeInt(3);
            this.writeBundle((Bundle)v);
        } else if (v instanceof PersistableBundle) {
            this.writeInt(25);
            this.writePersistableBundle((PersistableBundle)v);
        } else if (v instanceof Parcelable) {
            this.writeInt(4);
            this.writeParcelable((Parcelable)v, 0);
        } else if (v instanceof Short) {
            this.writeInt(5);
            this.writeInt(((Short)v).intValue());
        } else if (v instanceof Long) {
            this.writeInt(6);
            this.writeLong((Long)v);
        } else if (v instanceof Float) {
            this.writeInt(7);
            this.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Double) {
            this.writeInt(8);
            this.writeDouble((Double)v);
        } else if (v instanceof Boolean) {
            this.writeInt(9);
            this.writeInt((Boolean)v != false ? 1 : 0);
        } else if (v instanceof CharSequence) {
            this.writeInt(10);
            this.writeCharSequence((CharSequence)v);
        } else if (v instanceof List) {
            this.writeInt(11);
            this.writeList((List)v);
        } else if (v instanceof SparseArray) {
            this.writeInt(12);
            this.writeSparseArray((SparseArray)v);
        } else if (v instanceof boolean[]) {
            this.writeInt(23);
            this.writeBooleanArray((boolean[])v);
        } else if (v instanceof byte[]) {
            this.writeInt(13);
            this.writeByteArray((byte[])v);
        } else if (v instanceof String[]) {
            this.writeInt(14);
            this.writeStringArray((String[])v);
        } else if (v instanceof CharSequence[]) {
            this.writeInt(24);
            this.writeCharSequenceArray((CharSequence[])v);
        } else if (v instanceof IBinder) {
            this.writeInt(15);
            this.writeStrongBinder((IBinder)v);
        } else if (v instanceof Parcelable[]) {
            this.writeInt(16);
            this.writeParcelableArray((Parcelable[])v, 0);
        } else if (v instanceof int[]) {
            this.writeInt(18);
            this.writeIntArray((int[])v);
        } else if (v instanceof long[]) {
            this.writeInt(19);
            this.writeLongArray((long[])v);
        } else if (v instanceof Byte) {
            this.writeInt(20);
            this.writeInt(((Byte)v).byteValue());
        } else if (v instanceof Size) {
            this.writeInt(26);
            this.writeSize((Size)v);
        } else if (v instanceof SizeF) {
            this.writeInt(27);
            this.writeSizeF((SizeF)v);
        } else if (v instanceof double[]) {
            this.writeInt(28);
            this.writeDoubleArray((double[])v);
        } else {
            Class<?> clazz = v.getClass();
            if (clazz.isArray() && clazz.getComponentType() == Object.class) {
                this.writeInt(17);
                this.writeArray((Object[])v);
            } else if (v instanceof Serializable) {
                this.writeInt(21);
                this.writeSerializable((Serializable)v);
            } else {
                throw new RuntimeException("Parcel: unable to marshal value " + v);
            }
        }
    }

    private final void $$robo$$android_os_Parcel$writeParcelable(Parcelable p, int parcelableFlags) {
        if (p == null) {
            this.writeString(null);
            return;
        }
        this.writeParcelableCreator(p);
        p.writeToParcel(this, parcelableFlags);
    }

    private final void $$robo$$android_os_Parcel$writeParcelableCreator(Parcelable p) {
        String name = p.getClass().getName();
        this.writeString(name);
    }

    private final void $$robo$$android_os_Parcel$writeSerializable(Serializable s) {
        if (s == null) {
            this.writeString(null);
            return;
        }
        String name = s.getClass().getName();
        this.writeString(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(s);
            oos.close();
            this.writeByteArray(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Parcelable encountered IOException writing serializable object (name = " + name + ")", ioe);
        }
    }

    private final void $$robo$$android_os_Parcel$writeException(Exception e) {
        int code = 0;
        if (e instanceof Parcelable && e.getClass().getClassLoader() == Parcelable.class.getClassLoader()) {
            code = -9;
        } else if (e instanceof SecurityException) {
            code = -1;
        } else if (e instanceof BadParcelableException) {
            code = -2;
        } else if (e instanceof IllegalArgumentException) {
            code = -3;
        } else if (e instanceof NullPointerException) {
            code = -4;
        } else if (e instanceof IllegalStateException) {
            code = -5;
        } else if (e instanceof NetworkOnMainThreadException) {
            code = -6;
        } else if (e instanceof UnsupportedOperationException) {
            code = -7;
        } else if (e instanceof ServiceSpecificException) {
            code = -8;
        }
        this.writeInt(code);
        StrictMode.clearGatheredViolations();
        if (code == 0) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.writeString(e.getMessage());
        switch (code) {
            case -8: {
                this.writeInt(((ServiceSpecificException)e).errorCode);
                break;
            }
            case -9: {
                int sizePosition = this.dataPosition();
                this.writeInt(0);
                this.writeParcelable((Parcelable)((Object)e), 1);
                int payloadPosition = this.dataPosition();
                this.setDataPosition(sizePosition);
                this.writeInt(payloadPosition - sizePosition);
                this.setDataPosition(payloadPosition);
            }
        }
    }

    private final void $$robo$$android_os_Parcel$writeNoException() {
        if (StrictMode.hasGatheredViolations()) {
            this.writeInt(-128);
            int sizePosition = this.dataPosition();
            this.writeInt(0);
            StrictMode.writeGatheredViolationsToParcel(this);
            int payloadPosition = this.dataPosition();
            this.setDataPosition(sizePosition);
            this.writeInt(payloadPosition - sizePosition);
            this.setDataPosition(payloadPosition);
        } else {
            this.writeInt(0);
        }
    }

    private final void $$robo$$android_os_Parcel$readException() {
        int code = this.readExceptionCode();
        if (code != 0) {
            String msg = this.readString();
            this.readException(code, msg);
        }
    }

    private final int $$robo$$android_os_Parcel$readExceptionCode() {
        int code = this.readInt();
        if (code == -128) {
            int headerSize = this.readInt();
            if (headerSize == 0) {
                Log.e("Parcel", "Unexpected zero-sized Parcel reply header.");
            } else {
                StrictMode.readAndHandleBinderCallViolations(this);
            }
            return 0;
        }
        return code;
    }

    private final void $$robo$$android_os_Parcel$readException(int code, String msg) {
        switch (code) {
            case -9: {
                if (this.readInt() > 0) {
                    SneakyThrow.sneakyThrow((Exception)this.readParcelable(Parcelable.class.getClassLoader()));
                } else {
                    throw new RuntimeException(msg + " [missing Parcelable]");
                }
            }
            case -1: {
                throw new SecurityException(msg);
            }
            case -2: {
                throw new BadParcelableException(msg);
            }
            case -3: {
                throw new IllegalArgumentException(msg);
            }
            case -4: {
                throw new NullPointerException(msg);
            }
            case -5: {
                throw new IllegalStateException(msg);
            }
            case -6: {
                throw new NetworkOnMainThreadException();
            }
            case -7: {
                throw new UnsupportedOperationException(msg);
            }
            case -8: {
                throw new ServiceSpecificException(this.readInt(), msg);
            }
        }
        throw new RuntimeException("Unknown exception code: " + code + " msg " + msg);
    }

    private final int $$robo$$android_os_Parcel$readInt() {
        return Parcel.nativeReadInt(this.mNativePtr);
    }

    private final long $$robo$$android_os_Parcel$readLong() {
        return Parcel.nativeReadLong(this.mNativePtr);
    }

    private final float $$robo$$android_os_Parcel$readFloat() {
        return Parcel.nativeReadFloat(this.mNativePtr);
    }

    private final double $$robo$$android_os_Parcel$readDouble() {
        return Parcel.nativeReadDouble(this.mNativePtr);
    }

    private final String $$robo$$android_os_Parcel$readString() {
        return Parcel.nativeReadString(this.mNativePtr);
    }

    private final boolean $$robo$$android_os_Parcel$readBoolean() {
        return this.readInt() != 0;
    }

    private final CharSequence $$robo$$android_os_Parcel$readCharSequence() {
        return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(this);
    }

    private final IBinder $$robo$$android_os_Parcel$readStrongBinder() {
        return Parcel.nativeReadStrongBinder(this.mNativePtr);
    }

    private final ParcelFileDescriptor $$robo$$android_os_Parcel$readFileDescriptor() {
        FileDescriptor fd = Parcel.nativeReadFileDescriptor(this.mNativePtr);
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    private final FileDescriptor $$robo$$android_os_Parcel$readRawFileDescriptor() {
        return Parcel.nativeReadFileDescriptor(this.mNativePtr);
    }

    private final FileDescriptor[] $$robo$$android_os_Parcel$createRawFileDescriptorArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        FileDescriptor[] f = new FileDescriptor[N];
        for (int i = 0; i < N; ++i) {
            f[i] = this.readRawFileDescriptor();
        }
        return f;
    }

    private final void $$robo$$android_os_Parcel$readRawFileDescriptorArray(FileDescriptor[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readRawFileDescriptor();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    @Deprecated
    private static final FileDescriptor $$robo$$android_os_Parcel$openFileDescriptor(String string2, int n) throws FileNotFoundException {
        return null;
    }

    @Deprecated
    private static final FileDescriptor $$robo$$android_os_Parcel$dupFileDescriptor(FileDescriptor fileDescriptor) throws IOException {
        return null;
    }

    @Deprecated
    private static final void $$robo$$android_os_Parcel$closeFileDescriptor(FileDescriptor fileDescriptor) throws IOException {
    }

    private static final void $$robo$$android_os_Parcel$clearFileDescriptor(FileDescriptor fileDescriptor) {
    }

    private final byte $$robo$$android_os_Parcel$readByte() {
        return (byte)(this.readInt() & 0xFF);
    }

    private final void $$robo$$android_os_Parcel$readMap(Map outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readMapInternal(outVal, N, loader);
    }

    private final void $$robo$$android_os_Parcel$readList(List outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readListInternal(outVal, N, loader);
    }

    private final HashMap $$robo$$android_os_Parcel$readHashMap(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        HashMap m = new HashMap(N);
        this.readMapInternal(m, N, loader);
        return m;
    }

    private final Bundle $$robo$$android_os_Parcel$readBundle() {
        return this.readBundle(null);
    }

    private final Bundle $$robo$$android_os_Parcel$readBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        Bundle bundle = new Bundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    private final PersistableBundle $$robo$$android_os_Parcel$readPersistableBundle() {
        return this.readPersistableBundle(null);
    }

    private final PersistableBundle $$robo$$android_os_Parcel$readPersistableBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        PersistableBundle bundle = new PersistableBundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    private final Size $$robo$$android_os_Parcel$readSize() {
        int width = this.readInt();
        int height = this.readInt();
        return new Size(width, height);
    }

    private final SizeF $$robo$$android_os_Parcel$readSizeF() {
        float width = this.readFloat();
        float height = this.readFloat();
        return new SizeF(width, height);
    }

    private final byte[] $$robo$$android_os_Parcel$createByteArray() {
        return Parcel.nativeCreateByteArray(this.mNativePtr);
    }

    private final void $$robo$$android_os_Parcel$readByteArray(byte[] val) {
        byte[] ba = this.createByteArray();
        if (ba.length != val.length) {
            throw new RuntimeException("bad array lengths");
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])ba, (int)0, (byte[])val, (int)0, (int)ba.length);
    }

    private final byte[] $$robo$$android_os_Parcel$readBlob() {
        return Parcel.nativeReadBlob(this.mNativePtr);
    }

    private final String[] $$robo$$android_os_Parcel$readStringArray() {
        String[] array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new String[length];
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readString();
            }
        }
        return array2;
    }

    private final CharSequence[] $$robo$$android_os_Parcel$readCharSequenceArray() {
        CharSequence[] array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new CharSequence[length];
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readCharSequence();
            }
        }
        return array2;
    }

    private final ArrayList<CharSequence> $$robo$$android_os_Parcel$readCharSequenceList() {
        ArrayList<CharSequence> array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new ArrayList<CharSequence>(length);
            for (int i = 0; i < length; ++i) {
                array2.add(this.readCharSequence());
            }
        }
        return array2;
    }

    private final ArrayList $$robo$$android_os_Parcel$readArrayList(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList l = new ArrayList(N);
        this.readListInternal(l, N, loader);
        return l;
    }

    private final Object[] $$robo$$android_os_Parcel$readArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Object[] l = new Object[N];
        this.readArrayInternal(l, N, loader);
        return l;
    }

    private final SparseArray $$robo$$android_os_Parcel$readSparseArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseArray sa = new SparseArray(N);
        this.readSparseArrayInternal(sa, N, loader);
        return sa;
    }

    private final SparseBooleanArray $$robo$$android_os_Parcel$readSparseBooleanArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseBooleanArray sa = new SparseBooleanArray(N);
        this.readSparseBooleanArrayInternal(sa, N);
        return sa;
    }

    private final SparseIntArray $$robo$$android_os_Parcel$readSparseIntArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseIntArray sa = new SparseIntArray(N);
        this.readSparseIntArrayInternal(sa, N);
        return sa;
    }

    private final <T> ArrayList<T> $$robo$$android_os_Parcel$createTypedArrayList(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(N);
        while (N > 0) {
            if (this.readInt() != 0) {
                l.add(c.createFromParcel(this));
            } else {
                l.add(null);
            }
            --N;
        }
        return l;
    }

    private final <T> void $$robo$$android_os_Parcel$readTypedList(List<T> list, Parcelable.Creator<T> c) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            if (this.readInt() != 0) {
                list.set(i, c.createFromParcel(this));
                continue;
            }
            list.set(i, null);
        }
        while (i < N) {
            if (this.readInt() != 0) {
                list.add(c.createFromParcel(this));
            } else {
                list.add(null);
            }
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    private final ArrayList<String> $$robo$$android_os_Parcel$createStringArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>(N);
        while (N > 0) {
            l.add(this.readString());
            --N;
        }
        return l;
    }

    private final ArrayList<IBinder> $$robo$$android_os_Parcel$createBinderArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<IBinder> l = new ArrayList<IBinder>(N);
        while (N > 0) {
            l.add(this.readStrongBinder());
            --N;
        }
        return l;
    }

    private final void $$robo$$android_os_Parcel$readStringList(List<String> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readString());
        }
        while (i < N) {
            list.add(this.readString());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    private final void $$robo$$android_os_Parcel$readBinderList(List<IBinder> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readStrongBinder());
        }
        while (i < N) {
            list.add(this.readStrongBinder());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    private final <T extends Parcelable> List<T> $$robo$$android_os_Parcel$readParcelableList(List<T> list, ClassLoader cl) {
        int i;
        int N = this.readInt();
        if (N == -1) {
            list.clear();
            return list;
        }
        int M = list.size();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readParcelable(cl));
        }
        while (i < N) {
            list.add(this.readParcelable(cl));
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
        return list;
    }

    private final <T> T[] $$robo$$android_os_Parcel$createTypedArray(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        T[] l = c.newArray(N);
        for (int i = 0; i < N; ++i) {
            if (this.readInt() == 0) continue;
            l[i] = c.createFromParcel(this);
        }
        return l;
    }

    private final <T> void $$robo$$android_os_Parcel$readTypedArray(T[] val, Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0 ? c.createFromParcel(this) : null;
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    @Deprecated
    private final <T> T[] $$robo$$android_os_Parcel$readTypedArray(Parcelable.Creator<T> c) {
        return this.createTypedArray(c);
    }

    private final <T> T $$robo$$android_os_Parcel$readTypedObject(Parcelable.Creator<T> c) {
        if (this.readInt() != 0) {
            return c.createFromParcel(this);
        }
        return null;
    }

    private final <T extends Parcelable> void $$robo$$android_os_Parcel$writeParcelableArray(T[] value, int parcelableFlags) {
        if (value != null) {
            int N = value.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeParcelable((Parcelable)value[i], parcelableFlags);
            }
        } else {
            this.writeInt(-1);
        }
    }

    private final Object $$robo$$android_os_Parcel$readValue(ClassLoader loader) {
        int type = this.readInt();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readHashMap(loader);
            }
            case 4: {
                return this.readParcelable(loader);
            }
            case 5: {
                return (short)this.readInt();
            }
            case 6: {
                return this.readLong();
            }
            case 7: {
                return Float.valueOf(this.readFloat());
            }
            case 8: {
                return this.readDouble();
            }
            case 9: {
                return this.readInt() == 1;
            }
            case 10: {
                return this.readCharSequence();
            }
            case 11: {
                return this.readArrayList(loader);
            }
            case 23: {
                return this.createBooleanArray();
            }
            case 13: {
                return this.createByteArray();
            }
            case 14: {
                return this.readStringArray();
            }
            case 24: {
                return this.readCharSequenceArray();
            }
            case 15: {
                return this.readStrongBinder();
            }
            case 17: {
                return this.readArray(loader);
            }
            case 18: {
                return this.createIntArray();
            }
            case 19: {
                return this.createLongArray();
            }
            case 20: {
                return this.readByte();
            }
            case 21: {
                return this.readSerializable(loader);
            }
            case 16: {
                return this.readParcelableArray(loader);
            }
            case 12: {
                return this.readSparseArray(loader);
            }
            case 22: {
                return this.readSparseBooleanArray();
            }
            case 3: {
                return this.readBundle(loader);
            }
            case 25: {
                return this.readPersistableBundle(loader);
            }
            case 26: {
                return this.readSize();
            }
            case 27: {
                return this.readSizeF();
            }
            case 28: {
                return this.createDoubleArray();
            }
        }
        int off = this.dataPosition() - 4;
        throw new RuntimeException("Parcel " + this + ": Unmarshalling unknown type code " + type + " at offset " + off);
    }

    private final <T extends Parcelable> T $$robo$$android_os_Parcel$readParcelable(ClassLoader loader) {
        Parcelable.Creator<?> creator = this.readParcelableCreator(loader);
        if (creator == null) {
            return null;
        }
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return (T)((Parcelable)classLoaderCreator.createFromParcel(this, loader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    private final <T extends Parcelable> T $$robo$$android_os_Parcel$readCreator(Parcelable.Creator<?> creator, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return (T)((Parcelable)classLoaderCreator.createFromParcel(this, loader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Parcelable.Creator<?> $$robo$$android_os_Parcel$readParcelableCreator(ClassLoader loader) {
        Parcelable.Creator creator;
        String name = this.readString();
        if (name == null) {
            return null;
        }
        HashMap<ClassLoader, HashMap<String, Parcelable.Creator<?>>> hashMap = mCreators;
        synchronized (hashMap) {
            HashMap<String, Parcelable.Creator<Object>> map = mCreators.get(loader);
            if (map == null) {
                map = new HashMap();
                mCreators.put(loader, map);
            }
            if ((creator = map.get(name)) == null) {
                try {
                    ClassLoader parcelableClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
                    Class<?> parcelableClass = Class.forName(name, false, parcelableClassLoader);
                    if (!Parcelable.class.isAssignableFrom(parcelableClass)) {
                        throw new BadParcelableException("Parcelable protocol requires that the class implements Parcelable");
                    }
                    Field f = parcelableClass.getField("CREATOR");
                    if ((f.getModifiers() & 8) == 0) {
                        throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + name);
                    }
                    Class<?> creatorType = f.getType();
                    if (!Parcelable.Creator.class.isAssignableFrom(creatorType)) {
                        throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
                    }
                    creator = (Parcelable.Creator)f.get(null);
                }
                catch (IllegalAccessException e) {
                    Log.e("Parcel", "Illegal access when unmarshalling: " + name, e);
                    throw new BadParcelableException("IllegalAccessException when unmarshalling: " + name);
                }
                catch (ClassNotFoundException e) {
                    Log.e("Parcel", "Class not found when unmarshalling: " + name, e);
                    throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + name);
                }
                catch (NoSuchFieldException e) {
                    throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
                }
                if (creator == null) {
                    throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + name);
                }
                map.put(name, creator);
            }
        }
        return creator;
    }

    private final Parcelable[] $$robo$$android_os_Parcel$readParcelableArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Parcelable[] p = new Parcelable[N];
        for (int i = 0; i < N; ++i) {
            p[i] = this.readParcelable(loader);
        }
        return p;
    }

    private final <T extends Parcelable> T[] $$robo$$android_os_Parcel$readParcelableArray(ClassLoader loader, Class<T> clazz) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Parcelable[] p = (Parcelable[])Array.newInstance(clazz, N);
        for (int i = 0; i < N; ++i) {
            p[i] = this.readParcelable(loader);
        }
        return p;
    }

    private final Serializable $$robo$$android_os_Parcel$readSerializable() {
        return this.readSerializable(null);
    }

    private final Serializable $$robo$$android_os_Parcel$readSerializable(ClassLoader loader) {
        String name = this.readString();
        if (name == null) {
            return null;
        }
        byte[] serializedData = this.createByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedData);
        try {
            ShadowedObject ois = new ShadowedObject(this, bais, loader){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ClassLoader val$loader;
                /* synthetic */ Parcel this$0;

                private void $$robo$$android_os_Parcel_2$__constructor__(Parcel this$0, InputStream x0, ClassLoader classLoader) {
                    this.val$loader = classLoader;
                }

                private final Class<?> $$robo$$android_os_Parcel_2$resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
                    Class<?> c;
                    if (this.val$loader != null && (c = Class.forName(osClass.getName(), false, this.val$loader)) != null) {
                        return c;
                    }
                    return super.resolveClass(osClass);
                }

                private void __constructor__(Parcel parcel, InputStream inputStream, ClassLoader classLoader) {
                    this.$$robo$$android_os_Parcel_2$__constructor__(parcel, inputStream, classLoader);
                }
                {
                    this.this$0 = parcel;
                    super(inputStream);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Parcel_2$__constructor__(android.os.Parcel java.io.InputStream java.lang.ClassLoader ), this, parcel, inputStream, classLoader);
                }

                @Override
                protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                    return InvokeDynamicSupport.bootstrap("resolveClass", $$robo$$android_os_Parcel_2$resolveClass(java.io.ObjectStreamClass ), this, objectStreamClass);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            return (Serializable)ois.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Parcelable encountered IOException reading a Serializable object (name = " + name + ")", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Parcelable encountered ClassNotFoundException reading a Serializable object (name = " + name + ")", cnfe);
        }
    }

    private static final Parcel $$robo$$android_os_Parcel$obtain(int obj) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Parcel $$robo$$android_os_Parcel$obtain(long obj) {
        Parcel[] pool;
        Parcel[] parcelArray = pool = sHolderPool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                Parcel p = pool[i];
                if (p == null) continue;
                pool[i] = null;
                p.init(obj);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return p;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return new Parcel(obj);
        }
    }

    private void $$robo$$android_os_Parcel$__constructor__(long nativePtr) {
        this.init(nativePtr);
    }

    private final void $$robo$$android_os_Parcel$init(long nativePtr) {
        if (nativePtr != 0L) {
            this.mNativePtr = nativePtr;
            this.mOwnsNativeParcelObject = false;
        } else {
            this.mNativePtr = Parcel.nativeCreate();
            this.mOwnsNativeParcelObject = true;
        }
    }

    private final void $$robo$$android_os_Parcel$freeBuffer() {
        if (this.mOwnsNativeParcelObject) {
            this.updateNativeSize(Parcel.nativeFreeBuffer(this.mNativePtr));
        }
    }

    private final void $$robo$$android_os_Parcel$destroy() {
        if (this.mNativePtr != 0L) {
            if (this.mOwnsNativeParcelObject) {
                Parcel.nativeDestroy(this.mNativePtr);
                this.updateNativeSize(0L);
            }
            this.mNativePtr = 0L;
        }
    }

    private final void $$robo$$android_os_Parcel$finalize() throws Throwable {
        this.destroy();
    }

    private final void $$robo$$android_os_Parcel$readMapInternal(Map outVal, int N, ClassLoader loader) {
        while (N > 0) {
            Object key = this.readValue(loader);
            Object value = this.readValue(loader);
            outVal.put(key, value);
            --N;
        }
    }

    private final void $$robo$$android_os_Parcel$readArrayMapInternal(ArrayMap outVal, int N, ClassLoader loader) {
        while (N > 0) {
            String key = this.readString();
            Object value = this.readValue(loader);
            outVal.append(key, value);
            --N;
        }
        outVal.validate();
    }

    private final void $$robo$$android_os_Parcel$readArrayMapSafelyInternal(ArrayMap outVal, int N, ClassLoader loader) {
        while (N > 0) {
            String key = this.readString();
            Object value = this.readValue(loader);
            outVal.put(key, value);
            --N;
        }
    }

    private final void $$robo$$android_os_Parcel$readArrayMap(ArrayMap outVal, ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return;
        }
        this.readArrayMapInternal(outVal, N, loader);
    }

    private final ArraySet<? extends Object> $$robo$$android_os_Parcel$readArraySet(ClassLoader loader) {
        int size = this.readInt();
        if (size < 0) {
            return null;
        }
        ArraySet<Object> result = new ArraySet<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object value = this.readValue(loader);
            result.append(value);
        }
        return result;
    }

    private final void $$robo$$android_os_Parcel$readListInternal(List outVal, int N, ClassLoader loader) {
        while (N > 0) {
            Object value = this.readValue(loader);
            outVal.add(value);
            --N;
        }
    }

    private final void $$robo$$android_os_Parcel$readArrayInternal(Object[] outVal, int N, ClassLoader loader) {
        for (int i = 0; i < N; ++i) {
            Object value;
            outVal[i] = value = this.readValue(loader);
        }
    }

    private final void $$robo$$android_os_Parcel$readSparseArrayInternal(SparseArray outVal, int N, ClassLoader loader) {
        while (N > 0) {
            int key = this.readInt();
            Object value = this.readValue(loader);
            outVal.append(key, value);
            --N;
        }
    }

    private final void $$robo$$android_os_Parcel$readSparseBooleanArrayInternal(SparseBooleanArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            boolean value = this.readByte() == 1;
            outVal.append(key, value);
            --N;
        }
    }

    private final void $$robo$$android_os_Parcel$readSparseIntArrayInternal(SparseIntArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            int value = this.readInt();
            outVal.append(key, value);
            --N;
        }
    }

    private final long $$robo$$android_os_Parcel$getBlobAshmemSize() {
        return Parcel.nativeGetBlobAshmemSize(this.mNativePtr);
    }

    static void __staticInitializer__() {
        sOwnedPool = new Parcel[6];
        sHolderPool = new Parcel[6];
        STRING_CREATOR = new Parcelable.Creator<String>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_Parcel_1$__constructor__() {
            }

            private final String $$robo$$android_os_Parcel_1$createFromParcel(Parcel source) {
                return source.readString();
            }

            private final String[] $$robo$$android_os_Parcel_1$newArray(int size) {
                return new String[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_Parcel_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Parcel_1$__constructor__(), this);
            }

            @Override
            public String createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_Parcel_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public String[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_Parcel_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        mCreators = new HashMap();
    }

    private static int nativeDataSize(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDataSize", $$robo$$android_os_Parcel$nativeDataSize(long ), (long)l);
    }

    private static int nativeDataAvail(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDataAvail", $$robo$$android_os_Parcel$nativeDataAvail(long ), (long)l);
    }

    private static int nativeDataPosition(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDataPosition", $$robo$$android_os_Parcel$nativeDataPosition(long ), (long)l);
    }

    private static int nativeDataCapacity(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDataCapacity", $$robo$$android_os_Parcel$nativeDataCapacity(long ), (long)l);
    }

    private static long nativeSetDataSize(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeSetDataSize", $$robo$$android_os_Parcel$nativeSetDataSize(long int ), (long)l, (int)n);
    }

    private static void nativeSetDataPosition(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetDataPosition", $$robo$$android_os_Parcel$nativeSetDataPosition(long int ), (long)l, (int)n);
    }

    private static void nativeSetDataCapacity(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetDataCapacity", $$robo$$android_os_Parcel$nativeSetDataCapacity(long int ), (long)l, (int)n);
    }

    private static boolean nativePushAllowFds(long l, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativePushAllowFds", $$robo$$android_os_Parcel$nativePushAllowFds(long boolean ), (long)l, (boolean)bl);
    }

    private static void nativeRestoreAllowFds(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeRestoreAllowFds", $$robo$$android_os_Parcel$nativeRestoreAllowFds(long boolean ), (long)l, (boolean)bl);
    }

    private static void nativeWriteByteArray(long l, byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteByteArray", $$robo$$android_os_Parcel$nativeWriteByteArray(long byte[] int int ), (long)l, (byte[])byArray, (int)n, (int)n2);
    }

    private static void nativeWriteBlob(long l, byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteBlob", $$robo$$android_os_Parcel$nativeWriteBlob(long byte[] int int ), (long)l, (byte[])byArray, (int)n, (int)n2);
    }

    private static void nativeWriteInt(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteInt", $$robo$$android_os_Parcel$nativeWriteInt(long int ), (long)l, (int)n);
    }

    private static void nativeWriteLong(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteLong", $$robo$$android_os_Parcel$nativeWriteLong(long long ), (long)l, (long)l2);
    }

    private static void nativeWriteFloat(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteFloat", $$robo$$android_os_Parcel$nativeWriteFloat(long float ), (long)l, (float)f);
    }

    private static void nativeWriteDouble(long l, double d) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteDouble", $$robo$$android_os_Parcel$nativeWriteDouble(long double ), (long)l, (double)d);
    }

    private static void nativeWriteString(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteString", $$robo$$android_os_Parcel$nativeWriteString(long java.lang.String ), (long)l, (String)string2);
    }

    private static void nativeWriteStrongBinder(long l, IBinder iBinder) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteStrongBinder", $$robo$$android_os_Parcel$nativeWriteStrongBinder(long android.os.IBinder ), (long)l, (IBinder)iBinder);
    }

    private static long nativeWriteFileDescriptor(long l, FileDescriptor fileDescriptor) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeWriteFileDescriptor", $$robo$$android_os_Parcel$nativeWriteFileDescriptor(long java.io.FileDescriptor ), (long)l, (FileDescriptor)fileDescriptor);
    }

    private static byte[] nativeCreateByteArray(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreateByteArray", $$robo$$android_os_Parcel$nativeCreateByteArray(long ), (long)l);
    }

    private static byte[] nativeReadBlob(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeReadBlob", $$robo$$android_os_Parcel$nativeReadBlob(long ), (long)l);
    }

    private static int nativeReadInt(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeReadInt", $$robo$$android_os_Parcel$nativeReadInt(long ), (long)l);
    }

    private static long nativeReadLong(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeReadLong", $$robo$$android_os_Parcel$nativeReadLong(long ), (long)l);
    }

    private static float nativeReadFloat(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nativeReadFloat", $$robo$$android_os_Parcel$nativeReadFloat(long ), (long)l);
    }

    private static double nativeReadDouble(long l) {
        return (double)InvokeDynamicSupport.bootstrapStatic("nativeReadDouble", $$robo$$android_os_Parcel$nativeReadDouble(long ), (long)l);
    }

    private static String nativeReadString(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeReadString", $$robo$$android_os_Parcel$nativeReadString(long ), (long)l);
    }

    private static IBinder nativeReadStrongBinder(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeReadStrongBinder", $$robo$$android_os_Parcel$nativeReadStrongBinder(long ), (long)l);
    }

    private static FileDescriptor nativeReadFileDescriptor(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeReadFileDescriptor", $$robo$$android_os_Parcel$nativeReadFileDescriptor(long ), (long)l);
    }

    private static long nativeCreate() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreate", $$robo$$android_os_Parcel$nativeCreate());
    }

    private static long nativeFreeBuffer(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeFreeBuffer", $$robo$$android_os_Parcel$nativeFreeBuffer(long ), (long)l);
    }

    private static void nativeDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDestroy", $$robo$$android_os_Parcel$nativeDestroy(long ), (long)l);
    }

    private static byte[] nativeMarshall(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeMarshall", $$robo$$android_os_Parcel$nativeMarshall(long ), (long)l);
    }

    private static long nativeUnmarshall(long l, byte[] byArray, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeUnmarshall", $$robo$$android_os_Parcel$nativeUnmarshall(long byte[] int int ), (long)l, (byte[])byArray, (int)n, (int)n2);
    }

    private static int nativeCompareData(long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeCompareData", $$robo$$android_os_Parcel$nativeCompareData(long long ), (long)l, (long)l2);
    }

    private static long nativeAppendFrom(long l, long l2, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeAppendFrom", $$robo$$android_os_Parcel$nativeAppendFrom(long long int int ), (long)l, (long)l2, (int)n, (int)n2);
    }

    private static boolean nativeHasFileDescriptors(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeHasFileDescriptors", $$robo$$android_os_Parcel$nativeHasFileDescriptors(long ), (long)l);
    }

    private static void nativeWriteInterfaceToken(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteInterfaceToken", $$robo$$android_os_Parcel$nativeWriteInterfaceToken(long java.lang.String ), (long)l, (String)string2);
    }

    private static void nativeEnforceInterface(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("nativeEnforceInterface", $$robo$$android_os_Parcel$nativeEnforceInterface(long java.lang.String ), (long)l, (String)string2);
    }

    private static long nativeGetBlobAshmemSize(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetBlobAshmemSize", $$robo$$android_os_Parcel$nativeGetBlobAshmemSize(long ), (long)l);
    }

    public static Parcel obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_os_Parcel$obtain());
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_os_Parcel$recycle(), this);
    }

    public static long getGlobalAllocSize() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getGlobalAllocSize", $$robo$$android_os_Parcel$getGlobalAllocSize());
    }

    public static long getGlobalAllocCount() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getGlobalAllocCount", $$robo$$android_os_Parcel$getGlobalAllocCount());
    }

    public int dataSize() {
        return (int)InvokeDynamicSupport.bootstrap("dataSize", $$robo$$android_os_Parcel$dataSize(), this);
    }

    public int dataAvail() {
        return (int)InvokeDynamicSupport.bootstrap("dataAvail", $$robo$$android_os_Parcel$dataAvail(), this);
    }

    public int dataPosition() {
        return (int)InvokeDynamicSupport.bootstrap("dataPosition", $$robo$$android_os_Parcel$dataPosition(), this);
    }

    public int dataCapacity() {
        return (int)InvokeDynamicSupport.bootstrap("dataCapacity", $$robo$$android_os_Parcel$dataCapacity(), this);
    }

    public void setDataSize(int n) {
        InvokeDynamicSupport.bootstrap("setDataSize", $$robo$$android_os_Parcel$setDataSize(int ), this, n);
    }

    public void setDataPosition(int n) {
        InvokeDynamicSupport.bootstrap("setDataPosition", $$robo$$android_os_Parcel$setDataPosition(int ), this, n);
    }

    public void setDataCapacity(int n) {
        InvokeDynamicSupport.bootstrap("setDataCapacity", $$robo$$android_os_Parcel$setDataCapacity(int ), this, n);
    }

    public boolean pushAllowFds(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("pushAllowFds", $$robo$$android_os_Parcel$pushAllowFds(boolean ), this, bl);
    }

    public void restoreAllowFds(boolean bl) {
        InvokeDynamicSupport.bootstrap("restoreAllowFds", $$robo$$android_os_Parcel$restoreAllowFds(boolean ), this, bl);
    }

    public byte[] marshall() {
        return InvokeDynamicSupport.bootstrap("marshall", $$robo$$android_os_Parcel$marshall(), this);
    }

    public void unmarshall(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("unmarshall", $$robo$$android_os_Parcel$unmarshall(byte[] int int ), this, byArray, n, n2);
    }

    public void appendFrom(Parcel parcel, int n, int n2) {
        InvokeDynamicSupport.bootstrap("appendFrom", $$robo$$android_os_Parcel$appendFrom(android.os.Parcel int int ), this, parcel, n, n2);
    }

    public int compareData(Parcel parcel) {
        return (int)InvokeDynamicSupport.bootstrap("compareData", $$robo$$android_os_Parcel$compareData(android.os.Parcel ), this, parcel);
    }

    public void setClassCookie(Class clazz, Object object) {
        InvokeDynamicSupport.bootstrap("setClassCookie", $$robo$$android_os_Parcel$setClassCookie(java.lang.Class java.lang.Object ), this, clazz, object);
    }

    public Object getClassCookie(Class clazz) {
        return InvokeDynamicSupport.bootstrap("getClassCookie", $$robo$$android_os_Parcel$getClassCookie(java.lang.Class ), this, clazz);
    }

    public void adoptClassCookies(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("adoptClassCookies", $$robo$$android_os_Parcel$adoptClassCookies(android.os.Parcel ), this, parcel);
    }

    public boolean hasFileDescriptors() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFileDescriptors", $$robo$$android_os_Parcel$hasFileDescriptors(), this);
    }

    public void writeInterfaceToken(String string2) {
        InvokeDynamicSupport.bootstrap("writeInterfaceToken", $$robo$$android_os_Parcel$writeInterfaceToken(java.lang.String ), this, string2);
    }

    public void enforceInterface(String string2) {
        InvokeDynamicSupport.bootstrap("enforceInterface", $$robo$$android_os_Parcel$enforceInterface(java.lang.String ), this, string2);
    }

    public void writeByteArray(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("writeByteArray", $$robo$$android_os_Parcel$writeByteArray(byte[] ), this, byArray);
    }

    public void writeByteArray(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeByteArray", $$robo$$android_os_Parcel$writeByteArray(byte[] int int ), this, byArray, n, n2);
    }

    public void writeBlob(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("writeBlob", $$robo$$android_os_Parcel$writeBlob(byte[] ), this, byArray);
    }

    public void writeBlob(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeBlob", $$robo$$android_os_Parcel$writeBlob(byte[] int int ), this, byArray, n, n2);
    }

    public void writeInt(int n) {
        InvokeDynamicSupport.bootstrap("writeInt", $$robo$$android_os_Parcel$writeInt(int ), this, n);
    }

    public void writeLong(long l) {
        InvokeDynamicSupport.bootstrap("writeLong", $$robo$$android_os_Parcel$writeLong(long ), this, l);
    }

    public void writeFloat(float f) {
        InvokeDynamicSupport.bootstrap("writeFloat", $$robo$$android_os_Parcel$writeFloat(float ), this, f);
    }

    public void writeDouble(double d) {
        InvokeDynamicSupport.bootstrap("writeDouble", $$robo$$android_os_Parcel$writeDouble(double ), this, d);
    }

    public void writeString(String string2) {
        InvokeDynamicSupport.bootstrap("writeString", $$robo$$android_os_Parcel$writeString(java.lang.String ), this, string2);
    }

    public void writeBoolean(boolean bl) {
        InvokeDynamicSupport.bootstrap("writeBoolean", $$robo$$android_os_Parcel$writeBoolean(boolean ), this, bl);
    }

    public void writeCharSequence(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("writeCharSequence", $$robo$$android_os_Parcel$writeCharSequence(java.lang.CharSequence ), this, charSequence);
    }

    public void writeStrongBinder(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("writeStrongBinder", $$robo$$android_os_Parcel$writeStrongBinder(android.os.IBinder ), this, iBinder);
    }

    public void writeStrongInterface(IInterface iInterface) {
        InvokeDynamicSupport.bootstrap("writeStrongInterface", $$robo$$android_os_Parcel$writeStrongInterface(android.os.IInterface ), this, iInterface);
    }

    public void writeFileDescriptor(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrap("writeFileDescriptor", $$robo$$android_os_Parcel$writeFileDescriptor(java.io.FileDescriptor ), this, fileDescriptor);
    }

    private void updateNativeSize(long l) {
        InvokeDynamicSupport.bootstrap("updateNativeSize", $$robo$$android_os_Parcel$updateNativeSize(long ), this, l);
    }

    public void writeRawFileDescriptor(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrap("writeRawFileDescriptor", $$robo$$android_os_Parcel$writeRawFileDescriptor(java.io.FileDescriptor ), this, fileDescriptor);
    }

    public void writeRawFileDescriptorArray(FileDescriptor[] fileDescriptorArray) {
        InvokeDynamicSupport.bootstrap("writeRawFileDescriptorArray", $$robo$$android_os_Parcel$writeRawFileDescriptorArray(java.io.FileDescriptor[] ), this, fileDescriptorArray);
    }

    public void writeByte(byte by) {
        InvokeDynamicSupport.bootstrap("writeByte", $$robo$$android_os_Parcel$writeByte(byte ), this, by);
    }

    public void writeMap(Map map) {
        InvokeDynamicSupport.bootstrap("writeMap", $$robo$$android_os_Parcel$writeMap(java.util.Map ), this, map);
    }

    void writeMapInternal(Map<String, Object> map) {
        InvokeDynamicSupport.bootstrap("writeMapInternal", $$robo$$android_os_Parcel$writeMapInternal(java.util.Map<java.lang.String, java.lang.Object> ), this, map);
    }

    void writeArrayMapInternal(ArrayMap<String, Object> arrayMap) {
        InvokeDynamicSupport.bootstrap("writeArrayMapInternal", $$robo$$android_os_Parcel$writeArrayMapInternal(android.util.ArrayMap<java.lang.String, java.lang.Object> ), this, arrayMap);
    }

    public void writeArrayMap(ArrayMap<String, Object> arrayMap) {
        InvokeDynamicSupport.bootstrap("writeArrayMap", $$robo$$android_os_Parcel$writeArrayMap(android.util.ArrayMap<java.lang.String, java.lang.Object> ), this, arrayMap);
    }

    public void writeArraySet(ArraySet<? extends Object> arraySet) {
        InvokeDynamicSupport.bootstrap("writeArraySet", $$robo$$android_os_Parcel$writeArraySet(android.util.ArraySet<? extends java.lang.Object> ), this, arraySet);
    }

    public void writeBundle(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("writeBundle", $$robo$$android_os_Parcel$writeBundle(android.os.Bundle ), this, bundle);
    }

    public void writePersistableBundle(PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("writePersistableBundle", $$robo$$android_os_Parcel$writePersistableBundle(android.os.PersistableBundle ), this, persistableBundle);
    }

    public void writeSize(Size size) {
        InvokeDynamicSupport.bootstrap("writeSize", $$robo$$android_os_Parcel$writeSize(android.util.Size ), this, size);
    }

    public void writeSizeF(SizeF sizeF) {
        InvokeDynamicSupport.bootstrap("writeSizeF", $$robo$$android_os_Parcel$writeSizeF(android.util.SizeF ), this, sizeF);
    }

    public void writeList(List list) {
        InvokeDynamicSupport.bootstrap("writeList", $$robo$$android_os_Parcel$writeList(java.util.List ), this, list);
    }

    public void writeArray(Object[] objectArray) {
        InvokeDynamicSupport.bootstrap("writeArray", $$robo$$android_os_Parcel$writeArray(java.lang.Object[] ), this, objectArray);
    }

    public void writeSparseArray(SparseArray<Object> sparseArray) {
        InvokeDynamicSupport.bootstrap("writeSparseArray", $$robo$$android_os_Parcel$writeSparseArray(android.util.SparseArray<java.lang.Object> ), this, sparseArray);
    }

    public void writeSparseBooleanArray(SparseBooleanArray sparseBooleanArray) {
        InvokeDynamicSupport.bootstrap("writeSparseBooleanArray", $$robo$$android_os_Parcel$writeSparseBooleanArray(android.util.SparseBooleanArray ), this, sparseBooleanArray);
    }

    public void writeSparseIntArray(SparseIntArray sparseIntArray) {
        InvokeDynamicSupport.bootstrap("writeSparseIntArray", $$robo$$android_os_Parcel$writeSparseIntArray(android.util.SparseIntArray ), this, sparseIntArray);
    }

    public void writeBooleanArray(boolean[] blArray) {
        InvokeDynamicSupport.bootstrap("writeBooleanArray", $$robo$$android_os_Parcel$writeBooleanArray(boolean[] ), this, blArray);
    }

    public boolean[] createBooleanArray() {
        return InvokeDynamicSupport.bootstrap("createBooleanArray", $$robo$$android_os_Parcel$createBooleanArray(), this);
    }

    public void readBooleanArray(boolean[] blArray) {
        InvokeDynamicSupport.bootstrap("readBooleanArray", $$robo$$android_os_Parcel$readBooleanArray(boolean[] ), this, blArray);
    }

    public void writeCharArray(char[] cArray) {
        InvokeDynamicSupport.bootstrap("writeCharArray", $$robo$$android_os_Parcel$writeCharArray(char[] ), this, cArray);
    }

    public char[] createCharArray() {
        return InvokeDynamicSupport.bootstrap("createCharArray", $$robo$$android_os_Parcel$createCharArray(), this);
    }

    public void readCharArray(char[] cArray) {
        InvokeDynamicSupport.bootstrap("readCharArray", $$robo$$android_os_Parcel$readCharArray(char[] ), this, cArray);
    }

    public void writeIntArray(int[] nArray) {
        InvokeDynamicSupport.bootstrap("writeIntArray", $$robo$$android_os_Parcel$writeIntArray(int[] ), this, nArray);
    }

    public int[] createIntArray() {
        return InvokeDynamicSupport.bootstrap("createIntArray", $$robo$$android_os_Parcel$createIntArray(), this);
    }

    public void readIntArray(int[] nArray) {
        InvokeDynamicSupport.bootstrap("readIntArray", $$robo$$android_os_Parcel$readIntArray(int[] ), this, nArray);
    }

    public void writeLongArray(long[] lArray) {
        InvokeDynamicSupport.bootstrap("writeLongArray", $$robo$$android_os_Parcel$writeLongArray(long[] ), this, lArray);
    }

    public long[] createLongArray() {
        return InvokeDynamicSupport.bootstrap("createLongArray", $$robo$$android_os_Parcel$createLongArray(), this);
    }

    public void readLongArray(long[] lArray) {
        InvokeDynamicSupport.bootstrap("readLongArray", $$robo$$android_os_Parcel$readLongArray(long[] ), this, lArray);
    }

    public void writeFloatArray(float[] fArray) {
        InvokeDynamicSupport.bootstrap("writeFloatArray", $$robo$$android_os_Parcel$writeFloatArray(float[] ), this, fArray);
    }

    public float[] createFloatArray() {
        return InvokeDynamicSupport.bootstrap("createFloatArray", $$robo$$android_os_Parcel$createFloatArray(), this);
    }

    public void readFloatArray(float[] fArray) {
        InvokeDynamicSupport.bootstrap("readFloatArray", $$robo$$android_os_Parcel$readFloatArray(float[] ), this, fArray);
    }

    public void writeDoubleArray(double[] dArray) {
        InvokeDynamicSupport.bootstrap("writeDoubleArray", $$robo$$android_os_Parcel$writeDoubleArray(double[] ), this, dArray);
    }

    public double[] createDoubleArray() {
        return InvokeDynamicSupport.bootstrap("createDoubleArray", $$robo$$android_os_Parcel$createDoubleArray(), this);
    }

    public void readDoubleArray(double[] dArray) {
        InvokeDynamicSupport.bootstrap("readDoubleArray", $$robo$$android_os_Parcel$readDoubleArray(double[] ), this, dArray);
    }

    public void writeStringArray(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("writeStringArray", $$robo$$android_os_Parcel$writeStringArray(java.lang.String[] ), this, stringArray);
    }

    public String[] createStringArray() {
        return InvokeDynamicSupport.bootstrap("createStringArray", $$robo$$android_os_Parcel$createStringArray(), this);
    }

    public void readStringArray(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("readStringArray", $$robo$$android_os_Parcel$readStringArray(java.lang.String[] ), this, stringArray);
    }

    public void writeBinderArray(IBinder[] iBinderArray) {
        InvokeDynamicSupport.bootstrap("writeBinderArray", $$robo$$android_os_Parcel$writeBinderArray(android.os.IBinder[] ), this, iBinderArray);
    }

    public void writeCharSequenceArray(CharSequence[] charSequenceArray) {
        InvokeDynamicSupport.bootstrap("writeCharSequenceArray", $$robo$$android_os_Parcel$writeCharSequenceArray(java.lang.CharSequence[] ), this, charSequenceArray);
    }

    public void writeCharSequenceList(ArrayList<CharSequence> arrayList) {
        InvokeDynamicSupport.bootstrap("writeCharSequenceList", $$robo$$android_os_Parcel$writeCharSequenceList(java.util.ArrayList<java.lang.CharSequence> ), this, arrayList);
    }

    public IBinder[] createBinderArray() {
        return InvokeDynamicSupport.bootstrap("createBinderArray", $$robo$$android_os_Parcel$createBinderArray(), this);
    }

    public void readBinderArray(IBinder[] iBinderArray) {
        InvokeDynamicSupport.bootstrap("readBinderArray", $$robo$$android_os_Parcel$readBinderArray(android.os.IBinder[] ), this, iBinderArray);
    }

    public <T extends Parcelable> void writeTypedList(List<T> list) {
        InvokeDynamicSupport.bootstrap("writeTypedList", $$robo$$android_os_Parcel$writeTypedList(java.util.List<T> ), this, list);
    }

    public void writeStringList(List<String> list) {
        InvokeDynamicSupport.bootstrap("writeStringList", $$robo$$android_os_Parcel$writeStringList(java.util.List<java.lang.String> ), this, list);
    }

    public void writeBinderList(List<IBinder> list) {
        InvokeDynamicSupport.bootstrap("writeBinderList", $$robo$$android_os_Parcel$writeBinderList(java.util.List<android.os.IBinder> ), this, list);
    }

    public <T extends Parcelable> void writeParcelableList(List<T> list, int n) {
        InvokeDynamicSupport.bootstrap("writeParcelableList", $$robo$$android_os_Parcel$writeParcelableList(java.util.List<T> int ), this, list, n);
    }

    public <T extends Parcelable> void writeTypedArray(T[] TArray, int n) {
        InvokeDynamicSupport.bootstrap("writeTypedArray", $$robo$$android_os_Parcel$writeTypedArray(android.os.Parcelable[] int ), this, TArray, n);
    }

    public <T extends Parcelable> void writeTypedArrayList(ArrayList<T> arrayList, int n) {
        InvokeDynamicSupport.bootstrap("writeTypedArrayList", $$robo$$android_os_Parcel$writeTypedArrayList(java.util.ArrayList<T> int ), this, arrayList, n);
    }

    public <T> ArrayList<T> readTypedArrayList(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readTypedArrayList", $$robo$$android_os_Parcel$readTypedArrayList(java.lang.ClassLoader ), this, classLoader);
    }

    public <T extends Parcelable> void writeTypedArraySet(ArraySet<T> arraySet, int n) {
        InvokeDynamicSupport.bootstrap("writeTypedArraySet", $$robo$$android_os_Parcel$writeTypedArraySet(android.util.ArraySet<T> int ), this, arraySet, n);
    }

    public <T> ArraySet<T> readTypedArraySet(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readTypedArraySet", $$robo$$android_os_Parcel$readTypedArraySet(java.lang.ClassLoader ), this, classLoader);
    }

    public <T extends Parcelable> void writeTypedObject(T t, int n) {
        InvokeDynamicSupport.bootstrap("writeTypedObject", $$robo$$android_os_Parcel$writeTypedObject(T int ), this, t, n);
    }

    public void writeValue(Object object) {
        InvokeDynamicSupport.bootstrap("writeValue", $$robo$$android_os_Parcel$writeValue(java.lang.Object ), this, object);
    }

    public void writeParcelable(Parcelable parcelable, int n) {
        InvokeDynamicSupport.bootstrap("writeParcelable", $$robo$$android_os_Parcel$writeParcelable(android.os.Parcelable int ), this, parcelable, n);
    }

    public void writeParcelableCreator(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("writeParcelableCreator", $$robo$$android_os_Parcel$writeParcelableCreator(android.os.Parcelable ), this, parcelable);
    }

    public void writeSerializable(Serializable serializable) {
        InvokeDynamicSupport.bootstrap("writeSerializable", $$robo$$android_os_Parcel$writeSerializable(java.io.Serializable ), this, serializable);
    }

    public void writeException(Exception exception) {
        InvokeDynamicSupport.bootstrap("writeException", $$robo$$android_os_Parcel$writeException(java.lang.Exception ), this, exception);
    }

    public void writeNoException() {
        InvokeDynamicSupport.bootstrap("writeNoException", $$robo$$android_os_Parcel$writeNoException(), this);
    }

    public void readException() {
        InvokeDynamicSupport.bootstrap("readException", $$robo$$android_os_Parcel$readException(), this);
    }

    public int readExceptionCode() {
        return (int)InvokeDynamicSupport.bootstrap("readExceptionCode", $$robo$$android_os_Parcel$readExceptionCode(), this);
    }

    public void readException(int n, String string2) {
        InvokeDynamicSupport.bootstrap("readException", $$robo$$android_os_Parcel$readException(int java.lang.String ), this, n, string2);
    }

    public int readInt() {
        return (int)InvokeDynamicSupport.bootstrap("readInt", $$robo$$android_os_Parcel$readInt(), this);
    }

    public long readLong() {
        return (long)InvokeDynamicSupport.bootstrap("readLong", $$robo$$android_os_Parcel$readLong(), this);
    }

    public float readFloat() {
        return (float)InvokeDynamicSupport.bootstrap("readFloat", $$robo$$android_os_Parcel$readFloat(), this);
    }

    public double readDouble() {
        return (double)InvokeDynamicSupport.bootstrap("readDouble", $$robo$$android_os_Parcel$readDouble(), this);
    }

    public String readString() {
        return InvokeDynamicSupport.bootstrap("readString", $$robo$$android_os_Parcel$readString(), this);
    }

    public boolean readBoolean() {
        return (boolean)InvokeDynamicSupport.bootstrap("readBoolean", $$robo$$android_os_Parcel$readBoolean(), this);
    }

    public CharSequence readCharSequence() {
        return InvokeDynamicSupport.bootstrap("readCharSequence", $$robo$$android_os_Parcel$readCharSequence(), this);
    }

    public IBinder readStrongBinder() {
        return InvokeDynamicSupport.bootstrap("readStrongBinder", $$robo$$android_os_Parcel$readStrongBinder(), this);
    }

    public ParcelFileDescriptor readFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("readFileDescriptor", $$robo$$android_os_Parcel$readFileDescriptor(), this);
    }

    public FileDescriptor readRawFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("readRawFileDescriptor", $$robo$$android_os_Parcel$readRawFileDescriptor(), this);
    }

    public FileDescriptor[] createRawFileDescriptorArray() {
        return InvokeDynamicSupport.bootstrap("createRawFileDescriptorArray", $$robo$$android_os_Parcel$createRawFileDescriptorArray(), this);
    }

    public void readRawFileDescriptorArray(FileDescriptor[] fileDescriptorArray) {
        InvokeDynamicSupport.bootstrap("readRawFileDescriptorArray", $$robo$$android_os_Parcel$readRawFileDescriptorArray(java.io.FileDescriptor[] ), this, fileDescriptorArray);
    }

    @Deprecated
    static FileDescriptor openFileDescriptor(String string2, int n) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("openFileDescriptor", $$robo$$android_os_Parcel$openFileDescriptor(java.lang.String int ), (String)string2, (int)n);
    }

    @Deprecated
    static FileDescriptor dupFileDescriptor(FileDescriptor fileDescriptor) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("dupFileDescriptor", $$robo$$android_os_Parcel$dupFileDescriptor(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    @Deprecated
    static void closeFileDescriptor(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("closeFileDescriptor", $$robo$$android_os_Parcel$closeFileDescriptor(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    static void clearFileDescriptor(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("clearFileDescriptor", $$robo$$android_os_Parcel$clearFileDescriptor(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    public byte readByte() {
        return (byte)InvokeDynamicSupport.bootstrap("readByte", $$robo$$android_os_Parcel$readByte(), this);
    }

    public void readMap(Map map, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readMap", $$robo$$android_os_Parcel$readMap(java.util.Map java.lang.ClassLoader ), this, map, classLoader);
    }

    public void readList(List list, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readList", $$robo$$android_os_Parcel$readList(java.util.List java.lang.ClassLoader ), this, list, classLoader);
    }

    public HashMap readHashMap(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readHashMap", $$robo$$android_os_Parcel$readHashMap(java.lang.ClassLoader ), this, classLoader);
    }

    public Bundle readBundle() {
        return InvokeDynamicSupport.bootstrap("readBundle", $$robo$$android_os_Parcel$readBundle(), this);
    }

    public Bundle readBundle(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readBundle", $$robo$$android_os_Parcel$readBundle(java.lang.ClassLoader ), this, classLoader);
    }

    public PersistableBundle readPersistableBundle() {
        return InvokeDynamicSupport.bootstrap("readPersistableBundle", $$robo$$android_os_Parcel$readPersistableBundle(), this);
    }

    public PersistableBundle readPersistableBundle(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readPersistableBundle", $$robo$$android_os_Parcel$readPersistableBundle(java.lang.ClassLoader ), this, classLoader);
    }

    public Size readSize() {
        return InvokeDynamicSupport.bootstrap("readSize", $$robo$$android_os_Parcel$readSize(), this);
    }

    public SizeF readSizeF() {
        return InvokeDynamicSupport.bootstrap("readSizeF", $$robo$$android_os_Parcel$readSizeF(), this);
    }

    public byte[] createByteArray() {
        return InvokeDynamicSupport.bootstrap("createByteArray", $$robo$$android_os_Parcel$createByteArray(), this);
    }

    public void readByteArray(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("readByteArray", $$robo$$android_os_Parcel$readByteArray(byte[] ), this, byArray);
    }

    public byte[] readBlob() {
        return InvokeDynamicSupport.bootstrap("readBlob", $$robo$$android_os_Parcel$readBlob(), this);
    }

    public String[] readStringArray() {
        return InvokeDynamicSupport.bootstrap("readStringArray", $$robo$$android_os_Parcel$readStringArray(), this);
    }

    public CharSequence[] readCharSequenceArray() {
        return InvokeDynamicSupport.bootstrap("readCharSequenceArray", $$robo$$android_os_Parcel$readCharSequenceArray(), this);
    }

    public ArrayList<CharSequence> readCharSequenceList() {
        return InvokeDynamicSupport.bootstrap("readCharSequenceList", $$robo$$android_os_Parcel$readCharSequenceList(), this);
    }

    public ArrayList readArrayList(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readArrayList", $$robo$$android_os_Parcel$readArrayList(java.lang.ClassLoader ), this, classLoader);
    }

    public Object[] readArray(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readArray", $$robo$$android_os_Parcel$readArray(java.lang.ClassLoader ), this, classLoader);
    }

    public SparseArray readSparseArray(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readSparseArray", $$robo$$android_os_Parcel$readSparseArray(java.lang.ClassLoader ), this, classLoader);
    }

    public SparseBooleanArray readSparseBooleanArray() {
        return InvokeDynamicSupport.bootstrap("readSparseBooleanArray", $$robo$$android_os_Parcel$readSparseBooleanArray(), this);
    }

    public SparseIntArray readSparseIntArray() {
        return InvokeDynamicSupport.bootstrap("readSparseIntArray", $$robo$$android_os_Parcel$readSparseIntArray(), this);
    }

    public <T> ArrayList<T> createTypedArrayList(Parcelable.Creator<T> creator) {
        return InvokeDynamicSupport.bootstrap("createTypedArrayList", $$robo$$android_os_Parcel$createTypedArrayList(android.os.Parcelable$Creator<T> ), this, creator);
    }

    public <T> void readTypedList(List<T> list, Parcelable.Creator<T> creator) {
        InvokeDynamicSupport.bootstrap("readTypedList", $$robo$$android_os_Parcel$readTypedList(java.util.List<T> android.os.Parcelable$Creator<T> ), this, list, creator);
    }

    public ArrayList<String> createStringArrayList() {
        return InvokeDynamicSupport.bootstrap("createStringArrayList", $$robo$$android_os_Parcel$createStringArrayList(), this);
    }

    public ArrayList<IBinder> createBinderArrayList() {
        return InvokeDynamicSupport.bootstrap("createBinderArrayList", $$robo$$android_os_Parcel$createBinderArrayList(), this);
    }

    public void readStringList(List<String> list) {
        InvokeDynamicSupport.bootstrap("readStringList", $$robo$$android_os_Parcel$readStringList(java.util.List<java.lang.String> ), this, list);
    }

    public void readBinderList(List<IBinder> list) {
        InvokeDynamicSupport.bootstrap("readBinderList", $$robo$$android_os_Parcel$readBinderList(java.util.List<android.os.IBinder> ), this, list);
    }

    public <T extends Parcelable> List<T> readParcelableList(List<T> list, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readParcelableList", $$robo$$android_os_Parcel$readParcelableList(java.util.List<T> java.lang.ClassLoader ), this, list, classLoader);
    }

    public <T> T[] createTypedArray(Parcelable.Creator<T> creator) {
        return InvokeDynamicSupport.bootstrap("createTypedArray", $$robo$$android_os_Parcel$createTypedArray(android.os.Parcelable$Creator<T> ), this, creator);
    }

    public <T> void readTypedArray(T[] TArray, Parcelable.Creator<T> creator) {
        InvokeDynamicSupport.bootstrap("readTypedArray", $$robo$$android_os_Parcel$readTypedArray(T[] android.os.Parcelable$Creator<T> ), this, TArray, creator);
    }

    @Deprecated
    public <T> T[] readTypedArray(Parcelable.Creator<T> creator) {
        return InvokeDynamicSupport.bootstrap("readTypedArray", $$robo$$android_os_Parcel$readTypedArray(android.os.Parcelable$Creator<T> ), this, creator);
    }

    public <T> T readTypedObject(Parcelable.Creator<T> creator) {
        return (T)InvokeDynamicSupport.bootstrap("readTypedObject", $$robo$$android_os_Parcel$readTypedObject(android.os.Parcelable$Creator<T> ), this, creator);
    }

    public <T extends Parcelable> void writeParcelableArray(T[] TArray, int n) {
        InvokeDynamicSupport.bootstrap("writeParcelableArray", $$robo$$android_os_Parcel$writeParcelableArray(android.os.Parcelable[] int ), this, TArray, n);
    }

    public Object readValue(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readValue", $$robo$$android_os_Parcel$readValue(java.lang.ClassLoader ), this, classLoader);
    }

    public <T extends Parcelable> T readParcelable(ClassLoader classLoader) {
        return (T)InvokeDynamicSupport.bootstrap("readParcelable", $$robo$$android_os_Parcel$readParcelable(java.lang.ClassLoader ), this, classLoader);
    }

    public <T extends Parcelable> T readCreator(Parcelable.Creator<?> creator, ClassLoader classLoader) {
        return (T)InvokeDynamicSupport.bootstrap("readCreator", $$robo$$android_os_Parcel$readCreator(android.os.Parcelable$Creator<?> java.lang.ClassLoader ), this, creator, classLoader);
    }

    public Parcelable.Creator<?> readParcelableCreator(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readParcelableCreator", $$robo$$android_os_Parcel$readParcelableCreator(java.lang.ClassLoader ), this, classLoader);
    }

    public Parcelable[] readParcelableArray(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readParcelableArray", $$robo$$android_os_Parcel$readParcelableArray(java.lang.ClassLoader ), this, classLoader);
    }

    public <T extends Parcelable> T[] readParcelableArray(ClassLoader classLoader, Class<T> clazz) {
        return InvokeDynamicSupport.bootstrap("readParcelableArray", $$robo$$android_os_Parcel$readParcelableArray(java.lang.ClassLoader java.lang.Class ), this, classLoader, clazz);
    }

    public Serializable readSerializable() {
        return InvokeDynamicSupport.bootstrap("readSerializable", $$robo$$android_os_Parcel$readSerializable(), this);
    }

    private Serializable readSerializable(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readSerializable", $$robo$$android_os_Parcel$readSerializable(java.lang.ClassLoader ), this, classLoader);
    }

    protected static Parcel obtain(int n) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_os_Parcel$obtain(int ), (int)n);
    }

    protected static Parcel obtain(long l) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_os_Parcel$obtain(long ), (long)l);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_os_Parcel$__constructor__(l);
    }

    public Parcel(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Parcel$__constructor__(long ), this, l);
    }

    private void init(long l) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_os_Parcel$init(long ), this, l);
    }

    private void freeBuffer() {
        InvokeDynamicSupport.bootstrap("freeBuffer", $$robo$$android_os_Parcel$freeBuffer(), this);
    }

    private void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_os_Parcel$destroy(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_Parcel$finalize(), this);
    }

    void readMapInternal(Map map, int n, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readMapInternal", $$robo$$android_os_Parcel$readMapInternal(java.util.Map int java.lang.ClassLoader ), this, map, n, classLoader);
    }

    void readArrayMapInternal(ArrayMap arrayMap, int n, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readArrayMapInternal", $$robo$$android_os_Parcel$readArrayMapInternal(android.util.ArrayMap int java.lang.ClassLoader ), this, arrayMap, n, classLoader);
    }

    void readArrayMapSafelyInternal(ArrayMap arrayMap, int n, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readArrayMapSafelyInternal", $$robo$$android_os_Parcel$readArrayMapSafelyInternal(android.util.ArrayMap int java.lang.ClassLoader ), this, arrayMap, n, classLoader);
    }

    public void readArrayMap(ArrayMap arrayMap, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readArrayMap", $$robo$$android_os_Parcel$readArrayMap(android.util.ArrayMap java.lang.ClassLoader ), this, arrayMap, classLoader);
    }

    public ArraySet<? extends Object> readArraySet(ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("readArraySet", $$robo$$android_os_Parcel$readArraySet(java.lang.ClassLoader ), this, classLoader);
    }

    private void readListInternal(List list, int n, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readListInternal", $$robo$$android_os_Parcel$readListInternal(java.util.List int java.lang.ClassLoader ), this, list, n, classLoader);
    }

    private void readArrayInternal(Object[] objectArray, int n, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readArrayInternal", $$robo$$android_os_Parcel$readArrayInternal(java.lang.Object[] int java.lang.ClassLoader ), this, objectArray, n, classLoader);
    }

    private void readSparseArrayInternal(SparseArray sparseArray, int n, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("readSparseArrayInternal", $$robo$$android_os_Parcel$readSparseArrayInternal(android.util.SparseArray int java.lang.ClassLoader ), this, sparseArray, n, classLoader);
    }

    private void readSparseBooleanArrayInternal(SparseBooleanArray sparseBooleanArray, int n) {
        InvokeDynamicSupport.bootstrap("readSparseBooleanArrayInternal", $$robo$$android_os_Parcel$readSparseBooleanArrayInternal(android.util.SparseBooleanArray int ), this, sparseBooleanArray, n);
    }

    private void readSparseIntArrayInternal(SparseIntArray sparseIntArray, int n) {
        InvokeDynamicSupport.bootstrap("readSparseIntArrayInternal", $$robo$$android_os_Parcel$readSparseIntArrayInternal(android.util.SparseIntArray int ), this, sparseIntArray, n);
    }

    public long getBlobAshmemSize() {
        return (long)InvokeDynamicSupport.bootstrap("getBlobAshmemSize", $$robo$$android_os_Parcel$getBlobAshmemSize(), this);
    }

    static {
        RobolectricInternals.classInitializing(Parcel.class);
    }

    public /* synthetic */ Parcel() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Parcel)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

