/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.IWifiScanner;
import android.net.wifi.ScanResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiScanner
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int WIFI_BAND_UNSPECIFIED = 0;
    public static int WIFI_BAND_24_GHZ = 1;
    public static int WIFI_BAND_5_GHZ = 2;
    public static int WIFI_BAND_5_GHZ_DFS_ONLY = 4;
    public static int WIFI_BAND_5_GHZ_WITH_DFS = 6;
    public static int WIFI_BAND_BOTH = 3;
    public static int WIFI_BAND_BOTH_WITH_DFS = 7;
    public static int MIN_SCAN_PERIOD_MS = 1000;
    public static int MAX_SCAN_PERIOD_MS = 1024000;
    public static int REASON_SUCCEEDED = 0;
    public static int REASON_UNSPECIFIED = -1;
    public static int REASON_INVALID_LISTENER = -2;
    public static int REASON_INVALID_REQUEST = -3;
    public static int REASON_NOT_AUTHORIZED = -4;
    public static int REASON_DUPLICATE_REQEUST = -5;
    public static String GET_AVAILABLE_CHANNELS_EXTRA = "Channels";
    @Deprecated
    public static int REPORT_EVENT_AFTER_BUFFER_FULL = 0;
    public static int REPORT_EVENT_AFTER_EACH_SCAN = 1;
    public static int REPORT_EVENT_FULL_SCAN_RESULT = 2;
    public static int REPORT_EVENT_NO_BATCH = 4;
    public static String SCAN_PARAMS_SCAN_SETTINGS_KEY = "ScanSettings";
    public static String SCAN_PARAMS_WORK_SOURCE_KEY = "WorkSource";
    public static String PNO_PARAMS_PNO_SETTINGS_KEY = "PnoSettings";
    public static String PNO_PARAMS_SCAN_SETTINGS_KEY = "ScanSettings";
    private static String TAG = "WifiScanner";
    private static boolean DBG = false;
    private static int BASE = 159744;
    public static int CMD_SCAN = 159744;
    public static int CMD_START_BACKGROUND_SCAN = 159746;
    public static int CMD_STOP_BACKGROUND_SCAN = 159747;
    public static int CMD_GET_SCAN_RESULTS = 159748;
    public static int CMD_SCAN_RESULT = 159749;
    public static int CMD_AP_FOUND = 159753;
    public static int CMD_AP_LOST = 159754;
    public static int CMD_WIFI_CHANGE_DETECTED = 159759;
    public static int CMD_WIFI_CHANGES_STABILIZED = 159760;
    public static int CMD_OP_SUCCEEDED = 159761;
    public static int CMD_OP_FAILED = 159762;
    public static int CMD_PERIOD_CHANGED = 159763;
    public static int CMD_FULL_SCAN_RESULT = 159764;
    public static int CMD_START_SINGLE_SCAN = 159765;
    public static int CMD_STOP_SINGLE_SCAN = 159766;
    public static int CMD_SINGLE_SCAN_COMPLETED = 159767;
    public static int CMD_START_PNO_SCAN = 159768;
    public static int CMD_STOP_PNO_SCAN = 159769;
    public static int CMD_PNO_NETWORK_FOUND = 159770;
    public static int CMD_REGISTER_SCAN_LISTENER = 159771;
    public static int CMD_DEREGISTER_SCAN_LISTENER = 159772;
    public static int CMD_GET_SINGLE_SCAN_RESULTS = 159773;
    private Context mContext;
    private IWifiScanner mService;
    private static int INVALID_KEY = 0;
    private int mListenerKey;
    private SparseArray mListenerMap;
    private Object mListenerMapLock;
    private AsyncChannel mAsyncChannel;
    private Handler mInternalHandler;

    private final List<Integer> $$robo$$android_net_wifi_WifiScanner$getAvailableChannels(int band) {
        try {
            Bundle bundle = this.mService.getAvailableChannels(band);
            return bundle.getIntegerArrayList("Channels");
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final void $$robo$$android_net_wifi_WifiScanner$registerScanListener(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159771, 0, key);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$deregisterScanListener(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159772, 0, key);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startBackgroundScan(ScanSettings settings, ScanListener listener) {
        this.startBackgroundScan(settings, listener, null);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startBackgroundScan(ScanSettings settings, ScanListener listener, WorkSource workSource) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putParcelable("ScanSettings", settings);
        scanParams.putParcelable("WorkSource", workSource);
        this.mAsyncChannel.sendMessage(159746, 0, key, scanParams);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$stopBackgroundScan(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159747, 0, key);
    }

    private final boolean $$robo$$android_net_wifi_WifiScanner$getScanResults() {
        this.validateChannel();
        Message reply = this.mAsyncChannel.sendMessageSynchronously(159748, 0);
        return reply.what == 159761;
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startScan(ScanSettings settings, ScanListener listener) {
        this.startScan(settings, listener, null);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startScan(ScanSettings settings, ScanListener listener, WorkSource workSource) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        Bundle scanParams = new Bundle();
        scanParams.putParcelable("ScanSettings", settings);
        scanParams.putParcelable("WorkSource", workSource);
        this.mAsyncChannel.sendMessage(159765, 0, key, scanParams);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$stopScan(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159766, 0, key);
    }

    private final List<ScanResult> $$robo$$android_net_wifi_WifiScanner$getSingleScanResults() {
        this.validateChannel();
        Message reply = this.mAsyncChannel.sendMessageSynchronously(159773, 0);
        if (reply.what == 159761) {
            return Arrays.asList(((ParcelableScanResults)reply.obj).getResults());
        }
        OperationResult result = (OperationResult)reply.obj;
        Log.e("WifiScanner", "Error retrieving SingleScan results reason: " + result.reason + " description: " + result.description);
        return new ArrayList<ScanResult>();
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, int key) {
        Bundle pnoParams = new Bundle();
        scanSettings.isPnoScan = true;
        pnoParams.putParcelable("ScanSettings", scanSettings);
        pnoParams.putParcelable("PnoSettings", pnoSettings);
        this.mAsyncChannel.sendMessage(159768, 0, key, pnoParams);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startConnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, PnoScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Preconditions.checkNotNull(pnoSettings, "pnoSettings cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        pnoSettings.isConnected = true;
        this.startPnoScan(scanSettings, pnoSettings, key);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startDisconnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, PnoScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Preconditions.checkNotNull(pnoSettings, "pnoSettings cannot be null");
        int key = this.addListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        pnoSettings.isConnected = false;
        this.startPnoScan(scanSettings, pnoSettings, key);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$stopPnoScan(ScanListener listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        int key = this.removeListener(listener);
        if (key == 0) {
            return;
        }
        this.validateChannel();
        this.mAsyncChannel.sendMessage(159769, 0, key);
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_net_wifi_WifiScanner$configureWifiChange(int rssiSampleSize, int lostApSampleSize, int unchangedSampleSize, int minApsBreachingThreshold, int periodInMs, BssidInfo[] bssidInfos) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_net_wifi_WifiScanner$startTrackingWifiChange(WifiChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_net_wifi_WifiScanner$stopTrackingWifiChange(WifiChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_net_wifi_WifiScanner$configureWifiChange(WifiChangeSettings settings) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_net_wifi_WifiScanner$startTrackingBssids(BssidInfo[] bssidInfos, int apLostThreshold, BssidListener listener) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_net_wifi_WifiScanner$stopTrackingBssids(BssidListener listener) {
        throw new UnsupportedOperationException();
    }

    private void $$robo$$android_net_wifi_WifiScanner$__constructor__(Context context, IWifiScanner service, Looper looper) {
        this.mListenerKey = 1;
        this.mListenerMap = new SparseArray();
        this.mListenerMapLock = new Object();
        this.mContext = context;
        this.mService = service;
        Messenger messenger = null;
        try {
            messenger = this.mService.getMessenger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (messenger == null) {
            throw new IllegalStateException("getMessenger() returned null!  This is invalid.");
        }
        this.mAsyncChannel = new AsyncChannel();
        this.mInternalHandler = new ServiceHandler(this, looper);
        this.mAsyncChannel.connectSync(this.mContext, this.mInternalHandler, messenger);
        this.mAsyncChannel.sendMessage(69633);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$validateChannel() {
        if (this.mAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_WifiScanner$addListener(ActionListener listener) {
        Object object = this.mListenerMapLock;
        synchronized (object) {
            boolean keyExists = this.getListenerKey(listener) != 0;
            int key = this.putListener(listener);
            if (keyExists) {
                OperationResult operationResult = new OperationResult(-5, "Outstanding request with same key not stopped yet");
                Message message = Message.obtain(this.mInternalHandler, 159762, 0, key, operationResult);
                message.sendToTarget();
                return 0;
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_WifiScanner$putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            do {
                ++this.mListenerKey;
            } while (key == 0);
            this.mListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_net_wifi_WifiScanner$getListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_WifiScanner$getListenerKey(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            int index = this.mListenerMap.indexOfValue(listener);
            if (index == -1) {
                return 0;
            }
            return this.mListenerMap.keyAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_net_wifi_WifiScanner$removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            this.mListenerMap.remove(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_WifiScanner$removeListener(Object listener) {
        int key = this.getListenerKey(listener);
        if (key == 0) {
            Log.e("WifiScanner", "listener cannot be found");
            return key;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            return key;
        }
    }

    public List<Integer> getAvailableChannels(int n) {
        return InvokeDynamicSupport.bootstrap("getAvailableChannels", $$robo$$android_net_wifi_WifiScanner$getAvailableChannels(int ), this, n);
    }

    public void registerScanListener(ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("registerScanListener", $$robo$$android_net_wifi_WifiScanner$registerScanListener(android.net.wifi.WifiScanner$ScanListener ), this, scanListener);
    }

    public void deregisterScanListener(ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("deregisterScanListener", $$robo$$android_net_wifi_WifiScanner$deregisterScanListener(android.net.wifi.WifiScanner$ScanListener ), this, scanListener);
    }

    public void startBackgroundScan(ScanSettings scanSettings, ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("startBackgroundScan", $$robo$$android_net_wifi_WifiScanner$startBackgroundScan(android.net.wifi.WifiScanner$ScanSettings android.net.wifi.WifiScanner$ScanListener ), this, scanSettings, scanListener);
    }

    public void startBackgroundScan(ScanSettings scanSettings, ScanListener scanListener, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("startBackgroundScan", $$robo$$android_net_wifi_WifiScanner$startBackgroundScan(android.net.wifi.WifiScanner$ScanSettings android.net.wifi.WifiScanner$ScanListener android.os.WorkSource ), this, scanSettings, scanListener, workSource);
    }

    public void stopBackgroundScan(ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("stopBackgroundScan", $$robo$$android_net_wifi_WifiScanner$stopBackgroundScan(android.net.wifi.WifiScanner$ScanListener ), this, scanListener);
    }

    public boolean getScanResults() {
        return (boolean)InvokeDynamicSupport.bootstrap("getScanResults", $$robo$$android_net_wifi_WifiScanner$getScanResults(), this);
    }

    public void startScan(ScanSettings scanSettings, ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_net_wifi_WifiScanner$startScan(android.net.wifi.WifiScanner$ScanSettings android.net.wifi.WifiScanner$ScanListener ), this, scanSettings, scanListener);
    }

    public void startScan(ScanSettings scanSettings, ScanListener scanListener, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_net_wifi_WifiScanner$startScan(android.net.wifi.WifiScanner$ScanSettings android.net.wifi.WifiScanner$ScanListener android.os.WorkSource ), this, scanSettings, scanListener, workSource);
    }

    public void stopScan(ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("stopScan", $$robo$$android_net_wifi_WifiScanner$stopScan(android.net.wifi.WifiScanner$ScanListener ), this, scanListener);
    }

    public List<ScanResult> getSingleScanResults() {
        return InvokeDynamicSupport.bootstrap("getSingleScanResults", $$robo$$android_net_wifi_WifiScanner$getSingleScanResults(), this);
    }

    private void startPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, int n) {
        InvokeDynamicSupport.bootstrap("startPnoScan", $$robo$$android_net_wifi_WifiScanner$startPnoScan(android.net.wifi.WifiScanner$ScanSettings android.net.wifi.WifiScanner$PnoSettings int ), this, scanSettings, pnoSettings, n);
    }

    public void startConnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, PnoScanListener pnoScanListener) {
        InvokeDynamicSupport.bootstrap("startConnectedPnoScan", $$robo$$android_net_wifi_WifiScanner$startConnectedPnoScan(android.net.wifi.WifiScanner$ScanSettings android.net.wifi.WifiScanner$PnoSettings android.net.wifi.WifiScanner$PnoScanListener ), this, scanSettings, pnoSettings, pnoScanListener);
    }

    public void startDisconnectedPnoScan(ScanSettings scanSettings, PnoSettings pnoSettings, PnoScanListener pnoScanListener) {
        InvokeDynamicSupport.bootstrap("startDisconnectedPnoScan", $$robo$$android_net_wifi_WifiScanner$startDisconnectedPnoScan(android.net.wifi.WifiScanner$ScanSettings android.net.wifi.WifiScanner$PnoSettings android.net.wifi.WifiScanner$PnoScanListener ), this, scanSettings, pnoSettings, pnoScanListener);
    }

    public void stopPnoScan(ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("stopPnoScan", $$robo$$android_net_wifi_WifiScanner$stopPnoScan(android.net.wifi.WifiScanner$ScanListener ), this, scanListener);
    }

    @Deprecated
    public void configureWifiChange(int n, int n2, int n3, int n4, int n5, BssidInfo[] bssidInfoArray) {
        InvokeDynamicSupport.bootstrap("configureWifiChange", $$robo$$android_net_wifi_WifiScanner$configureWifiChange(int int int int int android.net.wifi.WifiScanner$BssidInfo[] ), this, n, n2, n3, n4, n5, bssidInfoArray);
    }

    @Deprecated
    public void startTrackingWifiChange(WifiChangeListener wifiChangeListener) {
        InvokeDynamicSupport.bootstrap("startTrackingWifiChange", $$robo$$android_net_wifi_WifiScanner$startTrackingWifiChange(android.net.wifi.WifiScanner$WifiChangeListener ), this, wifiChangeListener);
    }

    @Deprecated
    public void stopTrackingWifiChange(WifiChangeListener wifiChangeListener) {
        InvokeDynamicSupport.bootstrap("stopTrackingWifiChange", $$robo$$android_net_wifi_WifiScanner$stopTrackingWifiChange(android.net.wifi.WifiScanner$WifiChangeListener ), this, wifiChangeListener);
    }

    @Deprecated
    public void configureWifiChange(WifiChangeSettings wifiChangeSettings) {
        InvokeDynamicSupport.bootstrap("configureWifiChange", $$robo$$android_net_wifi_WifiScanner$configureWifiChange(android.net.wifi.WifiScanner$WifiChangeSettings ), this, wifiChangeSettings);
    }

    @Deprecated
    public void startTrackingBssids(BssidInfo[] bssidInfoArray, int n, BssidListener bssidListener) {
        InvokeDynamicSupport.bootstrap("startTrackingBssids", $$robo$$android_net_wifi_WifiScanner$startTrackingBssids(android.net.wifi.WifiScanner$BssidInfo[] int android.net.wifi.WifiScanner$BssidListener ), this, bssidInfoArray, n, bssidListener);
    }

    @Deprecated
    public void stopTrackingBssids(BssidListener bssidListener) {
        InvokeDynamicSupport.bootstrap("stopTrackingBssids", $$robo$$android_net_wifi_WifiScanner$stopTrackingBssids(android.net.wifi.WifiScanner$BssidListener ), this, bssidListener);
    }

    private void __constructor__(Context context, IWifiScanner iWifiScanner, Looper looper) {
        this.$$robo$$android_net_wifi_WifiScanner$__constructor__(context, iWifiScanner, looper);
    }

    public WifiScanner(Context context, IWifiScanner iWifiScanner, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner$__constructor__(android.content.Context android.net.wifi.IWifiScanner android.os.Looper ), this, context, iWifiScanner, looper);
    }

    private void validateChannel() {
        InvokeDynamicSupport.bootstrap("validateChannel", $$robo$$android_net_wifi_WifiScanner$validateChannel(), this);
    }

    private int addListener(ActionListener actionListener) {
        return (int)InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_net_wifi_WifiScanner$addListener(android.net.wifi.WifiScanner$ActionListener ), this, actionListener);
    }

    private int putListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("putListener", $$robo$$android_net_wifi_WifiScanner$putListener(java.lang.Object ), this, object);
    }

    private Object getListener(int n) {
        return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_net_wifi_WifiScanner$getListener(int ), this, n);
    }

    private int getListenerKey(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getListenerKey", $$robo$$android_net_wifi_WifiScanner$getListenerKey(java.lang.Object ), this, object);
    }

    private Object removeListener(int n) {
        return InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_net_wifi_WifiScanner$removeListener(int ), this, n);
    }

    private int removeListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_net_wifi_WifiScanner$removeListener(java.lang.Object ), this, object);
    }

    public /* synthetic */ WifiScanner() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiScanner)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ServiceHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ WifiScanner this$0;

        private void $$robo$$android_net_wifi_WifiScanner_ServiceHandler$__constructor__(WifiScanner wifiScanner, Looper looper) {
        }

        private final void $$robo$$android_net_wifi_WifiScanner_ServiceHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 69634: {
                    return;
                }
                case 69636: {
                    Log.e("WifiScanner", "Channel connection lost");
                    this.this$0.mAsyncChannel = null;
                    this.getLooper().quit();
                    return;
                }
            }
            Object listener = this.this$0.getListener(msg.arg2);
            if (listener == null) {
                return;
            }
            switch (msg.what) {
                case 159761: {
                    ((ActionListener)listener).onSuccess();
                    break;
                }
                case 159762: {
                    OperationResult result = (OperationResult)msg.obj;
                    ((ActionListener)listener).onFailure(result.reason, result.description);
                    this.this$0.removeListener(msg.arg2);
                    break;
                }
                case 159749: {
                    ((ScanListener)listener).onResults(((ParcelableScanData)msg.obj).getResults());
                    return;
                }
                case 159764: {
                    ScanResult result = (ScanResult)msg.obj;
                    ((ScanListener)listener).onFullResult(result);
                    return;
                }
                case 159763: {
                    ((ScanListener)listener).onPeriodChanged(msg.arg1);
                    return;
                }
                case 159753: {
                    ((BssidListener)listener).onFound(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159754: {
                    ((BssidListener)listener).onLost(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159759: {
                    ((WifiChangeListener)listener).onChanging(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159760: {
                    ((WifiChangeListener)listener).onQuiescence(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159767: {
                    this.this$0.removeListener(msg.arg2);
                    break;
                }
                case 159770: {
                    ((PnoScanListener)listener).onPnoNetworkFound(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                default: {
                    return;
                }
            }
        }

        private void __constructor__(WifiScanner wifiScanner, Looper looper) {
            this.$$robo$$android_net_wifi_WifiScanner_ServiceHandler$__constructor__(wifiScanner, looper);
        }

        public ServiceHandler(WifiScanner wifiScanner, Looper looper) {
            this.this$0 = wifiScanner;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ServiceHandler$__constructor__(android.net.wifi.WifiScanner android.os.Looper ), this, wifiScanner, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_WifiScanner_ServiceHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ ServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OperationResult
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int reason;
        public String description;
        public static Parcelable.Creator<OperationResult> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_OperationResult$__constructor__(int reason, String description) {
            this.reason = reason;
            this.description = description;
        }

        private final int $$robo$$android_net_wifi_WifiScanner_OperationResult$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_OperationResult$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.reason);
            dest.writeString(this.description);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<OperationResult>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_OperationResult_1$__constructor__() {
                }

                private final OperationResult $$robo$$android_net_wifi_WifiScanner_OperationResult_1$createFromParcel(Parcel in) {
                    int reason = in.readInt();
                    String description = in.readString();
                    return new OperationResult(reason, description);
                }

                private final OperationResult[] $$robo$$android_net_wifi_WifiScanner_OperationResult_1$newArray(int size) {
                    return new OperationResult[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_OperationResult_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_OperationResult_1$__constructor__(), this);
                }

                @Override
                public OperationResult createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_OperationResult_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public OperationResult[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_OperationResult_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_net_wifi_WifiScanner_OperationResult$__constructor__(n, string2);
        }

        public OperationResult(int n, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_OperationResult$__constructor__(int java.lang.String ), this, n, string2);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_OperationResult$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_OperationResult$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(OperationResult.class);
        }

        public /* synthetic */ OperationResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OperationResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class HotlistSettings
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public BssidInfo[] bssidInfos;
        public int apLostThreshold;
        public static Parcelable.Creator<HotlistSettings> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_HotlistSettings$__constructor__() {
        }

        private final int $$robo$$android_net_wifi_WifiScanner_HotlistSettings$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_HotlistSettings$writeToParcel(Parcel dest, int flags) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<HotlistSettings>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$__constructor__() {
                }

                private final HotlistSettings $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$createFromParcel(Parcel in) {
                    HotlistSettings settings = new HotlistSettings();
                    return settings;
                }

                private final HotlistSettings[] $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$newArray(int size) {
                    return new HotlistSettings[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$__constructor__(), this);
                }

                @Override
                public HotlistSettings createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public HotlistSettings[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_HotlistSettings$__constructor__();
        }

        public HotlistSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_HotlistSettings$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_HotlistSettings$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_HotlistSettings$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(HotlistSettings.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HotlistSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface BssidListener
    extends ActionListener,
    InstrumentedInterface {
        public void onFound(ScanResult[] var1);

        public void onLost(ScanResult[] var1);
    }

    @Deprecated
    public static interface WifiChangeListener
    extends ActionListener,
    InstrumentedInterface {
        public void onChanging(ScanResult[] var1);

        public void onQuiescence(ScanResult[] var1);
    }

    @Deprecated
    public static class WifiChangeSettings
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int rssiSampleSize;
        public int lostApSampleSize;
        public int unchangedSampleSize;
        public int minApsBreachingThreshold;
        public int periodInMs;
        public BssidInfo[] bssidInfos;
        public static Parcelable.Creator<WifiChangeSettings> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$__constructor__() {
        }

        private final int $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$writeToParcel(Parcel dest, int flags) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<WifiChangeSettings>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$__constructor__() {
                }

                private final WifiChangeSettings $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$createFromParcel(Parcel in) {
                    return new WifiChangeSettings();
                }

                private final WifiChangeSettings[] $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$newArray(int size) {
                    return new WifiChangeSettings[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$__constructor__(), this);
                }

                @Override
                public WifiChangeSettings createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public WifiChangeSettings[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$__constructor__();
        }

        public WifiChangeSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(WifiChangeSettings.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiChangeSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class BssidInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String bssid;
        public int low;
        public int high;
        public int frequencyHint;

        private void $$robo$$android_net_wifi_WifiScanner_BssidInfo$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_BssidInfo$__constructor__();
        }

        public BssidInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_BssidInfo$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BssidInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface PnoScanListener
    extends ScanListener,
    InstrumentedInterface {
        public void onPnoNetworkFound(ScanResult[] var1);
    }

    public static interface ScanListener
    extends ActionListener,
    InstrumentedInterface {
        public void onPeriodChanged(int var1);

        public void onResults(ScanData[] var1);

        public void onFullResult(ScanResult var1);
    }

    public static class PnoSettings
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public boolean isConnected;
        public int min5GHzRssi;
        public int min24GHzRssi;
        public int initialScoreMax;
        public int currentConnectionBonus;
        public int sameNetworkBonus;
        public int secureBonus;
        public int band5GHzBonus;
        public PnoNetwork[] networkList;
        public static Parcelable.Creator<PnoSettings> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_PnoSettings$__constructor__() {
        }

        private final int $$robo$$android_net_wifi_WifiScanner_PnoSettings$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_PnoSettings$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.isConnected ? 1 : 0);
            dest.writeInt(this.min5GHzRssi);
            dest.writeInt(this.min24GHzRssi);
            dest.writeInt(this.initialScoreMax);
            dest.writeInt(this.currentConnectionBonus);
            dest.writeInt(this.sameNetworkBonus);
            dest.writeInt(this.secureBonus);
            dest.writeInt(this.band5GHzBonus);
            if (this.networkList != null) {
                dest.writeInt(this.networkList.length);
                for (int i = 0; i < this.networkList.length; ++i) {
                    dest.writeString(this.networkList[i].ssid);
                    dest.writeByte(this.networkList[i].flags);
                    dest.writeByte(this.networkList[i].authBitField);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<PnoSettings>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_PnoSettings_1$__constructor__() {
                }

                private final PnoSettings $$robo$$android_net_wifi_WifiScanner_PnoSettings_1$createFromParcel(Parcel in) {
                    PnoSettings settings = new PnoSettings();
                    settings.isConnected = in.readInt() == 1;
                    settings.min5GHzRssi = in.readInt();
                    settings.min24GHzRssi = in.readInt();
                    settings.initialScoreMax = in.readInt();
                    settings.currentConnectionBonus = in.readInt();
                    settings.sameNetworkBonus = in.readInt();
                    settings.secureBonus = in.readInt();
                    settings.band5GHzBonus = in.readInt();
                    int numNetworks = in.readInt();
                    settings.networkList = new PnoNetwork[numNetworks];
                    for (int i = 0; i < numNetworks; ++i) {
                        String ssid = in.readString();
                        PnoNetwork network = new PnoNetwork(ssid);
                        network.flags = in.readByte();
                        network.authBitField = in.readByte();
                        settings.networkList[i] = network;
                    }
                    return settings;
                }

                private final PnoSettings[] $$robo$$android_net_wifi_WifiScanner_PnoSettings_1$newArray(int size) {
                    return new PnoSettings[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_PnoSettings_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_PnoSettings_1$__constructor__(), this);
                }

                @Override
                public PnoSettings createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_PnoSettings_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public PnoSettings[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_PnoSettings_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_PnoSettings$__constructor__();
        }

        public PnoSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_PnoSettings$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_PnoSettings$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_PnoSettings$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(PnoSettings.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PnoSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class PnoNetwork
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            public static byte FLAG_DIRECTED_SCAN = 1;
            public static byte FLAG_A_BAND = 2;
            public static byte FLAG_G_BAND = 4;
            public static byte FLAG_STRICT_MATCH = 8;
            public static byte FLAG_SAME_NETWORK = 16;
            public static byte AUTH_CODE_OPEN = 1;
            public static byte AUTH_CODE_PSK = 2;
            public static byte AUTH_CODE_EAPOL = 4;
            public String ssid;
            public byte flags;
            public byte authBitField;

            private void $$robo$$android_net_wifi_WifiScanner_PnoSettings_PnoNetwork$__constructor__(String ssid) {
                this.ssid = ssid;
                this.flags = 0;
                this.authBitField = 0;
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_net_wifi_WifiScanner_PnoSettings_PnoNetwork$__constructor__(string2);
            }

            public PnoNetwork(String string2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_PnoSettings_PnoNetwork$__constructor__(java.lang.String ), this, string2);
            }

            public /* synthetic */ PnoNetwork() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PnoNetwork)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class ParcelableScanResults
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ScanResult[] mResults;
        public static Parcelable.Creator<ParcelableScanResults> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$__constructor__(ScanResult[] results) {
            this.mResults = results;
        }

        private final ScanResult[] $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$getResults() {
            return this.mResults;
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanResult result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableScanResults>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$__constructor__() {
                }

                private final ParcelableScanResults $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$createFromParcel(Parcel in) {
                    int n = in.readInt();
                    ScanResult[] results = new ScanResult[n];
                    for (int i = 0; i < n; ++i) {
                        results[i] = ScanResult.CREATOR.createFromParcel(in);
                    }
                    return new ParcelableScanResults(results);
                }

                private final ParcelableScanResults[] $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$newArray(int size) {
                    return new ParcelableScanResults[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$__constructor__(), this);
                }

                @Override
                public ParcelableScanResults createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ParcelableScanResults[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ScanResult[] scanResultArray) {
            this.$$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$__constructor__(scanResultArray);
        }

        public ParcelableScanResults(ScanResult[] scanResultArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$__constructor__(android.net.wifi.ScanResult[] ), this, scanResultArray);
        }

        public ScanResult[] getResults() {
            return InvokeDynamicSupport.bootstrap("getResults", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$getResults(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableScanResults.class);
        }

        public /* synthetic */ ParcelableScanResults() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableScanResults)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParcelableScanData
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ScanData[] mResults;
        public static Parcelable.Creator<ParcelableScanData> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_ParcelableScanData$__constructor__(ScanData[] results) {
            this.mResults = results;
        }

        private final ScanData[] $$robo$$android_net_wifi_WifiScanner_ParcelableScanData$getResults() {
            return this.mResults;
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ParcelableScanData$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_ParcelableScanData$writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanData result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableScanData>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_ParcelableScanData_1$__constructor__() {
                }

                private final ParcelableScanData $$robo$$android_net_wifi_WifiScanner_ParcelableScanData_1$createFromParcel(Parcel in) {
                    int n = in.readInt();
                    ScanData[] results = new ScanData[n];
                    for (int i = 0; i < n; ++i) {
                        results[i] = ScanData.CREATOR.createFromParcel(in);
                    }
                    return new ParcelableScanData(results);
                }

                private final ParcelableScanData[] $$robo$$android_net_wifi_WifiScanner_ParcelableScanData_1$newArray(int size) {
                    return new ParcelableScanData[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_ParcelableScanData_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ParcelableScanData_1$__constructor__(), this);
                }

                @Override
                public ParcelableScanData createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_ParcelableScanData_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ParcelableScanData[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_ParcelableScanData_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ScanData[] scanDataArray) {
            this.$$robo$$android_net_wifi_WifiScanner_ParcelableScanData$__constructor__(scanDataArray);
        }

        public ParcelableScanData(ScanData[] scanDataArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ParcelableScanData$__constructor__(android.net.wifi.WifiScanner$ScanData[] ), this, scanDataArray);
        }

        public ScanData[] getResults() {
            return InvokeDynamicSupport.bootstrap("getResults", $$robo$$android_net_wifi_WifiScanner_ParcelableScanData$getResults(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_ParcelableScanData$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_ParcelableScanData$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableScanData.class);
        }

        public /* synthetic */ ParcelableScanData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableScanData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ScanData
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mId;
        private int mFlags;
        private int mBucketsScanned;
        private boolean mAllChannelsScanned;
        private ScanResult[] mResults;
        public static Parcelable.Creator<ScanData> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__() {
        }

        private void $$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(int id2, int flags, ScanResult[] results) {
            this.mId = id2;
            this.mFlags = flags;
            this.mResults = results;
        }

        private void $$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(int id2, int flags, int bucketsScanned, boolean allChannelsScanned, ScanResult[] results) {
            this.mId = id2;
            this.mFlags = flags;
            this.mBucketsScanned = bucketsScanned;
            this.mAllChannelsScanned = allChannelsScanned;
            this.mResults = results;
        }

        private void $$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(ScanData s) {
            this.mId = s.mId;
            this.mFlags = s.mFlags;
            this.mBucketsScanned = s.mBucketsScanned;
            this.mAllChannelsScanned = s.mAllChannelsScanned;
            this.mResults = new ScanResult[s.mResults.length];
            for (int i = 0; i < s.mResults.length; ++i) {
                ScanResult newResult;
                ScanResult result = s.mResults[i];
                this.mResults[i] = newResult = new ScanResult(result);
            }
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ScanData$getId() {
            return this.mId;
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ScanData$getFlags() {
            return this.mFlags;
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ScanData$getBucketsScanned() {
            return this.mBucketsScanned;
        }

        private final boolean $$robo$$android_net_wifi_WifiScanner_ScanData$isAllChannelsScanned() {
            return this.mAllChannelsScanned;
        }

        private final ScanResult[] $$robo$$android_net_wifi_WifiScanner_ScanData$getResults() {
            return this.mResults;
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ScanData$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_ScanData$writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mId);
                dest.writeInt(this.mFlags);
                dest.writeInt(this.mBucketsScanned);
                dest.writeInt(this.mAllChannelsScanned ? 1 : 0);
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanResult result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ScanData>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_ScanData_1$__constructor__() {
                }

                private final ScanData $$robo$$android_net_wifi_WifiScanner_ScanData_1$createFromParcel(Parcel in) {
                    int id2 = in.readInt();
                    int flags = in.readInt();
                    int bucketsScanned = in.readInt();
                    boolean allChannelsScanned = in.readInt() != 0;
                    int n = in.readInt();
                    ScanResult[] results = new ScanResult[n];
                    for (int i = 0; i < n; ++i) {
                        results[i] = ScanResult.CREATOR.createFromParcel(in);
                    }
                    return new ScanData(id2, flags, bucketsScanned, allChannelsScanned, results);
                }

                private final ScanData[] $$robo$$android_net_wifi_WifiScanner_ScanData_1$newArray(int size) {
                    return new ScanData[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_ScanData_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanData_1$__constructor__(), this);
                }

                @Override
                public ScanData createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_ScanData_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ScanData[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_ScanData_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__();
        }

        public ScanData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(), this);
        }

        private void __constructor__(int n, int n2, ScanResult[] scanResultArray) {
            this.$$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(n, n2, scanResultArray);
        }

        public ScanData(int n, int n2, ScanResult[] scanResultArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(int int android.net.wifi.ScanResult[] ), this, n, n2, scanResultArray);
        }

        private void __constructor__(int n, int n2, int n3, boolean bl, ScanResult[] scanResultArray) {
            this.$$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(n, n2, n3, bl, scanResultArray);
        }

        public ScanData(int n, int n2, int n3, boolean bl, ScanResult[] scanResultArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(int int int boolean android.net.wifi.ScanResult[] ), this, n, n2, n3, bl, scanResultArray);
        }

        private void __constructor__(ScanData scanData) {
            this.$$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(scanData);
        }

        public ScanData(ScanData scanData) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanData$__constructor__(android.net.wifi.WifiScanner$ScanData ), this, scanData);
        }

        public int getId() {
            return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_net_wifi_WifiScanner_ScanData$getId(), this);
        }

        public int getFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_net_wifi_WifiScanner_ScanData$getFlags(), this);
        }

        public int getBucketsScanned() {
            return (int)InvokeDynamicSupport.bootstrap("getBucketsScanned", $$robo$$android_net_wifi_WifiScanner_ScanData$getBucketsScanned(), this);
        }

        public boolean isAllChannelsScanned() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAllChannelsScanned", $$robo$$android_net_wifi_WifiScanner_ScanData$isAllChannelsScanned(), this);
        }

        public ScanResult[] getResults() {
            return InvokeDynamicSupport.bootstrap("getResults", $$robo$$android_net_wifi_WifiScanner_ScanData$getResults(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_ScanData$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_ScanData$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ScanData.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScanData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ScanSettings
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int band;
        public ChannelSpec[] channels;
        public HiddenNetwork[] hiddenNetworks;
        public int periodInMs;
        public int reportEvents;
        public int numBssidsPerScan;
        public int maxScansToCache;
        public int maxPeriodInMs;
        public int stepCount;
        public boolean isPnoScan;
        public static Parcelable.Creator<ScanSettings> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_ScanSettings$__constructor__() {
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ScanSettings$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_ScanSettings$writeToParcel(Parcel dest, int flags) {
            int i;
            dest.writeInt(this.band);
            dest.writeInt(this.periodInMs);
            dest.writeInt(this.reportEvents);
            dest.writeInt(this.numBssidsPerScan);
            dest.writeInt(this.maxScansToCache);
            dest.writeInt(this.maxPeriodInMs);
            dest.writeInt(this.stepCount);
            dest.writeInt(this.isPnoScan ? 1 : 0);
            if (this.channels != null) {
                dest.writeInt(this.channels.length);
                for (i = 0; i < this.channels.length; ++i) {
                    dest.writeInt(this.channels[i].frequency);
                    dest.writeInt(this.channels[i].dwellTimeMS);
                    dest.writeInt(this.channels[i].passive ? 1 : 0);
                }
            } else {
                dest.writeInt(0);
            }
            if (this.hiddenNetworks != null) {
                dest.writeInt(this.hiddenNetworks.length);
                for (i = 0; i < this.hiddenNetworks.length; ++i) {
                    dest.writeString(this.hiddenNetworks[i].ssid);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ScanSettings>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$__constructor__() {
                }

                private final ScanSettings $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$createFromParcel(Parcel in) {
                    ScanSettings settings = new ScanSettings();
                    settings.band = in.readInt();
                    settings.periodInMs = in.readInt();
                    settings.reportEvents = in.readInt();
                    settings.numBssidsPerScan = in.readInt();
                    settings.maxScansToCache = in.readInt();
                    settings.maxPeriodInMs = in.readInt();
                    settings.stepCount = in.readInt();
                    settings.isPnoScan = in.readInt() == 1;
                    int num_channels = in.readInt();
                    settings.channels = new ChannelSpec[num_channels];
                    for (int i = 0; i < num_channels; ++i) {
                        int frequency = in.readInt();
                        ChannelSpec spec = new ChannelSpec(frequency);
                        spec.dwellTimeMS = in.readInt();
                        spec.passive = in.readInt() == 1;
                        settings.channels[i] = spec;
                    }
                    int numNetworks = in.readInt();
                    settings.hiddenNetworks = new HiddenNetwork[numNetworks];
                    for (int i = 0; i < numNetworks; ++i) {
                        String ssid = in.readString();
                        settings.hiddenNetworks[i] = new HiddenNetwork(ssid);
                    }
                    return settings;
                }

                private final ScanSettings[] $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$newArray(int size) {
                    return new ScanSettings[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_ScanSettings_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$__constructor__(), this);
                }

                @Override
                public ScanSettings createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ScanSettings[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_ScanSettings$__constructor__();
        }

        public ScanSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanSettings$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_ScanSettings$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_ScanSettings$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ScanSettings.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScanSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class HiddenNetwork
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            public String ssid;

            private void $$robo$$android_net_wifi_WifiScanner_ScanSettings_HiddenNetwork$__constructor__(String ssid) {
                this.ssid = ssid;
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_net_wifi_WifiScanner_ScanSettings_HiddenNetwork$__constructor__(string2);
            }

            public HiddenNetwork(String string2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanSettings_HiddenNetwork$__constructor__(java.lang.String ), this, string2);
            }

            public /* synthetic */ HiddenNetwork() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HiddenNetwork)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class ChannelSpec
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int frequency;
        public boolean passive;
        public int dwellTimeMS;

        private void $$robo$$android_net_wifi_WifiScanner_ChannelSpec$__constructor__(int frequency) {
            this.frequency = frequency;
            this.passive = false;
            this.dwellTimeMS = 0;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_net_wifi_WifiScanner_ChannelSpec$__constructor__(n);
        }

        public ChannelSpec(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ChannelSpec$__constructor__(int ), this, n);
        }

        public /* synthetic */ ChannelSpec() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChannelSpec)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ActionListener
    extends InstrumentedInterface {
        public void onSuccess();

        public void onFailure(int var1, String var2);
    }
}

