/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructTimeval;
import android.util.Log;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetlinkSocket
implements Closeable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NetlinkSocket";
    private static int SOCKET_RECV_BUFSIZE = 65536;
    private static int DEFAULT_RECV_BUFSIZE = 8192;
    private FileDescriptor mDescriptor;
    private NetlinkSocketAddress mAddr;
    private long mLastRecvTimeoutMs;
    private long mLastSendTimeoutMs;

    private void $$robo$$android_net_netlink_NetlinkSocket$__constructor__(int nlProto) throws ErrnoException {
        this.mDescriptor = Os.socket(OsConstants.AF_NETLINK, OsConstants.SOCK_DGRAM, nlProto);
        Libcore.os.setsockoptInt(this.mDescriptor, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, 65536);
    }

    private final NetlinkSocketAddress $$robo$$android_net_netlink_NetlinkSocket$getLocalAddress() throws ErrnoException {
        return (NetlinkSocketAddress)Os.getsockname(this.mDescriptor);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$bind(NetlinkSocketAddress localAddr) throws ErrnoException, SocketException {
        Os.bind(this.mDescriptor, localAddr);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$connectTo(NetlinkSocketAddress peerAddr) throws ErrnoException, SocketException {
        Os.connect(this.mDescriptor, peerAddr);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$connectToKernel() throws ErrnoException, SocketException {
        this.connectTo(new NetlinkSocketAddress(0, 0));
    }

    private final ByteBuffer $$robo$$android_net_netlink_NetlinkSocket$recvMessage() throws ErrnoException, InterruptedIOException {
        return this.recvMessage(8192, 0L);
    }

    private final ByteBuffer $$robo$$android_net_netlink_NetlinkSocket$recvMessage(long timeoutMs) throws ErrnoException, InterruptedIOException {
        return this.recvMessage(8192, timeoutMs);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$checkTimeout(long timeoutMs) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Negative timeouts not permitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer $$robo$$android_net_netlink_NetlinkSocket$recvMessage(int bufsize, long timeoutMs) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        this.checkTimeout(timeoutMs);
        FileDescriptor fileDescriptor = this.mDescriptor;
        synchronized (fileDescriptor) {
            if (this.mLastRecvTimeoutMs != timeoutMs) {
                Os.setsockoptTimeval(this.mDescriptor, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, StructTimeval.fromMillis(timeoutMs));
                this.mLastRecvTimeoutMs = timeoutMs;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufsize);
        int length = Os.read(this.mDescriptor, byteBuffer);
        if (length == bufsize) {
            Log.w("NetlinkSocket", "maximum read");
        }
        byteBuffer.position(0);
        byteBuffer.limit(length);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    private final boolean $$robo$$android_net_netlink_NetlinkSocket$sendMessage(byte[] bytes, int offset, int count) throws ErrnoException, InterruptedIOException {
        return this.sendMessage(bytes, offset, count, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_netlink_NetlinkSocket$sendMessage(byte[] bytes, int offset, int count, long timeoutMs) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        this.checkTimeout(timeoutMs);
        FileDescriptor fileDescriptor = this.mDescriptor;
        synchronized (fileDescriptor) {
            if (this.mLastSendTimeoutMs != timeoutMs) {
                Os.setsockoptTimeval(this.mDescriptor, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, StructTimeval.fromMillis(timeoutMs));
                this.mLastSendTimeoutMs = timeoutMs;
            }
        }
        return count == Os.write(this.mDescriptor, bytes, offset, count);
    }

    private final void $$robo$$android_net_netlink_NetlinkSocket$close() {
        IoUtils.closeQuietly(this.mDescriptor);
    }

    private void __constructor__(int n) throws ErrnoException {
        this.$$robo$$android_net_netlink_NetlinkSocket$__constructor__(n);
    }

    public NetlinkSocket(int n) throws ErrnoException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_netlink_NetlinkSocket$__constructor__(int ), this, n);
    }

    public NetlinkSocketAddress getLocalAddress() throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("getLocalAddress", $$robo$$android_net_netlink_NetlinkSocket$getLocalAddress(), this);
    }

    public void bind(NetlinkSocketAddress netlinkSocketAddress) throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrap("bind", $$robo$$android_net_netlink_NetlinkSocket$bind(android.system.NetlinkSocketAddress ), this, netlinkSocketAddress);
    }

    public void connectTo(NetlinkSocketAddress netlinkSocketAddress) throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrap("connectTo", $$robo$$android_net_netlink_NetlinkSocket$connectTo(android.system.NetlinkSocketAddress ), this, netlinkSocketAddress);
    }

    public void connectToKernel() throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrap("connectToKernel", $$robo$$android_net_netlink_NetlinkSocket$connectToKernel(), this);
    }

    public ByteBuffer recvMessage() throws ErrnoException, InterruptedIOException {
        return InvokeDynamicSupport.bootstrap("recvMessage", $$robo$$android_net_netlink_NetlinkSocket$recvMessage(), this);
    }

    public ByteBuffer recvMessage(long l) throws ErrnoException, InterruptedIOException {
        return InvokeDynamicSupport.bootstrap("recvMessage", $$robo$$android_net_netlink_NetlinkSocket$recvMessage(long ), this, l);
    }

    private void checkTimeout(long l) {
        InvokeDynamicSupport.bootstrap("checkTimeout", $$robo$$android_net_netlink_NetlinkSocket$checkTimeout(long ), this, l);
    }

    public ByteBuffer recvMessage(int n, long l) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        return InvokeDynamicSupport.bootstrap("recvMessage", $$robo$$android_net_netlink_NetlinkSocket$recvMessage(int long ), this, n, l);
    }

    public boolean sendMessage(byte[] byArray, int n, int n2) throws ErrnoException, InterruptedIOException {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_net_netlink_NetlinkSocket$sendMessage(byte[] int int ), this, byArray, n, n2);
    }

    public boolean sendMessage(byte[] byArray, int n, int n2, long l) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_net_netlink_NetlinkSocket$sendMessage(byte[] int int long ), this, byArray, n, n2, l);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_netlink_NetlinkSocket$close(), this);
    }

    public /* synthetic */ NetlinkSocket() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetlinkSocket)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

