/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.security.net.config.UserCertificateSource;
import com.android.org.conscrypt.TrustManagerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class X509TrustManagerExtensions
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private TrustManagerImpl mDelegate;
    private X509TrustManager mTrustManager;
    private Method mCheckServerTrusted;
    private Method mIsSameTrustConfiguration;

    private void $$robo$$android_net_http_X509TrustManagerExtensions$__constructor__(X509TrustManager tm) throws IllegalArgumentException {
        if (tm instanceof TrustManagerImpl) {
            this.mDelegate = (TrustManagerImpl)tm;
            this.mTrustManager = null;
            this.mCheckServerTrusted = null;
            this.mIsSameTrustConfiguration = null;
            return;
        }
        this.mDelegate = null;
        this.mTrustManager = tm;
        try {
            this.mCheckServerTrusted = tm.getClass().getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Required method checkServerTrusted(X509Certificate[], String, String, String) missing");
        }
        Method isSameTrustConfiguration = null;
        try {
            isSameTrustConfiguration = tm.getClass().getMethod("isSameTrustConfiguration", String.class, String.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        this.mIsSameTrustConfiguration = isSameTrustConfiguration;
    }

    private final List<X509Certificate> $$robo$$android_net_http_X509TrustManagerExtensions$checkServerTrusted(X509Certificate[] chain, String authType, String host) throws CertificateException {
        if (this.mDelegate != null) {
            return this.mDelegate.checkServerTrusted(chain, authType, host);
        }
        try {
            return (List)this.mCheckServerTrusted.invoke((Object)this.mTrustManager, chain, authType, host);
        }
        catch (IllegalAccessException e) {
            throw new CertificateException("Failed to call checkServerTrusted", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CertificateException) {
                throw (CertificateException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new CertificateException("checkServerTrusted failed", e.getCause());
        }
    }

    private final boolean $$robo$$android_net_http_X509TrustManagerExtensions$isUserAddedCertificate(X509Certificate cert) {
        return UserCertificateSource.getInstance().findBySubjectAndPublicKey(cert) != null;
    }

    private final boolean $$robo$$android_net_http_X509TrustManagerExtensions$isSameTrustConfiguration(String hostname1, String hostname2) {
        if (this.mIsSameTrustConfiguration == null) {
            return true;
        }
        try {
            return (Boolean)this.mIsSameTrustConfiguration.invoke((Object)this.mTrustManager, hostname1, hostname2);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to call isSameTrustConfiguration", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException("isSameTrustConfiguration failed", e.getCause());
        }
    }

    private void __constructor__(X509TrustManager x509TrustManager) throws IllegalArgumentException {
        this.$$robo$$android_net_http_X509TrustManagerExtensions$__constructor__(x509TrustManager);
    }

    public X509TrustManagerExtensions(X509TrustManager x509TrustManager) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_X509TrustManagerExtensions$__constructor__(javax.net.ssl.X509TrustManager ), this, x509TrustManager);
    }

    public List<X509Certificate> checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, String string3) throws CertificateException {
        return InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_net_http_X509TrustManagerExtensions$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String java.lang.String ), this, x509CertificateArray, string2, string3);
    }

    public boolean isUserAddedCertificate(X509Certificate x509Certificate) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAddedCertificate", $$robo$$android_net_http_X509TrustManagerExtensions$isUserAddedCertificate(java.security.cert.X509Certificate ), this, x509Certificate);
    }

    public boolean isSameTrustConfiguration(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSameTrustConfiguration", $$robo$$android_net_http_X509TrustManagerExtensions$isSameTrustConfiguration(java.lang.String java.lang.String ), this, string2, string3);
    }

    public /* synthetic */ X509TrustManagerExtensions() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (X509TrustManagerExtensions)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

