/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StaticIpConfiguration
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public LinkAddress ipAddress;
    public InetAddress gateway;
    public ArrayList<InetAddress> dnsServers;
    public String domains;
    public static Parcelable.Creator<StaticIpConfiguration> CREATOR;

    private void $$robo$$android_net_StaticIpConfiguration$__constructor__() {
        this.dnsServers = new ArrayList();
    }

    private void $$robo$$android_net_StaticIpConfiguration$__constructor__(StaticIpConfiguration source) {
        if (source != null) {
            this.ipAddress = source.ipAddress;
            this.gateway = source.gateway;
            this.dnsServers.addAll(source.dnsServers);
            this.domains = source.domains;
        }
    }

    private final void $$robo$$android_net_StaticIpConfiguration$clear() {
        this.ipAddress = null;
        this.gateway = null;
        this.dnsServers.clear();
        this.domains = null;
    }

    private final List<RouteInfo> $$robo$$android_net_StaticIpConfiguration$getRoutes(String iface) {
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>(3);
        if (this.ipAddress != null) {
            RouteInfo connectedRoute = new RouteInfo(this.ipAddress, null, iface);
            routes.add(connectedRoute);
            if (this.gateway != null && !connectedRoute.matches(this.gateway)) {
                routes.add(RouteInfo.makeHostRoute(this.gateway, iface));
            }
        }
        if (this.gateway != null) {
            routes.add(new RouteInfo((IpPrefix)null, this.gateway, iface));
        }
        return routes;
    }

    private final LinkProperties $$robo$$android_net_StaticIpConfiguration$toLinkProperties(String iface) {
        LinkProperties lp = new LinkProperties();
        lp.setInterfaceName(iface);
        if (this.ipAddress != null) {
            lp.addLinkAddress(this.ipAddress);
        }
        for (RouteInfo route : this.getRoutes(iface)) {
            lp.addRoute(route);
        }
        for (InetAddress dns : this.dnsServers) {
            lp.addDnsServer(dns);
        }
        lp.setDomains(this.domains);
        return lp;
    }

    private final String $$robo$$android_net_StaticIpConfiguration$toString() {
        StringBuffer str = new StringBuffer();
        str.append("IP address ");
        if (this.ipAddress != null) {
            str.append(this.ipAddress).append(" ");
        }
        str.append("Gateway ");
        if (this.gateway != null) {
            str.append(this.gateway.getHostAddress()).append(" ");
        }
        str.append(" DNS servers: [");
        for (InetAddress dnsServer : this.dnsServers) {
            str.append(" ").append(dnsServer.getHostAddress());
        }
        str.append(" ] Domains ");
        if (this.domains != null) {
            str.append(this.domains);
        }
        return str.toString();
    }

    private final int $$robo$$android_net_StaticIpConfiguration$hashCode() {
        int result = 13;
        result = 47 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 47 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 47 * result + (this.domains == null ? 0 : this.domains.hashCode());
        result = 47 * result + this.dnsServers.hashCode();
        return result;
    }

    private final boolean $$robo$$android_net_StaticIpConfiguration$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticIpConfiguration)) {
            return false;
        }
        StaticIpConfiguration other = (StaticIpConfiguration)obj;
        return other != null && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.gateway, other.gateway) && this.dnsServers.equals(other.dnsServers) && Objects.equals(this.domains, other.domains);
    }

    private final int $$robo$$android_net_StaticIpConfiguration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_StaticIpConfiguration$writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.ipAddress, flags);
        NetworkUtils.parcelInetAddress(dest, this.gateway, flags);
        dest.writeInt(this.dnsServers.size());
        for (InetAddress dnsServer : this.dnsServers) {
            NetworkUtils.parcelInetAddress(dest, dnsServer, flags);
        }
        dest.writeString(this.domains);
    }

    private static final void $$robo$$android_net_StaticIpConfiguration$readFromParcel(StaticIpConfiguration s, Parcel in) {
        s.ipAddress = (LinkAddress)in.readParcelable(null);
        s.gateway = NetworkUtils.unparcelInetAddress(in);
        s.dnsServers.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            s.dnsServers.add(NetworkUtils.unparcelInetAddress(in));
        }
        s.domains = in.readString();
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<StaticIpConfiguration>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_StaticIpConfiguration_1$__constructor__() {
            }

            private final StaticIpConfiguration $$robo$$android_net_StaticIpConfiguration_1$createFromParcel(Parcel in) {
                StaticIpConfiguration s = new StaticIpConfiguration();
                StaticIpConfiguration.readFromParcel(s, in);
                return s;
            }

            private final StaticIpConfiguration[] $$robo$$android_net_StaticIpConfiguration_1$newArray(int size) {
                return new StaticIpConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_StaticIpConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_StaticIpConfiguration_1$__constructor__(), this);
            }

            @Override
            public StaticIpConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_StaticIpConfiguration_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public StaticIpConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_StaticIpConfiguration_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_StaticIpConfiguration$__constructor__();
    }

    public StaticIpConfiguration() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_StaticIpConfiguration$__constructor__(), this);
    }

    private void __constructor__(StaticIpConfiguration staticIpConfiguration) {
        this.$$robo$$android_net_StaticIpConfiguration$__constructor__(staticIpConfiguration);
    }

    public StaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_StaticIpConfiguration$__constructor__(android.net.StaticIpConfiguration ), this, staticIpConfiguration);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_StaticIpConfiguration$clear(), this);
    }

    public List<RouteInfo> getRoutes(String string2) {
        return InvokeDynamicSupport.bootstrap("getRoutes", $$robo$$android_net_StaticIpConfiguration$getRoutes(java.lang.String ), this, string2);
    }

    public LinkProperties toLinkProperties(String string2) {
        return InvokeDynamicSupport.bootstrap("toLinkProperties", $$robo$$android_net_StaticIpConfiguration$toLinkProperties(java.lang.String ), this, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_StaticIpConfiguration$toString(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_StaticIpConfiguration$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_StaticIpConfiguration$equals(java.lang.Object ), this, object);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_StaticIpConfiguration$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_StaticIpConfiguration$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    protected static void readFromParcel(StaticIpConfiguration staticIpConfiguration, Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("readFromParcel", $$robo$$android_net_StaticIpConfiguration$readFromParcel(android.net.StaticIpConfiguration android.os.Parcel ), (StaticIpConfiguration)staticIpConfiguration, (Parcel)parcel);
    }

    static {
        RobolectricInternals.classInitializing(StaticIpConfiguration.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StaticIpConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

