/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkStats;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.MathUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ProtocolException;
import java.util.Arrays;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkStatsHistory
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int VERSION_INIT = 1;
    private static int VERSION_ADD_PACKETS = 2;
    private static int VERSION_ADD_ACTIVE = 3;
    public static int FIELD_ACTIVE_TIME = 1;
    public static int FIELD_RX_BYTES = 2;
    public static int FIELD_RX_PACKETS = 4;
    public static int FIELD_TX_BYTES = 8;
    public static int FIELD_TX_PACKETS = 16;
    public static int FIELD_OPERATIONS = 32;
    public static int FIELD_ALL = -1;
    private long bucketDuration;
    private int bucketCount;
    private long[] bucketStart;
    private long[] activeTime;
    private long[] rxBytes;
    private long[] rxPackets;
    private long[] txBytes;
    private long[] txPackets;
    private long[] operations;
    private long totalBytes;
    public static Parcelable.Creator<NetworkStatsHistory> CREATOR;

    private void $$robo$$android_net_NetworkStatsHistory$__constructor__(long bucketDuration) {
    }

    private void $$robo$$android_net_NetworkStatsHistory$__constructor__(long bucketDuration, int initialSize) {
    }

    private void $$robo$$android_net_NetworkStatsHistory$__constructor__(long bucketDuration, int initialSize, int fields) {
        this.bucketDuration = bucketDuration;
        this.bucketStart = new long[initialSize];
        if ((fields & 1) != 0) {
            this.activeTime = new long[initialSize];
        }
        if ((fields & 2) != 0) {
            this.rxBytes = new long[initialSize];
        }
        if ((fields & 4) != 0) {
            this.rxPackets = new long[initialSize];
        }
        if ((fields & 8) != 0) {
            this.txBytes = new long[initialSize];
        }
        if ((fields & 0x10) != 0) {
            this.txPackets = new long[initialSize];
        }
        if ((fields & 0x20) != 0) {
            this.operations = new long[initialSize];
        }
        this.bucketCount = 0;
        this.totalBytes = 0L;
    }

    private void $$robo$$android_net_NetworkStatsHistory$__constructor__(NetworkStatsHistory existing, long bucketDuration) {
        this.recordEntireHistory(existing);
    }

    private void $$robo$$android_net_NetworkStatsHistory$__constructor__(Parcel in) {
        this.bucketDuration = in.readLong();
        this.bucketStart = ParcelUtils.readLongArray(in);
        this.activeTime = ParcelUtils.readLongArray(in);
        this.rxBytes = ParcelUtils.readLongArray(in);
        this.rxPackets = ParcelUtils.readLongArray(in);
        this.txBytes = ParcelUtils.readLongArray(in);
        this.txPackets = ParcelUtils.readLongArray(in);
        this.operations = ParcelUtils.readLongArray(in);
        this.bucketCount = this.bucketStart.length;
        this.totalBytes = in.readLong();
    }

    private final void $$robo$$android_net_NetworkStatsHistory$writeToParcel(Parcel out, int flags) {
        out.writeLong(this.bucketDuration);
        ParcelUtils.writeLongArray(out, this.bucketStart, this.bucketCount);
        ParcelUtils.writeLongArray(out, this.activeTime, this.bucketCount);
        ParcelUtils.writeLongArray(out, this.rxBytes, this.bucketCount);
        ParcelUtils.writeLongArray(out, this.rxPackets, this.bucketCount);
        ParcelUtils.writeLongArray(out, this.txBytes, this.bucketCount);
        ParcelUtils.writeLongArray(out, this.txPackets, this.bucketCount);
        ParcelUtils.writeLongArray(out, this.operations, this.bucketCount);
        out.writeLong(this.totalBytes);
    }

    private void $$robo$$android_net_NetworkStatsHistory$__constructor__(DataInputStream in) throws IOException {
        int version = in.readInt();
        switch (version) {
            case 1: {
                this.bucketDuration = in.readLong();
                this.bucketStart = DataStreamUtils.readFullLongArray(in);
                this.rxBytes = DataStreamUtils.readFullLongArray(in);
                this.rxPackets = new long[this.bucketStart.length];
                this.txBytes = DataStreamUtils.readFullLongArray(in);
                this.txPackets = new long[this.bucketStart.length];
                this.operations = new long[this.bucketStart.length];
                this.bucketCount = this.bucketStart.length;
                this.totalBytes = ArrayUtils.total(this.rxBytes) + ArrayUtils.total(this.txBytes);
                break;
            }
            case 2: 
            case 3: {
                this.bucketDuration = in.readLong();
                this.bucketStart = DataStreamUtils.readVarLongArray(in);
                this.activeTime = version >= 3 ? DataStreamUtils.readVarLongArray(in) : new long[this.bucketStart.length];
                this.rxBytes = DataStreamUtils.readVarLongArray(in);
                this.rxPackets = DataStreamUtils.readVarLongArray(in);
                this.txBytes = DataStreamUtils.readVarLongArray(in);
                this.txPackets = DataStreamUtils.readVarLongArray(in);
                this.operations = DataStreamUtils.readVarLongArray(in);
                this.bucketCount = this.bucketStart.length;
                this.totalBytes = ArrayUtils.total(this.rxBytes) + ArrayUtils.total(this.txBytes);
                break;
            }
            default: {
                throw new ProtocolException("unexpected version: " + version);
            }
        }
        if (this.bucketStart.length != this.bucketCount || this.rxBytes.length != this.bucketCount || this.rxPackets.length != this.bucketCount || this.txBytes.length != this.bucketCount || this.txPackets.length != this.bucketCount || this.operations.length != this.bucketCount) {
            throw new ProtocolException("Mismatched history lengths");
        }
    }

    private final void $$robo$$android_net_NetworkStatsHistory$writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeLong(this.bucketDuration);
        DataStreamUtils.writeVarLongArray(out, this.bucketStart, this.bucketCount);
        DataStreamUtils.writeVarLongArray(out, this.activeTime, this.bucketCount);
        DataStreamUtils.writeVarLongArray(out, this.rxBytes, this.bucketCount);
        DataStreamUtils.writeVarLongArray(out, this.rxPackets, this.bucketCount);
        DataStreamUtils.writeVarLongArray(out, this.txBytes, this.bucketCount);
        DataStreamUtils.writeVarLongArray(out, this.txPackets, this.bucketCount);
        DataStreamUtils.writeVarLongArray(out, this.operations, this.bucketCount);
    }

    private final int $$robo$$android_net_NetworkStatsHistory$describeContents() {
        return 0;
    }

    private final int $$robo$$android_net_NetworkStatsHistory$size() {
        return this.bucketCount;
    }

    private final long $$robo$$android_net_NetworkStatsHistory$getBucketDuration() {
        return this.bucketDuration;
    }

    private final long $$robo$$android_net_NetworkStatsHistory$getStart() {
        if (this.bucketCount > 0) {
            return this.bucketStart[0];
        }
        return Long.MAX_VALUE;
    }

    private final long $$robo$$android_net_NetworkStatsHistory$getEnd() {
        if (this.bucketCount > 0) {
            return this.bucketStart[this.bucketCount - 1] + this.bucketDuration;
        }
        return Long.MIN_VALUE;
    }

    private final long $$robo$$android_net_NetworkStatsHistory$getTotalBytes() {
        return this.totalBytes;
    }

    private final int $$robo$$android_net_NetworkStatsHistory$getIndexBefore(long time) {
        int index = Arrays.binarySearch(this.bucketStart, 0, this.bucketCount, time);
        index = index < 0 ? ~index - 1 : --index;
        return MathUtils.constrain(index, 0, this.bucketCount - 1);
    }

    private final int $$robo$$android_net_NetworkStatsHistory$getIndexAfter(long time) {
        int index = Arrays.binarySearch(this.bucketStart, 0, this.bucketCount, time);
        index = index < 0 ? (index ^= 0xFFFFFFFF) : ++index;
        return MathUtils.constrain(index, 0, this.bucketCount - 1);
    }

    private final Entry $$robo$$android_net_NetworkStatsHistory$getValues(int i, Entry recycle) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.bucketStart = this.bucketStart[i];
        entry.bucketDuration = this.bucketDuration;
        entry.activeTime = NetworkStatsHistory.getLong(this.activeTime, i, -1L);
        entry.rxBytes = NetworkStatsHistory.getLong(this.rxBytes, i, -1L);
        entry.rxPackets = NetworkStatsHistory.getLong(this.rxPackets, i, -1L);
        entry.txBytes = NetworkStatsHistory.getLong(this.txBytes, i, -1L);
        entry.txPackets = NetworkStatsHistory.getLong(this.txPackets, i, -1L);
        entry.operations = NetworkStatsHistory.getLong(this.operations, i, -1L);
        return entry;
    }

    @Deprecated
    private final void $$robo$$android_net_NetworkStatsHistory$recordData(long start, long end, long rxBytes, long txBytes) {
        this.recordData(start, end, new NetworkStats.Entry(NetworkStats.IFACE_ALL, -1, 0, 0, rxBytes, 0L, txBytes, 0L, 0L));
    }

    private final void $$robo$$android_net_NetworkStatsHistory$recordData(long start, long end, NetworkStats.Entry entry) {
        int startIndex;
        long curStart;
        long curEnd;
        long rxBytes = entry.rxBytes;
        long rxPackets = entry.rxPackets;
        long txBytes = entry.txBytes;
        long txPackets = entry.txPackets;
        long operations = entry.operations;
        if (entry.isNegative()) {
            throw new IllegalArgumentException("tried recording negative data");
        }
        if (entry.isEmpty()) {
            return;
        }
        this.ensureBuckets(start, end);
        long duration = end - start;
        for (int i = startIndex = this.getIndexAfter(end); i >= 0 && (curEnd = (curStart = this.bucketStart[i]) + this.bucketDuration) >= start; --i) {
            long overlap;
            if (curStart > end || (overlap = Math.min(curEnd, end) - Math.max(curStart, start)) <= 0L) continue;
            long fracRxBytes = rxBytes * overlap / duration;
            long fracRxPackets = rxPackets * overlap / duration;
            long fracTxBytes = txBytes * overlap / duration;
            long fracTxPackets = txPackets * overlap / duration;
            long fracOperations = operations * overlap / duration;
            NetworkStatsHistory.addLong(this.activeTime, i, overlap);
            NetworkStatsHistory.addLong(this.rxBytes, i, fracRxBytes);
            rxBytes -= fracRxBytes;
            NetworkStatsHistory.addLong(this.rxPackets, i, fracRxPackets);
            rxPackets -= fracRxPackets;
            NetworkStatsHistory.addLong(this.txBytes, i, fracTxBytes);
            txBytes -= fracTxBytes;
            NetworkStatsHistory.addLong(this.txPackets, i, fracTxPackets);
            txPackets -= fracTxPackets;
            NetworkStatsHistory.addLong(this.operations, i, fracOperations);
            operations -= fracOperations;
            duration -= overlap;
        }
        this.totalBytes += entry.rxBytes + entry.txBytes;
    }

    private final void $$robo$$android_net_NetworkStatsHistory$recordEntireHistory(NetworkStatsHistory input) {
        this.recordHistory(input, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private final void $$robo$$android_net_NetworkStatsHistory$recordHistory(NetworkStatsHistory input, long start, long end) {
        NetworkStats.Entry entry = new NetworkStats.Entry(NetworkStats.IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
        for (int i = 0; i < input.bucketCount; ++i) {
            long bucketStart = input.bucketStart[i];
            long bucketEnd = bucketStart + input.bucketDuration;
            if (bucketStart < start || bucketEnd > end) continue;
            entry.rxBytes = NetworkStatsHistory.getLong(input.rxBytes, i, 0L);
            entry.rxPackets = NetworkStatsHistory.getLong(input.rxPackets, i, 0L);
            entry.txBytes = NetworkStatsHistory.getLong(input.txBytes, i, 0L);
            entry.txPackets = NetworkStatsHistory.getLong(input.txPackets, i, 0L);
            entry.operations = NetworkStatsHistory.getLong(input.operations, i, 0L);
            this.recordData(bucketStart, bucketEnd, entry);
        }
    }

    private final void $$robo$$android_net_NetworkStatsHistory$ensureBuckets(long start, long end) {
        start -= start % this.bucketDuration;
        end += (this.bucketDuration - end % this.bucketDuration) % this.bucketDuration;
        for (long now = start; now < end; now += this.bucketDuration) {
            int index = Arrays.binarySearch(this.bucketStart, 0, this.bucketCount, now);
            if (index >= 0) continue;
            this.insertBucket(~index, now);
        }
    }

    private final void $$robo$$android_net_NetworkStatsHistory$insertBucket(int index, long start) {
        if (this.bucketCount >= this.bucketStart.length) {
            int newLength = Math.max(this.bucketStart.length, 10) * 3 / 2;
            this.bucketStart = Arrays.copyOf(this.bucketStart, newLength);
            if (this.activeTime != null) {
                this.activeTime = Arrays.copyOf(this.activeTime, newLength);
            }
            if (this.rxBytes != null) {
                this.rxBytes = Arrays.copyOf(this.rxBytes, newLength);
            }
            if (this.rxPackets != null) {
                this.rxPackets = Arrays.copyOf(this.rxPackets, newLength);
            }
            if (this.txBytes != null) {
                this.txBytes = Arrays.copyOf(this.txBytes, newLength);
            }
            if (this.txPackets != null) {
                this.txPackets = Arrays.copyOf(this.txPackets, newLength);
            }
            if (this.operations != null) {
                this.operations = Arrays.copyOf(this.operations, newLength);
            }
        }
        if (index < this.bucketCount) {
            int dstPos = index + 1;
            int length = this.bucketCount - index;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.bucketStart, (int)index, (long[])this.bucketStart, (int)dstPos, (int)length);
            if (this.activeTime != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.activeTime, (int)index, (long[])this.activeTime, (int)dstPos, (int)length);
            }
            if (this.rxBytes != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.rxBytes, (int)index, (long[])this.rxBytes, (int)dstPos, (int)length);
            }
            if (this.rxPackets != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.rxPackets, (int)index, (long[])this.rxPackets, (int)dstPos, (int)length);
            }
            if (this.txBytes != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.txBytes, (int)index, (long[])this.txBytes, (int)dstPos, (int)length);
            }
            if (this.txPackets != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.txPackets, (int)index, (long[])this.txPackets, (int)dstPos, (int)length);
            }
            if (this.operations != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.operations, (int)index, (long[])this.operations, (int)dstPos, (int)length);
            }
        }
        this.bucketStart[index] = start;
        NetworkStatsHistory.setLong(this.activeTime, index, 0L);
        NetworkStatsHistory.setLong(this.rxBytes, index, 0L);
        NetworkStatsHistory.setLong(this.rxPackets, index, 0L);
        NetworkStatsHistory.setLong(this.txBytes, index, 0L);
        NetworkStatsHistory.setLong(this.txPackets, index, 0L);
        NetworkStatsHistory.setLong(this.operations, index, 0L);
        ++this.bucketCount;
    }

    @Deprecated
    private final void $$robo$$android_net_NetworkStatsHistory$removeBucketsBefore(long cutoff) {
        long curStart;
        long curEnd;
        int i;
        for (i = 0; i < this.bucketCount && (curEnd = (curStart = this.bucketStart[i]) + this.bucketDuration) <= cutoff; ++i) {
        }
        if (i > 0) {
            int length = this.bucketStart.length;
            this.bucketStart = Arrays.copyOfRange(this.bucketStart, i, length);
            if (this.activeTime != null) {
                this.activeTime = Arrays.copyOfRange(this.activeTime, i, length);
            }
            if (this.rxBytes != null) {
                this.rxBytes = Arrays.copyOfRange(this.rxBytes, i, length);
            }
            if (this.rxPackets != null) {
                this.rxPackets = Arrays.copyOfRange(this.rxPackets, i, length);
            }
            if (this.txBytes != null) {
                this.txBytes = Arrays.copyOfRange(this.txBytes, i, length);
            }
            if (this.txPackets != null) {
                this.txPackets = Arrays.copyOfRange(this.txPackets, i, length);
            }
            if (this.operations != null) {
                this.operations = Arrays.copyOfRange(this.operations, i, length);
            }
            this.bucketCount -= i;
        }
    }

    private final Entry $$robo$$android_net_NetworkStatsHistory$getValues(long start, long end, Entry recycle) {
        return this.getValues(start, end, Long.MAX_VALUE, recycle);
    }

    private final Entry $$robo$$android_net_NetworkStatsHistory$getValues(long start, long end, long now, Entry recycle) {
        int startIndex;
        long curStart;
        long curEnd;
        Entry entry = recycle != null ? recycle : new Entry();
        entry.bucketDuration = end - start;
        entry.bucketStart = start;
        entry.activeTime = this.activeTime != null ? 0L : -1L;
        entry.rxBytes = this.rxBytes != null ? 0L : -1L;
        entry.rxPackets = this.rxPackets != null ? 0L : -1L;
        entry.txBytes = this.txBytes != null ? 0L : -1L;
        entry.txPackets = this.txPackets != null ? 0L : -1L;
        entry.operations = this.operations != null ? 0L : -1L;
        for (int i = startIndex = this.getIndexAfter(end); i >= 0 && (curEnd = (curStart = this.bucketStart[i]) + this.bucketDuration) > start; --i) {
            long overlap;
            boolean activeBucket;
            if (curStart >= end) continue;
            boolean bl = activeBucket = curStart < now && curEnd > now;
            if (activeBucket) {
                overlap = this.bucketDuration;
            } else {
                long overlapEnd = curEnd < end ? curEnd : end;
                long overlapStart = curStart > start ? curStart : start;
                overlap = overlapEnd - overlapStart;
            }
            if (overlap <= 0L) continue;
            if (this.activeTime != null) {
                entry.activeTime += this.activeTime[i] * overlap / this.bucketDuration;
            }
            if (this.rxBytes != null) {
                entry.rxBytes += this.rxBytes[i] * overlap / this.bucketDuration;
            }
            if (this.rxPackets != null) {
                entry.rxPackets += this.rxPackets[i] * overlap / this.bucketDuration;
            }
            if (this.txBytes != null) {
                entry.txBytes += this.txBytes[i] * overlap / this.bucketDuration;
            }
            if (this.txPackets != null) {
                entry.txPackets += this.txPackets[i] * overlap / this.bucketDuration;
            }
            if (this.operations == null) continue;
            entry.operations += this.operations[i] * overlap / this.bucketDuration;
        }
        return entry;
    }

    @Deprecated
    private final void $$robo$$android_net_NetworkStatsHistory$generateRandom(long start, long end, long bytes) {
        Random r = new Random();
        float fractionRx = r.nextFloat();
        long rxBytes = (long)((float)bytes * fractionRx);
        long txBytes = (long)((float)bytes * (1.0f - fractionRx));
        long rxPackets = rxBytes / 1024L;
        long txPackets = txBytes / 1024L;
        long operations = rxBytes / 2048L;
        this.generateRandom(start, end, rxBytes, rxPackets, txBytes, txPackets, operations, r);
    }

    @Deprecated
    private final void $$robo$$android_net_NetworkStatsHistory$generateRandom(long start, long end, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations, Random r) {
        this.ensureBuckets(start, end);
        NetworkStats.Entry entry = new NetworkStats.Entry(NetworkStats.IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
        while (rxBytes > 1024L || rxPackets > 128L || txBytes > 1024L || txPackets > 128L || operations > 32L) {
            long curStart = NetworkStatsHistory.randomLong(r, start, end);
            long curEnd = curStart + NetworkStatsHistory.randomLong(r, 0L, (end - curStart) / 2L);
            entry.rxBytes = NetworkStatsHistory.randomLong(r, 0L, rxBytes);
            entry.rxPackets = NetworkStatsHistory.randomLong(r, 0L, rxPackets);
            entry.txBytes = NetworkStatsHistory.randomLong(r, 0L, txBytes);
            entry.txPackets = NetworkStatsHistory.randomLong(r, 0L, txPackets);
            entry.operations = NetworkStatsHistory.randomLong(r, 0L, operations);
            rxBytes -= entry.rxBytes;
            rxPackets -= entry.rxPackets;
            txBytes -= entry.txBytes;
            txPackets -= entry.txPackets;
            operations -= entry.operations;
            this.recordData(curStart, curEnd, entry);
        }
    }

    private static final long $$robo$$android_net_NetworkStatsHistory$randomLong(Random r, long start, long end) {
        return (long)((float)start + r.nextFloat() * (float)(end - start));
    }

    private final boolean $$robo$$android_net_NetworkStatsHistory$intersects(long start, long end) {
        long dataStart = this.getStart();
        long dataEnd = this.getEnd();
        if (start >= dataStart && start <= dataEnd) {
            return true;
        }
        if (end >= dataStart && end <= dataEnd) {
            return true;
        }
        if (dataStart >= start && dataStart <= end) {
            return true;
        }
        return dataEnd >= start && dataEnd <= end;
    }

    private final void $$robo$$android_net_NetworkStatsHistory$dump(IndentingPrintWriter pw, boolean fullHistory) {
        int start;
        pw.print("NetworkStatsHistory: bucketDuration=");
        pw.println(this.bucketDuration / 1000L);
        pw.increaseIndent();
        int n = start = fullHistory ? 0 : Math.max(0, this.bucketCount - 32);
        if (start > 0) {
            pw.print("(omitting ");
            pw.print(start);
            pw.println(" buckets)");
        }
        for (int i = start; i < this.bucketCount; ++i) {
            pw.print("st=");
            pw.print(this.bucketStart[i] / 1000L);
            if (this.rxBytes != null) {
                pw.print(" rb=");
                pw.print(this.rxBytes[i]);
            }
            if (this.rxPackets != null) {
                pw.print(" rp=");
                pw.print(this.rxPackets[i]);
            }
            if (this.txBytes != null) {
                pw.print(" tb=");
                pw.print(this.txBytes[i]);
            }
            if (this.txPackets != null) {
                pw.print(" tp=");
                pw.print(this.txPackets[i]);
            }
            if (this.operations != null) {
                pw.print(" op=");
                pw.print(this.operations[i]);
            }
            pw.println();
        }
        pw.decreaseIndent();
    }

    private final void $$robo$$android_net_NetworkStatsHistory$dumpCheckin(PrintWriter pw) {
        pw.print("d,");
        pw.print(this.bucketDuration / 1000L);
        pw.println();
        for (int i = 0; i < this.bucketCount; ++i) {
            pw.print("b,");
            pw.print(this.bucketStart[i] / 1000L);
            pw.print(',');
            if (this.rxBytes != null) {
                pw.print(this.rxBytes[i]);
            } else {
                pw.print("*");
            }
            pw.print(',');
            if (this.rxPackets != null) {
                pw.print(this.rxPackets[i]);
            } else {
                pw.print("*");
            }
            pw.print(',');
            if (this.txBytes != null) {
                pw.print(this.txBytes[i]);
            } else {
                pw.print("*");
            }
            pw.print(',');
            if (this.txPackets != null) {
                pw.print(this.txPackets[i]);
            } else {
                pw.print("*");
            }
            pw.print(',');
            if (this.operations != null) {
                pw.print(this.operations[i]);
            } else {
                pw.print("*");
            }
            pw.println();
        }
    }

    private final void $$robo$$android_net_NetworkStatsHistory$writeToProto(ProtoOutputStream proto, long tag) {
        long start = proto.start(tag);
        proto.write(0x10400000001L, this.bucketDuration);
        for (int i = 0; i < this.bucketCount; ++i) {
            long startBucket = proto.start(0x21100000002L);
            proto.write(0x10400000001L, this.bucketStart[i]);
            NetworkStatsHistory.writeToProto(proto, 1116691496962L, this.rxBytes, i);
            NetworkStatsHistory.writeToProto(proto, 1116691496963L, this.rxPackets, i);
            NetworkStatsHistory.writeToProto(proto, 0x10400000004L, this.txBytes, i);
            NetworkStatsHistory.writeToProto(proto, 1116691496965L, this.txPackets, i);
            NetworkStatsHistory.writeToProto(proto, 1116691496966L, this.operations, i);
            proto.end(startBucket);
        }
        proto.end(start);
    }

    private static final void $$robo$$android_net_NetworkStatsHistory$writeToProto(ProtoOutputStream proto, long tag, long[] array2, int index) {
        if (array2 != null) {
            proto.write(tag, array2[index]);
        }
    }

    private final String $$robo$$android_net_NetworkStatsHistory$toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter((Writer)writer, "  "), false);
        return writer.toString();
    }

    private static final long $$robo$$android_net_NetworkStatsHistory$getLong(long[] array2, int i, long value) {
        return array2 != null ? array2[i] : value;
    }

    private static final void $$robo$$android_net_NetworkStatsHistory$setLong(long[] array2, int i, long value) {
        if (array2 != null) {
            array2[i] = value;
        }
    }

    private static final void $$robo$$android_net_NetworkStatsHistory$addLong(long[] array2, int i, long value) {
        if (array2 != null) {
            int n = i;
            array2[n] = array2[n] + value;
        }
    }

    private final int $$robo$$android_net_NetworkStatsHistory$estimateResizeBuckets(long newBucketDuration) {
        return (int)((long)this.size() * this.getBucketDuration() / newBucketDuration);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<NetworkStatsHistory>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkStatsHistory_1$__constructor__() {
            }

            private final NetworkStatsHistory $$robo$$android_net_NetworkStatsHistory_1$createFromParcel(Parcel in) {
                return new NetworkStatsHistory(in);
            }

            private final NetworkStatsHistory[] $$robo$$android_net_NetworkStatsHistory_1$newArray(int size) {
                return new NetworkStatsHistory[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkStatsHistory_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory_1$__constructor__(), this);
            }

            @Override
            public NetworkStatsHistory createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkStatsHistory_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public NetworkStatsHistory[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkStatsHistory_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(long l) {
        this.$$robo$$android_net_NetworkStatsHistory$__constructor__(l);
    }

    public NetworkStatsHistory(long l) {
        this(l, 10, -1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory$__constructor__(long ), this, l);
    }

    private void __constructor__(long l, int n) {
        this.$$robo$$android_net_NetworkStatsHistory$__constructor__(l, n);
    }

    public NetworkStatsHistory(long l, int n) {
        this(l, n, -1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory$__constructor__(long int ), this, l, n);
    }

    private void __constructor__(long l, int n, int n2) {
        this.$$robo$$android_net_NetworkStatsHistory$__constructor__(l, n, n2);
    }

    public NetworkStatsHistory(long l, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory$__constructor__(long int int ), this, l, n, n2);
    }

    private void __constructor__(NetworkStatsHistory networkStatsHistory, long l) {
        this.$$robo$$android_net_NetworkStatsHistory$__constructor__(networkStatsHistory, l);
    }

    public NetworkStatsHistory(NetworkStatsHistory networkStatsHistory, long l) {
        this(l, networkStatsHistory.estimateResizeBuckets(l));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory$__constructor__(android.net.NetworkStatsHistory long ), this, networkStatsHistory, l);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_net_NetworkStatsHistory$__constructor__(parcel);
    }

    public NetworkStatsHistory(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkStatsHistory$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(DataInputStream dataInputStream) throws IOException {
        this.$$robo$$android_net_NetworkStatsHistory$__constructor__(dataInputStream);
    }

    public NetworkStatsHistory(DataInputStream dataInputStream) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory$__constructor__(java.io.DataInputStream ), this, dataInputStream);
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeToStream", $$robo$$android_net_NetworkStatsHistory$writeToStream(java.io.DataOutputStream ), this, dataOutputStream);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkStatsHistory$describeContents(), this);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_net_NetworkStatsHistory$size(), this);
    }

    public long getBucketDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getBucketDuration", $$robo$$android_net_NetworkStatsHistory$getBucketDuration(), this);
    }

    public long getStart() {
        return (long)InvokeDynamicSupport.bootstrap("getStart", $$robo$$android_net_NetworkStatsHistory$getStart(), this);
    }

    public long getEnd() {
        return (long)InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_net_NetworkStatsHistory$getEnd(), this);
    }

    public long getTotalBytes() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalBytes", $$robo$$android_net_NetworkStatsHistory$getTotalBytes(), this);
    }

    public int getIndexBefore(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getIndexBefore", $$robo$$android_net_NetworkStatsHistory$getIndexBefore(long ), this, l);
    }

    public int getIndexAfter(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getIndexAfter", $$robo$$android_net_NetworkStatsHistory$getIndexAfter(long ), this, l);
    }

    public Entry getValues(int n, Entry entry) {
        return InvokeDynamicSupport.bootstrap("getValues", $$robo$$android_net_NetworkStatsHistory$getValues(int android.net.NetworkStatsHistory$Entry ), this, n, entry);
    }

    @Deprecated
    public void recordData(long l, long l2, long l3, long l4) {
        InvokeDynamicSupport.bootstrap("recordData", $$robo$$android_net_NetworkStatsHistory$recordData(long long long long ), this, l, l2, l3, l4);
    }

    public void recordData(long l, long l2, NetworkStats.Entry entry) {
        InvokeDynamicSupport.bootstrap("recordData", $$robo$$android_net_NetworkStatsHistory$recordData(long long android.net.NetworkStats$Entry ), this, l, l2, entry);
    }

    public void recordEntireHistory(NetworkStatsHistory networkStatsHistory) {
        InvokeDynamicSupport.bootstrap("recordEntireHistory", $$robo$$android_net_NetworkStatsHistory$recordEntireHistory(android.net.NetworkStatsHistory ), this, networkStatsHistory);
    }

    public void recordHistory(NetworkStatsHistory networkStatsHistory, long l, long l2) {
        InvokeDynamicSupport.bootstrap("recordHistory", $$robo$$android_net_NetworkStatsHistory$recordHistory(android.net.NetworkStatsHistory long long ), this, networkStatsHistory, l, l2);
    }

    private void ensureBuckets(long l, long l2) {
        InvokeDynamicSupport.bootstrap("ensureBuckets", $$robo$$android_net_NetworkStatsHistory$ensureBuckets(long long ), this, l, l2);
    }

    private void insertBucket(int n, long l) {
        InvokeDynamicSupport.bootstrap("insertBucket", $$robo$$android_net_NetworkStatsHistory$insertBucket(int long ), this, n, l);
    }

    @Deprecated
    public void removeBucketsBefore(long l) {
        InvokeDynamicSupport.bootstrap("removeBucketsBefore", $$robo$$android_net_NetworkStatsHistory$removeBucketsBefore(long ), this, l);
    }

    public Entry getValues(long l, long l2, Entry entry) {
        return InvokeDynamicSupport.bootstrap("getValues", $$robo$$android_net_NetworkStatsHistory$getValues(long long android.net.NetworkStatsHistory$Entry ), this, l, l2, entry);
    }

    public Entry getValues(long l, long l2, long l3, Entry entry) {
        return InvokeDynamicSupport.bootstrap("getValues", $$robo$$android_net_NetworkStatsHistory$getValues(long long long android.net.NetworkStatsHistory$Entry ), this, l, l2, l3, entry);
    }

    @Deprecated
    public void generateRandom(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrap("generateRandom", $$robo$$android_net_NetworkStatsHistory$generateRandom(long long long ), this, l, l2, l3);
    }

    @Deprecated
    public void generateRandom(long l, long l2, long l3, long l4, long l5, long l6, long l7, Random random) {
        InvokeDynamicSupport.bootstrap("generateRandom", $$robo$$android_net_NetworkStatsHistory$generateRandom(long long long long long long long java.util.Random ), this, l, l2, l3, l4, l5, l6, l7, random);
    }

    public static long randomLong(Random random, long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("randomLong", $$robo$$android_net_NetworkStatsHistory$randomLong(java.util.Random long long ), (Random)random, (long)l, (long)l2);
    }

    public boolean intersects(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrap("intersects", $$robo$$android_net_NetworkStatsHistory$intersects(long long ), this, l, l2);
    }

    public void dump(IndentingPrintWriter indentingPrintWriter, boolean bl) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_NetworkStatsHistory$dump(com.android.internal.util.IndentingPrintWriter boolean ), this, indentingPrintWriter, bl);
    }

    public void dumpCheckin(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpCheckin", $$robo$$android_net_NetworkStatsHistory$dumpCheckin(java.io.PrintWriter ), this, printWriter);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_net_NetworkStatsHistory$writeToProto(android.util.proto.ProtoOutputStream long ), this, protoOutputStream, l);
    }

    private static void writeToProto(ProtoOutputStream protoOutputStream, long l, long[] lArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("writeToProto", $$robo$$android_net_NetworkStatsHistory$writeToProto(android.util.proto.ProtoOutputStream long long[] int ), (ProtoOutputStream)protoOutputStream, (long)l, (long[])lArray, (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkStatsHistory$toString(), this);
    }

    private static long getLong(long[] lArray, int n, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getLong", $$robo$$android_net_NetworkStatsHistory$getLong(long[] int long ), (long[])lArray, (int)n, (long)l);
    }

    private static void setLong(long[] lArray, int n, long l) {
        InvokeDynamicSupport.bootstrapStatic("setLong", $$robo$$android_net_NetworkStatsHistory$setLong(long[] int long ), (long[])lArray, (int)n, (long)l);
    }

    private static void addLong(long[] lArray, int n, long l) {
        InvokeDynamicSupport.bootstrapStatic("addLong", $$robo$$android_net_NetworkStatsHistory$addLong(long[] int long ), (long[])lArray, (int)n, (long)l);
    }

    public int estimateResizeBuckets(long l) {
        return (int)InvokeDynamicSupport.bootstrap("estimateResizeBuckets", $$robo$$android_net_NetworkStatsHistory$estimateResizeBuckets(long ), this, l);
    }

    static {
        RobolectricInternals.classInitializing(NetworkStatsHistory.class);
    }

    public /* synthetic */ NetworkStatsHistory() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkStatsHistory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ParcelUtils
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_NetworkStatsHistory_ParcelUtils$__constructor__() {
        }

        private static final long[] $$robo$$android_net_NetworkStatsHistory_ParcelUtils$readLongArray(Parcel in) {
            int size = in.readInt();
            if (size == -1) {
                return null;
            }
            long[] values = new long[size];
            for (int i = 0; i < values.length; ++i) {
                values[i] = in.readLong();
            }
            return values;
        }

        private static final void $$robo$$android_net_NetworkStatsHistory_ParcelUtils$writeLongArray(Parcel out, long[] values, int size) {
            if (values == null) {
                out.writeInt(-1);
                return;
            }
            if (size > values.length) {
                throw new IllegalArgumentException("size larger than length");
            }
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                out.writeLong(values[i]);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_net_NetworkStatsHistory_ParcelUtils$__constructor__();
        }

        public ParcelUtils() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory_ParcelUtils$__constructor__(), this);
        }

        public static long[] readLongArray(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("readLongArray", $$robo$$android_net_NetworkStatsHistory_ParcelUtils$readLongArray(android.os.Parcel ), (Parcel)parcel);
        }

        public static void writeLongArray(Parcel parcel, long[] lArray, int n) {
            InvokeDynamicSupport.bootstrapStatic("writeLongArray", $$robo$$android_net_NetworkStatsHistory_ParcelUtils$writeLongArray(android.os.Parcel long[] int ), (Parcel)parcel, (long[])lArray, (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelUtils)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class DataStreamUtils
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$__constructor__() {
        }

        @Deprecated
        private static final long[] $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$readFullLongArray(DataInputStream in) throws IOException {
            int size = in.readInt();
            if (size < 0) {
                throw new ProtocolException("negative array size");
            }
            long[] values = new long[size];
            for (int i = 0; i < values.length; ++i) {
                values[i] = in.readLong();
            }
            return values;
        }

        private static final long $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$readVarLong(DataInputStream in) throws IOException {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = in.readByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw new ProtocolException("malformed long");
        }

        private static final void $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$writeVarLong(DataOutputStream out, long value) throws IOException {
            while (true) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    out.writeByte((int)value);
                    return;
                }
                out.writeByte((int)value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        private static final long[] $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$readVarLongArray(DataInputStream in) throws IOException {
            int size = in.readInt();
            if (size == -1) {
                return null;
            }
            if (size < 0) {
                throw new ProtocolException("negative array size");
            }
            long[] values = new long[size];
            for (int i = 0; i < values.length; ++i) {
                values[i] = DataStreamUtils.readVarLong(in);
            }
            return values;
        }

        private static final void $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$writeVarLongArray(DataOutputStream out, long[] values, int size) throws IOException {
            if (values == null) {
                out.writeInt(-1);
                return;
            }
            if (size > values.length) {
                throw new IllegalArgumentException("size larger than length");
            }
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                DataStreamUtils.writeVarLong(out, values[i]);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_net_NetworkStatsHistory_DataStreamUtils$__constructor__();
        }

        public DataStreamUtils() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$__constructor__(), this);
        }

        @Deprecated
        public static long[] readFullLongArray(DataInputStream dataInputStream) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("readFullLongArray", $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$readFullLongArray(java.io.DataInputStream ), (DataInputStream)dataInputStream);
        }

        public static long readVarLong(DataInputStream dataInputStream) throws IOException {
            return (long)InvokeDynamicSupport.bootstrapStatic("readVarLong", $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$readVarLong(java.io.DataInputStream ), (DataInputStream)dataInputStream);
        }

        public static void writeVarLong(DataOutputStream dataOutputStream, long l) throws IOException {
            InvokeDynamicSupport.bootstrapStatic("writeVarLong", $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$writeVarLong(java.io.DataOutputStream long ), (DataOutputStream)dataOutputStream, (long)l);
        }

        public static long[] readVarLongArray(DataInputStream dataInputStream) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("readVarLongArray", $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$readVarLongArray(java.io.DataInputStream ), (DataInputStream)dataInputStream);
        }

        public static void writeVarLongArray(DataOutputStream dataOutputStream, long[] lArray, int n) throws IOException {
            InvokeDynamicSupport.bootstrapStatic("writeVarLongArray", $$robo$$android_net_NetworkStatsHistory_DataStreamUtils$writeVarLongArray(java.io.DataOutputStream long[] int ), (DataOutputStream)dataOutputStream, (long[])lArray, (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataStreamUtils)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Entry
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static long UNKNOWN = -1L;
        public long bucketDuration;
        public long bucketStart;
        public long activeTime;
        public long rxBytes;
        public long rxPackets;
        public long txBytes;
        public long txPackets;
        public long operations;

        private void $$robo$$android_net_NetworkStatsHistory_Entry$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_NetworkStatsHistory_Entry$__constructor__();
        }

        public Entry() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStatsHistory_Entry$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

