/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseBooleanArray;
import com.android.internal.util.ArrayUtils;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkStats
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkStats";
    public static String IFACE_ALL;
    public static int UID_ALL = -1;
    public static int TAG_ALL = -1;
    public static int SET_ALL = -1;
    public static int SET_DEFAULT = 0;
    public static int SET_FOREGROUND = 1;
    public static int SET_DEBUG_START = 1000;
    public static int SET_DBG_VPN_IN = 1001;
    public static int SET_DBG_VPN_OUT = 1002;
    public static int TAG_NONE = 0;
    public static int METERED_ALL = -1;
    public static int METERED_NO = 0;
    public static int METERED_YES = 1;
    public static int ROAMING_ALL = -1;
    public static int ROAMING_NO = 0;
    public static int ROAMING_YES = 1;
    private long elapsedRealtime;
    private int size;
    private int capacity;
    private String[] iface;
    private int[] uid;
    private int[] set;
    private int[] tag;
    private int[] metered;
    private int[] roaming;
    private long[] rxBytes;
    private long[] rxPackets;
    private long[] txBytes;
    private long[] txPackets;
    private long[] operations;
    public static Parcelable.Creator<NetworkStats> CREATOR;

    private void $$robo$$android_net_NetworkStats$__constructor__(long elapsedRealtime, int initialSize) {
        this.elapsedRealtime = elapsedRealtime;
        this.size = 0;
        if (initialSize >= 0) {
            this.capacity = initialSize;
            this.iface = new String[initialSize];
            this.uid = new int[initialSize];
            this.set = new int[initialSize];
            this.tag = new int[initialSize];
            this.metered = new int[initialSize];
            this.roaming = new int[initialSize];
            this.rxBytes = new long[initialSize];
            this.rxPackets = new long[initialSize];
            this.txBytes = new long[initialSize];
            this.txPackets = new long[initialSize];
            this.operations = new long[initialSize];
        } else {
            this.capacity = 0;
            this.iface = EmptyArray.STRING;
            this.uid = EmptyArray.INT;
            this.set = EmptyArray.INT;
            this.tag = EmptyArray.INT;
            this.metered = EmptyArray.INT;
            this.roaming = EmptyArray.INT;
            this.rxBytes = EmptyArray.LONG;
            this.rxPackets = EmptyArray.LONG;
            this.txBytes = EmptyArray.LONG;
            this.txPackets = EmptyArray.LONG;
            this.operations = EmptyArray.LONG;
        }
    }

    private void $$robo$$android_net_NetworkStats$__constructor__(Parcel parcel) {
        this.elapsedRealtime = parcel.readLong();
        this.size = parcel.readInt();
        this.capacity = parcel.readInt();
        this.iface = parcel.createStringArray();
        this.uid = parcel.createIntArray();
        this.set = parcel.createIntArray();
        this.tag = parcel.createIntArray();
        this.metered = parcel.createIntArray();
        this.roaming = parcel.createIntArray();
        this.rxBytes = parcel.createLongArray();
        this.rxPackets = parcel.createLongArray();
        this.txBytes = parcel.createLongArray();
        this.txPackets = parcel.createLongArray();
        this.operations = parcel.createLongArray();
    }

    private final void $$robo$$android_net_NetworkStats$writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.elapsedRealtime);
        dest.writeInt(this.size);
        dest.writeInt(this.capacity);
        dest.writeStringArray(this.iface);
        dest.writeIntArray(this.uid);
        dest.writeIntArray(this.set);
        dest.writeIntArray(this.tag);
        dest.writeIntArray(this.metered);
        dest.writeIntArray(this.roaming);
        dest.writeLongArray(this.rxBytes);
        dest.writeLongArray(this.rxPackets);
        dest.writeLongArray(this.txBytes);
        dest.writeLongArray(this.txPackets);
        dest.writeLongArray(this.operations);
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$clone() {
        NetworkStats clone = new NetworkStats(this.elapsedRealtime, this.size);
        Entry entry = null;
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            clone.addValues(entry);
        }
        return clone;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$addIfaceValues(String iface, long rxBytes, long rxPackets, long txBytes, long txPackets) {
        return this.addValues(iface, -1, 0, 0, rxBytes, rxPackets, txBytes, txPackets, 0L);
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$addValues(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.addValues(new Entry(iface, uid, set, tag, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$addValues(String iface, int uid, int set, int tag, int metered, int roaming, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.addValues(new Entry(iface, uid, set, tag, metered, roaming, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$addValues(Entry entry) {
        if (this.size >= this.capacity) {
            int newLength = Math.max(this.size, 10) * 3 / 2;
            this.iface = Arrays.copyOf(this.iface, newLength);
            this.uid = Arrays.copyOf(this.uid, newLength);
            this.set = Arrays.copyOf(this.set, newLength);
            this.tag = Arrays.copyOf(this.tag, newLength);
            this.metered = Arrays.copyOf(this.metered, newLength);
            this.roaming = Arrays.copyOf(this.roaming, newLength);
            this.rxBytes = Arrays.copyOf(this.rxBytes, newLength);
            this.rxPackets = Arrays.copyOf(this.rxPackets, newLength);
            this.txBytes = Arrays.copyOf(this.txBytes, newLength);
            this.txPackets = Arrays.copyOf(this.txPackets, newLength);
            this.operations = Arrays.copyOf(this.operations, newLength);
            this.capacity = newLength;
        }
        this.iface[this.size] = entry.iface;
        this.uid[this.size] = entry.uid;
        this.set[this.size] = entry.set;
        this.tag[this.size] = entry.tag;
        this.metered[this.size] = entry.metered;
        this.roaming[this.size] = entry.roaming;
        this.rxBytes[this.size] = entry.rxBytes;
        this.rxPackets[this.size] = entry.rxPackets;
        this.txBytes[this.size] = entry.txBytes;
        this.txPackets[this.size] = entry.txPackets;
        this.operations[this.size] = entry.operations;
        ++this.size;
        return this;
    }

    private final Entry $$robo$$android_net_NetworkStats$getValues(int i, Entry recycle) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.iface = this.iface[i];
        entry.uid = this.uid[i];
        entry.set = this.set[i];
        entry.tag = this.tag[i];
        entry.metered = this.metered[i];
        entry.roaming = this.roaming[i];
        entry.rxBytes = this.rxBytes[i];
        entry.rxPackets = this.rxPackets[i];
        entry.txBytes = this.txBytes[i];
        entry.txPackets = this.txPackets[i];
        entry.operations = this.operations[i];
        return entry;
    }

    private final long $$robo$$android_net_NetworkStats$getElapsedRealtime() {
        return this.elapsedRealtime;
    }

    private final void $$robo$$android_net_NetworkStats$setElapsedRealtime(long time) {
        this.elapsedRealtime = time;
    }

    private final long $$robo$$android_net_NetworkStats$getElapsedRealtimeAge() {
        return SystemClock.elapsedRealtime() - this.elapsedRealtime;
    }

    private final int $$robo$$android_net_NetworkStats$size() {
        return this.size;
    }

    private final int $$robo$$android_net_NetworkStats$internalSize() {
        return this.capacity;
    }

    @Deprecated
    private final NetworkStats $$robo$$android_net_NetworkStats$combineValues(String iface, int uid, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.combineValues(iface, uid, 0, tag, rxBytes, rxPackets, txBytes, txPackets, operations);
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$combineValues(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.combineValues(new Entry(iface, uid, set, tag, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$combineValues(Entry entry) {
        int i = this.findIndex(entry.iface, entry.uid, entry.set, entry.tag, entry.metered, entry.roaming);
        if (i == -1) {
            this.addValues(entry);
        } else {
            int n = i;
            this.rxBytes[n] = this.rxBytes[n] + entry.rxBytes;
            int n2 = i;
            this.rxPackets[n2] = this.rxPackets[n2] + entry.rxPackets;
            int n3 = i;
            this.txBytes[n3] = this.txBytes[n3] + entry.txBytes;
            int n4 = i;
            this.txPackets[n4] = this.txPackets[n4] + entry.txPackets;
            int n5 = i;
            this.operations[n5] = this.operations[n5] + entry.operations;
        }
        return this;
    }

    private final void $$robo$$android_net_NetworkStats$combineAllValues(NetworkStats another) {
        Entry entry = null;
        for (int i = 0; i < another.size; ++i) {
            entry = another.getValues(i, entry);
            this.combineValues(entry);
        }
    }

    private final int $$robo$$android_net_NetworkStats$findIndex(String iface, int uid, int set, int tag, int metered, int roaming) {
        for (int i = 0; i < this.size; ++i) {
            if (uid != this.uid[i] || set != this.set[i] || tag != this.tag[i] || metered != this.metered[i] || roaming != this.roaming[i] || !Objects.equals(iface, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$android_net_NetworkStats$findIndexHinted(String iface, int uid, int set, int tag, int metered, int roaming, int hintIndex) {
        for (int offset = 0; offset < this.size; ++offset) {
            int halfOffset = offset / 2;
            int i = offset % 2 == 0 ? (hintIndex + halfOffset) % this.size : (this.size + hintIndex - halfOffset - 1) % this.size;
            if (uid != this.uid[i] || set != this.set[i] || tag != this.tag[i] || metered != this.metered[i] || roaming != this.roaming[i] || !Objects.equals(iface, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_net_NetworkStats$spliceOperationsFrom(NetworkStats stats) {
        for (int i = 0; i < this.size; ++i) {
            int j = stats.findIndex(this.iface[i], this.uid[i], this.set[i], this.tag[i], this.metered[i], this.roaming[i]);
            this.operations[i] = j == -1 ? 0L : stats.operations[j];
        }
    }

    private final String[] $$robo$$android_net_NetworkStats$getUniqueIfaces() {
        HashSet<String> ifaces = new HashSet<String>();
        for (String iface : this.iface) {
            if (iface == IFACE_ALL) continue;
            ifaces.add(iface);
        }
        return ifaces.toArray(new String[ifaces.size()]);
    }

    private final int[] $$robo$$android_net_NetworkStats$getUniqueUids() {
        SparseBooleanArray uids = new SparseBooleanArray();
        for (int uid : this.uid) {
            uids.put(uid, true);
        }
        int size = uids.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = uids.keyAt(i);
        }
        return result;
    }

    private final long $$robo$$android_net_NetworkStats$getTotalBytes() {
        Entry entry = this.getTotal(null);
        return entry.rxBytes + entry.txBytes;
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotal(Entry recycle) {
        return this.getTotal(recycle, null, -1, false);
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotal(Entry recycle, int limitUid) {
        return this.getTotal(recycle, null, limitUid, false);
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotal(Entry recycle, HashSet<String> limitIface) {
        return this.getTotal(recycle, limitIface, -1, false);
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotalIncludingTags(Entry recycle) {
        return this.getTotal(recycle, null, -1, true);
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotal(Entry recycle, HashSet<String> limitIface, int limitUid, boolean includeTags) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.iface = IFACE_ALL;
        entry.uid = limitUid;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        entry.rxBytes = 0L;
        entry.rxPackets = 0L;
        entry.txBytes = 0L;
        entry.txPackets = 0L;
        entry.operations = 0L;
        for (int i = 0; i < this.size; ++i) {
            boolean matchesIface;
            boolean matchesUid = limitUid == -1 || limitUid == this.uid[i];
            boolean bl = matchesIface = limitIface == null || limitIface.contains(this.iface[i]);
            if (!matchesUid || !matchesIface || this.tag[i] != 0 && !includeTags) continue;
            entry.rxBytes += this.rxBytes[i];
            entry.rxPackets += this.rxPackets[i];
            entry.txBytes += this.txBytes[i];
            entry.txPackets += this.txPackets[i];
            entry.operations += this.operations[i];
        }
        return entry;
    }

    private final long $$robo$$android_net_NetworkStats$getTotalPackets() {
        long total = 0L;
        for (int i = this.size - 1; i >= 0; --i) {
            total += this.rxPackets[i] + this.txPackets[i];
        }
        return total;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$subtract(NetworkStats right) {
        return NetworkStats.subtract(this, right, null, null);
    }

    private static final <C> NetworkStats $$robo$$android_net_NetworkStats$subtract(NetworkStats left, NetworkStats right, NonMonotonicObserver<C> observer, C cookie) {
        return NetworkStats.subtract(left, right, observer, cookie, null);
    }

    private static final <C> NetworkStats $$robo$$android_net_NetworkStats$subtract(NetworkStats left, NetworkStats right, NonMonotonicObserver<C> observer, C cookie, NetworkStats recycle) {
        NetworkStats result;
        long deltaRealtime = left.elapsedRealtime - right.elapsedRealtime;
        if (deltaRealtime < 0L) {
            if (observer != null) {
                observer.foundNonMonotonic(left, -1, right, -1, cookie);
            }
            deltaRealtime = 0L;
        }
        Entry entry = new Entry();
        if (recycle != null && recycle.capacity >= left.size) {
            result = recycle;
            result.size = 0;
            result.elapsedRealtime = deltaRealtime;
        } else {
            result = new NetworkStats(deltaRealtime, left.size);
        }
        for (int i = 0; i < left.size; ++i) {
            entry.iface = left.iface[i];
            entry.uid = left.uid[i];
            entry.set = left.set[i];
            entry.tag = left.tag[i];
            entry.metered = left.metered[i];
            entry.roaming = left.roaming[i];
            int j = right.findIndexHinted(entry.iface, entry.uid, entry.set, entry.tag, entry.metered, entry.roaming, i);
            if (j == -1) {
                entry.rxBytes = left.rxBytes[i];
                entry.rxPackets = left.rxPackets[i];
                entry.txBytes = left.txBytes[i];
                entry.txPackets = left.txPackets[i];
                entry.operations = left.operations[i];
            } else {
                entry.rxBytes = left.rxBytes[i] - right.rxBytes[j];
                entry.rxPackets = left.rxPackets[i] - right.rxPackets[j];
                entry.txBytes = left.txBytes[i] - right.txBytes[j];
                entry.txPackets = left.txPackets[i] - right.txPackets[j];
                entry.operations = left.operations[i] - right.operations[j];
                if (entry.rxBytes < 0L || entry.rxPackets < 0L || entry.txBytes < 0L || entry.txPackets < 0L || entry.operations < 0L) {
                    if (observer != null) {
                        observer.foundNonMonotonic(left, i, right, j, cookie);
                    }
                    entry.rxBytes = Math.max(entry.rxBytes, 0L);
                    entry.rxPackets = Math.max(entry.rxPackets, 0L);
                    entry.txBytes = Math.max(entry.txBytes, 0L);
                    entry.txPackets = Math.max(entry.txPackets, 0L);
                    entry.operations = Math.max(entry.operations, 0L);
                }
            }
            result.addValues(entry);
        }
        return result;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$groupedByIface() {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.uid = -1;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        entry.operations = 0L;
        for (int i = 0; i < this.size; ++i) {
            if (this.tag[i] != 0) continue;
            entry.iface = this.iface[i];
            entry.rxBytes = this.rxBytes[i];
            entry.rxPackets = this.rxPackets[i];
            entry.txBytes = this.txBytes[i];
            entry.txPackets = this.txPackets[i];
            stats.combineValues(entry);
        }
        return stats;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$groupedByUid() {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.iface = IFACE_ALL;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        for (int i = 0; i < this.size; ++i) {
            if (this.tag[i] != 0) continue;
            entry.uid = this.uid[i];
            entry.rxBytes = this.rxBytes[i];
            entry.rxPackets = this.rxPackets[i];
            entry.txBytes = this.txBytes[i];
            entry.txPackets = this.txPackets[i];
            entry.operations = this.operations[i];
            stats.combineValues(entry);
        }
        return stats;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$withoutUids(int[] uids) {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            if (ArrayUtils.contains(uids, entry.uid)) continue;
            stats.addValues(entry);
        }
        return stats;
    }

    private final void $$robo$$android_net_NetworkStats$dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("NetworkStats: elapsedRealtime=");
        pw.println(this.elapsedRealtime);
        for (int i = 0; i < this.size; ++i) {
            pw.print(prefix);
            pw.print("  [");
            pw.print(i);
            pw.print("]");
            pw.print(" iface=");
            pw.print(this.iface[i]);
            pw.print(" uid=");
            pw.print(this.uid[i]);
            pw.print(" set=");
            pw.print(NetworkStats.setToString(this.set[i]));
            pw.print(" tag=");
            pw.print(NetworkStats.tagToString(this.tag[i]));
            pw.print(" metered=");
            pw.print(NetworkStats.meteredToString(this.metered[i]));
            pw.print(" roaming=");
            pw.print(NetworkStats.roamingToString(this.roaming[i]));
            pw.print(" rxBytes=");
            pw.print(this.rxBytes[i]);
            pw.print(" rxPackets=");
            pw.print(this.rxPackets[i]);
            pw.print(" txBytes=");
            pw.print(this.txBytes[i]);
            pw.print(" txPackets=");
            pw.print(this.txPackets[i]);
            pw.print(" operations=");
            pw.println(this.operations[i]);
        }
    }

    private static final String $$robo$$android_net_NetworkStats$setToString(int set) {
        switch (set) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "FOREGROUND";
            }
            case 1001: {
                return "DBG_VPN_IN";
            }
            case 1002: {
                return "DBG_VPN_OUT";
            }
        }
        return "UNKNOWN";
    }

    private static final String $$robo$$android_net_NetworkStats$setToCheckinString(int set) {
        switch (set) {
            case -1: {
                return "all";
            }
            case 0: {
                return "def";
            }
            case 1: {
                return "fg";
            }
            case 1001: {
                return "vpnin";
            }
            case 1002: {
                return "vpnout";
            }
        }
        return "unk";
    }

    private static final boolean $$robo$$android_net_NetworkStats$setMatches(int querySet, int dataSet) {
        if (querySet == dataSet) {
            return true;
        }
        return querySet == -1 && dataSet < 1000;
    }

    private static final String $$robo$$android_net_NetworkStats$tagToString(int tag) {
        return "0x" + Integer.toHexString(tag);
    }

    private static final String $$robo$$android_net_NetworkStats$meteredToString(int metered) {
        switch (metered) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    private static final String $$robo$$android_net_NetworkStats$roamingToString(int roaming) {
        switch (roaming) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    private final String $$robo$$android_net_NetworkStats$toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump("", new PrintWriter(writer));
        return writer.toString();
    }

    private final int $$robo$$android_net_NetworkStats$describeContents() {
        return 0;
    }

    private final boolean $$robo$$android_net_NetworkStats$migrateTun(int tunUid, String tunIface, String underlyingIface) {
        Entry tunIfaceTotal = new Entry();
        Entry underlyingIfaceTotal = new Entry();
        this.tunAdjustmentInit(tunUid, tunIface, underlyingIface, tunIfaceTotal, underlyingIfaceTotal);
        Entry pool = NetworkStats.tunGetPool(tunIfaceTotal, underlyingIfaceTotal);
        if (pool.isEmpty()) {
            return true;
        }
        Entry moved = this.addTrafficToApplications(tunUid, tunIface, underlyingIface, tunIfaceTotal, pool);
        this.deductTrafficFromVpnApp(tunUid, underlyingIface, moved);
        if (!moved.isEmpty()) {
            Slog.wtf("NetworkStats", "Failed to deduct underlying network traffic from VPN package. Moved=" + moved);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_net_NetworkStats$tunAdjustmentInit(int tunUid, String tunIface, String underlyingIface, Entry tunIfaceTotal, Entry underlyingIfaceTotal) {
        Entry recycle = new Entry();
        for (int i = 0; i < this.size; ++i) {
            this.getValues(i, recycle);
            if (recycle.uid == -1) {
                throw new IllegalStateException("Cannot adjust VPN accounting on an iface aggregated NetworkStats.");
            }
            if (recycle.set == 1001 || recycle.set == 1002) {
                throw new IllegalStateException("Cannot adjust VPN accounting on a NetworkStats containing SET_DBG_VPN_*");
            }
            if (recycle.uid == tunUid && recycle.tag == 0 && Objects.equals(underlyingIface, recycle.iface)) {
                underlyingIfaceTotal.add(recycle);
            }
            if (recycle.uid == tunUid || recycle.tag != 0 || !Objects.equals(tunIface, recycle.iface)) continue;
            tunIfaceTotal.add(recycle);
        }
    }

    private static final Entry $$robo$$android_net_NetworkStats$tunGetPool(Entry tunIfaceTotal, Entry underlyingIfaceTotal) {
        Entry pool = new Entry();
        pool.rxBytes = Math.min(tunIfaceTotal.rxBytes, underlyingIfaceTotal.rxBytes);
        pool.rxPackets = Math.min(tunIfaceTotal.rxPackets, underlyingIfaceTotal.rxPackets);
        pool.txBytes = Math.min(tunIfaceTotal.txBytes, underlyingIfaceTotal.txBytes);
        pool.txPackets = Math.min(tunIfaceTotal.txPackets, underlyingIfaceTotal.txPackets);
        pool.operations = Math.min(tunIfaceTotal.operations, underlyingIfaceTotal.operations);
        return pool;
    }

    private final Entry $$robo$$android_net_NetworkStats$addTrafficToApplications(int tunUid, String tunIface, String underlyingIface, Entry tunIfaceTotal, Entry pool) {
        Entry moved = new Entry();
        Entry tmpEntry = new Entry();
        tmpEntry.iface = underlyingIface;
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.iface[i], tunIface) || this.uid[i] == tunUid) continue;
            tmpEntry.rxBytes = tunIfaceTotal.rxBytes > 0L ? pool.rxBytes * this.rxBytes[i] / tunIfaceTotal.rxBytes : 0L;
            tmpEntry.rxPackets = tunIfaceTotal.rxPackets > 0L ? pool.rxPackets * this.rxPackets[i] / tunIfaceTotal.rxPackets : 0L;
            tmpEntry.txBytes = tunIfaceTotal.txBytes > 0L ? pool.txBytes * this.txBytes[i] / tunIfaceTotal.txBytes : 0L;
            tmpEntry.txPackets = tunIfaceTotal.txPackets > 0L ? pool.txPackets * this.txPackets[i] / tunIfaceTotal.txPackets : 0L;
            tmpEntry.operations = tunIfaceTotal.operations > 0L ? pool.operations * this.operations[i] / tunIfaceTotal.operations : 0L;
            tmpEntry.uid = this.uid[i];
            tmpEntry.tag = this.tag[i];
            tmpEntry.set = this.set[i];
            tmpEntry.metered = this.metered[i];
            tmpEntry.roaming = this.roaming[i];
            this.combineValues(tmpEntry);
            if (this.tag[i] != 0) continue;
            moved.add(tmpEntry);
            tmpEntry.set = 1001;
            this.combineValues(tmpEntry);
        }
        return moved;
    }

    private final void $$robo$$android_net_NetworkStats$deductTrafficFromVpnApp(int tunUid, String underlyingIface, Entry moved) {
        int idxVpnForeground;
        moved.uid = tunUid;
        moved.set = 1002;
        moved.tag = 0;
        moved.iface = underlyingIface;
        moved.metered = -1;
        moved.roaming = -1;
        this.combineValues(moved);
        int idxVpnBackground = this.findIndex(underlyingIface, tunUid, 0, 0, 0, 0);
        if (idxVpnBackground != -1) {
            NetworkStats.tunSubtract(idxVpnBackground, this, moved);
        }
        if ((idxVpnForeground = this.findIndex(underlyingIface, tunUid, 1, 0, 0, 0)) != -1) {
            NetworkStats.tunSubtract(idxVpnForeground, this, moved);
        }
    }

    private static final void $$robo$$android_net_NetworkStats$tunSubtract(int i, NetworkStats left, Entry right) {
        long rxBytes = Math.min(left.rxBytes[i], right.rxBytes);
        int n = i;
        left.rxBytes[n] = left.rxBytes[n] - rxBytes;
        right.rxBytes -= rxBytes;
        long rxPackets = Math.min(left.rxPackets[i], right.rxPackets);
        int n2 = i;
        left.rxPackets[n2] = left.rxPackets[n2] - rxPackets;
        right.rxPackets -= rxPackets;
        long txBytes = Math.min(left.txBytes[i], right.txBytes);
        int n3 = i;
        left.txBytes[n3] = left.txBytes[n3] - txBytes;
        right.txBytes -= txBytes;
        long txPackets = Math.min(left.txPackets[i], right.txPackets);
        int n4 = i;
        left.txPackets[n4] = left.txPackets[n4] - txPackets;
        right.txPackets -= txPackets;
    }

    static void __staticInitializer__() {
        IFACE_ALL = null;
        CREATOR = new Parcelable.Creator<NetworkStats>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkStats_1$__constructor__() {
            }

            private final NetworkStats $$robo$$android_net_NetworkStats_1$createFromParcel(Parcel in) {
                return new NetworkStats(in);
            }

            private final NetworkStats[] $$robo$$android_net_NetworkStats_1$newArray(int size) {
                return new NetworkStats[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkStats_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_1$__constructor__(), this);
            }

            @Override
            public NetworkStats createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkStats_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public NetworkStats[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkStats_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(long l, int n) {
        this.$$robo$$android_net_NetworkStats$__constructor__(l, n);
    }

    public NetworkStats(long l, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats$__constructor__(long int ), this, l, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_net_NetworkStats$__constructor__(parcel);
    }

    public NetworkStats(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkStats$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public NetworkStats clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_net_NetworkStats$clone(), this);
    }

    public NetworkStats addIfaceValues(String string2, long l, long l2, long l3, long l4) {
        return InvokeDynamicSupport.bootstrap("addIfaceValues", $$robo$$android_net_NetworkStats$addIfaceValues(java.lang.String long long long long ), this, string2, l, l2, l3, l4);
    }

    public NetworkStats addValues(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
        return InvokeDynamicSupport.bootstrap("addValues", $$robo$$android_net_NetworkStats$addValues(java.lang.String int int int long long long long long ), this, string2, n, n2, n3, l, l2, l3, l4, l5);
    }

    public NetworkStats addValues(String string2, int n, int n2, int n3, int n4, int n5, long l, long l2, long l3, long l4, long l5) {
        return InvokeDynamicSupport.bootstrap("addValues", $$robo$$android_net_NetworkStats$addValues(java.lang.String int int int int int long long long long long ), this, string2, n, n2, n3, n4, n5, l, l2, l3, l4, l5);
    }

    public NetworkStats addValues(Entry entry) {
        return InvokeDynamicSupport.bootstrap("addValues", $$robo$$android_net_NetworkStats$addValues(android.net.NetworkStats$Entry ), this, entry);
    }

    public Entry getValues(int n, Entry entry) {
        return InvokeDynamicSupport.bootstrap("getValues", $$robo$$android_net_NetworkStats$getValues(int android.net.NetworkStats$Entry ), this, n, entry);
    }

    public long getElapsedRealtime() {
        return (long)InvokeDynamicSupport.bootstrap("getElapsedRealtime", $$robo$$android_net_NetworkStats$getElapsedRealtime(), this);
    }

    public void setElapsedRealtime(long l) {
        InvokeDynamicSupport.bootstrap("setElapsedRealtime", $$robo$$android_net_NetworkStats$setElapsedRealtime(long ), this, l);
    }

    public long getElapsedRealtimeAge() {
        return (long)InvokeDynamicSupport.bootstrap("getElapsedRealtimeAge", $$robo$$android_net_NetworkStats$getElapsedRealtimeAge(), this);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_net_NetworkStats$size(), this);
    }

    public int internalSize() {
        return (int)InvokeDynamicSupport.bootstrap("internalSize", $$robo$$android_net_NetworkStats$internalSize(), this);
    }

    @Deprecated
    public NetworkStats combineValues(String string2, int n, int n2, long l, long l2, long l3, long l4, long l5) {
        return InvokeDynamicSupport.bootstrap("combineValues", $$robo$$android_net_NetworkStats$combineValues(java.lang.String int int long long long long long ), this, string2, n, n2, l, l2, l3, l4, l5);
    }

    public NetworkStats combineValues(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
        return InvokeDynamicSupport.bootstrap("combineValues", $$robo$$android_net_NetworkStats$combineValues(java.lang.String int int int long long long long long ), this, string2, n, n2, n3, l, l2, l3, l4, l5);
    }

    public NetworkStats combineValues(Entry entry) {
        return InvokeDynamicSupport.bootstrap("combineValues", $$robo$$android_net_NetworkStats$combineValues(android.net.NetworkStats$Entry ), this, entry);
    }

    public void combineAllValues(NetworkStats networkStats) {
        InvokeDynamicSupport.bootstrap("combineAllValues", $$robo$$android_net_NetworkStats$combineAllValues(android.net.NetworkStats ), this, networkStats);
    }

    public int findIndex(String string2, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("findIndex", $$robo$$android_net_NetworkStats$findIndex(java.lang.String int int int int int ), this, string2, n, n2, n3, n4, n5);
    }

    public int findIndexHinted(String string2, int n, int n2, int n3, int n4, int n5, int n6) {
        return (int)InvokeDynamicSupport.bootstrap("findIndexHinted", $$robo$$android_net_NetworkStats$findIndexHinted(java.lang.String int int int int int int ), this, string2, n, n2, n3, n4, n5, n6);
    }

    public void spliceOperationsFrom(NetworkStats networkStats) {
        InvokeDynamicSupport.bootstrap("spliceOperationsFrom", $$robo$$android_net_NetworkStats$spliceOperationsFrom(android.net.NetworkStats ), this, networkStats);
    }

    public String[] getUniqueIfaces() {
        return InvokeDynamicSupport.bootstrap("getUniqueIfaces", $$robo$$android_net_NetworkStats$getUniqueIfaces(), this);
    }

    public int[] getUniqueUids() {
        return InvokeDynamicSupport.bootstrap("getUniqueUids", $$robo$$android_net_NetworkStats$getUniqueUids(), this);
    }

    public long getTotalBytes() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalBytes", $$robo$$android_net_NetworkStats$getTotalBytes(), this);
    }

    public Entry getTotal(Entry entry) {
        return InvokeDynamicSupport.bootstrap("getTotal", $$robo$$android_net_NetworkStats$getTotal(android.net.NetworkStats$Entry ), this, entry);
    }

    public Entry getTotal(Entry entry, int n) {
        return InvokeDynamicSupport.bootstrap("getTotal", $$robo$$android_net_NetworkStats$getTotal(android.net.NetworkStats$Entry int ), this, entry, n);
    }

    public Entry getTotal(Entry entry, HashSet<String> hashSet) {
        return InvokeDynamicSupport.bootstrap("getTotal", $$robo$$android_net_NetworkStats$getTotal(android.net.NetworkStats$Entry java.util.HashSet<java.lang.String> ), this, entry, hashSet);
    }

    public Entry getTotalIncludingTags(Entry entry) {
        return InvokeDynamicSupport.bootstrap("getTotalIncludingTags", $$robo$$android_net_NetworkStats$getTotalIncludingTags(android.net.NetworkStats$Entry ), this, entry);
    }

    private Entry getTotal(Entry entry, HashSet<String> hashSet, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getTotal", $$robo$$android_net_NetworkStats$getTotal(android.net.NetworkStats$Entry java.util.HashSet<java.lang.String> int boolean ), this, entry, hashSet, n, bl);
    }

    public long getTotalPackets() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalPackets", $$robo$$android_net_NetworkStats$getTotalPackets(), this);
    }

    public NetworkStats subtract(NetworkStats networkStats) {
        return InvokeDynamicSupport.bootstrap("subtract", $$robo$$android_net_NetworkStats$subtract(android.net.NetworkStats ), this, networkStats);
    }

    public static <C> NetworkStats subtract(NetworkStats networkStats, NetworkStats networkStats2, NonMonotonicObserver<C> nonMonotonicObserver, C c) {
        return InvokeDynamicSupport.bootstrapStatic("subtract", $$robo$$android_net_NetworkStats$subtract(android.net.NetworkStats android.net.NetworkStats android.net.NetworkStats$NonMonotonicObserver<C> C ), (NetworkStats)networkStats, (NetworkStats)networkStats2, nonMonotonicObserver, c);
    }

    public static <C> NetworkStats subtract(NetworkStats networkStats, NetworkStats networkStats2, NonMonotonicObserver<C> nonMonotonicObserver, C c, NetworkStats networkStats3) {
        return InvokeDynamicSupport.bootstrapStatic("subtract", $$robo$$android_net_NetworkStats$subtract(android.net.NetworkStats android.net.NetworkStats android.net.NetworkStats$NonMonotonicObserver<C> C android.net.NetworkStats ), (NetworkStats)networkStats, (NetworkStats)networkStats2, nonMonotonicObserver, c, (NetworkStats)networkStats3);
    }

    public NetworkStats groupedByIface() {
        return InvokeDynamicSupport.bootstrap("groupedByIface", $$robo$$android_net_NetworkStats$groupedByIface(), this);
    }

    public NetworkStats groupedByUid() {
        return InvokeDynamicSupport.bootstrap("groupedByUid", $$robo$$android_net_NetworkStats$groupedByUid(), this);
    }

    public NetworkStats withoutUids(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("withoutUids", $$robo$$android_net_NetworkStats$withoutUids(int[] ), this, nArray);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_NetworkStats$dump(java.lang.String java.io.PrintWriter ), this, string2, printWriter);
    }

    public static String setToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("setToString", $$robo$$android_net_NetworkStats$setToString(int ), (int)n);
    }

    public static String setToCheckinString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("setToCheckinString", $$robo$$android_net_NetworkStats$setToCheckinString(int ), (int)n);
    }

    public static boolean setMatches(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setMatches", $$robo$$android_net_NetworkStats$setMatches(int int ), (int)n, (int)n2);
    }

    public static String tagToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("tagToString", $$robo$$android_net_NetworkStats$tagToString(int ), (int)n);
    }

    public static String meteredToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("meteredToString", $$robo$$android_net_NetworkStats$meteredToString(int ), (int)n);
    }

    public static String roamingToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("roamingToString", $$robo$$android_net_NetworkStats$roamingToString(int ), (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkStats$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkStats$describeContents(), this);
    }

    public boolean migrateTun(int n, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("migrateTun", $$robo$$android_net_NetworkStats$migrateTun(int java.lang.String java.lang.String ), this, n, string2, string3);
    }

    private void tunAdjustmentInit(int n, String string2, String string3, Entry entry, Entry entry2) {
        InvokeDynamicSupport.bootstrap("tunAdjustmentInit", $$robo$$android_net_NetworkStats$tunAdjustmentInit(int java.lang.String java.lang.String android.net.NetworkStats$Entry android.net.NetworkStats$Entry ), this, n, string2, string3, entry, entry2);
    }

    private static Entry tunGetPool(Entry entry, Entry entry2) {
        return InvokeDynamicSupport.bootstrapStatic("tunGetPool", $$robo$$android_net_NetworkStats$tunGetPool(android.net.NetworkStats$Entry android.net.NetworkStats$Entry ), (Entry)entry, (Entry)entry2);
    }

    private Entry addTrafficToApplications(int n, String string2, String string3, Entry entry, Entry entry2) {
        return InvokeDynamicSupport.bootstrap("addTrafficToApplications", $$robo$$android_net_NetworkStats$addTrafficToApplications(int java.lang.String java.lang.String android.net.NetworkStats$Entry android.net.NetworkStats$Entry ), this, n, string2, string3, entry, entry2);
    }

    private void deductTrafficFromVpnApp(int n, String string2, Entry entry) {
        InvokeDynamicSupport.bootstrap("deductTrafficFromVpnApp", $$robo$$android_net_NetworkStats$deductTrafficFromVpnApp(int java.lang.String android.net.NetworkStats$Entry ), this, n, string2, entry);
    }

    private static void tunSubtract(int n, NetworkStats networkStats, Entry entry) {
        InvokeDynamicSupport.bootstrapStatic("tunSubtract", $$robo$$android_net_NetworkStats$tunSubtract(int android.net.NetworkStats android.net.NetworkStats$Entry ), (int)n, (NetworkStats)networkStats, (Entry)entry);
    }

    static {
        RobolectricInternals.classInitializing(NetworkStats.class);
    }

    public /* synthetic */ NetworkStats() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface NonMonotonicObserver<C> {
        public void foundNonMonotonic(NetworkStats var1, int var2, NetworkStats var3, int var4, C var5);
    }

    public static class Entry
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String iface;
        public int uid;
        public int set;
        public int tag;
        public int metered;
        public int roaming;
        public long rxBytes;
        public long rxPackets;
        public long txBytes;
        public long txPackets;
        public long operations;

        private void $$robo$$android_net_NetworkStats_Entry$__constructor__() {
        }

        private void $$robo$$android_net_NetworkStats_Entry$__constructor__(long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        }

        private void $$robo$$android_net_NetworkStats_Entry$__constructor__(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        }

        private void $$robo$$android_net_NetworkStats_Entry$__constructor__(String iface, int uid, int set, int tag, int metered, int roaming, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            this.iface = iface;
            this.uid = uid;
            this.set = set;
            this.tag = tag;
            this.metered = metered;
            this.roaming = roaming;
            this.rxBytes = rxBytes;
            this.rxPackets = rxPackets;
            this.txBytes = txBytes;
            this.txPackets = txPackets;
            this.operations = operations;
        }

        private final boolean $$robo$$android_net_NetworkStats_Entry$isNegative() {
            return this.rxBytes < 0L || this.rxPackets < 0L || this.txBytes < 0L || this.txPackets < 0L || this.operations < 0L;
        }

        private final boolean $$robo$$android_net_NetworkStats_Entry$isEmpty() {
            return this.rxBytes == 0L && this.rxPackets == 0L && this.txBytes == 0L && this.txPackets == 0L && this.operations == 0L;
        }

        private final void $$robo$$android_net_NetworkStats_Entry$add(Entry another) {
            this.rxBytes += another.rxBytes;
            this.rxPackets += another.rxPackets;
            this.txBytes += another.txBytes;
            this.txPackets += another.txPackets;
            this.operations += another.operations;
        }

        private final String $$robo$$android_net_NetworkStats_Entry$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("iface=").append(this.iface);
            builder.append(" uid=").append(this.uid);
            builder.append(" set=").append(NetworkStats.setToString(this.set));
            builder.append(" tag=").append(NetworkStats.tagToString(this.tag));
            builder.append(" metered=").append(NetworkStats.meteredToString(this.metered));
            builder.append(" roaming=").append(NetworkStats.roamingToString(this.roaming));
            builder.append(" rxBytes=").append(this.rxBytes);
            builder.append(" rxPackets=").append(this.rxPackets);
            builder.append(" txBytes=").append(this.txBytes);
            builder.append(" txPackets=").append(this.txPackets);
            builder.append(" operations=").append(this.operations);
            return builder.toString();
        }

        private final boolean $$robo$$android_net_NetworkStats_Entry$equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return this.uid == e.uid && this.set == e.set && this.tag == e.tag && this.metered == e.metered && this.roaming == e.roaming && this.rxBytes == e.rxBytes && this.rxPackets == e.rxPackets && this.txBytes == e.txBytes && this.txPackets == e.txPackets && this.operations == e.operations && this.iface.equals(e.iface);
            }
            return false;
        }

        private final int $$robo$$android_net_NetworkStats_Entry$hashCode() {
            return Objects.hash(this.uid, this.set, this.tag, this.metered, this.roaming, this.iface);
        }

        private void __constructor__() {
            this.$$robo$$android_net_NetworkStats_Entry$__constructor__();
        }

        public Entry() {
            this(IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_Entry$__constructor__(), this);
        }

        private void __constructor__(long l, long l2, long l3, long l4, long l5) {
            this.$$robo$$android_net_NetworkStats_Entry$__constructor__(l, l2, l3, l4, l5);
        }

        public Entry(long l, long l2, long l3, long l4, long l5) {
            this(IFACE_ALL, -1, 0, 0, l, l2, l3, l4, l5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_Entry$__constructor__(long long long long long ), this, l, l2, l3, l4, l5);
        }

        private void __constructor__(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this.$$robo$$android_net_NetworkStats_Entry$__constructor__(string2, n, n2, n3, l, l2, l3, l4, l5);
        }

        public Entry(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this(string2, n, n2, n3, 0, 0, l, l2, l3, l4, l5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_Entry$__constructor__(java.lang.String int int int long long long long long ), this, string2, n, n2, n3, l, l2, l3, l4, l5);
        }

        private void __constructor__(String string2, int n, int n2, int n3, int n4, int n5, long l, long l2, long l3, long l4, long l5) {
            this.$$robo$$android_net_NetworkStats_Entry$__constructor__(string2, n, n2, n3, n4, n5, l, l2, l3, l4, l5);
        }

        public Entry(String string2, int n, int n2, int n3, int n4, int n5, long l, long l2, long l3, long l4, long l5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_Entry$__constructor__(java.lang.String int int int int int long long long long long ), this, string2, n, n2, n3, n4, n5, l, l2, l3, l4, l5);
        }

        public boolean isNegative() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNegative", $$robo$$android_net_NetworkStats_Entry$isNegative(), this);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_net_NetworkStats_Entry$isEmpty(), this);
        }

        public void add(Entry entry) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_net_NetworkStats_Entry$add(android.net.NetworkStats$Entry ), this, entry);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkStats_Entry$toString(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkStats_Entry$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkStats_Entry$hashCode(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

