/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.media.AudioRecord;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionCallback;
import android.os.Handler;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaProjection
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaProjection";
    private IMediaProjection mImpl;
    private Context mContext;
    private Map<Callback, CallbackRecord> mCallbacks;

    private void $$robo$$android_media_projection_MediaProjection$__constructor__(Context context, IMediaProjection impl) {
        this.mCallbacks = new ArrayMap<Callback, CallbackRecord>();
        this.mContext = context;
        this.mImpl = impl;
        try {
            this.mImpl.start(new MediaProjectionCallback(this, null));
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to start media projection", e);
        }
    }

    private final void $$robo$$android_media_projection_MediaProjection$registerCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback should not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        this.mCallbacks.put(callback, new CallbackRecord(callback, handler));
    }

    private final void $$robo$$android_media_projection_MediaProjection$unregisterCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback should not be null");
        }
        this.mCallbacks.remove(callback);
    }

    private final VirtualDisplay $$robo$$android_media_projection_MediaProjection$createVirtualDisplay(String name, int width, int height, int dpi, boolean isSecure, Surface surface, VirtualDisplay.Callback callback, Handler handler) {
        DisplayManager dm = (DisplayManager)this.mContext.getSystemService("display");
        int flags = isSecure ? 4 : 0;
        return dm.createVirtualDisplay(this, name, width, height, dpi, surface, flags | 0x10 | 2, callback, handler, null);
    }

    private final VirtualDisplay $$robo$$android_media_projection_MediaProjection$createVirtualDisplay(String name, int width, int height, int dpi, int flags, Surface surface, VirtualDisplay.Callback callback, Handler handler) {
        DisplayManager dm = (DisplayManager)this.mContext.getSystemService("display");
        return dm.createVirtualDisplay(this, name, width, height, dpi, surface, flags, callback, handler, null);
    }

    private final AudioRecord $$robo$$android_media_projection_MediaProjection$createAudioRecord(int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes) {
        return null;
    }

    private final void $$robo$$android_media_projection_MediaProjection$stop() {
        try {
            this.mImpl.stop();
        }
        catch (RemoteException e) {
            Log.e("MediaProjection", "Unable to stop projection", e);
        }
    }

    private final IMediaProjection $$robo$$android_media_projection_MediaProjection$getProjection() {
        return this.mImpl;
    }

    private void __constructor__(Context context, IMediaProjection iMediaProjection) {
        this.$$robo$$android_media_projection_MediaProjection$__constructor__(context, iMediaProjection);
    }

    public MediaProjection(Context context, IMediaProjection iMediaProjection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjection$__constructor__(android.content.Context android.media.projection.IMediaProjection ), this, context, iMediaProjection);
    }

    public void registerCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_media_projection_MediaProjection$registerCallback(android.media.projection.MediaProjection$Callback android.os.Handler ), this, callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_media_projection_MediaProjection$unregisterCallback(android.media.projection.MediaProjection$Callback ), this, callback);
    }

    public VirtualDisplay createVirtualDisplay(String string2, int n, int n2, int n3, boolean bl, Surface surface, VirtualDisplay.Callback callback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("createVirtualDisplay", $$robo$$android_media_projection_MediaProjection$createVirtualDisplay(java.lang.String int int int boolean android.view.Surface android.hardware.display.VirtualDisplay$Callback android.os.Handler ), this, string2, n, n2, n3, bl, surface, callback, handler);
    }

    public VirtualDisplay createVirtualDisplay(String string2, int n, int n2, int n3, int n4, Surface surface, VirtualDisplay.Callback callback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("createVirtualDisplay", $$robo$$android_media_projection_MediaProjection$createVirtualDisplay(java.lang.String int int int int android.view.Surface android.hardware.display.VirtualDisplay$Callback android.os.Handler ), this, string2, n, n2, n3, n4, surface, callback, handler);
    }

    public AudioRecord createAudioRecord(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("createAudioRecord", $$robo$$android_media_projection_MediaProjection$createAudioRecord(int int int int ), this, n, n2, n3, n4);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_projection_MediaProjection$stop(), this);
    }

    public IMediaProjection getProjection() {
        return InvokeDynamicSupport.bootstrap("getProjection", $$robo$$android_media_projection_MediaProjection$getProjection(), this);
    }

    public /* synthetic */ MediaProjection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaProjection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CallbackRecord
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Callback mCallback;
        private Handler mHandler;

        private void $$robo$$android_media_projection_MediaProjection_CallbackRecord$__constructor__(Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_projection_MediaProjection_CallbackRecord$onStop() {
            this.mHandler.post(new Runnable(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ CallbackRecord this$0;

                private void $$robo$$android_media_projection_MediaProjection_CallbackRecord_1$__constructor__(CallbackRecord this$0) {
                }

                private final void $$robo$$android_media_projection_MediaProjection_CallbackRecord_1$run() {
                    this.this$0.mCallback.onStop();
                }

                private void __constructor__(CallbackRecord callbackRecord) {
                    this.$$robo$$android_media_projection_MediaProjection_CallbackRecord_1$__constructor__(callbackRecord);
                }
                {
                    this.this$0 = callbackRecord;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjection_CallbackRecord_1$__constructor__(android.media.projection.MediaProjection$CallbackRecord ), this, callbackRecord);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_projection_MediaProjection_CallbackRecord_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private void __constructor__(Callback callback, Handler handler) {
            this.$$robo$$android_media_projection_MediaProjection_CallbackRecord$__constructor__(callback, handler);
        }

        public CallbackRecord(Callback callback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjection_CallbackRecord$__constructor__(android.media.projection.MediaProjection$Callback android.os.Handler ), this, callback, handler);
        }

        public void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_projection_MediaProjection_CallbackRecord$onStop(), this);
        }

        public /* synthetic */ CallbackRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MediaProjectionCallback
    extends IMediaProjectionCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaProjection this$0;

        private void $$robo$$android_media_projection_MediaProjection_MediaProjectionCallback$__constructor__(MediaProjection mediaProjection) {
        }

        private final void $$robo$$android_media_projection_MediaProjection_MediaProjectionCallback$onStop() {
            for (CallbackRecord cbr : this.this$0.mCallbacks.values()) {
                cbr.onStop();
            }
        }

        private /* synthetic */ void $$robo$$android_media_projection_MediaProjection_MediaProjectionCallback$__constructor__(MediaProjection x0, 1 x1) {
        }

        private void __constructor__(MediaProjection mediaProjection) {
            this.$$robo$$android_media_projection_MediaProjection_MediaProjectionCallback$__constructor__(mediaProjection);
        }

        public MediaProjectionCallback(MediaProjection mediaProjection) {
            this.this$0 = mediaProjection;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjection_MediaProjectionCallback$__constructor__(android.media.projection.MediaProjection ), this, mediaProjection);
        }

        @Override
        public void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_projection_MediaProjection_MediaProjectionCallback$onStop(), this);
        }

        private /* synthetic */ void __constructor__(MediaProjection mediaProjection, 1 var2_2) {
            this.$$robo$$android_media_projection_MediaProjection_MediaProjectionCallback$__constructor__(mediaProjection, var2_2);
        }

        public /* synthetic */ MediaProjectionCallback(MediaProjection mediaProjection, 1 var2_2) {
            this(mediaProjection);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjection_MediaProjectionCallback$__constructor__(android.media.projection.MediaProjection android.media.projection.MediaProjection$1 ), this, mediaProjection, var2_2);
        }

        public /* synthetic */ MediaProjectionCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaProjectionCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_projection_MediaProjection_Callback$__constructor__() {
        }

        private final void $$robo$$android_media_projection_MediaProjection_Callback$onStop() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_projection_MediaProjection_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_projection_MediaProjection_Callback$__constructor__(), this);
        }

        public void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_projection_MediaProjection_Callback$onStop(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

