/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.FileUtils;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Utils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Utils";

    private void $$robo$$android_media_Utils$__constructor__() {
    }

    private static final <T extends Comparable<? super T>> void $$robo$$android_media_Utils$sortDistinctRanges(Range<T>[] ranges) {
        Arrays.sort(ranges, new Comparator<Range<T>>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_Utils_1$__constructor__() {
            }

            private final int $$robo$$android_media_Utils_1$compare(Range<T> lhs, Range<T> rhs) {
                if (lhs.getUpper().compareTo(rhs.getLower()) < 0) {
                    return -1;
                }
                if (lhs.getLower().compareTo(rhs.getUpper()) > 0) {
                    return 1;
                }
                throw new IllegalArgumentException("sample rate ranges must be distinct (" + lhs + " and " + rhs + ")");
            }

            private void __constructor__() {
                this.$$robo$$android_media_Utils_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Utils_1$__constructor__(), this);
            }

            @Override
            public int compare(Range<T> range, Range<T> range2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_media_Utils_1$compare(android.util.Range<T> android.util.Range<T> ), this, range, range2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private static final <T extends Comparable<? super T>> Range<T>[] $$robo$$android_media_Utils$intersectSortedDistinctRanges(Range<T>[] one, Range<T>[] another) {
        int ix = 0;
        Vector<Range<T>> result = new Vector<Range<T>>();
        for (Range<T> range : another) {
            while (ix < one.length && one[ix].getUpper().compareTo(range.getLower()) < 0) {
                ++ix;
            }
            while (ix < one.length && one[ix].getUpper().compareTo(range.getUpper()) < 0) {
                result.add(range.intersect(one[ix]));
                ++ix;
            }
            if (ix == one.length) break;
            if (one[ix].getLower().compareTo(range.getUpper()) > 0) continue;
            result.add(range.intersect(one[ix]));
        }
        return result.toArray(new Range[result.size()]);
    }

    private static final <T extends Comparable<? super T>> int $$robo$$android_media_Utils$binarySearchDistinctRanges(Range<T>[] ranges, T value) {
        return Arrays.binarySearch(ranges, Range.create(value, value), new Comparator<Range<T>>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_Utils_2$__constructor__() {
            }

            private final int $$robo$$android_media_Utils_2$compare(Range<T> lhs, Range<T> rhs) {
                if (lhs.getUpper().compareTo(rhs.getLower()) < 0) {
                    return -1;
                }
                if (lhs.getLower().compareTo(rhs.getUpper()) > 0) {
                    return 1;
                }
                return 0;
            }

            private void __constructor__() {
                this.$$robo$$android_media_Utils_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Utils_2$__constructor__(), this);
            }

            @Override
            public int compare(Range<T> range, Range<T> range2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_media_Utils_2$compare(android.util.Range<T> android.util.Range<T> ), this, range, range2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private static final int $$robo$$android_media_Utils$gcd(int a, int b) {
        if (a == 0 && b == 0) {
            return 1;
        }
        if (b < 0) {
            b = -b;
        }
        if (a < 0) {
            a = -a;
        }
        while (a != 0) {
            int c = b % a;
            b = a;
            a = c;
        }
        return b;
    }

    private static final Range<Integer> $$robo$$android_media_Utils$factorRange(Range<Integer> range, int factor) {
        if (factor == 1) {
            return range;
        }
        return Range.create(Utils.divUp(range.getLower(), factor), range.getUpper() / factor);
    }

    private static final Range<Long> $$robo$$android_media_Utils$factorRange(Range<Long> range, long factor) {
        if (factor == 1L) {
            return range;
        }
        return Range.create(Utils.divUp(range.getLower(), factor), range.getUpper() / factor);
    }

    private static final Rational $$robo$$android_media_Utils$scaleRatio(Rational ratio, int num, int den) {
        int common = Utils.gcd(num, den);
        return new Rational((int)((double)ratio.getNumerator() * (double)(num /= common)), (int)((double)ratio.getDenominator() * (double)(den /= common)));
    }

    private static final Range<Rational> $$robo$$android_media_Utils$scaleRange(Range<Rational> range, int num, int den) {
        if (num == den) {
            return range;
        }
        return Range.create(Utils.scaleRatio(range.getLower(), num, den), Utils.scaleRatio(range.getUpper(), num, den));
    }

    private static final Range<Integer> $$robo$$android_media_Utils$alignRange(Range<Integer> range, int align) {
        return range.intersect(Utils.divUp(range.getLower(), align) * align, range.getUpper() / align * align);
    }

    private static final int $$robo$$android_media_Utils$divUp(int num, int den) {
        return (num + den - 1) / den;
    }

    private static final long $$robo$$android_media_Utils$divUp(long num, long den) {
        return (num + den - 1L) / den;
    }

    private static final long $$robo$$android_media_Utils$lcm(int a, int b) {
        if (a == 0 || b == 0) {
            throw new IllegalArgumentException("lce is not defined for zero arguments");
        }
        return (long)a * (long)b / (long)Utils.gcd(a, b);
    }

    private static final Range<Integer> $$robo$$android_media_Utils$intRangeFor(double v) {
        return Range.create((int)v, (int)Math.ceil(v));
    }

    private static final Range<Long> $$robo$$android_media_Utils$longRangeFor(double v) {
        return Range.create((long)v, (long)Math.ceil(v));
    }

    private static final Size $$robo$$android_media_Utils$parseSize(Object o, Size fallback) {
        try {
            return Size.parseSize((String)o);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException e) {
            return fallback;
        }
        Log.w("Utils", "could not parse size '" + o + "'");
        return fallback;
    }

    private static final int $$robo$$android_media_Utils$parseIntSafely(Object o, int fallback) {
        if (o == null) {
            return fallback;
        }
        try {
            String s = (String)o;
            return Integer.parseInt(s);
        }
        catch (ClassCastException s) {
        }
        catch (NumberFormatException s) {
        }
        catch (NullPointerException e) {
            return fallback;
        }
        Log.w("Utils", "could not parse integer '" + o + "'");
        return fallback;
    }

    private static final Range<Integer> $$robo$$android_media_Utils$parseIntRange(Object o, Range<Integer> fallback) {
        try {
            String s = (String)o;
            int ix = s.indexOf(45);
            if (ix >= 0) {
                return Range.create(Integer.parseInt(s.substring(0, ix), 10), Integer.parseInt(s.substring(ix + 1), 10));
            }
            int value = Integer.parseInt(s);
            return Range.create(value, value);
        }
        catch (ClassCastException s) {
        }
        catch (NumberFormatException s) {
        }
        catch (NullPointerException e) {
            return fallback;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.w("Utils", "could not parse integer range '" + o + "'");
        return fallback;
    }

    private static final Range<Long> $$robo$$android_media_Utils$parseLongRange(Object o, Range<Long> fallback) {
        try {
            String s = (String)o;
            int ix = s.indexOf(45);
            if (ix >= 0) {
                return Range.create(Long.parseLong(s.substring(0, ix), 10), Long.parseLong(s.substring(ix + 1), 10));
            }
            long value = Long.parseLong(s);
            return Range.create(value, value);
        }
        catch (ClassCastException s) {
        }
        catch (NumberFormatException s) {
        }
        catch (NullPointerException e) {
            return fallback;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.w("Utils", "could not parse long range '" + o + "'");
        return fallback;
    }

    private static final Range<Rational> $$robo$$android_media_Utils$parseRationalRange(Object o, Range<Rational> fallback) {
        try {
            String s = (String)o;
            int ix = s.indexOf(45);
            if (ix >= 0) {
                return Range.create(Rational.parseRational(s.substring(0, ix)), Rational.parseRational(s.substring(ix + 1)));
            }
            Rational value = Rational.parseRational(s);
            return Range.create(value, value);
        }
        catch (ClassCastException s) {
        }
        catch (NumberFormatException s) {
        }
        catch (NullPointerException e) {
            return fallback;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.w("Utils", "could not parse rational range '" + o + "'");
        return fallback;
    }

    private static final Pair<Size, Size> $$robo$$android_media_Utils$parseSizeRange(Object o) {
        try {
            String s = (String)o;
            int ix = s.indexOf(45);
            if (ix >= 0) {
                return Pair.create(Size.parseSize(s.substring(0, ix)), Size.parseSize(s.substring(ix + 1)));
            }
            Size value = Size.parseSize(s);
            return Pair.create(value, value);
        }
        catch (ClassCastException s) {
        }
        catch (NumberFormatException s) {
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.w("Utils", "could not parse size range '" + o + "'");
        return null;
    }

    private static final File $$robo$$android_media_Utils$getUniqueExternalFile(Context context, String subdirectory, String fileName, String mimeType) {
        File externalStorage = Environment.getExternalStoragePublicDirectory(subdirectory);
        externalStorage.mkdirs();
        File outFile = null;
        try {
            outFile = FileUtils.buildUniqueFile(externalStorage, mimeType, fileName);
        }
        catch (FileNotFoundException e) {
            Log.e("Utils", "Unable to get a unique file name: " + e);
            return null;
        }
        return outFile;
    }

    private static final String $$robo$$android_media_Utils$getFileDisplayNameFromUri(Context context, Uri uri) {
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            return uri.getLastPathSegment();
        }
        if ("content".equals(scheme)) {
            String[] proj = new String[]{"_display_name"};
            try (Cursor cursor = context.getContentResolver().query(uri, proj, null, null, null);){
                if (cursor != null && cursor.getCount() != 0) {
                    cursor.moveToFirst();
                    String string2 = cursor.getString(cursor.getColumnIndex("_display_name"));
                    return string2;
                }
            }
        }
        return uri.toString();
    }

    private void __constructor__() {
        this.$$robo$$android_media_Utils$__constructor__();
    }

    public Utils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Utils$__constructor__(), this);
    }

    public static <T extends Comparable<? super T>> void sortDistinctRanges(Range<T>[] rangeArray) {
        InvokeDynamicSupport.bootstrapStatic("sortDistinctRanges", $$robo$$android_media_Utils$sortDistinctRanges(android.util.Range<T>[] ), (Range[])rangeArray);
    }

    public static <T extends Comparable<? super T>> Range<T>[] intersectSortedDistinctRanges(Range<T>[] rangeArray, Range<T>[] rangeArray2) {
        return InvokeDynamicSupport.bootstrapStatic("intersectSortedDistinctRanges", $$robo$$android_media_Utils$intersectSortedDistinctRanges(android.util.Range<T>[] android.util.Range<T>[] ), (Range[])rangeArray, (Range[])rangeArray2);
    }

    public static <T extends Comparable<? super T>> int binarySearchDistinctRanges(Range<T>[] rangeArray, T t) {
        return (int)InvokeDynamicSupport.bootstrapStatic("binarySearchDistinctRanges", $$robo$$android_media_Utils$binarySearchDistinctRanges(android.util.Range<T>[] T ), (Range[])rangeArray, t);
    }

    static int gcd(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("gcd", $$robo$$android_media_Utils$gcd(int int ), (int)n, (int)n2);
    }

    static Range<Integer> factorRange(Range<Integer> range, int n) {
        return InvokeDynamicSupport.bootstrapStatic("factorRange", $$robo$$android_media_Utils$factorRange(android.util.Range<java.lang.Integer> int ), range, (int)n);
    }

    static Range<Long> factorRange(Range<Long> range, long l) {
        return InvokeDynamicSupport.bootstrapStatic("factorRange", $$robo$$android_media_Utils$factorRange(android.util.Range<java.lang.Long> long ), range, (long)l);
    }

    private static Rational scaleRatio(Rational rational, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("scaleRatio", $$robo$$android_media_Utils$scaleRatio(android.util.Rational int int ), (Rational)rational, (int)n, (int)n2);
    }

    static Range<Rational> scaleRange(Range<Rational> range, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("scaleRange", $$robo$$android_media_Utils$scaleRange(android.util.Range<android.util.Rational> int int ), range, (int)n, (int)n2);
    }

    static Range<Integer> alignRange(Range<Integer> range, int n) {
        return InvokeDynamicSupport.bootstrapStatic("alignRange", $$robo$$android_media_Utils$alignRange(android.util.Range<java.lang.Integer> int ), range, (int)n);
    }

    static int divUp(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("divUp", $$robo$$android_media_Utils$divUp(int int ), (int)n, (int)n2);
    }

    static long divUp(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("divUp", $$robo$$android_media_Utils$divUp(long long ), (long)l, (long)l2);
    }

    private static long lcm(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("lcm", $$robo$$android_media_Utils$lcm(int int ), (int)n, (int)n2);
    }

    static Range<Integer> intRangeFor(double d) {
        return InvokeDynamicSupport.bootstrapStatic("intRangeFor", $$robo$$android_media_Utils$intRangeFor(double ), (double)d);
    }

    static Range<Long> longRangeFor(double d) {
        return InvokeDynamicSupport.bootstrapStatic("longRangeFor", $$robo$$android_media_Utils$longRangeFor(double ), (double)d);
    }

    static Size parseSize(Object object, Size size) {
        return InvokeDynamicSupport.bootstrapStatic("parseSize", $$robo$$android_media_Utils$parseSize(java.lang.Object android.util.Size ), (Object)object, (Size)size);
    }

    static int parseIntSafely(Object object, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseIntSafely", $$robo$$android_media_Utils$parseIntSafely(java.lang.Object int ), (Object)object, (int)n);
    }

    static Range<Integer> parseIntRange(Object object, Range<Integer> range) {
        return InvokeDynamicSupport.bootstrapStatic("parseIntRange", $$robo$$android_media_Utils$parseIntRange(java.lang.Object android.util.Range<java.lang.Integer> ), (Object)object, range);
    }

    static Range<Long> parseLongRange(Object object, Range<Long> range) {
        return InvokeDynamicSupport.bootstrapStatic("parseLongRange", $$robo$$android_media_Utils$parseLongRange(java.lang.Object android.util.Range<java.lang.Long> ), (Object)object, range);
    }

    static Range<Rational> parseRationalRange(Object object, Range<Rational> range) {
        return InvokeDynamicSupport.bootstrapStatic("parseRationalRange", $$robo$$android_media_Utils$parseRationalRange(java.lang.Object android.util.Range<android.util.Rational> ), (Object)object, range);
    }

    static Pair<Size, Size> parseSizeRange(Object object) {
        return InvokeDynamicSupport.bootstrapStatic("parseSizeRange", $$robo$$android_media_Utils$parseSizeRange(java.lang.Object ), (Object)object);
    }

    public static File getUniqueExternalFile(Context context, String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("getUniqueExternalFile", $$robo$$android_media_Utils$getUniqueExternalFile(android.content.Context java.lang.String java.lang.String java.lang.String ), (Context)context, (String)string2, (String)string3, (String)string4);
    }

    static String getFileDisplayNameFromUri(Context context, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getFileDisplayNameFromUri", $$robo$$android_media_Utils$getFileDisplayNameFromUri(android.content.Context android.net.Uri ), (Context)context, (Uri)uri);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Utils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

