/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TtmlNode;
import android.media.TtmlNodeListener;
import android.media.TtmlUtils;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class TtmlParser
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "TtmlParser";
    private static int DEFAULT_FRAMERATE = 30;
    private static int DEFAULT_SUBFRAMERATE = 1;
    private static int DEFAULT_TICKRATE = 1;
    private XmlPullParser mParser;
    private TtmlNodeListener mListener;
    private long mCurrentRunId;

    private void $$robo$$android_media_TtmlParser$__constructor__(TtmlNodeListener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_media_TtmlParser$parse(String ttmlText, long runId) throws XmlPullParserException, IOException {
        this.mParser = null;
        this.mCurrentRunId = runId;
        this.loadParser(ttmlText);
        this.parseTtml();
    }

    private final void $$robo$$android_media_TtmlParser$loadParser(String ttmlFragment) throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(false);
        this.mParser = factory.newPullParser();
        StringReader in = new StringReader(ttmlFragment);
        this.mParser.setInput(in);
    }

    private final void $$robo$$android_media_TtmlParser$extractAttribute(XmlPullParser parser, int i, StringBuilder out) {
        out.append(" ");
        out.append(parser.getAttributeName(i));
        out.append("=\"");
        out.append(parser.getAttributeValue(i));
        out.append("\"");
    }

    private final void $$robo$$android_media_TtmlParser$parseTtml() throws XmlPullParserException, IOException {
        LinkedList<TtmlNode> nodeStack = new LinkedList<TtmlNode>();
        int depthInUnsupportedTag = 0;
        boolean active = true;
        while (!this.isEndOfDoc()) {
            int eventType = this.mParser.getEventType();
            TtmlNode parent = (TtmlNode)nodeStack.peekLast();
            if (active) {
                if (eventType == 2) {
                    if (!TtmlParser.isSupportedTag(this.mParser.getName())) {
                        Log.w("TtmlParser", "Unsupported tag " + this.mParser.getName() + " is ignored.");
                        ++depthInUnsupportedTag;
                        active = false;
                    } else {
                        TtmlNode node = this.parseNode(parent);
                        nodeStack.addLast(node);
                        if (parent != null) {
                            parent.mChildren.add(node);
                        }
                    }
                } else if (eventType == 4) {
                    String text = TtmlUtils.applyDefaultSpacePolicy(this.mParser.getText());
                    if (!TextUtils.isEmpty(text)) {
                        parent.mChildren.add(new TtmlNode("#pcdata", "", text, 0L, Long.MAX_VALUE, parent, this.mCurrentRunId));
                    }
                } else if (eventType == 3) {
                    if (this.mParser.getName().equals("p")) {
                        this.mListener.onTtmlNodeParsed((TtmlNode)nodeStack.getLast());
                    } else if (this.mParser.getName().equals("tt")) {
                        this.mListener.onRootNodeParsed((TtmlNode)nodeStack.getLast());
                    }
                    nodeStack.removeLast();
                }
            } else if (eventType == 2) {
                ++depthInUnsupportedTag;
            } else if (eventType == 3 && --depthInUnsupportedTag == 0) {
                active = true;
            }
            this.mParser.next();
        }
    }

    private final TtmlNode $$robo$$android_media_TtmlParser$parseNode(TtmlNode parent) throws XmlPullParserException, IOException {
        int eventType = this.mParser.getEventType();
        if (eventType != 2) {
            return null;
        }
        StringBuilder attrStr = new StringBuilder();
        long start = 0L;
        long end = Long.MAX_VALUE;
        long dur = 0L;
        for (int i = 0; i < this.mParser.getAttributeCount(); ++i) {
            String attr2 = this.mParser.getAttributeName(i);
            String value = this.mParser.getAttributeValue(i);
            if ((attr2 = attr2.replaceFirst("^.*:", "")).equals("begin")) {
                start = TtmlUtils.parseTimeExpression(value, 30, 1, 1);
                continue;
            }
            if (attr2.equals("end")) {
                end = TtmlUtils.parseTimeExpression(value, 30, 1, 1);
                continue;
            }
            if (attr2.equals("dur")) {
                dur = TtmlUtils.parseTimeExpression(value, 30, 1, 1);
                continue;
            }
            this.extractAttribute(this.mParser, i, attrStr);
        }
        if (parent != null) {
            start += parent.mStartTimeMs;
            if (end != Long.MAX_VALUE) {
                end += parent.mStartTimeMs;
            }
        }
        if (dur > 0L) {
            if (end != Long.MAX_VALUE) {
                Log.e("TtmlParser", "'dur' and 'end' attributes are defined at the same time.'end' value is ignored.");
            }
            end = start + dur;
        }
        if (parent != null && end == Long.MAX_VALUE && parent.mEndTimeMs != Long.MAX_VALUE && end > parent.mEndTimeMs) {
            end = parent.mEndTimeMs;
        }
        TtmlNode node = new TtmlNode(this.mParser.getName(), attrStr.toString(), null, start, end, parent, this.mCurrentRunId);
        return node;
    }

    private final boolean $$robo$$android_media_TtmlParser$isEndOfDoc() throws XmlPullParserException {
        return this.mParser.getEventType() == 1;
    }

    private static final boolean $$robo$$android_media_TtmlParser$isSupportedTag(String tag) {
        return tag.equals("tt") || tag.equals("head") || tag.equals("body") || tag.equals("div") || tag.equals("p") || tag.equals("span") || tag.equals("br") || tag.equals("style") || tag.equals("styling") || tag.equals("layout") || tag.equals("region") || tag.equals("metadata") || tag.equals("smpte:image") || tag.equals("smpte:data") || tag.equals("smpte:information");
    }

    private void __constructor__(TtmlNodeListener ttmlNodeListener) {
        this.$$robo$$android_media_TtmlParser$__constructor__(ttmlNodeListener);
    }

    public TtmlParser(TtmlNodeListener ttmlNodeListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TtmlParser$__constructor__(android.media.TtmlNodeListener ), this, ttmlNodeListener);
    }

    public void parse(String string2, long l) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_TtmlParser$parse(java.lang.String long ), this, string2, l);
    }

    private void loadParser(String string2) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("loadParser", $$robo$$android_media_TtmlParser$loadParser(java.lang.String ), this, string2);
    }

    private void extractAttribute(XmlPullParser xmlPullParser, int n, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("extractAttribute", $$robo$$android_media_TtmlParser$extractAttribute(org.xmlpull.v1.XmlPullParser int java.lang.StringBuilder ), this, xmlPullParser, n, stringBuilder);
    }

    private void parseTtml() throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("parseTtml", $$robo$$android_media_TtmlParser$parseTtml(), this);
    }

    private TtmlNode parseNode(TtmlNode ttmlNode) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseNode", $$robo$$android_media_TtmlParser$parseNode(android.media.TtmlNode ), this, ttmlNode);
    }

    private boolean isEndOfDoc() throws XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrap("isEndOfDoc", $$robo$$android_media_TtmlParser$isEndOfDoc(), this);
    }

    private static boolean isSupportedTag(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSupportedTag", $$robo$$android_media_TtmlParser$isSupportedTag(java.lang.String ), (String)string2);
    }

    public /* synthetic */ TtmlParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TtmlParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

