/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Hashtable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MiniThumbFile
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MiniThumbFile";
    private static int MINI_THUMB_DATA_FILE_VERSION = 3;
    public static int BYTES_PER_MINTHUMB = 10000;
    private static int HEADER_SIZE = 13;
    private Uri mUri;
    private RandomAccessFile mMiniThumbFile;
    private FileChannel mChannel;
    private ByteBuffer mBuffer;
    private static Hashtable<String, MiniThumbFile> sThumbFiles;

    private static final synchronized void $$robo$$android_media_MiniThumbFile$reset() {
        for (MiniThumbFile file : sThumbFiles.values()) {
            file.deactivate();
        }
        sThumbFiles.clear();
    }

    private static final synchronized MiniThumbFile $$robo$$android_media_MiniThumbFile$instance(Uri uri) {
        String type = uri.getPathSegments().get(1);
        MiniThumbFile file = sThumbFiles.get(type);
        if (file == null) {
            file = new MiniThumbFile(Uri.parse("content://media/external/" + type + "/media"));
            sThumbFiles.put(type, file);
        }
        return file;
    }

    private final String $$robo$$android_media_MiniThumbFile$randomAccessFilePath(int version) {
        String directoryName = Environment.getExternalStorageDirectory().toString() + "/DCIM/.thumbnails";
        return directoryName + "/.thumbdata" + version + "-" + this.mUri.hashCode();
    }

    private final void $$robo$$android_media_MiniThumbFile$removeOldFile() {
        String oldPath = this.randomAccessFilePath(2);
        File oldFile = new File(oldPath);
        if (oldFile.exists()) {
            try {
                oldFile.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private final RandomAccessFile $$robo$$android_media_MiniThumbFile$miniThumbDataFile() {
        if (this.mMiniThumbFile == null) {
            this.removeOldFile();
            String path = this.randomAccessFilePath(3);
            File directory = new File(path).getParentFile();
            if (!directory.isDirectory() && !directory.mkdirs()) {
                Log.e("MiniThumbFile", "Unable to create .thumbnails directory " + directory.toString());
            }
            File f = new File(path);
            try {
                this.mMiniThumbFile = new RandomAccessFile(f, "rw");
            }
            catch (IOException ex) {
                try {
                    this.mMiniThumbFile = new RandomAccessFile(f, "r");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.mMiniThumbFile != null) {
                this.mChannel = this.mMiniThumbFile.getChannel();
            }
        }
        return this.mMiniThumbFile;
    }

    private void $$robo$$android_media_MiniThumbFile$__constructor__(Uri uri) {
        this.mUri = uri;
        this.mBuffer = ByteBuffer.allocateDirect(10000);
    }

    private final synchronized void $$robo$$android_media_MiniThumbFile$deactivate() {
        if (this.mMiniThumbFile != null) {
            try {
                this.mMiniThumbFile.close();
                this.mMiniThumbFile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized long $$robo$$android_media_MiniThumbFile$getMagic(long id2) {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r != null) {
            long pos = id2 * 10000L;
            FileLock lock = null;
            try {
                this.mBuffer.clear();
                this.mBuffer.limit(9);
                lock = this.mChannel.lock(pos, 9L, true);
                if (this.mChannel.read(this.mBuffer, pos) == 9) {
                    this.mBuffer.position(0);
                    if (this.mBuffer.get() == 1) {
                        long l = this.mBuffer.getLong();
                        return l;
                    }
                }
            }
            catch (IOException ex) {
                Log.v("MiniThumbFile", "Got exception checking file magic: ", ex);
            }
            catch (RuntimeException ex) {
                Log.e("MiniThumbFile", "Got exception when reading magic, id = " + id2 + ", disk full or mount read-only? " + ex.getClass());
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (IOException ex) {}
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void $$robo$$android_media_MiniThumbFile$saveMiniThumbToFile(byte[] data, long id2, long magic) throws IOException {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r == null) {
            return;
        }
        long pos = id2 * 10000L;
        FileLock lock = null;
        try {
            if (data != null) {
                if (data.length > 9987) {
                    return;
                }
                this.mBuffer.clear();
                this.mBuffer.put((byte)1);
                this.mBuffer.putLong(magic);
                this.mBuffer.putInt(data.length);
                this.mBuffer.put(data);
                this.mBuffer.flip();
                lock = this.mChannel.lock(pos, 10000L, false);
                this.mChannel.write(this.mBuffer, pos);
            }
        }
        catch (IOException ex) {
            Log.e("MiniThumbFile", "couldn't save mini thumbnail data for " + id2 + "; ", ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            Log.e("MiniThumbFile", "couldn't save mini thumbnail data for " + id2 + "; disk full or mount read-only? " + ex.getClass());
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized byte[] $$robo$$android_media_MiniThumbFile$getMiniThumbFromFile(long id2, byte[] data) {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r == null) {
            return null;
        }
        long pos = id2 * 10000L;
        FileLock lock = null;
        try {
            this.mBuffer.clear();
            lock = this.mChannel.lock(pos, 10000L, true);
            int size = this.mChannel.read(this.mBuffer, pos);
            if (size > 13) {
                this.mBuffer.position(0);
                byte flag = this.mBuffer.get();
                long magic = this.mBuffer.getLong();
                int length = this.mBuffer.getInt();
                if (size >= 13 + length && length != 0 && magic != 0L && flag == 1 && data.length >= length) {
                    this.mBuffer.get(data, 0, length);
                    byte[] byArray = data;
                    return byArray;
                }
            }
        }
        catch (IOException ex) {
            Log.w("MiniThumbFile", "got exception when reading thumbnail id=" + id2 + ", exception: " + ex);
        }
        catch (RuntimeException ex) {
            Log.e("MiniThumbFile", "Got exception when reading thumbnail, id = " + id2 + ", disk full or mount read-only? " + ex.getClass());
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException ex) {}
        }
        return null;
    }

    static void __staticInitializer__() {
        sThumbFiles = new Hashtable();
    }

    public static synchronized void reset() {
        InvokeDynamicSupport.bootstrapStatic("reset", $$robo$$android_media_MiniThumbFile$reset());
    }

    public static synchronized MiniThumbFile instance(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("instance", $$robo$$android_media_MiniThumbFile$instance(android.net.Uri ), (Uri)uri);
    }

    private String randomAccessFilePath(int n) {
        return InvokeDynamicSupport.bootstrap("randomAccessFilePath", $$robo$$android_media_MiniThumbFile$randomAccessFilePath(int ), this, n);
    }

    private void removeOldFile() {
        InvokeDynamicSupport.bootstrap("removeOldFile", $$robo$$android_media_MiniThumbFile$removeOldFile(), this);
    }

    private RandomAccessFile miniThumbDataFile() {
        return InvokeDynamicSupport.bootstrap("miniThumbDataFile", $$robo$$android_media_MiniThumbFile$miniThumbDataFile(), this);
    }

    private void __constructor__(Uri uri) {
        this.$$robo$$android_media_MiniThumbFile$__constructor__(uri);
    }

    public MiniThumbFile(Uri uri) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MiniThumbFile$__constructor__(android.net.Uri ), this, uri);
    }

    public synchronized void deactivate() {
        InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_media_MiniThumbFile$deactivate(), this);
    }

    public synchronized long getMagic(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getMagic", $$robo$$android_media_MiniThumbFile$getMagic(long ), this, l);
    }

    public synchronized void saveMiniThumbToFile(byte[] byArray, long l, long l2) throws IOException {
        InvokeDynamicSupport.bootstrap("saveMiniThumbToFile", $$robo$$android_media_MiniThumbFile$saveMiniThumbToFile(byte[] long long ), this, byArray, l, l2);
    }

    public synchronized byte[] getMiniThumbFromFile(long l, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("getMiniThumbFromFile", $$robo$$android_media_MiniThumbFile$getMiniThumbFromFile(long byte[] ), this, l, byArray);
    }

    static {
        RobolectricInternals.classInitializing(MiniThumbFile.class);
    }

    public /* synthetic */ MiniThumbFile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MiniThumbFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

