/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.io.IoUtils;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ExifInterface
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ExifInterface";
    private static boolean DEBUG = false;
    public static String TAG_ARTIST = "Artist";
    public static String TAG_BITS_PER_SAMPLE = "BitsPerSample";
    public static String TAG_COMPRESSION = "Compression";
    public static String TAG_COPYRIGHT = "Copyright";
    public static String TAG_DATETIME = "DateTime";
    public static String TAG_IMAGE_DESCRIPTION = "ImageDescription";
    public static String TAG_IMAGE_LENGTH = "ImageLength";
    public static String TAG_IMAGE_WIDTH = "ImageWidth";
    public static String TAG_JPEG_INTERCHANGE_FORMAT = "JPEGInterchangeFormat";
    public static String TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = "JPEGInterchangeFormatLength";
    public static String TAG_MAKE = "Make";
    public static String TAG_MODEL = "Model";
    public static String TAG_ORIENTATION = "Orientation";
    public static String TAG_PHOTOMETRIC_INTERPRETATION = "PhotometricInterpretation";
    public static String TAG_PLANAR_CONFIGURATION = "PlanarConfiguration";
    public static String TAG_PRIMARY_CHROMATICITIES = "PrimaryChromaticities";
    public static String TAG_REFERENCE_BLACK_WHITE = "ReferenceBlackWhite";
    public static String TAG_RESOLUTION_UNIT = "ResolutionUnit";
    public static String TAG_ROWS_PER_STRIP = "RowsPerStrip";
    public static String TAG_SAMPLES_PER_PIXEL = "SamplesPerPixel";
    public static String TAG_SOFTWARE = "Software";
    public static String TAG_STRIP_BYTE_COUNTS = "StripByteCounts";
    public static String TAG_STRIP_OFFSETS = "StripOffsets";
    public static String TAG_TRANSFER_FUNCTION = "TransferFunction";
    public static String TAG_WHITE_POINT = "WhitePoint";
    public static String TAG_X_RESOLUTION = "XResolution";
    public static String TAG_Y_CB_CR_COEFFICIENTS = "YCbCrCoefficients";
    public static String TAG_Y_CB_CR_POSITIONING = "YCbCrPositioning";
    public static String TAG_Y_CB_CR_SUB_SAMPLING = "YCbCrSubSampling";
    public static String TAG_Y_RESOLUTION = "YResolution";
    public static String TAG_APERTURE_VALUE = "ApertureValue";
    public static String TAG_BRIGHTNESS_VALUE = "BrightnessValue";
    public static String TAG_CFA_PATTERN = "CFAPattern";
    public static String TAG_COLOR_SPACE = "ColorSpace";
    public static String TAG_COMPONENTS_CONFIGURATION = "ComponentsConfiguration";
    public static String TAG_COMPRESSED_BITS_PER_PIXEL = "CompressedBitsPerPixel";
    public static String TAG_CONTRAST = "Contrast";
    public static String TAG_CUSTOM_RENDERED = "CustomRendered";
    public static String TAG_DATETIME_DIGITIZED = "DateTimeDigitized";
    public static String TAG_DATETIME_ORIGINAL = "DateTimeOriginal";
    public static String TAG_DEVICE_SETTING_DESCRIPTION = "DeviceSettingDescription";
    public static String TAG_DIGITAL_ZOOM_RATIO = "DigitalZoomRatio";
    public static String TAG_EXIF_VERSION = "ExifVersion";
    public static String TAG_EXPOSURE_BIAS_VALUE = "ExposureBiasValue";
    public static String TAG_EXPOSURE_INDEX = "ExposureIndex";
    public static String TAG_EXPOSURE_MODE = "ExposureMode";
    public static String TAG_EXPOSURE_PROGRAM = "ExposureProgram";
    public static String TAG_EXPOSURE_TIME = "ExposureTime";
    public static String TAG_F_NUMBER = "FNumber";
    @Deprecated
    public static String TAG_APERTURE = "FNumber";
    public static String TAG_FILE_SOURCE = "FileSource";
    public static String TAG_FLASH = "Flash";
    public static String TAG_FLASH_ENERGY = "FlashEnergy";
    public static String TAG_FLASHPIX_VERSION = "FlashpixVersion";
    public static String TAG_FOCAL_LENGTH = "FocalLength";
    public static String TAG_FOCAL_LENGTH_IN_35MM_FILM = "FocalLengthIn35mmFilm";
    public static String TAG_FOCAL_PLANE_RESOLUTION_UNIT = "FocalPlaneResolutionUnit";
    public static String TAG_FOCAL_PLANE_X_RESOLUTION = "FocalPlaneXResolution";
    public static String TAG_FOCAL_PLANE_Y_RESOLUTION = "FocalPlaneYResolution";
    public static String TAG_GAIN_CONTROL = "GainControl";
    public static String TAG_ISO_SPEED_RATINGS = "ISOSpeedRatings";
    @Deprecated
    public static String TAG_ISO = "ISOSpeedRatings";
    public static String TAG_IMAGE_UNIQUE_ID = "ImageUniqueID";
    public static String TAG_LIGHT_SOURCE = "LightSource";
    public static String TAG_MAKER_NOTE = "MakerNote";
    public static String TAG_MAX_APERTURE_VALUE = "MaxApertureValue";
    public static String TAG_METERING_MODE = "MeteringMode";
    public static String TAG_NEW_SUBFILE_TYPE = "NewSubfileType";
    public static String TAG_OECF = "OECF";
    public static String TAG_PIXEL_X_DIMENSION = "PixelXDimension";
    public static String TAG_PIXEL_Y_DIMENSION = "PixelYDimension";
    public static String TAG_RELATED_SOUND_FILE = "RelatedSoundFile";
    public static String TAG_SATURATION = "Saturation";
    public static String TAG_SCENE_CAPTURE_TYPE = "SceneCaptureType";
    public static String TAG_SCENE_TYPE = "SceneType";
    public static String TAG_SENSING_METHOD = "SensingMethod";
    public static String TAG_SHARPNESS = "Sharpness";
    public static String TAG_SHUTTER_SPEED_VALUE = "ShutterSpeedValue";
    public static String TAG_SPATIAL_FREQUENCY_RESPONSE = "SpatialFrequencyResponse";
    public static String TAG_SPECTRAL_SENSITIVITY = "SpectralSensitivity";
    public static String TAG_SUBFILE_TYPE = "SubfileType";
    public static String TAG_SUBSEC_TIME = "SubSecTime";
    public static String TAG_SUBSEC_TIME_DIG = "SubSecTimeDigitized";
    public static String TAG_SUBSEC_TIME_DIGITIZED = "SubSecTimeDigitized";
    public static String TAG_SUBSEC_TIME_ORIG = "SubSecTimeOriginal";
    public static String TAG_SUBSEC_TIME_ORIGINAL = "SubSecTimeOriginal";
    public static String TAG_SUBJECT_AREA = "SubjectArea";
    public static String TAG_SUBJECT_DISTANCE = "SubjectDistance";
    public static String TAG_SUBJECT_DISTANCE_RANGE = "SubjectDistanceRange";
    public static String TAG_SUBJECT_LOCATION = "SubjectLocation";
    public static String TAG_USER_COMMENT = "UserComment";
    public static String TAG_WHITE_BALANCE = "WhiteBalance";
    public static String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static String TAG_GPS_AREA_INFORMATION = "GPSAreaInformation";
    public static String TAG_GPS_DOP = "GPSDOP";
    public static String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static String TAG_GPS_DEST_BEARING = "GPSDestBearing";
    public static String TAG_GPS_DEST_BEARING_REF = "GPSDestBearingRef";
    public static String TAG_GPS_DEST_DISTANCE = "GPSDestDistance";
    public static String TAG_GPS_DEST_DISTANCE_REF = "GPSDestDistanceRef";
    public static String TAG_GPS_DEST_LATITUDE = "GPSDestLatitude";
    public static String TAG_GPS_DEST_LATITUDE_REF = "GPSDestLatitudeRef";
    public static String TAG_GPS_DEST_LONGITUDE = "GPSDestLongitude";
    public static String TAG_GPS_DEST_LONGITUDE_REF = "GPSDestLongitudeRef";
    public static String TAG_GPS_DIFFERENTIAL = "GPSDifferential";
    public static String TAG_GPS_IMG_DIRECTION = "GPSImgDirection";
    public static String TAG_GPS_IMG_DIRECTION_REF = "GPSImgDirectionRef";
    public static String TAG_GPS_LATITUDE = "GPSLatitude";
    public static String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static String TAG_GPS_MAP_DATUM = "GPSMapDatum";
    public static String TAG_GPS_MEASURE_MODE = "GPSMeasureMode";
    public static String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static String TAG_GPS_SATELLITES = "GPSSatellites";
    public static String TAG_GPS_SPEED = "GPSSpeed";
    public static String TAG_GPS_SPEED_REF = "GPSSpeedRef";
    public static String TAG_GPS_STATUS = "GPSStatus";
    public static String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static String TAG_GPS_TRACK = "GPSTrack";
    public static String TAG_GPS_TRACK_REF = "GPSTrackRef";
    public static String TAG_GPS_VERSION_ID = "GPSVersionID";
    public static String TAG_INTEROPERABILITY_INDEX = "InteroperabilityIndex";
    public static String TAG_THUMBNAIL_IMAGE_LENGTH = "ThumbnailImageLength";
    public static String TAG_THUMBNAIL_IMAGE_WIDTH = "ThumbnailImageWidth";
    public static String TAG_DNG_VERSION = "DNGVersion";
    public static String TAG_DEFAULT_CROP_SIZE = "DefaultCropSize";
    public static String TAG_ORF_THUMBNAIL_IMAGE = "ThumbnailImage";
    public static String TAG_ORF_PREVIEW_IMAGE_START = "PreviewImageStart";
    public static String TAG_ORF_PREVIEW_IMAGE_LENGTH = "PreviewImageLength";
    public static String TAG_ORF_ASPECT_FRAME = "AspectFrame";
    public static String TAG_RW2_SENSOR_BOTTOM_BORDER = "SensorBottomBorder";
    public static String TAG_RW2_SENSOR_LEFT_BORDER = "SensorLeftBorder";
    public static String TAG_RW2_SENSOR_RIGHT_BORDER = "SensorRightBorder";
    public static String TAG_RW2_SENSOR_TOP_BORDER = "SensorTopBorder";
    public static String TAG_RW2_ISO = "ISO";
    public static String TAG_RW2_JPG_FROM_RAW = "JpgFromRaw";
    private static String TAG_EXIF_IFD_POINTER = "ExifIFDPointer";
    private static String TAG_GPS_INFO_IFD_POINTER = "GPSInfoIFDPointer";
    private static String TAG_INTEROPERABILITY_IFD_POINTER = "InteroperabilityIFDPointer";
    private static String TAG_SUB_IFD_POINTER = "SubIFDPointer";
    private static String TAG_ORF_CAMERA_SETTINGS_IFD_POINTER = "CameraSettingsIFDPointer";
    private static String TAG_ORF_IMAGE_PROCESSING_IFD_POINTER = "ImageProcessingIFDPointer";
    private static String TAG_HAS_THUMBNAIL = "HasThumbnail";
    private static String TAG_THUMBNAIL_OFFSET = "ThumbnailOffset";
    private static String TAG_THUMBNAIL_LENGTH = "ThumbnailLength";
    private static String TAG_THUMBNAIL_DATA = "ThumbnailData";
    private static int MAX_THUMBNAIL_SIZE = 512;
    public static int ORIENTATION_UNDEFINED = 0;
    public static int ORIENTATION_NORMAL = 1;
    public static int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static int ORIENTATION_ROTATE_180 = 3;
    public static int ORIENTATION_FLIP_VERTICAL = 4;
    public static int ORIENTATION_TRANSPOSE = 5;
    public static int ORIENTATION_ROTATE_90 = 6;
    public static int ORIENTATION_TRANSVERSE = 7;
    public static int ORIENTATION_ROTATE_270 = 8;
    public static int WHITEBALANCE_AUTO = 0;
    public static int WHITEBALANCE_MANUAL = 1;
    private static int SIGNATURE_CHECK_SIZE = 5000;
    private static byte[] JPEG_SIGNATURE;
    private static String RAF_SIGNATURE = "FUJIFILMCCD-RAW";
    private static int RAF_OFFSET_TO_JPEG_IMAGE_OFFSET = 84;
    private static int RAF_INFO_SIZE = 160;
    private static int RAF_JPEG_LENGTH_VALUE_SIZE = 4;
    private static short ORF_SIGNATURE_1 = 20306;
    private static short ORF_SIGNATURE_2 = 21330;
    private static byte[] ORF_MAKER_NOTE_HEADER_1;
    private static byte[] ORF_MAKER_NOTE_HEADER_2;
    private static int ORF_MAKER_NOTE_HEADER_1_SIZE = 8;
    private static int ORF_MAKER_NOTE_HEADER_2_SIZE = 12;
    private static short RW2_SIGNATURE = 85;
    private static String PEF_SIGNATURE = "PENTAX";
    private static int PEF_MAKER_NOTE_SKIP_SIZE = 6;
    private static SimpleDateFormat sFormatter;
    private static short BYTE_ALIGN_II = 18761;
    private static short BYTE_ALIGN_MM = 19789;
    private static byte START_CODE = 42;
    private static int IFD_OFFSET = 8;
    private static int IFD_FORMAT_BYTE = 1;
    private static int IFD_FORMAT_STRING = 2;
    private static int IFD_FORMAT_USHORT = 3;
    private static int IFD_FORMAT_ULONG = 4;
    private static int IFD_FORMAT_URATIONAL = 5;
    private static int IFD_FORMAT_SBYTE = 6;
    private static int IFD_FORMAT_UNDEFINED = 7;
    private static int IFD_FORMAT_SSHORT = 8;
    private static int IFD_FORMAT_SLONG = 9;
    private static int IFD_FORMAT_SRATIONAL = 10;
    private static int IFD_FORMAT_SINGLE = 11;
    private static int IFD_FORMAT_DOUBLE = 12;
    private static int IFD_FORMAT_IFD = 13;
    private static String[] IFD_FORMAT_NAMES;
    private static int[] IFD_FORMAT_BYTES_PER_FORMAT;
    private static byte[] EXIF_ASCII_PREFIX;
    private static int DATA_UNCOMPRESSED = 1;
    private static int DATA_HUFFMAN_COMPRESSED = 2;
    private static int DATA_JPEG = 6;
    private static int DATA_JPEG_COMPRESSED = 7;
    private static int DATA_DEFLATE_ZIP = 8;
    private static int DATA_PACK_BITS_COMPRESSED = 32773;
    private static int DATA_LOSSY_JPEG = 34892;
    private static int[] BITS_PER_SAMPLE_RGB;
    private static int[] BITS_PER_SAMPLE_GREYSCALE_1;
    private static int[] BITS_PER_SAMPLE_GREYSCALE_2;
    private static int PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO = 0;
    private static int PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO = 1;
    private static int PHOTOMETRIC_INTERPRETATION_RGB = 2;
    private static int PHOTOMETRIC_INTERPRETATION_YCBCR = 6;
    private static int ORIGINAL_RESOLUTION_IMAGE = 0;
    private static int REDUCED_RESOLUTION_IMAGE = 1;
    private static ExifTag[] IFD_TIFF_TAGS;
    private static ExifTag[] IFD_EXIF_TAGS;
    private static ExifTag[] IFD_GPS_TAGS;
    private static ExifTag[] IFD_INTEROPERABILITY_TAGS;
    private static ExifTag[] IFD_THUMBNAIL_TAGS;
    private static ExifTag TAG_RAF_IMAGE_SIZE;
    private static ExifTag[] ORF_MAKER_NOTE_TAGS;
    private static ExifTag[] ORF_CAMERA_SETTINGS_TAGS;
    private static ExifTag[] ORF_IMAGE_PROCESSING_TAGS;
    private static ExifTag[] PEF_TAGS;
    private static int IFD_TYPE_PRIMARY = 0;
    private static int IFD_TYPE_EXIF = 1;
    private static int IFD_TYPE_GPS = 2;
    private static int IFD_TYPE_INTEROPERABILITY = 3;
    private static int IFD_TYPE_THUMBNAIL = 4;
    private static int IFD_TYPE_PREVIEW = 5;
    private static int IFD_TYPE_ORF_MAKER_NOTE = 6;
    private static int IFD_TYPE_ORF_CAMERA_SETTINGS = 7;
    private static int IFD_TYPE_ORF_IMAGE_PROCESSING = 8;
    private static int IFD_TYPE_PEF = 9;
    private static ExifTag[][] EXIF_TAGS;
    private static ExifTag[] EXIF_POINTER_TAGS;
    private static ExifTag JPEG_INTERCHANGE_FORMAT_TAG;
    private static ExifTag JPEG_INTERCHANGE_FORMAT_LENGTH_TAG;
    private static HashMap[] sExifTagMapsForReading;
    private static HashMap[] sExifTagMapsForWriting;
    private static HashSet<String> sTagSetForCompatibility;
    private static HashMap sExifPointerTagMap;
    private static Charset ASCII;
    private static byte[] IDENTIFIER_EXIF_APP1;
    private static byte MARKER = -1;
    private static byte MARKER_SOI = -40;
    private static byte MARKER_SOF0 = -64;
    private static byte MARKER_SOF1 = -63;
    private static byte MARKER_SOF2 = -62;
    private static byte MARKER_SOF3 = -61;
    private static byte MARKER_SOF5 = -59;
    private static byte MARKER_SOF6 = -58;
    private static byte MARKER_SOF7 = -57;
    private static byte MARKER_SOF9 = -55;
    private static byte MARKER_SOF10 = -54;
    private static byte MARKER_SOF11 = -53;
    private static byte MARKER_SOF13 = -51;
    private static byte MARKER_SOF14 = -50;
    private static byte MARKER_SOF15 = -49;
    private static byte MARKER_SOS = -38;
    private static byte MARKER_APP1 = -31;
    private static byte MARKER_COM = -2;
    private static byte MARKER_EOI = -39;
    private static int IMAGE_TYPE_UNKNOWN = 0;
    private static int IMAGE_TYPE_ARW = 1;
    private static int IMAGE_TYPE_CR2 = 2;
    private static int IMAGE_TYPE_DNG = 3;
    private static int IMAGE_TYPE_JPEG = 4;
    private static int IMAGE_TYPE_NEF = 5;
    private static int IMAGE_TYPE_NRW = 6;
    private static int IMAGE_TYPE_ORF = 7;
    private static int IMAGE_TYPE_PEF = 8;
    private static int IMAGE_TYPE_RAF = 9;
    private static int IMAGE_TYPE_RW2 = 10;
    private static int IMAGE_TYPE_SRW = 11;
    private String mFilename;
    private FileDescriptor mSeekableFileDescriptor;
    private AssetManager.AssetInputStream mAssetInputStream;
    private boolean mIsInputStream;
    private int mMimeType;
    private HashMap[] mAttributes;
    private ByteOrder mExifByteOrder;
    private boolean mHasThumbnail;
    private int mThumbnailOffset;
    private int mThumbnailLength;
    private byte[] mThumbnailBytes;
    private int mThumbnailCompression;
    private int mExifOffset;
    private int mOrfMakerNoteOffset;
    private int mOrfThumbnailOffset;
    private int mOrfThumbnailLength;
    private int mRw2JpgFromRawOffset;
    private boolean mIsSupportedFile;
    private static Pattern sNonZeroTimePattern;
    private static Pattern sGpsTimestampPattern;

    private void $$robo$$android_media_ExifInterface$__constructor__(String filename) throws IOException {
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        FileInputStream in = null;
        this.mAssetInputStream = null;
        this.mFilename = filename;
        this.mIsInputStream = false;
        try {
            in = new FileInputStream(filename);
            this.mSeekableFileDescriptor = ExifInterface.isSeekableFD(in.getFD()) ? in.getFD() : null;
            this.loadAttributes(in);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(in);
            throw throwable;
        }
        IoUtils.closeQuietly(in);
    }

    private void $$robo$$android_media_ExifInterface$__constructor__(FileDescriptor fileDescriptor) throws IOException {
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (fileDescriptor == null) {
            throw new IllegalArgumentException("fileDescriptor cannot be null");
        }
        this.mAssetInputStream = null;
        this.mFilename = null;
        if (ExifInterface.isSeekableFD(fileDescriptor)) {
            this.mSeekableFileDescriptor = fileDescriptor;
            try {
                fileDescriptor = Os.dup(fileDescriptor);
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        } else {
            this.mSeekableFileDescriptor = null;
        }
        this.mIsInputStream = false;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileDescriptor);
            this.loadAttributes(in);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(in);
            throw throwable;
        }
        IoUtils.closeQuietly(in);
    }

    private void $$robo$$android_media_ExifInterface$__constructor__(InputStream inputStream) throws IOException {
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null");
        }
        this.mFilename = null;
        if (inputStream instanceof AssetManager.AssetInputStream) {
            this.mAssetInputStream = (AssetManager.AssetInputStream)inputStream;
            this.mSeekableFileDescriptor = null;
        } else if (inputStream instanceof FileInputStream && ExifInterface.isSeekableFD(((FileInputStream)inputStream).getFD())) {
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = ((FileInputStream)inputStream).getFD();
        } else {
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = null;
        }
        this.mIsInputStream = true;
        this.loadAttributes(inputStream);
    }

    private final ExifAttribute $$robo$$android_media_ExifInterface$getExifAttribute(String tag) {
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            Object value = this.mAttributes[i].get(tag);
            if (value == null) continue;
            return (ExifAttribute)value;
        }
        return null;
    }

    private final String $$robo$$android_media_ExifInterface$getAttribute(String tag) {
        ExifAttribute attribute = this.getExifAttribute(tag);
        if (attribute != null) {
            if (!sTagSetForCompatibility.contains(tag)) {
                return attribute.getStringValue(this.mExifByteOrder);
            }
            if (tag.equals("GPSTimeStamp")) {
                if (attribute.format != 5 && attribute.format != 10) {
                    return null;
                }
                Rational[] array2 = (Rational[])attribute.getValue(this.mExifByteOrder);
                if (array2.length != 3) {
                    return null;
                }
                return String.format("%02d:%02d:%02d", (int)((float)array2[0].numerator / (float)array2[0].denominator), (int)((float)array2[1].numerator / (float)array2[1].denominator), (int)((float)array2[2].numerator / (float)array2[2].denominator));
            }
            try {
                return Double.toString(attribute.getDoubleValue(this.mExifByteOrder));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private final int $$robo$$android_media_ExifInterface$getAttributeInt(String tag, int defaultValue) {
        ExifAttribute exifAttribute = this.getExifAttribute(tag);
        if (exifAttribute == null) {
            return defaultValue;
        }
        try {
            return exifAttribute.getIntValue(this.mExifByteOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private final double $$robo$$android_media_ExifInterface$getAttributeDouble(String tag, double defaultValue) {
        ExifAttribute exifAttribute = this.getExifAttribute(tag);
        if (exifAttribute == null) {
            return defaultValue;
        }
        try {
            return exifAttribute.getDoubleValue(this.mExifByteOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private final void $$robo$$android_media_ExifInterface$setAttribute(String tag, String value) {
        if (value != null && sTagSetForCompatibility.contains(tag)) {
            if (tag.equals("GPSTimeStamp")) {
                Matcher m = sGpsTimestampPattern.matcher(value);
                if (!m.find()) {
                    Log.w("ExifInterface", "Invalid value for " + tag + " : " + value);
                    return;
                }
                value = Integer.parseInt(m.group(1)) + "/1," + Integer.parseInt(m.group(2)) + "/1," + Integer.parseInt(m.group(3)) + "/1";
            } else {
                try {
                    double doubleValue = Double.parseDouble(value);
                    value = (long)(doubleValue * 10000.0) + "/10000";
                }
                catch (NumberFormatException e) {
                    Log.w("ExifInterface", "Invalid value for " + tag + " : " + value);
                    return;
                }
            }
        }
        block12: for (int i = 0; i < EXIF_TAGS.length; ++i) {
            int dataFormat;
            Object obj;
            if (i == 4 && !this.mHasThumbnail || (obj = sExifTagMapsForWriting[i].get(tag)) == null) continue;
            if (value == null) {
                this.mAttributes[i].remove(tag);
                continue;
            }
            ExifTag exifTag = (ExifTag)obj;
            Pair<Integer, Integer> guess = ExifInterface.guessDataFormat(value);
            if (exifTag.primaryFormat == (Integer)guess.first || exifTag.primaryFormat == (Integer)guess.second) {
                dataFormat = exifTag.primaryFormat;
            } else if (exifTag.secondaryFormat != -1 && (exifTag.secondaryFormat == (Integer)guess.first || exifTag.secondaryFormat == (Integer)guess.second)) {
                dataFormat = exifTag.secondaryFormat;
            } else if (exifTag.primaryFormat == 1 || exifTag.primaryFormat == 7 || exifTag.primaryFormat == 2) {
                dataFormat = exifTag.primaryFormat;
            } else {
                Log.w("ExifInterface", "Given tag (" + tag + ") value didn't match with one of expected formats: " + IFD_FORMAT_NAMES[exifTag.primaryFormat] + (exifTag.secondaryFormat == -1 ? "" : ", " + IFD_FORMAT_NAMES[exifTag.secondaryFormat]) + " (guess: " + IFD_FORMAT_NAMES[(Integer)guess.first] + ((Integer)guess.second == -1 ? "" : ", " + IFD_FORMAT_NAMES[(Integer)guess.second]) + ")");
                continue;
            }
            switch (dataFormat) {
                case 1: {
                    this.mAttributes[i].put(tag, ExifAttribute.createByte(value));
                    continue block12;
                }
                case 2: 
                case 7: {
                    this.mAttributes[i].put(tag, ExifAttribute.createString(value));
                    continue block12;
                }
                case 3: {
                    int j;
                    String[] values = value.split(",");
                    int[] intArray = new int[values.length];
                    for (j = 0; j < values.length; ++j) {
                        intArray[j] = Integer.parseInt(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createUShort(intArray, this.mExifByteOrder));
                    continue block12;
                }
                case 9: {
                    int j;
                    String[] values = value.split(",");
                    int[] intArray = new int[values.length];
                    for (j = 0; j < values.length; ++j) {
                        intArray[j] = Integer.parseInt(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createSLong(intArray, this.mExifByteOrder));
                    continue block12;
                }
                case 4: {
                    int j;
                    String[] values = value.split(",");
                    long[] longArray = new long[values.length];
                    for (j = 0; j < values.length; ++j) {
                        longArray[j] = Long.parseLong(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createULong(longArray, this.mExifByteOrder));
                    continue block12;
                }
                case 5: {
                    String[] numbers;
                    int j;
                    String[] values = value.split(",");
                    Rational[] rationalArray = new Rational[values.length];
                    for (j = 0; j < values.length; ++j) {
                        numbers = values[j].split("/");
                        rationalArray[j] = new Rational((long)Double.parseDouble(numbers[0]), (long)Double.parseDouble(numbers[1]), null);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createURational(rationalArray, this.mExifByteOrder));
                    continue block12;
                }
                case 10: {
                    String[] numbers;
                    int j;
                    String[] values = value.split(",");
                    Rational[] rationalArray = new Rational[values.length];
                    for (j = 0; j < values.length; ++j) {
                        numbers = values[j].split("/");
                        rationalArray[j] = new Rational((long)Double.parseDouble(numbers[0]), (long)Double.parseDouble(numbers[1]), null);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createSRational(rationalArray, this.mExifByteOrder));
                    continue block12;
                }
                case 12: {
                    int j;
                    String[] values = value.split(",");
                    double[] doubleArray = new double[values.length];
                    for (j = 0; j < values.length; ++j) {
                        doubleArray[j] = Double.parseDouble(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createDouble(doubleArray, this.mExifByteOrder));
                    continue block12;
                }
                default: {
                    Log.w("ExifInterface", "Data format isn't one of expected formats: " + dataFormat);
                    continue block12;
                }
            }
        }
    }

    private final boolean $$robo$$android_media_ExifInterface$updateAttribute(String tag, ExifAttribute value) {
        boolean updated = false;
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            if (!this.mAttributes[i].containsKey(tag)) continue;
            this.mAttributes[i].put(tag, value);
            updated = true;
        }
        return updated;
    }

    private final void $$robo$$android_media_ExifInterface$removeAttribute(String tag) {
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            this.mAttributes[i].remove(tag);
        }
    }

    private final void $$robo$$android_media_ExifInterface$loadAttributes(InputStream in) throws IOException {
        try {
            for (int i = 0; i < EXIF_TAGS.length; ++i) {
                this.mAttributes[i] = new HashMap();
            }
            in = new BufferedInputStream(in, 5000);
            this.mMimeType = this.getMimeType((BufferedInputStream)in);
            ByteOrderedDataInputStream inputStream = new ByteOrderedDataInputStream(in);
            switch (this.mMimeType) {
                case 4: {
                    this.getJpegAttributes(inputStream, 0, 0);
                    break;
                }
                case 9: {
                    this.getRafAttributes(inputStream);
                    break;
                }
                case 7: {
                    this.getOrfAttributes(inputStream);
                    break;
                }
                case 10: {
                    this.getRw2Attributes(inputStream);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 11: {
                    this.getRawAttributes(inputStream);
                    break;
                }
            }
            this.setThumbnailData(inputStream);
            this.mIsSupportedFile = true;
        }
        catch (IOException e) {
            this.mIsSupportedFile = false;
        }
        finally {
            this.addDefaultValuesForCompatibility();
        }
    }

    private static final boolean $$robo$$android_media_ExifInterface$isSeekableFD(FileDescriptor fd) throws IOException {
        try {
            Os.lseek(fd, 0L, OsConstants.SEEK_CUR);
            return true;
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    private final void $$robo$$android_media_ExifInterface$printAttributes() {
        for (int i = 0; i < this.mAttributes.length; ++i) {
            Log.d("ExifInterface", "The size of tag group[" + i + "]: " + this.mAttributes[i].size());
            for (Map.Entry entry : this.mAttributes[i].entrySet()) {
                ExifAttribute tagValue = (ExifAttribute)entry.getValue();
                Log.d("ExifInterface", "tagName: " + entry.getKey() + ", tagType: " + tagValue.toString() + ", tagValue: '" + tagValue.getStringValue(this.mExifByteOrder) + "'");
            }
        }
    }

    private final void $$robo$$android_media_ExifInterface$saveAttributes() throws IOException {
        if (!this.mIsSupportedFile || this.mMimeType != 4) {
            throw new IOException("ExifInterface only supports saving attributes on JPEG formats.");
        }
        if (this.mIsInputStream || this.mSeekableFileDescriptor == null && this.mFilename == null) {
            throw new IOException("ExifInterface does not support saving attributes for the current input.");
        }
        this.mThumbnailBytes = this.getThumbnail();
        FileInputStream in = null;
        FileOutputStream out = null;
        File tempFile = null;
        try {
            if (this.mFilename != null) {
                File originalFile = new File(this.mFilename);
                tempFile = new File(this.mFilename + ".tmp");
                if (!originalFile.renameTo(tempFile)) {
                    throw new IOException("Could'nt rename to " + tempFile.getAbsolutePath());
                }
            } else if (this.mSeekableFileDescriptor != null) {
                tempFile = File.createTempFile("temp", "jpg");
                Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                in = new FileInputStream(this.mSeekableFileDescriptor);
                out = new FileOutputStream(tempFile);
                Streams.copy(in, out);
            }
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
        finally {
            IoUtils.closeQuietly(in);
            IoUtils.closeQuietly(out);
        }
        in = null;
        out = null;
        try {
            in = new FileInputStream(tempFile);
            if (this.mFilename != null) {
                out = new FileOutputStream(this.mFilename);
            } else if (this.mSeekableFileDescriptor != null) {
                Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                out = new FileOutputStream(this.mSeekableFileDescriptor);
            }
            this.saveJpegAttributes(in, out);
        }
        catch (ErrnoException e) {
            try {
                throw e.rethrowAsIOException();
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(out);
                tempFile.delete();
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
        IoUtils.closeQuietly(out);
        tempFile.delete();
        this.mThumbnailBytes = null;
    }

    private final boolean $$robo$$android_media_ExifInterface$hasThumbnail() {
        return this.mHasThumbnail;
    }

    private final byte[] $$robo$$android_media_ExifInterface$getThumbnail() {
        if (this.mThumbnailCompression == 6 || this.mThumbnailCompression == 7) {
            return this.getThumbnailBytes();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final byte[] $$robo$$android_media_ExifInterface$getThumbnailBytes() {
        block13: {
            block15: {
                if (!this.mHasThumbnail) {
                    return null;
                }
                if (this.mThumbnailBytes != null) {
                    return this.mThumbnailBytes;
                }
                in = null;
                if (this.mAssetInputStream == null) break block13;
                in = this.mAssetInputStream;
                if (!in.markSupported()) break block15;
                in.reset();
                ** GOTO lbl28
            }
            Log.d("ExifInterface", "Cannot read thumbnail from inputstream without mark/reset support");
            var2_2 = null;
            IoUtils.closeQuietly(in);
            return var2_2;
        }
        try {
            if (this.mFilename != null) {
                in = new FileInputStream(this.mFilename);
            } else if (this.mSeekableFileDescriptor != null) {
                fileDescriptor = Os.dup(this.mSeekableFileDescriptor);
                Os.lseek(fileDescriptor, 0L, OsConstants.SEEK_SET);
                in = new FileInputStream(fileDescriptor);
            }
lbl28:
            // 5 sources

            if (in == null) {
                throw new FileNotFoundException();
            }
            if (in.skip(this.mThumbnailOffset) != (long)this.mThumbnailOffset) {
                throw new IOException("Corrupted image");
            }
            buffer = new byte[this.mThumbnailLength];
            if (in.read(buffer) != this.mThumbnailLength) {
                throw new IOException("Corrupted image");
            }
            this.mThumbnailBytes = buffer;
            var3_5 = buffer;
        }
        catch (ErrnoException | IOException e) {
            try {
                Log.d("ExifInterface", "Encountered exception while getting thumbnail", e);
            }
            catch (Throwable var4_6) {
                IoUtils.closeQuietly(in);
                throw var4_6;
            }
            IoUtils.closeQuietly(in);
        }
        IoUtils.closeQuietly(in);
        return var3_5;
        return null;
    }

    private final Bitmap $$robo$$android_media_ExifInterface$getThumbnailBitmap() {
        if (!this.mHasThumbnail) {
            return null;
        }
        if (this.mThumbnailBytes == null) {
            this.mThumbnailBytes = this.getThumbnailBytes();
        }
        if (this.mThumbnailCompression == 6 || this.mThumbnailCompression == 7) {
            return BitmapFactory.decodeByteArray(this.mThumbnailBytes, 0, this.mThumbnailLength);
        }
        if (this.mThumbnailCompression == 1) {
            int[] rgbValues = new int[this.mThumbnailBytes.length / 3];
            int alpha = 0;
            for (int i = 0; i < rgbValues.length; ++i) {
                rgbValues[i] = alpha + (this.mThumbnailBytes[3 * i] << 16) + (this.mThumbnailBytes[3 * i + 1] << 8) + this.mThumbnailBytes[3 * i + 2];
            }
            ExifAttribute imageLengthAttribute = (ExifAttribute)this.mAttributes[4].get("ImageLength");
            ExifAttribute imageWidthAttribute = (ExifAttribute)this.mAttributes[4].get("ImageWidth");
            if (imageLengthAttribute != null && imageWidthAttribute != null) {
                int imageLength = imageLengthAttribute.getIntValue(this.mExifByteOrder);
                int imageWidth = imageWidthAttribute.getIntValue(this.mExifByteOrder);
                return Bitmap.createBitmap(rgbValues, imageWidth, imageLength, Bitmap.Config.ARGB_8888);
            }
        }
        return null;
    }

    private final boolean $$robo$$android_media_ExifInterface$isThumbnailCompressed() {
        if (!this.mHasThumbnail) {
            return false;
        }
        return this.mThumbnailCompression == 6 || this.mThumbnailCompression == 7;
    }

    private final long[] $$robo$$android_media_ExifInterface$getThumbnailRange() {
        if (!this.mHasThumbnail) {
            return null;
        }
        long[] range = new long[]{this.mThumbnailOffset, this.mThumbnailLength};
        return range;
    }

    private final boolean $$robo$$android_media_ExifInterface$getLatLong(float[] output) {
        String latValue = this.getAttribute("GPSLatitude");
        String latRef = this.getAttribute("GPSLatitudeRef");
        String lngValue = this.getAttribute("GPSLongitude");
        String lngRef = this.getAttribute("GPSLongitudeRef");
        if (latValue != null && latRef != null && lngValue != null && lngRef != null) {
            try {
                output[0] = ExifInterface.convertRationalLatLonToFloat(latValue, latRef);
                output[1] = ExifInterface.convertRationalLatLonToFloat(lngValue, lngRef);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private final double $$robo$$android_media_ExifInterface$getAltitude(double defaultValue) {
        double altitude = this.getAttributeDouble("GPSAltitude", -1.0);
        int ref = this.getAttributeInt("GPSAltitudeRef", -1);
        if (altitude >= 0.0 && ref >= 0) {
            return altitude * (double)(ref == 1 ? -1 : 1);
        }
        return defaultValue;
    }

    private final long $$robo$$android_media_ExifInterface$getDateTime() {
        String dateTimeString = this.getAttribute("DateTime");
        if (dateTimeString == null || !sNonZeroTimePattern.matcher(dateTimeString).matches()) {
            return -1L;
        }
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            long msecs = datetime.getTime();
            String subSecs = this.getAttribute("SubSecTime");
            if (subSecs != null) {
                try {
                    long sub;
                    for (sub = Long.parseLong(subSecs); sub > 1000L; sub /= 10L) {
                    }
                    msecs += sub;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return msecs;
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    private final long $$robo$$android_media_ExifInterface$getGpsDateTime() {
        String date = this.getAttribute("GPSDateStamp");
        String time = this.getAttribute("GPSTimeStamp");
        if (date == null || time == null || !sNonZeroTimePattern.matcher(date).matches() && !sNonZeroTimePattern.matcher(time).matches()) {
            return -1L;
        }
        String dateTimeString = date + ' ' + time;
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            return datetime.getTime();
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    private static final float $$robo$$android_media_ExifInterface$convertRationalLatLonToFloat(String rationalString, String ref) {
        try {
            String[] parts = rationalString.split(",");
            String[] pair = parts[0].split("/");
            double degrees = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[1].split("/");
            double minutes = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[2].split("/");
            double seconds = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            double result = degrees + minutes / 60.0 + seconds / 3600.0;
            if (ref.equals("S") || ref.equals("W")) {
                return (float)(-result);
            }
            return (float)result;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    private final int $$robo$$android_media_ExifInterface$getMimeType(BufferedInputStream in) throws IOException {
        in.mark(5000);
        byte[] signatureCheckBytes = new byte[5000];
        if (in.read(signatureCheckBytes) != 5000) {
            throw new EOFException();
        }
        in.reset();
        if (ExifInterface.isJpegFormat(signatureCheckBytes)) {
            return 4;
        }
        if (this.isRafFormat(signatureCheckBytes)) {
            return 9;
        }
        if (this.isOrfFormat(signatureCheckBytes)) {
            return 7;
        }
        if (this.isRw2Format(signatureCheckBytes)) {
            return 10;
        }
        return 0;
    }

    private static final boolean $$robo$$android_media_ExifInterface$isJpegFormat(byte[] signatureCheckBytes) throws IOException {
        for (int i = 0; i < JPEG_SIGNATURE.length; ++i) {
            if (signatureCheckBytes[i] == JPEG_SIGNATURE[i]) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_media_ExifInterface$isRafFormat(byte[] signatureCheckBytes) throws IOException {
        byte[] rafSignatureBytes = "FUJIFILMCCD-RAW".getBytes();
        for (int i = 0; i < rafSignatureBytes.length; ++i) {
            if (signatureCheckBytes[i] == rafSignatureBytes[i]) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_media_ExifInterface$isOrfFormat(byte[] signatureCheckBytes) throws IOException {
        ByteOrderedDataInputStream signatureInputStream = new ByteOrderedDataInputStream(signatureCheckBytes);
        this.mExifByteOrder = this.readByteOrder(signatureInputStream);
        signatureInputStream.setByteOrder(this.mExifByteOrder);
        short orfSignature = signatureInputStream.readShort();
        return orfSignature == 20306 || orfSignature == 21330;
    }

    private final boolean $$robo$$android_media_ExifInterface$isRw2Format(byte[] signatureCheckBytes) throws IOException {
        ByteOrderedDataInputStream signatureInputStream = new ByteOrderedDataInputStream(signatureCheckBytes);
        this.mExifByteOrder = this.readByteOrder(signatureInputStream);
        signatureInputStream.setByteOrder(this.mExifByteOrder);
        short signatureByte = signatureInputStream.readShort();
        return signatureByte == 85;
    }

    private final void $$robo$$android_media_ExifInterface$getJpegAttributes(ByteOrderedDataInputStream in, int jpegOffset, int imageType) throws IOException {
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        in.seek(jpegOffset);
        int bytesRead = jpegOffset;
        byte marker = in.readByte();
        if (marker != -1) {
            throw new IOException("Invalid marker: " + Integer.toHexString(marker & 0xFF));
        }
        ++bytesRead;
        if (in.readByte() != -40) {
            throw new IOException("Invalid marker: " + Integer.toHexString(marker & 0xFF));
        }
        ++bytesRead;
        while (true) {
            if ((marker = in.readByte()) != -1) {
                throw new IOException("Invalid marker:" + Integer.toHexString(marker & 0xFF));
            }
            ++bytesRead;
            marker = in.readByte();
            ++bytesRead;
            if (marker == -39 || marker == -38) break;
            int length = in.readUnsignedShort() - 2;
            bytesRead += 2;
            if (length < 0) {
                throw new IOException("Invalid length");
            }
            switch (marker) {
                case -31: {
                    if (length < 6) break;
                    byte[] identifier = new byte[6];
                    if (in.read(identifier) != 6) {
                        throw new IOException("Invalid exif");
                    }
                    bytesRead += 6;
                    length -= 6;
                    if (!Arrays.equals(identifier, IDENTIFIER_EXIF_APP1)) break;
                    if (length <= 0) {
                        throw new IOException("Invalid exif");
                    }
                    this.mExifOffset = bytesRead;
                    byte[] bytes = new byte[length];
                    if (in.read(bytes) != length) {
                        throw new IOException("Invalid exif");
                    }
                    bytesRead += length;
                    length = 0;
                    this.readExifSegment(bytes, imageType);
                    break;
                }
                case -2: {
                    byte[] bytes = new byte[length];
                    if (in.read(bytes) != length) {
                        throw new IOException("Invalid exif");
                    }
                    length = 0;
                    if (this.getAttribute("UserComment") != null) break;
                    this.mAttributes[1].put("UserComment", ExifAttribute.createString(new String(bytes, ASCII)));
                    break;
                }
                case -64: 
                case -63: 
                case -62: 
                case -61: 
                case -59: 
                case -58: 
                case -57: 
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    if (in.skipBytes(1) != 1) {
                        throw new IOException("Invalid SOFx");
                    }
                    this.mAttributes[imageType].put("ImageLength", ExifAttribute.createULong(in.readUnsignedShort(), this.mExifByteOrder));
                    this.mAttributes[imageType].put("ImageWidth", ExifAttribute.createULong(in.readUnsignedShort(), this.mExifByteOrder));
                    length -= 5;
                    break;
                }
            }
            if (length < 0) {
                throw new IOException("Invalid length");
            }
            if (in.skipBytes(length) != length) {
                throw new IOException("Invalid JPEG segment");
            }
            bytesRead += length;
        }
        in.setByteOrder(this.mExifByteOrder);
    }

    private final void $$robo$$android_media_ExifInterface$getRawAttributes(ByteOrderedDataInputStream in) throws IOException {
        ExifAttribute makerNoteAttribute;
        this.parseTiffHeaders(in, in.available());
        this.readImageFileDirectory(in, 0);
        this.updateImageSizeValues(in, 0);
        this.updateImageSizeValues(in, 5);
        this.updateImageSizeValues(in, 4);
        this.validateImages(in);
        if (this.mMimeType == 8 && (makerNoteAttribute = (ExifAttribute)this.mAttributes[1].get("MakerNote")) != null) {
            ByteOrderedDataInputStream makerNoteDataInputStream = new ByteOrderedDataInputStream(makerNoteAttribute.bytes);
            makerNoteDataInputStream.setByteOrder(this.mExifByteOrder);
            makerNoteDataInputStream.seek(6L);
            this.readImageFileDirectory(makerNoteDataInputStream, 9);
            ExifAttribute colorSpaceAttribute = (ExifAttribute)this.mAttributes[9].get("ColorSpace");
            if (colorSpaceAttribute != null) {
                this.mAttributes[1].put("ColorSpace", colorSpaceAttribute);
            }
        }
    }

    private final void $$robo$$android_media_ExifInterface$getRafAttributes(ByteOrderedDataInputStream in) throws IOException {
        in.skipBytes(84);
        byte[] jpegOffsetBytes = new byte[4];
        byte[] cfaHeaderOffsetBytes = new byte[4];
        in.read(jpegOffsetBytes);
        in.skipBytes(4);
        in.read(cfaHeaderOffsetBytes);
        int rafJpegOffset = ByteBuffer.wrap(jpegOffsetBytes).getInt();
        int rafCfaHeaderOffset = ByteBuffer.wrap(cfaHeaderOffsetBytes).getInt();
        this.getJpegAttributes(in, rafJpegOffset, 5);
        in.seek(rafCfaHeaderOffset);
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        int numberOfDirectoryEntry = in.readInt();
        for (int i = 0; i < numberOfDirectoryEntry; ++i) {
            int tagNumber = in.readUnsignedShort();
            int numberOfBytes = in.readUnsignedShort();
            if (tagNumber == ExifInterface.TAG_RAF_IMAGE_SIZE.number) {
                short imageLength = in.readShort();
                short imageWidth = in.readShort();
                ExifAttribute imageLengthAttribute = ExifAttribute.createUShort(imageLength, this.mExifByteOrder);
                ExifAttribute imageWidthAttribute = ExifAttribute.createUShort(imageWidth, this.mExifByteOrder);
                this.mAttributes[0].put("ImageLength", imageLengthAttribute);
                this.mAttributes[0].put("ImageWidth", imageWidthAttribute);
                return;
            }
            in.skipBytes(numberOfBytes);
        }
    }

    private final void $$robo$$android_media_ExifInterface$getOrfAttributes(ByteOrderedDataInputStream in) throws IOException {
        this.getRawAttributes(in);
        ExifAttribute makerNoteAttribute = (ExifAttribute)this.mAttributes[1].get("MakerNote");
        if (makerNoteAttribute != null) {
            ExifAttribute aspectFrameAttribute;
            ByteOrderedDataInputStream makerNoteDataInputStream = new ByteOrderedDataInputStream(makerNoteAttribute.bytes);
            makerNoteDataInputStream.setByteOrder(this.mExifByteOrder);
            byte[] makerNoteHeader1Bytes = new byte[ORF_MAKER_NOTE_HEADER_1.length];
            makerNoteDataInputStream.readFully(makerNoteHeader1Bytes);
            makerNoteDataInputStream.seek(0L);
            byte[] makerNoteHeader2Bytes = new byte[ORF_MAKER_NOTE_HEADER_2.length];
            makerNoteDataInputStream.readFully(makerNoteHeader2Bytes);
            if (Arrays.equals(makerNoteHeader1Bytes, ORF_MAKER_NOTE_HEADER_1)) {
                makerNoteDataInputStream.seek(8L);
            } else if (Arrays.equals(makerNoteHeader2Bytes, ORF_MAKER_NOTE_HEADER_2)) {
                makerNoteDataInputStream.seek(12L);
            }
            this.readImageFileDirectory(makerNoteDataInputStream, 6);
            ExifAttribute imageLengthAttribute = (ExifAttribute)this.mAttributes[7].get("PreviewImageStart");
            ExifAttribute bitsPerSampleAttribute = (ExifAttribute)this.mAttributes[7].get("PreviewImageLength");
            if (imageLengthAttribute != null && bitsPerSampleAttribute != null) {
                this.mAttributes[5].put("JPEGInterchangeFormat", imageLengthAttribute);
                this.mAttributes[5].put("JPEGInterchangeFormatLength", bitsPerSampleAttribute);
            }
            if ((aspectFrameAttribute = (ExifAttribute)this.mAttributes[8].get("AspectFrame")) != null) {
                int[] aspectFrameValues = new int[4];
                aspectFrameValues = (int[])aspectFrameAttribute.getValue(this.mExifByteOrder);
                if (aspectFrameValues[2] > aspectFrameValues[0] && aspectFrameValues[3] > aspectFrameValues[1]) {
                    int primaryImageWidth = aspectFrameValues[2] - aspectFrameValues[0] + 1;
                    int primaryImageLength = aspectFrameValues[3] - aspectFrameValues[1] + 1;
                    if (primaryImageWidth < primaryImageLength) {
                        primaryImageWidth += primaryImageLength;
                        primaryImageLength = primaryImageWidth - primaryImageLength;
                        primaryImageWidth -= primaryImageLength;
                    }
                    ExifAttribute primaryImageWidthAttribute = ExifAttribute.createUShort(primaryImageWidth, this.mExifByteOrder);
                    ExifAttribute primaryImageLengthAttribute = ExifAttribute.createUShort(primaryImageLength, this.mExifByteOrder);
                    this.mAttributes[0].put("ImageWidth", primaryImageWidthAttribute);
                    this.mAttributes[0].put("ImageLength", primaryImageLengthAttribute);
                }
            }
        }
    }

    private final void $$robo$$android_media_ExifInterface$getRw2Attributes(ByteOrderedDataInputStream in) throws IOException {
        this.getRawAttributes(in);
        ExifAttribute jpgFromRawAttribute = (ExifAttribute)this.mAttributes[0].get("JpgFromRaw");
        if (jpgFromRawAttribute != null) {
            this.getJpegAttributes(in, this.mRw2JpgFromRawOffset, 5);
        }
        ExifAttribute rw2IsoAttribute = (ExifAttribute)this.mAttributes[0].get("ISO");
        ExifAttribute exifIsoAttribute = (ExifAttribute)this.mAttributes[1].get("ISOSpeedRatings");
        if (rw2IsoAttribute != null && exifIsoAttribute == null) {
            this.mAttributes[1].put("ISOSpeedRatings", rw2IsoAttribute);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void $$robo$$android_media_ExifInterface$saveJpegAttributes(InputStream inputStream, OutputStream outputStream) throws IOException {
        dataInputStream = new DataInputStream(inputStream);
        dataOutputStream = new ByteOrderedDataOutputStream(outputStream, ByteOrder.BIG_ENDIAN);
        if (dataInputStream.readByte() != -1) {
            throw new IOException("Invalid marker");
        }
        dataOutputStream.writeByte(-1);
        if (dataInputStream.readByte() != -40) {
            throw new IOException("Invalid marker");
        }
        dataOutputStream.writeByte(-40);
        dataOutputStream.writeByte(-1);
        dataOutputStream.writeByte(-31);
        this.writeExifSegment(dataOutputStream, 6);
        bytes = new byte[4096];
        block4: while (true) {
            if ((marker = dataInputStream.readByte()) != -1) {
                throw new IOException("Invalid marker");
            }
            marker = dataInputStream.readByte();
            switch (marker) {
                case -31: {
                    length = dataInputStream.readUnsignedShort() - 2;
                    if (length < 0) {
                        throw new IOException("Invalid length");
                    }
                    identifier = new byte[6];
                    if (length >= 6) {
                        if (dataInputStream.read(identifier) != 6) {
                            throw new IOException("Invalid exif");
                        }
                        if (Arrays.equals(identifier, ExifInterface.IDENTIFIER_EXIF_APP1)) {
                            if (dataInputStream.skipBytes(length - 6) == length - 6) continue block4;
                            throw new IOException("Invalid length");
                        }
                    }
                    dataOutputStream.writeByte(-1);
                    dataOutputStream.writeByte(marker);
                    dataOutputStream.writeUnsignedShort(length + 2);
                    if (length >= 6) {
                        length -= 6;
                        dataOutputStream.write(identifier);
                    }
                    while (true) {
                        if (length <= 0 || (read = dataInputStream.read(bytes, 0, Math.min(length, bytes.length))) < 0) continue block4;
                        dataOutputStream.write(bytes, 0, read);
                        length -= read;
                    }
                }
                case -39: 
                case -38: {
                    dataOutputStream.writeByte(-1);
                    dataOutputStream.writeByte(marker);
                    Streams.copy(dataInputStream, dataOutputStream);
                    return;
                }
            }
            dataOutputStream.writeByte(-1);
            dataOutputStream.writeByte(marker);
            length = dataInputStream.readUnsignedShort();
            dataOutputStream.writeUnsignedShort(length);
            if ((length -= 2) < 0) {
                throw new IOException("Invalid length");
            }
            while (true) {
                if (length > 0 && (read = dataInputStream.read(bytes, 0, Math.min(length, bytes.length))) >= 0) ** break;
                continue block4;
                dataOutputStream.write(bytes, 0, read);
                length -= read;
            }
            break;
        }
    }

    private final void $$robo$$android_media_ExifInterface$readExifSegment(byte[] exifBytes, int imageType) throws IOException {
        ByteOrderedDataInputStream dataInputStream = new ByteOrderedDataInputStream(exifBytes);
        this.parseTiffHeaders(dataInputStream, exifBytes.length);
        this.readImageFileDirectory(dataInputStream, imageType);
    }

    private final void $$robo$$android_media_ExifInterface$addDefaultValuesForCompatibility() {
        String valueOfDateTimeOriginal = this.getAttribute("DateTimeOriginal");
        if (valueOfDateTimeOriginal != null) {
            this.mAttributes[0].put("DateTime", ExifAttribute.createString(valueOfDateTimeOriginal));
        }
        if (this.getAttribute("ImageWidth") == null) {
            this.mAttributes[0].put("ImageWidth", ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute("ImageLength") == null) {
            this.mAttributes[0].put("ImageLength", ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute("Orientation") == null) {
            this.mAttributes[0].put("Orientation", ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute("LightSource") == null) {
            this.mAttributes[1].put("LightSource", ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
    }

    private final ByteOrder $$robo$$android_media_ExifInterface$readByteOrder(ByteOrderedDataInputStream dataInputStream) throws IOException {
        short byteOrder = dataInputStream.readShort();
        switch (byteOrder) {
            case 18761: {
                return ByteOrder.LITTLE_ENDIAN;
            }
            case 19789: {
                return ByteOrder.BIG_ENDIAN;
            }
        }
        throw new IOException("Invalid byte order: " + Integer.toHexString(byteOrder));
    }

    private final void $$robo$$android_media_ExifInterface$parseTiffHeaders(ByteOrderedDataInputStream dataInputStream, int exifBytesLength) throws IOException {
        this.mExifByteOrder = this.readByteOrder(dataInputStream);
        dataInputStream.setByteOrder(this.mExifByteOrder);
        int startCode = dataInputStream.readUnsignedShort();
        if (this.mMimeType != 7 && this.mMimeType != 10 && startCode != 42) {
            throw new IOException("Invalid start code: " + Integer.toHexString(startCode));
        }
        int firstIfdOffset = dataInputStream.readInt();
        if (firstIfdOffset < 8 || firstIfdOffset >= exifBytesLength) {
            throw new IOException("Invalid first Ifd offset: " + firstIfdOffset);
        }
        if ((firstIfdOffset -= 8) > 0 && dataInputStream.skipBytes(firstIfdOffset) != firstIfdOffset) {
            throw new IOException("Couldn't jump to first Ifd: " + firstIfdOffset);
        }
    }

    private final void $$robo$$android_media_ExifInterface$readImageFileDirectory(ByteOrderedDataInputStream dataInputStream, int ifdType) throws IOException {
        int nextIfdOffset;
        if (dataInputStream.mPosition + 2 > dataInputStream.mLength) {
            return;
        }
        short numberOfDirectoryEntry = dataInputStream.readShort();
        if (dataInputStream.mPosition + 12 * numberOfDirectoryEntry > dataInputStream.mLength) {
            return;
        }
        for (short i = 0; i < numberOfDirectoryEntry; i = (short)(i + 1)) {
            Object nextIfdType;
            int tagNumber = dataInputStream.readUnsignedShort();
            int dataFormat = dataInputStream.readUnsignedShort();
            int numberOfComponents = dataInputStream.readInt();
            long nextEntryOffset = dataInputStream.peek() + 4;
            ExifTag tag = (ExifTag)sExifTagMapsForReading[ifdType].get(tagNumber);
            long byteCount = 0L;
            boolean valid = false;
            if (tag == null) {
                Log.w("ExifInterface", "Skip the tag entry since tag number is not defined: " + tagNumber);
            } else if (dataFormat <= 0 || dataFormat >= IFD_FORMAT_BYTES_PER_FORMAT.length) {
                Log.w("ExifInterface", "Skip the tag entry since data format is invalid: " + dataFormat);
            } else {
                byteCount = (long)numberOfComponents * (long)IFD_FORMAT_BYTES_PER_FORMAT[dataFormat];
                if (byteCount < 0L || byteCount > Integer.MAX_VALUE) {
                    Log.w("ExifInterface", "Skip the tag entry since the number of components is invalid: " + numberOfComponents);
                } else {
                    valid = true;
                }
            }
            if (!valid) {
                dataInputStream.seek(nextEntryOffset);
                continue;
            }
            if (byteCount > 4L) {
                int offset = dataInputStream.readInt();
                if (this.mMimeType == 7) {
                    if (tag.name == "MakerNote") {
                        this.mOrfMakerNoteOffset = offset;
                    } else if (ifdType == 6 && tag.name == "ThumbnailImage") {
                        this.mOrfThumbnailOffset = offset;
                        this.mOrfThumbnailLength = numberOfComponents;
                        ExifAttribute compressionAttribute = ExifAttribute.createUShort(6, this.mExifByteOrder);
                        ExifAttribute jpegInterchangeFormatAttribute = ExifAttribute.createULong(this.mOrfThumbnailOffset, this.mExifByteOrder);
                        ExifAttribute jpegInterchangeFormatLengthAttribute = ExifAttribute.createULong(this.mOrfThumbnailLength, this.mExifByteOrder);
                        this.mAttributes[4].put("Compression", compressionAttribute);
                        this.mAttributes[4].put("JPEGInterchangeFormat", jpegInterchangeFormatAttribute);
                        this.mAttributes[4].put("JPEGInterchangeFormatLength", jpegInterchangeFormatLengthAttribute);
                    }
                } else if (this.mMimeType == 10 && tag.name == "JpgFromRaw") {
                    this.mRw2JpgFromRawOffset = offset;
                }
                if ((long)offset + byteCount <= (long)dataInputStream.mLength) {
                    dataInputStream.seek(offset);
                } else {
                    Log.w("ExifInterface", "Skip the tag entry since data offset is invalid: " + offset);
                    dataInputStream.seek(nextEntryOffset);
                    continue;
                }
            }
            if ((nextIfdType = sExifPointerTagMap.get(tagNumber)) != null) {
                long offset = -1L;
                switch (dataFormat) {
                    case 3: {
                        offset = dataInputStream.readUnsignedShort();
                        break;
                    }
                    case 8: {
                        offset = dataInputStream.readShort();
                        break;
                    }
                    case 4: {
                        offset = dataInputStream.readUnsignedInt();
                        break;
                    }
                    case 9: 
                    case 13: {
                        offset = dataInputStream.readInt();
                        break;
                    }
                }
                if (offset > 0L && offset < (long)dataInputStream.mLength) {
                    dataInputStream.seek(offset);
                    this.readImageFileDirectory(dataInputStream, (Integer)nextIfdType);
                } else {
                    Log.w("ExifInterface", "Skip jump into the IFD since its offset is invalid: " + offset);
                }
                dataInputStream.seek(nextEntryOffset);
                continue;
            }
            byte[] bytes = new byte[(int)byteCount];
            dataInputStream.readFully(bytes);
            ExifAttribute attribute = new ExifAttribute(dataFormat, numberOfComponents, bytes, null);
            this.mAttributes[ifdType].put(tag.name, attribute);
            if (tag.name == "DNGVersion") {
                this.mMimeType = 3;
            }
            if ((tag.name == "Make" || tag.name == "Model") && attribute.getStringValue(this.mExifByteOrder).contains("PENTAX") || tag.name == "Compression" && attribute.getIntValue(this.mExifByteOrder) == 65535) {
                this.mMimeType = 8;
            }
            if ((long)dataInputStream.peek() == nextEntryOffset) continue;
            dataInputStream.seek(nextEntryOffset);
        }
        if (dataInputStream.peek() + 4 <= dataInputStream.mLength && (nextIfdOffset = dataInputStream.readInt()) > 8 && nextIfdOffset < dataInputStream.mLength) {
            dataInputStream.seek(nextIfdOffset);
            if (this.mAttributes[4].isEmpty()) {
                this.readImageFileDirectory(dataInputStream, 4);
            } else if (this.mAttributes[5].isEmpty()) {
                this.readImageFileDirectory(dataInputStream, 5);
            }
        }
    }

    private final void $$robo$$android_media_ExifInterface$retrieveJpegImageSize(ByteOrderedDataInputStream in, int imageType) throws IOException {
        ExifAttribute jpegInterchangeFormatAttribute;
        ExifAttribute imageLengthAttribute = (ExifAttribute)this.mAttributes[imageType].get("ImageLength");
        ExifAttribute imageWidthAttribute = (ExifAttribute)this.mAttributes[imageType].get("ImageWidth");
        if ((imageLengthAttribute == null || imageWidthAttribute == null) && (jpegInterchangeFormatAttribute = (ExifAttribute)this.mAttributes[imageType].get("JPEGInterchangeFormat")) != null) {
            int jpegInterchangeFormat = jpegInterchangeFormatAttribute.getIntValue(this.mExifByteOrder);
            this.getJpegAttributes(in, jpegInterchangeFormat, imageType);
        }
    }

    private final void $$robo$$android_media_ExifInterface$setThumbnailData(ByteOrderedDataInputStream in) throws IOException {
        HashMap thumbnailData = this.mAttributes[4];
        ExifAttribute compressionAttribute = (ExifAttribute)thumbnailData.get("Compression");
        if (compressionAttribute != null) {
            this.mThumbnailCompression = compressionAttribute.getIntValue(this.mExifByteOrder);
            switch (this.mThumbnailCompression) {
                case 6: {
                    this.handleThumbnailFromJfif(in, thumbnailData);
                    break;
                }
                case 1: 
                case 7: {
                    if (!this.isSupportedDataType(thumbnailData)) break;
                    this.handleThumbnailFromStrips(in, thumbnailData);
                }
            }
        } else {
            this.handleThumbnailFromJfif(in, thumbnailData);
        }
    }

    private final void $$robo$$android_media_ExifInterface$handleThumbnailFromJfif(ByteOrderedDataInputStream in, HashMap thumbnailData) throws IOException {
        ExifAttribute jpegInterchangeFormatAttribute = (ExifAttribute)thumbnailData.get("JPEGInterchangeFormat");
        ExifAttribute jpegInterchangeFormatLengthAttribute = (ExifAttribute)thumbnailData.get("JPEGInterchangeFormatLength");
        if (jpegInterchangeFormatAttribute != null && jpegInterchangeFormatLengthAttribute != null) {
            int thumbnailOffset = jpegInterchangeFormatAttribute.getIntValue(this.mExifByteOrder);
            int thumbnailLength = jpegInterchangeFormatLengthAttribute.getIntValue(this.mExifByteOrder);
            thumbnailLength = Math.min(thumbnailLength, in.available() - thumbnailOffset);
            if (this.mMimeType == 4 || this.mMimeType == 9 || this.mMimeType == 10) {
                thumbnailOffset += this.mExifOffset;
            } else if (this.mMimeType == 7) {
                thumbnailOffset += this.mOrfMakerNoteOffset;
            }
            if (thumbnailOffset > 0 && thumbnailLength > 0) {
                this.mHasThumbnail = true;
                this.mThumbnailOffset = thumbnailOffset;
                this.mThumbnailLength = thumbnailLength;
                this.mThumbnailCompression = 6;
                if (this.mFilename == null && this.mAssetInputStream == null && this.mSeekableFileDescriptor == null) {
                    byte[] thumbnailBytes = new byte[thumbnailLength];
                    in.seek(thumbnailOffset);
                    in.readFully(thumbnailBytes);
                    this.mThumbnailBytes = thumbnailBytes;
                }
            }
        }
    }

    private final void $$robo$$android_media_ExifInterface$handleThumbnailFromStrips(ByteOrderedDataInputStream in, HashMap thumbnailData) throws IOException {
        ExifAttribute stripOffsetsAttribute = (ExifAttribute)thumbnailData.get("StripOffsets");
        ExifAttribute stripByteCountsAttribute = (ExifAttribute)thumbnailData.get("StripByteCounts");
        if (stripOffsetsAttribute != null && stripByteCountsAttribute != null) {
            long[] stripOffsets = (long[])stripOffsetsAttribute.getValue(this.mExifByteOrder);
            long[] stripByteCounts = (long[])stripByteCountsAttribute.getValue(this.mExifByteOrder);
            byte[] totalStripBytes = new byte[(int)Arrays.stream(stripByteCounts).sum()];
            int bytesRead = 0;
            int bytesAdded = 0;
            for (int i = 0; i < stripOffsets.length; ++i) {
                int stripOffset = (int)stripOffsets[i];
                int stripByteCount = (int)stripByteCounts[i];
                int skipBytes = stripOffset - bytesRead;
                if (skipBytes < 0) {
                    Log.d("ExifInterface", "Invalid strip offset value");
                }
                in.seek(skipBytes);
                bytesRead += skipBytes;
                byte[] stripBytes = new byte[stripByteCount];
                in.read(stripBytes);
                bytesRead += stripByteCount;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])stripBytes, (int)0, (byte[])totalStripBytes, (int)bytesAdded, (int)stripBytes.length);
                bytesAdded += stripBytes.length;
            }
            this.mHasThumbnail = true;
            this.mThumbnailBytes = totalStripBytes;
            this.mThumbnailLength = totalStripBytes.length;
        }
    }

    private final boolean $$robo$$android_media_ExifInterface$isSupportedDataType(HashMap thumbnailData) throws IOException {
        ExifAttribute bitsPerSampleAttribute = (ExifAttribute)thumbnailData.get("BitsPerSample");
        if (bitsPerSampleAttribute != null) {
            int photometricInterpretationValue;
            ExifAttribute photometricInterpretationAttribute;
            int[] bitsPerSampleValue = (int[])bitsPerSampleAttribute.getValue(this.mExifByteOrder);
            if (Arrays.equals(BITS_PER_SAMPLE_RGB, bitsPerSampleValue)) {
                return true;
            }
            if (this.mMimeType == 3 && (photometricInterpretationAttribute = (ExifAttribute)thumbnailData.get("PhotometricInterpretation")) != null && ((photometricInterpretationValue = photometricInterpretationAttribute.getIntValue(this.mExifByteOrder)) == 1 && Arrays.equals(bitsPerSampleValue, BITS_PER_SAMPLE_GREYSCALE_2) || photometricInterpretationValue == 6 && Arrays.equals(bitsPerSampleValue, BITS_PER_SAMPLE_RGB))) {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_media_ExifInterface$isThumbnail(HashMap map) throws IOException {
        ExifAttribute imageLengthAttribute = (ExifAttribute)map.get("ImageLength");
        ExifAttribute imageWidthAttribute = (ExifAttribute)map.get("ImageWidth");
        if (imageLengthAttribute != null && imageWidthAttribute != null) {
            int imageLengthValue = imageLengthAttribute.getIntValue(this.mExifByteOrder);
            int imageWidthValue = imageWidthAttribute.getIntValue(this.mExifByteOrder);
            if (imageLengthValue <= 512 && imageWidthValue <= 512) {
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_media_ExifInterface$validateImages(InputStream in) throws IOException {
        this.swapBasedOnImageSize(0, 5);
        this.swapBasedOnImageSize(0, 4);
        this.swapBasedOnImageSize(5, 4);
        ExifAttribute pixelXDimAttribute = (ExifAttribute)this.mAttributes[1].get("PixelXDimension");
        ExifAttribute pixelYDimAttribute = (ExifAttribute)this.mAttributes[1].get("PixelYDimension");
        if (pixelXDimAttribute != null && pixelYDimAttribute != null) {
            this.mAttributes[0].put("ImageWidth", pixelXDimAttribute);
            this.mAttributes[0].put("ImageLength", pixelYDimAttribute);
        }
        if (this.mAttributes[4].isEmpty() && this.isThumbnail(this.mAttributes[5])) {
            this.mAttributes[4] = this.mAttributes[5];
            this.mAttributes[5] = new HashMap();
        }
        if (!this.isThumbnail(this.mAttributes[4])) {
            Log.d("ExifInterface", "No image meets the size requirements of a thumbnail image.");
        }
    }

    private final void $$robo$$android_media_ExifInterface$updateImageSizeValues(ByteOrderedDataInputStream in, int imageType) throws IOException {
        ExifAttribute defaultCropSizeAttribute = (ExifAttribute)this.mAttributes[imageType].get("DefaultCropSize");
        ExifAttribute topBorderAttribute = (ExifAttribute)this.mAttributes[imageType].get("SensorTopBorder");
        ExifAttribute leftBorderAttribute = (ExifAttribute)this.mAttributes[imageType].get("SensorLeftBorder");
        ExifAttribute bottomBorderAttribute = (ExifAttribute)this.mAttributes[imageType].get("SensorBottomBorder");
        ExifAttribute rightBorderAttribute = (ExifAttribute)this.mAttributes[imageType].get("SensorRightBorder");
        if (defaultCropSizeAttribute != null) {
            ExifAttribute defaultCropSizeYAttribute;
            ExifAttribute defaultCropSizeXAttribute;
            if (defaultCropSizeAttribute.format == 5) {
                Rational[] defaultCropSizeValue = (Rational[])defaultCropSizeAttribute.getValue(this.mExifByteOrder);
                defaultCropSizeXAttribute = ExifAttribute.createURational(defaultCropSizeValue[0], this.mExifByteOrder);
                defaultCropSizeYAttribute = ExifAttribute.createURational(defaultCropSizeValue[1], this.mExifByteOrder);
            } else {
                int[] defaultCropSizeValue = (int[])defaultCropSizeAttribute.getValue(this.mExifByteOrder);
                defaultCropSizeXAttribute = ExifAttribute.createUShort(defaultCropSizeValue[0], this.mExifByteOrder);
                defaultCropSizeYAttribute = ExifAttribute.createUShort(defaultCropSizeValue[1], this.mExifByteOrder);
            }
            this.mAttributes[imageType].put("ImageWidth", defaultCropSizeXAttribute);
            this.mAttributes[imageType].put("ImageLength", defaultCropSizeYAttribute);
        } else if (topBorderAttribute != null && leftBorderAttribute != null && bottomBorderAttribute != null && rightBorderAttribute != null) {
            int topBorderValue = topBorderAttribute.getIntValue(this.mExifByteOrder);
            int bottomBorderValue = bottomBorderAttribute.getIntValue(this.mExifByteOrder);
            int rightBorderValue = rightBorderAttribute.getIntValue(this.mExifByteOrder);
            int leftBorderValue = leftBorderAttribute.getIntValue(this.mExifByteOrder);
            if (bottomBorderValue > topBorderValue && rightBorderValue > leftBorderValue) {
                int length = bottomBorderValue - topBorderValue;
                int width = rightBorderValue - leftBorderValue;
                ExifAttribute imageLengthAttribute = ExifAttribute.createUShort(length, this.mExifByteOrder);
                ExifAttribute imageWidthAttribute = ExifAttribute.createUShort(width, this.mExifByteOrder);
                this.mAttributes[imageType].put("ImageLength", imageLengthAttribute);
                this.mAttributes[imageType].put("ImageWidth", imageWidthAttribute);
            }
        } else {
            this.retrieveJpegImageSize(in, imageType);
        }
    }

    private final int $$robo$$android_media_ExifInterface$writeExifSegment(ByteOrderedDataOutputStream dataOutputStream, int exifOffsetFromBeginning) throws IOException {
        int[] ifdOffsets = new int[EXIF_TAGS.length];
        int[] ifdDataSizes = new int[EXIF_TAGS.length];
        for (ExifTag tag : EXIF_POINTER_TAGS) {
            this.removeAttribute(tag.name);
        }
        this.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name);
        this.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name);
        for (int ifdType = 0; ifdType < EXIF_TAGS.length; ++ifdType) {
            for (Object obj : this.mAttributes[ifdType].entrySet().toArray()) {
                Map.Entry entry = (Map.Entry)obj;
                if (entry.getValue() != null) continue;
                this.mAttributes[ifdType].remove(entry.getKey());
            }
        }
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[1].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[2].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.EXIF_POINTER_TAGS[3].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.mHasThumbnail) {
            this.mAttributes[4].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(0L, this.mExifByteOrder));
            this.mAttributes[4].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name, ExifAttribute.createULong(this.mThumbnailLength, this.mExifByteOrder));
        }
        int i = 0;
        while (i < EXIF_TAGS.length) {
            int sum = 0;
            for (Map.Entry entry : this.mAttributes[i].entrySet()) {
                ExifAttribute exifAttribute = (ExifAttribute)entry.getValue();
                int size = exifAttribute.size();
                if (size <= 4) continue;
                sum += size;
            }
            int n = i++;
            ifdDataSizes[n] = ifdDataSizes[n] + sum;
        }
        int position = 8;
        for (int ifdType = 0; ifdType < EXIF_TAGS.length; ++ifdType) {
            if (this.mAttributes[ifdType].isEmpty()) continue;
            ifdOffsets[ifdType] = position;
            position += 2 + this.mAttributes[ifdType].size() * 12 + 4 + ifdDataSizes[ifdType];
        }
        if (this.mHasThumbnail) {
            int thumbnailOffset = position;
            this.mAttributes[4].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(thumbnailOffset, this.mExifByteOrder));
            this.mThumbnailOffset = exifOffsetFromBeginning + thumbnailOffset;
            position += this.mThumbnailLength;
        }
        int totalSize = position + 8;
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[1].name, ExifAttribute.createULong(ifdOffsets[1], this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[2].name, ExifAttribute.createULong(ifdOffsets[2], this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.EXIF_POINTER_TAGS[3].name, ExifAttribute.createULong(ifdOffsets[3], this.mExifByteOrder));
        }
        dataOutputStream.writeUnsignedShort(totalSize);
        dataOutputStream.write(IDENTIFIER_EXIF_APP1);
        dataOutputStream.writeShort(this.mExifByteOrder == ByteOrder.BIG_ENDIAN ? (short)19789 : 18761);
        dataOutputStream.setByteOrder(this.mExifByteOrder);
        dataOutputStream.writeUnsignedShort(42);
        dataOutputStream.writeUnsignedInt(8L);
        for (int ifdType = 0; ifdType < EXIF_TAGS.length; ++ifdType) {
            if (this.mAttributes[ifdType].isEmpty()) continue;
            dataOutputStream.writeUnsignedShort(this.mAttributes[ifdType].size());
            int dataOffset = ifdOffsets[ifdType] + 2 + this.mAttributes[ifdType].size() * 12 + 4;
            for (Map.Entry entry : this.mAttributes[ifdType].entrySet()) {
                ExifTag tag = (ExifTag)sExifTagMapsForWriting[ifdType].get(entry.getKey());
                int tagNumber = tag.number;
                ExifAttribute attribute = (ExifAttribute)entry.getValue();
                int size = attribute.size();
                dataOutputStream.writeUnsignedShort(tagNumber);
                dataOutputStream.writeUnsignedShort(attribute.format);
                dataOutputStream.writeInt(attribute.numberOfComponents);
                if (size > 4) {
                    dataOutputStream.writeUnsignedInt(dataOffset);
                    dataOffset += size;
                    continue;
                }
                dataOutputStream.write(attribute.bytes);
                if (size >= 4) continue;
                for (int i2 = size; i2 < 4; ++i2) {
                    dataOutputStream.writeByte(0);
                }
            }
            if (ifdType == 0 && !this.mAttributes[4].isEmpty()) {
                dataOutputStream.writeUnsignedInt(ifdOffsets[4]);
            } else {
                dataOutputStream.writeUnsignedInt(0L);
            }
            for (Map.Entry entry : this.mAttributes[ifdType].entrySet()) {
                ExifAttribute attribute = (ExifAttribute)entry.getValue();
                if (attribute.bytes.length <= 4) continue;
                dataOutputStream.write(attribute.bytes, 0, attribute.bytes.length);
            }
        }
        if (this.mHasThumbnail) {
            dataOutputStream.write(this.getThumbnailBytes());
        }
        dataOutputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        return totalSize;
    }

    private static final Pair<Integer, Integer> $$robo$$android_media_ExifInterface$guessDataFormat(String entryValue) {
        if (entryValue.contains(",")) {
            String[] entryValues = entryValue.split(",");
            Pair<Integer, Integer> dataFormat = ExifInterface.guessDataFormat(entryValues[0]);
            if ((Integer)dataFormat.first == 2) {
                return dataFormat;
            }
            for (int i = 1; i < entryValues.length; ++i) {
                Pair<Integer, Integer> guessDataFormat = ExifInterface.guessDataFormat(entryValues[i]);
                int first = -1;
                int second = -1;
                if (guessDataFormat.first == dataFormat.first || guessDataFormat.second == dataFormat.first) {
                    first = (Integer)dataFormat.first;
                }
                if ((Integer)dataFormat.second != -1 && (guessDataFormat.first == dataFormat.second || guessDataFormat.second == dataFormat.second)) {
                    second = (Integer)dataFormat.second;
                }
                if (first == -1 && second == -1) {
                    return new Pair<Integer, Integer>(2, -1);
                }
                if (first == -1) {
                    dataFormat = new Pair<Integer, Integer>(second, -1);
                    continue;
                }
                if (second != -1) continue;
                dataFormat = new Pair<Integer, Integer>(first, -1);
            }
            return dataFormat;
        }
        if (entryValue.contains("/")) {
            String[] rationalNumber = entryValue.split("/");
            if (rationalNumber.length == 2) {
                try {
                    long numerator = (long)Double.parseDouble(rationalNumber[0]);
                    long denominator = (long)Double.parseDouble(rationalNumber[1]);
                    if (numerator < 0L || denominator < 0L) {
                        return new Pair<Integer, Integer>(10, -1);
                    }
                    if (numerator > Integer.MAX_VALUE || denominator > Integer.MAX_VALUE) {
                        return new Pair<Integer, Integer>(5, -1);
                    }
                    return new Pair<Integer, Integer>(10, 5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new Pair<Integer, Integer>(2, -1);
        }
        try {
            Long longValue = Long.parseLong(entryValue);
            if (longValue >= 0L && longValue <= 65535L) {
                return new Pair<Integer, Integer>(3, 4);
            }
            if (longValue < 0L) {
                return new Pair<Integer, Integer>(9, -1);
            }
            return new Pair<Integer, Integer>(4, -1);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(entryValue);
                return new Pair<Integer, Integer>(12, -1);
            }
            catch (NumberFormatException numberFormatException2) {
                return new Pair<Integer, Integer>(2, -1);
            }
        }
    }

    private final void $$robo$$android_media_ExifInterface$swapBasedOnImageSize(int firstIfdType, int secondIfdType) throws IOException {
        if (this.mAttributes[firstIfdType].isEmpty() || this.mAttributes[secondIfdType].isEmpty()) {
            return;
        }
        ExifAttribute firstImageLengthAttribute = (ExifAttribute)this.mAttributes[firstIfdType].get("ImageLength");
        ExifAttribute firstImageWidthAttribute = (ExifAttribute)this.mAttributes[firstIfdType].get("ImageWidth");
        ExifAttribute secondImageLengthAttribute = (ExifAttribute)this.mAttributes[secondIfdType].get("ImageLength");
        ExifAttribute secondImageWidthAttribute = (ExifAttribute)this.mAttributes[secondIfdType].get("ImageWidth");
        if (firstImageLengthAttribute != null && firstImageWidthAttribute != null && secondImageLengthAttribute != null && secondImageWidthAttribute != null) {
            int firstImageLengthValue = firstImageLengthAttribute.getIntValue(this.mExifByteOrder);
            int firstImageWidthValue = firstImageWidthAttribute.getIntValue(this.mExifByteOrder);
            int secondImageLengthValue = secondImageLengthAttribute.getIntValue(this.mExifByteOrder);
            int secondImageWidthValue = secondImageWidthAttribute.getIntValue(this.mExifByteOrder);
            if (firstImageLengthValue < secondImageLengthValue && firstImageWidthValue < secondImageWidthValue) {
                HashMap tempMap = this.mAttributes[firstIfdType];
                this.mAttributes[firstIfdType] = this.mAttributes[secondIfdType];
                this.mAttributes[secondIfdType] = tempMap;
            }
        }
    }

    private final boolean $$robo$$android_media_ExifInterface$containsMatch(byte[] mainBytes, byte[] findBytes) {
        for (int i = 0; i < mainBytes.length - findBytes.length; ++i) {
            for (int j = 0; j < findBytes.length && mainBytes[i + j] == findBytes[j]; ++j) {
                if (j != findBytes.length - 1) continue;
                return true;
            }
        }
        return false;
    }

    static void __staticInitializer__() {
        JPEG_SIGNATURE = new byte[]{-1, -40, -1};
        ORF_MAKER_NOTE_HEADER_1 = new byte[]{79, 76, 89, 77, 80, 0};
        ORF_MAKER_NOTE_HEADER_2 = new byte[]{79, 76, 89, 77, 80, 85, 83, 0, 73, 73};
        IFD_FORMAT_NAMES = new String[]{"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE"};
        IFD_FORMAT_BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, 1};
        EXIF_ASCII_PREFIX = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
        BITS_PER_SAMPLE_RGB = new int[]{8, 8, 8};
        BITS_PER_SAMPLE_GREYSCALE_1 = new int[]{4};
        BITS_PER_SAMPLE_GREYSCALE_2 = new int[]{8};
        IFD_TIFF_TAGS = new ExifTag[]{new ExifTag("NewSubfileType", 254, 4, null), new ExifTag("SubfileType", 255, 4, null), new ExifTag("ImageWidth", 256, 3, 4, null), new ExifTag("ImageLength", 257, 3, 4, null), new ExifTag("BitsPerSample", 258, 3, null), new ExifTag("Compression", 259, 3, null), new ExifTag("PhotometricInterpretation", 262, 3, null), new ExifTag("ImageDescription", 270, 2, null), new ExifTag("Make", 271, 2, null), new ExifTag("Model", 272, 2, null), new ExifTag("StripOffsets", 273, 3, 4, null), new ExifTag("Orientation", 274, 3, null), new ExifTag("SamplesPerPixel", 277, 3, null), new ExifTag("RowsPerStrip", 278, 3, 4, null), new ExifTag("StripByteCounts", 279, 3, 4, null), new ExifTag("XResolution", 282, 5, null), new ExifTag("YResolution", 283, 5, null), new ExifTag("PlanarConfiguration", 284, 3, null), new ExifTag("ResolutionUnit", 296, 3, null), new ExifTag("TransferFunction", 301, 3, null), new ExifTag("Software", 305, 2, null), new ExifTag("DateTime", 306, 2, null), new ExifTag("Artist", 315, 2, null), new ExifTag("WhitePoint", 318, 5, null), new ExifTag("PrimaryChromaticities", 319, 5, null), new ExifTag("SubIFDPointer", 330, 4, null), new ExifTag("JPEGInterchangeFormat", 513, 4, null), new ExifTag("JPEGInterchangeFormatLength", 514, 4, null), new ExifTag("YCbCrCoefficients", 529, 5, null), new ExifTag("YCbCrSubSampling", 530, 3, null), new ExifTag("YCbCrPositioning", 531, 3, null), new ExifTag("ReferenceBlackWhite", 532, 5, null), new ExifTag("Copyright", 33432, 2, null), new ExifTag("ExifIFDPointer", 34665, 4, null), new ExifTag("GPSInfoIFDPointer", 34853, 4, null), new ExifTag("SensorTopBorder", 4, 4, null), new ExifTag("SensorLeftBorder", 5, 4, null), new ExifTag("SensorBottomBorder", 6, 4, null), new ExifTag("SensorRightBorder", 7, 4, null), new ExifTag("ISO", 23, 3, null), new ExifTag("JpgFromRaw", 46, 7, null)};
        IFD_EXIF_TAGS = new ExifTag[]{new ExifTag("ExposureTime", 33434, 5, null), new ExifTag("FNumber", 33437, 5, null), new ExifTag("ExposureProgram", 34850, 3, null), new ExifTag("SpectralSensitivity", 34852, 2, null), new ExifTag("ISOSpeedRatings", 34855, 3, null), new ExifTag("OECF", 34856, 7, null), new ExifTag("ExifVersion", 36864, 2, null), new ExifTag("DateTimeOriginal", 36867, 2, null), new ExifTag("DateTimeDigitized", 36868, 2, null), new ExifTag("ComponentsConfiguration", 37121, 7, null), new ExifTag("CompressedBitsPerPixel", 37122, 5, null), new ExifTag("ShutterSpeedValue", 37377, 10, null), new ExifTag("ApertureValue", 37378, 5, null), new ExifTag("BrightnessValue", 37379, 10, null), new ExifTag("ExposureBiasValue", 37380, 10, null), new ExifTag("MaxApertureValue", 37381, 5, null), new ExifTag("SubjectDistance", 37382, 5, null), new ExifTag("MeteringMode", 37383, 3, null), new ExifTag("LightSource", 37384, 3, null), new ExifTag("Flash", 37385, 3, null), new ExifTag("FocalLength", 37386, 5, null), new ExifTag("SubjectArea", 37396, 3, null), new ExifTag("MakerNote", 37500, 7, null), new ExifTag("UserComment", 37510, 7, null), new ExifTag("SubSecTime", 37520, 2, null), new ExifTag("SubSecTimeOriginal", 37521, 2, null), new ExifTag("SubSecTimeDigitized", 37522, 2, null), new ExifTag("FlashpixVersion", 40960, 7, null), new ExifTag("ColorSpace", 40961, 3, null), new ExifTag("PixelXDimension", 40962, 3, 4, null), new ExifTag("PixelYDimension", 40963, 3, 4, null), new ExifTag("RelatedSoundFile", 40964, 2, null), new ExifTag("InteroperabilityIFDPointer", 40965, 4, null), new ExifTag("FlashEnergy", 41483, 5, null), new ExifTag("SpatialFrequencyResponse", 41484, 7, null), new ExifTag("FocalPlaneXResolution", 41486, 5, null), new ExifTag("FocalPlaneYResolution", 41487, 5, null), new ExifTag("FocalPlaneResolutionUnit", 41488, 3, null), new ExifTag("SubjectLocation", 41492, 3, null), new ExifTag("ExposureIndex", 41493, 5, null), new ExifTag("SensingMethod", 41495, 3, null), new ExifTag("FileSource", 41728, 7, null), new ExifTag("SceneType", 41729, 7, null), new ExifTag("CFAPattern", 41730, 7, null), new ExifTag("CustomRendered", 41985, 3, null), new ExifTag("ExposureMode", 41986, 3, null), new ExifTag("WhiteBalance", 41987, 3, null), new ExifTag("DigitalZoomRatio", 41988, 5, null), new ExifTag("FocalLengthIn35mmFilm", 41989, 3, null), new ExifTag("SceneCaptureType", 41990, 3, null), new ExifTag("GainControl", 41991, 3, null), new ExifTag("Contrast", 41992, 3, null), new ExifTag("Saturation", 41993, 3, null), new ExifTag("Sharpness", 41994, 3, null), new ExifTag("DeviceSettingDescription", 41995, 7, null), new ExifTag("SubjectDistanceRange", 41996, 3, null), new ExifTag("ImageUniqueID", 42016, 2, null), new ExifTag("DNGVersion", 50706, 1, null), new ExifTag("DefaultCropSize", 50720, 3, 4, null)};
        IFD_GPS_TAGS = new ExifTag[]{new ExifTag("GPSVersionID", 0, 1, null), new ExifTag("GPSLatitudeRef", 1, 2, null), new ExifTag("GPSLatitude", 2, 5, null), new ExifTag("GPSLongitudeRef", 3, 2, null), new ExifTag("GPSLongitude", 4, 5, null), new ExifTag("GPSAltitudeRef", 5, 1, null), new ExifTag("GPSAltitude", 6, 5, null), new ExifTag("GPSTimeStamp", 7, 5, null), new ExifTag("GPSSatellites", 8, 2, null), new ExifTag("GPSStatus", 9, 2, null), new ExifTag("GPSMeasureMode", 10, 2, null), new ExifTag("GPSDOP", 11, 5, null), new ExifTag("GPSSpeedRef", 12, 2, null), new ExifTag("GPSSpeed", 13, 5, null), new ExifTag("GPSTrackRef", 14, 2, null), new ExifTag("GPSTrack", 15, 5, null), new ExifTag("GPSImgDirectionRef", 16, 2, null), new ExifTag("GPSImgDirection", 17, 5, null), new ExifTag("GPSMapDatum", 18, 2, null), new ExifTag("GPSDestLatitudeRef", 19, 2, null), new ExifTag("GPSDestLatitude", 20, 5, null), new ExifTag("GPSDestLongitudeRef", 21, 2, null), new ExifTag("GPSDestLongitude", 22, 5, null), new ExifTag("GPSDestBearingRef", 23, 2, null), new ExifTag("GPSDestBearing", 24, 5, null), new ExifTag("GPSDestDistanceRef", 25, 2, null), new ExifTag("GPSDestDistance", 26, 5, null), new ExifTag("GPSProcessingMethod", 27, 7, null), new ExifTag("GPSAreaInformation", 28, 7, null), new ExifTag("GPSDateStamp", 29, 2, null), new ExifTag("GPSDifferential", 30, 3, null)};
        IFD_INTEROPERABILITY_TAGS = new ExifTag[]{new ExifTag("InteroperabilityIndex", 1, 2, null)};
        IFD_THUMBNAIL_TAGS = new ExifTag[]{new ExifTag("NewSubfileType", 254, 4, null), new ExifTag("SubfileType", 255, 4, null), new ExifTag("ThumbnailImageWidth", 256, 3, 4, null), new ExifTag("ThumbnailImageLength", 257, 3, 4, null), new ExifTag("BitsPerSample", 258, 3, null), new ExifTag("Compression", 259, 3, null), new ExifTag("PhotometricInterpretation", 262, 3, null), new ExifTag("ImageDescription", 270, 2, null), new ExifTag("Make", 271, 2, null), new ExifTag("Model", 272, 2, null), new ExifTag("StripOffsets", 273, 3, 4, null), new ExifTag("Orientation", 274, 3, null), new ExifTag("SamplesPerPixel", 277, 3, null), new ExifTag("RowsPerStrip", 278, 3, 4, null), new ExifTag("StripByteCounts", 279, 3, 4, null), new ExifTag("XResolution", 282, 5, null), new ExifTag("YResolution", 283, 5, null), new ExifTag("PlanarConfiguration", 284, 3, null), new ExifTag("ResolutionUnit", 296, 3, null), new ExifTag("TransferFunction", 301, 3, null), new ExifTag("Software", 305, 2, null), new ExifTag("DateTime", 306, 2, null), new ExifTag("Artist", 315, 2, null), new ExifTag("WhitePoint", 318, 5, null), new ExifTag("PrimaryChromaticities", 319, 5, null), new ExifTag("SubIFDPointer", 330, 4, null), new ExifTag("JPEGInterchangeFormat", 513, 4, null), new ExifTag("JPEGInterchangeFormatLength", 514, 4, null), new ExifTag("YCbCrCoefficients", 529, 5, null), new ExifTag("YCbCrSubSampling", 530, 3, null), new ExifTag("YCbCrPositioning", 531, 3, null), new ExifTag("ReferenceBlackWhite", 532, 5, null), new ExifTag("Copyright", 33432, 2, null), new ExifTag("ExifIFDPointer", 34665, 4, null), new ExifTag("GPSInfoIFDPointer", 34853, 4, null), new ExifTag("DNGVersion", 50706, 1, null), new ExifTag("DefaultCropSize", 50720, 3, 4, null)};
        TAG_RAF_IMAGE_SIZE = new ExifTag("StripOffsets", 273, 3, null);
        ORF_MAKER_NOTE_TAGS = new ExifTag[]{new ExifTag("ThumbnailImage", 256, 7, null), new ExifTag("CameraSettingsIFDPointer", 8224, 4, null), new ExifTag("ImageProcessingIFDPointer", 8256, 4, null)};
        ORF_CAMERA_SETTINGS_TAGS = new ExifTag[]{new ExifTag("PreviewImageStart", 257, 4, null), new ExifTag("PreviewImageLength", 258, 4, null)};
        ORF_IMAGE_PROCESSING_TAGS = new ExifTag[]{new ExifTag("AspectFrame", 4371, 3, null)};
        PEF_TAGS = new ExifTag[]{new ExifTag("ColorSpace", 55, 3, null)};
        EXIF_TAGS = new ExifTag[][]{IFD_TIFF_TAGS, IFD_EXIF_TAGS, IFD_GPS_TAGS, IFD_INTEROPERABILITY_TAGS, IFD_THUMBNAIL_TAGS, IFD_TIFF_TAGS, ORF_MAKER_NOTE_TAGS, ORF_CAMERA_SETTINGS_TAGS, ORF_IMAGE_PROCESSING_TAGS, PEF_TAGS};
        EXIF_POINTER_TAGS = new ExifTag[]{new ExifTag("SubIFDPointer", 330, 4, null), new ExifTag("ExifIFDPointer", 34665, 4, null), new ExifTag("GPSInfoIFDPointer", 34853, 4, null), new ExifTag("InteroperabilityIFDPointer", 40965, 4, null), new ExifTag("CameraSettingsIFDPointer", 8224, 1, null), new ExifTag("ImageProcessingIFDPointer", 8256, 1, null)};
        JPEG_INTERCHANGE_FORMAT_TAG = new ExifTag("JPEGInterchangeFormat", 513, 4, null);
        JPEG_INTERCHANGE_FORMAT_LENGTH_TAG = new ExifTag("JPEGInterchangeFormatLength", 514, 4, null);
        sExifTagMapsForReading = new HashMap[EXIF_TAGS.length];
        sExifTagMapsForWriting = new HashMap[EXIF_TAGS.length];
        sTagSetForCompatibility = new HashSet<String>(Arrays.asList("FNumber", "DigitalZoomRatio", "ExposureTime", "SubjectDistance", "GPSTimeStamp"));
        sExifPointerTagMap = new HashMap();
        ASCII = Charset.forName("US-ASCII");
        IDENTIFIER_EXIF_APP1 = "Exif\u0000\u0000".getBytes(ASCII);
        sFormatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        sFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        for (int ifdType = 0; ifdType < EXIF_TAGS.length; ++ifdType) {
            ExifInterface.sExifTagMapsForReading[ifdType] = new HashMap();
            ExifInterface.sExifTagMapsForWriting[ifdType] = new HashMap();
            for (ExifTag tag : EXIF_TAGS[ifdType]) {
                sExifTagMapsForReading[ifdType].put(tag.number, tag);
                sExifTagMapsForWriting[ifdType].put(tag.name, tag);
            }
        }
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[0].number, 5);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[1].number, 1);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[2].number, 2);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[3].number, 3);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[4].number, 7);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[5].number, 8);
        sNonZeroTimePattern = Pattern.compile(".*[1-9].*");
        sGpsTimestampPattern = Pattern.compile("^([0-9][0-9]):([0-9][0-9]):([0-9][0-9])$");
    }

    private void __constructor__(String string2) throws IOException {
        this.$$robo$$android_media_ExifInterface$__constructor__(string2);
    }

    public ExifInterface(String string2) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__(FileDescriptor fileDescriptor) throws IOException {
        this.$$robo$$android_media_ExifInterface$__constructor__(fileDescriptor);
    }

    public ExifInterface(FileDescriptor fileDescriptor) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface$__constructor__(java.io.FileDescriptor ), this, fileDescriptor);
    }

    private void __constructor__(InputStream inputStream) throws IOException {
        this.$$robo$$android_media_ExifInterface$__constructor__(inputStream);
    }

    public ExifInterface(InputStream inputStream) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface$__constructor__(java.io.InputStream ), this, inputStream);
    }

    private ExifAttribute getExifAttribute(String string2) {
        return InvokeDynamicSupport.bootstrap("getExifAttribute", $$robo$$android_media_ExifInterface$getExifAttribute(java.lang.String ), this, string2);
    }

    public String getAttribute(String string2) {
        return InvokeDynamicSupport.bootstrap("getAttribute", $$robo$$android_media_ExifInterface$getAttribute(java.lang.String ), this, string2);
    }

    public int getAttributeInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getAttributeInt", $$robo$$android_media_ExifInterface$getAttributeInt(java.lang.String int ), this, string2, n);
    }

    public double getAttributeDouble(String string2, double d) {
        return (double)InvokeDynamicSupport.bootstrap("getAttributeDouble", $$robo$$android_media_ExifInterface$getAttributeDouble(java.lang.String double ), this, string2, d);
    }

    public void setAttribute(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setAttribute", $$robo$$android_media_ExifInterface$setAttribute(java.lang.String java.lang.String ), this, string2, string3);
    }

    private boolean updateAttribute(String string2, ExifAttribute exifAttribute) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAttribute", $$robo$$android_media_ExifInterface$updateAttribute(java.lang.String android.media.ExifInterface$ExifAttribute ), this, string2, exifAttribute);
    }

    private void removeAttribute(String string2) {
        InvokeDynamicSupport.bootstrap("removeAttribute", $$robo$$android_media_ExifInterface$removeAttribute(java.lang.String ), this, string2);
    }

    private void loadAttributes(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("loadAttributes", $$robo$$android_media_ExifInterface$loadAttributes(java.io.InputStream ), this, inputStream);
    }

    private static boolean isSeekableFD(FileDescriptor fileDescriptor) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSeekableFD", $$robo$$android_media_ExifInterface$isSeekableFD(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    private void printAttributes() {
        InvokeDynamicSupport.bootstrap("printAttributes", $$robo$$android_media_ExifInterface$printAttributes(), this);
    }

    public void saveAttributes() throws IOException {
        InvokeDynamicSupport.bootstrap("saveAttributes", $$robo$$android_media_ExifInterface$saveAttributes(), this);
    }

    public boolean hasThumbnail() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasThumbnail", $$robo$$android_media_ExifInterface$hasThumbnail(), this);
    }

    public byte[] getThumbnail() {
        return InvokeDynamicSupport.bootstrap("getThumbnail", $$robo$$android_media_ExifInterface$getThumbnail(), this);
    }

    public byte[] getThumbnailBytes() {
        return InvokeDynamicSupport.bootstrap("getThumbnailBytes", $$robo$$android_media_ExifInterface$getThumbnailBytes(), this);
    }

    public Bitmap getThumbnailBitmap() {
        return InvokeDynamicSupport.bootstrap("getThumbnailBitmap", $$robo$$android_media_ExifInterface$getThumbnailBitmap(), this);
    }

    public boolean isThumbnailCompressed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isThumbnailCompressed", $$robo$$android_media_ExifInterface$isThumbnailCompressed(), this);
    }

    public long[] getThumbnailRange() {
        return InvokeDynamicSupport.bootstrap("getThumbnailRange", $$robo$$android_media_ExifInterface$getThumbnailRange(), this);
    }

    public boolean getLatLong(float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("getLatLong", $$robo$$android_media_ExifInterface$getLatLong(float[] ), this, fArray);
    }

    public double getAltitude(double d) {
        return (double)InvokeDynamicSupport.bootstrap("getAltitude", $$robo$$android_media_ExifInterface$getAltitude(double ), this, d);
    }

    public long getDateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDateTime", $$robo$$android_media_ExifInterface$getDateTime(), this);
    }

    public long getGpsDateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getGpsDateTime", $$robo$$android_media_ExifInterface$getGpsDateTime(), this);
    }

    private static float convertRationalLatLonToFloat(String string2, String string3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("convertRationalLatLonToFloat", $$robo$$android_media_ExifInterface$convertRationalLatLonToFloat(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    private int getMimeType(BufferedInputStream bufferedInputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("getMimeType", $$robo$$android_media_ExifInterface$getMimeType(java.io.BufferedInputStream ), this, bufferedInputStream);
    }

    private static boolean isJpegFormat(byte[] byArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJpegFormat", $$robo$$android_media_ExifInterface$isJpegFormat(byte[] ), (byte[])byArray);
    }

    private boolean isRafFormat(byte[] byArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isRafFormat", $$robo$$android_media_ExifInterface$isRafFormat(byte[] ), this, byArray);
    }

    private boolean isOrfFormat(byte[] byArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isOrfFormat", $$robo$$android_media_ExifInterface$isOrfFormat(byte[] ), this, byArray);
    }

    private boolean isRw2Format(byte[] byArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isRw2Format", $$robo$$android_media_ExifInterface$isRw2Format(byte[] ), this, byArray);
    }

    private void getJpegAttributes(ByteOrderedDataInputStream byteOrderedDataInputStream, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("getJpegAttributes", $$robo$$android_media_ExifInterface$getJpegAttributes(android.media.ExifInterface$ByteOrderedDataInputStream int int ), this, byteOrderedDataInputStream, n, n2);
    }

    private void getRawAttributes(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("getRawAttributes", $$robo$$android_media_ExifInterface$getRawAttributes(android.media.ExifInterface$ByteOrderedDataInputStream ), this, byteOrderedDataInputStream);
    }

    private void getRafAttributes(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("getRafAttributes", $$robo$$android_media_ExifInterface$getRafAttributes(android.media.ExifInterface$ByteOrderedDataInputStream ), this, byteOrderedDataInputStream);
    }

    private void getOrfAttributes(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("getOrfAttributes", $$robo$$android_media_ExifInterface$getOrfAttributes(android.media.ExifInterface$ByteOrderedDataInputStream ), this, byteOrderedDataInputStream);
    }

    private void getRw2Attributes(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("getRw2Attributes", $$robo$$android_media_ExifInterface$getRw2Attributes(android.media.ExifInterface$ByteOrderedDataInputStream ), this, byteOrderedDataInputStream);
    }

    private void saveJpegAttributes(InputStream inputStream, OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("saveJpegAttributes", $$robo$$android_media_ExifInterface$saveJpegAttributes(java.io.InputStream java.io.OutputStream ), this, inputStream, outputStream);
    }

    private void readExifSegment(byte[] byArray, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("readExifSegment", $$robo$$android_media_ExifInterface$readExifSegment(byte[] int ), this, byArray, n);
    }

    private void addDefaultValuesForCompatibility() {
        InvokeDynamicSupport.bootstrap("addDefaultValuesForCompatibility", $$robo$$android_media_ExifInterface$addDefaultValuesForCompatibility(), this);
    }

    private ByteOrder readByteOrder(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        return InvokeDynamicSupport.bootstrap("readByteOrder", $$robo$$android_media_ExifInterface$readByteOrder(android.media.ExifInterface$ByteOrderedDataInputStream ), this, byteOrderedDataInputStream);
    }

    private void parseTiffHeaders(ByteOrderedDataInputStream byteOrderedDataInputStream, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("parseTiffHeaders", $$robo$$android_media_ExifInterface$parseTiffHeaders(android.media.ExifInterface$ByteOrderedDataInputStream int ), this, byteOrderedDataInputStream, n);
    }

    private void readImageFileDirectory(ByteOrderedDataInputStream byteOrderedDataInputStream, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("readImageFileDirectory", $$robo$$android_media_ExifInterface$readImageFileDirectory(android.media.ExifInterface$ByteOrderedDataInputStream int ), this, byteOrderedDataInputStream, n);
    }

    private void retrieveJpegImageSize(ByteOrderedDataInputStream byteOrderedDataInputStream, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("retrieveJpegImageSize", $$robo$$android_media_ExifInterface$retrieveJpegImageSize(android.media.ExifInterface$ByteOrderedDataInputStream int ), this, byteOrderedDataInputStream, n);
    }

    private void setThumbnailData(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("setThumbnailData", $$robo$$android_media_ExifInterface$setThumbnailData(android.media.ExifInterface$ByteOrderedDataInputStream ), this, byteOrderedDataInputStream);
    }

    private void handleThumbnailFromJfif(ByteOrderedDataInputStream byteOrderedDataInputStream, HashMap hashMap) throws IOException {
        InvokeDynamicSupport.bootstrap("handleThumbnailFromJfif", $$robo$$android_media_ExifInterface$handleThumbnailFromJfif(android.media.ExifInterface$ByteOrderedDataInputStream java.util.HashMap ), this, byteOrderedDataInputStream, hashMap);
    }

    private void handleThumbnailFromStrips(ByteOrderedDataInputStream byteOrderedDataInputStream, HashMap hashMap) throws IOException {
        InvokeDynamicSupport.bootstrap("handleThumbnailFromStrips", $$robo$$android_media_ExifInterface$handleThumbnailFromStrips(android.media.ExifInterface$ByteOrderedDataInputStream java.util.HashMap ), this, byteOrderedDataInputStream, hashMap);
    }

    private boolean isSupportedDataType(HashMap hashMap) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isSupportedDataType", $$robo$$android_media_ExifInterface$isSupportedDataType(java.util.HashMap ), this, hashMap);
    }

    private boolean isThumbnail(HashMap hashMap) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isThumbnail", $$robo$$android_media_ExifInterface$isThumbnail(java.util.HashMap ), this, hashMap);
    }

    private void validateImages(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("validateImages", $$robo$$android_media_ExifInterface$validateImages(java.io.InputStream ), this, inputStream);
    }

    private void updateImageSizeValues(ByteOrderedDataInputStream byteOrderedDataInputStream, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("updateImageSizeValues", $$robo$$android_media_ExifInterface$updateImageSizeValues(android.media.ExifInterface$ByteOrderedDataInputStream int ), this, byteOrderedDataInputStream, n);
    }

    private int writeExifSegment(ByteOrderedDataOutputStream byteOrderedDataOutputStream, int n) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("writeExifSegment", $$robo$$android_media_ExifInterface$writeExifSegment(android.media.ExifInterface$ByteOrderedDataOutputStream int ), this, byteOrderedDataOutputStream, n);
    }

    private static Pair<Integer, Integer> guessDataFormat(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("guessDataFormat", $$robo$$android_media_ExifInterface$guessDataFormat(java.lang.String ), (String)string2);
    }

    private void swapBasedOnImageSize(int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("swapBasedOnImageSize", $$robo$$android_media_ExifInterface$swapBasedOnImageSize(int int ), this, n, n2);
    }

    private boolean containsMatch(byte[] byArray, byte[] byArray2) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsMatch", $$robo$$android_media_ExifInterface$containsMatch(byte[] byte[] ), this, byArray, byArray2);
    }

    static {
        RobolectricInternals.classInitializing(ExifInterface.class);
    }

    public /* synthetic */ ExifInterface() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExifInterface)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ByteOrderedDataOutputStream
    extends FilterOutputStream
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private OutputStream mOutputStream;
        private ByteOrder mByteOrder;

        private void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$__constructor__(OutputStream out, ByteOrder byteOrder) {
            this.mOutputStream = out;
            this.mByteOrder = byteOrder;
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$write(byte[] bytes) throws IOException {
            this.mOutputStream.write(bytes);
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$write(byte[] bytes, int offset, int length) throws IOException {
            this.mOutputStream.write(bytes, offset, length);
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeByte(int val) throws IOException {
            this.mOutputStream.write(val);
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeShort(short val) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(val >>> 0 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 0 & 0xFF);
            }
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeInt(int val) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(val >>> 0 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 16 & 0xFF);
                this.mOutputStream.write(val >>> 24 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(val >>> 24 & 0xFF);
                this.mOutputStream.write(val >>> 16 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 0 & 0xFF);
            }
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeUnsignedShort(int val) throws IOException {
            this.writeShort((short)val);
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeUnsignedInt(long val) throws IOException {
            this.writeInt((int)val);
        }

        private void __constructor__(OutputStream outputStream, ByteOrder byteOrder) {
            this.$$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$__constructor__(outputStream, byteOrder);
        }

        public ByteOrderedDataOutputStream(OutputStream outputStream, ByteOrder byteOrder) {
            super(outputStream);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$__constructor__(java.io.OutputStream java.nio.ByteOrder ), this, outputStream, byteOrder);
        }

        public void setByteOrder(ByteOrder byteOrder) {
            InvokeDynamicSupport.bootstrap("setByteOrder", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$setByteOrder(java.nio.ByteOrder ), this, byteOrder);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$write(byte[] ), this, byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$write(byte[] int int ), this, byArray, n, n2);
        }

        public void writeByte(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("writeByte", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeByte(int ), this, n);
        }

        public void writeShort(short s) throws IOException {
            InvokeDynamicSupport.bootstrap("writeShort", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeShort(short ), this, s);
        }

        public void writeInt(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("writeInt", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeInt(int ), this, n);
        }

        public void writeUnsignedShort(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("writeUnsignedShort", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeUnsignedShort(int ), this, n);
        }

        public void writeUnsignedInt(long l) throws IOException {
            InvokeDynamicSupport.bootstrap("writeUnsignedInt", $$robo$$android_media_ExifInterface_ByteOrderedDataOutputStream$writeUnsignedInt(long ), this, l);
        }

        public /* synthetic */ ByteOrderedDataOutputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteOrderedDataOutputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ByteOrderedDataInputStream
    extends InputStream
    implements DataInput,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ByteOrder LITTLE_ENDIAN;
        private static ByteOrder BIG_ENDIAN;
        private DataInputStream mDataInputStream;
        private InputStream mInputStream;
        private ByteOrder mByteOrder;
        private int mLength;
        private int mPosition;

        private void $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$__constructor__(InputStream in) throws IOException {
            this.mByteOrder = ByteOrder.BIG_ENDIAN;
            this.mInputStream = in;
            this.mDataInputStream = new DataInputStream(in);
            this.mLength = this.mDataInputStream.available();
            this.mPosition = 0;
            this.mDataInputStream.mark(this.mLength);
        }

        private void $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$__constructor__(byte[] bytes) throws IOException {
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$seek(long byteCount) throws IOException {
            if ((long)this.mPosition > byteCount) {
                this.mPosition = 0;
                this.mDataInputStream.reset();
                this.mDataInputStream.mark(this.mLength);
            } else {
                byteCount -= (long)this.mPosition;
            }
            if (this.skipBytes((int)byteCount) != (int)byteCount) {
                throw new IOException("Couldn't seek up to the byteCount");
            }
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$peek() {
            return this.mPosition;
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$available() throws IOException {
            return this.mDataInputStream.available();
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$read() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.read();
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readUnsignedByte() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.readUnsignedByte();
        }

        private final String $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readLine() throws IOException {
            Log.d("ExifInterface", "Currently unsupported");
            return null;
        }

        private final boolean $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readBoolean() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.readBoolean();
        }

        private final char $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readChar() throws IOException {
            this.mPosition += 2;
            return this.mDataInputStream.readChar();
        }

        private final String $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readUTF() throws IOException {
            this.mPosition += 2;
            return this.mDataInputStream.readUTF();
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readFully(byte[] buffer, int offset, int length) throws IOException {
            this.mPosition += length;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            if (this.mDataInputStream.read(buffer, offset, length) != length) {
                throw new IOException("Couldn't read up to the length of buffer");
            }
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readFully(byte[] buffer) throws IOException {
            this.mPosition += buffer.length;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            if (this.mDataInputStream.read(buffer, 0, buffer.length) != buffer.length) {
                throw new IOException("Couldn't read up to the length of buffer");
            }
        }

        private final byte $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readByte() throws IOException {
            ++this.mPosition;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch = this.mDataInputStream.read();
            if (ch < 0) {
                throw new EOFException();
            }
            return (byte)ch;
        }

        private final short $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readShort() throws IOException {
            int ch2;
            this.mPosition += 2;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = this.mDataInputStream.read();
            if ((ch1 | (ch2 = this.mDataInputStream.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (short)((ch2 << 8) + ch1);
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (short)((ch1 << 8) + ch2);
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readInt() throws IOException {
            int ch4;
            int ch3;
            int ch2;
            this.mPosition += 4;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = this.mDataInputStream.read();
            if ((ch1 | (ch2 = this.mDataInputStream.read()) | (ch3 = this.mDataInputStream.read()) | (ch4 = this.mDataInputStream.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$skipBytes(int byteCount) throws IOException {
            int skipped;
            int totalSkip = Math.min(byteCount, this.mLength - this.mPosition);
            for (skipped = 0; skipped < totalSkip; skipped += this.mDataInputStream.skipBytes(totalSkip - skipped)) {
            }
            this.mPosition += skipped;
            return skipped;
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readUnsignedShort() throws IOException {
            int ch2;
            this.mPosition += 2;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = this.mDataInputStream.read();
            if ((ch1 | (ch2 = this.mDataInputStream.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (ch2 << 8) + ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (ch1 << 8) + ch2;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        private final long $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readUnsignedInt() throws IOException {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }

        private final long $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readLong() throws IOException {
            int ch8;
            int ch7;
            int ch6;
            int ch5;
            int ch4;
            int ch3;
            int ch2;
            this.mPosition += 8;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = this.mDataInputStream.read();
            if ((ch1 | (ch2 = this.mDataInputStream.read()) | (ch3 = this.mDataInputStream.read()) | (ch4 = this.mDataInputStream.read()) | (ch5 = this.mDataInputStream.read()) | (ch6 = this.mDataInputStream.read()) | (ch7 = this.mDataInputStream.read()) | (ch8 = this.mDataInputStream.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return ((long)ch8 << 56) + ((long)ch7 << 48) + ((long)ch6 << 40) + ((long)ch5 << 32) + ((long)ch4 << 24) + ((long)ch3 << 16) + ((long)ch2 << 8) + (long)ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return ((long)ch1 << 56) + ((long)ch2 << 48) + ((long)ch3 << 40) + ((long)ch4 << 32) + ((long)ch5 << 24) + ((long)ch6 << 16) + ((long)ch7 << 8) + (long)ch8;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        private final float $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        private final double $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        static void __staticInitializer__() {
            LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
            BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
        }

        private void __constructor__(InputStream inputStream) throws IOException {
            this.$$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$__constructor__(inputStream);
        }

        public ByteOrderedDataInputStream(InputStream inputStream) throws IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$__constructor__(java.io.InputStream ), this, inputStream);
        }

        private void __constructor__(byte[] byArray) throws IOException {
            this.$$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$__constructor__(byArray);
        }

        public ByteOrderedDataInputStream(byte[] byArray) throws IOException {
            this(new ByteArrayInputStream(byArray));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$__constructor__(byte[] ), this, byArray);
        }

        public void setByteOrder(ByteOrder byteOrder) {
            InvokeDynamicSupport.bootstrap("setByteOrder", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$setByteOrder(java.nio.ByteOrder ), this, byteOrder);
        }

        public void seek(long l) throws IOException {
            InvokeDynamicSupport.bootstrap("seek", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$seek(long ), this, l);
        }

        public int peek() {
            return (int)InvokeDynamicSupport.bootstrap("peek", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$peek(), this);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$available(), this);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$read(), this);
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("readUnsignedByte", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readUnsignedByte(), this);
        }

        @Override
        public String readLine() throws IOException {
            return InvokeDynamicSupport.bootstrap("readLine", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readLine(), this);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return (boolean)InvokeDynamicSupport.bootstrap("readBoolean", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readBoolean(), this);
        }

        @Override
        public char readChar() throws IOException {
            return (char)InvokeDynamicSupport.bootstrap("readChar", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readChar(), this);
        }

        @Override
        public String readUTF() throws IOException {
            return InvokeDynamicSupport.bootstrap("readUTF", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readUTF(), this);
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("readFully", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readFully(byte[] int int ), this, byArray, n, n2);
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            InvokeDynamicSupport.bootstrap("readFully", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readFully(byte[] ), this, byArray);
        }

        @Override
        public byte readByte() throws IOException {
            return (byte)InvokeDynamicSupport.bootstrap("readByte", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readByte(), this);
        }

        @Override
        public short readShort() throws IOException {
            return (short)InvokeDynamicSupport.bootstrap("readShort", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readShort(), this);
        }

        @Override
        public int readInt() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("readInt", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readInt(), this);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("skipBytes", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$skipBytes(int ), this, n);
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("readUnsignedShort", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readUnsignedShort(), this);
        }

        public long readUnsignedInt() throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("readUnsignedInt", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readUnsignedInt(), this);
        }

        @Override
        public long readLong() throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("readLong", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readLong(), this);
        }

        @Override
        public float readFloat() throws IOException {
            return (float)InvokeDynamicSupport.bootstrap("readFloat", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readFloat(), this);
        }

        @Override
        public double readDouble() throws IOException {
            return (double)InvokeDynamicSupport.bootstrap("readDouble", $$robo$$android_media_ExifInterface_ByteOrderedDataInputStream$readDouble(), this);
        }

        static {
            RobolectricInternals.classInitializing(ByteOrderedDataInputStream.class);
        }

        public /* synthetic */ ByteOrderedDataInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteOrderedDataInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L})
    public static @interface IfdType {
    }

    private static class ExifTag
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int number;
        public String name;
        public int primaryFormat;
        public int secondaryFormat;

        private void $$robo$$android_media_ExifInterface_ExifTag$__constructor__(String name, int number, int format) {
            this.name = name;
            this.number = number;
            this.primaryFormat = format;
            this.secondaryFormat = -1;
        }

        private void $$robo$$android_media_ExifInterface_ExifTag$__constructor__(String name, int number, int primaryFormat, int secondaryFormat) {
            this.name = name;
            this.number = number;
            this.primaryFormat = primaryFormat;
            this.secondaryFormat = secondaryFormat;
        }

        private /* synthetic */ void $$robo$$android_media_ExifInterface_ExifTag$__constructor__(String x0, int x1, int x2, 1 x3) {
        }

        private /* synthetic */ void $$robo$$android_media_ExifInterface_ExifTag$__constructor__(String x0, int x1, int x2, int x3, 1 x4) {
        }

        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_media_ExifInterface_ExifTag$__constructor__(string2, n, n2);
        }

        public ExifTag(String string2, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifTag$__constructor__(java.lang.String int int ), this, string2, n, n2);
        }

        private void __constructor__(String string2, int n, int n2, int n3) {
            this.$$robo$$android_media_ExifInterface_ExifTag$__constructor__(string2, n, n2, n3);
        }

        public ExifTag(String string2, int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifTag$__constructor__(java.lang.String int int int ), this, string2, n, n2, n3);
        }

        private /* synthetic */ void __constructor__(String string2, int n, int n2, 1 var4_4) {
            this.$$robo$$android_media_ExifInterface_ExifTag$__constructor__(string2, n, n2, var4_4);
        }

        public /* synthetic */ ExifTag(String string2, int n, int n2, 1 var4_4) {
            this(string2, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifTag$__constructor__(java.lang.String int int android.media.ExifInterface$1 ), this, string2, n, n2, var4_4);
        }

        private /* synthetic */ void __constructor__(String string2, int n, int n2, int n3, 1 var5_5) {
            this.$$robo$$android_media_ExifInterface_ExifTag$__constructor__(string2, n, n2, n3, var5_5);
        }

        public /* synthetic */ ExifTag(String string2, int n, int n2, int n3, 1 var5_5) {
            this(string2, n, n2, n3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifTag$__constructor__(java.lang.String int int int android.media.ExifInterface$1 ), this, string2, n, n2, n3, var5_5);
        }

        public /* synthetic */ ExifTag() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExifTag)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ExifAttribute
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int format;
        public int numberOfComponents;
        public byte[] bytes;

        private void $$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(int format, int numberOfComponents, byte[] bytes) {
            this.format = format;
            this.numberOfComponents = numberOfComponents;
            this.bytes = bytes;
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createUShort(int[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[3] * values.length]);
            buffer.order(byteOrder);
            for (int value : values) {
                buffer.putShort((short)value);
            }
            return new ExifAttribute(3, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createUShort(int value, ByteOrder byteOrder) {
            return ExifAttribute.createUShort(new int[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createULong(long[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[4] * values.length]);
            buffer.order(byteOrder);
            for (long value : values) {
                buffer.putInt((int)value);
            }
            return new ExifAttribute(4, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createULong(long value, ByteOrder byteOrder) {
            return ExifAttribute.createULong(new long[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createSLong(int[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[9] * values.length]);
            buffer.order(byteOrder);
            for (int value : values) {
                buffer.putInt(value);
            }
            return new ExifAttribute(9, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createSLong(int value, ByteOrder byteOrder) {
            return ExifAttribute.createSLong(new int[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createByte(String value) {
            if (value.length() == 1 && value.charAt(0) >= '0' && value.charAt(0) <= '1') {
                byte[] bytes = new byte[]{(byte)(value.charAt(0) - 48)};
                return new ExifAttribute(1, bytes.length, bytes);
            }
            byte[] ascii = value.getBytes(ASCII);
            return new ExifAttribute(1, ascii.length, ascii);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createString(String value) {
            byte[] ascii = (value + '\u0000').getBytes(ASCII);
            return new ExifAttribute(2, ascii.length, ascii);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createURational(Rational[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[5] * values.length]);
            buffer.order(byteOrder);
            for (Rational value : values) {
                buffer.putInt((int)value.numerator);
                buffer.putInt((int)value.denominator);
            }
            return new ExifAttribute(5, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createURational(Rational value, ByteOrder byteOrder) {
            return ExifAttribute.createURational(new Rational[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createSRational(Rational[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[10] * values.length]);
            buffer.order(byteOrder);
            for (Rational value : values) {
                buffer.putInt((int)value.numerator);
                buffer.putInt((int)value.denominator);
            }
            return new ExifAttribute(10, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createSRational(Rational value, ByteOrder byteOrder) {
            return ExifAttribute.createSRational(new Rational[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createDouble(double[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[12] * values.length]);
            buffer.order(byteOrder);
            for (double value : values) {
                buffer.putDouble(value);
            }
            return new ExifAttribute(12, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createDouble(double value, ByteOrder byteOrder) {
            return ExifAttribute.createDouble(new double[]{value}, byteOrder);
        }

        private final String $$robo$$android_media_ExifInterface_ExifAttribute$toString() {
            return "(" + IFD_FORMAT_NAMES[this.format] + ", data length:" + this.bytes.length + ")";
        }

        private final Object $$robo$$android_media_ExifInterface_ExifAttribute$getValue(ByteOrder byteOrder) {
            try {
                ByteOrderedDataInputStream inputStream = new ByteOrderedDataInputStream(this.bytes);
                inputStream.setByteOrder(byteOrder);
                switch (this.format) {
                    case 1: 
                    case 6: {
                        if (this.bytes.length == 1 && this.bytes[0] >= 0 && this.bytes[0] <= 1) {
                            return new String(new char[]{(char)(this.bytes[0] + 48)});
                        }
                        return new String(this.bytes, ASCII);
                    }
                    case 2: 
                    case 7: {
                        byte ch;
                        int index = 0;
                        if (this.numberOfComponents >= EXIF_ASCII_PREFIX.length) {
                            boolean same = true;
                            for (int i = 0; i < EXIF_ASCII_PREFIX.length; ++i) {
                                if (this.bytes[i] == EXIF_ASCII_PREFIX[i]) continue;
                                same = false;
                                break;
                            }
                            if (same) {
                                index = EXIF_ASCII_PREFIX.length;
                            }
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        while (index < this.numberOfComponents && (ch = this.bytes[index]) != 0) {
                            if (ch >= 32) {
                                stringBuilder.append((char)ch);
                            } else {
                                stringBuilder.append('?');
                            }
                            ++index;
                        }
                        return stringBuilder.toString();
                    }
                    case 3: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readUnsignedShort();
                        }
                        return values;
                    }
                    case 4: {
                        long[] values = new long[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readUnsignedInt();
                        }
                        return values;
                    }
                    case 5: {
                        Rational[] values = new Rational[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            long numerator = inputStream.readUnsignedInt();
                            long denominator = inputStream.readUnsignedInt();
                            values[i] = new Rational(numerator, denominator, null);
                        }
                        return values;
                    }
                    case 8: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readShort();
                        }
                        return values;
                    }
                    case 9: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readInt();
                        }
                        return values;
                    }
                    case 10: {
                        Rational[] values = new Rational[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            long numerator = inputStream.readInt();
                            long denominator = inputStream.readInt();
                            values[i] = new Rational(numerator, denominator, null);
                        }
                        return values;
                    }
                    case 11: {
                        double[] values = new double[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readFloat();
                        }
                        return values;
                    }
                    case 12: {
                        double[] values = new double[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readDouble();
                        }
                        return values;
                    }
                }
                return null;
            }
            catch (IOException e) {
                Log.w("ExifInterface", "IOException occurred during reading a value", e);
                return null;
            }
        }

        private final double $$robo$$android_media_ExifInterface_ExifAttribute$getDoubleValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                throw new NumberFormatException("NULL can't be converted to a double value");
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                if (array2.length == 1) {
                    return array2[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                if (array3.length == 1) {
                    return array3[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof double[]) {
                double[] array4 = (double[])value;
                if (array4.length == 1) {
                    return array4[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof Rational[]) {
                Rational[] array5 = (Rational[])value;
                if (array5.length == 1) {
                    return array5[0].calculate();
                }
                throw new NumberFormatException("There are more than one component");
            }
            throw new NumberFormatException("Couldn't find a double value");
        }

        private final int $$robo$$android_media_ExifInterface_ExifAttribute$getIntValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                throw new NumberFormatException("NULL can't be converted to a integer value");
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                if (array2.length == 1) {
                    return (int)array2[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                if (array3.length == 1) {
                    return array3[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            throw new NumberFormatException("Couldn't find a integer value");
        }

        private final String $$robo$$android_media_ExifInterface_ExifAttribute$getStringValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return (String)value;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                for (int i = 0; i < array2.length; ++i) {
                    stringBuilder.append(array2[i]);
                    if (i + 1 == array2.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                for (int i = 0; i < array3.length; ++i) {
                    stringBuilder.append(array3[i]);
                    if (i + 1 == array3.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof double[]) {
                double[] array4 = (double[])value;
                for (int i = 0; i < array4.length; ++i) {
                    stringBuilder.append(array4[i]);
                    if (i + 1 == array4.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof Rational[]) {
                Rational[] array5 = (Rational[])value;
                for (int i = 0; i < array5.length; ++i) {
                    stringBuilder.append(array5[i].numerator);
                    stringBuilder.append('/');
                    stringBuilder.append(array5[i].denominator);
                    if (i + 1 == array5.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            return null;
        }

        private final int $$robo$$android_media_ExifInterface_ExifAttribute$size() {
            return IFD_FORMAT_BYTES_PER_FORMAT[this.format] * this.numberOfComponents;
        }

        private /* synthetic */ void $$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(int x0, int x1, byte[] x2, 1 x3) {
        }

        private void __constructor__(int n, int n2, byte[] byArray) {
            this.$$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(n, n2, byArray);
        }

        public ExifAttribute(int n, int n2, byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(int int byte[] ), this, n, n2, byArray);
        }

        public static ExifAttribute createUShort(int[] nArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createUShort", $$robo$$android_media_ExifInterface_ExifAttribute$createUShort(int[] java.nio.ByteOrder ), (int[])nArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createUShort(int n, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createUShort", $$robo$$android_media_ExifInterface_ExifAttribute$createUShort(int java.nio.ByteOrder ), (int)n, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createULong(long[] lArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createULong", $$robo$$android_media_ExifInterface_ExifAttribute$createULong(long[] java.nio.ByteOrder ), (long[])lArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createULong(long l, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createULong", $$robo$$android_media_ExifInterface_ExifAttribute$createULong(long java.nio.ByteOrder ), (long)l, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createSLong(int[] nArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createSLong", $$robo$$android_media_ExifInterface_ExifAttribute$createSLong(int[] java.nio.ByteOrder ), (int[])nArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createSLong(int n, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createSLong", $$robo$$android_media_ExifInterface_ExifAttribute$createSLong(int java.nio.ByteOrder ), (int)n, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createByte(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createByte", $$robo$$android_media_ExifInterface_ExifAttribute$createByte(java.lang.String ), (String)string2);
        }

        public static ExifAttribute createString(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createString", $$robo$$android_media_ExifInterface_ExifAttribute$createString(java.lang.String ), (String)string2);
        }

        public static ExifAttribute createURational(Rational[] rationalArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createURational", $$robo$$android_media_ExifInterface_ExifAttribute$createURational(android.media.ExifInterface$Rational[] java.nio.ByteOrder ), (Rational[])rationalArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createURational(Rational rational, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createURational", $$robo$$android_media_ExifInterface_ExifAttribute$createURational(android.media.ExifInterface$Rational java.nio.ByteOrder ), (Rational)rational, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createSRational(Rational[] rationalArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createSRational", $$robo$$android_media_ExifInterface_ExifAttribute$createSRational(android.media.ExifInterface$Rational[] java.nio.ByteOrder ), (Rational[])rationalArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createSRational(Rational rational, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createSRational", $$robo$$android_media_ExifInterface_ExifAttribute$createSRational(android.media.ExifInterface$Rational java.nio.ByteOrder ), (Rational)rational, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createDouble(double[] dArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createDouble", $$robo$$android_media_ExifInterface_ExifAttribute$createDouble(double[] java.nio.ByteOrder ), (double[])dArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createDouble(double d, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createDouble", $$robo$$android_media_ExifInterface_ExifAttribute$createDouble(double java.nio.ByteOrder ), (double)d, (ByteOrder)byteOrder);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_ExifInterface_ExifAttribute$toString(), this);
        }

        private Object getValue(ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_media_ExifInterface_ExifAttribute$getValue(java.nio.ByteOrder ), this, byteOrder);
        }

        public double getDoubleValue(ByteOrder byteOrder) {
            return (double)InvokeDynamicSupport.bootstrap("getDoubleValue", $$robo$$android_media_ExifInterface_ExifAttribute$getDoubleValue(java.nio.ByteOrder ), this, byteOrder);
        }

        public int getIntValue(ByteOrder byteOrder) {
            return (int)InvokeDynamicSupport.bootstrap("getIntValue", $$robo$$android_media_ExifInterface_ExifAttribute$getIntValue(java.nio.ByteOrder ), this, byteOrder);
        }

        public String getStringValue(ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrap("getStringValue", $$robo$$android_media_ExifInterface_ExifAttribute$getStringValue(java.nio.ByteOrder ), this, byteOrder);
        }

        public int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_media_ExifInterface_ExifAttribute$size(), this);
        }

        private /* synthetic */ void __constructor__(int n, int n2, byte[] byArray, 1 var4_4) {
            this.$$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(n, n2, byArray, var4_4);
        }

        public /* synthetic */ ExifAttribute(int n, int n2, byte[] byArray, 1 var4_4) {
            this(n, n2, byArray);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(int int byte[] android.media.ExifInterface$1 ), this, n, n2, byArray, var4_4);
        }

        public /* synthetic */ ExifAttribute() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExifAttribute)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Rational
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public long numerator;
        public long denominator;

        private void $$robo$$android_media_ExifInterface_Rational$__constructor__(long numerator, long denominator) {
            if (denominator == 0L) {
                this.numerator = 0L;
                this.denominator = 1L;
                return;
            }
            this.numerator = numerator;
            this.denominator = denominator;
        }

        private final String $$robo$$android_media_ExifInterface_Rational$toString() {
            return this.numerator + "/" + this.denominator;
        }

        private final double $$robo$$android_media_ExifInterface_Rational$calculate() {
            return (double)this.numerator / (double)this.denominator;
        }

        private /* synthetic */ void $$robo$$android_media_ExifInterface_Rational$__constructor__(long x0, long x1, 1 x2) {
        }

        private void __constructor__(long l, long l2) {
            this.$$robo$$android_media_ExifInterface_Rational$__constructor__(l, l2);
        }

        public Rational(long l, long l2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_Rational$__constructor__(long long ), this, l, l2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_ExifInterface_Rational$toString(), this);
        }

        public double calculate() {
            return (double)InvokeDynamicSupport.bootstrap("calculate", $$robo$$android_media_ExifInterface_Rational$calculate(), this);
        }

        private /* synthetic */ void __constructor__(long l, long l2, 1 var5_3) {
            this.$$robo$$android_media_ExifInterface_Rational$__constructor__(l, l2, var5_3);
        }

        public /* synthetic */ Rational(long l, long l2, 1 var5_3) {
            this(l, l2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_Rational$__constructor__(long long android.media.ExifInterface$1 ), this, l, l2, var5_3);
        }

        public /* synthetic */ Rational() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rational)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

