/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPatch;
import android.media.AudioPortConfig;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AudioRecordingConfiguration
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private int mSessionId;
    private int mClientSource;
    private AudioFormat mDeviceFormat;
    private AudioFormat mClientFormat;
    private int mPatchHandle;
    public static Parcelable.Creator<AudioRecordingConfiguration> CREATOR;

    private void $$robo$$android_media_AudioRecordingConfiguration$__constructor__(int session, int source, AudioFormat clientFormat, AudioFormat devFormat, int patchHandle) {
        this.mSessionId = session;
        this.mClientSource = source;
        this.mClientFormat = clientFormat;
        this.mDeviceFormat = devFormat;
        this.mPatchHandle = patchHandle;
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$getClientAudioSource() {
        return this.mClientSource;
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$getClientAudioSessionId() {
        return this.mSessionId;
    }

    private final AudioFormat $$robo$$android_media_AudioRecordingConfiguration$getFormat() {
        return this.mDeviceFormat;
    }

    private final AudioFormat $$robo$$android_media_AudioRecordingConfiguration$getClientFormat() {
        return this.mClientFormat;
    }

    private final AudioDeviceInfo $$robo$$android_media_AudioRecordingConfiguration$getAudioDevice() {
        ArrayList<AudioPatch> patches = new ArrayList<AudioPatch>();
        if (AudioManager.listAudioPatches(patches) != 0) {
            Log.e(TAG, "Error retrieving list of audio patches");
            return null;
        }
        for (int i = 0; i < patches.size(); ++i) {
            AudioPatch patch = patches.get(i);
            if (patch.id() != this.mPatchHandle) continue;
            AudioPortConfig[] sources = patch.sources();
            if (sources == null || sources.length <= 0) break;
            int devId = sources[0].port().id();
            AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(1);
            for (int j = 0; j < devices.length; ++j) {
                if (devices[j].getId() != devId) continue;
                return devices[j];
            }
            break;
        }
        Log.e(TAG, "Couldn't find device for recording, did recording end already?");
        return null;
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$hashCode() {
        return Objects.hash(this.mSessionId, this.mClientSource);
    }

    private final int $$robo$$android_media_AudioRecordingConfiguration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_media_AudioRecordingConfiguration$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSessionId);
        dest.writeInt(this.mClientSource);
        this.mClientFormat.writeToParcel(dest, 0);
        this.mDeviceFormat.writeToParcel(dest, 0);
        dest.writeInt(this.mPatchHandle);
    }

    private void $$robo$$android_media_AudioRecordingConfiguration$__constructor__(Parcel in) {
        this.mSessionId = in.readInt();
        this.mClientSource = in.readInt();
        this.mClientFormat = AudioFormat.CREATOR.createFromParcel(in);
        this.mDeviceFormat = AudioFormat.CREATOR.createFromParcel(in);
        this.mPatchHandle = in.readInt();
    }

    private final boolean $$robo$$android_media_AudioRecordingConfiguration$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AudioRecordingConfiguration)) {
            return false;
        }
        AudioRecordingConfiguration that = (AudioRecordingConfiguration)o;
        return this.mSessionId == that.mSessionId && this.mClientSource == that.mClientSource && this.mPatchHandle == that.mPatchHandle && this.mClientFormat.equals(that.mClientFormat) && this.mDeviceFormat.equals(that.mDeviceFormat);
    }

    private /* synthetic */ void $$robo$$android_media_AudioRecordingConfiguration$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        TAG = new String("AudioRecordingConfiguration");
        CREATOR = new Parcelable.Creator<AudioRecordingConfiguration>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_AudioRecordingConfiguration_1$__constructor__() {
            }

            private final AudioRecordingConfiguration $$robo$$android_media_AudioRecordingConfiguration_1$createFromParcel(Parcel p) {
                return new AudioRecordingConfiguration(p, null);
            }

            private final AudioRecordingConfiguration[] $$robo$$android_media_AudioRecordingConfiguration_1$newArray(int size) {
                return new AudioRecordingConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_AudioRecordingConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecordingConfiguration_1$__constructor__(), this);
            }

            @Override
            public AudioRecordingConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_AudioRecordingConfiguration_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public AudioRecordingConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_AudioRecordingConfiguration_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, AudioFormat audioFormat, AudioFormat audioFormat2, int n3) {
        this.$$robo$$android_media_AudioRecordingConfiguration$__constructor__(n, n2, audioFormat, audioFormat2, n3);
    }

    public AudioRecordingConfiguration(int n, int n2, AudioFormat audioFormat, AudioFormat audioFormat2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecordingConfiguration$__constructor__(int int android.media.AudioFormat android.media.AudioFormat int ), this, n, n2, audioFormat, audioFormat2, n3);
    }

    public int getClientAudioSource() {
        return (int)InvokeDynamicSupport.bootstrap("getClientAudioSource", $$robo$$android_media_AudioRecordingConfiguration$getClientAudioSource(), this);
    }

    public int getClientAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getClientAudioSessionId", $$robo$$android_media_AudioRecordingConfiguration$getClientAudioSessionId(), this);
    }

    public AudioFormat getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_AudioRecordingConfiguration$getFormat(), this);
    }

    public AudioFormat getClientFormat() {
        return InvokeDynamicSupport.bootstrap("getClientFormat", $$robo$$android_media_AudioRecordingConfiguration$getClientFormat(), this);
    }

    public AudioDeviceInfo getAudioDevice() {
        return InvokeDynamicSupport.bootstrap("getAudioDevice", $$robo$$android_media_AudioRecordingConfiguration$getAudioDevice(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_AudioRecordingConfiguration$hashCode(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_AudioRecordingConfiguration$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_AudioRecordingConfiguration$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_AudioRecordingConfiguration$__constructor__(parcel);
    }

    public AudioRecordingConfiguration(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecordingConfiguration$__constructor__(android.os.Parcel ), this, parcel);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_AudioRecordingConfiguration$equals(java.lang.Object ), this, object);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_AudioRecordingConfiguration$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ AudioRecordingConfiguration(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecordingConfiguration$__constructor__(android.os.Parcel android.media.AudioRecordingConfiguration$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AudioRecordingConfiguration.class);
    }

    public /* synthetic */ AudioRecordingConfiguration() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioRecordingConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 9L})
    public static @interface AudioSource {
    }
}

