/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class Keyboard
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "Keyboard";
    private static String TAG_KEYBOARD = "Keyboard";
    private static String TAG_ROW = "Row";
    private static String TAG_KEY = "Key";
    public static int EDGE_LEFT = 1;
    public static int EDGE_RIGHT = 2;
    public static int EDGE_TOP = 4;
    public static int EDGE_BOTTOM = 8;
    public static int KEYCODE_SHIFT = -1;
    public static int KEYCODE_MODE_CHANGE = -2;
    public static int KEYCODE_CANCEL = -3;
    public static int KEYCODE_DONE = -4;
    public static int KEYCODE_DELETE = -5;
    public static int KEYCODE_ALT = -6;
    private CharSequence mLabel;
    private int mDefaultHorizontalGap;
    private int mDefaultWidth;
    private int mDefaultHeight;
    private int mDefaultVerticalGap;
    private boolean mShifted;
    private Key[] mShiftKeys;
    private int[] mShiftKeyIndices;
    private int mKeyWidth;
    private int mKeyHeight;
    private int mTotalHeight;
    private int mTotalWidth;
    private List<Key> mKeys;
    private List<Key> mModifierKeys;
    private int mDisplayWidth;
    private int mDisplayHeight;
    private int mKeyboardMode;
    private static int GRID_WIDTH = 10;
    private static int GRID_HEIGHT = 5;
    private static int GRID_SIZE = 50;
    private int mCellWidth;
    private int mCellHeight;
    private int[][] mGridNeighbors;
    private int mProximityThreshold;
    private static float SEARCH_DISTANCE;
    private ArrayList<Row> rows;

    private void $$robo$$android_inputmethodservice_Keyboard$__constructor__(Context context, int xmlLayoutResId) {
    }

    private void $$robo$$android_inputmethodservice_Keyboard$__constructor__(Context context, int xmlLayoutResId, int modeId, int width, int height) {
        this.mShiftKeys = new Key[]{null, null};
        this.mShiftKeyIndices = new int[]{-1, -1};
        this.rows = new ArrayList();
        this.mDisplayWidth = width;
        this.mDisplayHeight = height;
        this.mDefaultHorizontalGap = 0;
        this.mDefaultWidth = this.mDisplayWidth / 10;
        this.mDefaultVerticalGap = 0;
        this.mDefaultHeight = this.mDefaultWidth;
        this.mKeys = new ArrayList<Key>();
        this.mModifierKeys = new ArrayList<Key>();
        this.mKeyboardMode = modeId;
        this.loadKeyboard(context, context.getResources().getXml(xmlLayoutResId));
    }

    private void $$robo$$android_inputmethodservice_Keyboard$__constructor__(Context context, int xmlLayoutResId, int modeId) {
        this.mShiftKeys = new Key[]{null, null};
        this.mShiftKeyIndices = new int[]{-1, -1};
        this.rows = new ArrayList();
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        this.mDisplayWidth = dm.widthPixels;
        this.mDisplayHeight = dm.heightPixels;
        this.mDefaultHorizontalGap = 0;
        this.mDefaultWidth = this.mDisplayWidth / 10;
        this.mDefaultVerticalGap = 0;
        this.mDefaultHeight = this.mDefaultWidth;
        this.mKeys = new ArrayList<Key>();
        this.mModifierKeys = new ArrayList<Key>();
        this.mKeyboardMode = modeId;
        this.loadKeyboard(context, context.getResources().getXml(xmlLayoutResId));
    }

    private void $$robo$$android_inputmethodservice_Keyboard$__constructor__(Context context, int layoutTemplateResId, CharSequence characters, int columns, int horizontalPadding) {
        int x = 0;
        int y = 0;
        int column = 0;
        this.mTotalWidth = 0;
        Row row = new Row(this);
        row.defaultHeight = this.mDefaultHeight;
        row.defaultWidth = this.mDefaultWidth;
        row.defaultHorizontalGap = this.mDefaultHorizontalGap;
        row.verticalGap = this.mDefaultVerticalGap;
        row.rowEdgeFlags = 12;
        int maxColumns = columns == -1 ? Integer.MAX_VALUE : columns;
        for (int i = 0; i < characters.length(); ++i) {
            char c = characters.charAt(i);
            if (column >= maxColumns || x + this.mDefaultWidth + horizontalPadding > this.mDisplayWidth) {
                x = 0;
                y += this.mDefaultVerticalGap + this.mDefaultHeight;
                column = 0;
            }
            Key key = new Key(row);
            key.x = x;
            key.y = y;
            key.label = String.valueOf(c);
            key.codes = new int[]{c};
            ++column;
            this.mKeys.add(key);
            row.mKeys.add(key);
            if ((x += key.width + key.gap) <= this.mTotalWidth) continue;
            this.mTotalWidth = x;
        }
        this.mTotalHeight = y + this.mDefaultHeight;
        this.rows.add(row);
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$resize(int newWidth, int newHeight) {
        int numRows = this.rows.size();
        for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
            Row row = this.rows.get(rowIndex);
            int numKeys = row.mKeys.size();
            int totalGap = 0;
            int totalWidth = 0;
            for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
                Key key = row.mKeys.get(keyIndex);
                if (keyIndex > 0) {
                    totalGap += key.gap;
                }
                totalWidth += key.width;
            }
            if (totalGap + totalWidth <= newWidth) continue;
            int x = 0;
            float scaleFactor = (float)(newWidth - totalGap) / (float)totalWidth;
            for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
                Key key = row.mKeys.get(keyIndex);
                key.width = (int)((float)key.width * scaleFactor);
                key.x = x;
                x += key.width + key.gap;
            }
        }
        this.mTotalWidth = newWidth;
    }

    private final List<Key> $$robo$$android_inputmethodservice_Keyboard$getKeys() {
        return this.mKeys;
    }

    private final List<Key> $$robo$$android_inputmethodservice_Keyboard$getModifierKeys() {
        return this.mModifierKeys;
    }

    private final int $$robo$$android_inputmethodservice_Keyboard$getHorizontalGap() {
        return this.mDefaultHorizontalGap;
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$setHorizontalGap(int gap) {
        this.mDefaultHorizontalGap = gap;
    }

    private final int $$robo$$android_inputmethodservice_Keyboard$getVerticalGap() {
        return this.mDefaultVerticalGap;
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$setVerticalGap(int gap) {
        this.mDefaultVerticalGap = gap;
    }

    private final int $$robo$$android_inputmethodservice_Keyboard$getKeyHeight() {
        return this.mDefaultHeight;
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$setKeyHeight(int height) {
        this.mDefaultHeight = height;
    }

    private final int $$robo$$android_inputmethodservice_Keyboard$getKeyWidth() {
        return this.mDefaultWidth;
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$setKeyWidth(int width) {
        this.mDefaultWidth = width;
    }

    private final int $$robo$$android_inputmethodservice_Keyboard$getHeight() {
        return this.mTotalHeight;
    }

    private final int $$robo$$android_inputmethodservice_Keyboard$getMinWidth() {
        return this.mTotalWidth;
    }

    private final boolean $$robo$$android_inputmethodservice_Keyboard$setShifted(boolean shiftState) {
        for (Key shiftKey : this.mShiftKeys) {
            if (shiftKey == null) continue;
            shiftKey.on = shiftState;
        }
        if (this.mShifted != shiftState) {
            this.mShifted = shiftState;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_inputmethodservice_Keyboard$isShifted() {
        return this.mShifted;
    }

    private final int[] $$robo$$android_inputmethodservice_Keyboard$getShiftKeyIndices() {
        return this.mShiftKeyIndices;
    }

    private final int $$robo$$android_inputmethodservice_Keyboard$getShiftKeyIndex() {
        return this.mShiftKeyIndices[0];
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$computeNearestNeighbors() {
        this.mCellWidth = (this.getMinWidth() + 10 - 1) / 10;
        this.mCellHeight = (this.getHeight() + 5 - 1) / 5;
        this.mGridNeighbors = new int[50][];
        int[] indices = new int[this.mKeys.size()];
        int gridWidth = 10 * this.mCellWidth;
        int gridHeight = 5 * this.mCellHeight;
        for (int x = 0; x < gridWidth; x += this.mCellWidth) {
            for (int y = 0; y < gridHeight; y += this.mCellHeight) {
                int count = 0;
                for (int i = 0; i < this.mKeys.size(); ++i) {
                    Key key = this.mKeys.get(i);
                    if (key.squaredDistanceFrom(x, y) >= this.mProximityThreshold && key.squaredDistanceFrom(x + this.mCellWidth - 1, y) >= this.mProximityThreshold && key.squaredDistanceFrom(x + this.mCellWidth - 1, y + this.mCellHeight - 1) >= this.mProximityThreshold && key.squaredDistanceFrom(x, y + this.mCellHeight - 1) >= this.mProximityThreshold) continue;
                    indices[count++] = i;
                }
                int[] cell = new int[count];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])indices, (int)0, (int[])cell, (int)0, (int)count);
                this.mGridNeighbors[y / this.mCellHeight * 10 + x / this.mCellWidth] = cell;
            }
        }
    }

    private final int[] $$robo$$android_inputmethodservice_Keyboard$getNearestKeys(int x, int y) {
        int index;
        if (this.mGridNeighbors == null) {
            this.computeNearestNeighbors();
        }
        if (x >= 0 && x < this.getMinWidth() && y >= 0 && y < this.getHeight() && (index = y / this.mCellHeight * 10 + x / this.mCellWidth) < 50) {
            return this.mGridNeighbors[index];
        }
        return new int[0];
    }

    private final Row $$robo$$android_inputmethodservice_Keyboard$createRowFromXml(Resources res, XmlResourceParser parser) {
        return new Row(res, this, parser);
    }

    private final Key $$robo$$android_inputmethodservice_Keyboard$createKeyFromXml(Resources res, Row parent, int x, int y, XmlResourceParser parser) {
        return new Key(res, parent, x, y, parser);
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$loadKeyboard(Context context, XmlResourceParser parser) {
        boolean inKey = false;
        boolean inRow = false;
        boolean leftMostKey = false;
        int row = 0;
        int x = 0;
        int y = 0;
        Key key = null;
        Row currentRow = null;
        Resources res = context.getResources();
        boolean skipRow = false;
        try {
            int event;
            while ((event = parser.next()) != 1) {
                if (event == 2) {
                    String tag = parser.getName();
                    if ("Row".equals(tag)) {
                        inRow = true;
                        x = 0;
                        currentRow = this.createRowFromXml(res, parser);
                        this.rows.add(currentRow);
                        skipRow = currentRow.mode != 0 && currentRow.mode != this.mKeyboardMode;
                        if (!skipRow) continue;
                        this.skipToEndOfRow(parser);
                        inRow = false;
                        continue;
                    }
                    if ("Key".equals(tag)) {
                        inKey = true;
                        key = this.createKeyFromXml(res, currentRow, x, y, parser);
                        this.mKeys.add(key);
                        if (key.codes[0] == -1) {
                            for (int i = 0; i < this.mShiftKeys.length; ++i) {
                                if (this.mShiftKeys[i] != null) continue;
                                this.mShiftKeys[i] = key;
                                this.mShiftKeyIndices[i] = this.mKeys.size() - 1;
                                break;
                            }
                            this.mModifierKeys.add(key);
                        } else if (key.codes[0] == -6) {
                            this.mModifierKeys.add(key);
                        }
                        currentRow.mKeys.add(key);
                        continue;
                    }
                    if (!"Keyboard".equals(tag)) continue;
                    this.parseKeyboardAttributes(res, parser);
                    continue;
                }
                if (event != 3) continue;
                if (inKey) {
                    inKey = false;
                    if ((x += key.gap + key.width) <= this.mTotalWidth) continue;
                    this.mTotalWidth = x;
                    continue;
                }
                if (!inRow) continue;
                inRow = false;
                y += currentRow.verticalGap;
                y += currentRow.defaultHeight;
                ++row;
            }
        }
        catch (Exception e) {
            Log.e("Keyboard", "Parse error:" + e);
            e.printStackTrace();
        }
        this.mTotalHeight = y - this.mDefaultVerticalGap;
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$skipToEndOfRow(XmlResourceParser parser) throws XmlPullParserException, IOException {
        int event;
        while (!((event = parser.next()) == 1 || event == 3 && parser.getName().equals("Row"))) {
        }
    }

    private final void $$robo$$android_inputmethodservice_Keyboard$parseKeyboardAttributes(Resources res, XmlResourceParser parser) {
        TypedArray a = res.obtainAttributes(Xml.asAttributeSet(parser), R.styleable.Keyboard);
        this.mDefaultWidth = Keyboard.getDimensionOrFraction(a, 0, this.mDisplayWidth, this.mDisplayWidth / 10);
        this.mDefaultHeight = Keyboard.getDimensionOrFraction(a, 1, this.mDisplayHeight, 50);
        this.mDefaultHorizontalGap = Keyboard.getDimensionOrFraction(a, 2, this.mDisplayWidth, 0);
        this.mDefaultVerticalGap = Keyboard.getDimensionOrFraction(a, 3, this.mDisplayHeight, 0);
        this.mProximityThreshold = (int)((float)this.mDefaultWidth * SEARCH_DISTANCE);
        this.mProximityThreshold *= this.mProximityThreshold;
        a.recycle();
    }

    private static final int $$robo$$android_inputmethodservice_Keyboard$getDimensionOrFraction(TypedArray a, int index, int base, int defValue) {
        TypedValue value = a.peekValue(index);
        if (value == null) {
            return defValue;
        }
        if (value.type == 5) {
            return a.getDimensionPixelOffset(index, defValue);
        }
        if (value.type == 6) {
            return Math.round(a.getFraction(index, base, base, defValue));
        }
        return defValue;
    }

    static void __staticInitializer__() {
        SEARCH_DISTANCE = 1.8f;
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_inputmethodservice_Keyboard$__constructor__(context, n);
    }

    public Keyboard(Context context, int n) {
        this(context, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_Keyboard$__constructor__(android.content.Context int ), this, context, n);
    }

    private void __constructor__(Context context, int n, int n2, int n3, int n4) {
        this.$$robo$$android_inputmethodservice_Keyboard$__constructor__(context, n, n2, n3, n4);
    }

    public Keyboard(Context context, int n, int n2, int n3, int n4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_Keyboard$__constructor__(android.content.Context int int int int ), this, context, n, n2, n3, n4);
    }

    private void __constructor__(Context context, int n, int n2) {
        this.$$robo$$android_inputmethodservice_Keyboard$__constructor__(context, n, n2);
    }

    public Keyboard(Context context, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_Keyboard$__constructor__(android.content.Context int int ), this, context, n, n2);
    }

    private void __constructor__(Context context, int n, CharSequence charSequence, int n2, int n3) {
        this.$$robo$$android_inputmethodservice_Keyboard$__constructor__(context, n, charSequence, n2, n3);
    }

    public Keyboard(Context context, int n, CharSequence charSequence, int n2, int n3) {
        this(context, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_Keyboard$__constructor__(android.content.Context int java.lang.CharSequence int int ), this, context, n, charSequence, n2, n3);
    }

    void resize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("resize", $$robo$$android_inputmethodservice_Keyboard$resize(int int ), this, n, n2);
    }

    public List<Key> getKeys() {
        return InvokeDynamicSupport.bootstrap("getKeys", $$robo$$android_inputmethodservice_Keyboard$getKeys(), this);
    }

    public List<Key> getModifierKeys() {
        return InvokeDynamicSupport.bootstrap("getModifierKeys", $$robo$$android_inputmethodservice_Keyboard$getModifierKeys(), this);
    }

    protected int getHorizontalGap() {
        return (int)InvokeDynamicSupport.bootstrap("getHorizontalGap", $$robo$$android_inputmethodservice_Keyboard$getHorizontalGap(), this);
    }

    protected void setHorizontalGap(int n) {
        InvokeDynamicSupport.bootstrap("setHorizontalGap", $$robo$$android_inputmethodservice_Keyboard$setHorizontalGap(int ), this, n);
    }

    protected int getVerticalGap() {
        return (int)InvokeDynamicSupport.bootstrap("getVerticalGap", $$robo$$android_inputmethodservice_Keyboard$getVerticalGap(), this);
    }

    protected void setVerticalGap(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalGap", $$robo$$android_inputmethodservice_Keyboard$setVerticalGap(int ), this, n);
    }

    protected int getKeyHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getKeyHeight", $$robo$$android_inputmethodservice_Keyboard$getKeyHeight(), this);
    }

    protected void setKeyHeight(int n) {
        InvokeDynamicSupport.bootstrap("setKeyHeight", $$robo$$android_inputmethodservice_Keyboard$setKeyHeight(int ), this, n);
    }

    protected int getKeyWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getKeyWidth", $$robo$$android_inputmethodservice_Keyboard$getKeyWidth(), this);
    }

    protected void setKeyWidth(int n) {
        InvokeDynamicSupport.bootstrap("setKeyWidth", $$robo$$android_inputmethodservice_Keyboard$setKeyWidth(int ), this, n);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_inputmethodservice_Keyboard$getHeight(), this);
    }

    public int getMinWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMinWidth", $$robo$$android_inputmethodservice_Keyboard$getMinWidth(), this);
    }

    public boolean setShifted(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setShifted", $$robo$$android_inputmethodservice_Keyboard$setShifted(boolean ), this, bl);
    }

    public boolean isShifted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShifted", $$robo$$android_inputmethodservice_Keyboard$isShifted(), this);
    }

    public int[] getShiftKeyIndices() {
        return InvokeDynamicSupport.bootstrap("getShiftKeyIndices", $$robo$$android_inputmethodservice_Keyboard$getShiftKeyIndices(), this);
    }

    public int getShiftKeyIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getShiftKeyIndex", $$robo$$android_inputmethodservice_Keyboard$getShiftKeyIndex(), this);
    }

    private void computeNearestNeighbors() {
        InvokeDynamicSupport.bootstrap("computeNearestNeighbors", $$robo$$android_inputmethodservice_Keyboard$computeNearestNeighbors(), this);
    }

    public int[] getNearestKeys(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getNearestKeys", $$robo$$android_inputmethodservice_Keyboard$getNearestKeys(int int ), this, n, n2);
    }

    protected Row createRowFromXml(Resources resources, XmlResourceParser xmlResourceParser) {
        return InvokeDynamicSupport.bootstrap("createRowFromXml", $$robo$$android_inputmethodservice_Keyboard$createRowFromXml(android.content.res.Resources android.content.res.XmlResourceParser ), this, resources, xmlResourceParser);
    }

    protected Key createKeyFromXml(Resources resources, Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
        return InvokeDynamicSupport.bootstrap("createKeyFromXml", $$robo$$android_inputmethodservice_Keyboard$createKeyFromXml(android.content.res.Resources android.inputmethodservice.Keyboard$Row int int android.content.res.XmlResourceParser ), this, resources, row, n, n2, xmlResourceParser);
    }

    private void loadKeyboard(Context context, XmlResourceParser xmlResourceParser) {
        InvokeDynamicSupport.bootstrap("loadKeyboard", $$robo$$android_inputmethodservice_Keyboard$loadKeyboard(android.content.Context android.content.res.XmlResourceParser ), this, context, xmlResourceParser);
    }

    private void skipToEndOfRow(XmlResourceParser xmlResourceParser) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("skipToEndOfRow", $$robo$$android_inputmethodservice_Keyboard$skipToEndOfRow(android.content.res.XmlResourceParser ), this, xmlResourceParser);
    }

    private void parseKeyboardAttributes(Resources resources, XmlResourceParser xmlResourceParser) {
        InvokeDynamicSupport.bootstrap("parseKeyboardAttributes", $$robo$$android_inputmethodservice_Keyboard$parseKeyboardAttributes(android.content.res.Resources android.content.res.XmlResourceParser ), this, resources, xmlResourceParser);
    }

    static int getDimensionOrFraction(TypedArray typedArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDimensionOrFraction", $$robo$$android_inputmethodservice_Keyboard$getDimensionOrFraction(android.content.res.TypedArray int int int ), (TypedArray)typedArray, (int)n, (int)n2, (int)n3);
    }

    static {
        RobolectricInternals.classInitializing(Keyboard.class);
    }

    public /* synthetic */ Keyboard() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Keyboard)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Key
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int[] codes;
        public CharSequence label;
        public Drawable icon;
        public Drawable iconPreview;
        public int width;
        public int height;
        public int gap;
        public boolean sticky;
        public int x;
        public int y;
        public boolean pressed;
        public boolean on;
        public CharSequence text;
        public CharSequence popupCharacters;
        public int edgeFlags;
        public boolean modifier;
        private Keyboard keyboard;
        public int popupResId;
        public boolean repeatable;
        private static int[] KEY_STATE_NORMAL_ON;
        private static int[] KEY_STATE_PRESSED_ON;
        private static int[] KEY_STATE_NORMAL_OFF;
        private static int[] KEY_STATE_PRESSED_OFF;
        private static int[] KEY_STATE_NORMAL;
        private static int[] KEY_STATE_PRESSED;

        private void $$robo$$android_inputmethodservice_Keyboard_Key$__constructor__(Row parent) {
            this.keyboard = parent.parent;
            this.height = parent.defaultHeight;
            this.width = parent.defaultWidth;
            this.gap = parent.defaultHorizontalGap;
            this.edgeFlags = parent.rowEdgeFlags;
        }

        private void $$robo$$android_inputmethodservice_Keyboard_Key$__constructor__(Resources res, Row parent, int x, int y, XmlResourceParser parser) {
            this.x = x;
            this.y = y;
            TypedArray a = res.obtainAttributes(Xml.asAttributeSet(parser), R.styleable.Keyboard);
            this.width = Keyboard.getDimensionOrFraction(a, 0, this.keyboard.mDisplayWidth, parent.defaultWidth);
            this.height = Keyboard.getDimensionOrFraction(a, 1, this.keyboard.mDisplayHeight, parent.defaultHeight);
            this.gap = Keyboard.getDimensionOrFraction(a, 2, this.keyboard.mDisplayWidth, parent.defaultHorizontalGap);
            a.recycle();
            a = res.obtainAttributes(Xml.asAttributeSet(parser), R.styleable.Keyboard_Key);
            this.x += this.gap;
            TypedValue codesValue = new TypedValue();
            a.getValue(0, codesValue);
            if (codesValue.type == 16 || codesValue.type == 17) {
                this.codes = new int[]{codesValue.data};
            } else if (codesValue.type == 3) {
                this.codes = this.parseCSV(codesValue.string.toString());
            }
            this.iconPreview = a.getDrawable(7);
            if (this.iconPreview != null) {
                this.iconPreview.setBounds(0, 0, this.iconPreview.getIntrinsicWidth(), this.iconPreview.getIntrinsicHeight());
            }
            this.popupCharacters = a.getText(2);
            this.popupResId = a.getResourceId(1, 0);
            this.repeatable = a.getBoolean(6, false);
            this.modifier = a.getBoolean(4, false);
            this.sticky = a.getBoolean(5, false);
            this.edgeFlags = a.getInt(3, 0);
            this.edgeFlags |= parent.rowEdgeFlags;
            this.icon = a.getDrawable(10);
            if (this.icon != null) {
                this.icon.setBounds(0, 0, this.icon.getIntrinsicWidth(), this.icon.getIntrinsicHeight());
            }
            this.label = a.getText(9);
            this.text = a.getText(8);
            if (this.codes == null && !TextUtils.isEmpty(this.label)) {
                this.codes = new int[]{this.label.charAt(0)};
            }
            a.recycle();
        }

        private final void $$robo$$android_inputmethodservice_Keyboard_Key$onPressed() {
            this.pressed = !this.pressed;
        }

        private final void $$robo$$android_inputmethodservice_Keyboard_Key$onReleased(boolean inside) {
            boolean bl = this.pressed = !this.pressed;
            if (this.sticky && inside) {
                this.on = !this.on;
            }
        }

        private final int[] $$robo$$android_inputmethodservice_Keyboard_Key$parseCSV(String value) {
            int count = 0;
            int lastIndex = 0;
            if (value.length() > 0) {
                ++count;
                while ((lastIndex = value.indexOf(",", lastIndex + 1)) > 0) {
                    ++count;
                }
            }
            int[] values = new int[count];
            count = 0;
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                try {
                    values[count++] = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException nfe) {
                    Log.e("Keyboard", "Error parsing keycodes " + value);
                }
            }
            return values;
        }

        private final boolean $$robo$$android_inputmethodservice_Keyboard_Key$isInside(int x, int y) {
            boolean bottomEdge;
            boolean leftEdge = (this.edgeFlags & 1) > 0;
            boolean rightEdge = (this.edgeFlags & 2) > 0;
            boolean topEdge = (this.edgeFlags & 4) > 0;
            boolean bl = bottomEdge = (this.edgeFlags & 8) > 0;
            return (x >= this.x || leftEdge && x <= this.x + this.width) && (x < this.x + this.width || rightEdge && x >= this.x) && (y >= this.y || topEdge && y <= this.y + this.height) && (y < this.y + this.height || bottomEdge && y >= this.y);
        }

        private final int $$robo$$android_inputmethodservice_Keyboard_Key$squaredDistanceFrom(int x, int y) {
            int xDist = this.x + this.width / 2 - x;
            int yDist = this.y + this.height / 2 - y;
            return xDist * xDist + yDist * yDist;
        }

        private final int[] $$robo$$android_inputmethodservice_Keyboard_Key$getCurrentDrawableState() {
            int[] states = KEY_STATE_NORMAL;
            if (this.on) {
                states = this.pressed ? KEY_STATE_PRESSED_ON : KEY_STATE_NORMAL_ON;
            } else if (this.sticky) {
                states = this.pressed ? KEY_STATE_PRESSED_OFF : KEY_STATE_NORMAL_OFF;
            } else if (this.pressed) {
                states = KEY_STATE_PRESSED;
            }
            return states;
        }

        static void __staticInitializer__() {
            KEY_STATE_NORMAL_ON = new int[]{16842911, 0x10100A0};
            KEY_STATE_PRESSED_ON = new int[]{16842919, 16842911, 0x10100A0};
            KEY_STATE_NORMAL_OFF = new int[]{16842911};
            KEY_STATE_PRESSED_OFF = new int[]{16842919, 16842911};
            KEY_STATE_NORMAL = new int[0];
            KEY_STATE_PRESSED = new int[]{16842919};
        }

        private void __constructor__(Row row) {
            this.$$robo$$android_inputmethodservice_Keyboard_Key$__constructor__(row);
        }

        public Key(Row row) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_Keyboard_Key$__constructor__(android.inputmethodservice.Keyboard$Row ), this, row);
        }

        private void __constructor__(Resources resources, Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
            this.$$robo$$android_inputmethodservice_Keyboard_Key$__constructor__(resources, row, n, n2, xmlResourceParser);
        }

        public Key(Resources resources, Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
            this(row);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_Keyboard_Key$__constructor__(android.content.res.Resources android.inputmethodservice.Keyboard$Row int int android.content.res.XmlResourceParser ), this, resources, row, n, n2, xmlResourceParser);
        }

        public void onPressed() {
            InvokeDynamicSupport.bootstrap("onPressed", $$robo$$android_inputmethodservice_Keyboard_Key$onPressed(), this);
        }

        public void onReleased(boolean bl) {
            InvokeDynamicSupport.bootstrap("onReleased", $$robo$$android_inputmethodservice_Keyboard_Key$onReleased(boolean ), this, bl);
        }

        int[] parseCSV(String string2) {
            return InvokeDynamicSupport.bootstrap("parseCSV", $$robo$$android_inputmethodservice_Keyboard_Key$parseCSV(java.lang.String ), this, string2);
        }

        public boolean isInside(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isInside", $$robo$$android_inputmethodservice_Keyboard_Key$isInside(int int ), this, n, n2);
        }

        public int squaredDistanceFrom(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("squaredDistanceFrom", $$robo$$android_inputmethodservice_Keyboard_Key$squaredDistanceFrom(int int ), this, n, n2);
        }

        public int[] getCurrentDrawableState() {
            return InvokeDynamicSupport.bootstrap("getCurrentDrawableState", $$robo$$android_inputmethodservice_Keyboard_Key$getCurrentDrawableState(), this);
        }

        static {
            RobolectricInternals.classInitializing(Key.class);
        }

        public /* synthetic */ Key() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Key)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Row
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int defaultWidth;
        public int defaultHeight;
        public int defaultHorizontalGap;
        public int verticalGap;
        ArrayList<Key> mKeys;
        public int rowEdgeFlags;
        public int mode;
        private Keyboard parent;

        private void $$robo$$android_inputmethodservice_Keyboard_Row$__constructor__(Keyboard parent) {
            this.mKeys = new ArrayList();
            this.parent = parent;
        }

        private void $$robo$$android_inputmethodservice_Keyboard_Row$__constructor__(Resources res, Keyboard parent, XmlResourceParser parser) {
            this.mKeys = new ArrayList();
            this.parent = parent;
            TypedArray a = res.obtainAttributes(Xml.asAttributeSet(parser), R.styleable.Keyboard);
            this.defaultWidth = Keyboard.getDimensionOrFraction(a, 0, parent.mDisplayWidth, parent.mDefaultWidth);
            this.defaultHeight = Keyboard.getDimensionOrFraction(a, 1, parent.mDisplayHeight, parent.mDefaultHeight);
            this.defaultHorizontalGap = Keyboard.getDimensionOrFraction(a, 2, parent.mDisplayWidth, parent.mDefaultHorizontalGap);
            this.verticalGap = Keyboard.getDimensionOrFraction(a, 3, parent.mDisplayHeight, parent.mDefaultVerticalGap);
            a.recycle();
            a = res.obtainAttributes(Xml.asAttributeSet(parser), R.styleable.Keyboard_Row);
            this.rowEdgeFlags = a.getInt(0, 0);
            this.mode = a.getResourceId(1, 0);
        }

        private void __constructor__(Keyboard keyboard) {
            this.$$robo$$android_inputmethodservice_Keyboard_Row$__constructor__(keyboard);
        }

        public Row(Keyboard keyboard) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_Keyboard_Row$__constructor__(android.inputmethodservice.Keyboard ), this, keyboard);
        }

        private void __constructor__(Resources resources, Keyboard keyboard, XmlResourceParser xmlResourceParser) {
            this.$$robo$$android_inputmethodservice_Keyboard_Row$__constructor__(resources, keyboard, xmlResourceParser);
        }

        public Row(Resources resources, Keyboard keyboard, XmlResourceParser xmlResourceParser) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_Keyboard_Row$__constructor__(android.content.res.Resources android.inputmethodservice.Keyboard android.content.res.XmlResourceParser ), this, resources, keyboard, xmlResourceParser);
        }

        public /* synthetic */ Row() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Row)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

