/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.annotation.IntDef;
import android.app.ActivityManager;
import android.app.Dialog;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.ExtractEditText;
import android.inputmethodservice.SoftInputWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.Layout;
import android.text.Spannable;
import android.text.method.MovementMethod;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InputMethodService
extends AbstractInputMethodService
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "InputMethodService";
    static boolean DEBUG = false;
    public static int BACK_DISPOSITION_DEFAULT = 0;
    public static int BACK_DISPOSITION_WILL_NOT_DISMISS = 1;
    public static int BACK_DISPOSITION_WILL_DISMISS = 2;
    public static int IME_ACTIVE = 1;
    public static int IME_VISIBLE = 2;
    InputMethodManager mImm;
    int mTheme;
    LayoutInflater mInflater;
    TypedArray mThemeAttrs;
    View mRootView;
    SoftInputWindow mWindow;
    boolean mInitialized;
    boolean mWindowCreated;
    boolean mWindowAdded;
    boolean mWindowVisible;
    boolean mWindowWasVisible;
    boolean mInShowWindow;
    ViewGroup mFullscreenArea;
    FrameLayout mExtractFrame;
    FrameLayout mCandidatesFrame;
    FrameLayout mInputFrame;
    IBinder mToken;
    InputBinding mInputBinding;
    InputConnection mInputConnection;
    boolean mInputStarted;
    boolean mInputViewStarted;
    boolean mCandidatesViewStarted;
    InputConnection mStartedInputConnection;
    EditorInfo mInputEditorInfo;
    private IBinder mStartInputToken;
    int mShowInputFlags;
    boolean mShowInputRequested;
    boolean mLastShowInputRequested;
    int mCandidatesVisibility;
    CompletionInfo[] mCurCompletions;
    boolean mFullscreenApplied;
    boolean mIsFullscreen;
    View mExtractView;
    boolean mExtractViewHidden;
    ExtractEditText mExtractEditText;
    ViewGroup mExtractAccessories;
    View mExtractAction;
    ExtractedText mExtractedText;
    int mExtractedToken;
    View mInputView;
    boolean mIsInputViewShown;
    int mStatusIcon;
    int mBackDisposition;
    boolean mShouldClearInsetOfPreviousIme;
    Insets mTmpInsets;
    int[] mTmpLocation;
    ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer;
    View.OnClickListener mActionClickListener;
    private SettingsObserver mSettingsObserver;
    static int MOVEMENT_DOWN = -1;
    static int MOVEMENT_UP = -2;

    private void $$robo$$android_inputmethodservice_InputMethodService$__constructor__() {
        this.mTheme = 0;
        this.mTmpInsets = new Insets();
        this.mTmpLocation = new int[2];
        this.mInsetsComputer = new ViewTreeObserver.OnComputeInternalInsetsListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ InputMethodService this$0;

            private void $$robo$$android_inputmethodservice_InputMethodService_1$__constructor__(InputMethodService this$0) {
            }

            private final void $$robo$$android_inputmethodservice_InputMethodService_1$onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo info) {
                if (this.this$0.isExtractViewShown()) {
                    View decor = this.this$0.getWindow().getWindow().getDecorView();
                    info.contentInsets.top = info.visibleInsets.top = decor.getHeight();
                    info.touchableRegion.setEmpty();
                    info.setTouchableInsets(0);
                } else {
                    this.this$0.onComputeInsets(this.this$0.mTmpInsets);
                    info.contentInsets.top = this.this$0.mTmpInsets.contentTopInsets;
                    info.visibleInsets.top = this.this$0.mTmpInsets.visibleTopInsets;
                    info.touchableRegion.set(this.this$0.mTmpInsets.touchableRegion);
                    info.setTouchableInsets(this.this$0.mTmpInsets.touchableInsets);
                }
            }

            private void __constructor__(InputMethodService inputMethodService) {
                this.$$robo$$android_inputmethodservice_InputMethodService_1$__constructor__(inputMethodService);
            }
            {
                this.this$0 = inputMethodService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_InputMethodService_1$__constructor__(android.inputmethodservice.InputMethodService ), this, inputMethodService);
            }

            @Override
            public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo internalInsetsInfo) {
                InvokeDynamicSupport.bootstrap("onComputeInternalInsets", $$robo$$android_inputmethodservice_InputMethodService_1$onComputeInternalInsets(android.view.ViewTreeObserver$InternalInsetsInfo ), this, internalInsetsInfo);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mActionClickListener = new View.OnClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ InputMethodService this$0;

            private void $$robo$$android_inputmethodservice_InputMethodService_2$__constructor__(InputMethodService this$0) {
            }

            private final void $$robo$$android_inputmethodservice_InputMethodService_2$onClick(View v) {
                EditorInfo ei = this.this$0.getCurrentInputEditorInfo();
                InputConnection ic = this.this$0.getCurrentInputConnection();
                if (ei != null && ic != null) {
                    if (ei.actionId != 0) {
                        ic.performEditorAction(ei.actionId);
                    } else if ((ei.imeOptions & 0xFF) != 1) {
                        ic.performEditorAction(ei.imeOptions & 0xFF);
                    }
                }
            }

            private void __constructor__(InputMethodService inputMethodService) {
                this.$$robo$$android_inputmethodservice_InputMethodService_2$__constructor__(inputMethodService);
            }
            {
                this.this$0 = inputMethodService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_InputMethodService_2$__constructor__(android.inputmethodservice.InputMethodService ), this, inputMethodService);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_inputmethodservice_InputMethodService_2$onClick(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$setTheme(int theme) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = theme;
    }

    @Deprecated
    private final boolean $$robo$$android_inputmethodservice_InputMethodService$enableHardwareAcceleration() {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        return ActivityManager.isHighEndGfx();
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onCreate() {
        this.mTheme = Resources.selectSystemTheme(this.mTheme, this.getApplicationInfo().targetSdkVersion, 16973908, 16973951, 16974142, 16974142);
        super.setTheme(this.mTheme);
        super.onCreate();
        this.mImm = (InputMethodManager)this.getSystemService("input_method");
        this.mSettingsObserver = SettingsObserver.createAndRegister(this);
        this.mShouldClearInsetOfPreviousIme = this.mImm.getInputMethodWindowVisibleHeight() > 0;
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.mWindow = new SoftInputWindow(this, "InputMethod", this.mTheme, null, null, this.mDispatcherState, 2011, 80, false);
        this.initViews();
        this.mWindow.getWindow().setLayout(-1, -2);
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onInitializeInterface() {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$initialize() {
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.onInitializeInterface();
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$initViews() {
        this.mInitialized = false;
        this.mWindowCreated = false;
        this.mShowInputRequested = false;
        this.mShowInputFlags = 0;
        this.mThemeAttrs = this.obtainStyledAttributes(R.styleable.InputMethodService);
        this.mRootView = this.mInflater.inflate(17367149, null);
        this.mRootView.setSystemUiVisibility(768);
        this.mWindow.setContentView(this.mRootView);
        this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.mRootView.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsComputer);
        if (Settings.Global.getInt(this.getContentResolver(), "fancy_ime_animations", 0) != 0) {
            this.mWindow.getWindow().setWindowAnimations(16974579);
        }
        this.mFullscreenArea = (ViewGroup)this.mRootView.findViewById(16908910);
        this.mExtractViewHidden = false;
        this.mExtractFrame = (FrameLayout)this.mRootView.findViewById(16908316);
        this.mExtractView = null;
        this.mExtractEditText = null;
        this.mExtractAccessories = null;
        this.mExtractAction = null;
        this.mFullscreenApplied = false;
        this.mCandidatesFrame = (FrameLayout)this.mRootView.findViewById(16908317);
        this.mInputFrame = (FrameLayout)this.mRootView.findViewById(16908318);
        this.mInputView = null;
        this.mIsInputViewShown = false;
        this.mExtractFrame.setVisibility(8);
        this.mCandidatesVisibility = this.getCandidatesHiddenVisibility();
        this.mCandidatesFrame.setVisibility(this.mCandidatesVisibility);
        this.mInputFrame.setVisibility(8);
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onDestroy() {
        super.onDestroy();
        this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.doFinishInput();
        if (this.mWindowAdded) {
            this.mWindow.getWindow().setWindowAnimations(0);
            this.mWindow.dismiss();
        }
        if (this.mSettingsObserver != null) {
            this.mSettingsObserver.unregister();
            this.mSettingsObserver = null;
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resetStateForNewConfiguration();
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$resetStateForNewConfiguration() {
        boolean visible = this.mWindowVisible;
        int showFlags = this.mShowInputFlags;
        boolean showingInput = this.mShowInputRequested;
        CompletionInfo[] completions = this.mCurCompletions;
        this.initViews();
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.doStartInput(this.getCurrentInputConnection(), this.getCurrentInputEditorInfo(), true);
        }
        if (visible) {
            boolean showing;
            if (showingInput) {
                if (this.dispatchOnShowInputRequested(showFlags, true)) {
                    this.showWindow(true);
                    if (completions != null) {
                        this.mCurCompletions = completions;
                        this.onDisplayCompletions(completions);
                    }
                } else {
                    this.doHideWindow();
                }
            } else if (this.mCandidatesVisibility == 0) {
                this.showWindow(false);
            } else {
                this.doHideWindow();
            }
            this.mImm.setImeWindowStatus(this.mToken, this.mStartInputToken, 1 | ((showing = this.onEvaluateInputViewShown()) ? 2 : 0), this.mBackDisposition);
        }
    }

    private final AbstractInputMethodService.AbstractInputMethodImpl $$robo$$android_inputmethodservice_InputMethodService$onCreateInputMethodInterface() {
        return new InputMethodImpl(this);
    }

    private final AbstractInputMethodService.AbstractInputMethodSessionImpl $$robo$$android_inputmethodservice_InputMethodService$onCreateInputMethodSessionInterface() {
        return new InputMethodSessionImpl(this);
    }

    private final LayoutInflater $$robo$$android_inputmethodservice_InputMethodService$getLayoutInflater() {
        return this.mInflater;
    }

    private final Dialog $$robo$$android_inputmethodservice_InputMethodService$getWindow() {
        return this.mWindow;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$setBackDisposition(int disposition) {
        this.mBackDisposition = disposition;
    }

    private final int $$robo$$android_inputmethodservice_InputMethodService$getBackDisposition() {
        return this.mBackDisposition;
    }

    private final int $$robo$$android_inputmethodservice_InputMethodService$getMaxWidth() {
        WindowManager wm = (WindowManager)this.getSystemService("window");
        return wm.getDefaultDisplay().getWidth();
    }

    private final InputBinding $$robo$$android_inputmethodservice_InputMethodService$getCurrentInputBinding() {
        return this.mInputBinding;
    }

    private final InputConnection $$robo$$android_inputmethodservice_InputMethodService$getCurrentInputConnection() {
        InputConnection ic = this.mStartedInputConnection;
        if (ic != null) {
            return ic;
        }
        return this.mInputConnection;
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$getCurrentInputStarted() {
        return this.mInputStarted;
    }

    private final EditorInfo $$robo$$android_inputmethodservice_InputMethodService$getCurrentInputEditorInfo() {
        return this.mInputEditorInfo;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$updateFullscreenMode() {
        boolean changed;
        boolean isFullscreen = this.mShowInputRequested && this.onEvaluateFullscreenMode();
        boolean bl = changed = this.mLastShowInputRequested != this.mShowInputRequested;
        if (this.mIsFullscreen != isFullscreen || !this.mFullscreenApplied) {
            changed = true;
            this.mIsFullscreen = isFullscreen;
            if (this.mImm != null && this.mToken != null) {
                this.mImm.reportFullscreenMode(this.mToken, this.mIsFullscreen);
            }
            this.mFullscreenApplied = true;
            this.initialize();
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mFullscreenArea.getLayoutParams();
            if (isFullscreen) {
                this.mFullscreenArea.setBackgroundDrawable(this.mThemeAttrs.getDrawable(0));
                lp.height = 0;
                lp.weight = 1.0f;
            } else {
                this.mFullscreenArea.setBackgroundDrawable(null);
                lp.height = -2;
                lp.weight = 0.0f;
            }
            ((ViewGroup)this.mFullscreenArea.getParent()).updateViewLayout(this.mFullscreenArea, lp);
            if (isFullscreen) {
                View v;
                if (this.mExtractView == null && (v = this.onCreateExtractTextView()) != null) {
                    this.setExtractView(v);
                }
                this.startExtractingText(false);
            }
            this.updateExtractFrameVisibility();
        }
        if (changed) {
            this.onConfigureWindow(this.mWindow.getWindow(), isFullscreen, !this.mShowInputRequested);
            this.mLastShowInputRequested = this.mShowInputRequested;
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onConfigureWindow(Window win, boolean isFullscreen, boolean isCandidatesOnly) {
        int newHeight;
        int currentHeight = this.mWindow.getWindow().getAttributes().height;
        int n = newHeight = isFullscreen ? -1 : -2;
        if (!this.mIsInputViewShown || currentHeight != newHeight) {
            // empty if block
        }
        this.mWindow.getWindow().setLayout(-1, newHeight);
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$isFullscreenMode() {
        return this.mIsFullscreen;
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onEvaluateFullscreenMode() {
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation != 2) {
            return false;
        }
        return this.mInputEditorInfo == null || (this.mInputEditorInfo.imeOptions & 0x2000000) == 0;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$setExtractViewShown(boolean shown) {
        if (this.mExtractViewHidden == shown) {
            this.mExtractViewHidden = !shown;
            this.updateExtractFrameVisibility();
        }
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$isExtractViewShown() {
        return this.mIsFullscreen && !this.mExtractViewHidden;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$updateExtractFrameVisibility() {
        int animRes;
        int vis;
        if (this.isFullscreenMode()) {
            vis = this.mExtractViewHidden ? 4 : 0;
            this.mExtractFrame.setVisibility(vis);
        } else {
            vis = 0;
            this.mExtractFrame.setVisibility(8);
        }
        this.updateCandidatesVisibility(this.mCandidatesVisibility == 0);
        if (this.mWindowWasVisible && this.mFullscreenArea.getVisibility() != vis && (animRes = this.mThemeAttrs.getResourceId(vis == 0 ? 1 : 2, 0)) != 0) {
            this.mFullscreenArea.startAnimation(AnimationUtils.loadAnimation(this, animRes));
        }
        this.mFullscreenArea.setVisibility(vis);
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onComputeInsets(Insets outInsets) {
        View decor;
        int[] loc = this.mTmpLocation;
        if (this.mInputFrame.getVisibility() == 0) {
            this.mInputFrame.getLocationInWindow(loc);
        } else {
            decor = this.getWindow().getWindow().getDecorView();
            loc[1] = decor.getHeight();
        }
        if (this.isFullscreenMode()) {
            decor = this.getWindow().getWindow().getDecorView();
            outInsets.contentTopInsets = decor.getHeight();
        } else {
            outInsets.contentTopInsets = loc[1];
        }
        if (this.mCandidatesFrame.getVisibility() == 0) {
            this.mCandidatesFrame.getLocationInWindow(loc);
        }
        outInsets.visibleTopInsets = loc[1];
        outInsets.touchableInsets = 2;
        outInsets.touchableRegion.setEmpty();
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$updateInputViewShown() {
        boolean isShown;
        boolean bl = isShown = this.mShowInputRequested && this.onEvaluateInputViewShown();
        if (this.mIsInputViewShown != isShown && this.mWindowVisible) {
            this.mIsInputViewShown = isShown;
            this.mInputFrame.setVisibility(isShown ? 0 : 8);
            if (this.mInputView == null) {
                this.initialize();
                View v = this.onCreateInputView();
                if (v != null) {
                    this.setInputView(v);
                }
            }
        }
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$isShowInputRequested() {
        return this.mShowInputRequested;
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$isInputViewShown() {
        return this.mIsInputViewShown && this.mWindowVisible;
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onEvaluateInputViewShown() {
        if (this.mSettingsObserver == null) {
            Log.w("InputMethodService", "onEvaluateInputViewShown: mSettingsObserver must not be null here.");
            return false;
        }
        if (this.mSettingsObserver.shouldShowImeWithHardKeyboard()) {
            return true;
        }
        Configuration config = this.getResources().getConfiguration();
        return config.keyboard == 1 || config.hardKeyboardHidden == 2;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$setCandidatesViewShown(boolean shown) {
        this.updateCandidatesVisibility(shown);
        if (!this.mShowInputRequested && this.mWindowVisible != shown) {
            if (shown) {
                this.showWindow(false);
            } else {
                this.doHideWindow();
            }
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$updateCandidatesVisibility(boolean shown) {
        int vis;
        int n = vis = shown ? 0 : this.getCandidatesHiddenVisibility();
        if (this.mCandidatesVisibility != vis) {
            this.mCandidatesFrame.setVisibility(vis);
            this.mCandidatesVisibility = vis;
        }
    }

    private final int $$robo$$android_inputmethodservice_InputMethodService$getCandidatesHiddenVisibility() {
        return this.isExtractViewShown() ? 8 : 4;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$showStatusIcon(int iconResId) {
        this.mStatusIcon = iconResId;
        this.mImm.showStatusIcon(this.mToken, this.getPackageName(), iconResId);
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$hideStatusIcon() {
        this.mStatusIcon = 0;
        this.mImm.hideStatusIcon(this.mToken);
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$switchInputMethod(String id2) {
        this.mImm.setInputMethod(this.mToken, id2);
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$setExtractView(View view) {
        this.mExtractFrame.removeAllViews();
        this.mExtractFrame.addView(view, new FrameLayout.LayoutParams(-1, -1));
        this.mExtractView = view;
        if (view != null) {
            this.mExtractEditText = (ExtractEditText)view.findViewById(16908325);
            this.mExtractEditText.setIME(this);
            this.mExtractAction = view.findViewById(16908963);
            if (this.mExtractAction != null) {
                this.mExtractAccessories = (ViewGroup)view.findViewById(16908962);
            }
            this.startExtractingText(false);
        } else {
            this.mExtractEditText = null;
            this.mExtractAccessories = null;
            this.mExtractAction = null;
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$setCandidatesView(View view) {
        this.mCandidatesFrame.removeAllViews();
        this.mCandidatesFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$setInputView(View view) {
        this.mInputFrame.removeAllViews();
        this.mInputFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
        this.mInputView = view;
    }

    private final View $$robo$$android_inputmethodservice_InputMethodService$onCreateExtractTextView() {
        return this.mInflater.inflate(17367150, null);
    }

    private final View $$robo$$android_inputmethodservice_InputMethodService$onCreateCandidatesView() {
        return null;
    }

    private final View $$robo$$android_inputmethodservice_InputMethodService$onCreateInputView() {
        return null;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onStartInputView(EditorInfo info, boolean restarting) {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onFinishInputView(boolean finishingInput) {
        InputConnection ic;
        if (!finishingInput && (ic = this.getCurrentInputConnection()) != null) {
            ic.finishComposingText();
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onStartCandidatesView(EditorInfo info, boolean restarting) {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onFinishCandidatesView(boolean finishingInput) {
        InputConnection ic;
        if (!finishingInput && (ic = this.getCurrentInputConnection()) != null) {
            ic.finishComposingText();
        }
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onShowInputRequested(int flags, boolean configChange) {
        if (!this.onEvaluateInputViewShown()) {
            return false;
        }
        if ((flags & 1) == 0) {
            if (!configChange && this.onEvaluateFullscreenMode()) {
                return false;
            }
            if (!this.mSettingsObserver.shouldShowImeWithHardKeyboard() && this.getResources().getConfiguration().keyboard != 1) {
                return false;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$dispatchOnShowInputRequested(int flags, boolean configChange) {
        boolean result = this.onShowInputRequested(flags, configChange);
        this.mShowInputFlags = result ? flags : 0;
        return result;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$showWindow(boolean showInput) {
        if (this.mInShowWindow) {
            Log.w("InputMethodService", "Re-entrance in to showWindow");
            return;
        }
        try {
            this.mWindowWasVisible = this.mWindowVisible;
            this.mInShowWindow = true;
            this.showWindowInner(showInput);
        }
        catch (WindowManager.BadTokenException e) {
            this.mWindowVisible = false;
            this.mWindowAdded = false;
            throw e;
        }
        finally {
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$showWindowInner(boolean showInput) {
        int nextImeWindowStatus;
        boolean doShowInput = false;
        int previousImeWindowStatus = (this.mWindowVisible ? 1 : 0) | (this.isInputViewShown() ? 2 : 0);
        this.mWindowVisible = true;
        if (!this.mShowInputRequested && this.mInputStarted && showInput) {
            doShowInput = true;
            this.mShowInputRequested = true;
        }
        this.initialize();
        this.updateFullscreenMode();
        this.updateInputViewShown();
        if (!this.mWindowAdded || !this.mWindowCreated) {
            this.mWindowAdded = true;
            this.mWindowCreated = true;
            this.initialize();
            View v = this.onCreateCandidatesView();
            if (v != null) {
                this.setCandidatesView(v);
            }
        }
        if (this.mShowInputRequested) {
            if (!this.mInputViewStarted) {
                this.mInputViewStarted = true;
                this.onStartInputView(this.mInputEditorInfo, false);
            }
        } else if (!this.mCandidatesViewStarted) {
            this.mCandidatesViewStarted = true;
            this.onStartCandidatesView(this.mInputEditorInfo, false);
        }
        if (doShowInput) {
            this.startExtractingText(false);
        }
        if (previousImeWindowStatus != (nextImeWindowStatus = 1 | (this.isInputViewShown() ? 2 : 0))) {
            this.mImm.setImeWindowStatus(this.mToken, this.mStartInputToken, nextImeWindowStatus, this.mBackDisposition);
        }
        if ((previousImeWindowStatus & 1) == 0) {
            this.onWindowShown();
            this.mWindow.show();
            this.mShouldClearInsetOfPreviousIme = false;
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$finishViews() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(false);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(false);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$doHideWindow() {
        this.mImm.setImeWindowStatus(this.mToken, this.mStartInputToken, 0, this.mBackDisposition);
        this.hideWindow();
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$hideWindow() {
        this.finishViews();
        if (this.mWindowVisible) {
            this.mWindow.hide();
            this.mWindowVisible = false;
            this.onWindowHidden();
            this.mWindowWasVisible = false;
        }
        this.updateFullscreenMode();
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onWindowShown() {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onWindowHidden() {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$clearInsetOfPreviousIme() {
        if (!this.mShouldClearInsetOfPreviousIme) {
            return;
        }
        this.mImm.clearLastInputMethodWindowForTransition(this.mToken);
        this.mShouldClearInsetOfPreviousIme = false;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onBindInput() {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onUnbindInput() {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onStartInput(EditorInfo attribute, boolean restarting) {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$doFinishInput() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(true);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(true);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.onFinishInput();
        }
        this.mInputStarted = false;
        this.mStartedInputConnection = null;
        this.mCurCompletions = null;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$doStartInput(InputConnection ic, EditorInfo attribute, boolean restarting) {
        if (!restarting) {
            this.doFinishInput();
        }
        this.mInputStarted = true;
        this.mStartedInputConnection = ic;
        this.mInputEditorInfo = attribute;
        this.initialize();
        this.onStartInput(attribute, restarting);
        if (this.mWindowVisible) {
            if (this.mShowInputRequested) {
                this.mInputViewStarted = true;
                this.onStartInputView(this.mInputEditorInfo, restarting);
                this.startExtractingText(true);
            } else if (this.mCandidatesVisibility == 0) {
                this.mCandidatesViewStarted = true;
                this.onStartCandidatesView(this.mInputEditorInfo, restarting);
            }
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onFinishInput() {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic != null) {
            ic.finishComposingText();
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onDisplayCompletions(CompletionInfo[] completions) {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onUpdateExtractedText(int token, ExtractedText text) {
        if (this.mExtractedToken != token) {
            return;
        }
        if (text != null && this.mExtractEditText != null) {
            this.mExtractedText = text;
            this.mExtractEditText.setExtractedText(text);
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onUpdateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        ExtractEditText eet = this.mExtractEditText;
        if (eet != null && this.isFullscreenMode() && this.mExtractedText != null) {
            int off = this.mExtractedText.startOffset;
            eet.startInternalChanges();
            newSelEnd -= off;
            int len = eet.getText().length();
            if ((newSelStart -= off) < 0) {
                newSelStart = 0;
            } else if (newSelStart > len) {
                newSelStart = len;
            }
            if (newSelEnd < 0) {
                newSelEnd = 0;
            } else if (newSelEnd > len) {
                newSelEnd = len;
            }
            eet.setSelection(newSelStart, newSelEnd);
            eet.finishInternalChanges();
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onViewClicked(boolean focusChanged) {
    }

    @Deprecated
    private final void $$robo$$android_inputmethodservice_InputMethodService$onUpdateCursor(Rect newCursor) {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onUpdateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$requestHideSelf(int flags) {
        this.mImm.hideSoftInputFromInputMethod(this.mToken, flags);
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$requestShowSelf(int flags) {
        this.mImm.showSoftInputFromInputMethod(this.mToken, flags);
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$handleBack(boolean doIt) {
        if (this.mShowInputRequested) {
            if (doIt) {
                this.requestHideSelf(0);
            }
            return true;
        }
        if (this.mWindowVisible) {
            if (this.mCandidatesVisibility == 0) {
                if (doIt) {
                    this.setCandidatesViewShown(false);
                }
            } else if (doIt) {
                this.doHideWindow();
            }
            return true;
        }
        return false;
    }

    private final ExtractEditText $$robo$$android_inputmethodservice_InputMethodService$getExtractEditTextIfVisible() {
        if (!this.isExtractViewShown() || !this.isInputViewShown()) {
            return null;
        }
        return this.mExtractEditText;
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onKeyDown(int keyCode, KeyEvent event) {
        if (event.getKeyCode() == 4) {
            ExtractEditText eet = this.getExtractEditTextIfVisible();
            if (eet != null && eet.handleBackInTextActionModeIfNeeded(event)) {
                return true;
            }
            if (this.handleBack(false)) {
                event.startTracking();
                return true;
            }
            return false;
        }
        return this.doMovementKey(keyCode, event, -1);
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onKeyMultiple(int keyCode, int count, KeyEvent event) {
        return this.doMovementKey(keyCode, event, count);
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onKeyUp(int keyCode, KeyEvent event) {
        if (event.getKeyCode() == 4) {
            ExtractEditText eet = this.getExtractEditTextIfVisible();
            if (eet != null && eet.handleBackInTextActionModeIfNeeded(event)) {
                return true;
            }
            if (event.isTracking() && !event.isCanceled()) {
                return this.handleBack(true);
            }
        }
        return this.doMovementKey(keyCode, event, -2);
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onTrackballEvent(MotionEvent event) {
        return false;
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onAppPrivateCommand(String action, Bundle data) {
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onToggleSoftInput(int showFlags, int hideFlags) {
        if (this.isInputViewShown()) {
            this.requestHideSelf(hideFlags);
        } else {
            this.requestShowSelf(showFlags);
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$reportExtractedMovement(int keyCode, int count) {
        int dx = 0;
        int dy = 0;
        switch (keyCode) {
            case 21: {
                dx = -count;
                break;
            }
            case 22: {
                dx = count;
                break;
            }
            case 19: {
                dy = -count;
                break;
            }
            case 20: {
                dy = count;
            }
        }
        this.onExtractedCursorMovement(dx, dy);
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$doMovementKey(int keyCode, KeyEvent event, int count) {
        ExtractEditText eet = this.getExtractEditTextIfVisible();
        if (eet != null) {
            MovementMethod movement = eet.getMovementMethod();
            Layout layout2 = eet.getLayout();
            if (movement != null && layout2 != null) {
                if (count == -1) {
                    if (movement.onKeyDown(eet, (Spannable)eet.getText(), keyCode, event)) {
                        this.reportExtractedMovement(keyCode, 1);
                        return true;
                    }
                } else if (count == -2) {
                    if (movement.onKeyUp(eet, (Spannable)eet.getText(), keyCode, event)) {
                        return true;
                    }
                } else if (movement.onKeyOther(eet, (Spannable)eet.getText(), event)) {
                    this.reportExtractedMovement(keyCode, count);
                } else {
                    KeyEvent down = KeyEvent.changeAction(event, 0);
                    if (movement.onKeyDown(eet, (Spannable)eet.getText(), keyCode, down)) {
                        KeyEvent up = KeyEvent.changeAction(event, 1);
                        movement.onKeyUp(eet, (Spannable)eet.getText(), keyCode, up);
                        while (--count > 0) {
                            movement.onKeyDown(eet, (Spannable)eet.getText(), keyCode, down);
                            movement.onKeyUp(eet, (Spannable)eet.getText(), keyCode, up);
                        }
                        this.reportExtractedMovement(keyCode, count);
                    }
                }
            }
            switch (keyCode) {
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    return true;
                }
            }
        }
        return false;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$sendDownUpKeyEvents(int keyEventCode) {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic == null) {
            return;
        }
        long eventTime = SystemClock.uptimeMillis();
        ic.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, keyEventCode, 0, 0, -1, 0, 6));
        ic.sendKeyEvent(new KeyEvent(eventTime, SystemClock.uptimeMillis(), 1, keyEventCode, 0, 0, -1, 0, 6));
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$sendDefaultEditorAction(boolean fromEnterKey) {
        EditorInfo ei = this.getCurrentInputEditorInfo();
        if (!(ei == null || fromEnterKey && (ei.imeOptions & 0x40000000) != 0 || (ei.imeOptions & 0xFF) == 1)) {
            InputConnection ic = this.getCurrentInputConnection();
            if (ic != null) {
                ic.performEditorAction(ei.imeOptions & 0xFF);
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$sendKeyChar(char charCode) {
        switch (charCode) {
            case '\n': {
                if (this.sendDefaultEditorAction(true)) break;
                this.sendDownUpKeyEvents(66);
                break;
            }
            default: {
                if (charCode >= '0' && charCode <= '9') {
                    this.sendDownUpKeyEvents(charCode - 48 + 7);
                    break;
                }
                InputConnection ic = this.getCurrentInputConnection();
                if (ic == null) break;
                ic.commitText(String.valueOf(charCode), 1);
            }
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onExtractedSelectionChanged(int start, int end) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.setSelection(start, end);
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onExtractedDeleteText(int start, int end) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.finishComposingText();
            conn.setSelection(start, start);
            conn.deleteSurroundingText(0, end - start);
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onExtractedReplaceText(int start, int end, CharSequence text) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.setComposingRegion(start, end);
            conn.commitText(text, 1);
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onExtractedSetSpan(Object span, int start, int end, int flags) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            if (!conn.setSelection(start, end)) {
                return;
            }
            CharSequence text = conn.getSelectedText(1);
            if (text instanceof Spannable) {
                ((Spannable)text).setSpan(span, 0, text.length(), flags);
                conn.setComposingRegion(start, end);
                conn.commitText(text, 1);
            }
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onExtractedTextClicked() {
        if (this.mExtractEditText == null) {
            return;
        }
        if (this.mExtractEditText.hasVerticalScrollBar()) {
            this.setCandidatesViewShown(false);
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onExtractedCursorMovement(int dx, int dy) {
        if (this.mExtractEditText == null || dy == 0) {
            return;
        }
        if (this.mExtractEditText.hasVerticalScrollBar()) {
            this.setCandidatesViewShown(false);
        }
    }

    private final boolean $$robo$$android_inputmethodservice_InputMethodService$onExtractTextContextMenuItem(int id2) {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic != null) {
            ic.performContextMenuAction(id2);
        }
        return true;
    }

    private final CharSequence $$robo$$android_inputmethodservice_InputMethodService$getTextForImeAction(int imeOptions) {
        switch (imeOptions & 0xFF) {
            case 1: {
                return null;
            }
            case 2: {
                return this.getText(17039977);
            }
            case 3: {
                return this.getText(17039980);
            }
            case 4: {
                return this.getText(17039981);
            }
            case 5: {
                return this.getText(17039978);
            }
            case 6: {
                return this.getText(17039976);
            }
            case 7: {
                return this.getText(17039979);
            }
        }
        return this.getText(17039975);
    }

    private final int $$robo$$android_inputmethodservice_InputMethodService$getIconForImeAction(int imeOptions) {
        switch (imeOptions & 0xFF) {
            case 2: {
                return 17302380;
            }
            case 3: {
                return 17302384;
            }
            case 4: {
                return 17302385;
            }
            case 5: {
                return 17302381;
            }
            case 6: {
                return 17302379;
            }
            case 7: {
                return 17302382;
            }
        }
        return 17302383;
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onUpdateExtractingVisibility(EditorInfo ei) {
        if (ei.inputType == 0 || (ei.imeOptions & 0x10000000) != 0) {
            this.setExtractViewShown(false);
            return;
        }
        this.setExtractViewShown(true);
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onUpdateExtractingViews(EditorInfo ei) {
        boolean hasAction;
        if (!this.isExtractViewShown()) {
            return;
        }
        if (this.mExtractAccessories == null) {
            return;
        }
        boolean bl = hasAction = ei.actionLabel != null || (ei.imeOptions & 0xFF) != 1 && (ei.imeOptions & 0x20000000) == 0 && ei.inputType != 0;
        if (hasAction) {
            this.mExtractAccessories.setVisibility(0);
            if (this.mExtractAction != null) {
                if (this.mExtractAction instanceof ImageButton) {
                    ((ImageButton)this.mExtractAction).setImageResource(this.getIconForImeAction(ei.imeOptions));
                    if (ei.actionLabel != null) {
                        this.mExtractAction.setContentDescription(ei.actionLabel);
                    } else {
                        this.mExtractAction.setContentDescription(this.getTextForImeAction(ei.imeOptions));
                    }
                } else if (ei.actionLabel != null) {
                    ((TextView)this.mExtractAction).setText(ei.actionLabel);
                } else {
                    ((TextView)this.mExtractAction).setText(this.getTextForImeAction(ei.imeOptions));
                }
                this.mExtractAction.setOnClickListener(this.mActionClickListener);
            }
        } else {
            this.mExtractAccessories.setVisibility(8);
            if (this.mExtractAction != null) {
                this.mExtractAction.setOnClickListener(null);
            }
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onExtractingInputChanged(EditorInfo ei) {
        if (ei.inputType == 0) {
            this.requestHideSelf(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_inputmethodservice_InputMethodService$startExtractingText(boolean inputChanged) {
        ExtractEditText eet = this.mExtractEditText;
        if (eet != null && this.getCurrentInputStarted() && this.isFullscreenMode()) {
            ++this.mExtractedToken;
            ExtractedTextRequest req = new ExtractedTextRequest();
            req.token = this.mExtractedToken;
            req.flags = 1;
            req.hintMaxLines = 10;
            req.hintMaxChars = 10000;
            InputConnection ic = this.getCurrentInputConnection();
            ExtractedText extractedText = this.mExtractedText = ic == null ? null : ic.getExtractedText(req, 1);
            if (this.mExtractedText == null || ic == null) {
                Log.e("InputMethodService", "Unexpected null in startExtractingText : mExtractedText = " + this.mExtractedText + ", input connection = " + ic);
            }
            EditorInfo ei = this.getCurrentInputEditorInfo();
            try {
                eet.startInternalChanges();
                this.onUpdateExtractingVisibility(ei);
                this.onUpdateExtractingViews(ei);
                int inputType = ei.inputType;
                if ((inputType & 0xF) == 1 && (inputType & 0x40000) != 0) {
                    inputType |= 0x20000;
                }
                eet.setInputType(inputType);
                eet.setHint(ei.hintText);
                if (this.mExtractedText != null) {
                    eet.setEnabled(true);
                    eet.setExtractedText(this.mExtractedText);
                } else {
                    eet.setEnabled(false);
                    eet.setText("");
                }
            }
            finally {
                eet.finishInternalChanges();
            }
            if (inputChanged) {
                this.onExtractingInputChanged(ei);
            }
        }
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$onCurrentInputMethodSubtypeChanged(InputMethodSubtype newSubtype) {
    }

    private final int $$robo$$android_inputmethodservice_InputMethodService$getInputMethodWindowRecommendedHeight() {
        return this.mImm.getInputMethodWindowVisibleHeight();
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$exposeContent(InputContentInfo inputContentInfo, InputConnection inputConnection) {
        if (inputConnection == null) {
            return;
        }
        if (this.getCurrentInputConnection() != inputConnection) {
            return;
        }
        this.mImm.exposeContent(this.mToken, inputContentInfo, this.getCurrentInputEditorInfo());
    }

    private final void $$robo$$android_inputmethodservice_InputMethodService$dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        PrintWriterPrinter p = new PrintWriterPrinter(fout);
        p.println("Input method service state for " + this + ":");
        p.println("  mWindowCreated=" + this.mWindowCreated + " mWindowAdded=" + this.mWindowAdded);
        p.println("  mWindowVisible=" + this.mWindowVisible + " mWindowWasVisible=" + this.mWindowWasVisible + " mInShowWindow=" + this.mInShowWindow);
        p.println("  Configuration=" + this.getResources().getConfiguration());
        p.println("  mToken=" + this.mToken);
        p.println("  mInputBinding=" + this.mInputBinding);
        p.println("  mInputConnection=" + this.mInputConnection);
        p.println("  mStartedInputConnection=" + this.mStartedInputConnection);
        p.println("  mInputStarted=" + this.mInputStarted + " mInputViewStarted=" + this.mInputViewStarted + " mCandidatesViewStarted=" + this.mCandidatesViewStarted);
        p.println("  mStartInputToken=" + this.mStartInputToken);
        if (this.mInputEditorInfo != null) {
            p.println("  mInputEditorInfo:");
            this.mInputEditorInfo.dump(p, "    ");
        } else {
            p.println("  mInputEditorInfo: null");
        }
        p.println("  mShowInputRequested=" + this.mShowInputRequested + " mLastShowInputRequested=" + this.mLastShowInputRequested + " mShowInputFlags=0x" + Integer.toHexString(this.mShowInputFlags));
        p.println("  mCandidatesVisibility=" + this.mCandidatesVisibility + " mFullscreenApplied=" + this.mFullscreenApplied + " mIsFullscreen=" + this.mIsFullscreen + " mExtractViewHidden=" + this.mExtractViewHidden);
        if (this.mExtractedText != null) {
            p.println("  mExtractedText:");
            p.println("    text=" + this.mExtractedText.text.length() + " chars startOffset=" + this.mExtractedText.startOffset);
            p.println("    selectionStart=" + this.mExtractedText.selectionStart + " selectionEnd=" + this.mExtractedText.selectionEnd + " flags=0x" + Integer.toHexString(this.mExtractedText.flags));
        } else {
            p.println("  mExtractedText: null");
        }
        p.println("  mExtractedToken=" + this.mExtractedToken);
        p.println("  mIsInputViewShown=" + this.mIsInputViewShown + " mStatusIcon=" + this.mStatusIcon);
        p.println("Last computed insets:");
        p.println("  contentTopInsets=" + this.mTmpInsets.contentTopInsets + " visibleTopInsets=" + this.mTmpInsets.visibleTopInsets + " touchableInsets=" + this.mTmpInsets.touchableInsets + " touchableRegion=" + this.mTmpInsets.touchableRegion);
        p.println(" mShouldClearInsetOfPreviousIme=" + this.mShouldClearInsetOfPreviousIme);
        p.println(" mSettingsObserver=" + this.mSettingsObserver);
    }

    private void __constructor__() {
        this.$$robo$$android_inputmethodservice_InputMethodService$__constructor__();
    }

    public InputMethodService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_InputMethodService$__constructor__(), this);
    }

    @Override
    public void setTheme(int n) {
        InvokeDynamicSupport.bootstrap("setTheme", $$robo$$android_inputmethodservice_InputMethodService$setTheme(int ), this, n);
    }

    @Deprecated
    public boolean enableHardwareAcceleration() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableHardwareAcceleration", $$robo$$android_inputmethodservice_InputMethodService$enableHardwareAcceleration(), this);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_inputmethodservice_InputMethodService$onCreate(), this);
    }

    public void onInitializeInterface() {
        InvokeDynamicSupport.bootstrap("onInitializeInterface", $$robo$$android_inputmethodservice_InputMethodService$onInitializeInterface(), this);
    }

    void initialize() {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_inputmethodservice_InputMethodService$initialize(), this);
    }

    void initViews() {
        InvokeDynamicSupport.bootstrap("initViews", $$robo$$android_inputmethodservice_InputMethodService$initViews(), this);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_inputmethodservice_InputMethodService$onDestroy(), this);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_inputmethodservice_InputMethodService$onConfigurationChanged(android.content.res.Configuration ), this, configuration);
    }

    private void resetStateForNewConfiguration() {
        InvokeDynamicSupport.bootstrap("resetStateForNewConfiguration", $$robo$$android_inputmethodservice_InputMethodService$resetStateForNewConfiguration(), this);
    }

    @Override
    public AbstractInputMethodService.AbstractInputMethodImpl onCreateInputMethodInterface() {
        return InvokeDynamicSupport.bootstrap("onCreateInputMethodInterface", $$robo$$android_inputmethodservice_InputMethodService$onCreateInputMethodInterface(), this);
    }

    @Override
    public AbstractInputMethodService.AbstractInputMethodSessionImpl onCreateInputMethodSessionInterface() {
        return InvokeDynamicSupport.bootstrap("onCreateInputMethodSessionInterface", $$robo$$android_inputmethodservice_InputMethodService$onCreateInputMethodSessionInterface(), this);
    }

    public LayoutInflater getLayoutInflater() {
        return InvokeDynamicSupport.bootstrap("getLayoutInflater", $$robo$$android_inputmethodservice_InputMethodService$getLayoutInflater(), this);
    }

    public Dialog getWindow() {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_inputmethodservice_InputMethodService$getWindow(), this);
    }

    public void setBackDisposition(int n) {
        InvokeDynamicSupport.bootstrap("setBackDisposition", $$robo$$android_inputmethodservice_InputMethodService$setBackDisposition(int ), this, n);
    }

    public int getBackDisposition() {
        return (int)InvokeDynamicSupport.bootstrap("getBackDisposition", $$robo$$android_inputmethodservice_InputMethodService$getBackDisposition(), this);
    }

    public int getMaxWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxWidth", $$robo$$android_inputmethodservice_InputMethodService$getMaxWidth(), this);
    }

    public InputBinding getCurrentInputBinding() {
        return InvokeDynamicSupport.bootstrap("getCurrentInputBinding", $$robo$$android_inputmethodservice_InputMethodService$getCurrentInputBinding(), this);
    }

    public InputConnection getCurrentInputConnection() {
        return InvokeDynamicSupport.bootstrap("getCurrentInputConnection", $$robo$$android_inputmethodservice_InputMethodService$getCurrentInputConnection(), this);
    }

    public boolean getCurrentInputStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCurrentInputStarted", $$robo$$android_inputmethodservice_InputMethodService$getCurrentInputStarted(), this);
    }

    public EditorInfo getCurrentInputEditorInfo() {
        return InvokeDynamicSupport.bootstrap("getCurrentInputEditorInfo", $$robo$$android_inputmethodservice_InputMethodService$getCurrentInputEditorInfo(), this);
    }

    public void updateFullscreenMode() {
        InvokeDynamicSupport.bootstrap("updateFullscreenMode", $$robo$$android_inputmethodservice_InputMethodService$updateFullscreenMode(), this);
    }

    public void onConfigureWindow(Window window, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("onConfigureWindow", $$robo$$android_inputmethodservice_InputMethodService$onConfigureWindow(android.view.Window boolean boolean ), this, window, bl, bl2);
    }

    public boolean isFullscreenMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFullscreenMode", $$robo$$android_inputmethodservice_InputMethodService$isFullscreenMode(), this);
    }

    public boolean onEvaluateFullscreenMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("onEvaluateFullscreenMode", $$robo$$android_inputmethodservice_InputMethodService$onEvaluateFullscreenMode(), this);
    }

    public void setExtractViewShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExtractViewShown", $$robo$$android_inputmethodservice_InputMethodService$setExtractViewShown(boolean ), this, bl);
    }

    public boolean isExtractViewShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExtractViewShown", $$robo$$android_inputmethodservice_InputMethodService$isExtractViewShown(), this);
    }

    void updateExtractFrameVisibility() {
        InvokeDynamicSupport.bootstrap("updateExtractFrameVisibility", $$robo$$android_inputmethodservice_InputMethodService$updateExtractFrameVisibility(), this);
    }

    public void onComputeInsets(Insets insets) {
        InvokeDynamicSupport.bootstrap("onComputeInsets", $$robo$$android_inputmethodservice_InputMethodService$onComputeInsets(android.inputmethodservice.InputMethodService$Insets ), this, insets);
    }

    public void updateInputViewShown() {
        InvokeDynamicSupport.bootstrap("updateInputViewShown", $$robo$$android_inputmethodservice_InputMethodService$updateInputViewShown(), this);
    }

    public boolean isShowInputRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowInputRequested", $$robo$$android_inputmethodservice_InputMethodService$isShowInputRequested(), this);
    }

    public boolean isInputViewShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputViewShown", $$robo$$android_inputmethodservice_InputMethodService$isInputViewShown(), this);
    }

    public boolean onEvaluateInputViewShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("onEvaluateInputViewShown", $$robo$$android_inputmethodservice_InputMethodService$onEvaluateInputViewShown(), this);
    }

    public void setCandidatesViewShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCandidatesViewShown", $$robo$$android_inputmethodservice_InputMethodService$setCandidatesViewShown(boolean ), this, bl);
    }

    void updateCandidatesVisibility(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateCandidatesVisibility", $$robo$$android_inputmethodservice_InputMethodService$updateCandidatesVisibility(boolean ), this, bl);
    }

    public int getCandidatesHiddenVisibility() {
        return (int)InvokeDynamicSupport.bootstrap("getCandidatesHiddenVisibility", $$robo$$android_inputmethodservice_InputMethodService$getCandidatesHiddenVisibility(), this);
    }

    public void showStatusIcon(int n) {
        InvokeDynamicSupport.bootstrap("showStatusIcon", $$robo$$android_inputmethodservice_InputMethodService$showStatusIcon(int ), this, n);
    }

    public void hideStatusIcon() {
        InvokeDynamicSupport.bootstrap("hideStatusIcon", $$robo$$android_inputmethodservice_InputMethodService$hideStatusIcon(), this);
    }

    public void switchInputMethod(String string2) {
        InvokeDynamicSupport.bootstrap("switchInputMethod", $$robo$$android_inputmethodservice_InputMethodService$switchInputMethod(java.lang.String ), this, string2);
    }

    public void setExtractView(View view) {
        InvokeDynamicSupport.bootstrap("setExtractView", $$robo$$android_inputmethodservice_InputMethodService$setExtractView(android.view.View ), this, view);
    }

    public void setCandidatesView(View view) {
        InvokeDynamicSupport.bootstrap("setCandidatesView", $$robo$$android_inputmethodservice_InputMethodService$setCandidatesView(android.view.View ), this, view);
    }

    public void setInputView(View view) {
        InvokeDynamicSupport.bootstrap("setInputView", $$robo$$android_inputmethodservice_InputMethodService$setInputView(android.view.View ), this, view);
    }

    public View onCreateExtractTextView() {
        return InvokeDynamicSupport.bootstrap("onCreateExtractTextView", $$robo$$android_inputmethodservice_InputMethodService$onCreateExtractTextView(), this);
    }

    public View onCreateCandidatesView() {
        return InvokeDynamicSupport.bootstrap("onCreateCandidatesView", $$robo$$android_inputmethodservice_InputMethodService$onCreateCandidatesView(), this);
    }

    public View onCreateInputView() {
        return InvokeDynamicSupport.bootstrap("onCreateInputView", $$robo$$android_inputmethodservice_InputMethodService$onCreateInputView(), this);
    }

    public void onStartInputView(EditorInfo editorInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("onStartInputView", $$robo$$android_inputmethodservice_InputMethodService$onStartInputView(android.view.inputmethod.EditorInfo boolean ), this, editorInfo, bl);
    }

    public void onFinishInputView(boolean bl) {
        InvokeDynamicSupport.bootstrap("onFinishInputView", $$robo$$android_inputmethodservice_InputMethodService$onFinishInputView(boolean ), this, bl);
    }

    public void onStartCandidatesView(EditorInfo editorInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("onStartCandidatesView", $$robo$$android_inputmethodservice_InputMethodService$onStartCandidatesView(android.view.inputmethod.EditorInfo boolean ), this, editorInfo, bl);
    }

    public void onFinishCandidatesView(boolean bl) {
        InvokeDynamicSupport.bootstrap("onFinishCandidatesView", $$robo$$android_inputmethodservice_InputMethodService$onFinishCandidatesView(boolean ), this, bl);
    }

    public boolean onShowInputRequested(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onShowInputRequested", $$robo$$android_inputmethodservice_InputMethodService$onShowInputRequested(int boolean ), this, n, bl);
    }

    private boolean dispatchOnShowInputRequested(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchOnShowInputRequested", $$robo$$android_inputmethodservice_InputMethodService$dispatchOnShowInputRequested(int boolean ), this, n, bl);
    }

    public void showWindow(boolean bl) {
        InvokeDynamicSupport.bootstrap("showWindow", $$robo$$android_inputmethodservice_InputMethodService$showWindow(boolean ), this, bl);
    }

    void showWindowInner(boolean bl) {
        InvokeDynamicSupport.bootstrap("showWindowInner", $$robo$$android_inputmethodservice_InputMethodService$showWindowInner(boolean ), this, bl);
    }

    private void finishViews() {
        InvokeDynamicSupport.bootstrap("finishViews", $$robo$$android_inputmethodservice_InputMethodService$finishViews(), this);
    }

    private void doHideWindow() {
        InvokeDynamicSupport.bootstrap("doHideWindow", $$robo$$android_inputmethodservice_InputMethodService$doHideWindow(), this);
    }

    public void hideWindow() {
        InvokeDynamicSupport.bootstrap("hideWindow", $$robo$$android_inputmethodservice_InputMethodService$hideWindow(), this);
    }

    public void onWindowShown() {
        InvokeDynamicSupport.bootstrap("onWindowShown", $$robo$$android_inputmethodservice_InputMethodService$onWindowShown(), this);
    }

    public void onWindowHidden() {
        InvokeDynamicSupport.bootstrap("onWindowHidden", $$robo$$android_inputmethodservice_InputMethodService$onWindowHidden(), this);
    }

    private void clearInsetOfPreviousIme() {
        InvokeDynamicSupport.bootstrap("clearInsetOfPreviousIme", $$robo$$android_inputmethodservice_InputMethodService$clearInsetOfPreviousIme(), this);
    }

    public void onBindInput() {
        InvokeDynamicSupport.bootstrap("onBindInput", $$robo$$android_inputmethodservice_InputMethodService$onBindInput(), this);
    }

    public void onUnbindInput() {
        InvokeDynamicSupport.bootstrap("onUnbindInput", $$robo$$android_inputmethodservice_InputMethodService$onUnbindInput(), this);
    }

    public void onStartInput(EditorInfo editorInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("onStartInput", $$robo$$android_inputmethodservice_InputMethodService$onStartInput(android.view.inputmethod.EditorInfo boolean ), this, editorInfo, bl);
    }

    void doFinishInput() {
        InvokeDynamicSupport.bootstrap("doFinishInput", $$robo$$android_inputmethodservice_InputMethodService$doFinishInput(), this);
    }

    void doStartInput(InputConnection inputConnection, EditorInfo editorInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("doStartInput", $$robo$$android_inputmethodservice_InputMethodService$doStartInput(android.view.inputmethod.InputConnection android.view.inputmethod.EditorInfo boolean ), this, inputConnection, editorInfo, bl);
    }

    public void onFinishInput() {
        InvokeDynamicSupport.bootstrap("onFinishInput", $$robo$$android_inputmethodservice_InputMethodService$onFinishInput(), this);
    }

    public void onDisplayCompletions(CompletionInfo[] completionInfoArray) {
        InvokeDynamicSupport.bootstrap("onDisplayCompletions", $$robo$$android_inputmethodservice_InputMethodService$onDisplayCompletions(android.view.inputmethod.CompletionInfo[] ), this, completionInfoArray);
    }

    public void onUpdateExtractedText(int n, ExtractedText extractedText) {
        InvokeDynamicSupport.bootstrap("onUpdateExtractedText", $$robo$$android_inputmethodservice_InputMethodService$onUpdateExtractedText(int android.view.inputmethod.ExtractedText ), this, n, extractedText);
    }

    public void onUpdateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("onUpdateSelection", $$robo$$android_inputmethodservice_InputMethodService$onUpdateSelection(int int int int int int ), this, n, n2, n3, n4, n5, n6);
    }

    public void onViewClicked(boolean bl) {
        InvokeDynamicSupport.bootstrap("onViewClicked", $$robo$$android_inputmethodservice_InputMethodService$onViewClicked(boolean ), this, bl);
    }

    @Deprecated
    public void onUpdateCursor(Rect rect) {
        InvokeDynamicSupport.bootstrap("onUpdateCursor", $$robo$$android_inputmethodservice_InputMethodService$onUpdateCursor(android.graphics.Rect ), this, rect);
    }

    public void onUpdateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
        InvokeDynamicSupport.bootstrap("onUpdateCursorAnchorInfo", $$robo$$android_inputmethodservice_InputMethodService$onUpdateCursorAnchorInfo(android.view.inputmethod.CursorAnchorInfo ), this, cursorAnchorInfo);
    }

    public void requestHideSelf(int n) {
        InvokeDynamicSupport.bootstrap("requestHideSelf", $$robo$$android_inputmethodservice_InputMethodService$requestHideSelf(int ), this, n);
    }

    private void requestShowSelf(int n) {
        InvokeDynamicSupport.bootstrap("requestShowSelf", $$robo$$android_inputmethodservice_InputMethodService$requestShowSelf(int ), this, n);
    }

    private boolean handleBack(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleBack", $$robo$$android_inputmethodservice_InputMethodService$handleBack(boolean ), this, bl);
    }

    private ExtractEditText getExtractEditTextIfVisible() {
        return InvokeDynamicSupport.bootstrap("getExtractEditTextIfVisible", $$robo$$android_inputmethodservice_InputMethodService$getExtractEditTextIfVisible(), this);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_inputmethodservice_InputMethodService$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyLongPress", $$robo$$android_inputmethodservice_InputMethodService$onKeyLongPress(int android.view.KeyEvent ), this, n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$android_inputmethodservice_InputMethodService$onKeyMultiple(int int android.view.KeyEvent ), this, n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_inputmethodservice_InputMethodService$onKeyUp(int android.view.KeyEvent ), this, n, keyEvent);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$android_inputmethodservice_InputMethodService$onTrackballEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_inputmethodservice_InputMethodService$onGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
    }

    public void onAppPrivateCommand(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onAppPrivateCommand", $$robo$$android_inputmethodservice_InputMethodService$onAppPrivateCommand(java.lang.String android.os.Bundle ), this, string2, bundle);
    }

    private void onToggleSoftInput(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onToggleSoftInput", $$robo$$android_inputmethodservice_InputMethodService$onToggleSoftInput(int int ), this, n, n2);
    }

    void reportExtractedMovement(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reportExtractedMovement", $$robo$$android_inputmethodservice_InputMethodService$reportExtractedMovement(int int ), this, n, n2);
    }

    boolean doMovementKey(int n, KeyEvent keyEvent, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("doMovementKey", $$robo$$android_inputmethodservice_InputMethodService$doMovementKey(int android.view.KeyEvent int ), this, n, keyEvent, n2);
    }

    public void sendDownUpKeyEvents(int n) {
        InvokeDynamicSupport.bootstrap("sendDownUpKeyEvents", $$robo$$android_inputmethodservice_InputMethodService$sendDownUpKeyEvents(int ), this, n);
    }

    public boolean sendDefaultEditorAction(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendDefaultEditorAction", $$robo$$android_inputmethodservice_InputMethodService$sendDefaultEditorAction(boolean ), this, bl);
    }

    public void sendKeyChar(char c) {
        InvokeDynamicSupport.bootstrap("sendKeyChar", $$robo$$android_inputmethodservice_InputMethodService$sendKeyChar(char ), this, c);
    }

    public void onExtractedSelectionChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onExtractedSelectionChanged", $$robo$$android_inputmethodservice_InputMethodService$onExtractedSelectionChanged(int int ), this, n, n2);
    }

    public void onExtractedDeleteText(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onExtractedDeleteText", $$robo$$android_inputmethodservice_InputMethodService$onExtractedDeleteText(int int ), this, n, n2);
    }

    public void onExtractedReplaceText(int n, int n2, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("onExtractedReplaceText", $$robo$$android_inputmethodservice_InputMethodService$onExtractedReplaceText(int int java.lang.CharSequence ), this, n, n2, charSequence);
    }

    public void onExtractedSetSpan(Object object, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onExtractedSetSpan", $$robo$$android_inputmethodservice_InputMethodService$onExtractedSetSpan(java.lang.Object int int int ), this, object, n, n2, n3);
    }

    public void onExtractedTextClicked() {
        InvokeDynamicSupport.bootstrap("onExtractedTextClicked", $$robo$$android_inputmethodservice_InputMethodService$onExtractedTextClicked(), this);
    }

    public void onExtractedCursorMovement(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onExtractedCursorMovement", $$robo$$android_inputmethodservice_InputMethodService$onExtractedCursorMovement(int int ), this, n, n2);
    }

    public boolean onExtractTextContextMenuItem(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onExtractTextContextMenuItem", $$robo$$android_inputmethodservice_InputMethodService$onExtractTextContextMenuItem(int ), this, n);
    }

    public CharSequence getTextForImeAction(int n) {
        return InvokeDynamicSupport.bootstrap("getTextForImeAction", $$robo$$android_inputmethodservice_InputMethodService$getTextForImeAction(int ), this, n);
    }

    private int getIconForImeAction(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIconForImeAction", $$robo$$android_inputmethodservice_InputMethodService$getIconForImeAction(int ), this, n);
    }

    public void onUpdateExtractingVisibility(EditorInfo editorInfo) {
        InvokeDynamicSupport.bootstrap("onUpdateExtractingVisibility", $$robo$$android_inputmethodservice_InputMethodService$onUpdateExtractingVisibility(android.view.inputmethod.EditorInfo ), this, editorInfo);
    }

    public void onUpdateExtractingViews(EditorInfo editorInfo) {
        InvokeDynamicSupport.bootstrap("onUpdateExtractingViews", $$robo$$android_inputmethodservice_InputMethodService$onUpdateExtractingViews(android.view.inputmethod.EditorInfo ), this, editorInfo);
    }

    public void onExtractingInputChanged(EditorInfo editorInfo) {
        InvokeDynamicSupport.bootstrap("onExtractingInputChanged", $$robo$$android_inputmethodservice_InputMethodService$onExtractingInputChanged(android.view.inputmethod.EditorInfo ), this, editorInfo);
    }

    void startExtractingText(boolean bl) {
        InvokeDynamicSupport.bootstrap("startExtractingText", $$robo$$android_inputmethodservice_InputMethodService$startExtractingText(boolean ), this, bl);
    }

    protected void onCurrentInputMethodSubtypeChanged(InputMethodSubtype inputMethodSubtype) {
        InvokeDynamicSupport.bootstrap("onCurrentInputMethodSubtypeChanged", $$robo$$android_inputmethodservice_InputMethodService$onCurrentInputMethodSubtypeChanged(android.view.inputmethod.InputMethodSubtype ), this, inputMethodSubtype);
    }

    public int getInputMethodWindowRecommendedHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getInputMethodWindowRecommendedHeight", $$robo$$android_inputmethodservice_InputMethodService$getInputMethodWindowRecommendedHeight(), this);
    }

    @Override
    public void exposeContent(InputContentInfo inputContentInfo, InputConnection inputConnection) {
        InvokeDynamicSupport.bootstrap("exposeContent", $$robo$$android_inputmethodservice_InputMethodService$exposeContent(android.view.inputmethod.InputContentInfo android.view.inputmethod.InputConnection ), this, inputContentInfo, inputConnection);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_inputmethodservice_InputMethodService$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SettingsObserver
    extends ContentObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mShowImeWithHardKeyboard;
        private InputMethodService mService;

        private void $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$__constructor__(InputMethodService service) {
            this.mShowImeWithHardKeyboard = 0;
            this.mService = service;
        }

        private static final SettingsObserver $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$createAndRegister(InputMethodService service) {
            SettingsObserver observer = new SettingsObserver(service);
            service.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("show_ime_with_hard_keyboard"), false, observer);
            return observer;
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$unregister() {
            this.mService.getContentResolver().unregisterContentObserver(this);
        }

        private final boolean $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$shouldShowImeWithHardKeyboard() {
            if (this.mShowImeWithHardKeyboard == 0) {
                this.mShowImeWithHardKeyboard = Settings.Secure.getInt(this.mService.getContentResolver(), "show_ime_with_hard_keyboard", 0) != 0 ? 2 : 1;
            }
            switch (this.mShowImeWithHardKeyboard) {
                case 2: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            Log.e("InputMethodService", "Unexpected mShowImeWithHardKeyboard=" + this.mShowImeWithHardKeyboard);
            return false;
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$onChange(boolean selfChange, Uri uri) {
            Uri showImeWithHardKeyboardUri = Settings.Secure.getUriFor("show_ime_with_hard_keyboard");
            if (showImeWithHardKeyboardUri.equals(uri)) {
                this.mShowImeWithHardKeyboard = Settings.Secure.getInt(this.mService.getContentResolver(), "show_ime_with_hard_keyboard", 0) != 0 ? 2 : 1;
                this.mService.resetStateForNewConfiguration();
            }
        }

        private final String $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$toString() {
            return "SettingsObserver{mShowImeWithHardKeyboard=" + this.mShowImeWithHardKeyboard + "}";
        }

        private void __constructor__(InputMethodService inputMethodService) {
            this.$$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$__constructor__(inputMethodService);
        }

        public SettingsObserver(InputMethodService inputMethodService) {
            super(new Handler(inputMethodService.getMainLooper()));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$__constructor__(android.inputmethodservice.InputMethodService ), this, inputMethodService);
        }

        public static SettingsObserver createAndRegister(InputMethodService inputMethodService) {
            return InvokeDynamicSupport.bootstrapStatic("createAndRegister", $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$createAndRegister(android.inputmethodservice.InputMethodService ), (InputMethodService)inputMethodService);
        }

        void unregister() {
            InvokeDynamicSupport.bootstrap("unregister", $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$unregister(), this);
        }

        private boolean shouldShowImeWithHardKeyboard() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldShowImeWithHardKeyboard", $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$shouldShowImeWithHardKeyboard(), this);
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$onChange(boolean android.net.Uri ), this, bl, uri);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_inputmethodservice_InputMethodService_SettingsObserver$toString(), this);
        }

        public /* synthetic */ SettingsObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L})
        private static @interface ShowImeWithHardKeyboardType {
            public static final int UNKNOWN = 0;
            public static final int FALSE = 1;
            public static final int TRUE = 2;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Insets
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int contentTopInsets;
        public int visibleTopInsets;
        public Region touchableRegion;
        public static int TOUCHABLE_INSETS_FRAME = 0;
        public static int TOUCHABLE_INSETS_CONTENT = 1;
        public static int TOUCHABLE_INSETS_VISIBLE = 2;
        public static int TOUCHABLE_INSETS_REGION = 3;
        public int touchableInsets;

        private void $$robo$$android_inputmethodservice_InputMethodService_Insets$__constructor__() {
            this.touchableRegion = new Region();
        }

        private void __constructor__() {
            this.$$robo$$android_inputmethodservice_InputMethodService_Insets$__constructor__();
        }

        public Insets() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_InputMethodService_Insets$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Insets)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class InputMethodSessionImpl
    extends AbstractInputMethodService.AbstractInputMethodSessionImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ InputMethodService this$0;

        private void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$__constructor__(InputMethodService this$0) {
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$finishInput() {
            if (!this.isEnabled()) {
                return;
            }
            this.this$0.doFinishInput();
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$displayCompletions(CompletionInfo[] completions) {
            if (!this.isEnabled()) {
                return;
            }
            this.this$0.mCurCompletions = completions;
            this.this$0.onDisplayCompletions(completions);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$updateExtractedText(int token, ExtractedText text) {
            if (!this.isEnabled()) {
                return;
            }
            this.this$0.onUpdateExtractedText(token, text);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
            if (!this.isEnabled()) {
                return;
            }
            this.this$0.onUpdateSelection(oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$viewClicked(boolean focusChanged) {
            if (!this.isEnabled()) {
                return;
            }
            this.this$0.onViewClicked(focusChanged);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$updateCursor(Rect newCursor) {
            if (!this.isEnabled()) {
                return;
            }
            this.this$0.onUpdateCursor(newCursor);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$appPrivateCommand(String action, Bundle data) {
            if (!this.isEnabled()) {
                return;
            }
            this.this$0.onAppPrivateCommand(action, data);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$toggleSoftInput(int showFlags, int hideFlags) {
            this.this$0.onToggleSoftInput(showFlags, hideFlags);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$updateCursorAnchorInfo(CursorAnchorInfo info) {
            if (!this.isEnabled()) {
                return;
            }
            this.this$0.onUpdateCursorAnchorInfo(info);
        }

        private void __constructor__(InputMethodService inputMethodService) {
            this.$$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$__constructor__(inputMethodService);
        }

        public InputMethodSessionImpl(InputMethodService inputMethodService) {
            this.this$0 = inputMethodService;
            super(inputMethodService);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$__constructor__(android.inputmethodservice.InputMethodService ), this, inputMethodService);
        }

        @Override
        public void finishInput() {
            InvokeDynamicSupport.bootstrap("finishInput", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$finishInput(), this);
        }

        @Override
        public void displayCompletions(CompletionInfo[] completionInfoArray) {
            InvokeDynamicSupport.bootstrap("displayCompletions", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$displayCompletions(android.view.inputmethod.CompletionInfo[] ), this, completionInfoArray);
        }

        @Override
        public void updateExtractedText(int n, ExtractedText extractedText) {
            InvokeDynamicSupport.bootstrap("updateExtractedText", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$updateExtractedText(int android.view.inputmethod.ExtractedText ), this, n, extractedText);
        }

        @Override
        public void updateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
            InvokeDynamicSupport.bootstrap("updateSelection", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$updateSelection(int int int int int int ), this, n, n2, n3, n4, n5, n6);
        }

        @Override
        public void viewClicked(boolean bl) {
            InvokeDynamicSupport.bootstrap("viewClicked", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$viewClicked(boolean ), this, bl);
        }

        @Override
        public void updateCursor(Rect rect) {
            InvokeDynamicSupport.bootstrap("updateCursor", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$updateCursor(android.graphics.Rect ), this, rect);
        }

        @Override
        public void appPrivateCommand(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("appPrivateCommand", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$appPrivateCommand(java.lang.String android.os.Bundle ), this, string2, bundle);
        }

        @Override
        public void toggleSoftInput(int n, int n2) {
            InvokeDynamicSupport.bootstrap("toggleSoftInput", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$toggleSoftInput(int int ), this, n, n2);
        }

        @Override
        public void updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
            InvokeDynamicSupport.bootstrap("updateCursorAnchorInfo", $$robo$$android_inputmethodservice_InputMethodService_InputMethodSessionImpl$updateCursorAnchorInfo(android.view.inputmethod.CursorAnchorInfo ), this, cursorAnchorInfo);
        }

        public /* synthetic */ InputMethodSessionImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodSessionImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class InputMethodImpl
    extends AbstractInputMethodService.AbstractInputMethodImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ InputMethodService this$0;

        private void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$__constructor__(InputMethodService this$0) {
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$attachToken(IBinder token) {
            if (this.this$0.mToken == null) {
                this.this$0.mToken = token;
                this.this$0.mWindow.setToken(token);
            }
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$bindInput(InputBinding binding) {
            this.this$0.mInputBinding = binding;
            this.this$0.mInputConnection = binding.getConnection();
            if (this.this$0.mImm != null && this.this$0.mToken != null) {
                this.this$0.mImm.reportFullscreenMode(this.this$0.mToken, this.this$0.mIsFullscreen);
            }
            this.this$0.initialize();
            this.this$0.onBindInput();
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$unbindInput() {
            this.this$0.onUnbindInput();
            this.this$0.mInputBinding = null;
            this.this$0.mInputConnection = null;
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$startInput(InputConnection ic, EditorInfo attribute) {
            this.this$0.doStartInput(ic, attribute, false);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$restartInput(InputConnection ic, EditorInfo attribute) {
            this.this$0.doStartInput(ic, attribute, true);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$dispatchStartInputWithToken(InputConnection inputConnection, EditorInfo editorInfo, boolean restarting, IBinder startInputToken) {
            this.this$0.mStartInputToken = startInputToken;
            super.dispatchStartInputWithToken(inputConnection, editorInfo, restarting, startInputToken);
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$hideSoftInput(int flags, ResultReceiver resultReceiver) {
            boolean wasVis = this.this$0.isInputViewShown();
            this.this$0.mShowInputFlags = 0;
            this.this$0.mShowInputRequested = false;
            this.this$0.doHideWindow();
            this.this$0.clearInsetOfPreviousIme();
            if (resultReceiver != null) {
                resultReceiver.send(wasVis != this.this$0.isInputViewShown() ? 3 : (wasVis ? 0 : 1), null);
            }
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$showSoftInput(int flags, ResultReceiver resultReceiver) {
            boolean wasVis = this.this$0.isInputViewShown();
            if (this.this$0.dispatchOnShowInputRequested(flags, false)) {
                try {
                    this.this$0.showWindow(true);
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    // empty catch block
                }
            }
            this.this$0.clearInsetOfPreviousIme();
            boolean showing = this.this$0.isInputViewShown();
            this.this$0.mImm.setImeWindowStatus(this.this$0.mToken, this.this$0.mStartInputToken, 1 | (showing ? 2 : 0), this.this$0.mBackDisposition);
            if (resultReceiver != null) {
                resultReceiver.send(wasVis != this.this$0.isInputViewShown() ? 2 : (wasVis ? 0 : 1), null);
            }
        }

        private final void $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$changeInputMethodSubtype(InputMethodSubtype subtype) {
            this.this$0.onCurrentInputMethodSubtypeChanged(subtype);
        }

        private void __constructor__(InputMethodService inputMethodService) {
            this.$$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$__constructor__(inputMethodService);
        }

        public InputMethodImpl(InputMethodService inputMethodService) {
            this.this$0 = inputMethodService;
            super(inputMethodService);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$__constructor__(android.inputmethodservice.InputMethodService ), this, inputMethodService);
        }

        @Override
        public void attachToken(IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("attachToken", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$attachToken(android.os.IBinder ), this, iBinder);
        }

        @Override
        public void bindInput(InputBinding inputBinding) {
            InvokeDynamicSupport.bootstrap("bindInput", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$bindInput(android.view.inputmethod.InputBinding ), this, inputBinding);
        }

        @Override
        public void unbindInput() {
            InvokeDynamicSupport.bootstrap("unbindInput", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$unbindInput(), this);
        }

        @Override
        public void startInput(InputConnection inputConnection, EditorInfo editorInfo) {
            InvokeDynamicSupport.bootstrap("startInput", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$startInput(android.view.inputmethod.InputConnection android.view.inputmethod.EditorInfo ), this, inputConnection, editorInfo);
        }

        @Override
        public void restartInput(InputConnection inputConnection, EditorInfo editorInfo) {
            InvokeDynamicSupport.bootstrap("restartInput", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$restartInput(android.view.inputmethod.InputConnection android.view.inputmethod.EditorInfo ), this, inputConnection, editorInfo);
        }

        @Override
        public void dispatchStartInputWithToken(InputConnection inputConnection, EditorInfo editorInfo, boolean bl, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("dispatchStartInputWithToken", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$dispatchStartInputWithToken(android.view.inputmethod.InputConnection android.view.inputmethod.EditorInfo boolean android.os.IBinder ), this, inputConnection, editorInfo, bl, iBinder);
        }

        @Override
        public void hideSoftInput(int n, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("hideSoftInput", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$hideSoftInput(int android.os.ResultReceiver ), this, n, resultReceiver);
        }

        @Override
        public void showSoftInput(int n, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("showSoftInput", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$showSoftInput(int android.os.ResultReceiver ), this, n, resultReceiver);
        }

        @Override
        public void changeInputMethodSubtype(InputMethodSubtype inputMethodSubtype) {
            InvokeDynamicSupport.bootstrap("changeInputMethodSubtype", $$robo$$android_inputmethodservice_InputMethodService_InputMethodImpl$changeInputMethodSubtype(android.view.inputmethod.InputMethodSubtype ), this, inputMethodSubtype);
        }

        public /* synthetic */ InputMethodImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

