/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.util.Calendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GregorianCalendar
extends Calendar
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 9199388694351062137L;
    public static int BC = 0;
    public static int AD = 1;
    private static int EPOCH_YEAR = 1970;
    private static int[][] MONTH_COUNT;
    private static int[][] LIMITS;
    private long gregorianCutover;
    private transient int cutoverJulianDay;
    private transient int gregorianCutoverYear;
    protected transient boolean isGregorian;
    protected transient boolean invertGregorian;

    private final int $$robo$$android_icu_util_GregorianCalendar$handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__() {
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__(TimeZone zone) {
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__(Locale aLocale) {
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__(ULocale locale) {
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__(TimeZone zone, Locale aLocale) {
        this.gregorianCutover = -12219292800000L;
        this.cutoverJulianDay = 2299161;
        this.gregorianCutoverYear = 1582;
        this.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__(TimeZone zone, ULocale locale) {
        this.gregorianCutover = -12219292800000L;
        this.cutoverJulianDay = 2299161;
        this.gregorianCutoverYear = 1582;
        this.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__(int year, int month, int date) {
        this.gregorianCutover = -12219292800000L;
        this.cutoverJulianDay = 2299161;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__(int year, int month, int date, int hour, int minute) {
        this.gregorianCutover = -12219292800000L;
        this.cutoverJulianDay = 2299161;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
    }

    private void $$robo$$android_icu_util_GregorianCalendar$__constructor__(int year, int month, int date, int hour, int minute, int second) {
        this.gregorianCutover = -12219292800000L;
        this.cutoverJulianDay = 2299161;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    private final void $$robo$$android_icu_util_GregorianCalendar$setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
        if (this.gregorianCutover <= -184303902528000000L) {
            this.cutoverJulianDay = Integer.MIN_VALUE;
            this.gregorianCutoverYear = Integer.MIN_VALUE;
        } else if (this.gregorianCutover >= 183882168921600000L) {
            this.cutoverJulianDay = Integer.MAX_VALUE;
            this.gregorianCutoverYear = Integer.MAX_VALUE;
        } else {
            this.cutoverJulianDay = (int)GregorianCalendar.floorDivide(this.gregorianCutover, 86400000L);
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTime(date);
            this.gregorianCutoverYear = cal.get(19);
        }
    }

    private final Date $$robo$$android_icu_util_GregorianCalendar$getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    private final boolean $$robo$$android_icu_util_GregorianCalendar$isLeapYear(int year) {
        return year >= this.gregorianCutoverYear ? year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) : year % 4 == 0;
    }

    private final boolean $$robo$$android_icu_util_GregorianCalendar$isEquivalentTo(Calendar other) {
        return super.isEquivalentTo(other) && this.gregorianCutover == ((GregorianCalendar)other).gregorianCutover;
    }

    private final int $$robo$$android_icu_util_GregorianCalendar$hashCode() {
        return super.hashCode() ^ (int)this.gregorianCutover;
    }

    private final void $$robo$$android_icu_util_GregorianCalendar$roll(int field, int amount) {
        switch (field) {
            case 3: {
                int woy = this.get(3);
                int isoYear = this.get(17);
                int isoDoy = this.internalGet(6);
                if (this.internalGet(2) == 0) {
                    if (woy >= 52) {
                        isoDoy += this.handleGetYearLength(isoYear);
                    }
                } else if (woy == 1) {
                    isoDoy -= this.handleGetYearLength(isoYear - 1);
                }
                if ((woy += amount) < 1 || woy > 52) {
                    int lastDoy = this.handleGetYearLength(isoYear);
                    int lastRelDow = (lastDoy - isoDoy + this.internalGet(7) - this.getFirstDayOfWeek()) % 7;
                    if (lastRelDow < 0) {
                        lastRelDow += 7;
                    }
                    if (6 - lastRelDow >= this.getMinimalDaysInFirstWeek()) {
                        lastDoy -= 7;
                    }
                    int lastWoy = this.weekNumber(lastDoy, lastRelDow + 1);
                    woy = (woy + lastWoy - 1) % lastWoy + 1;
                }
                this.set(3, woy);
                this.set(1, isoYear);
                return;
            }
        }
        super.roll(field, amount);
    }

    private final int $$robo$$android_icu_util_GregorianCalendar$getActualMinimum(int field) {
        return this.getMinimum(field);
    }

    private final int $$robo$$android_icu_util_GregorianCalendar$getActualMaximum(int field) {
        switch (field) {
            case 1: {
                Calendar cal = (Calendar)this.clone();
                cal.setLenient(true);
                int era = cal.get(0);
                Date d = cal.getTime();
                int lowGood = LIMITS[1][1];
                int highBad = LIMITS[1][2] + 1;
                while (lowGood + 1 < highBad) {
                    int y = (lowGood + highBad) / 2;
                    cal.set(1, y);
                    if (cal.get(1) == y && cal.get(0) == era) {
                        lowGood = y;
                        continue;
                    }
                    highBad = y;
                    cal.setTime(d);
                }
                return lowGood;
            }
        }
        return super.getActualMaximum(field);
    }

    private final boolean $$robo$$android_icu_util_GregorianCalendar$inDaylightTime() {
        if (!this.getTimeZone().useDaylightTime()) {
            return false;
        }
        this.complete();
        return this.internalGet(16) != 0;
    }

    private final int $$robo$$android_icu_util_GregorianCalendar$handleGetMonthLength(int extendedYear, int month) {
        if (month < 0 || month > 11) {
            int[] rem = new int[1];
            extendedYear += GregorianCalendar.floorDivide(month, 12, rem);
            month = rem[0];
        }
        return MONTH_COUNT[month][this.isLeapYear(extendedYear) ? 1 : 0];
    }

    private final int $$robo$$android_icu_util_GregorianCalendar$handleGetYearLength(int eyear) {
        return this.isLeapYear(eyear) ? 366 : 365;
    }

    private final void $$robo$$android_icu_util_GregorianCalendar$handleComputeFields(int julianDay) {
        int eyear;
        int dayOfYear;
        int dayOfMonth;
        int month;
        if (julianDay >= this.cutoverJulianDay) {
            month = this.getGregorianMonth();
            dayOfMonth = this.getGregorianDayOfMonth();
            dayOfYear = this.getGregorianDayOfYear();
            eyear = this.getGregorianYear();
        } else {
            int march1;
            long julianEpochDay = julianDay - 1721424;
            eyear = (int)GregorianCalendar.floorDivide(4L * julianEpochDay + 1464L, 1461L);
            long january1 = 365L * ((long)eyear - 1L) + GregorianCalendar.floorDivide((long)eyear - 1L, 4L);
            dayOfYear = (int)(julianEpochDay - january1);
            boolean isLeap = (eyear & 3) == 0;
            int correction = 0;
            int n = march1 = isLeap ? 60 : 59;
            if (dayOfYear >= march1) {
                correction = isLeap ? 1 : 2;
            }
            month = (12 * (dayOfYear + correction) + 6) / 367;
            dayOfMonth = dayOfYear - MONTH_COUNT[month][isLeap ? 3 : 2] + 1;
            ++dayOfYear;
        }
        this.internalSet(2, month);
        this.internalSet(5, dayOfMonth);
        this.internalSet(6, dayOfYear);
        this.internalSet(19, eyear);
        int era = 1;
        if (eyear < 1) {
            era = 0;
            eyear = 1 - eyear;
        }
        this.internalSet(0, era);
        this.internalSet(1, eyear);
    }

    private final int $$robo$$android_icu_util_GregorianCalendar$handleGetExtendedYear() {
        int era;
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1970) : ((era = this.internalGet(0, 1)) == 0 ? 1 - this.internalGet(1, 1) : this.internalGet(1, 1970));
        return year;
    }

    private final int $$robo$$android_icu_util_GregorianCalendar$handleComputeJulianDay(int bestField) {
        this.invertGregorian = false;
        int jd = super.handleComputeJulianDay(bestField);
        if (this.isGregorian != jd >= this.cutoverJulianDay) {
            this.invertGregorian = true;
            jd = super.handleComputeJulianDay(bestField);
        }
        return jd;
    }

    private final int $$robo$$android_icu_util_GregorianCalendar$handleComputeMonthStart(int eyear, int month, boolean useMonth) {
        if (month < 0 || month > 11) {
            int[] rem = new int[1];
            eyear += GregorianCalendar.floorDivide(month, 12, rem);
            month = rem[0];
        }
        boolean isLeap = eyear % 4 == 0;
        int y = eyear - 1;
        int julianDay = 365 * y + GregorianCalendar.floorDivide(y, 4) + 1721423;
        boolean bl = this.isGregorian = eyear >= this.gregorianCutoverYear;
        if (this.invertGregorian) {
            boolean bl2 = this.isGregorian = !this.isGregorian;
        }
        if (this.isGregorian) {
            isLeap = isLeap && (eyear % 100 != 0 || eyear % 400 == 0);
            julianDay += GregorianCalendar.floorDivide(y, 400) - GregorianCalendar.floorDivide(y, 100) + 2;
        }
        if (month != 0) {
            julianDay += MONTH_COUNT[month][isLeap ? 3 : 2];
        }
        return julianDay;
    }

    private final String $$robo$$android_icu_util_GregorianCalendar$getType() {
        return "gregorian";
    }

    static void __staticInitializer__() {
        MONTH_COUNT = new int[][]{{31, 31, 0, 0}, {28, 29, 31, 31}, {31, 31, 59, 60}, {30, 30, 90, 91}, {31, 31, 120, 121}, {30, 30, 151, 152}, {31, 31, 181, 182}, {31, 31, 212, 213}, {30, 30, 243, 244}, {31, 31, 273, 274}, {30, 30, 304, 305}, {31, 31, 334, 335}};
        LIMITS = new int[][]{{0, 0, 1, 1}, {1, 1, 5828963, 5838270}, {0, 0, 11, 11}, {1, 1, 52, 53}, new int[0], {1, 1, 28, 31}, {1, 1, 365, 366}, new int[0], {-1, -1, 4, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5838270, -5838270, 5828964, 5838271}, new int[0], {-5838269, -5838269, 5828963, 5838270}, new int[0], new int[0], new int[0]};
    }

    @Override
    protected int handleGetLimit(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetLimit", $$robo$$android_icu_util_GregorianCalendar$handleGetLimit(int int ), this, n, n2);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__();
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(), this);
    }

    private void __constructor__(TimeZone timeZone) {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__(timeZone);
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(android.icu.util.TimeZone ), this, timeZone);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__(locale);
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(java.util.Locale ), this, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__(uLocale);
    }

    public GregorianCalendar(ULocale uLocale) {
        this(TimeZone.getDefault(), uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(android.icu.util.ULocale ), this, uLocale);
    }

    private void __constructor__(TimeZone timeZone, Locale locale) {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__(timeZone, locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(android.icu.util.TimeZone java.util.Locale ), this, timeZone, locale);
    }

    private void __constructor__(TimeZone timeZone, ULocale uLocale) {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__(timeZone, uLocale);
    }

    public GregorianCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(android.icu.util.TimeZone android.icu.util.ULocale ), this, timeZone, uLocale);
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__(n, n2, n3);
    }

    public GregorianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(int int int ), this, n, n2, n3);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5) {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__(n, n2, n3, n4, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(int int int int int ), this, n, n2, n3, n4, n5);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$$android_icu_util_GregorianCalendar$__constructor__(n, n2, n3, n4, n5, n6);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_GregorianCalendar$__constructor__(int int int int int int ), this, n, n2, n3, n4, n5, n6);
    }

    public void setGregorianChange(Date date) {
        InvokeDynamicSupport.bootstrap("setGregorianChange", $$robo$$android_icu_util_GregorianCalendar$setGregorianChange(java.util.Date ), this, date);
    }

    public Date getGregorianChange() {
        return InvokeDynamicSupport.bootstrap("getGregorianChange", $$robo$$android_icu_util_GregorianCalendar$getGregorianChange(), this);
    }

    public boolean isLeapYear(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLeapYear", $$robo$$android_icu_util_GregorianCalendar$isLeapYear(int ), this, n);
    }

    @Override
    public boolean isEquivalentTo(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEquivalentTo", $$robo$$android_icu_util_GregorianCalendar$isEquivalentTo(android.icu.util.Calendar ), this, calendar);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_GregorianCalendar$hashCode(), this);
    }

    @Override
    public void roll(int n, int n2) {
        InvokeDynamicSupport.bootstrap("roll", $$robo$$android_icu_util_GregorianCalendar$roll(int int ), this, n, n2);
    }

    @Override
    public int getActualMinimum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getActualMinimum", $$robo$$android_icu_util_GregorianCalendar$getActualMinimum(int ), this, n);
    }

    @Override
    public int getActualMaximum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getActualMaximum", $$robo$$android_icu_util_GregorianCalendar$getActualMaximum(int ), this, n);
    }

    boolean inDaylightTime() {
        return (boolean)InvokeDynamicSupport.bootstrap("inDaylightTime", $$robo$$android_icu_util_GregorianCalendar$inDaylightTime(), this);
    }

    @Override
    protected int handleGetMonthLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetMonthLength", $$robo$$android_icu_util_GregorianCalendar$handleGetMonthLength(int int ), this, n, n2);
    }

    @Override
    protected int handleGetYearLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetYearLength", $$robo$$android_icu_util_GregorianCalendar$handleGetYearLength(int ), this, n);
    }

    @Override
    protected void handleComputeFields(int n) {
        InvokeDynamicSupport.bootstrap("handleComputeFields", $$robo$$android_icu_util_GregorianCalendar$handleComputeFields(int ), this, n);
    }

    @Override
    protected int handleGetExtendedYear() {
        return (int)InvokeDynamicSupport.bootstrap("handleGetExtendedYear", $$robo$$android_icu_util_GregorianCalendar$handleGetExtendedYear(), this);
    }

    @Override
    protected int handleComputeJulianDay(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handleComputeJulianDay", $$robo$$android_icu_util_GregorianCalendar$handleComputeJulianDay(int ), this, n);
    }

    @Override
    protected int handleComputeMonthStart(int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("handleComputeMonthStart", $$robo$$android_icu_util_GregorianCalendar$handleComputeMonthStart(int int boolean ), this, n, n2, bl);
    }

    @Override
    public String getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_util_GregorianCalendar$getType(), this);
    }

    static {
        RobolectricInternals.classInitializing(GregorianCalendar.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GregorianCalendar)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

