/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.text.UTF16;
import android.icu.util.BytesTrie;
import android.icu.util.ICUUncheckedIOException;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CharsTrie
implements Cloneable,
Iterable<Entry> {
    public /* synthetic */ Object __robo_data__;
    private static BytesTrie.Result[] valueResults_;
    static int kMaxBranchLinearSubNodeLength = 5;
    static int kMinLinearMatch = 48;
    static int kMaxLinearMatchLength = 16;
    static int kMinValueLead = 64;
    static int kNodeTypeMask = 63;
    static int kValueIsFinal = 32768;
    static int kMaxOneUnitValue = 16383;
    static int kMinTwoUnitValueLead = 16384;
    static int kThreeUnitValueLead = Short.MAX_VALUE;
    static int kMaxTwoUnitValue = 0x3FFEFFFF;
    static int kMaxOneUnitNodeValue = 255;
    static int kMinTwoUnitNodeValueLead = 16448;
    static int kThreeUnitNodeValueLead = 32704;
    static int kMaxTwoUnitNodeValue = 0xFDFFFF;
    static int kMaxOneUnitDelta = 64511;
    static int kMinTwoUnitDeltaLead = 64512;
    static int kThreeUnitDeltaLead = 65535;
    static int kMaxTwoUnitDelta = 0x3FEFFFF;
    private CharSequence chars_;
    private int root_;
    private int pos_;
    private int remainingMatchLength_;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_util_CharsTrie$__constructor__(CharSequence trieChars, int offset) {
        this.chars_ = trieChars;
        this.pos_ = this.root_ = offset;
        this.remainingMatchLength_ = -1;
    }

    private final Object $$robo$$android_icu_util_CharsTrie$clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private final CharsTrie $$robo$$android_icu_util_CharsTrie$reset() {
        this.pos_ = this.root_;
        this.remainingMatchLength_ = -1;
        return this;
    }

    private final CharsTrie $$robo$$android_icu_util_CharsTrie$saveState(State state) {
        state.chars = this.chars_;
        state.root = this.root_;
        state.pos = this.pos_;
        state.remainingMatchLength = this.remainingMatchLength_;
        return this;
    }

    private final CharsTrie $$robo$$android_icu_util_CharsTrie$resetToState(State state) {
        if (this.chars_ != state.chars || this.chars_ == null || this.root_ != state.root) {
            throw new IllegalArgumentException("incompatible trie state");
        }
        this.pos_ = state.pos;
        this.remainingMatchLength_ = state.remainingMatchLength;
        return this;
    }

    private final BytesTrie.Result $$robo$$android_icu_util_CharsTrie$current() {
        char node;
        int pos = this.pos_;
        if (pos < 0) {
            return BytesTrie.Result.NO_MATCH;
        }
        return this.remainingMatchLength_ < 0 && (node = this.chars_.charAt(pos)) >= '@' ? valueResults_[node >> 15] : BytesTrie.Result.NO_VALUE;
    }

    private final BytesTrie.Result $$robo$$android_icu_util_CharsTrie$first(int inUnit) {
        this.remainingMatchLength_ = -1;
        return this.nextImpl(this.root_, inUnit);
    }

    private final BytesTrie.Result $$robo$$android_icu_util_CharsTrie$firstForCodePoint(int cp) {
        return cp <= 65535 ? this.first(cp) : (this.first(UTF16.getLeadSurrogate(cp)).hasNext() ? this.next(UTF16.getTrailSurrogate(cp)) : BytesTrie.Result.NO_MATCH);
    }

    private final BytesTrie.Result $$robo$$android_icu_util_CharsTrie$next(int inUnit) {
        int pos = this.pos_;
        if (pos < 0) {
            return BytesTrie.Result.NO_MATCH;
        }
        int length = this.remainingMatchLength_;
        if (length >= 0) {
            if (inUnit == this.chars_.charAt(pos++)) {
                char node;
                this.remainingMatchLength_ = --length;
                this.pos_ = pos;
                return length < 0 && (node = this.chars_.charAt(pos)) >= '@' ? valueResults_[node >> 15] : BytesTrie.Result.NO_VALUE;
            }
            this.stop();
            return BytesTrie.Result.NO_MATCH;
        }
        return this.nextImpl(pos, inUnit);
    }

    private final BytesTrie.Result $$robo$$android_icu_util_CharsTrie$nextForCodePoint(int cp) {
        return cp <= 65535 ? this.next(cp) : (this.next(UTF16.getLeadSurrogate(cp)).hasNext() ? this.next(UTF16.getTrailSurrogate(cp)) : BytesTrie.Result.NO_MATCH);
    }

    private final BytesTrie.Result $$robo$$android_icu_util_CharsTrie$next(CharSequence s, int sIndex, int sLimit) {
        if (sIndex >= sLimit) {
            return this.current();
        }
        int pos = this.pos_;
        if (pos < 0) {
            return BytesTrie.Result.NO_MATCH;
        }
        int length = this.remainingMatchLength_;
        block0: while (true) {
            int node;
            if (sIndex == sLimit) {
                this.remainingMatchLength_ = length;
                this.pos_ = pos;
                return length < 0 && (node = this.chars_.charAt(pos)) >= 64 ? valueResults_[node >> 15] : BytesTrie.Result.NO_VALUE;
            }
            char inUnit = s.charAt(sIndex++);
            if (length >= 0) {
                if (inUnit != this.chars_.charAt(pos)) {
                    this.stop();
                    return BytesTrie.Result.NO_MATCH;
                }
                ++pos;
                --length;
                continue;
            }
            this.remainingMatchLength_ = length;
            node = this.chars_.charAt(pos++);
            while (true) {
                if (node < 48) {
                    BytesTrie.Result result = this.branchNext(pos, node, inUnit);
                    if (result == BytesTrie.Result.NO_MATCH) {
                        return BytesTrie.Result.NO_MATCH;
                    }
                    if (sIndex == sLimit) {
                        return result;
                    }
                    if (result == BytesTrie.Result.FINAL_VALUE) {
                        this.stop();
                        return BytesTrie.Result.NO_MATCH;
                    }
                    inUnit = s.charAt(sIndex++);
                    pos = this.pos_;
                    node = this.chars_.charAt(pos++);
                    continue;
                }
                if (node < 64) {
                    length = node - 48;
                    if (inUnit != this.chars_.charAt(pos)) {
                        this.stop();
                        return BytesTrie.Result.NO_MATCH;
                    }
                    ++pos;
                    --length;
                    continue block0;
                }
                if ((node & 0x8000) != 0) {
                    this.stop();
                    return BytesTrie.Result.NO_MATCH;
                }
                pos = CharsTrie.skipNodeValue(pos, node);
                node &= 0x3F;
            }
            break;
        }
    }

    private final int $$robo$$android_icu_util_CharsTrie$getValue() {
        int pos = this.pos_;
        char leadUnit = this.chars_.charAt(pos++);
        if (!$assertionsDisabled && leadUnit < '@') {
            throw new AssertionError();
        }
        return (leadUnit & 0x8000) != 0 ? CharsTrie.readValue(this.chars_, pos, leadUnit & Short.MAX_VALUE) : CharsTrie.readNodeValue(this.chars_, pos, leadUnit);
    }

    private final long $$robo$$android_icu_util_CharsTrie$getUniqueValue() {
        int pos = this.pos_;
        if (pos < 0) {
            return 0L;
        }
        long uniqueValue = CharsTrie.findUniqueValue(this.chars_, pos + this.remainingMatchLength_ + 1, 0L);
        return uniqueValue << 31 >> 31;
    }

    private final int $$robo$$android_icu_util_CharsTrie$getNextChars(Appendable out) {
        int node;
        int pos = this.pos_;
        if (pos < 0) {
            return 0;
        }
        if (this.remainingMatchLength_ >= 0) {
            CharsTrie.append(out, this.chars_.charAt(pos));
            return 1;
        }
        if ((node = this.chars_.charAt(pos++)) >= 64) {
            if ((node & 0x8000) != 0) {
                return 0;
            }
            pos = CharsTrie.skipNodeValue(pos, node);
            node &= 0x3F;
        }
        if (node < 48) {
            if (node == 0) {
                node = this.chars_.charAt(pos++);
            }
            CharsTrie.getNextBranchChars(this.chars_, pos, ++node, out);
            return node;
        }
        CharsTrie.append(out, this.chars_.charAt(pos));
        return 1;
    }

    private final Iterator $$robo$$android_icu_util_CharsTrie$iterator() {
        return new Iterator(this.chars_, this.pos_, this.remainingMatchLength_, 0, null);
    }

    private final Iterator $$robo$$android_icu_util_CharsTrie$iterator(int maxStringLength) {
        return new Iterator(this.chars_, this.pos_, this.remainingMatchLength_, maxStringLength, null);
    }

    private static final Iterator $$robo$$android_icu_util_CharsTrie$iterator(CharSequence trieChars, int offset, int maxStringLength) {
        return new Iterator(trieChars, offset, -1, maxStringLength, null);
    }

    private final void $$robo$$android_icu_util_CharsTrie$stop() {
        this.pos_ = -1;
    }

    private static final int $$robo$$android_icu_util_CharsTrie$readValue(CharSequence chars, int pos, int leadUnit) {
        int value = leadUnit < 16384 ? leadUnit : (leadUnit < Short.MAX_VALUE ? leadUnit - 16384 << 16 | chars.charAt(pos) : chars.charAt(pos) << 16 | chars.charAt(pos + 1));
        return value;
    }

    private static final int $$robo$$android_icu_util_CharsTrie$skipValue(int pos, int leadUnit) {
        if (leadUnit >= 16384) {
            pos = leadUnit < Short.MAX_VALUE ? ++pos : (pos += 2);
        }
        return pos;
    }

    private static final int $$robo$$android_icu_util_CharsTrie$skipValue(CharSequence chars, int pos) {
        char leadUnit = chars.charAt(pos++);
        return CharsTrie.skipValue(pos, leadUnit & Short.MAX_VALUE);
    }

    private static final int $$robo$$android_icu_util_CharsTrie$readNodeValue(CharSequence chars, int pos, int leadUnit) {
        if (!($assertionsDisabled || 64 <= leadUnit && leadUnit < 32768)) {
            throw new AssertionError();
        }
        int value = leadUnit < 16448 ? (leadUnit >> 6) - 1 : (leadUnit < 32704 ? (leadUnit & 0x7FC0) - 16448 << 10 | chars.charAt(pos) : chars.charAt(pos) << 16 | chars.charAt(pos + 1));
        return value;
    }

    private static final int $$robo$$android_icu_util_CharsTrie$skipNodeValue(int pos, int leadUnit) {
        if (!($assertionsDisabled || 64 <= leadUnit && leadUnit < 32768)) {
            throw new AssertionError();
        }
        if (leadUnit >= 16448) {
            pos = leadUnit < 32704 ? ++pos : (pos += 2);
        }
        return pos;
    }

    private static final int $$robo$$android_icu_util_CharsTrie$jumpByDelta(CharSequence chars, int pos) {
        int delta;
        if ((delta = chars.charAt(pos++)) >= 64512) {
            if (delta == 65535) {
                delta = chars.charAt(pos) << 16 | chars.charAt(pos + 1);
                pos += 2;
            } else {
                delta = delta - 64512 << 16 | chars.charAt(pos++);
            }
        }
        return pos + delta;
    }

    private static final int $$robo$$android_icu_util_CharsTrie$skipDelta(CharSequence chars, int pos) {
        char delta;
        if ((delta = chars.charAt(pos++)) >= '\ufc00') {
            pos = delta == '\uffff' ? (pos += 2) : ++pos;
        }
        return pos;
    }

    private final BytesTrie.Result $$robo$$android_icu_util_CharsTrie$branchNext(int pos, int length, int inUnit) {
        if (length == 0) {
            length = this.chars_.charAt(pos++);
        }
        ++length;
        while (length > 5) {
            if (inUnit < this.chars_.charAt(pos++)) {
                length >>= 1;
                pos = CharsTrie.jumpByDelta(this.chars_, pos);
                continue;
            }
            length -= length >> 1;
            pos = CharsTrie.skipDelta(this.chars_, pos);
        }
        do {
            if (inUnit == this.chars_.charAt(pos++)) {
                BytesTrie.Result result;
                int node = this.chars_.charAt(pos);
                if ((node & 0x8000) != 0) {
                    result = BytesTrie.Result.FINAL_VALUE;
                } else {
                    int delta;
                    ++pos;
                    if (node < 16384) {
                        delta = node;
                    } else if (node < Short.MAX_VALUE) {
                        delta = node - 16384 << 16 | this.chars_.charAt(pos++);
                    } else {
                        delta = this.chars_.charAt(pos) << 16 | this.chars_.charAt(pos + 1);
                        pos += 2;
                    }
                    node = this.chars_.charAt(pos += delta);
                    result = node >= 64 ? valueResults_[node >> 15] : BytesTrie.Result.NO_VALUE;
                }
                this.pos_ = pos;
                return result;
            }
            pos = CharsTrie.skipValue(this.chars_, pos);
        } while (--length > 1);
        if (inUnit == this.chars_.charAt(pos++)) {
            this.pos_ = pos;
            char node = this.chars_.charAt(pos);
            return node >= '@' ? valueResults_[node >> 15] : BytesTrie.Result.NO_VALUE;
        }
        this.stop();
        return BytesTrie.Result.NO_MATCH;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final BytesTrie.Result $$robo$$android_icu_util_CharsTrie$nextImpl(int pos, int inUnit) {
        int node = this.chars_.charAt(pos++);
        while (true) {
            if (node < 48) {
                return this.branchNext(pos, node, inUnit);
            }
            if (node < 64) {
                BytesTrie.Result result;
                int length = node - 48;
                if (inUnit != this.chars_.charAt(pos++)) break;
                this.remainingMatchLength_ = --length;
                this.pos_ = pos;
                if (length < 0) {
                    char c = this.chars_.charAt(pos);
                    node = c;
                    if (c >= '@') {
                        result = valueResults_[node >> 15];
                        return result;
                    }
                }
                result = BytesTrie.Result.NO_VALUE;
                return result;
            }
            if ((node & 0x8000) != 0) break;
            pos = CharsTrie.skipNodeValue(pos, node);
            node &= 0x3F;
        }
        this.stop();
        return BytesTrie.Result.NO_MATCH;
    }

    private static final long $$robo$$android_icu_util_CharsTrie$findUniqueValueFromBranch(CharSequence chars, int pos, int length, long uniqueValue) {
        while (length > 5) {
            if ((uniqueValue = CharsTrie.findUniqueValueFromBranch(chars, CharsTrie.jumpByDelta(chars, ++pos), length >> 1, uniqueValue)) == 0L) {
                return 0L;
            }
            length -= length >> 1;
            pos = CharsTrie.skipDelta(chars, pos);
        }
        do {
            int n = ++pos;
            int node = chars.charAt(n);
            boolean isFinal = (node & 0x8000) != 0;
            int value = CharsTrie.readValue(chars, ++pos, node &= Short.MAX_VALUE);
            pos = CharsTrie.skipValue(pos, node);
            if (isFinal) {
                if (uniqueValue != 0L) {
                    if (value == (int)(uniqueValue >> 1)) continue;
                    return 0L;
                }
                uniqueValue = (long)value << 1 | 1L;
                continue;
            }
            if ((uniqueValue = CharsTrie.findUniqueValue(chars, pos + value, uniqueValue)) != 0L) continue;
            return 0L;
        } while (--length > 1);
        return (long)(pos + 1) << 33 | uniqueValue & 0x1FFFFFFFFL;
    }

    private static final long $$robo$$android_icu_util_CharsTrie$findUniqueValue(CharSequence chars, int pos, long uniqueValue) {
        int node = chars.charAt(pos++);
        while (true) {
            if (node < 48) {
                if (node == 0) {
                    node = chars.charAt(pos++);
                }
                if ((uniqueValue = CharsTrie.findUniqueValueFromBranch(chars, pos, node + '\u0001', uniqueValue)) == 0L) {
                    return 0L;
                }
                pos = (int)(uniqueValue >>> 33);
                node = chars.charAt(pos++);
                continue;
            }
            if (node < 64) {
                pos += node - 48 + 1;
                node = chars.charAt(pos++);
                continue;
            }
            boolean isFinal = (node & 0x8000) != 0;
            int value = isFinal ? CharsTrie.readValue(chars, pos, node & Short.MAX_VALUE) : CharsTrie.readNodeValue(chars, pos, node);
            if (uniqueValue != 0L) {
                if (value != (int)(uniqueValue >> 1)) {
                    return 0L;
                }
            } else {
                uniqueValue = (long)value << 1 | 1L;
            }
            if (isFinal) {
                return uniqueValue;
            }
            pos = CharsTrie.skipNodeValue(pos, node);
            node &= 0x3F;
        }
    }

    private static final void $$robo$$android_icu_util_CharsTrie$getNextBranchChars(CharSequence chars, int pos, int length, Appendable out) {
        while (length > 5) {
            CharsTrie.getNextBranchChars(chars, CharsTrie.jumpByDelta(chars, ++pos), length >> 1, out);
            length -= length >> 1;
            pos = CharsTrie.skipDelta(chars, pos);
        }
        do {
            CharsTrie.append(out, chars.charAt(pos++));
            pos = CharsTrie.skipValue(chars, pos);
        } while (--length > 1);
        CharsTrie.append(out, chars.charAt(pos));
    }

    private static final void $$robo$$android_icu_util_CharsTrie$append(Appendable out, int c) {
        try {
            out.append((char)c);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CharsTrie.class.desiredAssertionStatus();
        valueResults_ = new BytesTrie.Result[]{BytesTrie.Result.INTERMEDIATE_VALUE, BytesTrie.Result.FINAL_VALUE};
    }

    private void __constructor__(CharSequence charSequence, int n) {
        this.$$robo$$android_icu_util_CharsTrie$__constructor__(charSequence, n);
    }

    public CharsTrie(CharSequence charSequence, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_CharsTrie$__constructor__(java.lang.CharSequence int ), this, charSequence, n);
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_util_CharsTrie$clone(), this);
    }

    public CharsTrie reset() {
        return InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_util_CharsTrie$reset(), this);
    }

    public CharsTrie saveState(State state) {
        return InvokeDynamicSupport.bootstrap("saveState", $$robo$$android_icu_util_CharsTrie$saveState(android.icu.util.CharsTrie$State ), this, state);
    }

    public CharsTrie resetToState(State state) {
        return InvokeDynamicSupport.bootstrap("resetToState", $$robo$$android_icu_util_CharsTrie$resetToState(android.icu.util.CharsTrie$State ), this, state);
    }

    public BytesTrie.Result current() {
        return InvokeDynamicSupport.bootstrap("current", $$robo$$android_icu_util_CharsTrie$current(), this);
    }

    public BytesTrie.Result first(int n) {
        return InvokeDynamicSupport.bootstrap("first", $$robo$$android_icu_util_CharsTrie$first(int ), this, n);
    }

    public BytesTrie.Result firstForCodePoint(int n) {
        return InvokeDynamicSupport.bootstrap("firstForCodePoint", $$robo$$android_icu_util_CharsTrie$firstForCodePoint(int ), this, n);
    }

    public BytesTrie.Result next(int n) {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_util_CharsTrie$next(int ), this, n);
    }

    public BytesTrie.Result nextForCodePoint(int n) {
        return InvokeDynamicSupport.bootstrap("nextForCodePoint", $$robo$$android_icu_util_CharsTrie$nextForCodePoint(int ), this, n);
    }

    public BytesTrie.Result next(CharSequence charSequence, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_util_CharsTrie$next(java.lang.CharSequence int int ), this, charSequence, n, n2);
    }

    public int getValue() {
        return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_icu_util_CharsTrie$getValue(), this);
    }

    public long getUniqueValue() {
        return (long)InvokeDynamicSupport.bootstrap("getUniqueValue", $$robo$$android_icu_util_CharsTrie$getUniqueValue(), this);
    }

    public int getNextChars(Appendable appendable) {
        return (int)InvokeDynamicSupport.bootstrap("getNextChars", $$robo$$android_icu_util_CharsTrie$getNextChars(java.lang.Appendable ), this, appendable);
    }

    public Iterator iterator() {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_util_CharsTrie$iterator(), this);
    }

    public Iterator iterator(int n) {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_util_CharsTrie$iterator(int ), this, n);
    }

    public static Iterator iterator(CharSequence charSequence, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("iterator", $$robo$$android_icu_util_CharsTrie$iterator(java.lang.CharSequence int int ), (CharSequence)charSequence, (int)n, (int)n2);
    }

    private void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_icu_util_CharsTrie$stop(), this);
    }

    private static int readValue(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("readValue", $$robo$$android_icu_util_CharsTrie$readValue(java.lang.CharSequence int int ), (CharSequence)charSequence, (int)n, (int)n2);
    }

    private static int skipValue(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipValue", $$robo$$android_icu_util_CharsTrie$skipValue(int int ), (int)n, (int)n2);
    }

    private static int skipValue(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipValue", $$robo$$android_icu_util_CharsTrie$skipValue(java.lang.CharSequence int ), (CharSequence)charSequence, (int)n);
    }

    private static int readNodeValue(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("readNodeValue", $$robo$$android_icu_util_CharsTrie$readNodeValue(java.lang.CharSequence int int ), (CharSequence)charSequence, (int)n, (int)n2);
    }

    private static int skipNodeValue(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipNodeValue", $$robo$$android_icu_util_CharsTrie$skipNodeValue(int int ), (int)n, (int)n2);
    }

    private static int jumpByDelta(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("jumpByDelta", $$robo$$android_icu_util_CharsTrie$jumpByDelta(java.lang.CharSequence int ), (CharSequence)charSequence, (int)n);
    }

    private static int skipDelta(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipDelta", $$robo$$android_icu_util_CharsTrie$skipDelta(java.lang.CharSequence int ), (CharSequence)charSequence, (int)n);
    }

    private BytesTrie.Result branchNext(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("branchNext", $$robo$$android_icu_util_CharsTrie$branchNext(int int int ), this, n, n2, n3);
    }

    private BytesTrie.Result nextImpl(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("nextImpl", $$robo$$android_icu_util_CharsTrie$nextImpl(int int ), this, n, n2);
    }

    private static long findUniqueValueFromBranch(CharSequence charSequence, int n, int n2, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("findUniqueValueFromBranch", $$robo$$android_icu_util_CharsTrie$findUniqueValueFromBranch(java.lang.CharSequence int int long ), (CharSequence)charSequence, (int)n, (int)n2, (long)l);
    }

    private static long findUniqueValue(CharSequence charSequence, int n, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("findUniqueValue", $$robo$$android_icu_util_CharsTrie$findUniqueValue(java.lang.CharSequence int long ), (CharSequence)charSequence, (int)n, (long)l);
    }

    private static void getNextBranchChars(CharSequence charSequence, int n, int n2, Appendable appendable) {
        InvokeDynamicSupport.bootstrapStatic("getNextBranchChars", $$robo$$android_icu_util_CharsTrie$getNextBranchChars(java.lang.CharSequence int int java.lang.Appendable ), (CharSequence)charSequence, (int)n, (int)n2, (Appendable)appendable);
    }

    private static void append(Appendable appendable, int n) {
        InvokeDynamicSupport.bootstrapStatic("append", $$robo$$android_icu_util_CharsTrie$append(java.lang.Appendable int ), (Appendable)appendable, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(CharsTrie.class);
    }

    public /* synthetic */ CharsTrie() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsTrie)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Iterator
    implements java.util.Iterator<Entry> {
        public /* synthetic */ Object __robo_data__;
        private CharSequence chars_;
        private int pos_;
        private int initialPos_;
        private int remainingMatchLength_;
        private int initialRemainingMatchLength_;
        private boolean skipValue_;
        private StringBuilder str_;
        private int maxLength_;
        private Entry entry_;
        private ArrayList<Long> stack_;

        private void $$robo$$android_icu_util_CharsTrie_Iterator$__constructor__(CharSequence trieChars, int offset, int remainingMatchLength, int maxStringLength) {
            this.str_ = new StringBuilder();
            this.entry_ = new Entry(null);
            this.stack_ = new ArrayList();
            this.chars_ = trieChars;
            this.pos_ = this.initialPos_ = offset;
            this.remainingMatchLength_ = this.initialRemainingMatchLength_ = remainingMatchLength;
            this.maxLength_ = maxStringLength;
            int length = this.remainingMatchLength_;
            if (length >= 0) {
                if (this.maxLength_ > 0 && ++length > this.maxLength_) {
                    length = this.maxLength_;
                }
                this.str_.append(this.chars_, this.pos_, this.pos_ + length);
                this.pos_ += length;
                this.remainingMatchLength_ -= length;
            }
        }

        private final Iterator $$robo$$android_icu_util_CharsTrie_Iterator$reset() {
            this.pos_ = this.initialPos_;
            this.remainingMatchLength_ = this.initialRemainingMatchLength_;
            this.skipValue_ = false;
            int length = this.remainingMatchLength_ + 1;
            if (this.maxLength_ > 0 && length > this.maxLength_) {
                length = this.maxLength_;
            }
            this.str_.setLength(length);
            this.pos_ += length;
            this.remainingMatchLength_ -= length;
            this.stack_.clear();
            return this;
        }

        private final boolean $$robo$$android_icu_util_CharsTrie_Iterator$hasNext() {
            return this.pos_ >= 0 || !this.stack_.isEmpty();
        }

        private final Entry $$robo$$android_icu_util_CharsTrie_Iterator$next() {
            int pos = this.pos_;
            if (pos < 0) {
                if (this.stack_.isEmpty()) {
                    throw new NoSuchElementException();
                }
                long top = this.stack_.remove(this.stack_.size() - 1);
                int length = (int)top;
                pos = (int)(top >> 32);
                this.str_.setLength(length & 0xFFFF);
                if ((length >>>= 16) > 1) {
                    if ((pos = this.branchNext(pos, length)) < 0) {
                        return this.entry_;
                    }
                } else {
                    this.str_.append(this.chars_.charAt(pos++));
                }
            }
            if (this.remainingMatchLength_ >= 0) {
                return this.truncateAndStop();
            }
            while (true) {
                int node;
                if ((node = this.chars_.charAt(pos++)) >= 64) {
                    if (this.skipValue_) {
                        pos = CharsTrie.skipNodeValue(pos, node);
                        node &= 0x3F;
                        this.skipValue_ = false;
                    } else {
                        boolean isFinal = (node & 0x8000) != 0;
                        this.entry_.value = isFinal ? CharsTrie.readValue(this.chars_, pos, node & Short.MAX_VALUE) : CharsTrie.readNodeValue(this.chars_, pos, node);
                        if (isFinal || this.maxLength_ > 0 && this.str_.length() == this.maxLength_) {
                            this.pos_ = -1;
                        } else {
                            this.pos_ = pos - 1;
                            this.skipValue_ = true;
                        }
                        this.entry_.chars = this.str_;
                        return this.entry_;
                    }
                }
                if (this.maxLength_ > 0 && this.str_.length() == this.maxLength_) {
                    return this.truncateAndStop();
                }
                if (node < 48) {
                    if (node == 0) {
                        node = this.chars_.charAt(pos++);
                    }
                    if ((pos = this.branchNext(pos, node + 1)) >= 0) continue;
                    return this.entry_;
                }
                int length = node - 48 + 1;
                if (this.maxLength_ > 0 && this.str_.length() + length > this.maxLength_) {
                    this.str_.append(this.chars_, pos, pos + this.maxLength_ - this.str_.length());
                    return this.truncateAndStop();
                }
                this.str_.append(this.chars_, pos, pos + length);
                pos += length;
            }
        }

        private final void $$robo$$android_icu_util_CharsTrie_Iterator$remove() {
            throw new UnsupportedOperationException();
        }

        private final Entry $$robo$$android_icu_util_CharsTrie_Iterator$truncateAndStop() {
            this.pos_ = -1;
            this.entry_.chars = this.str_;
            this.entry_.value = -1;
            return this.entry_;
        }

        private final int $$robo$$android_icu_util_CharsTrie_Iterator$branchNext(int pos, int length) {
            int node;
            while (length > 5) {
                this.stack_.add((long)CharsTrie.skipDelta(this.chars_, ++pos) << 32 | (long)(length - (length >> 1) << 16) | (long)this.str_.length());
                length >>= 1;
                pos = CharsTrie.jumpByDelta(this.chars_, pos);
            }
            char trieUnit = this.chars_.charAt(pos++);
            boolean isFinal = ((node = this.chars_.charAt(pos++)) & 0x8000) != 0;
            int value = CharsTrie.readValue(this.chars_, pos, node &= Short.MAX_VALUE);
            pos = CharsTrie.skipValue(pos, node);
            this.stack_.add((long)pos << 32 | (long)(length - 1 << 16) | (long)this.str_.length());
            this.str_.append(trieUnit);
            if (isFinal) {
                this.pos_ = -1;
                this.entry_.chars = this.str_;
                this.entry_.value = value;
                return -1;
            }
            return pos + value;
        }

        private /* synthetic */ void $$robo$$android_icu_util_CharsTrie_Iterator$__constructor__(CharSequence x0, int x1, int x2, int x3, 1 x4) {
        }

        private void __constructor__(CharSequence charSequence, int n, int n2, int n3) {
            this.$$robo$$android_icu_util_CharsTrie_Iterator$__constructor__(charSequence, n, n2, n3);
        }

        public Iterator(CharSequence charSequence, int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_CharsTrie_Iterator$__constructor__(java.lang.CharSequence int int int ), this, charSequence, n, n2, n3);
        }

        public Iterator reset() {
            return InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_util_CharsTrie_Iterator$reset(), this);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_util_CharsTrie_Iterator$hasNext(), this);
        }

        @Override
        public Entry next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_util_CharsTrie_Iterator$next(), this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_util_CharsTrie_Iterator$remove(), this);
        }

        private Entry truncateAndStop() {
            return InvokeDynamicSupport.bootstrap("truncateAndStop", $$robo$$android_icu_util_CharsTrie_Iterator$truncateAndStop(), this);
        }

        private int branchNext(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("branchNext", $$robo$$android_icu_util_CharsTrie_Iterator$branchNext(int int ), this, n, n2);
        }

        private /* synthetic */ void __constructor__(CharSequence charSequence, int n, int n2, int n3, 1 var5_5) {
            this.$$robo$$android_icu_util_CharsTrie_Iterator$__constructor__(charSequence, n, n2, n3, var5_5);
        }

        public /* synthetic */ Iterator(CharSequence charSequence, int n, int n2, int n3, 1 var5_5) {
            this(charSequence, n, n2, n3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_CharsTrie_Iterator$__constructor__(java.lang.CharSequence int int int android.icu.util.CharsTrie$1 ), this, charSequence, n, n2, n3, var5_5);
        }

        public /* synthetic */ Iterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Iterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Entry
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public CharSequence chars;
        public int value;

        private void $$robo$$android_icu_util_CharsTrie_Entry$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_icu_util_CharsTrie_Entry$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_CharsTrie_Entry$__constructor__();
        }

        public Entry() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_CharsTrie_Entry$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_util_CharsTrie_Entry$__constructor__(var1_1);
        }

        public /* synthetic */ Entry(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_CharsTrie_Entry$__constructor__(android.icu.util.CharsTrie$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CharSequence chars;
        private int root;
        private int pos;
        private int remainingMatchLength;

        private void $$robo$$android_icu_util_CharsTrie_State$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_CharsTrie_State$__constructor__();
        }

        public State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_CharsTrie_State$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

