/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUDebug;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.PatternProps;
import android.icu.lang.UCharacter;
import android.icu.math.BigDecimal;
import android.icu.text.BreakIterator;
import android.icu.text.DecimalFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.DisplayContext;
import android.icu.text.NFRule;
import android.icu.text.NFRuleSet;
import android.icu.text.NumberFormat;
import android.icu.text.PluralFormat;
import android.icu.text.PluralRules;
import android.icu.text.RBNFPostProcessor;
import android.icu.text.RbnfLenientScanner;
import android.icu.text.RbnfLenientScannerProvider;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.UResourceBundleIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RuleBasedNumberFormat
extends NumberFormat
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static long serialVersionUID = -7664252765575395068L;
    public static int SPELLOUT = 1;
    public static int ORDINAL = 2;
    public static int DURATION = 3;
    public static int NUMBERING_SYSTEM = 4;
    private transient NFRuleSet[] ruleSets;
    private transient Map<String, NFRuleSet> ruleSetsMap;
    private transient NFRuleSet defaultRuleSet;
    private ULocale locale;
    private int roundingMode;
    private transient RbnfLenientScannerProvider scannerProvider;
    private transient boolean lookedForScanner;
    private transient DecimalFormatSymbols decimalFormatSymbols;
    private transient DecimalFormat decimalFormat;
    private transient NFRule defaultInfinityRule;
    private transient NFRule defaultNaNRule;
    private boolean lenientParse;
    private transient String lenientParseRules;
    private transient String postProcessRules;
    private transient RBNFPostProcessor postProcessor;
    private Map<String, String[]> ruleSetDisplayNames;
    private String[] publicRuleSetNames;
    private boolean capitalizationInfoIsSet;
    private boolean capitalizationForListOrMenu;
    private boolean capitalizationForStandAlone;
    private transient BreakIterator capitalizationBrkIter;
    private static boolean DEBUG;
    private static String[] rulenames;
    private static String[] locnames;
    private static BigDecimal MAX_VALUE;
    private static BigDecimal MIN_VALUE;

    private void $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(String description) {
        this.ruleSets = null;
        this.ruleSetsMap = null;
        this.defaultRuleSet = null;
        this.locale = null;
        this.roundingMode = 7;
        this.scannerProvider = null;
        this.decimalFormatSymbols = null;
        this.decimalFormat = null;
        this.defaultInfinityRule = null;
        this.defaultNaNRule = null;
        this.lenientParse = false;
        this.capitalizationInfoIsSet = false;
        this.capitalizationForListOrMenu = false;
        this.capitalizationForStandAlone = false;
        this.capitalizationBrkIter = null;
        this.locale = ULocale.getDefault(ULocale.Category.FORMAT);
        this.init(description, null);
    }

    private void $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(String description, String[][] localizations) {
        this.ruleSets = null;
        this.ruleSetsMap = null;
        this.defaultRuleSet = null;
        this.locale = null;
        this.roundingMode = 7;
        this.scannerProvider = null;
        this.decimalFormatSymbols = null;
        this.decimalFormat = null;
        this.defaultInfinityRule = null;
        this.defaultNaNRule = null;
        this.lenientParse = false;
        this.capitalizationInfoIsSet = false;
        this.capitalizationForListOrMenu = false;
        this.capitalizationForStandAlone = false;
        this.capitalizationBrkIter = null;
        this.locale = ULocale.getDefault(ULocale.Category.FORMAT);
        this.init(description, localizations);
    }

    private void $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(String description, Locale locale) {
    }

    private void $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(String description, ULocale locale) {
        this.ruleSets = null;
        this.ruleSetsMap = null;
        this.defaultRuleSet = null;
        this.locale = null;
        this.roundingMode = 7;
        this.scannerProvider = null;
        this.decimalFormatSymbols = null;
        this.decimalFormat = null;
        this.defaultInfinityRule = null;
        this.defaultNaNRule = null;
        this.lenientParse = false;
        this.capitalizationInfoIsSet = false;
        this.capitalizationForListOrMenu = false;
        this.capitalizationForStandAlone = false;
        this.capitalizationBrkIter = null;
        this.locale = locale;
        this.init(description, null);
    }

    private void $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(String description, String[][] localizations, ULocale locale) {
        this.ruleSets = null;
        this.ruleSetsMap = null;
        this.defaultRuleSet = null;
        this.locale = null;
        this.roundingMode = 7;
        this.scannerProvider = null;
        this.decimalFormatSymbols = null;
        this.decimalFormat = null;
        this.defaultInfinityRule = null;
        this.defaultNaNRule = null;
        this.lenientParse = false;
        this.capitalizationInfoIsSet = false;
        this.capitalizationForListOrMenu = false;
        this.capitalizationForStandAlone = false;
        this.capitalizationBrkIter = null;
        this.locale = locale;
        this.init(description, localizations);
    }

    private void $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(Locale locale, int format) {
    }

    private void $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(ULocale locale, int format) {
        UResourceBundle locNamesBundle;
        this.ruleSets = null;
        this.ruleSetsMap = null;
        this.defaultRuleSet = null;
        this.locale = null;
        this.roundingMode = 7;
        this.scannerProvider = null;
        this.decimalFormatSymbols = null;
        this.decimalFormat = null;
        this.defaultInfinityRule = null;
        this.defaultNaNRule = null;
        this.lenientParse = false;
        this.capitalizationInfoIsSet = false;
        this.capitalizationForListOrMenu = false;
        this.capitalizationForStandAlone = false;
        this.capitalizationBrkIter = null;
        this.locale = locale;
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b/rbnf", locale);
        ULocale uloc = bundle.getULocale();
        this.setLocale(uloc, uloc);
        StringBuilder description = new StringBuilder();
        String[][] localizations = null;
        try {
            ICUResourceBundle rules = bundle.getWithFallback("RBNFRules/" + rulenames[format - 1]);
            UResourceBundleIterator it = rules.getIterator();
            while (it.hasNext()) {
                description.append(it.nextString());
            }
        }
        catch (MissingResourceException rules) {
            // empty catch block
        }
        if ((locNamesBundle = bundle.findTopLevel(locnames[format - 1])) != null) {
            localizations = new String[locNamesBundle.getSize()][];
            for (int i = 0; i < localizations.length; ++i) {
                localizations[i] = locNamesBundle.get(i).getStringArray();
            }
        }
        this.init(description.toString(), localizations);
    }

    private void $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(int format) {
    }

    private final Object $$robo$$android_icu_text_RuleBasedNumberFormat$clone() {
        return super.clone();
    }

    private final boolean $$robo$$android_icu_text_RuleBasedNumberFormat$equals(Object that) {
        if (!(that instanceof RuleBasedNumberFormat)) {
            return false;
        }
        RuleBasedNumberFormat that2 = (RuleBasedNumberFormat)that;
        if (!this.locale.equals(that2.locale) || this.lenientParse != that2.lenientParse) {
            return false;
        }
        if (this.ruleSets.length != that2.ruleSets.length) {
            return false;
        }
        for (int i = 0; i < this.ruleSets.length; ++i) {
            if (this.ruleSets[i].equals(that2.ruleSets[i])) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_RuleBasedNumberFormat$hashCode() {
        return super.hashCode();
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$toString() {
        StringBuilder result = new StringBuilder();
        for (NFRuleSet ruleSet : this.ruleSets) {
            result.append(ruleSet.toString());
        }
        return result.toString();
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
        out.writeObject(this.locale);
        out.writeInt(this.roundingMode);
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$readObject(ObjectInputStream in) throws IOException {
        ULocale loc;
        String description = in.readUTF();
        try {
            loc = (ULocale)in.readObject();
        }
        catch (Exception e) {
            loc = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        try {
            this.roundingMode = in.readInt();
        }
        catch (Exception e) {
            // empty catch block
        }
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(description, loc);
        this.ruleSets = temp.ruleSets;
        this.ruleSetsMap = temp.ruleSetsMap;
        this.defaultRuleSet = temp.defaultRuleSet;
        this.publicRuleSetNames = temp.publicRuleSetNames;
        this.decimalFormatSymbols = temp.decimalFormatSymbols;
        this.decimalFormat = temp.decimalFormat;
        this.locale = temp.locale;
        this.defaultInfinityRule = temp.defaultInfinityRule;
        this.defaultNaNRule = temp.defaultNaNRule;
    }

    private final String[] $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetNames() {
        return (String[])this.publicRuleSetNames.clone();
    }

    private final ULocale[] $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayNameLocales() {
        if (this.ruleSetDisplayNames != null) {
            Set<String> s = this.ruleSetDisplayNames.keySet();
            String[] locales = s.toArray(new String[s.size()]);
            Arrays.sort(locales, String.CASE_INSENSITIVE_ORDER);
            ULocale[] result = new ULocale[locales.length];
            for (int i = 0; i < locales.length; ++i) {
                result[i] = new ULocale(locales[i]);
            }
            return result;
        }
        return null;
    }

    private final String[] $$robo$$android_icu_text_RuleBasedNumberFormat$getNameListForLocale(ULocale loc) {
        if (loc != null && this.ruleSetDisplayNames != null) {
            String[] localeNames;
            for (String lname : localeNames = new String[]{loc.getBaseName(), ULocale.getDefault(ULocale.Category.DISPLAY).getBaseName()}) {
                while (lname.length() > 0) {
                    String[] names = this.ruleSetDisplayNames.get(lname);
                    if (names != null) {
                        return names;
                    }
                    lname = ULocale.getFallback(lname);
                }
            }
        }
        return null;
    }

    private final String[] $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayNames(ULocale loc) {
        String[] names = this.getNameListForLocale(loc);
        if (names != null) {
            return (String[])names.clone();
        }
        names = this.getRuleSetNames();
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].substring(1);
        }
        return names;
    }

    private final String[] $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayNames() {
        return this.getRuleSetDisplayNames(ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayName(String ruleSetName, ULocale loc) {
        String[] rsnames = this.publicRuleSetNames;
        for (int ix = 0; ix < rsnames.length; ++ix) {
            if (!rsnames[ix].equals(ruleSetName)) continue;
            String[] names = this.getNameListForLocale(loc);
            if (names != null) {
                return names[ix];
            }
            return rsnames[ix].substring(1);
        }
        throw new IllegalArgumentException("unrecognized rule set name: " + ruleSetName);
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayName(String ruleSetName) {
        return this.getRuleSetDisplayName(ruleSetName, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$format(double number, String ruleSet) throws IllegalArgumentException {
        if (ruleSet.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.adjustForContext(this.format(number, this.findRuleSet(ruleSet)));
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$format(long number, String ruleSet) throws IllegalArgumentException {
        if (ruleSet.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.adjustForContext(this.format(number, this.findRuleSet(ruleSet)));
    }

    private final StringBuffer $$robo$$android_icu_text_RuleBasedNumberFormat$format(double number, StringBuffer toAppendTo, FieldPosition ignore) {
        if (toAppendTo.length() == 0) {
            toAppendTo.append(this.adjustForContext(this.format(number, this.defaultRuleSet)));
        } else {
            toAppendTo.append(this.format(number, this.defaultRuleSet));
        }
        return toAppendTo;
    }

    private final StringBuffer $$robo$$android_icu_text_RuleBasedNumberFormat$format(long number, StringBuffer toAppendTo, FieldPosition ignore) {
        if (toAppendTo.length() == 0) {
            toAppendTo.append(this.adjustForContext(this.format(number, this.defaultRuleSet)));
        } else {
            toAppendTo.append(this.format(number, this.defaultRuleSet));
        }
        return toAppendTo;
    }

    private final StringBuffer $$robo$$android_icu_text_RuleBasedNumberFormat$format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(new BigDecimal(number), toAppendTo, pos);
    }

    private final StringBuffer $$robo$$android_icu_text_RuleBasedNumberFormat$format(java.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(new BigDecimal(number), toAppendTo, pos);
    }

    private final StringBuffer $$robo$$android_icu_text_RuleBasedNumberFormat$format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        if (MIN_VALUE.compareTo(number) >= 0 || MAX_VALUE.compareTo(number) <= 0) {
            return this.getDecimalFormat().format(number, toAppendTo, pos);
        }
        if (number.scale() == 0) {
            return this.format(number.longValue(), toAppendTo, pos);
        }
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    private final Number $$robo$$android_icu_text_RuleBasedNumberFormat$parse(String text, ParsePosition parsePosition) {
        String workingText = text.substring(parsePosition.getIndex());
        ParsePosition workingPos = new ParsePosition(0);
        Number tempResult = null;
        Number result = NFRule.ZERO;
        ParsePosition highWaterMark = new ParsePosition(workingPos.getIndex());
        for (int i = this.ruleSets.length - 1; i >= 0; --i) {
            if (!this.ruleSets[i].isPublic() || !this.ruleSets[i].isParseable()) continue;
            tempResult = this.ruleSets[i].parse(workingText, workingPos, Double.MAX_VALUE);
            if (workingPos.getIndex() > highWaterMark.getIndex()) {
                result = tempResult;
                highWaterMark.setIndex(workingPos.getIndex());
            }
            if (highWaterMark.getIndex() == workingText.length()) break;
            workingPos.setIndex(0);
        }
        parsePosition.setIndex(parsePosition.getIndex() + highWaterMark.getIndex());
        return result;
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$setLenientParseMode(boolean enabled) {
        this.lenientParse = enabled;
    }

    private final boolean $$robo$$android_icu_text_RuleBasedNumberFormat$lenientParseEnabled() {
        return this.lenientParse;
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$setLenientScannerProvider(RbnfLenientScannerProvider scannerProvider) {
        this.scannerProvider = scannerProvider;
    }

    private final RbnfLenientScannerProvider $$robo$$android_icu_text_RuleBasedNumberFormat$getLenientScannerProvider() {
        if (this.scannerProvider == null && this.lenientParse && !this.lookedForScanner) {
            try {
                this.lookedForScanner = true;
                Class<?> cls = Class.forName("android.icu.impl.text.RbnfScannerProviderImpl");
                RbnfLenientScannerProvider provider = (RbnfLenientScannerProvider)cls.newInstance();
                this.setLenientScannerProvider(provider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.scannerProvider;
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$setDefaultRuleSet(String ruleSetName) {
        if (ruleSetName == null) {
            if (this.publicRuleSetNames.length > 0) {
                this.defaultRuleSet = this.findRuleSet(this.publicRuleSetNames[0]);
            } else {
                this.defaultRuleSet = null;
                int n = this.ruleSets.length;
                while (--n >= 0) {
                    String currentName = this.ruleSets[n].getName();
                    if (!currentName.equals("%spellout-numbering") && !currentName.equals("%digits-ordinal") && !currentName.equals("%duration")) continue;
                    this.defaultRuleSet = this.ruleSets[n];
                    return;
                }
                n = this.ruleSets.length;
                while (--n >= 0) {
                    if (!this.ruleSets[n].isPublic()) continue;
                    this.defaultRuleSet = this.ruleSets[n];
                    break;
                }
            }
        } else {
            if (ruleSetName.startsWith("%%")) {
                throw new IllegalArgumentException("cannot use private rule set: " + ruleSetName);
            }
            this.defaultRuleSet = this.findRuleSet(ruleSetName);
        }
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$getDefaultRuleSetName() {
        if (this.defaultRuleSet != null && this.defaultRuleSet.isPublic()) {
            return this.defaultRuleSet.getName();
        }
        return "";
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        if (newSymbols != null) {
            this.decimalFormatSymbols = (DecimalFormatSymbols)newSymbols.clone();
            if (this.decimalFormat != null) {
                this.decimalFormat.setDecimalFormatSymbols(this.decimalFormatSymbols);
            }
            if (this.defaultInfinityRule != null) {
                this.defaultInfinityRule = null;
                this.getDefaultInfinityRule();
            }
            if (this.defaultNaNRule != null) {
                this.defaultNaNRule = null;
                this.getDefaultNaNRule();
            }
            for (NFRuleSet ruleSet : this.ruleSets) {
                ruleSet.setDecimalFormatSymbols(this.decimalFormatSymbols);
            }
        }
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$setContext(DisplayContext context) {
        super.setContext(context);
        if (!(this.capitalizationInfoIsSet || context != DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && context != DisplayContext.CAPITALIZATION_FOR_STANDALONE)) {
            this.initCapitalizationContextInfo(this.locale);
            this.capitalizationInfoIsSet = true;
        }
        if (this.capitalizationBrkIter == null && (context == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || context == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && this.capitalizationForListOrMenu || context == DisplayContext.CAPITALIZATION_FOR_STANDALONE && this.capitalizationForStandAlone)) {
            this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.locale);
        }
    }

    private final int $$robo$$android_icu_text_RuleBasedNumberFormat$getRoundingMode() {
        return this.roundingMode;
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$setRoundingMode(int roundingMode) {
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("Invalid rounding mode: " + roundingMode);
        }
        this.roundingMode = roundingMode;
    }

    private final NFRuleSet $$robo$$android_icu_text_RuleBasedNumberFormat$getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    private final RbnfLenientScanner $$robo$$android_icu_text_RuleBasedNumberFormat$getLenientScanner() {
        RbnfLenientScannerProvider provider;
        if (this.lenientParse && (provider = this.getLenientScannerProvider()) != null) {
            return provider.get(this.locale, this.lenientParseRules);
        }
        return null;
    }

    private final DecimalFormatSymbols $$robo$$android_icu_text_RuleBasedNumberFormat$getDecimalFormatSymbols() {
        if (this.decimalFormatSymbols == null) {
            this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        }
        return this.decimalFormatSymbols;
    }

    private final DecimalFormat $$robo$$android_icu_text_RuleBasedNumberFormat$getDecimalFormat() {
        if (this.decimalFormat == null) {
            String pattern = RuleBasedNumberFormat.getPattern(this.locale, 0);
            this.decimalFormat = new DecimalFormat(pattern, this.getDecimalFormatSymbols());
        }
        return this.decimalFormat;
    }

    private final PluralFormat $$robo$$android_icu_text_RuleBasedNumberFormat$createPluralFormat(PluralRules.PluralType pluralType, String pattern) {
        return new PluralFormat(this.locale, pluralType, pattern, this.getDecimalFormat());
    }

    private final NFRule $$robo$$android_icu_text_RuleBasedNumberFormat$getDefaultInfinityRule() {
        if (this.defaultInfinityRule == null) {
            this.defaultInfinityRule = new NFRule(this, "Inf: " + this.getDecimalFormatSymbols().getInfinity());
        }
        return this.defaultInfinityRule;
    }

    private final NFRule $$robo$$android_icu_text_RuleBasedNumberFormat$getDefaultNaNRule() {
        if (this.defaultNaNRule == null) {
            this.defaultNaNRule = new NFRule(this, "NaN: " + this.getDecimalFormatSymbols().getNaN());
        }
        return this.defaultNaNRule;
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$extractSpecial(StringBuilder description, String specialName) {
        String result = null;
        int lp = description.indexOf(specialName);
        if (lp != -1 && (lp == 0 || description.charAt(lp - 1) == ';')) {
            int lpStart;
            int lpEnd = description.indexOf(";%", lp);
            if (lpEnd == -1) {
                lpEnd = description.length() - 1;
            }
            for (lpStart = lp + specialName.length(); lpStart < lpEnd && PatternProps.isWhiteSpace(description.charAt(lpStart)); ++lpStart) {
            }
            result = description.substring(lpStart, lpEnd);
            description.delete(lp, lpEnd + 1);
        }
        return result;
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$init(String description, String[][] localizations) {
        int i;
        this.initLocalizations(localizations);
        StringBuilder descBuf = this.stripWhitespace(description);
        this.lenientParseRules = this.extractSpecial(descBuf, "%%lenient-parse:");
        this.postProcessRules = this.extractSpecial(descBuf, "%%post-process:");
        int numRuleSets = 1;
        int p = 0;
        while ((p = descBuf.indexOf(";%", p)) != -1) {
            ++numRuleSets;
            p += 2;
        }
        this.ruleSets = new NFRuleSet[numRuleSets];
        this.ruleSetsMap = new HashMap<String, NFRuleSet>(numRuleSets * 2 + 1);
        this.defaultRuleSet = null;
        int publicRuleSetCount = 0;
        String[] ruleSetDescriptions = new String[numRuleSets];
        int start = 0;
        for (int curRuleSet = 0; curRuleSet < this.ruleSets.length; ++curRuleSet) {
            NFRuleSet ruleSet;
            p = descBuf.indexOf(";%", start);
            if (p < 0) {
                p = descBuf.length() - 1;
            }
            ruleSetDescriptions[curRuleSet] = descBuf.substring(start, p + 1);
            this.ruleSets[curRuleSet] = ruleSet = new NFRuleSet(this, ruleSetDescriptions, curRuleSet);
            String currentName = ruleSet.getName();
            this.ruleSetsMap.put(currentName, ruleSet);
            if (!currentName.startsWith("%%")) {
                ++publicRuleSetCount;
                if (this.defaultRuleSet == null && currentName.equals("%spellout-numbering") || currentName.equals("%digits-ordinal") || currentName.equals("%duration")) {
                    this.defaultRuleSet = ruleSet;
                }
            }
            start = p + 1;
        }
        if (this.defaultRuleSet == null) {
            for (int i2 = this.ruleSets.length - 1; i2 >= 0; --i2) {
                if (this.ruleSets[i2].getName().startsWith("%%")) continue;
                this.defaultRuleSet = this.ruleSets[i2];
                break;
            }
        }
        if (this.defaultRuleSet == null) {
            this.defaultRuleSet = this.ruleSets[this.ruleSets.length - 1];
        }
        for (int i3 = 0; i3 < this.ruleSets.length; ++i3) {
            this.ruleSets[i3].parseRules(ruleSetDescriptions[i3]);
        }
        String[] publicRuleSetTemp = new String[publicRuleSetCount];
        publicRuleSetCount = 0;
        for (i = this.ruleSets.length - 1; i >= 0; --i) {
            if (this.ruleSets[i].getName().startsWith("%%")) continue;
            publicRuleSetTemp[publicRuleSetCount++] = this.ruleSets[i].getName();
        }
        if (this.publicRuleSetNames != null) {
            block5: for (i = 0; i < this.publicRuleSetNames.length; ++i) {
                String name = this.publicRuleSetNames[i];
                for (int j = 0; j < publicRuleSetTemp.length; ++j) {
                    if (name.equals(publicRuleSetTemp[j])) continue block5;
                }
                throw new IllegalArgumentException("did not find public rule set: " + name);
            }
            this.defaultRuleSet = this.findRuleSet(this.publicRuleSetNames[0]);
        } else {
            this.publicRuleSetNames = publicRuleSetTemp;
        }
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$initLocalizations(String[][] localizations) {
        if (localizations != null) {
            this.publicRuleSetNames = (String[])localizations[0].clone();
            HashMap<String, String[]> m = new HashMap<String, String[]>();
            for (int i = 1; i < localizations.length; ++i) {
                String[] data = localizations[i];
                String loc = data[0];
                String[] names = new String[data.length - 1];
                if (names.length != this.publicRuleSetNames.length) {
                    throw new IllegalArgumentException("public name length: " + this.publicRuleSetNames.length + " != localized names[" + i + "] length: " + names.length);
                }
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)data, (int)1, (Object)names, (int)0, (int)names.length);
                m.put(loc, names);
            }
            if (!m.isEmpty()) {
                this.ruleSetDisplayNames = m;
            }
        }
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$initCapitalizationContextInfo(ULocale theLocale) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", theLocale);
        try {
            ICUResourceBundle rdb = rb.getWithFallback("contextTransforms/number-spellout");
            int[] intVector = rdb.getIntVector();
            if (intVector.length >= 2) {
                this.capitalizationForListOrMenu = intVector[0] != 0;
                this.capitalizationForStandAlone = intVector[1] != 0;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private final StringBuilder $$robo$$android_icu_text_RuleBasedNumberFormat$stripWhitespace(String description) {
        StringBuilder result = new StringBuilder();
        int descriptionLength = description.length();
        int start = 0;
        while (start < descriptionLength) {
            while (start < descriptionLength && PatternProps.isWhiteSpace(description.charAt(start))) {
                ++start;
            }
            if (start < descriptionLength && description.charAt(start) == ';') {
                ++start;
                continue;
            }
            int p = description.indexOf(59, start);
            if (p == -1) {
                result.append(description.substring(start));
                break;
            }
            if (p >= descriptionLength) break;
            result.append(description.substring(start, p + 1));
            start = p + 1;
        }
        return result;
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$format(double number, NFRuleSet ruleSet) {
        StringBuilder result = new StringBuilder();
        if (this.getRoundingMode() != 7) {
            number = new BigDecimal(Double.toString(number)).setScale(this.getMaximumFractionDigits(), this.roundingMode).doubleValue();
        }
        ruleSet.format(number, result, 0, 0);
        this.postProcess(result, ruleSet);
        return result.toString();
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$format(long number, NFRuleSet ruleSet) {
        StringBuilder result = new StringBuilder();
        if (number == Long.MIN_VALUE) {
            result.append(this.getDecimalFormat().format(Long.MIN_VALUE));
        } else {
            ruleSet.format(number, result, 0, 0);
        }
        this.postProcess(result, ruleSet);
        return result.toString();
    }

    private final void $$robo$$android_icu_text_RuleBasedNumberFormat$postProcess(StringBuilder result, NFRuleSet ruleSet) {
        if (this.postProcessRules != null) {
            if (this.postProcessor == null) {
                int ix = this.postProcessRules.indexOf(";");
                if (ix == -1) {
                    ix = this.postProcessRules.length();
                }
                String ppClassName = this.postProcessRules.substring(0, ix).trim();
                try {
                    Class<?> cls = Class.forName(ppClassName);
                    this.postProcessor = (RBNFPostProcessor)cls.newInstance();
                    this.postProcessor.init(this, this.postProcessRules);
                }
                catch (Exception e) {
                    if (DEBUG) {
                        System.out.println("could not locate " + ppClassName + ", error " + e.getClass().getName() + ", " + e.getMessage());
                    }
                    this.postProcessor = null;
                    this.postProcessRules = null;
                    return;
                }
            }
            this.postProcessor.process(result, ruleSet);
        }
    }

    private final String $$robo$$android_icu_text_RuleBasedNumberFormat$adjustForContext(String result) {
        DisplayContext capitalization;
        if (result != null && result.length() > 0 && UCharacter.isLowerCase(result.codePointAt(0)) && ((capitalization = this.getContext(DisplayContext.Type.CAPITALIZATION)) == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || capitalization == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && this.capitalizationForListOrMenu || capitalization == DisplayContext.CAPITALIZATION_FOR_STANDALONE && this.capitalizationForStandAlone)) {
            if (this.capitalizationBrkIter == null) {
                this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.locale);
            }
            return UCharacter.toTitleCase(this.locale, result, this.capitalizationBrkIter, 768);
        }
        return result;
    }

    private final NFRuleSet $$robo$$android_icu_text_RuleBasedNumberFormat$findRuleSet(String name) throws IllegalArgumentException {
        NFRuleSet result = this.ruleSetsMap.get(name);
        if (result == null) {
            throw new IllegalArgumentException("No rule set named " + name);
        }
        return result;
    }

    static void __staticInitializer__() {
        DEBUG = ICUDebug.enabled("rbnf");
        rulenames = new String[]{"SpelloutRules", "OrdinalRules", "DurationRules", "NumberingSystemRules"};
        locnames = new String[]{"SpelloutLocalizations", "OrdinalLocalizations", "DurationLocalizations", "NumberingSystemLocalizations"};
        MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
        MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(string2);
    }

    public RuleBasedNumberFormat(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__(String string2, String[][] stringArray) {
        this.$$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(string2, stringArray);
    }

    public RuleBasedNumberFormat(String string2, String[][] stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(java.lang.String java.lang.String[][] ), this, string2, stringArray);
    }

    private void __constructor__(String string2, Locale locale) {
        this.$$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(string2, locale);
    }

    public RuleBasedNumberFormat(String string2, Locale locale) {
        this(string2, ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(java.lang.String java.util.Locale ), this, string2, locale);
    }

    private void __constructor__(String string2, ULocale uLocale) {
        this.$$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(string2, uLocale);
    }

    public RuleBasedNumberFormat(String string2, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(java.lang.String android.icu.util.ULocale ), this, string2, uLocale);
    }

    private void __constructor__(String string2, String[][] stringArray, ULocale uLocale) {
        this.$$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(string2, stringArray, uLocale);
    }

    public RuleBasedNumberFormat(String string2, String[][] stringArray, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(java.lang.String java.lang.String[][] android.icu.util.ULocale ), this, string2, stringArray, uLocale);
    }

    private void __constructor__(Locale locale, int n) {
        this.$$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(locale, n);
    }

    public RuleBasedNumberFormat(Locale locale, int n) {
        this(ULocale.forLocale(locale), n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(java.util.Locale int ), this, locale, n);
    }

    private void __constructor__(ULocale uLocale, int n) {
        this.$$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(uLocale, n);
    }

    public RuleBasedNumberFormat(ULocale uLocale, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(android.icu.util.ULocale int ), this, uLocale, n);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(n);
    }

    public RuleBasedNumberFormat(int n) {
        this(ULocale.getDefault(ULocale.Category.FORMAT), n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RuleBasedNumberFormat$__constructor__(int ), this, n);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_RuleBasedNumberFormat$clone(), this);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_RuleBasedNumberFormat$equals(java.lang.Object ), this, object);
    }

    @Override
    @Deprecated
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_RuleBasedNumberFormat$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_RuleBasedNumberFormat$toString(), this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_text_RuleBasedNumberFormat$writeObject(java.io.ObjectOutputStream ), this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_RuleBasedNumberFormat$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    public String[] getRuleSetNames() {
        return InvokeDynamicSupport.bootstrap("getRuleSetNames", $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetNames(), this);
    }

    public ULocale[] getRuleSetDisplayNameLocales() {
        return InvokeDynamicSupport.bootstrap("getRuleSetDisplayNameLocales", $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayNameLocales(), this);
    }

    private String[] getNameListForLocale(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getNameListForLocale", $$robo$$android_icu_text_RuleBasedNumberFormat$getNameListForLocale(android.icu.util.ULocale ), this, uLocale);
    }

    public String[] getRuleSetDisplayNames(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getRuleSetDisplayNames", $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayNames(android.icu.util.ULocale ), this, uLocale);
    }

    public String[] getRuleSetDisplayNames() {
        return InvokeDynamicSupport.bootstrap("getRuleSetDisplayNames", $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayNames(), this);
    }

    public String getRuleSetDisplayName(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getRuleSetDisplayName", $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayName(java.lang.String android.icu.util.ULocale ), this, string2, uLocale);
    }

    public String getRuleSetDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrap("getRuleSetDisplayName", $$robo$$android_icu_text_RuleBasedNumberFormat$getRuleSetDisplayName(java.lang.String ), this, string2);
    }

    public String format(double d, String string2) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(double java.lang.String ), this, d, string2);
    }

    public String format(long l, String string2) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(long java.lang.String ), this, l, string2);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(double java.lang.StringBuffer java.text.FieldPosition ), this, d, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(long java.lang.StringBuffer java.text.FieldPosition ), this, l, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(java.math.BigInteger java.lang.StringBuffer java.text.FieldPosition ), this, bigInteger, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(java.math.BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(java.math.BigDecimal java.lang.StringBuffer java.text.FieldPosition ), this, bigDecimal, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(android.icu.math.BigDecimal java.lang.StringBuffer java.text.FieldPosition ), this, bigDecimal, stringBuffer, fieldPosition);
    }

    @Override
    public Number parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_RuleBasedNumberFormat$parse(java.lang.String java.text.ParsePosition ), this, string2, parsePosition);
    }

    public void setLenientParseMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLenientParseMode", $$robo$$android_icu_text_RuleBasedNumberFormat$setLenientParseMode(boolean ), this, bl);
    }

    public boolean lenientParseEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("lenientParseEnabled", $$robo$$android_icu_text_RuleBasedNumberFormat$lenientParseEnabled(), this);
    }

    public void setLenientScannerProvider(RbnfLenientScannerProvider rbnfLenientScannerProvider) {
        InvokeDynamicSupport.bootstrap("setLenientScannerProvider", $$robo$$android_icu_text_RuleBasedNumberFormat$setLenientScannerProvider(android.icu.text.RbnfLenientScannerProvider ), this, rbnfLenientScannerProvider);
    }

    public RbnfLenientScannerProvider getLenientScannerProvider() {
        return InvokeDynamicSupport.bootstrap("getLenientScannerProvider", $$robo$$android_icu_text_RuleBasedNumberFormat$getLenientScannerProvider(), this);
    }

    public void setDefaultRuleSet(String string2) {
        InvokeDynamicSupport.bootstrap("setDefaultRuleSet", $$robo$$android_icu_text_RuleBasedNumberFormat$setDefaultRuleSet(java.lang.String ), this, string2);
    }

    public String getDefaultRuleSetName() {
        return InvokeDynamicSupport.bootstrap("getDefaultRuleSetName", $$robo$$android_icu_text_RuleBasedNumberFormat$getDefaultRuleSetName(), this);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        InvokeDynamicSupport.bootstrap("setDecimalFormatSymbols", $$robo$$android_icu_text_RuleBasedNumberFormat$setDecimalFormatSymbols(android.icu.text.DecimalFormatSymbols ), this, decimalFormatSymbols);
    }

    @Override
    public void setContext(DisplayContext displayContext) {
        InvokeDynamicSupport.bootstrap("setContext", $$robo$$android_icu_text_RuleBasedNumberFormat$setContext(android.icu.text.DisplayContext ), this, displayContext);
    }

    @Override
    public int getRoundingMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRoundingMode", $$robo$$android_icu_text_RuleBasedNumberFormat$getRoundingMode(), this);
    }

    @Override
    public void setRoundingMode(int n) {
        InvokeDynamicSupport.bootstrap("setRoundingMode", $$robo$$android_icu_text_RuleBasedNumberFormat$setRoundingMode(int ), this, n);
    }

    NFRuleSet getDefaultRuleSet() {
        return InvokeDynamicSupport.bootstrap("getDefaultRuleSet", $$robo$$android_icu_text_RuleBasedNumberFormat$getDefaultRuleSet(), this);
    }

    RbnfLenientScanner getLenientScanner() {
        return InvokeDynamicSupport.bootstrap("getLenientScanner", $$robo$$android_icu_text_RuleBasedNumberFormat$getLenientScanner(), this);
    }

    DecimalFormatSymbols getDecimalFormatSymbols() {
        return InvokeDynamicSupport.bootstrap("getDecimalFormatSymbols", $$robo$$android_icu_text_RuleBasedNumberFormat$getDecimalFormatSymbols(), this);
    }

    DecimalFormat getDecimalFormat() {
        return InvokeDynamicSupport.bootstrap("getDecimalFormat", $$robo$$android_icu_text_RuleBasedNumberFormat$getDecimalFormat(), this);
    }

    PluralFormat createPluralFormat(PluralRules.PluralType pluralType, String string2) {
        return InvokeDynamicSupport.bootstrap("createPluralFormat", $$robo$$android_icu_text_RuleBasedNumberFormat$createPluralFormat(android.icu.text.PluralRules$PluralType java.lang.String ), this, pluralType, string2);
    }

    NFRule getDefaultInfinityRule() {
        return InvokeDynamicSupport.bootstrap("getDefaultInfinityRule", $$robo$$android_icu_text_RuleBasedNumberFormat$getDefaultInfinityRule(), this);
    }

    NFRule getDefaultNaNRule() {
        return InvokeDynamicSupport.bootstrap("getDefaultNaNRule", $$robo$$android_icu_text_RuleBasedNumberFormat$getDefaultNaNRule(), this);
    }

    private String extractSpecial(StringBuilder stringBuilder, String string2) {
        return InvokeDynamicSupport.bootstrap("extractSpecial", $$robo$$android_icu_text_RuleBasedNumberFormat$extractSpecial(java.lang.StringBuilder java.lang.String ), this, stringBuilder, string2);
    }

    private void init(String string2, String[][] stringArray) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_icu_text_RuleBasedNumberFormat$init(java.lang.String java.lang.String[][] ), this, string2, stringArray);
    }

    private void initLocalizations(String[][] stringArray) {
        InvokeDynamicSupport.bootstrap("initLocalizations", $$robo$$android_icu_text_RuleBasedNumberFormat$initLocalizations(java.lang.String[][] ), this, stringArray);
    }

    private void initCapitalizationContextInfo(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("initCapitalizationContextInfo", $$robo$$android_icu_text_RuleBasedNumberFormat$initCapitalizationContextInfo(android.icu.util.ULocale ), this, uLocale);
    }

    private StringBuilder stripWhitespace(String string2) {
        return InvokeDynamicSupport.bootstrap("stripWhitespace", $$robo$$android_icu_text_RuleBasedNumberFormat$stripWhitespace(java.lang.String ), this, string2);
    }

    private String format(double d, NFRuleSet nFRuleSet) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(double android.icu.text.NFRuleSet ), this, d, nFRuleSet);
    }

    private String format(long l, NFRuleSet nFRuleSet) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RuleBasedNumberFormat$format(long android.icu.text.NFRuleSet ), this, l, nFRuleSet);
    }

    private void postProcess(StringBuilder stringBuilder, NFRuleSet nFRuleSet) {
        InvokeDynamicSupport.bootstrap("postProcess", $$robo$$android_icu_text_RuleBasedNumberFormat$postProcess(java.lang.StringBuilder android.icu.text.NFRuleSet ), this, stringBuilder, nFRuleSet);
    }

    private String adjustForContext(String string2) {
        return InvokeDynamicSupport.bootstrap("adjustForContext", $$robo$$android_icu_text_RuleBasedNumberFormat$adjustForContext(java.lang.String ), this, string2);
    }

    NFRuleSet findRuleSet(String string2) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("findRuleSet", $$robo$$android_icu_text_RuleBasedNumberFormat$findRuleSet(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(RuleBasedNumberFormat.class);
    }

    public /* synthetic */ RuleBasedNumberFormat() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RuleBasedNumberFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

