/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CacheValue;
import android.icu.impl.ICUDebug;
import android.icu.text.RuleBasedBreakIterator;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BreakIterator
implements Cloneable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG;
    public static int DONE = -1;
    public static int WORD_NONE = 0;
    public static int WORD_NONE_LIMIT = 100;
    public static int WORD_NUMBER = 100;
    public static int WORD_NUMBER_LIMIT = 200;
    public static int WORD_LETTER = 200;
    public static int WORD_LETTER_LIMIT = 300;
    public static int WORD_KANA = 300;
    public static int WORD_KANA_LIMIT = 400;
    public static int WORD_IDEO = 400;
    public static int WORD_IDEO_LIMIT = 500;
    public static int KIND_CHARACTER = 0;
    public static int KIND_WORD = 1;
    public static int KIND_LINE = 2;
    public static int KIND_SENTENCE = 3;
    public static int KIND_TITLE = 4;
    private static int KIND_COUNT = 5;
    private static CacheValue<?>[] iterCache;
    private static BreakIteratorServiceShim shim;
    private ULocale validLocale;
    private ULocale actualLocale;

    private void $$robo$$android_icu_text_BreakIterator$__constructor__() {
    }

    private final Object $$robo$$android_icu_text_BreakIterator$clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    public abstract int first();

    public abstract int last();

    public abstract int next(int var1);

    public abstract int next();

    public abstract int previous();

    public abstract int following(int var1);

    private final int $$robo$$android_icu_text_BreakIterator$preceding(int offset) {
        int pos = this.following(offset);
        while (pos >= offset && pos != -1) {
            pos = this.previous();
        }
        return pos;
    }

    private final boolean $$robo$$android_icu_text_BreakIterator$isBoundary(int offset) {
        if (offset == 0) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    public abstract int current();

    private final int $$robo$$android_icu_text_BreakIterator$getRuleStatus() {
        return 0;
    }

    private final int $$robo$$android_icu_text_BreakIterator$getRuleStatusVec(int[] fillInArray) {
        if (fillInArray != null && fillInArray.length > 0) {
            fillInArray[0] = 0;
        }
        return 1;
    }

    public abstract CharacterIterator getText();

    private final void $$robo$$android_icu_text_BreakIterator$setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    public abstract void setText(CharacterIterator var1);

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getWordInstance() {
        return BreakIterator.getWordInstance(ULocale.getDefault());
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getWordInstance(Locale where) {
        return BreakIterator.getBreakInstance(ULocale.forLocale(where), 1);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getWordInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where, 1);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getLineInstance() {
        return BreakIterator.getLineInstance(ULocale.getDefault());
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getLineInstance(Locale where) {
        return BreakIterator.getBreakInstance(ULocale.forLocale(where), 2);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getLineInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where, 2);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getCharacterInstance() {
        return BreakIterator.getCharacterInstance(ULocale.getDefault());
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getCharacterInstance(Locale where) {
        return BreakIterator.getBreakInstance(ULocale.forLocale(where), 0);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getCharacterInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where, 0);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getSentenceInstance() {
        return BreakIterator.getSentenceInstance(ULocale.getDefault());
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getSentenceInstance(Locale where) {
        return BreakIterator.getBreakInstance(ULocale.forLocale(where), 3);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getSentenceInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where, 3);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getTitleInstance() {
        return BreakIterator.getTitleInstance(ULocale.getDefault());
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getTitleInstance(Locale where) {
        return BreakIterator.getBreakInstance(ULocale.forLocale(where), 4);
    }

    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getTitleInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where, 4);
    }

    private static final Object $$robo$$android_icu_text_BreakIterator$registerInstance(BreakIterator iter, Locale locale, int kind) {
        return BreakIterator.registerInstance(iter, ULocale.forLocale(locale), kind);
    }

    private static final Object $$robo$$android_icu_text_BreakIterator$registerInstance(BreakIterator iter, ULocale locale, int kind) {
        BreakIteratorCache cache;
        if (iterCache[kind] != null && (cache = (BreakIteratorCache)iterCache[kind].get()) != null && cache.getLocale().equals(locale)) {
            BreakIterator.iterCache[kind] = null;
        }
        return BreakIterator.getShim().registerInstance(iter, locale, kind);
    }

    private static final boolean $$robo$$android_icu_text_BreakIterator$unregister(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("registry key must not be null");
        }
        if (shim != null) {
            for (int kind = 0; kind < 5; ++kind) {
                BreakIterator.iterCache[kind] = null;
            }
            return shim.unregister(key);
        }
        return false;
    }

    @Deprecated
    private static final BreakIterator $$robo$$android_icu_text_BreakIterator$getBreakInstance(ULocale where, int kind) {
        BreakIteratorCache cache;
        if (where == null) {
            throw new NullPointerException("Specified locale is null");
        }
        if (iterCache[kind] != null && (cache = (BreakIteratorCache)iterCache[kind].get()) != null && cache.getLocale().equals(where)) {
            return cache.createBreakInstance();
        }
        BreakIterator result = BreakIterator.getShim().createBreakIterator(where, kind);
        BreakIteratorCache cache2 = new BreakIteratorCache(where, result);
        BreakIterator.iterCache[kind] = CacheValue.getInstance(cache2);
        if (result instanceof RuleBasedBreakIterator) {
            RuleBasedBreakIterator rbbi = (RuleBasedBreakIterator)result;
            rbbi.setBreakType(kind);
        }
        return result;
    }

    private static final synchronized Locale[] $$robo$$android_icu_text_BreakIterator$getAvailableLocales() {
        return BreakIterator.getShim().getAvailableLocales();
    }

    private static final synchronized ULocale[] $$robo$$android_icu_text_BreakIterator$getAvailableULocales() {
        return BreakIterator.getShim().getAvailableULocales();
    }

    private static final BreakIteratorServiceShim $$robo$$android_icu_text_BreakIterator$getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("android.icu.text.BreakIteratorFactory");
                shim = (BreakIteratorServiceShim)cls.newInstance();
            }
            catch (MissingResourceException e) {
                throw e;
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    private final ULocale $$robo$$android_icu_text_BreakIterator$getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    private final void $$robo$$android_icu_text_BreakIterator$setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static void __staticInitializer__() {
        DEBUG = ICUDebug.enabled("breakiterator");
        iterCache = new CacheValue[5];
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_BreakIterator$__constructor__();
    }

    public BreakIterator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakIterator$__constructor__(), this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_BreakIterator$clone(), this);
    }

    public int preceding(int n) {
        return (int)InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_icu_text_BreakIterator$preceding(int ), this, n);
    }

    public boolean isBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBoundary", $$robo$$android_icu_text_BreakIterator$isBoundary(int ), this, n);
    }

    public int getRuleStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getRuleStatus", $$robo$$android_icu_text_BreakIterator$getRuleStatus(), this);
    }

    public int getRuleStatusVec(int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("getRuleStatusVec", $$robo$$android_icu_text_BreakIterator$getRuleStatusVec(int[] ), this, nArray);
    }

    public void setText(String string2) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_BreakIterator$setText(java.lang.String ), this, string2);
    }

    public static BreakIterator getWordInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getWordInstance", $$robo$$android_icu_text_BreakIterator$getWordInstance());
    }

    public static BreakIterator getWordInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getWordInstance", $$robo$$android_icu_text_BreakIterator$getWordInstance(java.util.Locale ), (Locale)locale);
    }

    public static BreakIterator getWordInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getWordInstance", $$robo$$android_icu_text_BreakIterator$getWordInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static BreakIterator getLineInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getLineInstance", $$robo$$android_icu_text_BreakIterator$getLineInstance());
    }

    public static BreakIterator getLineInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getLineInstance", $$robo$$android_icu_text_BreakIterator$getLineInstance(java.util.Locale ), (Locale)locale);
    }

    public static BreakIterator getLineInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getLineInstance", $$robo$$android_icu_text_BreakIterator$getLineInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static BreakIterator getCharacterInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getCharacterInstance", $$robo$$android_icu_text_BreakIterator$getCharacterInstance());
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getCharacterInstance", $$robo$$android_icu_text_BreakIterator$getCharacterInstance(java.util.Locale ), (Locale)locale);
    }

    public static BreakIterator getCharacterInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getCharacterInstance", $$robo$$android_icu_text_BreakIterator$getCharacterInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static BreakIterator getSentenceInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getSentenceInstance", $$robo$$android_icu_text_BreakIterator$getSentenceInstance());
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getSentenceInstance", $$robo$$android_icu_text_BreakIterator$getSentenceInstance(java.util.Locale ), (Locale)locale);
    }

    public static BreakIterator getSentenceInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getSentenceInstance", $$robo$$android_icu_text_BreakIterator$getSentenceInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static BreakIterator getTitleInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getTitleInstance", $$robo$$android_icu_text_BreakIterator$getTitleInstance());
    }

    public static BreakIterator getTitleInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getTitleInstance", $$robo$$android_icu_text_BreakIterator$getTitleInstance(java.util.Locale ), (Locale)locale);
    }

    public static BreakIterator getTitleInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getTitleInstance", $$robo$$android_icu_text_BreakIterator$getTitleInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static Object registerInstance(BreakIterator breakIterator, Locale locale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("registerInstance", $$robo$$android_icu_text_BreakIterator$registerInstance(android.icu.text.BreakIterator java.util.Locale int ), (BreakIterator)breakIterator, (Locale)locale, (int)n);
    }

    public static Object registerInstance(BreakIterator breakIterator, ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("registerInstance", $$robo$$android_icu_text_BreakIterator$registerInstance(android.icu.text.BreakIterator android.icu.util.ULocale int ), (BreakIterator)breakIterator, (ULocale)uLocale, (int)n);
    }

    public static boolean unregister(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unregister", $$robo$$android_icu_text_BreakIterator$unregister(java.lang.Object ), (Object)object);
    }

    @Deprecated
    public static BreakIterator getBreakInstance(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getBreakInstance", $$robo$$android_icu_text_BreakIterator$getBreakInstance(android.icu.util.ULocale int ), (ULocale)uLocale, (int)n);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_text_BreakIterator$getAvailableLocales());
    }

    public static synchronized ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_text_BreakIterator$getAvailableULocales());
    }

    private static BreakIteratorServiceShim getShim() {
        return InvokeDynamicSupport.bootstrapStatic("getShim", $$robo$$android_icu_text_BreakIterator$getShim());
    }

    public ULocale getLocale(ULocale.Type type) {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_BreakIterator$getLocale(android.icu.util.ULocale$Type ), this, type);
    }

    void setLocale(ULocale uLocale, ULocale uLocale2) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_BreakIterator$setLocale(android.icu.util.ULocale android.icu.util.ULocale ), this, uLocale, uLocale2);
    }

    static {
        RobolectricInternals.classInitializing(BreakIterator.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BreakIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class BreakIteratorServiceShim
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_BreakIterator_BreakIteratorServiceShim$__constructor__() {
        }

        public abstract Object registerInstance(BreakIterator var1, ULocale var2, int var3);

        public abstract boolean unregister(Object var1);

        public abstract Locale[] getAvailableLocales();

        public abstract ULocale[] getAvailableULocales();

        public abstract BreakIterator createBreakIterator(ULocale var1, int var2);

        private void __constructor__() {
            this.$$robo$$android_icu_text_BreakIterator_BreakIteratorServiceShim$__constructor__();
        }

        public BreakIteratorServiceShim() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakIterator_BreakIteratorServiceShim$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BreakIteratorServiceShim)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class BreakIteratorCache
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private BreakIterator iter;
        private ULocale where;

        private void $$robo$$android_icu_text_BreakIterator_BreakIteratorCache$__constructor__(ULocale where, BreakIterator iter) {
            this.where = where;
            this.iter = (BreakIterator)iter.clone();
        }

        private final ULocale $$robo$$android_icu_text_BreakIterator_BreakIteratorCache$getLocale() {
            return this.where;
        }

        private final BreakIterator $$robo$$android_icu_text_BreakIterator_BreakIteratorCache$createBreakInstance() {
            return (BreakIterator)this.iter.clone();
        }

        private void __constructor__(ULocale uLocale, BreakIterator breakIterator) {
            this.$$robo$$android_icu_text_BreakIterator_BreakIteratorCache$__constructor__(uLocale, breakIterator);
        }

        public BreakIteratorCache(ULocale uLocale, BreakIterator breakIterator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakIterator_BreakIteratorCache$__constructor__(android.icu.util.ULocale android.icu.text.BreakIterator ), this, uLocale, breakIterator);
        }

        ULocale getLocale() {
            return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_BreakIterator_BreakIteratorCache$getLocale(), this);
        }

        BreakIterator createBreakInstance() {
            return InvokeDynamicSupport.bootstrap("createBreakInstance", $$robo$$android_icu_text_BreakIterator_BreakIteratorCache$createBreakInstance(), this);
        }

        public /* synthetic */ BreakIteratorCache() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BreakIteratorCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

