/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.lang.UCharacter;
import android.icu.text.ArabicShaping;
import android.icu.text.ArabicShapingException;
import android.icu.text.Bidi;
import android.icu.text.UTF16;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BidiTransform
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Bidi bidi;
    private String text;
    private int reorderingOptions;
    private int shapingOptions;

    private void $$robo$$android_icu_text_BidiTransform$__constructor__() {
    }

    private final String $$robo$$android_icu_text_BidiTransform$transform(CharSequence text, byte inParaLevel, Order inOrder, byte outParaLevel, Order outOrder, Mirroring doMirroring, int shapingOptions) {
        if (text == null || inOrder == null || outOrder == null || doMirroring == null) {
            throw new IllegalArgumentException();
        }
        this.text = text.toString();
        byte[] levels = new byte[]{inParaLevel, outParaLevel};
        this.resolveBaseDirection(levels);
        ReorderingScheme currentScheme = this.findMatchingScheme(levels[0], inOrder, levels[1], outOrder);
        if (currentScheme != null) {
            this.bidi = new Bidi();
            this.reorderingOptions = Mirroring.ON.equals((Object)doMirroring) ? 2 : 0;
            this.shapingOptions = shapingOptions & 0xFFFFFFFB;
            currentScheme.doTransform(this);
        }
        return this.text;
    }

    private final void $$robo$$android_icu_text_BidiTransform$resolveBaseDirection(byte[] levels) {
        byte level;
        levels[0] = Bidi.IsDefaultLevel(levels[0]) ? ((level = Bidi.getBaseDirection(this.text)) != 3 ? level : (levels[0] == 127 ? (byte)1 : 0)) : (byte)(levels[0] & 1);
        levels[1] = Bidi.IsDefaultLevel(levels[1]) ? levels[0] : (byte)(levels[1] & 1);
    }

    private final ReorderingScheme $$robo$$android_icu_text_BidiTransform$findMatchingScheme(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
        for (ReorderingScheme scheme : ReorderingScheme.values()) {
            if (!scheme.matches(inLevel, inOrder, outLevel, outOrder)) continue;
            return scheme;
        }
        return null;
    }

    private final void $$robo$$android_icu_text_BidiTransform$resolve(byte level, int options) {
        this.bidi.setInverse((options & 5) != 0);
        this.bidi.setReorderingMode(options);
        this.bidi.setPara(this.text, level, null);
    }

    private final void $$robo$$android_icu_text_BidiTransform$reorder() {
        this.text = this.bidi.writeReordered(this.reorderingOptions);
        this.reorderingOptions = 0;
    }

    private final void $$robo$$android_icu_text_BidiTransform$reverse() {
        this.text = Bidi.writeReverse(this.text, 0);
    }

    private final void $$robo$$android_icu_text_BidiTransform$mirror() {
        int ch;
        if ((this.reorderingOptions & 2) == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer(this.text);
        byte[] levels = this.bidi.getLevels();
        int n = levels.length;
        for (int i = 0; i < n; i += UTF16.getCharCount(ch)) {
            ch = UTF16.charAt(sb, i);
            if ((levels[i] & 1) == 0) continue;
            UTF16.setCharAt(sb, i, UCharacter.getMirror(ch));
        }
        this.text = sb.toString();
        this.reorderingOptions &= 0xFFFFFFFD;
    }

    private final void $$robo$$android_icu_text_BidiTransform$shapeArabic(int digitsDir, int lettersDir) {
        if (digitsDir == lettersDir) {
            this.shapeArabic(this.shapingOptions | digitsDir);
        } else {
            this.shapeArabic(this.shapingOptions & 0xFFFFFFE7 | digitsDir);
            this.shapeArabic(this.shapingOptions & 0xFFFFFF1F | lettersDir);
        }
    }

    private final void $$robo$$android_icu_text_BidiTransform$shapeArabic(int options) {
        if (options != 0) {
            ArabicShaping shaper = new ArabicShaping(options);
            try {
                this.text = shaper.shape(this.text);
            }
            catch (ArabicShapingException arabicShapingException) {
                // empty catch block
            }
        }
    }

    private static final boolean $$robo$$android_icu_text_BidiTransform$IsLTR(byte level) {
        return (level & 1) == 0;
    }

    private static final boolean $$robo$$android_icu_text_BidiTransform$IsRTL(byte level) {
        return (level & 1) == 1;
    }

    private static final boolean $$robo$$android_icu_text_BidiTransform$IsLogical(Order order) {
        return Order.LOGICAL.equals((Object)order);
    }

    private static final boolean $$robo$$android_icu_text_BidiTransform$IsVisual(Order order) {
        return Order.VISUAL.equals((Object)order);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_BidiTransform$__constructor__();
    }

    public BidiTransform() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform$__constructor__(), this);
    }

    public String transform(CharSequence charSequence, byte by, Order order, byte by2, Order order2, Mirroring mirroring, int n) {
        return InvokeDynamicSupport.bootstrap("transform", $$robo$$android_icu_text_BidiTransform$transform(java.lang.CharSequence byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order android.icu.text.BidiTransform$Mirroring int ), this, charSequence, by, order, by2, order2, mirroring, n);
    }

    private void resolveBaseDirection(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("resolveBaseDirection", $$robo$$android_icu_text_BidiTransform$resolveBaseDirection(byte[] ), this, byArray);
    }

    private ReorderingScheme findMatchingScheme(byte by, Order order, byte by2, Order order2) {
        return InvokeDynamicSupport.bootstrap("findMatchingScheme", $$robo$$android_icu_text_BidiTransform$findMatchingScheme(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
    }

    private void resolve(byte by, int n) {
        InvokeDynamicSupport.bootstrap("resolve", $$robo$$android_icu_text_BidiTransform$resolve(byte int ), this, by, n);
    }

    private void reorder() {
        InvokeDynamicSupport.bootstrap("reorder", $$robo$$android_icu_text_BidiTransform$reorder(), this);
    }

    private void reverse() {
        InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_icu_text_BidiTransform$reverse(), this);
    }

    private void mirror() {
        InvokeDynamicSupport.bootstrap("mirror", $$robo$$android_icu_text_BidiTransform$mirror(), this);
    }

    private void shapeArabic(int n, int n2) {
        InvokeDynamicSupport.bootstrap("shapeArabic", $$robo$$android_icu_text_BidiTransform$shapeArabic(int int ), this, n, n2);
    }

    private void shapeArabic(int n) {
        InvokeDynamicSupport.bootstrap("shapeArabic", $$robo$$android_icu_text_BidiTransform$shapeArabic(int ), this, n);
    }

    private static boolean IsLTR(byte by) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("IsLTR", $$robo$$android_icu_text_BidiTransform$IsLTR(byte ), (byte)by);
    }

    private static boolean IsRTL(byte by) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("IsRTL", $$robo$$android_icu_text_BidiTransform$IsRTL(byte ), (byte)by);
    }

    private static boolean IsLogical(Order order) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("IsLogical", $$robo$$android_icu_text_BidiTransform$IsLogical(android.icu.text.BidiTransform$Order ), (Order)order);
    }

    private static boolean IsVisual(Order order) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("IsVisual", $$robo$$android_icu_text_BidiTransform$IsVisual(android.icu.text.BidiTransform$Order ), (Order)order);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BidiTransform)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static abstract class ReorderingScheme
    extends Enum<ReorderingScheme> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ ReorderingScheme LOG_LTR_TO_VIS_LTR;
        public static /* enum */ ReorderingScheme LOG_RTL_TO_VIS_LTR;
        public static /* enum */ ReorderingScheme LOG_LTR_TO_VIS_RTL;
        public static /* enum */ ReorderingScheme LOG_RTL_TO_VIS_RTL;
        public static /* enum */ ReorderingScheme VIS_LTR_TO_LOG_RTL;
        public static /* enum */ ReorderingScheme VIS_RTL_TO_LOG_RTL;
        public static /* enum */ ReorderingScheme VIS_LTR_TO_LOG_LTR;
        public static /* enum */ ReorderingScheme VIS_RTL_TO_LOG_LTR;
        public static /* enum */ ReorderingScheme LOG_LTR_TO_LOG_RTL;
        public static /* enum */ ReorderingScheme LOG_RTL_TO_LOG_LTR;
        public static /* enum */ ReorderingScheme VIS_LTR_TO_VIS_RTL;
        public static /* enum */ ReorderingScheme VIS_RTL_TO_VIS_LTR;
        public static /* enum */ ReorderingScheme LOG_LTR_TO_LOG_LTR;
        public static /* enum */ ReorderingScheme LOG_RTL_TO_LOG_RTL;
        public static /* enum */ ReorderingScheme VIS_LTR_TO_VIS_LTR;
        public static /* enum */ ReorderingScheme VIS_RTL_TO_VIS_RTL;
        private static /* synthetic */ ReorderingScheme[] $VALUES;

        private static final ReorderingScheme[] $$robo$$android_icu_text_BidiTransform_ReorderingScheme$values() {
            return (ReorderingScheme[])$VALUES.clone();
        }

        private static final ReorderingScheme $$robo$$android_icu_text_BidiTransform_ReorderingScheme$valueOf(String name) {
            return Enum.valueOf(ReorderingScheme.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme$__constructor__(String string2, int n) {
        }

        abstract boolean matches(byte var1, Order var2, byte var3, Order var4);

        abstract void doTransform(BidiTransform var1);

        private /* synthetic */ void $$robo$$android_icu_text_BidiTransform_ReorderingScheme$__constructor__(String x0, int x1, 1 x2) {
        }

        static void __staticInitializer__() {
            LOG_LTR_TO_VIS_LTR = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_1$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_1$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsLTR(inLevel) && BidiTransform.IsLogical(inOrder) && BidiTransform.IsLTR(outLevel) && BidiTransform.IsVisual(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_1$doTransform(BidiTransform transform) {
                    transform.shapeArabic(0, 0);
                    transform.resolve((byte)0, 0);
                    transform.reorder();
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_1$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_1$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_1$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_1$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            LOG_RTL_TO_VIS_LTR = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_2$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_2$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsRTL(inLevel) && BidiTransform.IsLogical(inOrder) && BidiTransform.IsLTR(outLevel) && BidiTransform.IsVisual(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_2$doTransform(BidiTransform transform) {
                    transform.resolve((byte)1, 0);
                    transform.reorder();
                    transform.shapeArabic(0, 4);
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_2$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_2$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_2$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_2$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            LOG_LTR_TO_VIS_RTL = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_3$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_3$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsLTR(inLevel) && BidiTransform.IsLogical(inOrder) && BidiTransform.IsRTL(outLevel) && BidiTransform.IsVisual(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_3$doTransform(BidiTransform transform) {
                    transform.shapeArabic(0, 0);
                    transform.resolve((byte)0, 0);
                    transform.reorder();
                    transform.reverse();
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_3$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_3$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_3$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_3$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            LOG_RTL_TO_VIS_RTL = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_4$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_4$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsRTL(inLevel) && BidiTransform.IsLogical(inOrder) && BidiTransform.IsRTL(outLevel) && BidiTransform.IsVisual(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_4$doTransform(BidiTransform transform) {
                    transform.resolve((byte)1, 0);
                    transform.reorder();
                    transform.shapeArabic(0, 4);
                    transform.reverse();
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_4$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_4$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_4$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_4$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            VIS_LTR_TO_LOG_RTL = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_5$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_5$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsLTR(inLevel) && BidiTransform.IsVisual(inOrder) && BidiTransform.IsRTL(outLevel) && BidiTransform.IsLogical(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_5$doTransform(BidiTransform transform) {
                    transform.shapeArabic(0, 4);
                    transform.resolve((byte)1, 5);
                    transform.reorder();
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_5$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_5$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_5$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_5$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            VIS_RTL_TO_LOG_RTL = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_6$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_6$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsRTL(inLevel) && BidiTransform.IsVisual(inOrder) && BidiTransform.IsRTL(outLevel) && BidiTransform.IsLogical(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_6$doTransform(BidiTransform transform) {
                    transform.reverse();
                    transform.shapeArabic(0, 4);
                    transform.resolve((byte)1, 5);
                    transform.reorder();
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_6$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_6$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_6$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_6$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            VIS_LTR_TO_LOG_LTR = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_7$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_7$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsLTR(inLevel) && BidiTransform.IsVisual(inOrder) && BidiTransform.IsLTR(outLevel) && BidiTransform.IsLogical(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_7$doTransform(BidiTransform transform) {
                    transform.resolve((byte)0, 5);
                    transform.reorder();
                    transform.shapeArabic(0, 0);
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_7$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_7$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_7$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_7$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            VIS_RTL_TO_LOG_LTR = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_8$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_8$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsRTL(inLevel) && BidiTransform.IsVisual(inOrder) && BidiTransform.IsLTR(outLevel) && BidiTransform.IsLogical(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_8$doTransform(BidiTransform transform) {
                    transform.reverse();
                    transform.resolve((byte)0, 5);
                    transform.reorder();
                    transform.shapeArabic(0, 0);
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_8$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_8$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_8$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_8$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            LOG_LTR_TO_LOG_RTL = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_9$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_9$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsLTR(inLevel) && BidiTransform.IsLogical(inOrder) && BidiTransform.IsRTL(outLevel) && BidiTransform.IsLogical(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_9$doTransform(BidiTransform transform) {
                    transform.shapeArabic(0, 0);
                    transform.resolve((byte)0, 0);
                    transform.mirror();
                    transform.resolve((byte)0, 3);
                    transform.reorder();
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_9$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_9$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_9$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_9$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            LOG_RTL_TO_LOG_LTR = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_10$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_10$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsRTL(inLevel) && BidiTransform.IsLogical(inOrder) && BidiTransform.IsLTR(outLevel) && BidiTransform.IsLogical(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_10$doTransform(BidiTransform transform) {
                    transform.resolve((byte)1, 0);
                    transform.mirror();
                    transform.resolve((byte)1, 3);
                    transform.reorder();
                    transform.shapeArabic(0, 0);
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_10$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_10$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_10$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_10$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            VIS_LTR_TO_VIS_RTL = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_11$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_11$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsLTR(inLevel) && BidiTransform.IsVisual(inOrder) && BidiTransform.IsRTL(outLevel) && BidiTransform.IsVisual(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_11$doTransform(BidiTransform transform) {
                    transform.resolve((byte)0, 0);
                    transform.mirror();
                    transform.shapeArabic(0, 4);
                    transform.reverse();
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_11$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_11$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_11$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_11$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            VIS_RTL_TO_VIS_LTR = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_12$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_12$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsRTL(inLevel) && BidiTransform.IsVisual(inOrder) && BidiTransform.IsLTR(outLevel) && BidiTransform.IsVisual(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_12$doTransform(BidiTransform transform) {
                    transform.reverse();
                    transform.resolve((byte)0, 0);
                    transform.mirror();
                    transform.shapeArabic(0, 4);
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_12$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_12$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_12$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_12$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            LOG_LTR_TO_LOG_LTR = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_13$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_13$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsLTR(inLevel) && BidiTransform.IsLogical(inOrder) && BidiTransform.IsLTR(outLevel) && BidiTransform.IsLogical(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_13$doTransform(BidiTransform transform) {
                    transform.resolve((byte)0, 0);
                    transform.mirror();
                    transform.shapeArabic(0, 0);
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_13$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_13$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_13$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_13$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            LOG_RTL_TO_LOG_RTL = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_14$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_14$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsRTL(inLevel) && BidiTransform.IsLogical(inOrder) && BidiTransform.IsRTL(outLevel) && BidiTransform.IsLogical(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_14$doTransform(BidiTransform transform) {
                    transform.resolve((byte)1, 0);
                    transform.mirror();
                    transform.shapeArabic(4, 0);
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_14$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_14$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_14$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_14$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            VIS_LTR_TO_VIS_LTR = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_15$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_15$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsLTR(inLevel) && BidiTransform.IsVisual(inOrder) && BidiTransform.IsLTR(outLevel) && BidiTransform.IsVisual(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_15$doTransform(BidiTransform transform) {
                    transform.resolve((byte)0, 0);
                    transform.mirror();
                    transform.shapeArabic(0, 4);
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_15$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_15$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_15$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_15$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            VIS_RTL_TO_VIS_RTL = new ShadowedObject(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_16$__constructor__(String string2, int n) {
                }

                private final boolean $$robo$$android_icu_text_BidiTransform_ReorderingScheme_16$matches(byte inLevel, Order inOrder, byte outLevel, Order outOrder) {
                    return BidiTransform.IsRTL(inLevel) && BidiTransform.IsVisual(inOrder) && BidiTransform.IsRTL(outLevel) && BidiTransform.IsVisual(outOrder);
                }

                private final void $$robo$$android_icu_text_BidiTransform_ReorderingScheme_16$doTransform(BidiTransform transform) {
                    transform.reverse();
                    transform.resolve((byte)0, 0);
                    transform.mirror();
                    transform.shapeArabic(0, 4);
                    transform.reverse();
                }

                @Override
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme_16$__constructor__(string2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_16$__constructor__(java.lang.String int ), this, string2, n);
                }

                @Override
                boolean matches(byte by, Order order, byte by2, Order order2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_16$matches(byte android.icu.text.BidiTransform$Order byte android.icu.text.BidiTransform$Order ), this, by, order, by2, order2);
                }

                @Override
                void doTransform(BidiTransform bidiTransform) {
                    InvokeDynamicSupport.bootstrap("doTransform", $$robo$$android_icu_text_BidiTransform_ReorderingScheme_16$doTransform(android.icu.text.BidiTransform ), this, bidiTransform);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            $VALUES = new ReorderingScheme[]{LOG_LTR_TO_VIS_LTR, LOG_RTL_TO_VIS_LTR, LOG_LTR_TO_VIS_RTL, LOG_RTL_TO_VIS_RTL, VIS_LTR_TO_LOG_RTL, VIS_RTL_TO_LOG_RTL, VIS_LTR_TO_LOG_LTR, VIS_RTL_TO_LOG_LTR, LOG_LTR_TO_LOG_RTL, LOG_RTL_TO_LOG_LTR, VIS_LTR_TO_VIS_RTL, VIS_RTL_TO_VIS_LTR, LOG_LTR_TO_LOG_LTR, LOG_RTL_TO_LOG_RTL, VIS_LTR_TO_VIS_LTR, VIS_RTL_TO_VIS_RTL};
        }

        public static ReorderingScheme[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_BidiTransform_ReorderingScheme$values());
        }

        public static ReorderingScheme valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_BidiTransform_ReorderingScheme$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme$__constructor__(string2, n);
        }

        public ReorderingScheme() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme$__constructor__(java.lang.String int ), this, string2, n);
        }

        private /* synthetic */ void __constructor__(String string2, int n, 1 var3_3) {
            this.$$robo$$android_icu_text_BidiTransform_ReorderingScheme$__constructor__(string2, n, var3_3);
        }

        public /* synthetic */ ReorderingScheme(String string2, int n, 1 var3_3) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_ReorderingScheme$__constructor__(java.lang.String int android.icu.text.BidiTransform$1 ), this, string2, n, var3_3);
        }

        static {
            RobolectricInternals.classInitializing(ReorderingScheme.class);
        }

        public /* synthetic */ ReorderingScheme() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReorderingScheme)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Mirroring
    extends Enum<Mirroring> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Mirroring OFF;
        public static /* enum */ Mirroring ON;
        private static /* synthetic */ Mirroring[] $VALUES;

        private static final Mirroring[] $$robo$$android_icu_text_BidiTransform_Mirroring$values() {
            return (Mirroring[])$VALUES.clone();
        }

        private static final Mirroring $$robo$$android_icu_text_BidiTransform_Mirroring$valueOf(String name) {
            return Enum.valueOf(Mirroring.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_BidiTransform_Mirroring$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            OFF = new Mirroring();
            ON = new Mirroring();
            $VALUES = new Mirroring[]{OFF, ON};
        }

        public static Mirroring[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_BidiTransform_Mirroring$values());
        }

        public static Mirroring valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_BidiTransform_Mirroring$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_BidiTransform_Mirroring$__constructor__(string2, n);
        }

        public Mirroring() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_Mirroring$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Mirroring.class);
        }

        public /* synthetic */ Mirroring() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Mirroring)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Order
    extends Enum<Order> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Order LOGICAL;
        public static /* enum */ Order VISUAL;
        private static /* synthetic */ Order[] $VALUES;

        private static final Order[] $$robo$$android_icu_text_BidiTransform_Order$values() {
            return (Order[])$VALUES.clone();
        }

        private static final Order $$robo$$android_icu_text_BidiTransform_Order$valueOf(String name) {
            return Enum.valueOf(Order.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_BidiTransform_Order$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            LOGICAL = new Order();
            VISUAL = new Order();
            $VALUES = new Order[]{LOGICAL, VISUAL};
        }

        public static Order[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_BidiTransform_Order$values());
        }

        public static Order valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_BidiTransform_Order$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_BidiTransform_Order$__constructor__(string2, n);
        }

        public Order() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BidiTransform_Order$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Order.class);
        }

        public /* synthetic */ Order() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Order)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

