/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.data;

import android.icu.impl.ICUData;
import android.icu.impl.PatternProps;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResourceReader
implements Closeable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private BufferedReader reader;
    private String resourceName;
    private String encoding;
    private Class<?> root;
    private int lineNo;

    private void $$robo$$android_icu_impl_data_ResourceReader$__constructor__(String resourceName, String encoding) throws UnsupportedEncodingException {
    }

    private void $$robo$$android_icu_impl_data_ResourceReader$__constructor__(String resourceName) {
    }

    private void $$robo$$android_icu_impl_data_ResourceReader$__constructor__(Class<?> rootClass, String resourceName, String encoding) throws UnsupportedEncodingException {
        this.reader = null;
        this.root = rootClass;
        this.resourceName = resourceName;
        this.encoding = encoding;
        this.lineNo = -1;
        this._reset();
    }

    private void $$robo$$android_icu_impl_data_ResourceReader$__constructor__(InputStream is, String resourceName, String encoding) {
        this.reader = null;
        this.root = null;
        this.resourceName = resourceName;
        this.encoding = encoding;
        this.lineNo = -1;
        try {
            InputStreamReader isr = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
            this.reader = new BufferedReader(isr);
            this.lineNo = 0;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void $$robo$$android_icu_impl_data_ResourceReader$__constructor__(InputStream is, String resourceName) {
    }

    private void $$robo$$android_icu_impl_data_ResourceReader$__constructor__(Class<?> rootClass, String resourceName) {
        this.reader = null;
        this.root = rootClass;
        this.resourceName = resourceName;
        this.encoding = null;
        this.lineNo = -1;
        try {
            this._reset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private final String $$robo$$android_icu_impl_data_ResourceReader$readLine() throws IOException {
        if (this.lineNo == 0) {
            ++this.lineNo;
            String line = this.reader.readLine();
            if (line != null && (line.charAt(0) == '\uffef' || line.charAt(0) == '\ufeff')) {
                line = line.substring(1);
            }
            return line;
        }
        ++this.lineNo;
        return this.reader.readLine();
    }

    private final String $$robo$$android_icu_impl_data_ResourceReader$readLineSkippingComments(boolean trim) throws IOException {
        String line;
        int pos;
        do {
            if ((line = this.readLine()) != null) continue;
            return line;
        } while ((pos = PatternProps.skipWhiteSpace(line, 0)) == line.length() || line.charAt(pos) == '#');
        if (trim) {
            line = line.substring(pos);
        }
        return line;
    }

    private final String $$robo$$android_icu_impl_data_ResourceReader$readLineSkippingComments() throws IOException {
        return this.readLineSkippingComments(false);
    }

    private final int $$robo$$android_icu_impl_data_ResourceReader$getLineNumber() {
        return this.lineNo;
    }

    private final String $$robo$$android_icu_impl_data_ResourceReader$describePosition() {
        return this.resourceName + ':' + this.lineNo;
    }

    private final void $$robo$$android_icu_impl_data_ResourceReader$reset() {
        try {
            this._reset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_icu_impl_data_ResourceReader$_reset() throws UnsupportedEncodingException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.lineNo == 0) {
            return;
        }
        InputStream is = ICUData.getStream(this.root, this.resourceName);
        if (is == null) {
            throw new IllegalArgumentException("Can't open " + this.resourceName);
        }
        InputStreamReader isr = this.encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.encoding);
        this.reader = new BufferedReader(isr);
        this.lineNo = 0;
    }

    private final void $$robo$$android_icu_impl_data_ResourceReader$close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private void __constructor__(String string2, String string3) throws UnsupportedEncodingException {
        this.$$robo$$android_icu_impl_data_ResourceReader$__constructor__(string2, string3);
    }

    public ResourceReader(String string2, String string3) throws UnsupportedEncodingException {
        this(ICUData.class, "data/" + string2, string3);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_data_ResourceReader$__constructor__(java.lang.String java.lang.String ), this, string2, string3);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_impl_data_ResourceReader$__constructor__(string2);
    }

    public ResourceReader(String string2) {
        this(ICUData.class, "data/" + string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_data_ResourceReader$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__(Class<?> clazz, String string2, String string3) throws UnsupportedEncodingException {
        this.$$robo$$android_icu_impl_data_ResourceReader$__constructor__(clazz, string2, string3);
    }

    public ResourceReader(Class<?> clazz, String string2, String string3) throws UnsupportedEncodingException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_data_ResourceReader$__constructor__(java.lang.Class<?> java.lang.String java.lang.String ), this, clazz, string2, string3);
    }

    private void __constructor__(InputStream inputStream, String string2, String string3) {
        this.$$robo$$android_icu_impl_data_ResourceReader$__constructor__(inputStream, string2, string3);
    }

    public ResourceReader(InputStream inputStream, String string2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_data_ResourceReader$__constructor__(java.io.InputStream java.lang.String java.lang.String ), this, inputStream, string2, string3);
    }

    private void __constructor__(InputStream inputStream, String string2) {
        this.$$robo$$android_icu_impl_data_ResourceReader$__constructor__(inputStream, string2);
    }

    public ResourceReader(InputStream inputStream, String string2) {
        this(inputStream, string2, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_data_ResourceReader$__constructor__(java.io.InputStream java.lang.String ), this, inputStream, string2);
    }

    private void __constructor__(Class<?> clazz, String string2) {
        this.$$robo$$android_icu_impl_data_ResourceReader$__constructor__(clazz, string2);
    }

    public ResourceReader(Class<?> clazz, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_data_ResourceReader$__constructor__(java.lang.Class<?> java.lang.String ), this, clazz, string2);
    }

    public String readLine() throws IOException {
        return InvokeDynamicSupport.bootstrap("readLine", $$robo$$android_icu_impl_data_ResourceReader$readLine(), this);
    }

    public String readLineSkippingComments(boolean bl) throws IOException {
        return InvokeDynamicSupport.bootstrap("readLineSkippingComments", $$robo$$android_icu_impl_data_ResourceReader$readLineSkippingComments(boolean ), this, bl);
    }

    public String readLineSkippingComments() throws IOException {
        return InvokeDynamicSupport.bootstrap("readLineSkippingComments", $$robo$$android_icu_impl_data_ResourceReader$readLineSkippingComments(), this);
    }

    public int getLineNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getLineNumber", $$robo$$android_icu_impl_data_ResourceReader$getLineNumber(), this);
    }

    public String describePosition() {
        return InvokeDynamicSupport.bootstrap("describePosition", $$robo$$android_icu_impl_data_ResourceReader$describePosition(), this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_impl_data_ResourceReader$reset(), this);
    }

    private void _reset() throws UnsupportedEncodingException {
        InvokeDynamicSupport.bootstrap("_reset", $$robo$$android_icu_impl_data_ResourceReader$_reset(), this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_icu_impl_data_ResourceReader$close(), this);
    }

    public /* synthetic */ ResourceReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

