/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.OlsonTimeZone;
import android.icu.impl.SimpleCache;
import android.icu.impl.SoftCache;
import android.icu.text.NumberFormat;
import android.icu.util.Output;
import android.icu.util.SimpleTimeZone;
import android.icu.util.TimeZone;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.SoftReference;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ZoneMeta
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean ASSERT = false;
    private static String ZONEINFORESNAME = "zoneinfo64";
    private static String kREGIONS = "Regions";
    private static String kZONES = "Zones";
    private static String kNAMES = "Names";
    private static String kGMT_ID = "GMT";
    private static String kCUSTOM_TZ_PREFIX = "GMT";
    private static String kWorld = "001";
    private static SoftReference<Set<String>> REF_SYSTEM_ZONES;
    private static SoftReference<Set<String>> REF_CANONICAL_SYSTEM_ZONES;
    private static SoftReference<Set<String>> REF_CANONICAL_SYSTEM_LOCATION_ZONES;
    private static String[] ZONEIDS;
    private static ICUCache<String, String> CANONICAL_ID_CACHE;
    private static ICUCache<String, String> REGION_CACHE;
    private static ICUCache<String, Boolean> SINGLE_COUNTRY_CACHE;
    private static SystemTimeZoneCache SYSTEM_ZONE_CACHE;
    private static int kMAX_CUSTOM_HOUR = 23;
    private static int kMAX_CUSTOM_MIN = 59;
    private static int kMAX_CUSTOM_SEC = 59;
    private static CustomTimeZoneCache CUSTOM_ZONE_CACHE;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_ZoneMeta$__constructor__() {
    }

    private static final synchronized Set<String> $$robo$$android_icu_impl_ZoneMeta$getSystemZIDs() {
        Set<String> systemZones = null;
        if (REF_SYSTEM_ZONES != null) {
            systemZones = REF_SYSTEM_ZONES.get();
        }
        if (systemZones == null) {
            String[] allIDs;
            TreeSet<String> systemIDs = new TreeSet<String>();
            for (String id2 : allIDs = ZoneMeta.getZoneIDs()) {
                if (id2.equals("Etc/Unknown")) continue;
                systemIDs.add(id2);
            }
            systemZones = Collections.unmodifiableSet(systemIDs);
            REF_SYSTEM_ZONES = new SoftReference<Set<String>>(systemZones);
        }
        return systemZones;
    }

    private static final synchronized Set<String> $$robo$$android_icu_impl_ZoneMeta$getCanonicalSystemZIDs() {
        Set<String> canonicalSystemZones = null;
        if (REF_CANONICAL_SYSTEM_ZONES != null) {
            canonicalSystemZones = REF_CANONICAL_SYSTEM_ZONES.get();
        }
        if (canonicalSystemZones == null) {
            String[] allIDs;
            TreeSet<String> canonicalSystemIDs = new TreeSet<String>();
            for (String id2 : allIDs = ZoneMeta.getZoneIDs()) {
                String canonicalID;
                if (id2.equals("Etc/Unknown") || !id2.equals(canonicalID = ZoneMeta.getCanonicalCLDRID(id2))) continue;
                canonicalSystemIDs.add(id2);
            }
            canonicalSystemZones = Collections.unmodifiableSet(canonicalSystemIDs);
            REF_CANONICAL_SYSTEM_ZONES = new SoftReference<Set<String>>(canonicalSystemZones);
        }
        return canonicalSystemZones;
    }

    private static final synchronized Set<String> $$robo$$android_icu_impl_ZoneMeta$getCanonicalSystemLocationZIDs() {
        Set<String> canonicalSystemLocationZones = null;
        if (REF_CANONICAL_SYSTEM_LOCATION_ZONES != null) {
            canonicalSystemLocationZones = REF_CANONICAL_SYSTEM_LOCATION_ZONES.get();
        }
        if (canonicalSystemLocationZones == null) {
            String[] allIDs;
            TreeSet<String> canonicalSystemLocationIDs = new TreeSet<String>();
            for (String id2 : allIDs = ZoneMeta.getZoneIDs()) {
                String region;
                String canonicalID;
                if (id2.equals("Etc/Unknown") || !id2.equals(canonicalID = ZoneMeta.getCanonicalCLDRID(id2)) || (region = ZoneMeta.getRegion(id2)) == null || region.equals("001")) continue;
                canonicalSystemLocationIDs.add(id2);
            }
            canonicalSystemLocationZones = Collections.unmodifiableSet(canonicalSystemLocationIDs);
            REF_CANONICAL_SYSTEM_LOCATION_ZONES = new SoftReference<Set<String>>(canonicalSystemLocationZones);
        }
        return canonicalSystemLocationZones;
    }

    private static final Set<String> $$robo$$android_icu_impl_ZoneMeta$getAvailableIDs(TimeZone.SystemTimeZoneType type, String region, Integer rawOffset) {
        Set<String> baseSet = null;
        switch (1.$SwitchMap$android$icu$util$TimeZone$SystemTimeZoneType[type.ordinal()]) {
            case 1: {
                baseSet = ZoneMeta.getSystemZIDs();
                break;
            }
            case 2: {
                baseSet = ZoneMeta.getCanonicalSystemZIDs();
                break;
            }
            case 3: {
                baseSet = ZoneMeta.getCanonicalSystemLocationZIDs();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SystemTimeZoneType");
            }
        }
        if (region == null && rawOffset == null) {
            return baseSet;
        }
        if (region != null) {
            region = region.toUpperCase(Locale.ENGLISH);
        }
        TreeSet<String> result = new TreeSet<String>();
        for (String id2 : baseSet) {
            OlsonTimeZone z;
            String r;
            if (region != null && !region.equals(r = ZoneMeta.getRegion(id2)) || rawOffset != null && ((z = ZoneMeta.getSystemTimeZone(id2)) == null || !rawOffset.equals(((TimeZone)z).getRawOffset()))) continue;
            result.add(id2);
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    private static final synchronized int $$robo$$android_icu_impl_ZoneMeta$countEquivalentIDs(String id2) {
        int count = 0;
        UResourceBundle res = ZoneMeta.openOlsonResource(null, id2);
        if (res != null) {
            try {
                UResourceBundle links = res.get("links");
                int[] v = links.getIntVector();
                count = v.length;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return count;
    }

    private static final synchronized String $$robo$$android_icu_impl_ZoneMeta$getEquivalentID(String id2, int index) {
        UResourceBundle res;
        String result = "";
        if (index >= 0 && (res = ZoneMeta.openOlsonResource(null, id2)) != null) {
            String tmp;
            int zoneIdx = -1;
            try {
                UResourceBundle links = res.get("links");
                int[] zones = links.getIntVector();
                if (index < zones.length) {
                    zoneIdx = zones[index];
                }
            }
            catch (MissingResourceException links) {
                // empty catch block
            }
            if (zoneIdx >= 0 && (tmp = ZoneMeta.getZoneID(zoneIdx)) != null) {
                result = tmp;
            }
        }
        return result;
    }

    private static final synchronized String[] $$robo$$android_icu_impl_ZoneMeta$getZoneIDs() {
        if (ZONEIDS == null) {
            try {
                UResourceBundle top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "zoneinfo64", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                ZONEIDS = top.getStringArray("Names");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (ZONEIDS == null) {
            ZONEIDS = new String[0];
        }
        return ZONEIDS;
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getZoneID(int idx) {
        String[] ids;
        if (idx >= 0 && idx < (ids = ZoneMeta.getZoneIDs()).length) {
            return ids[idx];
        }
        return null;
    }

    private static final int $$robo$$android_icu_impl_ZoneMeta$getZoneIndex(String zid) {
        int zoneIdx = -1;
        String[] all = ZoneMeta.getZoneIDs();
        if (all.length > 0) {
            int mid;
            int start = 0;
            int limit = all.length;
            int lastMid = Integer.MAX_VALUE;
            while (lastMid != (mid = (start + limit) / 2)) {
                lastMid = mid;
                int r = zid.compareTo(all[mid]);
                if (r == 0) {
                    zoneIdx = mid;
                    break;
                }
                if (r < 0) {
                    limit = mid;
                    continue;
                }
                start = mid;
            }
        }
        return zoneIdx;
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getCanonicalCLDRID(TimeZone tz) {
        if (tz instanceof OlsonTimeZone) {
            return ((OlsonTimeZone)tz).getCanonicalID();
        }
        return ZoneMeta.getCanonicalCLDRID(tz.getID());
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getCanonicalCLDRID(String tzid) {
        String canonical = CANONICAL_ID_CACHE.get(tzid);
        if (canonical == null) {
            canonical = ZoneMeta.findCLDRCanonicalID(tzid);
            if (canonical == null) {
                try {
                    int zoneIdx = ZoneMeta.getZoneIndex(tzid);
                    if (zoneIdx >= 0) {
                        UResourceBundle top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "zoneinfo64", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                        UResourceBundle zones = top.get("Zones");
                        UResourceBundle zone = zones.get(zoneIdx);
                        if (zone.getType() == 7) {
                            tzid = ZoneMeta.getZoneID(zone.getInt());
                            canonical = ZoneMeta.findCLDRCanonicalID(tzid);
                        }
                        if (canonical == null) {
                            canonical = tzid;
                        }
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (canonical != null) {
                CANONICAL_ID_CACHE.put(tzid, canonical);
            }
        }
        return canonical;
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$findCLDRCanonicalID(String tzid) {
        String canonical = null;
        String tzidKey = tzid.replace('/', ':');
        try {
            UResourceBundle keyTypeData = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle typeMap = keyTypeData.get("typeMap");
            UResourceBundle typeKeys = typeMap.get("timezone");
            try {
                typeKeys.get(tzidKey);
                canonical = tzid;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (canonical == null) {
                UResourceBundle typeAlias = keyTypeData.get("typeAlias");
                UResourceBundle aliasesForKey = typeAlias.get("timezone");
                canonical = aliasesForKey.getString(tzidKey);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return canonical;
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getRegion(String tzid) {
        int zoneIdx;
        String region = REGION_CACHE.get(tzid);
        if (region == null && (zoneIdx = ZoneMeta.getZoneIndex(tzid)) >= 0) {
            try {
                UResourceBundle top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "zoneinfo64", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle regions = top.get("Regions");
                if (zoneIdx < regions.getSize()) {
                    region = regions.getString(zoneIdx);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (region != null) {
                REGION_CACHE.put(tzid, region);
            }
        }
        return region;
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getCanonicalCountry(String tzid) {
        String country = ZoneMeta.getRegion(tzid);
        if (country != null && country.equals("001")) {
            country = null;
        }
        return country;
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getCanonicalCountry(String tzid, Output<Boolean> isPrimary) {
        isPrimary.value = Boolean.FALSE;
        String country = ZoneMeta.getRegion(tzid);
        if (country != null && country.equals("001")) {
            return null;
        }
        Boolean singleZone = SINGLE_COUNTRY_CACHE.get(tzid);
        if (singleZone == null) {
            Set<String> ids = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL_LOCATION, country, null);
            if (!$assertionsDisabled && ids.size() < 1) {
                throw new AssertionError();
            }
            singleZone = ids.size() <= 1;
            SINGLE_COUNTRY_CACHE.put(tzid, singleZone);
        }
        if (singleZone.booleanValue()) {
            isPrimary.value = Boolean.TRUE;
        } else {
            try {
                UResourceBundle bundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "metaZones");
                UResourceBundle primaryZones = bundle.get("primaryZones");
                String primaryZone = primaryZones.getString(country);
                if (tzid.equals(primaryZone)) {
                    isPrimary.value = Boolean.TRUE;
                } else {
                    String canonicalID = ZoneMeta.getCanonicalCLDRID(tzid);
                    if (canonicalID != null && canonicalID.equals(primaryZone)) {
                        isPrimary.value = Boolean.TRUE;
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return country;
    }

    private static final UResourceBundle $$robo$$android_icu_impl_ZoneMeta$openOlsonResource(UResourceBundle top, String id2) {
        UResourceBundle res = null;
        int zoneIdx = ZoneMeta.getZoneIndex(id2);
        if (zoneIdx >= 0) {
            try {
                UResourceBundle zones;
                UResourceBundle zone;
                if (top == null) {
                    top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "zoneinfo64", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                }
                if ((zone = (zones = top.get("Zones")).get(zoneIdx)).getType() == 7) {
                    zone = zones.get(zone.getInt());
                }
                res = zone;
            }
            catch (MissingResourceException e) {
                res = null;
            }
        }
        return res;
    }

    private static final OlsonTimeZone $$robo$$android_icu_impl_ZoneMeta$getSystemTimeZone(String id2) {
        return (OlsonTimeZone)SYSTEM_ZONE_CACHE.getInstance(id2, id2);
    }

    private static final SimpleTimeZone $$robo$$android_icu_impl_ZoneMeta$getCustomTimeZone(String id2) {
        int[] fields = new int[4];
        if (ZoneMeta.parseCustomID(id2, fields)) {
            Integer key = fields[0] * (fields[1] | fields[2] << 5 | fields[3] << 11);
            return (SimpleTimeZone)CUSTOM_ZONE_CACHE.getInstance(key, fields);
        }
        return null;
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getCustomID(String id2) {
        int[] fields = new int[4];
        if (ZoneMeta.parseCustomID(id2, fields)) {
            return ZoneMeta.formatCustomID(fields[1], fields[2], fields[3], fields[0] < 0);
        }
        return null;
    }

    private static final boolean $$robo$$android_icu_impl_ZoneMeta$parseCustomID(String id2, int[] fields) {
        NumberFormat numberFormat = null;
        if (id2 != null && id2.length() > "GMT".length() && id2.toUpperCase(Locale.ENGLISH).startsWith("GMT")) {
            ParsePosition pos = new ParsePosition("GMT".length());
            int sign = 1;
            int hour = 0;
            int min = 0;
            int sec = 0;
            if (id2.charAt(pos.getIndex()) == '-') {
                sign = -1;
            } else if (id2.charAt(pos.getIndex()) != '+') {
                return false;
            }
            pos.setIndex(pos.getIndex() + 1);
            numberFormat = NumberFormat.getInstance();
            numberFormat.setParseIntegerOnly(true);
            int start = pos.getIndex();
            Number n = numberFormat.parse(id2, pos);
            if (pos.getIndex() == start) {
                return false;
            }
            hour = n.intValue();
            if (pos.getIndex() < id2.length()) {
                if (pos.getIndex() - start > 2 || id2.charAt(pos.getIndex()) != ':') {
                    return false;
                }
                pos.setIndex(pos.getIndex() + 1);
                int oldPos = pos.getIndex();
                n = numberFormat.parse(id2, pos);
                if (pos.getIndex() - oldPos != 2) {
                    return false;
                }
                min = n.intValue();
                if (pos.getIndex() < id2.length()) {
                    if (id2.charAt(pos.getIndex()) != ':') {
                        return false;
                    }
                    pos.setIndex(pos.getIndex() + 1);
                    oldPos = pos.getIndex();
                    n = numberFormat.parse(id2, pos);
                    if (pos.getIndex() != id2.length() || pos.getIndex() - oldPos != 2) {
                        return false;
                    }
                    sec = n.intValue();
                }
            } else {
                int length = pos.getIndex() - start;
                if (length <= 0 || 6 < length) {
                    return false;
                }
                switch (length) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        min = hour % 100;
                        hour /= 100;
                        break;
                    }
                    case 5: 
                    case 6: {
                        sec = hour % 100;
                        min = hour / 100 % 100;
                        hour /= 10000;
                    }
                }
            }
            if (hour <= 23 && min <= 59 && sec <= 59) {
                if (fields != null) {
                    if (fields.length >= 1) {
                        fields[0] = sign;
                    }
                    if (fields.length >= 2) {
                        fields[1] = hour;
                    }
                    if (fields.length >= 3) {
                        fields[2] = min;
                    }
                    if (fields.length >= 4) {
                        fields[3] = sec;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final SimpleTimeZone $$robo$$android_icu_impl_ZoneMeta$getCustomTimeZone(int offset) {
        boolean negative = false;
        int tmp = offset;
        if (offset < 0) {
            negative = true;
            tmp = -offset;
        }
        int sec = (tmp /= 1000) % 60;
        int min = (tmp /= 60) % 60;
        int hour = tmp / 60;
        String zid = ZoneMeta.formatCustomID(hour, min, sec, negative);
        return new SimpleTimeZone(offset, zid);
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$formatCustomID(int hour, int min, int sec, boolean negative) {
        StringBuilder zid = new StringBuilder("GMT");
        if (hour != 0 || min != 0) {
            if (negative) {
                zid.append('-');
            } else {
                zid.append('+');
            }
            if (hour < 10) {
                zid.append('0');
            }
            zid.append(hour);
            zid.append(':');
            if (min < 10) {
                zid.append('0');
            }
            zid.append(min);
            if (sec != 0) {
                zid.append(':');
                if (sec < 10) {
                    zid.append('0');
                }
                zid.append(sec);
            }
        }
        return zid.toString();
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getShortID(TimeZone tz) {
        String canonicalID = null;
        canonicalID = tz instanceof OlsonTimeZone ? ((OlsonTimeZone)tz).getCanonicalID() : ZoneMeta.getCanonicalCLDRID(tz.getID());
        if (canonicalID == null) {
            return null;
        }
        return ZoneMeta.getShortIDFromCanonical(canonicalID);
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getShortID(String id2) {
        String canonicalID = ZoneMeta.getCanonicalCLDRID(id2);
        if (canonicalID == null) {
            return null;
        }
        return ZoneMeta.getShortIDFromCanonical(canonicalID);
    }

    private static final String $$robo$$android_icu_impl_ZoneMeta$getShortIDFromCanonical(String canonicalID) {
        String shortID = null;
        String tzidKey = canonicalID.replace('/', ':');
        try {
            UResourceBundle keyTypeData = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle typeMap = keyTypeData.get("typeMap");
            UResourceBundle typeKeys = typeMap.get("timezone");
            shortID = typeKeys.getString(tzidKey);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return shortID;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !ZoneMeta.class.desiredAssertionStatus();
        ZONEIDS = null;
        CANONICAL_ID_CACHE = new SimpleCache<String, String>();
        REGION_CACHE = new SimpleCache<String, String>();
        SINGLE_COUNTRY_CACHE = new SimpleCache<String, Boolean>();
        SYSTEM_ZONE_CACHE = new SystemTimeZoneCache(null);
        CUSTOM_ZONE_CACHE = new CustomTimeZoneCache(null);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_ZoneMeta$__constructor__();
    }

    public ZoneMeta() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ZoneMeta$__constructor__(), this);
    }

    private static synchronized Set<String> getSystemZIDs() {
        return InvokeDynamicSupport.bootstrapStatic("getSystemZIDs", $$robo$$android_icu_impl_ZoneMeta$getSystemZIDs());
    }

    private static synchronized Set<String> getCanonicalSystemZIDs() {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalSystemZIDs", $$robo$$android_icu_impl_ZoneMeta$getCanonicalSystemZIDs());
    }

    private static synchronized Set<String> getCanonicalSystemLocationZIDs() {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalSystemLocationZIDs", $$robo$$android_icu_impl_ZoneMeta$getCanonicalSystemLocationZIDs());
    }

    public static Set<String> getAvailableIDs(TimeZone.SystemTimeZoneType systemTimeZoneType, String string2, Integer n) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableIDs", $$robo$$android_icu_impl_ZoneMeta$getAvailableIDs(android.icu.util.TimeZone$SystemTimeZoneType java.lang.String java.lang.Integer ), (TimeZone.SystemTimeZoneType)systemTimeZoneType, (String)string2, (Integer)n);
    }

    public static synchronized int countEquivalentIDs(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countEquivalentIDs", $$robo$$android_icu_impl_ZoneMeta$countEquivalentIDs(java.lang.String ), (String)string2);
    }

    public static synchronized String getEquivalentID(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getEquivalentID", $$robo$$android_icu_impl_ZoneMeta$getEquivalentID(java.lang.String int ), (String)string2, (int)n);
    }

    private static synchronized String[] getZoneIDs() {
        return InvokeDynamicSupport.bootstrapStatic("getZoneIDs", $$robo$$android_icu_impl_ZoneMeta$getZoneIDs());
    }

    private static String getZoneID(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getZoneID", $$robo$$android_icu_impl_ZoneMeta$getZoneID(int ), (int)n);
    }

    private static int getZoneIndex(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getZoneIndex", $$robo$$android_icu_impl_ZoneMeta$getZoneIndex(java.lang.String ), (String)string2);
    }

    public static String getCanonicalCLDRID(TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalCLDRID", $$robo$$android_icu_impl_ZoneMeta$getCanonicalCLDRID(android.icu.util.TimeZone ), (TimeZone)timeZone);
    }

    public static String getCanonicalCLDRID(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalCLDRID", $$robo$$android_icu_impl_ZoneMeta$getCanonicalCLDRID(java.lang.String ), (String)string2);
    }

    private static String findCLDRCanonicalID(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findCLDRCanonicalID", $$robo$$android_icu_impl_ZoneMeta$findCLDRCanonicalID(java.lang.String ), (String)string2);
    }

    public static String getRegion(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getRegion", $$robo$$android_icu_impl_ZoneMeta$getRegion(java.lang.String ), (String)string2);
    }

    public static String getCanonicalCountry(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalCountry", $$robo$$android_icu_impl_ZoneMeta$getCanonicalCountry(java.lang.String ), (String)string2);
    }

    public static String getCanonicalCountry(String string2, Output<Boolean> output) {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalCountry", $$robo$$android_icu_impl_ZoneMeta$getCanonicalCountry(java.lang.String android.icu.util.Output<java.lang.Boolean> ), (String)string2, output);
    }

    public static UResourceBundle openOlsonResource(UResourceBundle uResourceBundle, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("openOlsonResource", $$robo$$android_icu_impl_ZoneMeta$openOlsonResource(android.icu.util.UResourceBundle java.lang.String ), (UResourceBundle)uResourceBundle, (String)string2);
    }

    public static OlsonTimeZone getSystemTimeZone(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getSystemTimeZone", $$robo$$android_icu_impl_ZoneMeta$getSystemTimeZone(java.lang.String ), (String)string2);
    }

    public static SimpleTimeZone getCustomTimeZone(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCustomTimeZone", $$robo$$android_icu_impl_ZoneMeta$getCustomTimeZone(java.lang.String ), (String)string2);
    }

    public static String getCustomID(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCustomID", $$robo$$android_icu_impl_ZoneMeta$getCustomID(java.lang.String ), (String)string2);
    }

    static boolean parseCustomID(String string2, int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("parseCustomID", $$robo$$android_icu_impl_ZoneMeta$parseCustomID(java.lang.String int[] ), (String)string2, (int[])nArray);
    }

    public static SimpleTimeZone getCustomTimeZone(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCustomTimeZone", $$robo$$android_icu_impl_ZoneMeta$getCustomTimeZone(int ), (int)n);
    }

    static String formatCustomID(int n, int n2, int n3, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("formatCustomID", $$robo$$android_icu_impl_ZoneMeta$formatCustomID(int int int boolean ), (int)n, (int)n2, (int)n3, (boolean)bl);
    }

    public static String getShortID(TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrapStatic("getShortID", $$robo$$android_icu_impl_ZoneMeta$getShortID(android.icu.util.TimeZone ), (TimeZone)timeZone);
    }

    public static String getShortID(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getShortID", $$robo$$android_icu_impl_ZoneMeta$getShortID(java.lang.String ), (String)string2);
    }

    private static String getShortIDFromCanonical(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getShortIDFromCanonical", $$robo$$android_icu_impl_ZoneMeta$getShortIDFromCanonical(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(ZoneMeta.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZoneMeta)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CustomTimeZoneCache
    extends SoftCache<Integer, SimpleTimeZone, int[]> {
        public /* synthetic */ Object __robo_data__;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_ZoneMeta_CustomTimeZoneCache$__constructor__() {
        }

        private final SimpleTimeZone $$robo$$android_icu_impl_ZoneMeta_CustomTimeZoneCache$createInstance(Integer key, int[] data) {
            if (!$assertionsDisabled && data.length != 4) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && data[0] != 1 && data[0] != -1) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || data[1] >= 0 && data[1] <= 23)) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || data[2] >= 0 && data[2] <= 59)) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || data[3] >= 0 && data[3] <= 59)) {
                throw new AssertionError();
            }
            String id2 = ZoneMeta.formatCustomID(data[1], data[2], data[3], data[0] < 0);
            int offset = data[0] * ((data[1] * 60 + data[2]) * 60 + data[3]) * 1000;
            SimpleTimeZone tz = new SimpleTimeZone(offset, id2);
            tz.freeze();
            return tz;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_ZoneMeta_CustomTimeZoneCache$__constructor__(1 x0) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !ZoneMeta.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ZoneMeta_CustomTimeZoneCache$__constructor__();
        }

        public CustomTimeZoneCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ZoneMeta_CustomTimeZoneCache$__constructor__(), this);
        }

        @Override
        protected SimpleTimeZone createInstance(Integer n, int[] nArray) {
            return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_impl_ZoneMeta_CustomTimeZoneCache$createInstance(java.lang.Integer int[] ), this, n, nArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_ZoneMeta_CustomTimeZoneCache$__constructor__(var1_1);
        }

        public /* synthetic */ CustomTimeZoneCache(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ZoneMeta_CustomTimeZoneCache$__constructor__(android.icu.impl.ZoneMeta$1 ), this, var1_1);
        }

        static {
            RobolectricInternals.classInitializing(CustomTimeZoneCache.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CustomTimeZoneCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SystemTimeZoneCache
    extends SoftCache<String, OlsonTimeZone, String> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_ZoneMeta_SystemTimeZoneCache$__constructor__() {
        }

        private final OlsonTimeZone $$robo$$android_icu_impl_ZoneMeta_SystemTimeZoneCache$createInstance(String key, String data) {
            OlsonTimeZone tz = null;
            try {
                UResourceBundle top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "zoneinfo64", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle res = ZoneMeta.openOlsonResource(top, data);
                if (res != null) {
                    tz = new OlsonTimeZone(top, res, data);
                    tz.freeze();
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return tz;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_ZoneMeta_SystemTimeZoneCache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ZoneMeta_SystemTimeZoneCache$__constructor__();
        }

        public SystemTimeZoneCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ZoneMeta_SystemTimeZoneCache$__constructor__(), this);
        }

        @Override
        protected OlsonTimeZone createInstance(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_impl_ZoneMeta_SystemTimeZoneCache$createInstance(java.lang.String java.lang.String ), this, string2, string3);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_ZoneMeta_SystemTimeZoneCache$__constructor__(var1_1);
        }

        public /* synthetic */ SystemTimeZoneCache(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ZoneMeta_SystemTimeZoneCache$__constructor__(android.icu.impl.ZoneMeta$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemTimeZoneCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

