/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.IllegalIcuArgumentException;
import android.icu.impl.PatternProps;
import android.icu.lang.UCharacter;
import android.icu.text.Replaceable;
import android.icu.text.UTF16;
import android.icu.text.UnicodeMatcher;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Utility
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static char APOSTROPHE = '\'';
    private static char BACKSLASH = '\\';
    private static int MAGIC_UNSIGNED = Integer.MIN_VALUE;
    private static char ESCAPE = '\ua5a5';
    static byte ESCAPE_BYTE = -91;
    public static String LINE_SEPARATOR;
    static char[] HEX_DIGIT;
    private static char[] UNESCAPE_MAP;
    static char[] DIGITS;

    private void $$robo$$android_icu_impl_Utility$__constructor__() {
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayEquals(Object[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof Object[])) {
            return false;
        }
        Object[] targ = (Object[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayEquals(int[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof int[])) {
            return false;
        }
        int[] targ = (int[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayEquals(double[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof double[])) {
            return false;
        }
        double[] targ = (double[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayEquals(byte[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof byte[])) {
            return false;
        }
        byte[] targ = (byte[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (source instanceof Object[]) {
            return Utility.arrayEquals((Object[])source, target);
        }
        if (source instanceof int[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        if (source instanceof double[]) {
            return Utility.arrayEquals((double[])source, target);
        }
        if (source instanceof byte[]) {
            return Utility.arrayEquals((byte[])source, target);
        }
        return source.equals(target);
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayRegionMatches(Object[] source, int sourceStart, Object[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (Utility.arrayEquals(source[i], target[i + delta])) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayRegionMatches(char[] source, int sourceStart, char[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayRegionMatches(int[] source, int sourceStart, int[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayRegionMatches(double[] source, int sourceStart, double[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_icu_impl_Utility$arrayRegionMatches(byte[] source, int sourceStart, byte[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_icu_impl_Utility$sameObjects(Object a, Object b) {
        return a == b;
    }

    private static final boolean $$robo$$android_icu_impl_Utility$objectEquals(Object a, Object b) {
        return a == null ? b == null : (b == null ? false : a.equals(b));
    }

    private static final <T extends Comparable<T>> int $$robo$$android_icu_impl_Utility$checkCompare(T a, T b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareTo(b));
    }

    private static final int $$robo$$android_icu_impl_Utility$checkHash(Object a) {
        return a == null ? 0 : a.hashCode();
    }

    private static final String $$robo$$android_icu_impl_Utility$arrayToRLEString(int[] a) {
        StringBuilder buffer = new StringBuilder();
        Utility.appendInt(buffer, a.length);
        int runValue = a[0];
        int runLength = 1;
        for (int i = 1; i < a.length; ++i) {
            int s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength);
            runValue = s;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    private static final String $$robo$$android_icu_impl_Utility$arrayToRLEString(short[] a) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        short runValue = a[0];
        int runLength = 1;
        for (int i = 1; i < a.length; ++i) {
            short s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength);
            runValue = s;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    private static final String $$robo$$android_icu_impl_Utility$arrayToRLEString(char[] a) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        char runValue = a[0];
        int runLength = 1;
        for (int i = 1; i < a.length; ++i) {
            char s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, (short)runValue, runLength);
            runValue = s;
            runLength = 1;
        }
        Utility.encodeRun(buffer, (short)runValue, runLength);
        return buffer.toString();
    }

    private static final String $$robo$$android_icu_impl_Utility$arrayToRLEString(byte[] a) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        byte runValue = a[0];
        int runLength = 1;
        byte[] state = new byte[2];
        for (int i = 1; i < a.length; ++i) {
            byte b = a[i];
            if (b == runValue && runLength < 255) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength, state);
            runValue = b;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength, state);
        if (state[0] != 0) {
            Utility.appendEncodedByte(buffer, (byte)0, state);
        }
        return buffer.toString();
    }

    private static final <T extends Appendable> void $$robo$$android_icu_impl_Utility$encodeRun(T buffer, int value, int length) {
        if (length < 4) {
            for (int j = 0; j < length; ++j) {
                if (value == 42405) {
                    Utility.appendInt(buffer, value);
                }
                Utility.appendInt(buffer, value);
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    Utility.appendInt(buffer, 42405);
                }
                Utility.appendInt(buffer, value);
                --length;
            }
            Utility.appendInt(buffer, 42405);
            Utility.appendInt(buffer, length);
            Utility.appendInt(buffer, value);
        }
    }

    private static final <T extends Appendable> void $$robo$$android_icu_impl_Utility$appendInt(T buffer, int value) {
        try {
            buffer.append((char)(value >>> 16));
            buffer.append((char)(value & 0xFFFF));
        }
        catch (IOException e) {
            throw new IllegalIcuArgumentException(e);
        }
    }

    private static final <T extends Appendable> void $$robo$$android_icu_impl_Utility$encodeRun(T buffer, short value, int length) {
        try {
            char valueChar = (char)value;
            if (length < 4) {
                for (int j = 0; j < length; ++j) {
                    if (valueChar == '\ua5a5') {
                        buffer.append('\ua5a5');
                    }
                    buffer.append(valueChar);
                }
            } else {
                if (length == 42405) {
                    if (valueChar == '\ua5a5') {
                        buffer.append('\ua5a5');
                    }
                    buffer.append(valueChar);
                    --length;
                }
                buffer.append('\ua5a5');
                buffer.append((char)length);
                buffer.append(valueChar);
            }
        }
        catch (IOException e) {
            throw new IllegalIcuArgumentException(e);
        }
    }

    private static final <T extends Appendable> void $$robo$$android_icu_impl_Utility$encodeRun(T buffer, byte value, int length, byte[] state) {
        if (length < 4) {
            for (int j = 0; j < length; ++j) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
            }
        } else {
            if ((byte)length == -91) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
                --length;
            }
            Utility.appendEncodedByte(buffer, (byte)-91, state);
            Utility.appendEncodedByte(buffer, (byte)length, state);
            Utility.appendEncodedByte(buffer, value, state);
        }
    }

    private static final <T extends Appendable> void $$robo$$android_icu_impl_Utility$appendEncodedByte(T buffer, byte value, byte[] state) {
        try {
            if (state[0] != 0) {
                char c = (char)(state[1] << 8 | value & 0xFF);
                buffer.append(c);
                state[0] = 0;
            } else {
                state[0] = 1;
                state[1] = value;
            }
        }
        catch (IOException e) {
            throw new IllegalIcuArgumentException(e);
        }
    }

    private static final int[] $$robo$$android_icu_impl_Utility$RLEStringToIntArray(String s) {
        int length = Utility.getInt(s, 0);
        int[] array2 = new int[length];
        int ai = 0;
        int i = 1;
        int maxI = s.length() / 2;
        while (ai < length && i < maxI) {
            int c;
            if ((c = Utility.getInt(s, i++)) == 42405) {
                if ((c = Utility.getInt(s, i++)) == 42405) {
                    array2[ai++] = c;
                    continue;
                }
                int runLength = c;
                int runValue = Utility.getInt(s, i++);
                for (int j = 0; j < runLength; ++j) {
                    array2[ai++] = runValue;
                }
                continue;
            }
            array2[ai++] = c;
        }
        if (ai != length || i != maxI) {
            throw new IllegalStateException("Bad run-length encoded int array");
        }
        return array2;
    }

    private static final int $$robo$$android_icu_impl_Utility$getInt(String s, int i) {
        return s.charAt(2 * i) << 16 | s.charAt(2 * i + 1);
    }

    private static final short[] $$robo$$android_icu_impl_Utility$RLEStringToShortArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        short[] array2 = new short[length];
        int ai = 0;
        for (int i = 2; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 42405) {
                if ((c = s.charAt(++i)) == 42405) {
                    array2[ai++] = (short)c;
                    continue;
                }
                int runLength = c;
                short runValue = (short)s.charAt(++i);
                for (int j = 0; j < runLength; ++j) {
                    array2[ai++] = runValue;
                }
                continue;
            }
            array2[ai++] = (short)c;
        }
        if (ai != length) {
            throw new IllegalStateException("Bad run-length encoded short array");
        }
        return array2;
    }

    private static final char[] $$robo$$android_icu_impl_Utility$RLEStringToCharArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        char[] array2 = new char[length];
        int ai = 0;
        for (int i = 2; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 42405) {
                if ((c = s.charAt(++i)) == 42405) {
                    array2[ai++] = c;
                    continue;
                }
                int runLength = c;
                char runValue = s.charAt(++i);
                for (int j = 0; j < runLength; ++j) {
                    array2[ai++] = runValue;
                }
                continue;
            }
            array2[ai++] = c;
        }
        if (ai != length) {
            throw new IllegalStateException("Bad run-length encoded short array");
        }
        return array2;
    }

    private static final byte[] $$robo$$android_icu_impl_Utility$RLEStringToByteArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        byte[] array2 = new byte[length];
        boolean nextChar = true;
        int c = 0;
        int node = 0;
        int runLength = 0;
        int i = 2;
        int ai = 0;
        while (ai < length) {
            int b;
            if (nextChar) {
                c = s.charAt(i++);
                b = (byte)(c >> 8);
                nextChar = false;
            } else {
                b = c & 0xFF;
                nextChar = true;
            }
            switch (node) {
                case 0: {
                    if (b == -91) {
                        node = 1;
                        break;
                    }
                    array2[ai++] = b;
                    break;
                }
                case 1: {
                    if (b == -91) {
                        array2[ai++] = -91;
                        node = 0;
                        break;
                    }
                    runLength = b;
                    if (runLength < 0) {
                        runLength += 256;
                    }
                    node = 2;
                    break;
                }
                case 2: {
                    for (int j = 0; j < runLength; ++j) {
                        array2[ai++] = b;
                    }
                    node = 0;
                }
            }
        }
        if (node != 0) {
            throw new IllegalStateException("Bad run-length encoded byte array");
        }
        if (i != s.length()) {
            throw new IllegalStateException("Excess data in RLE byte array string");
        }
        return array2;
    }

    private static final String $$robo$$android_icu_impl_Utility$formatForSource(String s) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            if (i > 0) {
                buffer.append('+').append(LINE_SEPARATOR);
            }
            buffer.append("        \"");
            int count = 11;
            while (i < s.length() && count < 80) {
                char c;
                if ((c = s.charAt(i++)) < ' ' || c == '\"' || c == '\\') {
                    if (c == '\n') {
                        buffer.append("\\n");
                        count += 2;
                        continue;
                    }
                    if (c == '\t') {
                        buffer.append("\\t");
                        count += 2;
                        continue;
                    }
                    if (c == '\r') {
                        buffer.append("\\r");
                        count += 2;
                        continue;
                    }
                    buffer.append('\\');
                    buffer.append(HEX_DIGIT[(c & 0x1C0) >> 6]);
                    buffer.append(HEX_DIGIT[(c & 0x38) >> 3]);
                    buffer.append(HEX_DIGIT[c & 7]);
                    count += 4;
                    continue;
                }
                if (c <= '~') {
                    buffer.append(c);
                    ++count;
                    continue;
                }
                buffer.append("\\u");
                buffer.append(HEX_DIGIT[(c & 0xF000) >> 12]);
                buffer.append(HEX_DIGIT[(c & 0xF00) >> 8]);
                buffer.append(HEX_DIGIT[(c & 0xF0) >> 4]);
                buffer.append(HEX_DIGIT[c & 0xF]);
                count += 6;
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    private static final String $$robo$$android_icu_impl_Utility$format1ForSource(String s) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"");
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) < ' ' || c == '\"' || c == '\\') {
                if (c == '\n') {
                    buffer.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    buffer.append("\\t");
                    continue;
                }
                if (c == '\r') {
                    buffer.append("\\r");
                    continue;
                }
                buffer.append('\\');
                buffer.append(HEX_DIGIT[(c & 0x1C0) >> 6]);
                buffer.append(HEX_DIGIT[(c & 0x38) >> 3]);
                buffer.append(HEX_DIGIT[c & 7]);
                continue;
            }
            if (c <= '~') {
                buffer.append(c);
                continue;
            }
            buffer.append("\\u");
            buffer.append(HEX_DIGIT[(c & 0xF000) >> 12]);
            buffer.append(HEX_DIGIT[(c & 0xF00) >> 8]);
            buffer.append(HEX_DIGIT[(c & 0xF0) >> 4]);
            buffer.append(HEX_DIGIT[c & 0xF]);
        }
        buffer.append('\"');
        return buffer.toString();
    }

    private static final String $$robo$$android_icu_impl_Utility$escape(String s) {
        int c;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(c)) {
            c = Character.codePointAt(s, i);
            if (c >= 32 && c <= 127) {
                if (c == 92) {
                    buf.append("\\\\");
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            boolean four = c <= 65535;
            buf.append(four ? "\\u" : "\\U");
            buf.append(Utility.hex(c, four ? 4 : 8));
        }
        return buf.toString();
    }

    private static final int $$robo$$android_icu_impl_Utility$unescapeAt(String s, int[] offset16) {
        int dig;
        int result = 0;
        int n = 0;
        int minDig = 0;
        int maxDig = 0;
        int bitsPerDigit = 4;
        boolean braces = false;
        int offset = offset16[0];
        int length = s.length();
        if (offset < 0 || offset >= length) {
            return -1;
        }
        int c = Character.codePointAt(s, offset);
        offset += UTF16.getCharCount(c);
        switch (c) {
            case 117: {
                maxDig = 4;
                minDig = 4;
                break;
            }
            case 85: {
                maxDig = 8;
                minDig = 8;
                break;
            }
            case 120: {
                minDig = 1;
                if (offset < length && UTF16.charAt(s, offset) == 123) {
                    ++offset;
                    braces = true;
                    maxDig = 8;
                    break;
                }
                maxDig = 2;
                break;
            }
            default: {
                dig = UCharacter.digit(c, 8);
                if (dig < 0) break;
                minDig = 1;
                maxDig = 3;
                n = 1;
                bitsPerDigit = 3;
                result = dig;
            }
        }
        if (minDig != 0) {
            while (offset < length && n < maxDig && (dig = UCharacter.digit(c = UTF16.charAt(s, offset), bitsPerDigit == 3 ? 8 : 16)) >= 0) {
                result = result << bitsPerDigit | dig;
                offset += UTF16.getCharCount(c);
                ++n;
            }
            if (n < minDig) {
                return -1;
            }
            if (braces) {
                if (c != 125) {
                    return -1;
                }
                ++offset;
            }
            if (result < 0 || result >= 0x110000) {
                return -1;
            }
            if (offset < length && UTF16.isLeadSurrogate((char)result)) {
                int ahead = offset + 1;
                c = s.charAt(offset);
                if (c == 92 && ahead < length) {
                    int[] o = new int[]{ahead};
                    c = Utility.unescapeAt(s, o);
                    ahead = o[0];
                }
                if (UTF16.isTrailSurrogate((char)c)) {
                    offset = ahead;
                    result = Character.toCodePoint((char)result, (char)c);
                }
            }
            offset16[0] = offset;
            return result;
        }
        for (int i = 0; i < UNESCAPE_MAP.length; i += 2) {
            if (c == UNESCAPE_MAP[i]) {
                offset16[0] = offset;
                return UNESCAPE_MAP[i + 1];
            }
            if (c < UNESCAPE_MAP[i]) break;
        }
        if (c == 99 && offset < length) {
            c = UTF16.charAt(s, offset);
            offset16[0] = offset + UTF16.getCharCount(c);
            return 0x1F & c;
        }
        offset16[0] = offset;
        return c;
    }

    private static final String $$robo$$android_icu_impl_Utility$unescape(String s) {
        StringBuilder buf = new StringBuilder();
        int[] pos = new int[1];
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                pos[0] = i;
                int e = Utility.unescapeAt(s, pos);
                if (e < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence " + s.substring(i - 1, Math.min(i + 8, s.length())));
                }
                buf.appendCodePoint(e);
                i = pos[0];
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static final String $$robo$$android_icu_impl_Utility$unescapeLeniently(String s) {
        StringBuilder buf = new StringBuilder();
        int[] pos = new int[1];
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                pos[0] = i;
                int e = Utility.unescapeAt(s, pos);
                if (e < 0) {
                    buf.append(c);
                    continue;
                }
                buf.appendCodePoint(e);
                i = pos[0];
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static final String $$robo$$android_icu_impl_Utility$hex(long ch) {
        return Utility.hex(ch, 4);
    }

    private static final String $$robo$$android_icu_impl_Utility$hex(long i, int places) {
        String result;
        boolean negative;
        if (i == Long.MIN_VALUE) {
            return "-8000000000000000";
        }
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        if ((result = Long.toString(i, 16).toUpperCase(Locale.ENGLISH)).length() < places) {
            result = "0000000000000000".substring(result.length(), places) + result;
        }
        if (negative) {
            return '-' + result;
        }
        return result;
    }

    private static final String $$robo$$android_icu_impl_Utility$hex(CharSequence s) {
        return Utility.hex(s, 4, ",", true, new StringBuilder()).toString();
    }

    private static final <S extends CharSequence, U extends CharSequence, T extends Appendable> T $$robo$$android_icu_impl_Utility$hex(S s, int width, U separator, boolean useCodePoints, T result) {
        try {
            if (useCodePoints) {
                int cp;
                for (int i = 0; i < s.length(); i += UTF16.getCharCount(cp)) {
                    cp = Character.codePointAt(s, i);
                    if (i != 0) {
                        result.append(separator);
                    }
                    result.append(Utility.hex(cp, width));
                }
            } else {
                for (int i = 0; i < s.length(); ++i) {
                    if (i != 0) {
                        result.append(separator);
                    }
                    result.append(Utility.hex(s.charAt(i), width));
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalIcuArgumentException(e);
        }
    }

    private static final String $$robo$$android_icu_impl_Utility$hex(byte[] o, int start, int end, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (i != 0) {
                result.append(separator);
            }
            result.append(Utility.hex(o[i]));
        }
        return result.toString();
    }

    private static final <S extends CharSequence> String $$robo$$android_icu_impl_Utility$hex(S s, int width, S separator) {
        return Utility.hex(s, width, separator, true, new StringBuilder()).toString();
    }

    private static final void $$robo$$android_icu_impl_Utility$split(String s, char divider, String[] output) {
        int i;
        int last = 0;
        int current = 0;
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != divider) continue;
            output[current++] = s.substring(last, i);
            last = i + 1;
        }
        output[current++] = s.substring(last, i);
        while (current < output.length) {
            output[current++] = "";
        }
    }

    private static final String[] $$robo$$android_icu_impl_Utility$split(String s, char divider) {
        int i;
        int last = 0;
        ArrayList<String> output = new ArrayList<String>();
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != divider) continue;
            output.add(s.substring(last, i));
            last = i + 1;
        }
        output.add(s.substring(last, i));
        return output.toArray(new String[output.size()]);
    }

    private static final int $$robo$$android_icu_impl_Utility$lookup(String source, String[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (!source.equals(target[i])) continue;
            return i;
        }
        return -1;
    }

    private static final boolean $$robo$$android_icu_impl_Utility$parseChar(String id2, int[] pos, char ch) {
        int start = pos[0];
        pos[0] = PatternProps.skipWhiteSpace(id2, pos[0]);
        if (pos[0] == id2.length() || id2.charAt(pos[0]) != ch) {
            pos[0] = start;
            return false;
        }
        pos[0] = pos[0] + 1;
        return true;
    }

    private static final int $$robo$$android_icu_impl_Utility$parsePattern(String rule, int pos, int limit, String pattern, int[] parsedInts) {
        int[] p = new int[1];
        int intCount = 0;
        block5: for (int i = 0; i < pattern.length(); ++i) {
            char cpat = pattern.charAt(i);
            switch (cpat) {
                case ' ': {
                    char c;
                    if (pos >= limit) {
                        return -1;
                    }
                    if (!PatternProps.isWhiteSpace(c = rule.charAt(pos++))) {
                        return -1;
                    }
                }
                case '~': {
                    pos = PatternProps.skipWhiteSpace(rule, pos);
                    continue block5;
                }
                case '#': {
                    p[0] = pos;
                    parsedInts[intCount++] = Utility.parseInteger(rule, p, limit);
                    if (p[0] == pos) {
                        return -1;
                    }
                    pos = p[0];
                    continue block5;
                }
                default: {
                    char c;
                    if (pos >= limit) {
                        return -1;
                    }
                    if ((c = (char)UCharacter.toLowerCase(rule.charAt(pos++))) == cpat) continue block5;
                    return -1;
                }
            }
        }
        return pos;
    }

    private static final int $$robo$$android_icu_impl_Utility$parsePattern(String pat, Replaceable text, int index, int limit) {
        int ipat = 0;
        if (ipat == pat.length()) {
            return index;
        }
        int cpat = Character.codePointAt(pat, ipat);
        while (index < limit) {
            int c = text.char32At(index);
            if (cpat == 126) {
                if (PatternProps.isWhiteSpace(c)) {
                    index += UTF16.getCharCount(c);
                    continue;
                }
                if (++ipat == pat.length()) {
                    return index;
                }
            } else if (c == cpat) {
                int n = UTF16.getCharCount(c);
                index += n;
                if ((ipat += n) == pat.length()) {
                    return index;
                }
            } else {
                return -1;
            }
            cpat = UTF16.charAt(pat, ipat);
        }
        return -1;
    }

    private static final int $$robo$$android_icu_impl_Utility$parseInteger(String rule, int[] pos, int limit) {
        int count = 0;
        int value = 0;
        int p = pos[0];
        int radix = 10;
        if (rule.regionMatches(true, p, "0x", 0, 2)) {
            p += 2;
            radix = 16;
        } else if (p < limit && rule.charAt(p) == '0') {
            ++p;
            count = 1;
            radix = 8;
        }
        while (p < limit) {
            int d;
            if ((d = UCharacter.digit(rule.charAt(p++), radix)) < 0) {
                --p;
                break;
            }
            ++count;
            int v = value * radix + d;
            if (v <= value) {
                return 0;
            }
            value = v;
        }
        if (count > 0) {
            pos[0] = p;
        }
        return value;
    }

    private static final String $$robo$$android_icu_impl_Utility$parseUnicodeIdentifier(String str, int[] pos) {
        int p;
        int ch;
        StringBuilder buf = new StringBuilder();
        for (p = pos[0]; p < str.length(); p += UTF16.getCharCount(ch)) {
            ch = Character.codePointAt(str, p);
            if (buf.length() == 0) {
                if (UCharacter.isUnicodeIdentifierStart(ch)) {
                    buf.appendCodePoint(ch);
                    continue;
                }
                return null;
            }
            if (!UCharacter.isUnicodeIdentifierPart(ch)) break;
            buf.appendCodePoint(ch);
        }
        pos[0] = p;
        return buf.toString();
    }

    private static final <T extends Appendable> void $$robo$$android_icu_impl_Utility$recursiveAppendNumber(T result, int n, int radix, int minDigits) {
        try {
            int digit = n % radix;
            if (n >= radix || minDigits > 1) {
                Utility.recursiveAppendNumber(result, n / radix, radix, minDigits - 1);
            }
            result.append(DIGITS[digit]);
        }
        catch (IOException e) {
            throw new IllegalIcuArgumentException(e);
        }
    }

    private static final <T extends Appendable> T $$robo$$android_icu_impl_Utility$appendNumber(T result, int n, int radix, int minDigits) {
        try {
            if (radix < 2 || radix > 36) {
                throw new IllegalArgumentException("Illegal radix " + radix);
            }
            int abs = n;
            if (n < 0) {
                abs = -n;
                result.append("-");
            }
            Utility.recursiveAppendNumber(result, abs, radix, minDigits);
            return result;
        }
        catch (IOException e) {
            throw new IllegalIcuArgumentException(e);
        }
    }

    private static final int $$robo$$android_icu_impl_Utility$parseNumber(String text, int[] pos, int radix) {
        int ch;
        int d;
        int p;
        int n = 0;
        for (p = pos[0]; p < text.length() && (d = UCharacter.digit(ch = Character.codePointAt(text, p), radix)) >= 0; ++p) {
            if ((n = radix * n + d) >= 0) continue;
            return -1;
        }
        if (p == pos[0]) {
            return -1;
        }
        pos[0] = p;
        return n;
    }

    private static final boolean $$robo$$android_icu_impl_Utility$isUnprintable(int c) {
        return c < 32 || c > 126;
    }

    private static final <T extends Appendable> boolean $$robo$$android_icu_impl_Utility$escapeUnprintable(T result, int c) {
        try {
            if (Utility.isUnprintable(c)) {
                result.append('\\');
                if ((c & 0xFFFF0000) != 0) {
                    result.append('U');
                    result.append(DIGITS[0xF & c >> 28]);
                    result.append(DIGITS[0xF & c >> 24]);
                    result.append(DIGITS[0xF & c >> 20]);
                    result.append(DIGITS[0xF & c >> 16]);
                } else {
                    result.append('u');
                }
                result.append(DIGITS[0xF & c >> 12]);
                result.append(DIGITS[0xF & c >> 8]);
                result.append(DIGITS[0xF & c >> 4]);
                result.append(DIGITS[0xF & c]);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new IllegalIcuArgumentException(e);
        }
    }

    private static final int $$robo$$android_icu_impl_Utility$quotedIndexOf(String text, int start, int limit, String setOfChars) {
        for (int i = start; i < limit; ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c == '\'') {
                while (++i < limit && text.charAt(i) != '\'') {
                }
                continue;
            }
            if (setOfChars.indexOf(c) < 0) continue;
            return i;
        }
        return -1;
    }

    private static final void $$robo$$android_icu_impl_Utility$appendToRule(StringBuffer rule, int c, boolean isLiteral, boolean escapeUnprintable, StringBuffer quoteBuf) {
        if (isLiteral || escapeUnprintable && Utility.isUnprintable(c)) {
            if (quoteBuf.length() > 0) {
                while (quoteBuf.length() >= 2 && quoteBuf.charAt(0) == '\'' && quoteBuf.charAt(1) == '\'') {
                    rule.append('\\').append('\'');
                    quoteBuf.delete(0, 2);
                }
                int trailingCount = 0;
                while (quoteBuf.length() >= 2 && quoteBuf.charAt(quoteBuf.length() - 2) == '\'' && quoteBuf.charAt(quoteBuf.length() - 1) == '\'') {
                    quoteBuf.setLength(quoteBuf.length() - 2);
                    ++trailingCount;
                }
                if (quoteBuf.length() > 0) {
                    rule.append('\'');
                    rule.append(quoteBuf);
                    rule.append('\'');
                    quoteBuf.setLength(0);
                }
                while (trailingCount-- > 0) {
                    rule.append('\\').append('\'');
                }
            }
            if (c != -1) {
                if (c == 32) {
                    int len = rule.length();
                    if (len > 0 && rule.charAt(len - 1) != ' ') {
                        rule.append(' ');
                    }
                } else if (!escapeUnprintable || !Utility.escapeUnprintable(rule, c)) {
                    rule.appendCodePoint(c);
                }
            }
        } else if (quoteBuf.length() == 0 && (c == 39 || c == 92)) {
            rule.append('\\').append((char)c);
        } else if (!(quoteBuf.length() <= 0 && (c < 33 || c > 126 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122) && !PatternProps.isWhiteSpace(c))) {
            quoteBuf.appendCodePoint(c);
            if (c == 39) {
                quoteBuf.append((char)c);
            }
        } else {
            rule.appendCodePoint(c);
        }
    }

    private static final void $$robo$$android_icu_impl_Utility$appendToRule(StringBuffer rule, String text, boolean isLiteral, boolean escapeUnprintable, StringBuffer quoteBuf) {
        for (int i = 0; i < text.length(); ++i) {
            Utility.appendToRule(rule, text.charAt(i), isLiteral, escapeUnprintable, quoteBuf);
        }
    }

    private static final void $$robo$$android_icu_impl_Utility$appendToRule(StringBuffer rule, UnicodeMatcher matcher, boolean escapeUnprintable, StringBuffer quoteBuf) {
        if (matcher != null) {
            Utility.appendToRule(rule, matcher.toPattern(escapeUnprintable), true, escapeUnprintable, quoteBuf);
        }
    }

    private static final int $$robo$$android_icu_impl_Utility$compareUnsigned(int source, int target) {
        if ((source -= Integer.MIN_VALUE) < (target -= Integer.MIN_VALUE)) {
            return -1;
        }
        if (source > target) {
            return 1;
        }
        return 0;
    }

    private static final byte $$robo$$android_icu_impl_Utility$highBit(int n) {
        if (n <= 0) {
            return -1;
        }
        byte bit = 0;
        if (n >= 65536) {
            n >>= 16;
            bit = (byte)(bit + 16);
        }
        if (n >= 256) {
            n >>= 8;
            bit = (byte)(bit + 8);
        }
        if (n >= 16) {
            n >>= 4;
            bit = (byte)(bit + 4);
        }
        if (n >= 4) {
            n >>= 2;
            bit = (byte)(bit + 2);
        }
        if (n >= 2) {
            n >>= 1;
            bit = (byte)(bit + 1);
        }
        return bit;
    }

    private static final String $$robo$$android_icu_impl_Utility$valueOf(int[] source) {
        StringBuilder result = new StringBuilder(source.length);
        for (int i = 0; i < source.length; ++i) {
            result.appendCodePoint(source[i]);
        }
        return result.toString();
    }

    private static final String $$robo$$android_icu_impl_Utility$repeat(String s, int count) {
        if (count <= 0) {
            return "";
        }
        if (count == 1) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(s);
        }
        return result.toString();
    }

    private static final String[] $$robo$$android_icu_impl_Utility$splitString(String src, String target) {
        return src.split("\\Q" + target + "\\E");
    }

    private static final String[] $$robo$$android_icu_impl_Utility$splitWhitespace(String src) {
        return src.split("\\s+");
    }

    private static final String $$robo$$android_icu_impl_Utility$fromHex(String string2, int minLength, String separator) {
        return Utility.fromHex(string2, minLength, Pattern.compile(separator != null ? separator : "\\s+"));
    }

    private static final String $$robo$$android_icu_impl_Utility$fromHex(String string2, int minLength, Pattern separator) {
        String[] parts;
        StringBuilder buffer = new StringBuilder();
        for (String part : parts = separator.split(string2)) {
            if (part.length() < minLength) {
                throw new IllegalArgumentException("code point too short: " + part);
            }
            int cp = Integer.parseInt(part, 16);
            buffer.appendCodePoint(cp);
        }
        return buffer.toString();
    }

    static void __staticInitializer__() {
        LINE_SEPARATOR = System.getProperty("line.separator");
        HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'e', '\u001b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_Utility$__constructor__();
    }

    public Utility() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Utility$__constructor__(), this);
    }

    public static boolean arrayEquals(Object[] objectArray, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayEquals", $$robo$$android_icu_impl_Utility$arrayEquals(java.lang.Object[] java.lang.Object ), (Object[])objectArray, (Object)object);
    }

    public static boolean arrayEquals(int[] nArray, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayEquals", $$robo$$android_icu_impl_Utility$arrayEquals(int[] java.lang.Object ), (int[])nArray, (Object)object);
    }

    public static boolean arrayEquals(double[] dArray, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayEquals", $$robo$$android_icu_impl_Utility$arrayEquals(double[] java.lang.Object ), (double[])dArray, (Object)object);
    }

    public static boolean arrayEquals(byte[] byArray, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayEquals", $$robo$$android_icu_impl_Utility$arrayEquals(byte[] java.lang.Object ), (byte[])byArray, (Object)object);
    }

    public static boolean arrayEquals(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayEquals", $$robo$$android_icu_impl_Utility$arrayEquals(java.lang.Object java.lang.Object ), (Object)object, (Object)object2);
    }

    public static boolean arrayRegionMatches(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayRegionMatches", $$robo$$android_icu_impl_Utility$arrayRegionMatches(java.lang.Object[] int java.lang.Object[] int int ), (Object[])objectArray, (int)n, (Object[])objectArray2, (int)n2, (int)n3);
    }

    public static boolean arrayRegionMatches(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayRegionMatches", $$robo$$android_icu_impl_Utility$arrayRegionMatches(char[] int char[] int int ), (char[])cArray, (int)n, (char[])cArray2, (int)n2, (int)n3);
    }

    public static boolean arrayRegionMatches(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayRegionMatches", $$robo$$android_icu_impl_Utility$arrayRegionMatches(int[] int int[] int int ), (int[])nArray, (int)n, (int[])nArray2, (int)n2, (int)n3);
    }

    public static boolean arrayRegionMatches(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayRegionMatches", $$robo$$android_icu_impl_Utility$arrayRegionMatches(double[] int double[] int int ), (double[])dArray, (int)n, (double[])dArray2, (int)n2, (int)n3);
    }

    public static boolean arrayRegionMatches(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayRegionMatches", $$robo$$android_icu_impl_Utility$arrayRegionMatches(byte[] int byte[] int int ), (byte[])byArray, (int)n, (byte[])byArray2, (int)n2, (int)n3);
    }

    public static boolean sameObjects(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("sameObjects", $$robo$$android_icu_impl_Utility$sameObjects(java.lang.Object java.lang.Object ), (Object)object, (Object)object2);
    }

    public static boolean objectEquals(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("objectEquals", $$robo$$android_icu_impl_Utility$objectEquals(java.lang.Object java.lang.Object ), (Object)object, (Object)object2);
    }

    public static <T extends Comparable<T>> int checkCompare(T t, T t2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkCompare", $$robo$$android_icu_impl_Utility$checkCompare(T T ), t, t2);
    }

    public static int checkHash(Object object) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkHash", $$robo$$android_icu_impl_Utility$checkHash(java.lang.Object ), (Object)object);
    }

    public static String arrayToRLEString(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("arrayToRLEString", $$robo$$android_icu_impl_Utility$arrayToRLEString(int[] ), (int[])nArray);
    }

    public static String arrayToRLEString(short[] sArray) {
        return InvokeDynamicSupport.bootstrapStatic("arrayToRLEString", $$robo$$android_icu_impl_Utility$arrayToRLEString(short[] ), (short[])sArray);
    }

    public static String arrayToRLEString(char[] cArray) {
        return InvokeDynamicSupport.bootstrapStatic("arrayToRLEString", $$robo$$android_icu_impl_Utility$arrayToRLEString(char[] ), (char[])cArray);
    }

    public static String arrayToRLEString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("arrayToRLEString", $$robo$$android_icu_impl_Utility$arrayToRLEString(byte[] ), (byte[])byArray);
    }

    private static <T extends Appendable> void encodeRun(T t, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("encodeRun", $$robo$$android_icu_impl_Utility$encodeRun(T int int ), t, (int)n, (int)n2);
    }

    private static <T extends Appendable> void appendInt(T t, int n) {
        InvokeDynamicSupport.bootstrapStatic("appendInt", $$robo$$android_icu_impl_Utility$appendInt(T int ), t, (int)n);
    }

    private static <T extends Appendable> void encodeRun(T t, short s, int n) {
        InvokeDynamicSupport.bootstrapStatic("encodeRun", $$robo$$android_icu_impl_Utility$encodeRun(T short int ), t, (short)s, (int)n);
    }

    private static <T extends Appendable> void encodeRun(T t, byte by, int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("encodeRun", $$robo$$android_icu_impl_Utility$encodeRun(T byte int byte[] ), t, (byte)by, (int)n, (byte[])byArray);
    }

    private static <T extends Appendable> void appendEncodedByte(T t, byte by, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("appendEncodedByte", $$robo$$android_icu_impl_Utility$appendEncodedByte(T byte byte[] ), t, (byte)by, (byte[])byArray);
    }

    public static int[] RLEStringToIntArray(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("RLEStringToIntArray", $$robo$$android_icu_impl_Utility$RLEStringToIntArray(java.lang.String ), (String)string2);
    }

    static int getInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getInt", $$robo$$android_icu_impl_Utility$getInt(java.lang.String int ), (String)string2, (int)n);
    }

    public static short[] RLEStringToShortArray(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("RLEStringToShortArray", $$robo$$android_icu_impl_Utility$RLEStringToShortArray(java.lang.String ), (String)string2);
    }

    public static char[] RLEStringToCharArray(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("RLEStringToCharArray", $$robo$$android_icu_impl_Utility$RLEStringToCharArray(java.lang.String ), (String)string2);
    }

    public static byte[] RLEStringToByteArray(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("RLEStringToByteArray", $$robo$$android_icu_impl_Utility$RLEStringToByteArray(java.lang.String ), (String)string2);
    }

    public static String formatForSource(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("formatForSource", $$robo$$android_icu_impl_Utility$formatForSource(java.lang.String ), (String)string2);
    }

    public static String format1ForSource(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("format1ForSource", $$robo$$android_icu_impl_Utility$format1ForSource(java.lang.String ), (String)string2);
    }

    public static String escape(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("escape", $$robo$$android_icu_impl_Utility$escape(java.lang.String ), (String)string2);
    }

    public static int unescapeAt(String string2, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("unescapeAt", $$robo$$android_icu_impl_Utility$unescapeAt(java.lang.String int[] ), (String)string2, (int[])nArray);
    }

    public static String unescape(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("unescape", $$robo$$android_icu_impl_Utility$unescape(java.lang.String ), (String)string2);
    }

    public static String unescapeLeniently(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("unescapeLeniently", $$robo$$android_icu_impl_Utility$unescapeLeniently(java.lang.String ), (String)string2);
    }

    public static String hex(long l) {
        return InvokeDynamicSupport.bootstrapStatic("hex", $$robo$$android_icu_impl_Utility$hex(long ), (long)l);
    }

    public static String hex(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("hex", $$robo$$android_icu_impl_Utility$hex(long int ), (long)l, (int)n);
    }

    public static String hex(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("hex", $$robo$$android_icu_impl_Utility$hex(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    public static <S extends CharSequence, U extends CharSequence, T extends Appendable> T hex(S s, int n, U u, boolean bl, T t) {
        return (T)InvokeDynamicSupport.bootstrapStatic("hex", $$robo$$android_icu_impl_Utility$hex(S int U boolean T ), s, (int)n, u, (boolean)bl, t);
    }

    public static String hex(byte[] byArray, int n, int n2, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("hex", $$robo$$android_icu_impl_Utility$hex(byte[] int int java.lang.String ), (byte[])byArray, (int)n, (int)n2, (String)string2);
    }

    public static <S extends CharSequence> String hex(S s, int n, S s2) {
        return InvokeDynamicSupport.bootstrapStatic("hex", $$robo$$android_icu_impl_Utility$hex(S int S ), s, (int)n, s2);
    }

    public static void split(String string2, char c, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("split", $$robo$$android_icu_impl_Utility$split(java.lang.String char java.lang.String[] ), (String)string2, (char)c, (String[])stringArray);
    }

    public static String[] split(String string2, char c) {
        return InvokeDynamicSupport.bootstrapStatic("split", $$robo$$android_icu_impl_Utility$split(java.lang.String char ), (String)string2, (char)c);
    }

    public static int lookup(String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lookup", $$robo$$android_icu_impl_Utility$lookup(java.lang.String java.lang.String[] ), (String)string2, (String[])stringArray);
    }

    public static boolean parseChar(String string2, int[] nArray, char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("parseChar", $$robo$$android_icu_impl_Utility$parseChar(java.lang.String int[] char ), (String)string2, (int[])nArray, (char)c);
    }

    public static int parsePattern(String string2, int n, int n2, String string3, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parsePattern", $$robo$$android_icu_impl_Utility$parsePattern(java.lang.String int int java.lang.String int[] ), (String)string2, (int)n, (int)n2, (String)string3, (int[])nArray);
    }

    public static int parsePattern(String string2, Replaceable replaceable, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parsePattern", $$robo$$android_icu_impl_Utility$parsePattern(java.lang.String android.icu.text.Replaceable int int ), (String)string2, (Replaceable)replaceable, (int)n, (int)n2);
    }

    public static int parseInteger(String string2, int[] nArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseInteger", $$robo$$android_icu_impl_Utility$parseInteger(java.lang.String int[] int ), (String)string2, (int[])nArray, (int)n);
    }

    public static String parseUnicodeIdentifier(String string2, int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("parseUnicodeIdentifier", $$robo$$android_icu_impl_Utility$parseUnicodeIdentifier(java.lang.String int[] ), (String)string2, (int[])nArray);
    }

    private static <T extends Appendable> void recursiveAppendNumber(T t, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("recursiveAppendNumber", $$robo$$android_icu_impl_Utility$recursiveAppendNumber(T int int int ), t, (int)n, (int)n2, (int)n3);
    }

    public static <T extends Appendable> T appendNumber(T t, int n, int n2, int n3) {
        return (T)InvokeDynamicSupport.bootstrapStatic("appendNumber", $$robo$$android_icu_impl_Utility$appendNumber(T int int int ), t, (int)n, (int)n2, (int)n3);
    }

    public static int parseNumber(String string2, int[] nArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseNumber", $$robo$$android_icu_impl_Utility$parseNumber(java.lang.String int[] int ), (String)string2, (int[])nArray, (int)n);
    }

    public static boolean isUnprintable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUnprintable", $$robo$$android_icu_impl_Utility$isUnprintable(int ), (int)n);
    }

    public static <T extends Appendable> boolean escapeUnprintable(T t, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("escapeUnprintable", $$robo$$android_icu_impl_Utility$escapeUnprintable(T int ), t, (int)n);
    }

    public static int quotedIndexOf(String string2, int n, int n2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("quotedIndexOf", $$robo$$android_icu_impl_Utility$quotedIndexOf(java.lang.String int int java.lang.String ), (String)string2, (int)n, (int)n2, (String)string3);
    }

    public static void appendToRule(StringBuffer stringBuffer, int n, boolean bl, boolean bl2, StringBuffer stringBuffer2) {
        InvokeDynamicSupport.bootstrapStatic("appendToRule", $$robo$$android_icu_impl_Utility$appendToRule(java.lang.StringBuffer int boolean boolean java.lang.StringBuffer ), (StringBuffer)stringBuffer, (int)n, (boolean)bl, (boolean)bl2, (StringBuffer)stringBuffer2);
    }

    public static void appendToRule(StringBuffer stringBuffer, String string2, boolean bl, boolean bl2, StringBuffer stringBuffer2) {
        InvokeDynamicSupport.bootstrapStatic("appendToRule", $$robo$$android_icu_impl_Utility$appendToRule(java.lang.StringBuffer java.lang.String boolean boolean java.lang.StringBuffer ), (StringBuffer)stringBuffer, (String)string2, (boolean)bl, (boolean)bl2, (StringBuffer)stringBuffer2);
    }

    public static void appendToRule(StringBuffer stringBuffer, UnicodeMatcher unicodeMatcher, boolean bl, StringBuffer stringBuffer2) {
        InvokeDynamicSupport.bootstrapStatic("appendToRule", $$robo$$android_icu_impl_Utility$appendToRule(java.lang.StringBuffer android.icu.text.UnicodeMatcher boolean java.lang.StringBuffer ), (StringBuffer)stringBuffer, (UnicodeMatcher)unicodeMatcher, (boolean)bl, (StringBuffer)stringBuffer2);
    }

    public static int compareUnsigned(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareUnsigned", $$robo$$android_icu_impl_Utility$compareUnsigned(int int ), (int)n, (int)n2);
    }

    public static byte highBit(int n) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("highBit", $$robo$$android_icu_impl_Utility$highBit(int ), (int)n);
    }

    public static String valueOf(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_Utility$valueOf(int[] ), (int[])nArray);
    }

    public static String repeat(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("repeat", $$robo$$android_icu_impl_Utility$repeat(java.lang.String int ), (String)string2, (int)n);
    }

    public static String[] splitString(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("splitString", $$robo$$android_icu_impl_Utility$splitString(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    public static String[] splitWhitespace(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("splitWhitespace", $$robo$$android_icu_impl_Utility$splitWhitespace(java.lang.String ), (String)string2);
    }

    public static String fromHex(String string2, int n, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("fromHex", $$robo$$android_icu_impl_Utility$fromHex(java.lang.String int java.lang.String ), (String)string2, (int)n, (String)string3);
    }

    public static String fromHex(String string2, int n, Pattern pattern) {
        return InvokeDynamicSupport.bootstrapStatic("fromHex", $$robo$$android_icu_impl_Utility$fromHex(java.lang.String int java.util.regex.Pattern ), (String)string2, (int)n, (Pattern)pattern);
    }

    static {
        RobolectricInternals.classInitializing(Utility.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Utility)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

