/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.Punycode;
import android.icu.impl.UBiDiProps;
import android.icu.lang.UCharacter;
import android.icu.lang.UScript;
import android.icu.text.IDNA;
import android.icu.text.Normalizer2;
import android.icu.text.StringPrepParseException;
import android.icu.util.ICUException;
import com.google.errorprone.annotations.DoNotMock;
import java.util.EnumSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UTS46
extends IDNA
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static Normalizer2 uts46Norm2;
    int options;
    private static EnumSet<IDNA.Error> severeErrors;
    private static byte[] asciiData;
    private static int L_MASK;
    private static int R_AL_MASK;
    private static int L_R_AL_MASK;
    private static int R_AL_AN_MASK;
    private static int EN_AN_MASK;
    private static int R_AL_EN_AN_MASK;
    private static int L_EN_MASK;
    private static int ES_CS_ET_ON_BN_NSM_MASK;
    private static int L_EN_ES_CS_ET_ON_BN_NSM_MASK;
    private static int R_AL_AN_EN_ES_CS_ET_ON_BN_NSM_MASK;
    private static int U_GC_M_MASK;

    private void $$robo$$android_icu_impl_UTS46$__constructor__(int options) {
        this.options = options;
    }

    private final StringBuilder $$robo$$android_icu_impl_UTS46$labelToASCII(CharSequence label, StringBuilder dest, IDNA.Info info) {
        return this.process(label, true, true, dest, info);
    }

    private final StringBuilder $$robo$$android_icu_impl_UTS46$labelToUnicode(CharSequence label, StringBuilder dest, IDNA.Info info) {
        return this.process(label, true, false, dest, info);
    }

    private final StringBuilder $$robo$$android_icu_impl_UTS46$nameToASCII(CharSequence name, StringBuilder dest, IDNA.Info info) {
        this.process(name, false, true, dest, info);
        if (dest.length() >= 254 && !info.getErrors().contains((Object)IDNA.Error.DOMAIN_NAME_TOO_LONG) && UTS46.isASCIIString(dest) && (dest.length() > 254 || dest.charAt(253) != '.')) {
            UTS46.addError(info, IDNA.Error.DOMAIN_NAME_TOO_LONG);
        }
        return dest;
    }

    private final StringBuilder $$robo$$android_icu_impl_UTS46$nameToUnicode(CharSequence name, StringBuilder dest, IDNA.Info info) {
        return this.process(name, false, false, dest, info);
    }

    private static final boolean $$robo$$android_icu_impl_UTS46$isASCIIString(CharSequence dest) {
        int length = dest.length();
        for (int i = 0; i < length; ++i) {
            if (dest.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private final StringBuilder $$robo$$android_icu_impl_UTS46$process(CharSequence src, boolean isLabel, boolean toASCII, StringBuilder dest, IDNA.Info info) {
        if (dest == src) {
            throw new IllegalArgumentException();
        }
        dest.delete(0, Integer.MAX_VALUE);
        UTS46.resetInfo(info);
        int srcLength = src.length();
        if (srcLength == 0) {
            UTS46.addError(info, IDNA.Error.EMPTY_LABEL);
            return dest;
        }
        boolean disallowNonLDHDot = (this.options & 2) != 0;
        int labelStart = 0;
        int i = 0;
        while (true) {
            if (i == srcLength) {
                if (toASCII) {
                    if (i - labelStart > 63) {
                        UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                    }
                    if (!(isLabel || i < 254 || i <= 254 && labelStart >= i)) {
                        UTS46.addError(info, IDNA.Error.DOMAIN_NAME_TOO_LONG);
                    }
                }
                UTS46.promoteAndResetLabelErrors(info);
                return dest;
            }
            char c = src.charAt(i);
            if (c > '\u007f') break;
            byte cData = asciiData[c];
            if (cData > 0) {
                dest.append((char)(c + 32));
            } else {
                if (cData < 0 && disallowNonLDHDot) break;
                dest.append(c);
                if (c == '-') {
                    if (i == labelStart + 3 && src.charAt(i - 1) == '-') {
                        ++i;
                        break;
                    }
                    if (i == labelStart) {
                        UTS46.addLabelError(info, IDNA.Error.LEADING_HYPHEN);
                    }
                    if (i + 1 == srcLength || src.charAt(i + 1) == '.') {
                        UTS46.addLabelError(info, IDNA.Error.TRAILING_HYPHEN);
                    }
                } else if (c == '.') {
                    if (isLabel) {
                        ++i;
                        break;
                    }
                    if (i == labelStart) {
                        UTS46.addLabelError(info, IDNA.Error.EMPTY_LABEL);
                    }
                    if (toASCII && i - labelStart > 63) {
                        UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                    }
                    UTS46.promoteAndResetLabelErrors(info);
                    labelStart = i + 1;
                }
            }
            ++i;
        }
        UTS46.promoteAndResetLabelErrors(info);
        this.processUnicode(src, labelStart, i, isLabel, toASCII, dest, info);
        if (UTS46.isBiDi(info) && !UTS46.hasCertainErrors(info, severeErrors) && (!UTS46.isOkBiDi(info) || labelStart > 0 && !UTS46.isASCIIOkBiDi(dest, labelStart))) {
            UTS46.addError(info, IDNA.Error.BIDI);
        }
        return dest;
    }

    private final StringBuilder $$robo$$android_icu_impl_UTS46$processUnicode(CharSequence src, int labelStart, int mappingStart, boolean isLabel, boolean toASCII, StringBuilder dest, IDNA.Info info) {
        if (mappingStart == 0) {
            uts46Norm2.normalize(src, dest);
        } else {
            uts46Norm2.normalizeSecondAndAppend(dest, src.subSequence(mappingStart, src.length()));
        }
        boolean doMapDevChars = toASCII ? (this.options & 0x10) == 0 : (this.options & 0x20) == 0;
        int destLength = dest.length();
        int labelLimit = labelStart;
        while (labelLimit < destLength) {
            char c = dest.charAt(labelLimit);
            if (c == '.' && !isLabel) {
                int labelLength = labelLimit - labelStart;
                int newLength = this.processLabel(dest, labelStart, labelLength, toASCII, info);
                UTS46.promoteAndResetLabelErrors(info);
                destLength += newLength - labelLength;
                labelLimit = labelStart += newLength + 1;
                continue;
            }
            if ('\u00df' <= c && c <= '\u200d' && (c == '\u00df' || c == '\u03c2' || c >= '\u200c')) {
                UTS46.setTransitionalDifferent(info);
                if (doMapDevChars) {
                    destLength = this.mapDevChars(dest, labelStart, labelLimit);
                    doMapDevChars = false;
                    continue;
                }
                ++labelLimit;
                continue;
            }
            ++labelLimit;
        }
        if (0 == labelStart || labelStart < labelLimit) {
            this.processLabel(dest, labelStart, labelLimit - labelStart, toASCII, info);
            UTS46.promoteAndResetLabelErrors(info);
        }
        return dest;
    }

    private final int $$robo$$android_icu_impl_UTS46$mapDevChars(StringBuilder dest, int labelStart, int mappingStart) {
        int length = dest.length();
        boolean didMapDevChars = false;
        int i = mappingStart;
        block5: while (i < length) {
            char c = dest.charAt(i);
            switch (c) {
                case '\u00df': {
                    didMapDevChars = true;
                    dest.setCharAt(i++, 's');
                    dest.insert(i++, 's');
                    ++length;
                    continue block5;
                }
                case '\u03c2': {
                    didMapDevChars = true;
                    dest.setCharAt(i++, '\u03c3');
                    continue block5;
                }
                case '\u200c': 
                case '\u200d': {
                    didMapDevChars = true;
                    dest.delete(i, i + 1);
                    --length;
                    continue block5;
                }
            }
            ++i;
        }
        if (didMapDevChars) {
            String normalized = uts46Norm2.normalize(dest.subSequence(labelStart, dest.length()));
            dest.replace(labelStart, Integer.MAX_VALUE, normalized);
            return dest.length();
        }
        return length;
    }

    private static final boolean $$robo$$android_icu_impl_UTS46$isNonASCIIDisallowedSTD3Valid(int c) {
        return c == 8800 || c == 8814 || c == 8815;
    }

    private static final int $$robo$$android_icu_impl_UTS46$replaceLabel(StringBuilder dest, int destLabelStart, int destLabelLength, CharSequence label, int labelLength) {
        if (label != dest) {
            dest.delete(destLabelStart, destLabelStart + destLabelLength).insert(destLabelStart, label);
        }
        return labelLength;
    }

    private final int $$robo$$android_icu_impl_UTS46$processLabel(StringBuilder dest, int labelStart, int labelLength, boolean toASCII, IDNA.Info info) {
        int c;
        boolean disallowNonLDHDot;
        StringBuilder labelString;
        boolean wasPunycode;
        int destLabelStart = labelStart;
        int destLabelLength = labelLength;
        if (labelLength >= 4 && dest.charAt(labelStart) == 'x' && dest.charAt(labelStart + 1) == 'n' && dest.charAt(labelStart + 2) == '-' && dest.charAt(labelStart + 3) == '-') {
            StringBuilder fromPunycode;
            wasPunycode = true;
            try {
                fromPunycode = Punycode.decode(dest.subSequence(labelStart + 4, labelStart + labelLength), null);
            }
            catch (StringPrepParseException e) {
                UTS46.addLabelError(info, IDNA.Error.PUNYCODE);
                return this.markBadACELabel(dest, labelStart, labelLength, toASCII, info);
            }
            boolean isValid = uts46Norm2.isNormalized(fromPunycode);
            if (!isValid) {
                UTS46.addLabelError(info, IDNA.Error.INVALID_ACE_LABEL);
                return this.markBadACELabel(dest, labelStart, labelLength, toASCII, info);
            }
            labelString = fromPunycode;
            labelStart = 0;
            labelLength = fromPunycode.length();
        } else {
            wasPunycode = false;
            labelString = dest;
        }
        if (labelLength == 0) {
            UTS46.addLabelError(info, IDNA.Error.EMPTY_LABEL);
            return UTS46.replaceLabel(dest, destLabelStart, destLabelLength, labelString, labelLength);
        }
        if (labelLength >= 4 && labelString.charAt(labelStart + 2) == '-' && labelString.charAt(labelStart + 3) == '-') {
            UTS46.addLabelError(info, IDNA.Error.HYPHEN_3_4);
        }
        if (labelString.charAt(labelStart) == '-') {
            UTS46.addLabelError(info, IDNA.Error.LEADING_HYPHEN);
        }
        if (labelString.charAt(labelStart + labelLength - 1) == '-') {
            UTS46.addLabelError(info, IDNA.Error.TRAILING_HYPHEN);
        }
        int i = labelStart;
        int limit = labelStart + labelLength;
        char oredChars = '\u0000';
        boolean bl = disallowNonLDHDot = (this.options & 2) != 0;
        do {
            if ((c = labelString.charAt(i)) <= 127) {
                if (c == 46) {
                    UTS46.addLabelError(info, IDNA.Error.LABEL_HAS_DOT);
                    labelString.setCharAt(i, '\ufffd');
                    continue;
                }
                if (!disallowNonLDHDot || asciiData[c] >= 0) continue;
                UTS46.addLabelError(info, IDNA.Error.DISALLOWED);
                labelString.setCharAt(i, '\ufffd');
                continue;
            }
            oredChars = (char)(oredChars | c);
            if (disallowNonLDHDot && UTS46.isNonASCIIDisallowedSTD3Valid(c)) {
                UTS46.addLabelError(info, IDNA.Error.DISALLOWED);
                labelString.setCharAt(i, '\ufffd');
                continue;
            }
            if (c != 65533) continue;
            UTS46.addLabelError(info, IDNA.Error.DISALLOWED);
        } while (++i < limit);
        c = labelString.codePointAt(labelStart);
        if ((UTS46.U_GET_GC_MASK(c) & U_GC_M_MASK) != 0) {
            UTS46.addLabelError(info, IDNA.Error.LEADING_COMBINING_MARK);
            labelString.setCharAt(labelStart, '\ufffd');
            if (c > 65535) {
                labelString.deleteCharAt(labelStart + 1);
                --labelLength;
                if (labelString == dest) {
                    --destLabelLength;
                }
            }
        }
        if (!UTS46.hasCertainLabelErrors(info, severeErrors)) {
            if ((this.options & 4) != 0 && (!UTS46.isBiDi(info) || UTS46.isOkBiDi(info))) {
                this.checkLabelBiDi(labelString, labelStart, labelLength, info);
            }
            if ((this.options & 8) != 0 && (oredChars & 0x200C) == 8204 && !this.isLabelOkContextJ(labelString, labelStart, labelLength)) {
                UTS46.addLabelError(info, IDNA.Error.CONTEXTJ);
            }
            if ((this.options & 0x40) != 0 && oredChars >= '\u00b7') {
                this.checkLabelContextO(labelString, labelStart, labelLength, info);
            }
            if (toASCII) {
                if (wasPunycode) {
                    if (destLabelLength > 63) {
                        UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                    }
                    return destLabelLength;
                }
                if (oredChars >= '\u0080') {
                    StringBuilder punycode;
                    try {
                        punycode = Punycode.encode(labelString.subSequence(labelStart, labelStart + labelLength), null);
                    }
                    catch (StringPrepParseException e) {
                        throw new ICUException(e);
                    }
                    punycode.insert(0, "xn--");
                    if (punycode.length() > 63) {
                        UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                    }
                    return UTS46.replaceLabel(dest, destLabelStart, destLabelLength, punycode, punycode.length());
                }
                if (labelLength > 63) {
                    UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                }
            }
        } else if (wasPunycode) {
            UTS46.addLabelError(info, IDNA.Error.INVALID_ACE_LABEL);
            return this.markBadACELabel(dest, destLabelStart, destLabelLength, toASCII, info);
        }
        return UTS46.replaceLabel(dest, destLabelStart, destLabelLength, labelString, labelLength);
    }

    private final int $$robo$$android_icu_impl_UTS46$markBadACELabel(StringBuilder dest, int labelStart, int labelLength, boolean toASCII, IDNA.Info info) {
        boolean disallowNonLDHDot = (this.options & 2) != 0;
        boolean isASCII = true;
        boolean onlyLDH = true;
        int i = labelStart + 4;
        int limit = labelStart + labelLength;
        do {
            char c;
            if ((c = dest.charAt(i)) <= '\u007f') {
                if (c == '.') {
                    UTS46.addLabelError(info, IDNA.Error.LABEL_HAS_DOT);
                    dest.setCharAt(i, '\ufffd');
                    onlyLDH = false;
                    isASCII = false;
                    continue;
                }
                if (asciiData[c] >= 0) continue;
                onlyLDH = false;
                if (!disallowNonLDHDot) continue;
                dest.setCharAt(i, '\ufffd');
                isASCII = false;
                continue;
            }
            onlyLDH = false;
            isASCII = false;
        } while (++i < limit);
        if (onlyLDH) {
            dest.insert(labelStart + labelLength, '\ufffd');
            ++labelLength;
        } else if (toASCII && isASCII && labelLength > 63) {
            UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
        }
        return labelLength;
    }

    private final void $$robo$$android_icu_impl_UTS46$checkLabelBiDi(CharSequence label, int labelStart, int labelLength, IDNA.Info info) {
        int lastMask;
        int labelLimit;
        int firstMask;
        int c;
        int i;
        block11: {
            int dir;
            i = labelStart;
            c = Character.codePointAt(label, i);
            i += Character.charCount(c);
            firstMask = UTS46.U_MASK(UBiDiProps.INSTANCE.getClass(c));
            if ((firstMask & ~L_R_AL_MASK) != 0) {
                UTS46.setNotOkBiDi(info);
            }
            labelLimit = labelStart + labelLength;
            do {
                if (i >= labelLimit) {
                    lastMask = firstMask;
                    break block11;
                }
                c = Character.codePointBefore(label, labelLimit);
                labelLimit -= Character.charCount(c);
            } while ((dir = UBiDiProps.INSTANCE.getClass(c)) == 17);
            lastMask = UTS46.U_MASK(dir);
        }
        if ((firstMask & L_MASK) != 0 ? (lastMask & ~L_EN_MASK) != 0 : (lastMask & ~R_AL_EN_AN_MASK) != 0) {
            UTS46.setNotOkBiDi(info);
        }
        int mask = 0;
        while (i < labelLimit) {
            c = Character.codePointAt(label, i);
            i += Character.charCount(c);
            mask |= UTS46.U_MASK(UBiDiProps.INSTANCE.getClass(c));
        }
        if ((firstMask & L_MASK) != 0) {
            if ((mask & ~L_EN_ES_CS_ET_ON_BN_NSM_MASK) != 0) {
                UTS46.setNotOkBiDi(info);
            }
        } else {
            if ((mask & ~R_AL_AN_EN_ES_CS_ET_ON_BN_NSM_MASK) != 0) {
                UTS46.setNotOkBiDi(info);
            }
            if ((mask & EN_AN_MASK) == EN_AN_MASK) {
                UTS46.setNotOkBiDi(info);
            }
        }
        if (((firstMask | mask | lastMask) & R_AL_AN_MASK) != 0) {
            UTS46.setBiDi(info);
        }
    }

    private static final boolean $$robo$$android_icu_impl_UTS46$isASCIIOkBiDi(CharSequence s, int length) {
        int labelStart = 0;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '.') {
                if (!(i <= labelStart || 'a' <= (c = s.charAt(i - 1)) && c <= 'z' || '0' <= c && c <= '9')) {
                    return false;
                }
                labelStart = i + 1;
                continue;
            }
            if (!(i == labelStart ? 'a' > c || c > 'z' : c <= ' ' && (c >= '\u001c' || '\t' <= c && c <= '\r'))) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_icu_impl_UTS46$isLabelOkContextJ(CharSequence label, int labelStart, int labelLength) {
        int labelLimit = labelStart + labelLength;
        for (int i = labelStart; i < labelLimit; ++i) {
            int c;
            if (label.charAt(i) == '\u200c') {
                int type;
                if (i == labelStart) {
                    return false;
                }
                int j = i;
                c = Character.codePointBefore(label, j);
                j -= Character.charCount(c);
                if (uts46Norm2.getCombiningClass(c) == 9) continue;
                while ((type = UBiDiProps.INSTANCE.getJoiningType(c)) == 5) {
                    if (j == 0) {
                        return false;
                    }
                    c = Character.codePointBefore(label, j);
                    j -= Character.charCount(c);
                }
                if (type != 3 && type != 2) {
                    return false;
                }
                j = i + 1;
                do {
                    if (j == labelLimit) {
                        return false;
                    }
                    c = Character.codePointAt(label, j);
                    j += Character.charCount(c);
                } while ((type = UBiDiProps.INSTANCE.getJoiningType(c)) == 5);
                if (type == 4 || type == 2) continue;
                return false;
            }
            if (label.charAt(i) != '\u200d') continue;
            if (i == labelStart) {
                return false;
            }
            c = Character.codePointBefore(label, i);
            if (uts46Norm2.getCombiningClass(c) == 9) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_icu_impl_UTS46$checkLabelContextO(CharSequence label, int labelStart, int labelLength, IDNA.Info info) {
        int labelEnd = labelStart + labelLength - 1;
        int arabicDigits = 0;
        block0: for (int i = labelStart; i <= labelEnd; ++i) {
            int c = label.charAt(i);
            if (c < 183) continue;
            if (c <= 1785) {
                if (c == 183) {
                    if (labelStart < i && label.charAt(i - 1) == 'l' && i < labelEnd && label.charAt(i + 1) == 'l') continue;
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_PUNCTUATION);
                    continue;
                }
                if (c == 885) {
                    if (i < labelEnd && 14 == UScript.getScript(Character.codePointAt(label, i + 1))) continue;
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_PUNCTUATION);
                    continue;
                }
                if (c == 1523 || c == 1524) {
                    if (labelStart < i && 19 == UScript.getScript(Character.codePointBefore(label, i))) continue;
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_PUNCTUATION);
                    continue;
                }
                if (1632 > c) continue;
                if (c <= 1641) {
                    if (arabicDigits > 0) {
                        UTS46.addLabelError(info, IDNA.Error.CONTEXTO_DIGITS);
                    }
                    arabicDigits = -1;
                    continue;
                }
                if (1776 > c) continue;
                if (arabicDigits < 0) {
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_DIGITS);
                }
                arabicDigits = 1;
                continue;
            }
            if (c != 12539) continue;
            int j = labelStart;
            while (true) {
                if (j > labelEnd) {
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_PUNCTUATION);
                    continue block0;
                }
                c = Character.codePointAt(label, j);
                int script = UScript.getScript(c);
                if (script == 20 || script == 22 || script == 17) continue block0;
                j += Character.charCount(c);
            }
        }
    }

    private static final int $$robo$$android_icu_impl_UTS46$U_MASK(int x) {
        return 1 << x;
    }

    private static final int $$robo$$android_icu_impl_UTS46$U_GET_GC_MASK(int c) {
        return 1 << UCharacter.getType(c);
    }

    static void __staticInitializer__() {
        uts46Norm2 = Normalizer2.getInstance(null, "uts46", Normalizer2.Mode.COMPOSE);
        severeErrors = EnumSet.of(IDNA.Error.LEADING_COMBINING_MARK, IDNA.Error.DISALLOWED, IDNA.Error.PUNYCODE, IDNA.Error.LABEL_HAS_DOT, IDNA.Error.INVALID_ACE_LABEL);
        asciiData = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1};
        L_MASK = UTS46.U_MASK(0);
        R_AL_MASK = UTS46.U_MASK(1) | UTS46.U_MASK(13);
        L_R_AL_MASK = L_MASK | R_AL_MASK;
        R_AL_AN_MASK = R_AL_MASK | UTS46.U_MASK(5);
        EN_AN_MASK = UTS46.U_MASK(2) | UTS46.U_MASK(5);
        R_AL_EN_AN_MASK = R_AL_MASK | EN_AN_MASK;
        L_EN_MASK = L_MASK | UTS46.U_MASK(2);
        ES_CS_ET_ON_BN_NSM_MASK = UTS46.U_MASK(3) | UTS46.U_MASK(6) | UTS46.U_MASK(4) | UTS46.U_MASK(10) | UTS46.U_MASK(18) | UTS46.U_MASK(17);
        L_EN_ES_CS_ET_ON_BN_NSM_MASK = L_EN_MASK | ES_CS_ET_ON_BN_NSM_MASK;
        R_AL_AN_EN_ES_CS_ET_ON_BN_NSM_MASK = R_AL_MASK | EN_AN_MASK | ES_CS_ET_ON_BN_NSM_MASK;
        U_GC_M_MASK = UTS46.U_MASK(6) | UTS46.U_MASK(7) | UTS46.U_MASK(8);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_icu_impl_UTS46$__constructor__(n);
    }

    public UTS46(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UTS46$__constructor__(int ), this, n);
    }

    @Override
    public StringBuilder labelToASCII(CharSequence charSequence, StringBuilder stringBuilder, IDNA.Info info) {
        return InvokeDynamicSupport.bootstrap("labelToASCII", $$robo$$android_icu_impl_UTS46$labelToASCII(java.lang.CharSequence java.lang.StringBuilder android.icu.text.IDNA$Info ), this, charSequence, stringBuilder, info);
    }

    @Override
    public StringBuilder labelToUnicode(CharSequence charSequence, StringBuilder stringBuilder, IDNA.Info info) {
        return InvokeDynamicSupport.bootstrap("labelToUnicode", $$robo$$android_icu_impl_UTS46$labelToUnicode(java.lang.CharSequence java.lang.StringBuilder android.icu.text.IDNA$Info ), this, charSequence, stringBuilder, info);
    }

    @Override
    public StringBuilder nameToASCII(CharSequence charSequence, StringBuilder stringBuilder, IDNA.Info info) {
        return InvokeDynamicSupport.bootstrap("nameToASCII", $$robo$$android_icu_impl_UTS46$nameToASCII(java.lang.CharSequence java.lang.StringBuilder android.icu.text.IDNA$Info ), this, charSequence, stringBuilder, info);
    }

    @Override
    public StringBuilder nameToUnicode(CharSequence charSequence, StringBuilder stringBuilder, IDNA.Info info) {
        return InvokeDynamicSupport.bootstrap("nameToUnicode", $$robo$$android_icu_impl_UTS46$nameToUnicode(java.lang.CharSequence java.lang.StringBuilder android.icu.text.IDNA$Info ), this, charSequence, stringBuilder, info);
    }

    private static boolean isASCIIString(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isASCIIString", $$robo$$android_icu_impl_UTS46$isASCIIString(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    private StringBuilder process(CharSequence charSequence, boolean bl, boolean bl2, StringBuilder stringBuilder, IDNA.Info info) {
        return InvokeDynamicSupport.bootstrap("process", $$robo$$android_icu_impl_UTS46$process(java.lang.CharSequence boolean boolean java.lang.StringBuilder android.icu.text.IDNA$Info ), this, charSequence, bl, bl2, stringBuilder, info);
    }

    private StringBuilder processUnicode(CharSequence charSequence, int n, int n2, boolean bl, boolean bl2, StringBuilder stringBuilder, IDNA.Info info) {
        return InvokeDynamicSupport.bootstrap("processUnicode", $$robo$$android_icu_impl_UTS46$processUnicode(java.lang.CharSequence int int boolean boolean java.lang.StringBuilder android.icu.text.IDNA$Info ), this, charSequence, n, n2, bl, bl2, stringBuilder, info);
    }

    private int mapDevChars(StringBuilder stringBuilder, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("mapDevChars", $$robo$$android_icu_impl_UTS46$mapDevChars(java.lang.StringBuilder int int ), this, stringBuilder, n, n2);
    }

    private static boolean isNonASCIIDisallowedSTD3Valid(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNonASCIIDisallowedSTD3Valid", $$robo$$android_icu_impl_UTS46$isNonASCIIDisallowedSTD3Valid(int ), (int)n);
    }

    private static int replaceLabel(StringBuilder stringBuilder, int n, int n2, CharSequence charSequence, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("replaceLabel", $$robo$$android_icu_impl_UTS46$replaceLabel(java.lang.StringBuilder int int java.lang.CharSequence int ), (StringBuilder)stringBuilder, (int)n, (int)n2, (CharSequence)charSequence, (int)n3);
    }

    private int processLabel(StringBuilder stringBuilder, int n, int n2, boolean bl, IDNA.Info info) {
        return (int)InvokeDynamicSupport.bootstrap("processLabel", $$robo$$android_icu_impl_UTS46$processLabel(java.lang.StringBuilder int int boolean android.icu.text.IDNA$Info ), this, stringBuilder, n, n2, bl, info);
    }

    private int markBadACELabel(StringBuilder stringBuilder, int n, int n2, boolean bl, IDNA.Info info) {
        return (int)InvokeDynamicSupport.bootstrap("markBadACELabel", $$robo$$android_icu_impl_UTS46$markBadACELabel(java.lang.StringBuilder int int boolean android.icu.text.IDNA$Info ), this, stringBuilder, n, n2, bl, info);
    }

    private void checkLabelBiDi(CharSequence charSequence, int n, int n2, IDNA.Info info) {
        InvokeDynamicSupport.bootstrap("checkLabelBiDi", $$robo$$android_icu_impl_UTS46$checkLabelBiDi(java.lang.CharSequence int int android.icu.text.IDNA$Info ), this, charSequence, n, n2, info);
    }

    private static boolean isASCIIOkBiDi(CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isASCIIOkBiDi", $$robo$$android_icu_impl_UTS46$isASCIIOkBiDi(java.lang.CharSequence int ), (CharSequence)charSequence, (int)n);
    }

    private boolean isLabelOkContextJ(CharSequence charSequence, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLabelOkContextJ", $$robo$$android_icu_impl_UTS46$isLabelOkContextJ(java.lang.CharSequence int int ), this, charSequence, n, n2);
    }

    private void checkLabelContextO(CharSequence charSequence, int n, int n2, IDNA.Info info) {
        InvokeDynamicSupport.bootstrap("checkLabelContextO", $$robo$$android_icu_impl_UTS46$checkLabelContextO(java.lang.CharSequence int int android.icu.text.IDNA$Info ), this, charSequence, n, n2, info);
    }

    private static int U_MASK(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("U_MASK", $$robo$$android_icu_impl_UTS46$U_MASK(int ), (int)n);
    }

    private static int U_GET_GC_MASK(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("U_GET_GC_MASK", $$robo$$android_icu_impl_UTS46$U_GET_GC_MASK(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(UTS46.class);
    }

    public /* synthetic */ UTS46() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UTS46)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

