/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie2_16;
import android.icu.impl.Trie2_32;
import com.google.errorprone.annotations.DoNotMock;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Trie2
implements Iterable<Range> {
    public /* synthetic */ Object __robo_data__;
    private static ValueMapper defaultValueMapper;
    UTrie2Header header;
    char[] index;
    int data16;
    int[] data32;
    int indexLength;
    int dataLength;
    int index2NullOffset;
    int initialValue;
    int errorValue;
    int highStart;
    int highValueIndex;
    int dataNullOffset;
    int fHash;
    static int UTRIE2_OPTIONS_VALUE_BITS_MASK = 15;
    static int UTRIE2_SHIFT_1 = 11;
    static int UTRIE2_SHIFT_2 = 5;
    static int UTRIE2_SHIFT_1_2 = 6;
    static int UTRIE2_OMITTED_BMP_INDEX_1_LENGTH = 32;
    static int UTRIE2_CP_PER_INDEX_1_ENTRY = 2048;
    static int UTRIE2_INDEX_2_BLOCK_LENGTH = 64;
    static int UTRIE2_INDEX_2_MASK = 63;
    static int UTRIE2_DATA_BLOCK_LENGTH = 32;
    static int UTRIE2_DATA_MASK = 31;
    static int UTRIE2_INDEX_SHIFT = 2;
    static int UTRIE2_DATA_GRANULARITY = 4;
    static int UTRIE2_INDEX_2_OFFSET = 0;
    static int UTRIE2_LSCP_INDEX_2_OFFSET = 2048;
    static int UTRIE2_LSCP_INDEX_2_LENGTH = 32;
    static int UTRIE2_INDEX_2_BMP_LENGTH = 2080;
    static int UTRIE2_UTF8_2B_INDEX_2_OFFSET = 2080;
    static int UTRIE2_UTF8_2B_INDEX_2_LENGTH = 32;
    static int UTRIE2_INDEX_1_OFFSET = 2112;
    static int UTRIE2_MAX_INDEX_1_LENGTH = 512;
    static int UTRIE2_BAD_UTF8_DATA_OFFSET = 128;
    static int UTRIE2_DATA_START_OFFSET = 192;
    static int UNEWTRIE2_INDEX_GAP_OFFSET = 2080;
    static int UNEWTRIE2_INDEX_GAP_LENGTH = 576;
    static int UNEWTRIE2_MAX_INDEX_2_LENGTH = 35488;
    static int UNEWTRIE2_INDEX_1_LENGTH = 544;
    static int UNEWTRIE2_MAX_DATA_LENGTH = 1115264;

    private void $$robo$$android_icu_impl_Trie2$__constructor__() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Trie2 $$robo$$android_icu_impl_Trie2$createFromSerialized(ByteBuffer bytes) throws IOException {
        ByteOrder outerByteOrder = bytes.order();
        try {
            Trie2 This;
            ValueWidth width;
            UTrie2Header header = new UTrie2Header();
            header.signature = bytes.getInt();
            switch (header.signature) {
                case 1416784178: {
                    break;
                }
                case 845771348: {
                    boolean isBigEndian = outerByteOrder == ByteOrder.BIG_ENDIAN;
                    bytes.order(isBigEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    header.signature = 1416784178;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Buffer does not contain a serialized UTrie2");
                }
            }
            header.options = bytes.getChar();
            header.indexLength = bytes.getChar();
            header.shiftedDataLength = bytes.getChar();
            header.index2NullOffset = bytes.getChar();
            header.dataNullOffset = bytes.getChar();
            header.shiftedHighStart = bytes.getChar();
            if ((header.options & 0xF) > 1) {
                throw new IllegalArgumentException("UTrie2 serialized format error.");
            }
            if ((header.options & 0xF) == 0) {
                width = ValueWidth.BITS_16;
                This = new Trie2_16();
            } else {
                width = ValueWidth.BITS_32;
                This = new Trie2_32();
            }
            This.header = header;
            This.indexLength = header.indexLength;
            This.dataLength = header.shiftedDataLength << 2;
            This.index2NullOffset = header.index2NullOffset;
            This.dataNullOffset = header.dataNullOffset;
            This.highStart = header.shiftedHighStart << 11;
            This.highValueIndex = This.dataLength - 4;
            if (width == ValueWidth.BITS_16) {
                This.highValueIndex += This.indexLength;
            }
            int indexArraySize = This.indexLength;
            if (width == ValueWidth.BITS_16) {
                indexArraySize += This.dataLength;
            }
            This.index = ICUBinary.getChars(bytes, indexArraySize, 0);
            if (width == ValueWidth.BITS_16) {
                This.data16 = This.indexLength;
            } else {
                This.data32 = ICUBinary.getInts(bytes, This.dataLength, 0);
            }
            switch (2.$SwitchMap$android$icu$impl$Trie2$ValueWidth[width.ordinal()]) {
                case 1: {
                    This.data32 = null;
                    This.initialValue = This.index[This.dataNullOffset];
                    This.errorValue = This.index[This.data16 + 128];
                    break;
                }
                case 2: {
                    This.data16 = 0;
                    This.initialValue = This.data32[This.dataNullOffset];
                    This.errorValue = This.data32[128];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("UTrie2 serialized format error.");
                }
            }
            Trie2 trie2 = This;
            return trie2;
        }
        finally {
            bytes.order(outerByteOrder);
        }
    }

    private static final int $$robo$$android_icu_impl_Trie2$getVersion(InputStream is, boolean littleEndianOk) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark().");
        }
        is.mark(4);
        byte[] sig = new byte[4];
        int read = is.read(sig);
        is.reset();
        if (read != sig.length) {
            return 0;
        }
        if (sig[0] == 84 && sig[1] == 114 && sig[2] == 105 && sig[3] == 101) {
            return 1;
        }
        if (sig[0] == 84 && sig[1] == 114 && sig[2] == 105 && sig[3] == 50) {
            return 2;
        }
        if (littleEndianOk) {
            if (sig[0] == 101 && sig[1] == 105 && sig[2] == 114 && sig[3] == 84) {
                return 1;
            }
            if (sig[0] == 50 && sig[1] == 105 && sig[2] == 114 && sig[3] == 84) {
                return 2;
            }
        }
        return 0;
    }

    public abstract int get(int var1);

    public abstract int getFromU16SingleLead(char var1);

    private final boolean $$robo$$android_icu_impl_Trie2$equals(Object other) {
        if (!(other instanceof Trie2)) {
            return false;
        }
        Trie2 OtherTrie = (Trie2)other;
        Iterator<Range> otherIter = OtherTrie.iterator();
        for (Range rangeFromThis : this) {
            if (!otherIter.hasNext()) {
                return false;
            }
            Range rangeFromOther = otherIter.next();
            if (rangeFromThis.equals(rangeFromOther)) continue;
            return false;
        }
        if (otherIter.hasNext()) {
            return false;
        }
        return this.errorValue == OtherTrie.errorValue && this.initialValue == OtherTrie.initialValue;
    }

    private final int $$robo$$android_icu_impl_Trie2$hashCode() {
        if (this.fHash == 0) {
            int hash = Trie2.initHash();
            for (Range r : this) {
                hash = Trie2.hashInt(hash, r.hashCode());
            }
            if (hash == 0) {
                hash = 1;
            }
            this.fHash = hash;
        }
        return this.fHash;
    }

    private final Iterator<Range> $$robo$$android_icu_impl_Trie2$iterator() {
        return this.iterator(defaultValueMapper);
    }

    private final Iterator<Range> $$robo$$android_icu_impl_Trie2$iterator(ValueMapper mapper) {
        return new Trie2Iterator(this, mapper);
    }

    private final Iterator<Range> $$robo$$android_icu_impl_Trie2$iteratorForLeadSurrogate(char lead, ValueMapper mapper) {
        return new Trie2Iterator(this, lead, mapper);
    }

    private final Iterator<Range> $$robo$$android_icu_impl_Trie2$iteratorForLeadSurrogate(char lead) {
        return new Trie2Iterator(this, lead, defaultValueMapper);
    }

    private final int $$robo$$android_icu_impl_Trie2$serializeHeader(DataOutputStream dos) throws IOException {
        int bytesWritten = 0;
        dos.writeInt(this.header.signature);
        dos.writeShort(this.header.options);
        dos.writeShort(this.header.indexLength);
        dos.writeShort(this.header.shiftedDataLength);
        dos.writeShort(this.header.index2NullOffset);
        dos.writeShort(this.header.dataNullOffset);
        dos.writeShort(this.header.shiftedHighStart);
        bytesWritten += 16;
        for (int i = 0; i < this.header.indexLength; ++i) {
            dos.writeChar(this.index[i]);
        }
        return bytesWritten += this.header.indexLength;
    }

    private final CharSequenceIterator $$robo$$android_icu_impl_Trie2$charSequenceIterator(CharSequence text, int index) {
        return new CharSequenceIterator(this, text, index);
    }

    private final int $$robo$$android_icu_impl_Trie2$rangeEnd(int start, int limitp, int val) {
        int c;
        int limit = Math.min(this.highStart, limitp);
        for (c = start + 1; c < limit && this.get(c) == val; ++c) {
        }
        if (c >= this.highStart) {
            c = limitp;
        }
        return c - 1;
    }

    private static final int $$robo$$android_icu_impl_Trie2$initHash() {
        return -2128831035;
    }

    private static final int $$robo$$android_icu_impl_Trie2$hashByte(int h, int b) {
        h *= 16777619;
        return h ^= b;
    }

    private static final int $$robo$$android_icu_impl_Trie2$hashUChar32(int h, int c) {
        h = Trie2.hashByte(h, c & 0xFF);
        h = Trie2.hashByte(h, c >> 8 & 0xFF);
        h = Trie2.hashByte(h, c >> 16);
        return h;
    }

    private static final int $$robo$$android_icu_impl_Trie2$hashInt(int h, int i) {
        h = Trie2.hashByte(h, i & 0xFF);
        h = Trie2.hashByte(h, i >> 8 & 0xFF);
        h = Trie2.hashByte(h, i >> 16 & 0xFF);
        h = Trie2.hashByte(h, i >> 24 & 0xFF);
        return h;
    }

    static void __staticInitializer__() {
        defaultValueMapper = new ValueMapper(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_impl_Trie2_1$__constructor__() {
            }

            private final int $$robo$$android_icu_impl_Trie2_1$map(int in) {
                return in;
            }

            private void __constructor__() {
                this.$$robo$$android_icu_impl_Trie2_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2_1$__constructor__(), this);
            }

            @Override
            public int map(int n) {
                return (int)InvokeDynamicSupport.bootstrap("map", $$robo$$android_icu_impl_Trie2_1$map(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_Trie2$__constructor__();
    }

    public Trie2() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2$__constructor__(), this);
    }

    public static Trie2 createFromSerialized(ByteBuffer byteBuffer) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromSerialized", $$robo$$android_icu_impl_Trie2$createFromSerialized(java.nio.ByteBuffer ), (ByteBuffer)byteBuffer);
    }

    public static int getVersion(InputStream inputStream, boolean bl) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getVersion", $$robo$$android_icu_impl_Trie2$getVersion(java.io.InputStream boolean ), (InputStream)inputStream, (boolean)bl);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_Trie2$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_Trie2$hashCode(), this);
    }

    @Override
    public Iterator<Range> iterator() {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_impl_Trie2$iterator(), this);
    }

    public Iterator<Range> iterator(ValueMapper valueMapper) {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_impl_Trie2$iterator(android.icu.impl.Trie2$ValueMapper ), this, valueMapper);
    }

    public Iterator<Range> iteratorForLeadSurrogate(char c, ValueMapper valueMapper) {
        return InvokeDynamicSupport.bootstrap("iteratorForLeadSurrogate", $$robo$$android_icu_impl_Trie2$iteratorForLeadSurrogate(char android.icu.impl.Trie2$ValueMapper ), this, c, valueMapper);
    }

    public Iterator<Range> iteratorForLeadSurrogate(char c) {
        return InvokeDynamicSupport.bootstrap("iteratorForLeadSurrogate", $$robo$$android_icu_impl_Trie2$iteratorForLeadSurrogate(char ), this, c);
    }

    protected int serializeHeader(DataOutputStream dataOutputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("serializeHeader", $$robo$$android_icu_impl_Trie2$serializeHeader(java.io.DataOutputStream ), this, dataOutputStream);
    }

    public CharSequenceIterator charSequenceIterator(CharSequence charSequence, int n) {
        return InvokeDynamicSupport.bootstrap("charSequenceIterator", $$robo$$android_icu_impl_Trie2$charSequenceIterator(java.lang.CharSequence int ), this, charSequence, n);
    }

    int rangeEnd(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("rangeEnd", $$robo$$android_icu_impl_Trie2$rangeEnd(int int int ), this, n, n2, n3);
    }

    private static int initHash() {
        return (int)InvokeDynamicSupport.bootstrapStatic("initHash", $$robo$$android_icu_impl_Trie2$initHash());
    }

    private static int hashByte(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("hashByte", $$robo$$android_icu_impl_Trie2$hashByte(int int ), (int)n, (int)n2);
    }

    private static int hashUChar32(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("hashUChar32", $$robo$$android_icu_impl_Trie2$hashUChar32(int int ), (int)n, (int)n2);
    }

    private static int hashInt(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("hashInt", $$robo$$android_icu_impl_Trie2$hashInt(int int ), (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(Trie2.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Trie2)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Trie2Iterator
    implements Iterator<Range> {
        public /* synthetic */ Object __robo_data__;
        private ValueMapper mapper;
        private Range returnValue;
        private int nextStart;
        private int limitCP;
        private boolean doingCodePoints;
        private boolean doLeadSurrogates;
        /* synthetic */ Trie2 this$0;

        private void $$robo$$android_icu_impl_Trie2_Trie2Iterator$__constructor__(Trie2 this$0, ValueMapper vm) {
            this.returnValue = new Range();
            this.doingCodePoints = true;
            this.doLeadSurrogates = true;
            this.mapper = vm;
            this.nextStart = 0;
            this.limitCP = 0x110000;
            this.doLeadSurrogates = true;
        }

        private void $$robo$$android_icu_impl_Trie2_Trie2Iterator$__constructor__(Trie2 this$0, char leadSurrogate, ValueMapper vm) {
            this.returnValue = new Range();
            this.doingCodePoints = true;
            this.doLeadSurrogates = true;
            if (leadSurrogate < '\ud800' || leadSurrogate > '\udbff') {
                throw new IllegalArgumentException("Bad lead surrogate value.");
            }
            this.mapper = vm;
            this.nextStart = leadSurrogate - 55232 << 10;
            this.limitCP = this.nextStart + 1024;
            this.doLeadSurrogates = false;
        }

        private final Range $$robo$$android_icu_impl_Trie2_Trie2Iterator$next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextStart >= this.limitCP) {
                this.doingCodePoints = false;
                this.nextStart = 55296;
            }
            int endOfRange = 0;
            int val = 0;
            int mappedVal = 0;
            if (this.doingCodePoints) {
                val = this.this$0.get(this.nextStart);
                mappedVal = this.mapper.map(val);
                endOfRange = this.this$0.rangeEnd(this.nextStart, this.limitCP, val);
                while (endOfRange < this.limitCP - 1 && this.mapper.map(val = this.this$0.get(endOfRange + 1)) == mappedVal) {
                    endOfRange = this.this$0.rangeEnd(endOfRange + 1, this.limitCP, val);
                }
            } else {
                val = this.this$0.getFromU16SingleLead((char)this.nextStart);
                mappedVal = this.mapper.map(val);
                endOfRange = this.rangeEndLS((char)this.nextStart);
                while (endOfRange < 56319 && this.mapper.map(val = this.this$0.getFromU16SingleLead((char)(endOfRange + 1))) == mappedVal) {
                    endOfRange = this.rangeEndLS((char)(endOfRange + 1));
                }
            }
            this.returnValue.startCodePoint = this.nextStart;
            this.returnValue.endCodePoint = endOfRange;
            this.returnValue.value = mappedVal;
            this.returnValue.leadSurrogate = !this.doingCodePoints;
            this.nextStart = endOfRange + 1;
            return this.returnValue;
        }

        private final boolean $$robo$$android_icu_impl_Trie2_Trie2Iterator$hasNext() {
            return this.doingCodePoints && (this.doLeadSurrogates || this.nextStart < this.limitCP) || this.nextStart < 56320;
        }

        private final void $$robo$$android_icu_impl_Trie2_Trie2Iterator$remove() {
            throw new UnsupportedOperationException();
        }

        private final int $$robo$$android_icu_impl_Trie2_Trie2Iterator$rangeEndLS(char startingLS) {
            int c;
            if (startingLS >= '\udbff') {
                return 56319;
            }
            int val = this.this$0.getFromU16SingleLead(startingLS);
            for (c = startingLS + '\u0001'; c <= 56319 && this.this$0.getFromU16SingleLead((char)c) == val; ++c) {
            }
            return c - 1;
        }

        private void __constructor__(Trie2 trie2, ValueMapper valueMapper) {
            this.$$robo$$android_icu_impl_Trie2_Trie2Iterator$__constructor__(trie2, valueMapper);
        }

        public Trie2Iterator(Trie2 trie2, ValueMapper valueMapper) {
            this.this$0 = trie2;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2_Trie2Iterator$__constructor__(android.icu.impl.Trie2 android.icu.impl.Trie2$ValueMapper ), this, trie2, valueMapper);
        }

        private void __constructor__(Trie2 trie2, char c, ValueMapper valueMapper) {
            this.$$robo$$android_icu_impl_Trie2_Trie2Iterator$__constructor__(trie2, c, valueMapper);
        }

        public Trie2Iterator(Trie2 trie2, char c, ValueMapper valueMapper) {
            this.this$0 = trie2;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2_Trie2Iterator$__constructor__(android.icu.impl.Trie2 char android.icu.impl.Trie2$ValueMapper ), this, trie2, c, valueMapper);
        }

        @Override
        public Range next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_Trie2_Trie2Iterator$next(), this);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_impl_Trie2_Trie2Iterator$hasNext(), this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_impl_Trie2_Trie2Iterator$remove(), this);
        }

        private int rangeEndLS(char c) {
            return (int)InvokeDynamicSupport.bootstrap("rangeEndLS", $$robo$$android_icu_impl_Trie2_Trie2Iterator$rangeEndLS(char ), this, c);
        }

        public /* synthetic */ Trie2Iterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Trie2Iterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class UTrie2Header
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int signature;
        int options;
        int indexLength;
        int shiftedDataLength;
        int index2NullOffset;
        int dataNullOffset;
        int shiftedHighStart;

        private void $$robo$$android_icu_impl_Trie2_UTrie2Header$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_Trie2_UTrie2Header$__constructor__();
        }

        public UTrie2Header() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2_UTrie2Header$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UTrie2Header)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ValueWidth
    extends Enum<ValueWidth> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ ValueWidth BITS_16;
        public static /* enum */ ValueWidth BITS_32;
        private static /* synthetic */ ValueWidth[] $VALUES;

        private static final ValueWidth[] $$robo$$android_icu_impl_Trie2_ValueWidth$values() {
            return (ValueWidth[])$VALUES.clone();
        }

        private static final ValueWidth $$robo$$android_icu_impl_Trie2_ValueWidth$valueOf(String name) {
            return Enum.valueOf(ValueWidth.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_Trie2_ValueWidth$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            BITS_16 = new ValueWidth();
            BITS_32 = new ValueWidth();
            $VALUES = new ValueWidth[]{BITS_16, BITS_32};
        }

        public static ValueWidth[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_Trie2_ValueWidth$values());
        }

        public static ValueWidth valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_Trie2_ValueWidth$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_Trie2_ValueWidth$__constructor__(string2, n);
        }

        public ValueWidth() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2_ValueWidth$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ValueWidth.class);
        }

        public /* synthetic */ ValueWidth() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ValueWidth)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class CharSequenceIterator
    implements Iterator<CharSequenceValues> {
        public /* synthetic */ Object __robo_data__;
        private CharSequence text;
        private int textLength;
        private int index;
        private CharSequenceValues fResults;
        /* synthetic */ Trie2 this$0;

        private void $$robo$$android_icu_impl_Trie2_CharSequenceIterator$__constructor__(Trie2 this$0, CharSequence t, int index) {
            this.fResults = new CharSequenceValues();
            this.text = t;
            this.textLength = this.text.length();
            this.set(index);
        }

        private final void $$robo$$android_icu_impl_Trie2_CharSequenceIterator$set(int i) {
            if (i < 0 || i > this.textLength) {
                throw new IndexOutOfBoundsException();
            }
            this.index = i;
        }

        private final boolean $$robo$$android_icu_impl_Trie2_CharSequenceIterator$hasNext() {
            return this.index < this.textLength;
        }

        private final boolean $$robo$$android_icu_impl_Trie2_CharSequenceIterator$hasPrevious() {
            return this.index > 0;
        }

        private final CharSequenceValues $$robo$$android_icu_impl_Trie2_CharSequenceIterator$next() {
            int c = Character.codePointAt(this.text, this.index);
            int val = this.this$0.get(c);
            this.fResults.index = this.index++;
            this.fResults.codePoint = c;
            this.fResults.value = val;
            if (c >= 65536) {
                ++this.index;
            }
            return this.fResults;
        }

        private final CharSequenceValues $$robo$$android_icu_impl_Trie2_CharSequenceIterator$previous() {
            int c = Character.codePointBefore(this.text, this.index);
            int val = this.this$0.get(c);
            --this.index;
            if (c >= 65536) {
                --this.index;
            }
            this.fResults.index = this.index;
            this.fResults.codePoint = c;
            this.fResults.value = val;
            return this.fResults;
        }

        private final void $$robo$$android_icu_impl_Trie2_CharSequenceIterator$remove() {
            throw new UnsupportedOperationException("Trie2.CharSequenceIterator does not support remove().");
        }

        private void __constructor__(Trie2 trie2, CharSequence charSequence, int n) {
            this.$$robo$$android_icu_impl_Trie2_CharSequenceIterator$__constructor__(trie2, charSequence, n);
        }

        public CharSequenceIterator(Trie2 trie2, CharSequence charSequence, int n) {
            this.this$0 = trie2;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2_CharSequenceIterator$__constructor__(android.icu.impl.Trie2 java.lang.CharSequence int ), this, trie2, charSequence, n);
        }

        public void set(int n) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_impl_Trie2_CharSequenceIterator$set(int ), this, n);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_impl_Trie2_CharSequenceIterator$hasNext(), this);
        }

        public boolean hasPrevious() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasPrevious", $$robo$$android_icu_impl_Trie2_CharSequenceIterator$hasPrevious(), this);
        }

        @Override
        public CharSequenceValues next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_Trie2_CharSequenceIterator$next(), this);
        }

        public CharSequenceValues previous() {
            return InvokeDynamicSupport.bootstrap("previous", $$robo$$android_icu_impl_Trie2_CharSequenceIterator$previous(), this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_impl_Trie2_CharSequenceIterator$remove(), this);
        }

        public /* synthetic */ CharSequenceIterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharSequenceIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CharSequenceValues
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int index;
        public int codePoint;
        public int value;

        private void $$robo$$android_icu_impl_Trie2_CharSequenceValues$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_Trie2_CharSequenceValues$__constructor__();
        }

        public CharSequenceValues() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2_CharSequenceValues$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharSequenceValues)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ValueMapper
    extends InstrumentedInterface {
        public int map(int var1);
    }

    public static class Range
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int startCodePoint;
        public int endCodePoint;
        public int value;
        public boolean leadSurrogate;

        private void $$robo$$android_icu_impl_Trie2_Range$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_Trie2_Range$equals(Object other) {
            if (other == null || !other.getClass().equals(this.getClass())) {
                return false;
            }
            Range tother = (Range)other;
            return this.startCodePoint == tother.startCodePoint && this.endCodePoint == tother.endCodePoint && this.value == tother.value && this.leadSurrogate == tother.leadSurrogate;
        }

        private final int $$robo$$android_icu_impl_Trie2_Range$hashCode() {
            int h = Trie2.initHash();
            h = Trie2.hashUChar32(h, this.startCodePoint);
            h = Trie2.hashUChar32(h, this.endCodePoint);
            h = Trie2.hashInt(h, this.value);
            h = Trie2.hashByte(h, this.leadSurrogate ? 1 : 0);
            return h;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_Trie2_Range$__constructor__();
        }

        public Range() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie2_Range$__constructor__(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_Trie2_Range$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_Trie2_Range$hashCode(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Range)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

