/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.LocaleIDs;
import android.icu.impl.locale.AsciiUtil;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LocaleIDParser
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private char[] id;
    private int index;
    private StringBuilder buffer;
    private boolean canonicalize;
    private boolean hadCountry;
    Map<String, String> keywords;
    String baseName;
    private static char KEYWORD_SEPARATOR = '@';
    private static char HYPHEN = '-';
    private static char KEYWORD_ASSIGN = '=';
    private static char COMMA = ',';
    private static char ITEM_SEPARATOR = ';';
    private static char DOT = '.';
    private static char UNDERSCORE = '_';
    private static char DONE = '\uffff';

    private void $$robo$$android_icu_impl_LocaleIDParser$__constructor__(String localeID) {
    }

    private void $$robo$$android_icu_impl_LocaleIDParser$__constructor__(String localeID, boolean canonicalize) {
        this.id = localeID.toCharArray();
        this.index = 0;
        this.buffer = new StringBuilder(this.id.length + 5);
        this.canonicalize = canonicalize;
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$reset() {
        this.index = 0;
        this.buffer = new StringBuilder(this.id.length + 5);
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$append(char c) {
        this.buffer.append(c);
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$addSeparator() {
        this.append('_');
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getString(int start) {
        return this.buffer.substring(start);
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$set(int pos, String s) {
        this.buffer.delete(pos, this.buffer.length());
        this.buffer.insert(pos, s);
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$append(String s) {
        this.buffer.append(s);
    }

    private final char $$robo$$android_icu_impl_LocaleIDParser$next() {
        if (this.index == this.id.length) {
            ++this.index;
            return '\uffff';
        }
        return this.id[this.index++];
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$skipUntilTerminatorOrIDSeparator() {
        while (!this.isTerminatorOrIDSeparator(this.next())) {
        }
        --this.index;
    }

    private final boolean $$robo$$android_icu_impl_LocaleIDParser$atTerminator() {
        return this.index >= this.id.length || this.isTerminator(this.id[this.index]);
    }

    private final boolean $$robo$$android_icu_impl_LocaleIDParser$isTerminator(char c) {
        return c == '@' || c == '\uffff' || c == '.';
    }

    private final boolean $$robo$$android_icu_impl_LocaleIDParser$isTerminatorOrIDSeparator(char c) {
        return c == '_' || c == '-' || this.isTerminator(c);
    }

    private final boolean $$robo$$android_icu_impl_LocaleIDParser$haveExperimentalLanguagePrefix() {
        char c;
        if (this.id.length > 2 && ((c = this.id[1]) == '-' || c == '_')) {
            c = this.id[0];
            return c == 'x' || c == 'X' || c == 'i' || c == 'I';
        }
        return false;
    }

    private final boolean $$robo$$android_icu_impl_LocaleIDParser$haveKeywordAssign() {
        for (int i = this.index; i < this.id.length; ++i) {
            if (this.id[i] != '=') continue;
            return true;
        }
        return false;
    }

    private final int $$robo$$android_icu_impl_LocaleIDParser$parseLanguage() {
        String lang;
        char c;
        int startLength = this.buffer.length();
        if (this.haveExperimentalLanguagePrefix()) {
            this.append(AsciiUtil.toLower(this.id[0]));
            this.append('-');
            this.index = 2;
        }
        while (!this.isTerminatorOrIDSeparator(c = this.next())) {
            this.append(AsciiUtil.toLower(c));
        }
        --this.index;
        if (this.buffer.length() - startLength == 3 && (lang = LocaleIDs.threeToTwoLetterLanguage(this.getString(0))) != null) {
            this.set(0, lang);
        }
        return 0;
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$skipLanguage() {
        if (this.haveExperimentalLanguagePrefix()) {
            this.index = 2;
        }
        this.skipUntilTerminatorOrIDSeparator();
    }

    private final int $$robo$$android_icu_impl_LocaleIDParser$parseScript() {
        if (!this.atTerminator()) {
            char c;
            int oldIndex = this.index++;
            int oldBlen = this.buffer.length();
            boolean firstPass = true;
            while (!this.isTerminatorOrIDSeparator(c = this.next()) && AsciiUtil.isAlpha(c)) {
                if (firstPass) {
                    this.addSeparator();
                    this.append(AsciiUtil.toUpper(c));
                    firstPass = false;
                    continue;
                }
                this.append(AsciiUtil.toLower(c));
            }
            --this.index;
            if (this.index - oldIndex != 5) {
                this.index = oldIndex;
                this.buffer.delete(oldBlen, this.buffer.length());
            } else {
                ++oldBlen;
            }
            return oldBlen;
        }
        return this.buffer.length();
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$skipScript() {
        if (!this.atTerminator()) {
            char c;
            int oldIndex = this.index++;
            while (!this.isTerminatorOrIDSeparator(c = this.next()) && AsciiUtil.isAlpha(c)) {
            }
            --this.index;
            if (this.index - oldIndex != 5) {
                this.index = oldIndex;
            }
        }
    }

    private final int $$robo$$android_icu_impl_LocaleIDParser$parseCountry() {
        if (!this.atTerminator()) {
            char c;
            int oldIndex = this.index++;
            int oldBlen = this.buffer.length();
            boolean firstPass = true;
            while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                if (firstPass) {
                    this.hadCountry = true;
                    this.addSeparator();
                    ++oldBlen;
                    firstPass = false;
                }
                this.append(AsciiUtil.toUpper(c));
            }
            --this.index;
            int charsAppended = this.buffer.length() - oldBlen;
            if (charsAppended != 0) {
                String region;
                if (charsAppended < 2 || charsAppended > 3) {
                    this.index = oldIndex;
                    this.buffer.delete(--oldBlen, this.buffer.length());
                    this.hadCountry = false;
                } else if (charsAppended == 3 && (region = LocaleIDs.threeToTwoLetterRegion(this.getString(oldBlen))) != null) {
                    this.set(oldBlen, region);
                }
            }
            return oldBlen;
        }
        return this.buffer.length();
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$skipCountry() {
        if (!this.atTerminator()) {
            if (this.id[this.index] == '_' || this.id[this.index] == '-') {
                ++this.index;
            }
            int oldIndex = this.index;
            this.skipUntilTerminatorOrIDSeparator();
            int charsSkipped = this.index - oldIndex;
            if (charsSkipped < 2 || charsSkipped > 3) {
                this.index = oldIndex;
            }
        }
    }

    private final int $$robo$$android_icu_impl_LocaleIDParser$parseVariant() {
        char c;
        int oldBlen = this.buffer.length();
        boolean start = true;
        boolean needSeparator = true;
        boolean skipping = false;
        boolean firstPass = true;
        while ((c = this.next()) != '\uffff') {
            if (c == '.') {
                start = false;
                skipping = true;
                continue;
            }
            if (c == '@') {
                if (this.haveKeywordAssign()) break;
                skipping = false;
                start = false;
                needSeparator = true;
                continue;
            }
            if (start) {
                start = false;
                if (c == '_' || c == '-') continue;
                --this.index;
                continue;
            }
            if (skipping) continue;
            if (needSeparator) {
                needSeparator = false;
                if (firstPass && !this.hadCountry) {
                    this.addSeparator();
                    ++oldBlen;
                }
                this.addSeparator();
                if (firstPass) {
                    ++oldBlen;
                    firstPass = false;
                }
            }
            if ((c = AsciiUtil.toUpper(c)) == '-' || c == ',') {
                c = '_';
            }
            this.append(c);
        }
        --this.index;
        return oldBlen;
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getLanguage() {
        this.reset();
        return this.getString(this.parseLanguage());
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getScript() {
        this.reset();
        this.skipLanguage();
        return this.getString(this.parseScript());
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getCountry() {
        this.reset();
        this.skipLanguage();
        this.skipScript();
        return this.getString(this.parseCountry());
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getVariant() {
        this.reset();
        this.skipLanguage();
        this.skipScript();
        this.skipCountry();
        return this.getString(this.parseVariant());
    }

    private final String[] $$robo$$android_icu_impl_LocaleIDParser$getLanguageScriptCountryVariant() {
        this.reset();
        return new String[]{this.getString(this.parseLanguage()), this.getString(this.parseScript()), this.getString(this.parseCountry()), this.getString(this.parseVariant())};
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$setBaseName(String baseName) {
        this.baseName = baseName;
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$parseBaseName() {
        if (this.baseName != null) {
            this.set(0, this.baseName);
        } else {
            this.reset();
            this.parseLanguage();
            this.parseScript();
            this.parseCountry();
            this.parseVariant();
            int len = this.buffer.length();
            if (len > 0 && this.buffer.charAt(len - 1) == '_') {
                this.buffer.deleteCharAt(len - 1);
            }
        }
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getBaseName() {
        if (this.baseName != null) {
            return this.baseName;
        }
        this.parseBaseName();
        return this.getString(0);
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getName() {
        this.parseBaseName();
        this.parseKeywords();
        return this.getString(0);
    }

    private final boolean $$robo$$android_icu_impl_LocaleIDParser$setToKeywordStart() {
        for (int i = this.index; i < this.id.length; ++i) {
            if (this.id[i] != '@') continue;
            if (this.canonicalize) {
                for (int j = ++i; j < this.id.length; ++j) {
                    if (this.id[j] != '=') continue;
                    this.index = i;
                    return true;
                }
                break;
            }
            if (++i >= this.id.length) break;
            this.index = i;
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_icu_impl_LocaleIDParser$isDoneOrKeywordAssign(char c) {
        return c == '\uffff' || c == '=';
    }

    private static final boolean $$robo$$android_icu_impl_LocaleIDParser$isDoneOrItemSeparator(char c) {
        return c == '\uffff' || c == ';';
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getKeyword() {
        int start = this.index;
        while (!LocaleIDParser.isDoneOrKeywordAssign(this.next())) {
        }
        --this.index;
        return AsciiUtil.toLowerString(new String(this.id, start, this.index - start).trim());
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getValue() {
        int start = this.index;
        while (!LocaleIDParser.isDoneOrItemSeparator(this.next())) {
        }
        --this.index;
        return new String(this.id, start, this.index - start).trim();
    }

    private final Comparator<String> $$robo$$android_icu_impl_LocaleIDParser$getKeyComparator() {
        Comparator<String> comp = new Comparator<String>(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ LocaleIDParser this$0;

            private void $$robo$$android_icu_impl_LocaleIDParser_1$__constructor__(LocaleIDParser this$0) {
            }

            private final int $$robo$$android_icu_impl_LocaleIDParser_1$compare(String lhs, String rhs) {
                return lhs.compareTo(rhs);
            }

            private void __constructor__(LocaleIDParser localeIDParser) {
                this.$$robo$$android_icu_impl_LocaleIDParser_1$__constructor__(localeIDParser);
            }
            {
                this.this$0 = localeIDParser;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleIDParser_1$__constructor__(android.icu.impl.LocaleIDParser ), this, localeIDParser);
            }

            @Override
            public int compare(String string2, String string3) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_impl_LocaleIDParser_1$compare(java.lang.String java.lang.String ), this, string2, string3);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        return comp;
    }

    private final Map<String, String> $$robo$$android_icu_impl_LocaleIDParser$getKeywordMap() {
        block6: {
            Map<String, String> m;
            block7: {
                String key;
                if (this.keywords != null) break block6;
                m = null;
                if (!this.setToKeywordStart()) break block7;
                while ((key = this.getKeyword()).length() != 0) {
                    block9: {
                        String value;
                        block11: {
                            block10: {
                                block8: {
                                    char c = this.next();
                                    if (c == '=') break block8;
                                    if (c == '\uffff') {
                                        break;
                                    }
                                    break block9;
                                }
                                value = this.getValue();
                                if (value.length() == 0) break block9;
                                if (m != null) break block10;
                                m = new TreeMap(this.getKeyComparator());
                                break block11;
                            }
                            if (((TreeMap)m).containsKey(key)) break block9;
                        }
                        ((TreeMap)m).put(key, value);
                    }
                    if (this.next() == ';') continue;
                }
            }
            this.keywords = m != null ? m : Collections.emptyMap();
        }
        return this.keywords;
    }

    private final int $$robo$$android_icu_impl_LocaleIDParser$parseKeywords() {
        int oldBlen = this.buffer.length();
        Map<String, String> m = this.getKeywordMap();
        if (!m.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, String> e : m.entrySet()) {
                this.append(first ? (char)'@' : ';');
                first = false;
                this.append(e.getKey());
                this.append('=');
                this.append(e.getValue());
            }
            if (!first) {
                ++oldBlen;
            }
        }
        return oldBlen;
    }

    private final Iterator<String> $$robo$$android_icu_impl_LocaleIDParser$getKeywords() {
        Map<String, String> m = this.getKeywordMap();
        return m.isEmpty() ? null : m.keySet().iterator();
    }

    private final String $$robo$$android_icu_impl_LocaleIDParser$getKeywordValue(String keywordName) {
        Map<String, String> m = this.getKeywordMap();
        return m.isEmpty() ? null : m.get(AsciiUtil.toLowerString(keywordName.trim()));
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$defaultKeywordValue(String keywordName, String value) {
        this.setKeywordValue(keywordName, value, false);
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$setKeywordValue(String keywordName, String value) {
        this.setKeywordValue(keywordName, value, true);
    }

    private final void $$robo$$android_icu_impl_LocaleIDParser$setKeywordValue(String keywordName, String value, boolean reset) {
        if (keywordName == null) {
            if (reset) {
                this.keywords = Collections.emptyMap();
            }
        } else {
            if ((keywordName = AsciiUtil.toLowerString(keywordName.trim())).length() == 0) {
                throw new IllegalArgumentException("keyword must not be empty");
            }
            if (value != null && (value = value.trim()).length() == 0) {
                throw new IllegalArgumentException("value must not be empty");
            }
            Map<String, String> m = this.getKeywordMap();
            if (m.isEmpty()) {
                if (value != null) {
                    this.keywords = new TreeMap<String, String>(this.getKeyComparator());
                    this.keywords.put(keywordName, value.trim());
                }
            } else if (reset || !m.containsKey(keywordName)) {
                if (value != null) {
                    m.put(keywordName, value);
                } else {
                    m.remove(keywordName);
                    if (m.isEmpty()) {
                        this.keywords = Collections.emptyMap();
                    }
                }
            }
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_impl_LocaleIDParser$__constructor__(string2);
    }

    public LocaleIDParser(String string2) {
        this(string2, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleIDParser$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__(String string2, boolean bl) {
        this.$$robo$$android_icu_impl_LocaleIDParser$__constructor__(string2, bl);
    }

    public LocaleIDParser(String string2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_LocaleIDParser$__constructor__(java.lang.String boolean ), this, string2, bl);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_impl_LocaleIDParser$reset(), this);
    }

    private void append(char c) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_LocaleIDParser$append(char ), this, c);
    }

    private void addSeparator() {
        InvokeDynamicSupport.bootstrap("addSeparator", $$robo$$android_icu_impl_LocaleIDParser$addSeparator(), this);
    }

    private String getString(int n) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_icu_impl_LocaleIDParser$getString(int ), this, n);
    }

    private void set(int n, String string2) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_impl_LocaleIDParser$set(int java.lang.String ), this, n, string2);
    }

    private void append(String string2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_LocaleIDParser$append(java.lang.String ), this, string2);
    }

    private char next() {
        return (char)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_LocaleIDParser$next(), this);
    }

    private void skipUntilTerminatorOrIDSeparator() {
        InvokeDynamicSupport.bootstrap("skipUntilTerminatorOrIDSeparator", $$robo$$android_icu_impl_LocaleIDParser$skipUntilTerminatorOrIDSeparator(), this);
    }

    private boolean atTerminator() {
        return (boolean)InvokeDynamicSupport.bootstrap("atTerminator", $$robo$$android_icu_impl_LocaleIDParser$atTerminator(), this);
    }

    private boolean isTerminator(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTerminator", $$robo$$android_icu_impl_LocaleIDParser$isTerminator(char ), this, c);
    }

    private boolean isTerminatorOrIDSeparator(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTerminatorOrIDSeparator", $$robo$$android_icu_impl_LocaleIDParser$isTerminatorOrIDSeparator(char ), this, c);
    }

    private boolean haveExperimentalLanguagePrefix() {
        return (boolean)InvokeDynamicSupport.bootstrap("haveExperimentalLanguagePrefix", $$robo$$android_icu_impl_LocaleIDParser$haveExperimentalLanguagePrefix(), this);
    }

    private boolean haveKeywordAssign() {
        return (boolean)InvokeDynamicSupport.bootstrap("haveKeywordAssign", $$robo$$android_icu_impl_LocaleIDParser$haveKeywordAssign(), this);
    }

    private int parseLanguage() {
        return (int)InvokeDynamicSupport.bootstrap("parseLanguage", $$robo$$android_icu_impl_LocaleIDParser$parseLanguage(), this);
    }

    private void skipLanguage() {
        InvokeDynamicSupport.bootstrap("skipLanguage", $$robo$$android_icu_impl_LocaleIDParser$skipLanguage(), this);
    }

    private int parseScript() {
        return (int)InvokeDynamicSupport.bootstrap("parseScript", $$robo$$android_icu_impl_LocaleIDParser$parseScript(), this);
    }

    private void skipScript() {
        InvokeDynamicSupport.bootstrap("skipScript", $$robo$$android_icu_impl_LocaleIDParser$skipScript(), this);
    }

    private int parseCountry() {
        return (int)InvokeDynamicSupport.bootstrap("parseCountry", $$robo$$android_icu_impl_LocaleIDParser$parseCountry(), this);
    }

    private void skipCountry() {
        InvokeDynamicSupport.bootstrap("skipCountry", $$robo$$android_icu_impl_LocaleIDParser$skipCountry(), this);
    }

    private int parseVariant() {
        return (int)InvokeDynamicSupport.bootstrap("parseVariant", $$robo$$android_icu_impl_LocaleIDParser$parseVariant(), this);
    }

    public String getLanguage() {
        return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_icu_impl_LocaleIDParser$getLanguage(), this);
    }

    public String getScript() {
        return InvokeDynamicSupport.bootstrap("getScript", $$robo$$android_icu_impl_LocaleIDParser$getScript(), this);
    }

    public String getCountry() {
        return InvokeDynamicSupport.bootstrap("getCountry", $$robo$$android_icu_impl_LocaleIDParser$getCountry(), this);
    }

    public String getVariant() {
        return InvokeDynamicSupport.bootstrap("getVariant", $$robo$$android_icu_impl_LocaleIDParser$getVariant(), this);
    }

    public String[] getLanguageScriptCountryVariant() {
        return InvokeDynamicSupport.bootstrap("getLanguageScriptCountryVariant", $$robo$$android_icu_impl_LocaleIDParser$getLanguageScriptCountryVariant(), this);
    }

    public void setBaseName(String string2) {
        InvokeDynamicSupport.bootstrap("setBaseName", $$robo$$android_icu_impl_LocaleIDParser$setBaseName(java.lang.String ), this, string2);
    }

    public void parseBaseName() {
        InvokeDynamicSupport.bootstrap("parseBaseName", $$robo$$android_icu_impl_LocaleIDParser$parseBaseName(), this);
    }

    public String getBaseName() {
        return InvokeDynamicSupport.bootstrap("getBaseName", $$robo$$android_icu_impl_LocaleIDParser$getBaseName(), this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_impl_LocaleIDParser$getName(), this);
    }

    private boolean setToKeywordStart() {
        return (boolean)InvokeDynamicSupport.bootstrap("setToKeywordStart", $$robo$$android_icu_impl_LocaleIDParser$setToKeywordStart(), this);
    }

    private static boolean isDoneOrKeywordAssign(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDoneOrKeywordAssign", $$robo$$android_icu_impl_LocaleIDParser$isDoneOrKeywordAssign(char ), (char)c);
    }

    private static boolean isDoneOrItemSeparator(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDoneOrItemSeparator", $$robo$$android_icu_impl_LocaleIDParser$isDoneOrItemSeparator(char ), (char)c);
    }

    private String getKeyword() {
        return InvokeDynamicSupport.bootstrap("getKeyword", $$robo$$android_icu_impl_LocaleIDParser$getKeyword(), this);
    }

    private String getValue() {
        return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_icu_impl_LocaleIDParser$getValue(), this);
    }

    private Comparator<String> getKeyComparator() {
        return InvokeDynamicSupport.bootstrap("getKeyComparator", $$robo$$android_icu_impl_LocaleIDParser$getKeyComparator(), this);
    }

    public Map<String, String> getKeywordMap() {
        return InvokeDynamicSupport.bootstrap("getKeywordMap", $$robo$$android_icu_impl_LocaleIDParser$getKeywordMap(), this);
    }

    private int parseKeywords() {
        return (int)InvokeDynamicSupport.bootstrap("parseKeywords", $$robo$$android_icu_impl_LocaleIDParser$parseKeywords(), this);
    }

    public Iterator<String> getKeywords() {
        return InvokeDynamicSupport.bootstrap("getKeywords", $$robo$$android_icu_impl_LocaleIDParser$getKeywords(), this);
    }

    public String getKeywordValue(String string2) {
        return InvokeDynamicSupport.bootstrap("getKeywordValue", $$robo$$android_icu_impl_LocaleIDParser$getKeywordValue(java.lang.String ), this, string2);
    }

    public void defaultKeywordValue(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("defaultKeywordValue", $$robo$$android_icu_impl_LocaleIDParser$defaultKeywordValue(java.lang.String java.lang.String ), this, string2, string3);
    }

    public void setKeywordValue(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setKeywordValue", $$robo$$android_icu_impl_LocaleIDParser$setKeywordValue(java.lang.String java.lang.String ), this, string2, string3);
    }

    private void setKeywordValue(String string2, String string3, boolean bl) {
        InvokeDynamicSupport.bootstrap("setKeywordValue", $$robo$$android_icu_impl_LocaleIDParser$setKeywordValue(java.lang.String java.lang.String boolean ), this, string2, string3, bl);
    }

    public /* synthetic */ LocaleIDParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleIDParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

