/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.content.Context;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.os.ParcelFileDescriptor;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.util.concurrent.TimeoutException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsbDeviceConnection
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "UsbDeviceConnection";
    private UsbDevice mDevice;
    private Context mContext;
    private long mNativeContext;
    private CloseGuard mCloseGuard;

    private void $$robo$$android_hardware_usb_UsbDeviceConnection$__constructor__(UsbDevice device) {
        this.mCloseGuard = CloseGuard.get();
        this.mDevice = device;
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$open(String name, ParcelFileDescriptor pfd, Context context) {
        this.mContext = context.getApplicationContext();
        boolean wasOpened = this.native_open(name, pfd.getFileDescriptor());
        if (wasOpened) {
            this.mCloseGuard.open("close");
        }
        return wasOpened;
    }

    private final Context $$robo$$android_hardware_usb_UsbDeviceConnection$getContext() {
        return this.mContext;
    }

    private final void $$robo$$android_hardware_usb_UsbDeviceConnection$close() {
        if (this.mNativeContext != 0L) {
            this.native_close();
            this.mCloseGuard.close();
        }
    }

    private final int $$robo$$android_hardware_usb_UsbDeviceConnection$getFileDescriptor() {
        return this.native_get_fd();
    }

    private final byte[] $$robo$$android_hardware_usb_UsbDeviceConnection$getRawDescriptors() {
        return this.native_get_desc();
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$claimInterface(UsbInterface intf, boolean force) {
        return this.native_claim_interface(intf.getId(), force);
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$releaseInterface(UsbInterface intf) {
        return this.native_release_interface(intf.getId());
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$setInterface(UsbInterface intf) {
        return this.native_set_interface(intf.getId(), intf.getAlternateSetting());
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$setConfiguration(UsbConfiguration configuration) {
        return this.native_set_configuration(configuration.getId());
    }

    private final int $$robo$$android_hardware_usb_UsbDeviceConnection$controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        return this.controlTransfer(requestType, request, value, index, buffer, 0, length, timeout);
    }

    private final int $$robo$$android_hardware_usb_UsbDeviceConnection$controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int offset, int length, int timeout) {
        UsbDeviceConnection.checkBounds(buffer, offset, length);
        return this.native_control_request(requestType, request, value, index, buffer, offset, length, timeout);
    }

    private final int $$robo$$android_hardware_usb_UsbDeviceConnection$bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int length, int timeout) {
        return this.bulkTransfer(endpoint, buffer, 0, length, timeout);
    }

    private final int $$robo$$android_hardware_usb_UsbDeviceConnection$bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int offset, int length, int timeout) {
        UsbDeviceConnection.checkBounds(buffer, offset, length);
        return this.native_bulk_request(endpoint.getAddress(), buffer, offset, length, timeout);
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$resetDevice() {
        return this.native_reset_device();
    }

    private final UsbRequest $$robo$$android_hardware_usb_UsbDeviceConnection$requestWait() {
        UsbRequest request = null;
        try {
            request = this.native_request_wait(-1L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (request != null) {
            request.dequeue(this.mContext.getApplicationInfo().targetSdkVersion >= 26);
        }
        return request;
    }

    private final UsbRequest $$robo$$android_hardware_usb_UsbDeviceConnection$requestWait(long timeout) throws TimeoutException {
        UsbRequest request = this.native_request_wait(timeout = Preconditions.checkArgumentNonnegative(timeout, "timeout"));
        if (request != null) {
            request.dequeue(true);
        }
        return request;
    }

    private final String $$robo$$android_hardware_usb_UsbDeviceConnection$getSerial() {
        return this.native_get_serial();
    }

    private static final void $$robo$$android_hardware_usb_UsbDeviceConnection$checkBounds(byte[] buffer, int start, int length) {
        int bufferLength;
        int n = bufferLength = buffer != null ? buffer.length : 0;
        if (length < 0 || start < 0 || start + length > bufferLength) {
            throw new IllegalArgumentException("Buffer start or length out of bounds.");
        }
    }

    private final void $$robo$$android_hardware_usb_UsbDeviceConnection$finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
        }
        finally {
            super.finalize();
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$native_open(String string2, FileDescriptor fileDescriptor) {
        return false;
    }

    private final void $$robo$$android_hardware_usb_UsbDeviceConnection$native_close() {
    }

    private final int $$robo$$android_hardware_usb_UsbDeviceConnection$native_get_fd() {
        return 0;
    }

    private final byte[] $$robo$$android_hardware_usb_UsbDeviceConnection$native_get_desc() {
        return null;
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$native_claim_interface(int n, boolean bl) {
        return false;
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$native_release_interface(int n) {
        return false;
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$native_set_interface(int n, int n2) {
        return false;
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$native_set_configuration(int n) {
        return false;
    }

    private final int $$robo$$android_hardware_usb_UsbDeviceConnection$native_control_request(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7) {
        return 0;
    }

    private final int $$robo$$android_hardware_usb_UsbDeviceConnection$native_bulk_request(int n, byte[] byArray, int n2, int n3, int n4) {
        return 0;
    }

    private final UsbRequest $$robo$$android_hardware_usb_UsbDeviceConnection$native_request_wait(long l) throws TimeoutException {
        return null;
    }

    private final String $$robo$$android_hardware_usb_UsbDeviceConnection$native_get_serial() {
        return null;
    }

    private final boolean $$robo$$android_hardware_usb_UsbDeviceConnection$native_reset_device() {
        return false;
    }

    private void __constructor__(UsbDevice usbDevice) {
        this.$$robo$$android_hardware_usb_UsbDeviceConnection$__constructor__(usbDevice);
    }

    public UsbDeviceConnection(UsbDevice usbDevice) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_UsbDeviceConnection$__constructor__(android.hardware.usb.UsbDevice ), this, usbDevice);
    }

    boolean open(String string2, ParcelFileDescriptor parcelFileDescriptor, Context context) {
        return (boolean)InvokeDynamicSupport.bootstrap("open", $$robo$$android_hardware_usb_UsbDeviceConnection$open(java.lang.String android.os.ParcelFileDescriptor android.content.Context ), this, string2, parcelFileDescriptor, context);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_hardware_usb_UsbDeviceConnection$getContext(), this);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_usb_UsbDeviceConnection$close(), this);
    }

    public int getFileDescriptor() {
        return (int)InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$android_hardware_usb_UsbDeviceConnection$getFileDescriptor(), this);
    }

    public byte[] getRawDescriptors() {
        return InvokeDynamicSupport.bootstrap("getRawDescriptors", $$robo$$android_hardware_usb_UsbDeviceConnection$getRawDescriptors(), this);
    }

    public boolean claimInterface(UsbInterface usbInterface, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("claimInterface", $$robo$$android_hardware_usb_UsbDeviceConnection$claimInterface(android.hardware.usb.UsbInterface boolean ), this, usbInterface, bl);
    }

    public boolean releaseInterface(UsbInterface usbInterface) {
        return (boolean)InvokeDynamicSupport.bootstrap("releaseInterface", $$robo$$android_hardware_usb_UsbDeviceConnection$releaseInterface(android.hardware.usb.UsbInterface ), this, usbInterface);
    }

    public boolean setInterface(UsbInterface usbInterface) {
        return (boolean)InvokeDynamicSupport.bootstrap("setInterface", $$robo$$android_hardware_usb_UsbDeviceConnection$setInterface(android.hardware.usb.UsbInterface ), this, usbInterface);
    }

    public boolean setConfiguration(UsbConfiguration usbConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("setConfiguration", $$robo$$android_hardware_usb_UsbDeviceConnection$setConfiguration(android.hardware.usb.UsbConfiguration ), this, usbConfiguration);
    }

    public int controlTransfer(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        return (int)InvokeDynamicSupport.bootstrap("controlTransfer", $$robo$$android_hardware_usb_UsbDeviceConnection$controlTransfer(int int int int byte[] int int ), this, n, n2, n3, n4, byArray, n5, n6);
    }

    public int controlTransfer(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7) {
        return (int)InvokeDynamicSupport.bootstrap("controlTransfer", $$robo$$android_hardware_usb_UsbDeviceConnection$controlTransfer(int int int int byte[] int int int ), this, n, n2, n3, n4, byArray, n5, n6, n7);
    }

    public int bulkTransfer(UsbEndpoint usbEndpoint, byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("bulkTransfer", $$robo$$android_hardware_usb_UsbDeviceConnection$bulkTransfer(android.hardware.usb.UsbEndpoint byte[] int int ), this, usbEndpoint, byArray, n, n2);
    }

    public int bulkTransfer(UsbEndpoint usbEndpoint, byte[] byArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("bulkTransfer", $$robo$$android_hardware_usb_UsbDeviceConnection$bulkTransfer(android.hardware.usb.UsbEndpoint byte[] int int int ), this, usbEndpoint, byArray, n, n2, n3);
    }

    public boolean resetDevice() {
        return (boolean)InvokeDynamicSupport.bootstrap("resetDevice", $$robo$$android_hardware_usb_UsbDeviceConnection$resetDevice(), this);
    }

    public UsbRequest requestWait() {
        return InvokeDynamicSupport.bootstrap("requestWait", $$robo$$android_hardware_usb_UsbDeviceConnection$requestWait(), this);
    }

    public UsbRequest requestWait(long l) throws TimeoutException {
        return InvokeDynamicSupport.bootstrap("requestWait", $$robo$$android_hardware_usb_UsbDeviceConnection$requestWait(long ), this, l);
    }

    public String getSerial() {
        return InvokeDynamicSupport.bootstrap("getSerial", $$robo$$android_hardware_usb_UsbDeviceConnection$getSerial(), this);
    }

    private static void checkBounds(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkBounds", $$robo$$android_hardware_usb_UsbDeviceConnection$checkBounds(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_usb_UsbDeviceConnection$finalize(), this);
    }

    private boolean native_open(String string2, FileDescriptor fileDescriptor) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_open", $$robo$$android_hardware_usb_UsbDeviceConnection$native_open(java.lang.String java.io.FileDescriptor ), this, string2, fileDescriptor);
    }

    private void native_close() {
        InvokeDynamicSupport.bootstrap("native_close", $$robo$$android_hardware_usb_UsbDeviceConnection$native_close(), this);
    }

    private int native_get_fd() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_fd", $$robo$$android_hardware_usb_UsbDeviceConnection$native_get_fd(), this);
    }

    private byte[] native_get_desc() {
        return InvokeDynamicSupport.bootstrap("native_get_desc", $$robo$$android_hardware_usb_UsbDeviceConnection$native_get_desc(), this);
    }

    private boolean native_claim_interface(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_claim_interface", $$robo$$android_hardware_usb_UsbDeviceConnection$native_claim_interface(int boolean ), this, n, bl);
    }

    private boolean native_release_interface(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_release_interface", $$robo$$android_hardware_usb_UsbDeviceConnection$native_release_interface(int ), this, n);
    }

    private boolean native_set_interface(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_set_interface", $$robo$$android_hardware_usb_UsbDeviceConnection$native_set_interface(int int ), this, n, n2);
    }

    private boolean native_set_configuration(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_set_configuration", $$robo$$android_hardware_usb_UsbDeviceConnection$native_set_configuration(int ), this, n);
    }

    private int native_control_request(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7) {
        return (int)InvokeDynamicSupport.bootstrap("native_control_request", $$robo$$android_hardware_usb_UsbDeviceConnection$native_control_request(int int int int byte[] int int int ), this, n, n2, n3, n4, byArray, n5, n6, n7);
    }

    private int native_bulk_request(int n, byte[] byArray, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrap("native_bulk_request", $$robo$$android_hardware_usb_UsbDeviceConnection$native_bulk_request(int byte[] int int int ), this, n, byArray, n2, n3, n4);
    }

    private UsbRequest native_request_wait(long l) throws TimeoutException {
        return InvokeDynamicSupport.bootstrap("native_request_wait", $$robo$$android_hardware_usb_UsbDeviceConnection$native_request_wait(long ), this, l);
    }

    private String native_get_serial() {
        return InvokeDynamicSupport.bootstrap("native_get_serial", $$robo$$android_hardware_usb_UsbDeviceConnection$native_get_serial(), this);
    }

    private boolean native_reset_device() {
        return (boolean)InvokeDynamicSupport.bootstrap("native_reset_device", $$robo$$android_hardware_usb_UsbDeviceConnection$native_reset_device(), this);
    }

    public /* synthetic */ UsbDeviceConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsbDeviceConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

