/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SurfaceUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;

    private void $$robo$$android_hardware_camera2_utils_SurfaceUtils$__constructor__() {
    }

    private static final boolean $$robo$$android_hardware_camera2_utils_SurfaceUtils$isSurfaceForPreview(Surface surface) {
        return LegacyCameraDevice.isPreviewConsumer(surface);
    }

    private static final boolean $$robo$$android_hardware_camera2_utils_SurfaceUtils$isSurfaceForHwVideoEncoder(Surface surface) {
        return LegacyCameraDevice.isVideoEncoderConsumer(surface);
    }

    private static final Size $$robo$$android_hardware_camera2_utils_SurfaceUtils$getSurfaceSize(Surface surface) {
        try {
            return LegacyCameraDevice.getSurfaceSize(surface);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new IllegalArgumentException("Surface was abandoned", e);
        }
    }

    private static final int $$robo$$android_hardware_camera2_utils_SurfaceUtils$getSurfaceFormat(Surface surface) {
        try {
            return LegacyCameraDevice.detectSurfaceType(surface);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new IllegalArgumentException("Surface was abandoned", e);
        }
    }

    private static final int $$robo$$android_hardware_camera2_utils_SurfaceUtils$getSurfaceDataspace(Surface surface) {
        try {
            return LegacyCameraDevice.detectSurfaceDataspace(surface);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new IllegalArgumentException("Surface was abandoned", e);
        }
    }

    private static final boolean $$robo$$android_hardware_camera2_utils_SurfaceUtils$isFlexibleConsumer(Surface output) {
        return LegacyCameraDevice.isFlexibleConsumer(output);
    }

    private static final void $$robo$$android_hardware_camera2_utils_SurfaceUtils$checkHighSpeedSurfaceFormat(Surface surface) {
        int surfaceFormat = SurfaceUtils.getSurfaceFormat(surface);
        if (surfaceFormat != 34) {
            throw new IllegalArgumentException("Surface format(" + surfaceFormat + ") is not for preview or hardware video encoding!");
        }
    }

    private static final void $$robo$$android_hardware_camera2_utils_SurfaceUtils$checkConstrainedHighSpeedSurfaces(Collection<Surface> surfaces, Range<Integer> fpsRange, StreamConfigurationMap config) {
        boolean isSecondSurfacePreview;
        Iterator<Surface> iterator;
        boolean isFirstSurfacePreview;
        if (surfaces == null || surfaces.size() == 0 || surfaces.size() > 2) {
            throw new IllegalArgumentException("Output target surface list must not be null and the size must be 1 or 2");
        }
        List<Size> highSpeedSizes = null;
        if (fpsRange == null) {
            highSpeedSizes = Arrays.asList(config.getHighSpeedVideoSizes());
        } else {
            Range<Integer>[] highSpeedFpsRanges = config.getHighSpeedVideoFpsRanges();
            if (!Arrays.asList(highSpeedFpsRanges).contains(fpsRange)) {
                throw new IllegalArgumentException("Fps range " + fpsRange.toString() + " in the request is not a supported high speed fps range " + Arrays.toString(highSpeedFpsRanges));
            }
            highSpeedSizes = Arrays.asList(config.getHighSpeedVideoSizesFor(fpsRange));
        }
        for (Surface surface : surfaces) {
            SurfaceUtils.checkHighSpeedSurfaceFormat(surface);
            Size surfaceSize = SurfaceUtils.getSurfaceSize(surface);
            if (!highSpeedSizes.contains(surfaceSize)) {
                throw new IllegalArgumentException("Surface size " + surfaceSize.toString() + " is not part of the high speed supported size list " + Arrays.toString(highSpeedSizes.toArray()));
            }
            if (!SurfaceUtils.isSurfaceForPreview(surface) && !SurfaceUtils.isSurfaceForHwVideoEncoder(surface)) {
                throw new IllegalArgumentException("This output surface is neither preview nor hardware video encoding surface");
            }
            if (!SurfaceUtils.isSurfaceForPreview(surface) || !SurfaceUtils.isSurfaceForHwVideoEncoder(surface)) continue;
            throw new IllegalArgumentException("This output surface can not be both preview and hardware video encoding surface");
        }
        if (surfaces.size() == 2 && (isFirstSurfacePreview = SurfaceUtils.isSurfaceForPreview((iterator = surfaces.iterator()).next())) == (isSecondSurfacePreview = SurfaceUtils.isSurfaceForPreview(iterator.next()))) {
            throw new IllegalArgumentException("The 2 output surfaces must have different type");
        }
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_utils_SurfaceUtils$__constructor__();
    }

    public SurfaceUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_SurfaceUtils$__constructor__(), this);
    }

    public static boolean isSurfaceForPreview(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSurfaceForPreview", $$robo$$android_hardware_camera2_utils_SurfaceUtils$isSurfaceForPreview(android.view.Surface ), (Surface)surface);
    }

    public static boolean isSurfaceForHwVideoEncoder(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSurfaceForHwVideoEncoder", $$robo$$android_hardware_camera2_utils_SurfaceUtils$isSurfaceForHwVideoEncoder(android.view.Surface ), (Surface)surface);
    }

    public static Size getSurfaceSize(Surface surface) {
        return InvokeDynamicSupport.bootstrapStatic("getSurfaceSize", $$robo$$android_hardware_camera2_utils_SurfaceUtils$getSurfaceSize(android.view.Surface ), (Surface)surface);
    }

    public static int getSurfaceFormat(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSurfaceFormat", $$robo$$android_hardware_camera2_utils_SurfaceUtils$getSurfaceFormat(android.view.Surface ), (Surface)surface);
    }

    public static int getSurfaceDataspace(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSurfaceDataspace", $$robo$$android_hardware_camera2_utils_SurfaceUtils$getSurfaceDataspace(android.view.Surface ), (Surface)surface);
    }

    public static boolean isFlexibleConsumer(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFlexibleConsumer", $$robo$$android_hardware_camera2_utils_SurfaceUtils$isFlexibleConsumer(android.view.Surface ), (Surface)surface);
    }

    private static void checkHighSpeedSurfaceFormat(Surface surface) {
        InvokeDynamicSupport.bootstrapStatic("checkHighSpeedSurfaceFormat", $$robo$$android_hardware_camera2_utils_SurfaceUtils$checkHighSpeedSurfaceFormat(android.view.Surface ), (Surface)surface);
    }

    public static void checkConstrainedHighSpeedSurfaces(Collection<Surface> collection, Range<Integer> range, StreamConfigurationMap streamConfigurationMap) {
        InvokeDynamicSupport.bootstrapStatic("checkConstrainedHighSpeedSurfaces", $$robo$$android_hardware_camera2_utils_SurfaceUtils$checkConstrainedHighSpeedSurfaces(java.util.Collection<android.view.Surface> android.util.Range<java.lang.Integer> android.hardware.camera2.params.StreamConfigurationMap ), collection, range, (StreamConfigurationMap)streamConfigurationMap);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

