/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Rational;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MarshalQueryablePrimitive<T>
implements MarshalQueryable<T> {
    public /* synthetic */ Object __robo_data__;

    private void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive$__constructor__() {
    }

    private final Marshaler<T> $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive$createMarshaler(TypeReference<T> managedType, int nativeType) {
        return new MarshalerPrimitive(this, managedType, nativeType);
    }

    private final boolean $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive$isTypeMappingSupported(TypeReference<T> managedType, int nativeType) {
        if (managedType.getType() instanceof Class) {
            Class klass = (Class)managedType.getType();
            if (klass == Byte.TYPE || klass == Byte.class) {
                return nativeType == 0;
            }
            if (klass == Integer.TYPE || klass == Integer.class) {
                return nativeType == 1;
            }
            if (klass == Float.TYPE || klass == Float.class) {
                return nativeType == 2;
            }
            if (klass == Long.TYPE || klass == Long.class) {
                return nativeType == 3;
            }
            if (klass == Double.TYPE || klass == Double.class) {
                return nativeType == 4;
            }
            if (klass == Rational.class) {
                return nativeType == 5;
            }
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive$__constructor__();
    }

    public MarshalQueryablePrimitive() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive$__constructor__(), this);
    }

    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> typeReference, int n) {
        return InvokeDynamicSupport.bootstrap("createMarshaler", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive$createMarshaler(android.hardware.camera2.utils.TypeReference<T> int ), this, typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> typeReference, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTypeMappingSupported", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive$isTypeMappingSupported(android.hardware.camera2.utils.TypeReference<T> int ), this, typeReference, n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MarshalQueryablePrimitive)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MarshalerPrimitive
    extends Marshaler<T> {
        public /* synthetic */ Object __robo_data__;
        private Class<T> mClass;
        /* synthetic */ MarshalQueryablePrimitive this$0;

        private void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$__constructor__(MarshalQueryablePrimitive marshalQueryablePrimitive, TypeReference<T> typeReference, int nativeType) {
            this.mClass = MarshalHelpers.wrapClassIfPrimitive(typeReference.getRawType());
        }

        private final T $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$unmarshal(ByteBuffer buffer) {
            return this.mClass.cast(this.unmarshalObject(buffer));
        }

        private final int $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$calculateMarshalSize(T value) {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }

        private final void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshal(T value, ByteBuffer buffer) {
            if (value instanceof Integer) {
                MarshalHelpers.checkNativeTypeEquals(1, this.mNativeType);
                int val = (Integer)value;
                this.marshalPrimitive(val, buffer);
            } else if (value instanceof Float) {
                MarshalHelpers.checkNativeTypeEquals(2, this.mNativeType);
                float val = ((Float)value).floatValue();
                this.marshalPrimitive(val, buffer);
            } else if (value instanceof Long) {
                MarshalHelpers.checkNativeTypeEquals(3, this.mNativeType);
                long val = (Long)value;
                this.marshalPrimitive(val, buffer);
            } else if (value instanceof Rational) {
                MarshalHelpers.checkNativeTypeEquals(5, this.mNativeType);
                this.marshalPrimitive((Rational)value, buffer);
            } else if (value instanceof Double) {
                MarshalHelpers.checkNativeTypeEquals(4, this.mNativeType);
                double val = (Double)value;
                this.marshalPrimitive(val, buffer);
            } else if (value instanceof Byte) {
                MarshalHelpers.checkNativeTypeEquals(0, this.mNativeType);
                byte val = (Byte)value;
                this.marshalPrimitive(val, buffer);
            } else {
                throw new UnsupportedOperationException("Can't marshal managed type " + this.mTypeReference);
            }
        }

        private final void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(int value, ByteBuffer buffer) {
            buffer.putInt(value);
        }

        private final void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(float value, ByteBuffer buffer) {
            buffer.putFloat(value);
        }

        private final void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(double value, ByteBuffer buffer) {
            buffer.putDouble(value);
        }

        private final void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(long value, ByteBuffer buffer) {
            buffer.putLong(value);
        }

        private final void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(Rational value, ByteBuffer buffer) {
            buffer.putInt(value.getNumerator());
            buffer.putInt(value.getDenominator());
        }

        private final void $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(byte value, ByteBuffer buffer) {
            buffer.put(value);
        }

        private final Object $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$unmarshalObject(ByteBuffer buffer) {
            switch (this.mNativeType) {
                case 1: {
                    return buffer.getInt();
                }
                case 2: {
                    return Float.valueOf(buffer.getFloat());
                }
                case 3: {
                    return buffer.getLong();
                }
                case 5: {
                    int numerator = buffer.getInt();
                    int denominator = buffer.getInt();
                    return new Rational(numerator, denominator);
                }
                case 4: {
                    return buffer.getDouble();
                }
                case 0: {
                    return buffer.get();
                }
            }
            throw new UnsupportedOperationException("Can't unmarshal native type " + this.mNativeType);
        }

        private final int $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$getNativeSize() {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }

        private void __constructor__(MarshalQueryablePrimitive marshalQueryablePrimitive, TypeReference<T> typeReference, int n) {
            this.$$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$__constructor__(marshalQueryablePrimitive, typeReference, n);
        }

        public MarshalerPrimitive(MarshalQueryablePrimitive marshalQueryablePrimitive, TypeReference<T> typeReference, int n) {
            this.this$0 = marshalQueryablePrimitive;
            super(marshalQueryablePrimitive, typeReference, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$__constructor__(android.hardware.camera2.marshal.impl.MarshalQueryablePrimitive android.hardware.camera2.utils.TypeReference<T> int ), this, marshalQueryablePrimitive, typeReference, n);
        }

        @Override
        public T unmarshal(ByteBuffer byteBuffer) {
            return InvokeDynamicSupport.bootstrap("unmarshal", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$unmarshal(java.nio.ByteBuffer ), this, byteBuffer);
        }

        @Override
        public int calculateMarshalSize(T t) {
            return (int)InvokeDynamicSupport.bootstrap("calculateMarshalSize", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$calculateMarshalSize(T ), this, t);
        }

        @Override
        public void marshal(T t, ByteBuffer byteBuffer) {
            InvokeDynamicSupport.bootstrap("marshal", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshal(T java.nio.ByteBuffer ), this, t, byteBuffer);
        }

        private void marshalPrimitive(int n, ByteBuffer byteBuffer) {
            InvokeDynamicSupport.bootstrap("marshalPrimitive", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(int java.nio.ByteBuffer ), this, n, byteBuffer);
        }

        private void marshalPrimitive(float f, ByteBuffer byteBuffer) {
            InvokeDynamicSupport.bootstrap("marshalPrimitive", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(float java.nio.ByteBuffer ), this, f, byteBuffer);
        }

        private void marshalPrimitive(double d, ByteBuffer byteBuffer) {
            InvokeDynamicSupport.bootstrap("marshalPrimitive", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(double java.nio.ByteBuffer ), this, d, byteBuffer);
        }

        private void marshalPrimitive(long l, ByteBuffer byteBuffer) {
            InvokeDynamicSupport.bootstrap("marshalPrimitive", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(long java.nio.ByteBuffer ), this, l, byteBuffer);
        }

        private void marshalPrimitive(Rational rational, ByteBuffer byteBuffer) {
            InvokeDynamicSupport.bootstrap("marshalPrimitive", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(android.util.Rational java.nio.ByteBuffer ), this, rational, byteBuffer);
        }

        private void marshalPrimitive(byte by, ByteBuffer byteBuffer) {
            InvokeDynamicSupport.bootstrap("marshalPrimitive", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$marshalPrimitive(byte java.nio.ByteBuffer ), this, by, byteBuffer);
        }

        private Object unmarshalObject(ByteBuffer byteBuffer) {
            return InvokeDynamicSupport.bootstrap("unmarshalObject", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$unmarshalObject(java.nio.ByteBuffer ), this, byteBuffer);
        }

        @Override
        public int getNativeSize() {
            return (int)InvokeDynamicSupport.bootstrap("getNativeSize", $$robo$$android_hardware_camera2_marshal_impl_MarshalQueryablePrimitive_MarshalerPrimitive$getNativeSize(), this);
        }

        public /* synthetic */ MarshalerPrimitive() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MarshalerPrimitive)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

