/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.utils.SubmitInfo;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.OsConstants;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraDeviceUserShim
implements ICameraDeviceUser,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "CameraDeviceUserShim";
    private static boolean DEBUG = false;
    private static int OPEN_CAMERA_TIMEOUT_MS = 5000;
    private LegacyCameraDevice mLegacyDevice;
    private Object mConfigureLock;
    private int mSurfaceIdCounter;
    private boolean mConfiguring;
    private SparseArray<Surface> mSurfaces;
    private CameraCharacteristics mCameraCharacteristics;
    private CameraLooper mCameraInit;
    private CameraCallbackThread mCameraCallbacks;

    private void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$__constructor__(int cameraId, LegacyCameraDevice legacyCamera, CameraCharacteristics characteristics, CameraLooper cameraInit, CameraCallbackThread cameraCallbacks) {
        this.mConfigureLock = new Object();
        this.mLegacyDevice = legacyCamera;
        this.mConfiguring = false;
        this.mSurfaces = new SparseArray();
        this.mCameraCharacteristics = characteristics;
        this.mCameraInit = cameraInit;
        this.mCameraCallbacks = cameraCallbacks;
        this.mSurfaceIdCounter = 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$translateErrorsFromCamera1(int errorCode) {
        if (errorCode == -OsConstants.EACCES) {
            return 1;
        }
        return errorCode;
    }

    private static final CameraDeviceUserShim $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$connectBinderShim(ICameraDeviceCallbacks callbacks, int cameraId) {
        CameraLooper init = new CameraLooper(cameraId);
        CameraCallbackThread threadCallbacks = new CameraCallbackThread(callbacks);
        int initErrors = init.waitForOpen(5000);
        Camera legacyCamera = init.getCamera();
        LegacyExceptionUtils.throwOnServiceError(initErrors);
        legacyCamera.disableShutterSound();
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo(cameraId, info);
        Camera.Parameters legacyParameters = null;
        try {
            legacyParameters = legacyCamera.getParameters();
        }
        catch (RuntimeException e) {
            throw new ServiceSpecificException(10, "Unable to get initial parameters: " + e.getMessage());
        }
        CameraCharacteristics characteristics = LegacyMetadataMapper.createCharacteristics(legacyParameters, info);
        LegacyCameraDevice device = new LegacyCameraDevice(cameraId, legacyCamera, characteristics, threadCallbacks);
        return new CameraDeviceUserShim(cameraId, device, characteristics, init, threadCallbacks);
    }

    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$disconnect() {
        if (this.mLegacyDevice.isClosed()) {
            Log.w("CameraDeviceUserShim", "Cannot disconnect, device has already been closed.");
        }
        try {
            this.mLegacyDevice.close();
        }
        finally {
            this.mCameraInit.close();
            this.mCameraCallbacks.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubmitInfo $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$submitRequest(CaptureRequest request, boolean streaming) {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot submit request, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                String err = "Cannot submit request, configuration change in progress.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
        }
        return this.mLegacyDevice.submitRequest(request, streaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubmitInfo $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$submitRequestList(CaptureRequest[] request, boolean streaming) {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot submit request list, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                String err = "Cannot submit request, configuration change in progress.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
        }
        return this.mLegacyDevice.submitRequestList(request, streaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$cancelRequest(int requestId) {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot cancel request, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                String err = "Cannot cancel request, configuration change in progress.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
        }
        return this.mLegacyDevice.cancelRequest(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$beginConfigure() {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot begin configure, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                String err = "Cannot begin configure, configuration change already in progress.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
            this.mConfiguring = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$endConfigure(int operatingMode) {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot end configure, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        if (operatingMode != 0) {
            String err = "LEGACY devices do not support this operating mode";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(3, err);
        }
        Object surfaces = null;
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                String err = "Cannot end configure, no configuration change in progress.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
            if (this.mSurfaces != null) {
                surfaces = this.mSurfaces.clone();
            }
            this.mConfiguring = false;
        }
        this.mLegacyDevice.configureOutputs((SparseArray<Surface>)surfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$deleteStream(int streamId) {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot delete stream, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                String err = "Cannot delete stream, no configuration change in progress.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
            int index = this.mSurfaces.indexOfKey(streamId);
            if (index < 0) {
                String err = "Cannot delete stream, stream id " + streamId + " doesn't exist.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(3, err);
            }
            this.mSurfaces.removeAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createStream(OutputConfiguration outputConfiguration) {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot create stream, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                String err = "Cannot create stream, beginConfigure hasn't been called yet.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
            if (outputConfiguration.getRotation() != 0) {
                String err = "Cannot create stream, stream rotation is not supported.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(3, err);
            }
            int id2 = ++this.mSurfaceIdCounter;
            this.mSurfaces.put(id2, outputConfiguration.getSurface());
            return id2;
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$finalizeOutputConfigurations(int steamId, OutputConfiguration config) {
        String err = "Finalizing output configuration is not supported on legacy devices";
        Log.e("CameraDeviceUserShim", err);
        throw new ServiceSpecificException(10, err);
    }

    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createInputStream(int width, int height, int format) {
        String err = "Creating input stream is not supported on legacy devices";
        Log.e("CameraDeviceUserShim", err);
        throw new ServiceSpecificException(10, err);
    }

    private final Surface $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$getInputSurface() {
        String err = "Getting input surface is not supported on legacy devices";
        Log.e("CameraDeviceUserShim", err);
        throw new ServiceSpecificException(10, err);
    }

    private final CameraMetadataNative $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createDefaultRequest(int templateId) {
        CameraMetadataNative template;
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot create default request, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        try {
            template = LegacyMetadataMapper.createRequestTemplate(this.mCameraCharacteristics, templateId);
        }
        catch (IllegalArgumentException e) {
            String err = "createDefaultRequest - invalid templateId specified";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(3, err);
        }
        return template;
    }

    private final CameraMetadataNative $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$getCameraInfo() {
        Log.e("CameraDeviceUserShim", "getCameraInfo unimplemented.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$waitUntilIdle() throws RemoteException {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot wait until idle, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                String err = "Cannot wait until idle, configuration change in progress.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
        }
        this.mLegacyDevice.waitUntilIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$flush() {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot flush, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                String err = "Cannot flush, configuration change in progress.";
                Log.e("CameraDeviceUserShim", err);
                throw new ServiceSpecificException(10, err);
            }
        }
        return this.mLegacyDevice.flush();
    }

    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$prepare(int streamId) {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot prepare stream, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
        this.mCameraCallbacks.onPrepared(streamId);
    }

    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$prepare2(int maxCount, int streamId) {
        this.prepare(streamId);
    }

    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$tearDown(int streamId) {
        if (this.mLegacyDevice.isClosed()) {
            String err = "Cannot tear down stream, device has been closed.";
            Log.e("CameraDeviceUserShim", err);
            throw new ServiceSpecificException(4, err);
        }
    }

    private final IBinder $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$asBinder() {
        return null;
    }

    private void __constructor__(int n, LegacyCameraDevice legacyCameraDevice, CameraCharacteristics cameraCharacteristics, CameraLooper cameraLooper, CameraCallbackThread cameraCallbackThread) {
        this.$$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$__constructor__(n, legacyCameraDevice, cameraCharacteristics, cameraLooper, cameraCallbackThread);
    }

    public CameraDeviceUserShim(int n, LegacyCameraDevice legacyCameraDevice, CameraCharacteristics cameraCharacteristics, CameraLooper cameraLooper, CameraCallbackThread cameraCallbackThread) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$__constructor__(int android.hardware.camera2.legacy.LegacyCameraDevice android.hardware.camera2.CameraCharacteristics android.hardware.camera2.legacy.CameraDeviceUserShim$CameraLooper android.hardware.camera2.legacy.CameraDeviceUserShim$CameraCallbackThread ), this, n, legacyCameraDevice, cameraCharacteristics, cameraLooper, cameraCallbackThread);
    }

    private static int translateErrorsFromCamera1(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("translateErrorsFromCamera1", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$translateErrorsFromCamera1(int ), (int)n);
    }

    public static CameraDeviceUserShim connectBinderShim(ICameraDeviceCallbacks iCameraDeviceCallbacks, int n) {
        return InvokeDynamicSupport.bootstrapStatic("connectBinderShim", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$connectBinderShim(android.hardware.camera2.ICameraDeviceCallbacks int ), (ICameraDeviceCallbacks)iCameraDeviceCallbacks, (int)n);
    }

    @Override
    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$disconnect(), this);
    }

    @Override
    public SubmitInfo submitRequest(CaptureRequest captureRequest, boolean bl) {
        return InvokeDynamicSupport.bootstrap("submitRequest", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$submitRequest(android.hardware.camera2.CaptureRequest boolean ), this, captureRequest, bl);
    }

    @Override
    public SubmitInfo submitRequestList(CaptureRequest[] captureRequestArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("submitRequestList", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$submitRequestList(android.hardware.camera2.CaptureRequest[] boolean ), this, captureRequestArray, bl);
    }

    @Override
    public long cancelRequest(int n) {
        return (long)InvokeDynamicSupport.bootstrap("cancelRequest", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$cancelRequest(int ), this, n);
    }

    @Override
    public void beginConfigure() {
        InvokeDynamicSupport.bootstrap("beginConfigure", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$beginConfigure(), this);
    }

    @Override
    public void endConfigure(int n) {
        InvokeDynamicSupport.bootstrap("endConfigure", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$endConfigure(int ), this, n);
    }

    @Override
    public void deleteStream(int n) {
        InvokeDynamicSupport.bootstrap("deleteStream", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$deleteStream(int ), this, n);
    }

    @Override
    public int createStream(OutputConfiguration outputConfiguration) {
        return (int)InvokeDynamicSupport.bootstrap("createStream", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createStream(android.hardware.camera2.params.OutputConfiguration ), this, outputConfiguration);
    }

    @Override
    public void finalizeOutputConfigurations(int n, OutputConfiguration outputConfiguration) {
        InvokeDynamicSupport.bootstrap("finalizeOutputConfigurations", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$finalizeOutputConfigurations(int android.hardware.camera2.params.OutputConfiguration ), this, n, outputConfiguration);
    }

    @Override
    public int createInputStream(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("createInputStream", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createInputStream(int int int ), this, n, n2, n3);
    }

    @Override
    public Surface getInputSurface() {
        return InvokeDynamicSupport.bootstrap("getInputSurface", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$getInputSurface(), this);
    }

    @Override
    public CameraMetadataNative createDefaultRequest(int n) {
        return InvokeDynamicSupport.bootstrap("createDefaultRequest", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createDefaultRequest(int ), this, n);
    }

    @Override
    public CameraMetadataNative getCameraInfo() {
        return InvokeDynamicSupport.bootstrap("getCameraInfo", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$getCameraInfo(), this);
    }

    @Override
    public void waitUntilIdle() throws RemoteException {
        InvokeDynamicSupport.bootstrap("waitUntilIdle", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$waitUntilIdle(), this);
    }

    @Override
    public long flush() {
        return (long)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$flush(), this);
    }

    @Override
    public void prepare(int n) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$prepare(int ), this, n);
    }

    @Override
    public void prepare2(int n, int n2) {
        InvokeDynamicSupport.bootstrap("prepare2", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$prepare2(int int ), this, n, n2);
    }

    @Override
    public void tearDown(int n) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$tearDown(int ), this, n);
    }

    @Override
    public IBinder asBinder() {
        return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$asBinder(), this);
    }

    public /* synthetic */ CameraDeviceUserShim() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraDeviceUserShim)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CameraCallbackThread
    implements ICameraDeviceCallbacks,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int CAMERA_ERROR = 0;
        private static int CAMERA_IDLE = 1;
        private static int CAPTURE_STARTED = 2;
        private static int RESULT_RECEIVED = 3;
        private static int PREPARED = 4;
        private static int REPEATING_REQUEST_ERROR = 5;
        private static int REQUEST_QUEUE_EMPTY = 6;
        private HandlerThread mHandlerThread;
        private Handler mHandler;
        private ICameraDeviceCallbacks mCallbacks;

        private void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$__constructor__(ICameraDeviceCallbacks callbacks) {
            this.mCallbacks = callbacks;
            this.mHandlerThread = new HandlerThread("LegacyCameraCallback");
            this.mHandlerThread.start();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$close() {
            this.mHandlerThread.quitSafely();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            Message msg = this.getHandler().obtainMessage(0, errorCode, 0, resultExtras);
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onDeviceIdle() {
            Message msg = this.getHandler().obtainMessage(1);
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onCaptureStarted(CaptureResultExtras resultExtras, long timestamp) {
            Message msg = this.getHandler().obtainMessage(2, (int)(timestamp & 0xFFFFFFFFL), (int)(timestamp >> 32 & 0xFFFFFFFFL), resultExtras);
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras) {
            Object[] resultArray = new Object[]{result, resultExtras};
            Message msg = this.getHandler().obtainMessage(3, resultArray);
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onPrepared(int streamId) {
            Message msg = this.getHandler().obtainMessage(4, streamId, 0);
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onRepeatingRequestError(long lastFrameNumber) {
            Message msg = this.getHandler().obtainMessage(5, (int)(lastFrameNumber & 0xFFFFFFFFL), (int)(lastFrameNumber >> 32 & 0xFFFFFFFFL));
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onRequestQueueEmpty() {
            Message msg = this.getHandler().obtainMessage(6, 0, 0);
            this.getHandler().sendMessage(msg);
        }

        private final IBinder $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$asBinder() {
            return null;
        }

        private final Handler $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$getHandler() {
            if (this.mHandler == null) {
                this.mHandler = new CallbackHandler(this, this.mHandlerThread.getLooper());
            }
            return this.mHandler;
        }

        private void __constructor__(ICameraDeviceCallbacks iCameraDeviceCallbacks) {
            this.$$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$__constructor__(iCameraDeviceCallbacks);
        }

        public CameraCallbackThread(ICameraDeviceCallbacks iCameraDeviceCallbacks) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$__constructor__(android.hardware.camera2.ICameraDeviceCallbacks ), this, iCameraDeviceCallbacks);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$close(), this);
        }

        @Override
        public void onDeviceError(int n, CaptureResultExtras captureResultExtras) {
            InvokeDynamicSupport.bootstrap("onDeviceError", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onDeviceError(int android.hardware.camera2.impl.CaptureResultExtras ), this, n, captureResultExtras);
        }

        @Override
        public void onDeviceIdle() {
            InvokeDynamicSupport.bootstrap("onDeviceIdle", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onDeviceIdle(), this);
        }

        @Override
        public void onCaptureStarted(CaptureResultExtras captureResultExtras, long l) {
            InvokeDynamicSupport.bootstrap("onCaptureStarted", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onCaptureStarted(android.hardware.camera2.impl.CaptureResultExtras long ), this, captureResultExtras, l);
        }

        @Override
        public void onResultReceived(CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) {
            InvokeDynamicSupport.bootstrap("onResultReceived", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onResultReceived(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CaptureResultExtras ), this, cameraMetadataNative, captureResultExtras);
        }

        @Override
        public void onPrepared(int n) {
            InvokeDynamicSupport.bootstrap("onPrepared", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onPrepared(int ), this, n);
        }

        @Override
        public void onRepeatingRequestError(long l) {
            InvokeDynamicSupport.bootstrap("onRepeatingRequestError", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onRepeatingRequestError(long ), this, l);
        }

        @Override
        public void onRequestQueueEmpty() {
            InvokeDynamicSupport.bootstrap("onRequestQueueEmpty", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onRequestQueueEmpty(), this);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$asBinder(), this);
        }

        private Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$getHandler(), this);
        }

        public /* synthetic */ CameraCallbackThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraCallbackThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class CallbackHandler
        extends Handler
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraCallbackThread this$0;

            private void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$__constructor__(CameraCallbackThread cameraCallbackThread, Looper l) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$handleMessage(Message msg) {
                try {
                    switch (msg.what) {
                        case 0: {
                            int errorCode = msg.arg1;
                            CaptureResultExtras resultExtras = (CaptureResultExtras)msg.obj;
                            this.this$0.mCallbacks.onDeviceError(errorCode, resultExtras);
                            break;
                        }
                        case 1: {
                            this.this$0.mCallbacks.onDeviceIdle();
                            break;
                        }
                        case 2: {
                            long timestamp = (long)msg.arg2 & 0xFFFFFFFFL;
                            timestamp = timestamp << 32 | (long)msg.arg1 & 0xFFFFFFFFL;
                            CaptureResultExtras resultExtras = (CaptureResultExtras)msg.obj;
                            this.this$0.mCallbacks.onCaptureStarted(resultExtras, timestamp);
                            break;
                        }
                        case 3: {
                            Object[] resultArray = (Object[])msg.obj;
                            CameraMetadataNative result = (CameraMetadataNative)resultArray[0];
                            CaptureResultExtras resultExtras = (CaptureResultExtras)resultArray[1];
                            this.this$0.mCallbacks.onResultReceived(result, resultExtras);
                            break;
                        }
                        case 4: {
                            int streamId = msg.arg1;
                            this.this$0.mCallbacks.onPrepared(streamId);
                            break;
                        }
                        case 5: {
                            long lastFrameNumber = (long)msg.arg2 & 0xFFFFFFFFL;
                            lastFrameNumber = lastFrameNumber << 32 | (long)msg.arg1 & 0xFFFFFFFFL;
                            this.this$0.mCallbacks.onRepeatingRequestError(lastFrameNumber);
                            break;
                        }
                        case 6: {
                            this.this$0.mCallbacks.onRequestQueueEmpty();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown callback message " + msg.what);
                        }
                    }
                }
                catch (RemoteException e) {
                    throw new IllegalStateException("Received remote exception during camera callback " + msg.what, e);
                }
            }

            private void __constructor__(CameraCallbackThread cameraCallbackThread, Looper looper) {
                this.$$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$__constructor__(cameraCallbackThread, looper);
            }

            public CallbackHandler(CameraCallbackThread cameraCallbackThread, Looper looper) {
                this.this$0 = cameraCallbackThread;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$__constructor__(android.hardware.camera2.legacy.CameraDeviceUserShim$CameraCallbackThread android.os.Looper ), this, cameraCallbackThread, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$handleMessage(android.os.Message ), this, message);
            }

            public /* synthetic */ CallbackHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private static class CameraLooper
    implements Runnable,
    AutoCloseable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mCameraId;
        private Looper mLooper;
        private volatile int mInitErrors;
        private Camera mCamera;
        private ConditionVariable mStartDone;
        private Thread mThread;

        private void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$__constructor__(int cameraId) {
            this.mCamera = Camera.openUninitialized();
            this.mStartDone = new ConditionVariable();
            this.mCameraId = cameraId;
            this.mThread = new Thread(this);
            this.mThread.start();
        }

        private final Camera $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$getCamera() {
            return this.mCamera;
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$run() {
            Looper.prepare();
            this.mLooper = Looper.myLooper();
            this.mInitErrors = this.mCamera.cameraInitUnspecified(this.mCameraId);
            this.mStartDone.open();
            Looper.loop();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$close() {
            if (this.mLooper == null) {
                return;
            }
            this.mLooper.quitSafely();
            try {
                this.mThread.join();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            this.mLooper = null;
        }

        private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$waitForOpen(int timeoutMs) {
            if (!this.mStartDone.block(timeoutMs)) {
                Log.e("CameraDeviceUserShim", "waitForOpen - Camera failed to open after timeout of 5000 ms");
                try {
                    this.mCamera.release();
                }
                catch (RuntimeException e) {
                    Log.e("CameraDeviceUserShim", "connectBinderShim - Failed to release camera after timeout ", e);
                }
                throw new ServiceSpecificException(10);
            }
            return this.mInitErrors;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$__constructor__(n);
        }

        public CameraLooper(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$__constructor__(int ), this, n);
        }

        public Camera getCamera() {
            return InvokeDynamicSupport.bootstrap("getCamera", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$getCamera(), this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$run(), this);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$close(), this);
        }

        public int waitForOpen(int n) {
            return (int)InvokeDynamicSupport.bootstrap("waitForOpen", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$waitForOpen(int ), this, n);
        }

        public /* synthetic */ CameraLooper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraLooper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

