/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.RequestHolder;
import android.os.Handler;
import android.util.Log;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraDeviceState
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "CameraDeviceState";
    private static boolean DEBUG = false;
    private static int STATE_ERROR = 0;
    private static int STATE_UNCONFIGURED = 1;
    private static int STATE_CONFIGURING = 2;
    private static int STATE_IDLE = 3;
    private static int STATE_CAPTURING = 4;
    private static String[] sStateNames;
    private int mCurrentState;
    private int mCurrentError;
    private RequestHolder mCurrentRequest;
    private Handler mCurrentHandler;
    private CameraDeviceStateListener mCurrentListener;
    public static int NO_CAPTURE_ERROR = -1;

    private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState$__constructor__() {
        this.mCurrentState = 1;
        this.mCurrentError = -1;
        this.mCurrentRequest = null;
        this.mCurrentHandler = null;
        this.mCurrentListener = null;
    }

    private final synchronized void $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setError(int error) {
        this.mCurrentError = error;
        this.doStateTransition(0);
    }

    private final synchronized boolean $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setConfiguring() {
        this.doStateTransition(2);
        return this.mCurrentError == -1;
    }

    private final synchronized boolean $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setIdle() {
        this.doStateTransition(3);
        return this.mCurrentError == -1;
    }

    private final synchronized boolean $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setCaptureStart(RequestHolder request, long timestamp, int captureError) {
        this.mCurrentRequest = request;
        this.doStateTransition(4, timestamp, captureError);
        return this.mCurrentError == -1;
    }

    private final synchronized boolean $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setCaptureResult(RequestHolder request, CameraMetadataNative result, int captureError, Object captureErrorArg) {
        if (this.mCurrentState != 4) {
            Log.e("CameraDeviceState", "Cannot receive result while in state: " + this.mCurrentState);
            this.mCurrentError = 1;
            this.doStateTransition(0);
            return this.mCurrentError == -1;
        }
        if (this.mCurrentHandler != null && this.mCurrentListener != null) {
            if (captureError != -1) {
                this.mCurrentHandler.post(new Runnable(this, captureError, captureErrorArg, request){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$captureError;
                    /* synthetic */ Object val$captureErrorArg;
                    /* synthetic */ RequestHolder val$request;
                    /* synthetic */ CameraDeviceState this$0;

                    private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_1$__constructor__(CameraDeviceState this$0, int n, Object object, RequestHolder requestHolder) {
                        this.val$captureError = n;
                        this.val$captureErrorArg = object;
                        this.val$request = requestHolder;
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_1$run() {
                        this.this$0.mCurrentListener.onError(this.val$captureError, this.val$captureErrorArg, this.val$request);
                    }

                    private void __constructor__(CameraDeviceState cameraDeviceState, int n, Object object, RequestHolder requestHolder) {
                        this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_1$__constructor__(cameraDeviceState, n, object, requestHolder);
                    }
                    {
                        this.this$0 = cameraDeviceState;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_1$__constructor__(android.hardware.camera2.legacy.CameraDeviceState int java.lang.Object android.hardware.camera2.legacy.RequestHolder ), this, cameraDeviceState, n, object, requestHolder);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_1$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                this.mCurrentHandler.post(new Runnable(this, result, request){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ CameraMetadataNative val$result;
                    /* synthetic */ RequestHolder val$request;
                    /* synthetic */ CameraDeviceState this$0;

                    private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_2$__constructor__(CameraDeviceState this$0, CameraMetadataNative cameraMetadataNative, RequestHolder requestHolder) {
                        this.val$result = cameraMetadataNative;
                        this.val$request = requestHolder;
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_2$run() {
                        this.this$0.mCurrentListener.onCaptureResult(this.val$result, this.val$request);
                    }

                    private void __constructor__(CameraDeviceState cameraDeviceState, CameraMetadataNative cameraMetadataNative, RequestHolder requestHolder) {
                        this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_2$__constructor__(cameraDeviceState, cameraMetadataNative, requestHolder);
                    }
                    {
                        this.this$0 = cameraDeviceState;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_2$__constructor__(android.hardware.camera2.legacy.CameraDeviceState android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.legacy.RequestHolder ), this, cameraDeviceState, cameraMetadataNative, requestHolder);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_2$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
        return this.mCurrentError == -1;
    }

    private final synchronized boolean $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setCaptureResult(RequestHolder request, CameraMetadataNative result) {
        return this.setCaptureResult(request, result, -1, null);
    }

    private final synchronized void $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setRepeatingRequestError(long lastFrameNumber) {
        this.mCurrentHandler.post(new Runnable(this, lastFrameNumber){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ long val$lastFrameNumber;
            /* synthetic */ CameraDeviceState this$0;

            private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_3$__constructor__(CameraDeviceState this$0, long l) {
                this.val$lastFrameNumber = l;
            }

            private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_3$run() {
                this.this$0.mCurrentListener.onRepeatingRequestError(this.val$lastFrameNumber);
            }

            private void __constructor__(CameraDeviceState cameraDeviceState, long l) {
                this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_3$__constructor__(cameraDeviceState, l);
            }
            {
                this.this$0 = cameraDeviceState;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_3$__constructor__(android.hardware.camera2.legacy.CameraDeviceState long ), this, cameraDeviceState, l);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_3$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final synchronized void $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setCameraDeviceCallbacks(Handler handler, CameraDeviceStateListener listener) {
        this.mCurrentHandler = handler;
        this.mCurrentListener = listener;
    }

    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState$doStateTransition(int newState) {
        this.doStateTransition(newState, 0L, -1);
    }

    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState$doStateTransition(int newState, long timestamp, int error) {
        if (newState != this.mCurrentState) {
            String stateName = "UNKNOWN";
            if (newState >= 0 && newState < sStateNames.length) {
                stateName = sStateNames[newState];
            }
            Log.i("CameraDeviceState", "Legacy camera service transitioning to state " + stateName);
        }
        if (newState != 0 && newState != 3 && this.mCurrentState != newState && this.mCurrentHandler != null && this.mCurrentListener != null) {
            this.mCurrentHandler.post(new Runnable(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ CameraDeviceState this$0;

                private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_4$__constructor__(CameraDeviceState this$0) {
                }

                private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_4$run() {
                    this.this$0.mCurrentListener.onBusy();
                }

                private void __constructor__(CameraDeviceState cameraDeviceState) {
                    this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_4$__constructor__(cameraDeviceState);
                }
                {
                    this.this$0 = cameraDeviceState;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_4$__constructor__(android.hardware.camera2.legacy.CameraDeviceState ), this, cameraDeviceState);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_4$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        switch (newState) {
            case 0: {
                if (this.mCurrentState != 0 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(this){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ CameraDeviceState this$0;

                        private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_5$__constructor__(CameraDeviceState this$0) {
                        }

                        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_5$run() {
                            this.this$0.mCurrentListener.onError(this.this$0.mCurrentError, null, this.this$0.mCurrentRequest);
                        }

                        private void __constructor__(CameraDeviceState cameraDeviceState) {
                            this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_5$__constructor__(cameraDeviceState);
                        }
                        {
                            this.this$0 = cameraDeviceState;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_5$__constructor__(android.hardware.camera2.legacy.CameraDeviceState ), this, cameraDeviceState);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_5$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
                this.mCurrentState = 0;
                break;
            }
            case 2: {
                if (this.mCurrentState != 1 && this.mCurrentState != 3) {
                    Log.e("CameraDeviceState", "Cannot call configure while in state: " + this.mCurrentState);
                    this.mCurrentError = 1;
                    this.doStateTransition(0);
                    break;
                }
                if (this.mCurrentState != 2 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(this){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ CameraDeviceState this$0;

                        private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_6$__constructor__(CameraDeviceState this$0) {
                        }

                        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_6$run() {
                            this.this$0.mCurrentListener.onConfiguring();
                        }

                        private void __constructor__(CameraDeviceState cameraDeviceState) {
                            this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_6$__constructor__(cameraDeviceState);
                        }
                        {
                            this.this$0 = cameraDeviceState;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_6$__constructor__(android.hardware.camera2.legacy.CameraDeviceState ), this, cameraDeviceState);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_6$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
                this.mCurrentState = 2;
                break;
            }
            case 3: {
                if (this.mCurrentState == 3) break;
                if (this.mCurrentState != 2 && this.mCurrentState != 4) {
                    Log.e("CameraDeviceState", "Cannot call idle while in state: " + this.mCurrentState);
                    this.mCurrentError = 1;
                    this.doStateTransition(0);
                    break;
                }
                if (this.mCurrentState != 3 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(this){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ CameraDeviceState this$0;

                        private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_7$__constructor__(CameraDeviceState this$0) {
                        }

                        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_7$run() {
                            this.this$0.mCurrentListener.onIdle();
                        }

                        private void __constructor__(CameraDeviceState cameraDeviceState) {
                            this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_7$__constructor__(cameraDeviceState);
                        }
                        {
                            this.this$0 = cameraDeviceState;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_7$__constructor__(android.hardware.camera2.legacy.CameraDeviceState ), this, cameraDeviceState);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_7$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
                this.mCurrentState = 3;
                break;
            }
            case 4: {
                if (this.mCurrentState != 3 && this.mCurrentState != 4) {
                    Log.e("CameraDeviceState", "Cannot call capture while in state: " + this.mCurrentState);
                    this.mCurrentError = 1;
                    this.doStateTransition(0);
                    break;
                }
                if (this.mCurrentHandler != null && this.mCurrentListener != null) {
                    if (error != -1) {
                        this.mCurrentHandler.post(new Runnable(this, error){
                            public /* synthetic */ Object __robo_data__;
                            /* synthetic */ int val$error;
                            /* synthetic */ CameraDeviceState this$0;

                            private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_8$__constructor__(CameraDeviceState this$0, int n) {
                                this.val$error = n;
                            }

                            private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_8$run() {
                                this.this$0.mCurrentListener.onError(this.val$error, null, this.this$0.mCurrentRequest);
                            }

                            private void __constructor__(CameraDeviceState cameraDeviceState, int n) {
                                this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_8$__constructor__(cameraDeviceState, n);
                            }
                            {
                                this.this$0 = cameraDeviceState;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_8$__constructor__(android.hardware.camera2.legacy.CameraDeviceState int ), this, cameraDeviceState, n);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_8$run(), this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    } else {
                        this.mCurrentHandler.post(new Runnable(this, timestamp){
                            public /* synthetic */ Object __robo_data__;
                            /* synthetic */ long val$timestamp;
                            /* synthetic */ CameraDeviceState this$0;

                            private void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_9$__constructor__(CameraDeviceState this$0, long l) {
                                this.val$timestamp = l;
                            }

                            private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceState_9$run() {
                                this.this$0.mCurrentListener.onCaptureStarted(this.this$0.mCurrentRequest, this.val$timestamp);
                            }

                            private void __constructor__(CameraDeviceState cameraDeviceState, long l) {
                                this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState_9$__constructor__(cameraDeviceState, l);
                            }
                            {
                                this.this$0 = cameraDeviceState;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_9$__constructor__(android.hardware.camera2.legacy.CameraDeviceState long ), this, cameraDeviceState, l);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceState_9$run(), this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    }
                }
                this.mCurrentState = 4;
                break;
            }
            default: {
                throw new IllegalStateException("Transition to unknown state: " + newState);
            }
        }
    }

    static void __staticInitializer__() {
        sStateNames = new String[]{"ERROR", "UNCONFIGURED", "CONFIGURING", "IDLE", "CAPTURING"};
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_legacy_CameraDeviceState$__constructor__();
    }

    public CameraDeviceState() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$__constructor__(), this);
    }

    public synchronized void setError(int n) {
        InvokeDynamicSupport.bootstrap("setError", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setError(int ), this, n);
    }

    public synchronized boolean setConfiguring() {
        return (boolean)InvokeDynamicSupport.bootstrap("setConfiguring", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setConfiguring(), this);
    }

    public synchronized boolean setIdle() {
        return (boolean)InvokeDynamicSupport.bootstrap("setIdle", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setIdle(), this);
    }

    public synchronized boolean setCaptureStart(RequestHolder requestHolder, long l, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCaptureStart", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setCaptureStart(android.hardware.camera2.legacy.RequestHolder long int ), this, requestHolder, l, n);
    }

    public synchronized boolean setCaptureResult(RequestHolder requestHolder, CameraMetadataNative cameraMetadataNative, int n, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCaptureResult", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setCaptureResult(android.hardware.camera2.legacy.RequestHolder android.hardware.camera2.impl.CameraMetadataNative int java.lang.Object ), this, requestHolder, cameraMetadataNative, n, object);
    }

    public synchronized boolean setCaptureResult(RequestHolder requestHolder, CameraMetadataNative cameraMetadataNative) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCaptureResult", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setCaptureResult(android.hardware.camera2.legacy.RequestHolder android.hardware.camera2.impl.CameraMetadataNative ), this, requestHolder, cameraMetadataNative);
    }

    public synchronized void setRepeatingRequestError(long l) {
        InvokeDynamicSupport.bootstrap("setRepeatingRequestError", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setRepeatingRequestError(long ), this, l);
    }

    public synchronized void setCameraDeviceCallbacks(Handler handler, CameraDeviceStateListener cameraDeviceStateListener) {
        InvokeDynamicSupport.bootstrap("setCameraDeviceCallbacks", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$setCameraDeviceCallbacks(android.os.Handler android.hardware.camera2.legacy.CameraDeviceState$CameraDeviceStateListener ), this, handler, cameraDeviceStateListener);
    }

    private void doStateTransition(int n) {
        InvokeDynamicSupport.bootstrap("doStateTransition", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$doStateTransition(int ), this, n);
    }

    private void doStateTransition(int n, long l, int n2) {
        InvokeDynamicSupport.bootstrap("doStateTransition", $$robo$$android_hardware_camera2_legacy_CameraDeviceState$doStateTransition(int long int ), this, n, l, n2);
    }

    static {
        RobolectricInternals.classInitializing(CameraDeviceState.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraDeviceState)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface CameraDeviceStateListener
    extends InstrumentedInterface {
        public void onError(int var1, Object var2, RequestHolder var3);

        public void onConfiguring();

        public void onIdle();

        public void onBusy();

        public void onCaptureStarted(RequestHolder var1, long var2);

        public void onCaptureResult(CameraMetadataNative var1, RequestHolder var2);

        public void onRepeatingRequestError(long var1);
    }
}

