/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.hardware.SensorManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LegacySensorManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean sInitialized;
    private static IWindowManager sWindowManager;
    private static int sRotation;
    private SensorManager mSensorManager;
    private HashMap<SensorListener, LegacyListener> mLegacyListenersMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_hardware_LegacySensorManager$__constructor__(SensorManager sensorManager) {
        this.mLegacyListenersMap = new HashMap();
        this.mSensorManager = sensorManager;
        Class<SensorManager> clazz = SensorManager.class;
        synchronized (SensorManager.class) {
            if (!sInitialized && (sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"))) != null) {
                try {
                    sRotation = sWindowManager.watchRotation((IRotationWatcher)new ShadowedObject(this){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ LegacySensorManager this$0;

                        private void $$robo$$android_hardware_LegacySensorManager_1$__constructor__(LegacySensorManager this$0) {
                        }

                        private final void $$robo$$android_hardware_LegacySensorManager_1$onRotationChanged(int rotation) {
                            LegacySensorManager.onRotationChanged(rotation);
                        }

                        private void __constructor__(LegacySensorManager legacySensorManager) {
                            this.$$robo$$android_hardware_LegacySensorManager_1$__constructor__(legacySensorManager);
                        }
                        {
                            this.this$0 = legacySensorManager;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_LegacySensorManager_1$__constructor__(android.hardware.LegacySensorManager ), this, legacySensorManager);
                        }

                        @Override
                        public void onRotationChanged(int n) {
                            InvokeDynamicSupport.bootstrap("onRotationChanged", $$robo$$android_hardware_LegacySensorManager_1$onRotationChanged(int ), this, n);
                        }
                        {
                            this.$$robo$init();
                        }

                        @Override
                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        @Override
                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    }, 0);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final int $$robo$$android_hardware_LegacySensorManager$getSensors() {
        int result = 0;
        List<Sensor> fullList = this.mSensorManager.getFullSensorList();
        for (Sensor i : fullList) {
            switch (i.getType()) {
                case 1: {
                    result |= 2;
                    break;
                }
                case 2: {
                    result |= 8;
                    break;
                }
                case 3: {
                    result |= 0x81;
                }
            }
        }
        return result;
    }

    private final boolean $$robo$$android_hardware_LegacySensorManager$registerListener(SensorListener listener, int sensors, int rate) {
        if (listener == null) {
            return false;
        }
        boolean result = false;
        result = this.registerLegacyListener(2, 1, listener, sensors, rate) || result;
        result = this.registerLegacyListener(8, 2, listener, sensors, rate) || result;
        result = this.registerLegacyListener(128, 3, listener, sensors, rate) || result;
        result = this.registerLegacyListener(1, 3, listener, sensors, rate) || result;
        result = this.registerLegacyListener(4, 7, listener, sensors, rate) || result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_LegacySensorManager$registerLegacyListener(int legacyType, int type, SensorListener listener, int sensors, int rate) {
        Sensor sensor;
        boolean result = false;
        if ((sensors & legacyType) != 0 && (sensor = this.mSensorManager.getDefaultSensor(type)) != null) {
            HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
            synchronized (hashMap) {
                LegacyListener legacyListener = this.mLegacyListenersMap.get(listener);
                if (legacyListener == null) {
                    legacyListener = new LegacyListener(listener);
                    this.mLegacyListenersMap.put(listener, legacyListener);
                }
                result = legacyListener.registerSensor(legacyType) ? this.mSensorManager.registerListener(legacyListener, sensor, rate) : true;
            }
        }
        return result;
    }

    private final void $$robo$$android_hardware_LegacySensorManager$unregisterListener(SensorListener listener, int sensors) {
        if (listener == null) {
            return;
        }
        this.unregisterLegacyListener(2, 1, listener, sensors);
        this.unregisterLegacyListener(8, 2, listener, sensors);
        this.unregisterLegacyListener(128, 3, listener, sensors);
        this.unregisterLegacyListener(1, 3, listener, sensors);
        this.unregisterLegacyListener(4, 7, listener, sensors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_LegacySensorManager$unregisterLegacyListener(int legacyType, int type, SensorListener listener, int sensors) {
        Sensor sensor;
        if ((sensors & legacyType) != 0 && (sensor = this.mSensorManager.getDefaultSensor(type)) != null) {
            HashMap<SensorListener, LegacyListener> hashMap = this.mLegacyListenersMap;
            synchronized (hashMap) {
                LegacyListener legacyListener = this.mLegacyListenersMap.get(listener);
                if (legacyListener != null && legacyListener.unregisterSensor(legacyType)) {
                    this.mSensorManager.unregisterListener(legacyListener, sensor);
                    if (!legacyListener.hasSensors()) {
                        this.mLegacyListenersMap.remove(listener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_hardware_LegacySensorManager$onRotationChanged(int rotation) {
        Class<SensorManager> clazz = SensorManager.class;
        synchronized (SensorManager.class) {
            sRotation = rotation;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_hardware_LegacySensorManager$getRotation() {
        Class<SensorManager> clazz = SensorManager.class;
        synchronized (SensorManager.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sRotation;
        }
    }

    static void __staticInitializer__() {
        sRotation = 0;
    }

    private void __constructor__(SensorManager sensorManager) {
        this.$$robo$$android_hardware_LegacySensorManager$__constructor__(sensorManager);
    }

    public LegacySensorManager(SensorManager sensorManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_LegacySensorManager$__constructor__(android.hardware.SensorManager ), this, sensorManager);
    }

    public int getSensors() {
        return (int)InvokeDynamicSupport.bootstrap("getSensors", $$robo$$android_hardware_LegacySensorManager$getSensors(), this);
    }

    public boolean registerListener(SensorListener sensorListener, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_hardware_LegacySensorManager$registerListener(android.hardware.SensorListener int int ), this, sensorListener, n, n2);
    }

    private boolean registerLegacyListener(int n, int n2, SensorListener sensorListener, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerLegacyListener", $$robo$$android_hardware_LegacySensorManager$registerLegacyListener(int int android.hardware.SensorListener int int ), this, n, n2, sensorListener, n3, n4);
    }

    public void unregisterListener(SensorListener sensorListener, int n) {
        InvokeDynamicSupport.bootstrap("unregisterListener", $$robo$$android_hardware_LegacySensorManager$unregisterListener(android.hardware.SensorListener int ), this, sensorListener, n);
    }

    private void unregisterLegacyListener(int n, int n2, SensorListener sensorListener, int n3) {
        InvokeDynamicSupport.bootstrap("unregisterLegacyListener", $$robo$$android_hardware_LegacySensorManager$unregisterLegacyListener(int int android.hardware.SensorListener int ), this, n, n2, sensorListener, n3);
    }

    static void onRotationChanged(int n) {
        InvokeDynamicSupport.bootstrapStatic("onRotationChanged", $$robo$$android_hardware_LegacySensorManager$onRotationChanged(int ), (int)n);
    }

    static int getRotation() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRotation", $$robo$$android_hardware_LegacySensorManager$getRotation());
    }

    static {
        RobolectricInternals.classInitializing(LegacySensorManager.class);
    }

    public /* synthetic */ LegacySensorManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacySensorManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LmsFilter
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int SENSORS_RATE_MS = 20;
        private static int COUNT = 12;
        private static float PREDICTION_RATIO = 0.33333334f;
        private static float PREDICTION_TIME = 0.08f;
        private float[] mV;
        private long[] mT;
        private int mIndex;

        private void $$robo$$android_hardware_LegacySensorManager_LmsFilter$__constructor__() {
            this.mV = new float[24];
            this.mT = new long[24];
            this.mIndex = 12;
        }

        private final float $$robo$$android_hardware_LegacySensorManager_LmsFilter$filter(long time, float in) {
            float v = in;
            float ns = 1.0E-9f;
            float v1 = this.mV[this.mIndex];
            if (v - v1 > 180.0f) {
                v -= 360.0f;
            } else if (v1 - v > 180.0f) {
                v += 360.0f;
            }
            ++this.mIndex;
            if (this.mIndex >= 24) {
                this.mIndex = 12;
            }
            this.mV[this.mIndex] = v;
            this.mT[this.mIndex] = time;
            this.mV[this.mIndex - 12] = v;
            this.mT[this.mIndex - 12] = time;
            float E = 0.0f;
            float D = 0.0f;
            float C = 0.0f;
            float B = 0.0f;
            float A = 0.0f;
            for (int i = 0; i < 11; ++i) {
                int j = this.mIndex - 1 - i;
                float Z = this.mV[j];
                float T2 = (float)(this.mT[j] / 2L + this.mT[j + 1] / 2L - time) * 1.0E-9f;
                float dT = (float)(this.mT[j] - this.mT[j + 1]) * 1.0E-9f;
                dT *= dT;
                A += Z * dT;
                B += T2 * (T2 * dT);
                C += T2 * dT;
                D += Z * (T2 * dT);
                E += dT;
            }
            float b = (A * B + C * D) / (E * B + C * C);
            float a = (E * b - A) / C;
            float f = b + 0.08f * a;
            float f2 = (f *= 0.0027777778f) >= 0.0f ? f : -f;
            if (f2 >= 0.5f) {
                f = f - (float)Math.ceil(f + 0.5f) + 1.0f;
            }
            if (f < 0.0f) {
                f += 1.0f;
            }
            return f *= 360.0f;
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_LegacySensorManager_LmsFilter$__constructor__();
        }

        public LmsFilter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_LegacySensorManager_LmsFilter$__constructor__(), this);
        }

        public float filter(long l, float f) {
            return (float)InvokeDynamicSupport.bootstrap("filter", $$robo$$android_hardware_LegacySensorManager_LmsFilter$filter(long float ), this, l, f);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LmsFilter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LegacyListener
    implements SensorEventListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private float[] mValues;
        private SensorListener mTarget;
        private int mSensors;
        private LmsFilter mYawfilter;

        private void $$robo$$android_hardware_LegacySensorManager_LegacyListener$__constructor__(SensorListener target) {
            this.mValues = new float[6];
            this.mYawfilter = new LmsFilter();
            this.mTarget = target;
            this.mSensors = 0;
        }

        private final boolean $$robo$$android_hardware_LegacySensorManager_LegacyListener$registerSensor(int legacyType) {
            if ((this.mSensors & legacyType) != 0) {
                return false;
            }
            boolean alreadyHasOrientationSensor = LegacyListener.hasOrientationSensor(this.mSensors);
            this.mSensors |= legacyType;
            return !alreadyHasOrientationSensor || !LegacyListener.hasOrientationSensor(legacyType);
        }

        private final boolean $$robo$$android_hardware_LegacySensorManager_LegacyListener$unregisterSensor(int legacyType) {
            if ((this.mSensors & legacyType) == 0) {
                return false;
            }
            this.mSensors &= ~legacyType;
            return !LegacyListener.hasOrientationSensor(legacyType) || !LegacyListener.hasOrientationSensor(this.mSensors);
        }

        private final boolean $$robo$$android_hardware_LegacySensorManager_LegacyListener$hasSensors() {
            return this.mSensors != 0;
        }

        private static final boolean $$robo$$android_hardware_LegacySensorManager_LegacyListener$hasOrientationSensor(int sensors) {
            return (sensors & 0x81) != 0;
        }

        private final void $$robo$$android_hardware_LegacySensorManager_LegacyListener$onAccuracyChanged(Sensor sensor, int accuracy) {
            try {
                this.mTarget.onAccuracyChanged(LegacyListener.getLegacySensorType(sensor.getType()), accuracy);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }

        private final void $$robo$$android_hardware_LegacySensorManager_LegacyListener$onSensorChanged(SensorEvent event) {
            float[] v = this.mValues;
            v[0] = event.values[0];
            v[1] = event.values[1];
            v[2] = event.values[2];
            int type = event.sensor.getType();
            int legacyType = LegacyListener.getLegacySensorType(type);
            this.mapSensorDataToWindow(legacyType, v, LegacySensorManager.getRotation());
            if (type == 3) {
                if ((this.mSensors & 0x80) != 0) {
                    this.mTarget.onSensorChanged(128, v);
                }
                if ((this.mSensors & 1) != 0) {
                    v[0] = this.mYawfilter.filter(event.timestamp, v[0]);
                    this.mTarget.onSensorChanged(1, v);
                }
            } else {
                this.mTarget.onSensorChanged(legacyType, v);
            }
        }

        private final void $$robo$$android_hardware_LegacySensorManager_LegacyListener$mapSensorDataToWindow(int sensor, float[] values, int orientation) {
            float x = values[0];
            float y = values[1];
            float z = values[2];
            switch (sensor) {
                case 1: 
                case 128: {
                    z = -z;
                    break;
                }
                case 2: {
                    x = -x;
                    y = -y;
                    z = -z;
                    break;
                }
                case 8: {
                    x = -x;
                    y = -y;
                }
            }
            values[0] = x;
            values[1] = y;
            values[2] = z;
            values[3] = x;
            values[4] = y;
            values[5] = z;
            if ((orientation & 1) != 0) {
                switch (sensor) {
                    case 2: 
                    case 8: {
                        values[0] = -y;
                        values[1] = x;
                        values[2] = z;
                        break;
                    }
                    case 1: 
                    case 128: {
                        values[0] = x + (float)(x < 270.0f ? 90 : -270);
                        values[1] = z;
                        values[2] = y;
                    }
                }
            }
            if ((orientation & 2) != 0) {
                x = values[0];
                y = values[1];
                z = values[2];
                switch (sensor) {
                    case 2: 
                    case 8: {
                        values[0] = -x;
                        values[1] = -y;
                        values[2] = z;
                        break;
                    }
                    case 1: 
                    case 128: {
                        values[0] = x >= 180.0f ? x - 180.0f : x + 180.0f;
                        values[1] = -y;
                        values[2] = -z;
                    }
                }
            }
        }

        private static final int $$robo$$android_hardware_LegacySensorManager_LegacyListener$getLegacySensorType(int type) {
            switch (type) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 8;
                }
                case 3: {
                    return 128;
                }
                case 7: {
                    return 4;
                }
            }
            return 0;
        }

        private void __constructor__(SensorListener sensorListener) {
            this.$$robo$$android_hardware_LegacySensorManager_LegacyListener$__constructor__(sensorListener);
        }

        public LegacyListener(SensorListener sensorListener) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_LegacySensorManager_LegacyListener$__constructor__(android.hardware.SensorListener ), this, sensorListener);
        }

        boolean registerSensor(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("registerSensor", $$robo$$android_hardware_LegacySensorManager_LegacyListener$registerSensor(int ), this, n);
        }

        boolean unregisterSensor(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("unregisterSensor", $$robo$$android_hardware_LegacySensorManager_LegacyListener$unregisterSensor(int ), this, n);
        }

        boolean hasSensors() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSensors", $$robo$$android_hardware_LegacySensorManager_LegacyListener$hasSensors(), this);
        }

        private static boolean hasOrientationSensor(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasOrientationSensor", $$robo$$android_hardware_LegacySensorManager_LegacyListener$hasOrientationSensor(int ), (int)n);
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
            InvokeDynamicSupport.bootstrap("onAccuracyChanged", $$robo$$android_hardware_LegacySensorManager_LegacyListener$onAccuracyChanged(android.hardware.Sensor int ), this, sensor, n);
        }

        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            InvokeDynamicSupport.bootstrap("onSensorChanged", $$robo$$android_hardware_LegacySensorManager_LegacyListener$onSensorChanged(android.hardware.SensorEvent ), this, sensorEvent);
        }

        private void mapSensorDataToWindow(int n, float[] fArray, int n2) {
            InvokeDynamicSupport.bootstrap("mapSensorDataToWindow", $$robo$$android_hardware_LegacySensorManager_LegacyListener$mapSensorDataToWindow(int float[] int ), this, n, fArray, n2);
        }

        private static int getLegacySensorType(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getLegacySensorType", $$robo$$android_hardware_LegacySensorManager_LegacyListener$getLegacySensorType(int ), (int)n);
        }

        public /* synthetic */ LegacyListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

