/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.annotation.IntDef;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PdfRenderer
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static Object sPdfiumLock;
    private CloseGuard mCloseGuard;
    private Point mTempPoint;
    private long mNativeDocument;
    private int mPageCount;
    private ParcelFileDescriptor mInput;
    private Page mCurrentPage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_graphics_pdf_PdfRenderer$__constructor__(ParcelFileDescriptor input) throws IOException {
        long size;
        this.mCloseGuard = CloseGuard.get();
        this.mTempPoint = new Point();
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Libcore.os.lseek(input.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            size = Libcore.os.fstat((FileDescriptor)input.getFileDescriptor()).st_size;
        }
        catch (ErrnoException ee) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mInput = input;
        Object object = sPdfiumLock;
        synchronized (object) {
            this.mNativeDocument = PdfRenderer.nativeCreate(this.mInput.getFd(), size);
            try {
                this.mPageCount = PdfRenderer.nativeGetPageCount(this.mNativeDocument);
            }
            catch (Throwable t) {
                PdfRenderer.nativeClose(this.mNativeDocument);
                throw t;
            }
        }
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_graphics_pdf_PdfRenderer$close() {
        this.throwIfClosed();
        this.throwIfPageOpened();
        this.doClose();
    }

    private final int $$robo$$android_graphics_pdf_PdfRenderer$getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_graphics_pdf_PdfRenderer$shouldScaleForPrinting() {
        this.throwIfClosed();
        Object object = sPdfiumLock;
        synchronized (object) {
            return PdfRenderer.nativeScaleForPrinting(this.mNativeDocument);
        }
    }

    private final Page $$robo$$android_graphics_pdf_PdfRenderer$openPage(int index) {
        this.throwIfClosed();
        this.throwIfPageOpened();
        this.throwIfPageNotInDocument(index);
        this.mCurrentPage = new Page(this, index, null);
        return this.mCurrentPage;
    }

    private final void $$robo$$android_graphics_pdf_PdfRenderer$finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            if (this.mInput != null) {
                this.doClose();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfRenderer$doClose() {
        if (this.mCurrentPage != null) {
            this.mCurrentPage.close();
        }
        Object object = sPdfiumLock;
        synchronized (object) {
            PdfRenderer.nativeClose(this.mNativeDocument);
        }
        try {
            this.mInput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mInput = null;
        this.mCloseGuard.close();
    }

    private final void $$robo$$android_graphics_pdf_PdfRenderer$throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfRenderer$throwIfPageOpened() {
        if (this.mCurrentPage != null) {
            throw new IllegalStateException("Current page not closed");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfRenderer$throwIfPageNotInDocument(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    private static final long $$robo$$android_graphics_pdf_PdfRenderer$nativeCreate(int n, long l) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_pdf_PdfRenderer$nativeClose(long l) {
    }

    private static final int $$robo$$android_graphics_pdf_PdfRenderer$nativeGetPageCount(long l) {
        return 0;
    }

    private static final boolean $$robo$$android_graphics_pdf_PdfRenderer$nativeScaleForPrinting(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_pdf_PdfRenderer$nativeRenderPage(long l, long l2, Bitmap bitmap, int n, int n2, int n3, int n4, long l3, int n5) {
    }

    private static final long $$robo$$android_graphics_pdf_PdfRenderer$nativeOpenPageAndGetSize(long l, int n, Point point) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_pdf_PdfRenderer$nativeClosePage(long l) {
    }

    static void __staticInitializer__() {
        sPdfiumLock = new Object();
    }

    private void __constructor__(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.$$robo$$android_graphics_pdf_PdfRenderer$__constructor__(parcelFileDescriptor);
    }

    public PdfRenderer(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfRenderer$__constructor__(android.os.ParcelFileDescriptor ), this, parcelFileDescriptor);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_pdf_PdfRenderer$close(), this);
    }

    public int getPageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPageCount", $$robo$$android_graphics_pdf_PdfRenderer$getPageCount(), this);
    }

    public boolean shouldScaleForPrinting() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldScaleForPrinting", $$robo$$android_graphics_pdf_PdfRenderer$shouldScaleForPrinting(), this);
    }

    public Page openPage(int n) {
        return InvokeDynamicSupport.bootstrap("openPage", $$robo$$android_graphics_pdf_PdfRenderer$openPage(int ), this, n);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_pdf_PdfRenderer$finalize(), this);
    }

    private void doClose() {
        InvokeDynamicSupport.bootstrap("doClose", $$robo$$android_graphics_pdf_PdfRenderer$doClose(), this);
    }

    private void throwIfClosed() {
        InvokeDynamicSupport.bootstrap("throwIfClosed", $$robo$$android_graphics_pdf_PdfRenderer$throwIfClosed(), this);
    }

    private void throwIfPageOpened() {
        InvokeDynamicSupport.bootstrap("throwIfPageOpened", $$robo$$android_graphics_pdf_PdfRenderer$throwIfPageOpened(), this);
    }

    private void throwIfPageNotInDocument(int n) {
        InvokeDynamicSupport.bootstrap("throwIfPageNotInDocument", $$robo$$android_graphics_pdf_PdfRenderer$throwIfPageNotInDocument(int ), this, n);
    }

    private static long nativeCreate(int n, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreate", $$robo$$android_graphics_pdf_PdfRenderer$nativeCreate(int long ), (int)n, (long)l);
    }

    private static void nativeClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClose", $$robo$$android_graphics_pdf_PdfRenderer$nativeClose(long ), (long)l);
    }

    private static int nativeGetPageCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetPageCount", $$robo$$android_graphics_pdf_PdfRenderer$nativeGetPageCount(long ), (long)l);
    }

    private static boolean nativeScaleForPrinting(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeScaleForPrinting", $$robo$$android_graphics_pdf_PdfRenderer$nativeScaleForPrinting(long ), (long)l);
    }

    private static void nativeRenderPage(long l, long l2, Bitmap bitmap, int n, int n2, int n3, int n4, long l3, int n5) {
        InvokeDynamicSupport.bootstrapStatic("nativeRenderPage", $$robo$$android_graphics_pdf_PdfRenderer$nativeRenderPage(long long android.graphics.Bitmap int int int int long int ), (long)l, (long)l2, (Bitmap)bitmap, (int)n, (int)n2, (int)n3, (int)n4, (long)l3, (int)n5);
    }

    private static long nativeOpenPageAndGetSize(long l, int n, Point point) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpenPageAndGetSize", $$robo$$android_graphics_pdf_PdfRenderer$nativeOpenPageAndGetSize(long int android.graphics.Point ), (long)l, (int)n, (Point)point);
    }

    private static void nativeClosePage(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClosePage", $$robo$$android_graphics_pdf_PdfRenderer$nativeClosePage(long ), (long)l);
    }

    static {
        RobolectricInternals.classInitializing(PdfRenderer.class);
    }

    public /* synthetic */ PdfRenderer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PdfRenderer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class Page
    implements AutoCloseable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CloseGuard mCloseGuard;
        public static int RENDER_MODE_FOR_DISPLAY = 1;
        public static int RENDER_MODE_FOR_PRINT = 2;
        private int mIndex;
        private int mWidth;
        private int mHeight;
        private long mNativePage;
        /* synthetic */ PdfRenderer this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void $$robo$$android_graphics_pdf_PdfRenderer_Page$__constructor__(PdfRenderer this$0, int index) {
            this.mCloseGuard = CloseGuard.get();
            Point size = this$0.mTempPoint;
            Object object = sPdfiumLock;
            synchronized (object) {
                this.mNativePage = PdfRenderer.nativeOpenPageAndGetSize(this$0.mNativeDocument, index, size);
            }
            this.mIndex = index;
            this.mWidth = size.x;
            this.mHeight = size.y;
            this.mCloseGuard.open("close");
        }

        private final int $$robo$$android_graphics_pdf_PdfRenderer_Page$getIndex() {
            return this.mIndex;
        }

        private final int $$robo$$android_graphics_pdf_PdfRenderer_Page$getWidth() {
            return this.mWidth;
        }

        private final int $$robo$$android_graphics_pdf_PdfRenderer_Page$getHeight() {
            return this.mHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_graphics_pdf_PdfRenderer_Page$render(Bitmap destination, Rect destClip, Matrix transform, int renderMode) {
            int contentBottom;
            if (this.mNativePage == 0L) {
                throw new NullPointerException();
            }
            if ((destination = Preconditions.checkNotNull(destination, "bitmap null")).getConfig() != Bitmap.Config.ARGB_8888) {
                throw new IllegalArgumentException("Unsupported pixel format");
            }
            if (destClip != null && (destClip.left < 0 || destClip.top < 0 || destClip.right > destination.getWidth() || destClip.bottom > destination.getHeight())) {
                throw new IllegalArgumentException("destBounds not in destination");
            }
            if (transform != null && !transform.isAffine()) {
                throw new IllegalArgumentException("transform not affine");
            }
            if (renderMode != 2 && renderMode != 1) {
                throw new IllegalArgumentException("Unsupported render mode");
            }
            if (renderMode == 2 && renderMode == 1) {
                throw new IllegalArgumentException("Only single render mode supported");
            }
            int contentLeft = destClip != null ? destClip.left : 0;
            int contentTop = destClip != null ? destClip.top : 0;
            int contentRight = destClip != null ? destClip.right : destination.getWidth();
            int n = contentBottom = destClip != null ? destClip.bottom : destination.getHeight();
            if (transform == null) {
                int clipWidth = contentRight - contentLeft;
                int clipHeight = contentBottom - contentTop;
                transform = new Matrix();
                transform.postScale((float)clipWidth / (float)this.getWidth(), (float)clipHeight / (float)this.getHeight());
                transform.postTranslate(contentLeft, contentTop);
            }
            long transformPtr = transform.native_instance;
            Object object = sPdfiumLock;
            synchronized (object) {
                PdfRenderer.nativeRenderPage(this.this$0.mNativeDocument, this.mNativePage, destination, contentLeft, contentTop, contentRight, contentBottom, transformPtr, renderMode);
            }
        }

        private final void $$robo$$android_graphics_pdf_PdfRenderer_Page$close() {
            this.throwIfClosed();
            this.doClose();
        }

        private final void $$robo$$android_graphics_pdf_PdfRenderer_Page$finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                if (this.mNativePage != 0L) {
                    this.doClose();
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_graphics_pdf_PdfRenderer_Page$doClose() {
            Object object = sPdfiumLock;
            synchronized (object) {
                PdfRenderer.nativeClosePage(this.mNativePage);
            }
            this.mNativePage = 0L;
            this.mCloseGuard.close();
            this.this$0.mCurrentPage = null;
        }

        private final void $$robo$$android_graphics_pdf_PdfRenderer_Page$throwIfClosed() {
            if (this.mNativePage == 0L) {
                throw new IllegalStateException("Already closed");
            }
        }

        private /* synthetic */ void $$robo$$android_graphics_pdf_PdfRenderer_Page$__constructor__(PdfRenderer x0, int x1, 1 x2) {
        }

        private void __constructor__(PdfRenderer pdfRenderer, int n) {
            this.$$robo$$android_graphics_pdf_PdfRenderer_Page$__constructor__(pdfRenderer, n);
        }

        public Page(PdfRenderer pdfRenderer, int n) {
            this.this$0 = pdfRenderer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfRenderer_Page$__constructor__(android.graphics.pdf.PdfRenderer int ), this, pdfRenderer, n);
        }

        public int getIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$android_graphics_pdf_PdfRenderer_Page$getIndex(), this);
        }

        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_graphics_pdf_PdfRenderer_Page$getWidth(), this);
        }

        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_graphics_pdf_PdfRenderer_Page$getHeight(), this);
        }

        public void render(Bitmap bitmap, Rect rect, Matrix matrix, int n) {
            InvokeDynamicSupport.bootstrap("render", $$robo$$android_graphics_pdf_PdfRenderer_Page$render(android.graphics.Bitmap android.graphics.Rect android.graphics.Matrix int ), this, bitmap, rect, matrix, n);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_pdf_PdfRenderer_Page$close(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_pdf_PdfRenderer_Page$finalize(), this);
        }

        private void doClose() {
            InvokeDynamicSupport.bootstrap("doClose", $$robo$$android_graphics_pdf_PdfRenderer_Page$doClose(), this);
        }

        private void throwIfClosed() {
            InvokeDynamicSupport.bootstrap("throwIfClosed", $$robo$$android_graphics_pdf_PdfRenderer_Page$throwIfClosed(), this);
        }

        private /* synthetic */ void __constructor__(PdfRenderer pdfRenderer, int n, 1 var3_3) {
            this.$$robo$$android_graphics_pdf_PdfRenderer_Page$__constructor__(pdfRenderer, n, var3_3);
        }

        public /* synthetic */ Page(PdfRenderer pdfRenderer, int n, 1 var3_3) {
            this(pdfRenderer, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfRenderer_Page$__constructor__(android.graphics.pdf.PdfRenderer int android.graphics.pdf.PdfRenderer$1 ), this, pdfRenderer, n, var3_3);
        }

        public /* synthetic */ Page() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Page)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L})
    public static @interface RenderMode {
    }
}

