/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleDrawable;
import android.view.DisplayListCanvas;
import android.view.RenderNodeAnimator;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class RippleComponent
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private RippleDrawable mOwner;
    protected Rect mBounds;
    private boolean mHasDisplayListCanvas;
    private boolean mHasPendingHardwareAnimator;
    private RenderNodeAnimatorSet mHardwareAnimator;
    private Animator mSoftwareAnimator;
    private boolean mHasMaxRadius;
    protected float mTargetRadius;
    protected float mDensityScale;
    private boolean mForceSoftware;

    private void $$robo$$android_graphics_drawable_RippleComponent$__constructor__(RippleDrawable owner, Rect bounds, boolean forceSoftware) {
        this.mOwner = owner;
        this.mBounds = bounds;
        this.mForceSoftware = forceSoftware;
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$onBoundsChange() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$setup(float maxRadius, int densityDpi) {
        if (maxRadius >= 0.0f) {
            this.mHasMaxRadius = true;
            this.mTargetRadius = maxRadius;
        } else {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
        }
        this.mDensityScale = (float)densityDpi * 0.00625f;
        this.onTargetRadiusChanged(this.mTargetRadius);
    }

    private static final float $$robo$$android_graphics_drawable_RippleComponent$getTargetRadius(Rect bounds) {
        float halfWidth = (float)bounds.width() / 2.0f;
        float halfHeight = (float)bounds.height() / 2.0f;
        return (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$enter(boolean fast) {
        this.cancel();
        this.mSoftwareAnimator = this.createSoftwareEnter(fast);
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.start();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$exit() {
        this.cancel();
        if (this.mHasDisplayListCanvas) {
            this.mHasPendingHardwareAnimator = true;
            this.invalidateSelf();
        } else {
            this.mSoftwareAnimator = this.createSoftwareExit();
            this.mSoftwareAnimator.start();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$cancel() {
        this.cancelSoftwareAnimations();
        this.endHardwareAnimations();
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$end() {
        this.endSoftwareAnimations();
        this.endHardwareAnimations();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleComponent$draw(Canvas c, Paint p) {
        boolean hasDisplayListCanvas;
        boolean bl = hasDisplayListCanvas = !this.mForceSoftware && c.isHardwareAccelerated() && c instanceof DisplayListCanvas;
        if (this.mHasDisplayListCanvas != hasDisplayListCanvas) {
            this.mHasDisplayListCanvas = hasDisplayListCanvas;
            if (!hasDisplayListCanvas) {
                this.endHardwareAnimations();
            }
        }
        if (hasDisplayListCanvas) {
            DisplayListCanvas hw = (DisplayListCanvas)c;
            this.startPendingAnimation(hw, p);
            if (this.mHardwareAnimator != null) {
                return this.drawHardware(hw);
            }
        }
        return this.drawSoftware(c, p);
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$getBounds(Rect bounds) {
        int r = (int)Math.ceil(this.mTargetRadius);
        bounds.set(-r, -r, r, r);
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$startPendingAnimation(DisplayListCanvas hw, Paint p) {
        if (this.mHasPendingHardwareAnimator) {
            this.mHasPendingHardwareAnimator = false;
            this.mHardwareAnimator = this.createHardwareExit(new Paint(p));
            this.mHardwareAnimator.start(hw);
            this.jumpValuesToExit();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$cancelSoftwareAnimations() {
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.cancel();
            this.mSoftwareAnimator = null;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$endSoftwareAnimations() {
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.end();
            this.mSoftwareAnimator = null;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$endHardwareAnimations() {
        if (this.mHardwareAnimator != null) {
            this.mHardwareAnimator.end();
            this.mHardwareAnimator = null;
        }
        if (this.mHasPendingHardwareAnimator) {
            this.mHasPendingHardwareAnimator = false;
            this.jumpValuesToExit();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$invalidateSelf() {
        this.mOwner.invalidateSelf(false);
    }

    private final boolean $$robo$$android_graphics_drawable_RippleComponent$isHardwareAnimating() {
        return this.mHardwareAnimator != null && this.mHardwareAnimator.isRunning() || this.mHasPendingHardwareAnimator;
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            float targetRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
            this.onTargetRadiusChanged(targetRadius);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleComponent$onTargetRadiusChanged(float targetRadius) {
    }

    protected abstract Animator createSoftwareEnter(boolean var1);

    protected abstract Animator createSoftwareExit();

    protected abstract RenderNodeAnimatorSet createHardwareExit(Paint var1);

    protected abstract boolean drawHardware(DisplayListCanvas var1);

    protected abstract boolean drawSoftware(Canvas var1, Paint var2);

    protected abstract void jumpValuesToExit();

    private void __constructor__(RippleDrawable rippleDrawable, Rect rect, boolean bl) {
        this.$$robo$$android_graphics_drawable_RippleComponent$__constructor__(rippleDrawable, rect, bl);
    }

    public RippleComponent(RippleDrawable rippleDrawable, Rect rect, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleComponent$__constructor__(android.graphics.drawable.RippleDrawable android.graphics.Rect boolean ), this, rippleDrawable, rect, bl);
    }

    public void onBoundsChange() {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_RippleComponent$onBoundsChange(), this);
    }

    public void setup(float f, int n) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_graphics_drawable_RippleComponent$setup(float int ), this, f, n);
    }

    private static float getTargetRadius(Rect rect) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getTargetRadius", $$robo$$android_graphics_drawable_RippleComponent$getTargetRadius(android.graphics.Rect ), (Rect)rect);
    }

    public void enter(boolean bl) {
        InvokeDynamicSupport.bootstrap("enter", $$robo$$android_graphics_drawable_RippleComponent$enter(boolean ), this, bl);
    }

    public void exit() {
        InvokeDynamicSupport.bootstrap("exit", $$robo$$android_graphics_drawable_RippleComponent$exit(), this);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_graphics_drawable_RippleComponent$cancel(), this);
    }

    public void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_graphics_drawable_RippleComponent$end(), this);
    }

    public boolean draw(Canvas canvas, Paint paint) {
        return (boolean)InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_RippleComponent$draw(android.graphics.Canvas android.graphics.Paint ), this, canvas, paint);
    }

    public void getBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_graphics_drawable_RippleComponent$getBounds(android.graphics.Rect ), this, rect);
    }

    private void startPendingAnimation(DisplayListCanvas displayListCanvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("startPendingAnimation", $$robo$$android_graphics_drawable_RippleComponent$startPendingAnimation(android.view.DisplayListCanvas android.graphics.Paint ), this, displayListCanvas, paint);
    }

    private void cancelSoftwareAnimations() {
        InvokeDynamicSupport.bootstrap("cancelSoftwareAnimations", $$robo$$android_graphics_drawable_RippleComponent$cancelSoftwareAnimations(), this);
    }

    private void endSoftwareAnimations() {
        InvokeDynamicSupport.bootstrap("endSoftwareAnimations", $$robo$$android_graphics_drawable_RippleComponent$endSoftwareAnimations(), this);
    }

    private void endHardwareAnimations() {
        InvokeDynamicSupport.bootstrap("endHardwareAnimations", $$robo$$android_graphics_drawable_RippleComponent$endHardwareAnimations(), this);
    }

    protected void invalidateSelf() {
        InvokeDynamicSupport.bootstrap("invalidateSelf", $$robo$$android_graphics_drawable_RippleComponent$invalidateSelf(), this);
    }

    protected boolean isHardwareAnimating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareAnimating", $$robo$$android_graphics_drawable_RippleComponent$isHardwareAnimating(), this);
    }

    protected void onHotspotBoundsChanged() {
        InvokeDynamicSupport.bootstrap("onHotspotBoundsChanged", $$robo$$android_graphics_drawable_RippleComponent$onHotspotBoundsChanged(), this);
    }

    protected void onTargetRadiusChanged(float f) {
        InvokeDynamicSupport.bootstrap("onTargetRadiusChanged", $$robo$$android_graphics_drawable_RippleComponent$onTargetRadiusChanged(float ), this, f);
    }

    public /* synthetic */ RippleComponent() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleComponent)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class RenderNodeAnimatorSet
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ArrayList<RenderNodeAnimator> mAnimators;

        private void $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$__constructor__() {
            this.mAnimators = new ArrayList();
        }

        private final void $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$add(RenderNodeAnimator anim2) {
            this.mAnimators.add(anim2);
        }

        private final void $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$clear() {
            this.mAnimators.clear();
        }

        private final void $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$start(DisplayListCanvas target) {
            if (target == null) {
                throw new IllegalArgumentException("Hardware canvas must be non-null");
            }
            ArrayList<RenderNodeAnimator> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                RenderNodeAnimator anim2 = animators.get(i);
                anim2.setTarget(target);
                anim2.start();
            }
        }

        private final void $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$cancel() {
            ArrayList<RenderNodeAnimator> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                RenderNodeAnimator anim2 = animators.get(i);
                anim2.cancel();
            }
        }

        private final void $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$end() {
            ArrayList<RenderNodeAnimator> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                RenderNodeAnimator anim2 = animators.get(i);
                anim2.end();
            }
        }

        private final boolean $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$isRunning() {
            ArrayList<RenderNodeAnimator> animators = this.mAnimators;
            int N = animators.size();
            for (int i = 0; i < N; ++i) {
                RenderNodeAnimator anim2 = animators.get(i);
                if (!anim2.isRunning()) continue;
                return true;
            }
            return false;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$__constructor__();
        }

        public RenderNodeAnimatorSet() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$__constructor__(), this);
        }

        public void add(RenderNodeAnimator renderNodeAnimator) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$add(android.view.RenderNodeAnimator ), this, renderNodeAnimator);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$clear(), this);
        }

        public void start(DisplayListCanvas displayListCanvas) {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$start(android.view.DisplayListCanvas ), this, displayListCanvas);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$cancel(), this);
        }

        public void end() {
            InvokeDynamicSupport.bootstrap("end", $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$end(), this);
        }

        public boolean isRunning() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_RippleComponent_RenderNodeAnimatorSet$isRunning(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RenderNodeAnimatorSet)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

